import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:google_fonts/google_fonts.dart';

class MyText extends StatelessWidget {
  final String text;
  final double? fontsizeNormal, fontsizeWeb;
  final dynamic maxline, fontstyle, fontwaight, textalign;
  final Color? color, decorationColor;
  final dynamic overflow, multilanguage;
  final TextDecoration? decoration;
  final TextDecorationStyle? decorationStyle;
  final TextDirection? textDirection;

  const MyText({
    super.key,
    this.color,
    required this.text,
    this.fontsizeNormal,
    this.maxline,
    this.overflow,
    this.decoration,
    this.decorationStyle,
    this.decorationColor,
    this.fontsizeWeb,
    this.textDirection,
    this.textalign,
    this.fontwaight,
    this.fontstyle,
    this.multilanguage,
  });

  @override
  Widget build(BuildContext context) {
    if (multilanguage == true) {
      return LocaleText(
        text,
        textAlign: textalign,
        overflow: overflow,
        maxLines: maxline,
        style: kIsWeb
            ? TextStyle(
                fontSize: fontsizeNormal,
                fontStyle: fontstyle,
                decoration: decoration,
                decorationStyle: decorationStyle,
                decorationColor: decorationColor,
                color: color ?? Theme.of(context).colorScheme.surface,
                fontWeight: fontwaight)
            : GoogleFonts.lato(
                fontSize: fontsizeNormal,
                fontStyle: fontstyle,
                decoration: decoration,
                decorationStyle: decorationStyle,
                decorationColor: decorationColor,
                color: color ?? Theme.of(context).colorScheme.surface,
                fontWeight: fontwaight),
      );
    } else {
      return Text(
        text,
        textAlign: textalign,
        overflow: overflow,
        maxLines: maxline,
        style: kIsWeb
            ? TextStyle(
                fontSize: fontsizeNormal,
                fontStyle: fontstyle,
                decoration: decoration,
                decorationStyle: decorationStyle,
                decorationColor: decorationColor,
                color: color ?? Theme.of(context).colorScheme.surface,
                fontWeight: fontwaight)
            : GoogleFonts.lato(
                fontSize: fontsizeNormal,
                fontStyle: fontstyle,
                decoration: decoration,
                decorationStyle: decorationStyle,
                decorationColor: decorationColor,
                color: color ?? Theme.of(context).colorScheme.surface,
                fontWeight: fontwaight),
      );
    }
  }
}
