import 'package:prakah/utils/color.dart';
import 'package:flutter/material.dart';
import 'package:flutter_pannable_rating_bar/flutter_pannable_rating_bar.dart';

class MyRating extends StatelessWidget {
  final double rating, size, spacing;
  const MyRating(
      {super.key,
      required this.rating,
      required this.spacing,
      required this.size});

  @override
  Widget build(BuildContext context) {
    double ratingStar = rating;
    return PannableRatingBar(
      rate: ratingStar,
      items: List.generate(
          5,
          (index) => RatingWidget(
                selectedColor: colorAccent,
                unSelectedColor: gray,
                child: Icon(
                  Icons.star,
                  size: size,
                ),
              )),
      onHover: (value) {
        // the rating value is updated every time the cursor moves over a new item.
        ratingStar = value;
      },
    );
  }
}
