import 'package:cached_network_image/cached_network_image.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:flutter/material.dart';

class MyNetworkImage extends StatelessWidget {
  final String imageUrl;
  final double? imgHeight, imgWidth, radius;
  final dynamic fit;
  final bool? islandscap;
  final Color? color;

  const MyNetworkImage(
      {super.key,
      required this.imageUrl,
      required this.fit,
      this.color,
      this.radius,
      this.imgHeight,
      this.islandscap,
      this.imgWidth});

  @override
  Widget build(BuildContext context) {
    return ClipRRect(
      borderRadius: BorderRadius.circular(radius ?? 0),
      child: CachedNetworkImage(
        imageUrl: imageUrl,
        height: imgHeight,
        width: imgWidth,
        fit: fit,
        color: color,
        imageBuilder: (context, imageProvider) => Container(
          decoration: BoxDecoration(
            image: DecorationImage(
              image: imageProvider,
              colorFilter: color != null
                  ? ColorFilter.mode(color!, BlendMode.srcATop)
                  : null,
              fit: fit,
            ),
          ),
        ),
        placeholder: (context, url) {
          return MyImage(
            radius: radius ?? 0,
            width: imgWidth ?? 0.0,
            height: imgHeight ?? 0.0,
            imagePath: islandscap == false || islandscap == null
                ? "no_image_port.png"
                : "no_image_land.png",
            fit: BoxFit.cover,
          );
        },
        errorWidget: (context, url, error) {
          return MyImage(
            radius: radius ?? 0,
            width: imgWidth ?? 0.0,
            height: imgHeight ?? 0.0,
            imagePath: islandscap == false || islandscap == null
                ? "no_image_port.png"
                : "no_image_land.png",
            fit: BoxFit.cover,
          );
        },
      ),
    );
  }
}
