import 'package:flutter/material.dart';

class MyImage extends StatelessWidget {
  final double height;
  final double width;
  final String imagePath;
  final Color? color;
  final double? radius;
  final dynamic fit;
  final bool? isAppicon;
  
  const MyImage(
      {super.key,
      required this.width,
      required this.height,
      required this.imagePath,
      this.isAppicon,
      this.color,
      this.radius,
      this.fit});

  @override
  Widget build(BuildContext context) {
    return ClipRRect(
      borderRadius: BorderRadius.circular(radius ?? 0),
      child: isAppicon == true
          ? Image.asset(
              "assets/appicon/$imagePath",
              height: height,
              color: color,
              width: width,
              fit: fit,
              errorBuilder: (context, url, error) {
                return Image.asset(
                  "assets/images/no_image_land.png",
                  width: width,
                  height: height,
                  fit: BoxFit.cover,
                );
              },
            )
          : Image.asset(
              "assets/images/$imagePath",
              height: height,
              color: color,
              width: width,
              fit: fit,
              errorBuilder: (context, url, error) {
                return Image.asset(
                  "assets/images/no_image_land.png",
                  width: width,
                  height: height,
                  fit: BoxFit.cover,
                );
              },
            ),
    );
  }
}
