import 'dart:io';
import 'package:prakah/utils/color.dart';
import 'package:flutter/material.dart';

class MyFileImage extends StatelessWidget {
  final double? height;
  final double? width;
  final String? imagePath;
  final Color? color;
  final dynamic fit;
  final bool? withShaderMask;

  const MyFileImage({
    super.key,
    this.width,
    this.height,
    required this.imagePath,
    this.color,
    this.fit,
    this.withShaderMask,
  });

  @override
  Widget build(BuildContext context) {
    if (withShaderMask != null && withShaderMask == true) {
      return ShaderMask(
        blendMode: BlendMode.srcIn,
        shaderCallback: (bounds) {
          return const LinearGradient(
            begin: Alignment.topCenter,
            end: Alignment.bottomCenter,
            colors: [colorPrimaryDark, colorPrimary],
          ).createShader(
            Rect.fromLTWH(0, 0, bounds.width, bounds.height),
          );
        },
        child: Image.file(
          File(imagePath ?? ""),
          height: height,
          color: color,
          width: width,
          fit: fit,
          errorBuilder: (context, url, error) {
            return Image.asset(
              "assets/images/no_image_port.png",
              width: width,
              height: height,
              fit: BoxFit.cover,
            );
          },
        ),
      );
    } else {
      return Image.file(
        File(imagePath ?? ""),
        height: height,
        color: color,
        width: width,
        fit: fit,
        errorBuilder: (context, url, error) {
          return Image.asset(
            "assets/images/no_image_port.png",
            width: width,
            height: height,
            fit: BoxFit.cover,
          );
        },
      );
    }
  }
}
