import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/provider/profileprovider.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webaddtocart.dart';
import 'package:prakah/webpages/webbecometutor.dart';
import 'package:prakah/webpages/webhome.dart';
import 'package:prakah/webpages/webliveclass.dart';
import 'package:prakah/webpages/weblogin.dart';
import 'package:prakah/webpages/webprofile.dart';
import 'package:prakah/webpages/webregister.dart';
import 'package:prakah/webwidget/interactivecontainer.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:provider/provider.dart';

class WebAppbar extends StatefulWidget {
  final TextEditingController? controller;
  const WebAppbar({super.key, this.controller});

  @override
  State<WebAppbar> createState() => _WebAppbarState();
}

class _WebAppbarState extends State<WebAppbar> {
  ProfileProvider profileProvider = ProfileProvider();
  GeneralProvider generalProvider = GeneralProvider();
  SearchProvider searchProvider = SearchProvider();
  TextEditingController controller = TextEditingController();

  @override
  void initState() {
    super.initState();
    profileProvider = Provider.of<ProfileProvider>(context, listen: false);
    generalProvider = Provider.of<GeneralProvider>(context, listen: false);
    searchProvider = Provider.of<SearchProvider>(context, listen: false);

    controller = widget.controller ?? TextEditingController();
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<GeneralProvider>(
        builder: (context, generalprovider, child) {
      return Container(
        width: MediaQuery.of(context).size.width,
        height: MediaQuery.of(context).size.height,
        alignment: Alignment.centerLeft,
        padding: MediaQuery.of(context).size.width > 1000
            ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
            : const EdgeInsets.fromLTRB(20, 0, 20, 0),
        // color: white,
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            /* AppIcon With AppName */
            InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              highlightColor: transparent,
              onTap: () {
                searchProvider.setSearch("0");
                Utils.navigatePage(context, const WebHome(), '');
              },
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  MyImage(
                    width: 40,
                    height: 40,
                    radius: 8,
                    imagePath: 'appiconweb.png',
                    isAppicon: true,
                    fit: BoxFit.cover,
                  ),
                  const SizedBox(width: 10),
                  MediaQuery.of(context).size.width > 1200
                      ? buildTab(
                          name: "home",
                          count: "1",
                          onTap: () {
                            generalprovider.setHomeTab("1");
                            searchProvider.setSearch("0");
                            Utils.navigatePage(context, const WebHome(), '');
                          })
                      : buildIconTab(
                          icon: Icons.home,
                          count: "1",
                          onTap: () {
                            generalprovider.setHomeTab("1");
                            searchProvider.setSearch("0");
                            Utils.navigatePage(context, const WebHome(), '');
                          }),
                  profileProvider.profileModel.status == 200
                      ? (profileProvider.profileModel.result?[0].tutorStatus ??
                                  "") !=
                              "approved"
                          ? MediaQuery.of(context).size.width > 1200
                              ? buildTab(
                                  name: "become_tutor",
                                  count: "2",
                                  onTap: () {
                                    generalprovider.setHomeTab("2");
                                    searchProvider.setSearch("0");
                                    if (Utils.checkLoginUser(context)) {
                                      final resultList =
                                          profileProvider.profileModel.result ??
                                              [];
                                      String tutorStatus = resultList.isNotEmpty
                                          ? resultList[0].tutorStatus ?? "0"
                                          : "0";
                                      Utils.navigatePage(
                                          context,
                                          WebBecomeTutor(
                                            tutorStatus: tutorStatus,
                                          ),
                                          '');
                                    }
                                  },
                                )
                              : buildIconTab(
                                  icon: Icons.school,
                                  count: "2",
                                  onTap: () {
                                    generalprovider.setHomeTab("2");
                                    searchProvider.setSearch("0");
                                    if (Utils.checkLoginUser(context)) {
                                      final resultList =
                                          profileProvider.profileModel.result ??
                                              [];
                                      String tutorStatus = resultList.isNotEmpty
                                          ? resultList[0].tutorStatus ?? "0"
                                          : "0";

                                      Utils.navigatePage(
                                          context,
                                          WebBecomeTutor(
                                            tutorStatus: tutorStatus,
                                          ),
                                          '');
                                    }
                                  },
                                )
                          : const SizedBox.shrink()
                      : const SizedBox.shrink(),
                  MediaQuery.of(context).size.width > 1200
                      ? buildTab(
                          name: "my_cart",
                          count: "3",
                          onTap: () {
                            generalprovider.setHomeTab("3");
                            searchProvider.setSearch("0");
                            if (Utils.checkLoginUser(context)) {
                              Utils.navigatePage(context, WebAddToCart(), '');
                            }
                          })
                      : buildIconTab(
                          onTap: () {
                            generalprovider.setHomeTab("3");
                            searchProvider.setSearch("0");
                            if (Utils.checkLoginUser(context)) {
                              Utils.navigatePage(context, WebAddToCart(), '');
                            }
                          },
                          count: "3",
                          icon: Icons.shopping_cart),
                  MediaQuery.of(context).size.width > 1200
                      ? buildTab(
                          count: "4",
                          name: "live_class",
                          onTap: () {
                            generalprovider.setHomeTab("4");
                            searchProvider.setSearch("0");
                            Utils.navigatePage(context, WebLiveClass(), '');
                          })
                      : buildIconTab(
                          onTap: () {
                            generalprovider.setHomeTab("4");
                            searchProvider.setSearch("0");
                            Utils.navigatePage(context, WebLiveClass(), '');
                          },
                          count: "4",
                          icon: Icons.live_tv_rounded),
                ],
              ),
            ),
            SizedBox(width: 30),
            /* Search Fields */
            Consumer<SearchProvider>(builder: (context, searchProvider, child) {
              return Flexible(
                fit: FlexFit.loose,
                child: TextFormField(
                  cursorColor: black,
                  controller: controller,
                  style: TextStyle(
                      fontSize: Dimens.textSmall,
                      fontStyle: FontStyle.normal,
                      color: black,
                      fontWeight: FontWeight.w300),
                  decoration: InputDecoration(
                    filled: true,
                    fillColor: white.withValues(alpha: 0.8),
                    suffixIcon: ((widget.controller?.text.length ?? 0) >= 3)
                        ? InkWell(
                            onTap: () {
                              controller.clear();
                              searchProvider.selectLayout(Constant.courseType);
                              searchProvider.searchList?.clear();
                              searchProvider.setSearch("0");
                            },
                            child: Icon(Icons.close, color: gray, size: 20))
                        : Icon(Icons.search_sharp, color: gray, size: 20),
                    contentPadding: const EdgeInsets.fromLTRB(15, 15, 15, 15),
                    focusedBorder: OutlineInputBorder(
                      borderRadius: const BorderRadius.all(Radius.circular(4)),
                      borderSide: BorderSide.none,
                    ),
                    disabledBorder: OutlineInputBorder(
                      borderRadius: const BorderRadius.all(Radius.circular(4)),
                      borderSide: BorderSide.none,
                    ),
                    enabledBorder: OutlineInputBorder(
                      borderRadius: const BorderRadius.all(Radius.circular(4)),
                      borderSide: BorderSide.none,
                    ),
                    border: OutlineInputBorder(
                      borderRadius: const BorderRadius.all(Radius.circular(4)),
                      borderSide: BorderSide.none,
                    ),
                    hintText: Locales.string(context, "searchbarhint"),
                    hintStyle: TextStyle(
                        fontSize: Dimens.textSmall,
                        fontStyle: FontStyle.normal,
                        color: black,
                        fontWeight: FontWeight.w300),
                  ),
                  onChanged: (value) async {
                    if (value.length >= 3) {
                      searchProvider.clearWishList();
                      searchProvider.searchList?.clear();
                      searchProvider.setSearch("1");

                      String type;
                      if (searchProvider.layoutType == Constant.courseType) {
                        type = "3";
                      } else if (searchProvider.layoutType ==
                          Constant.bookType) {
                        type = "2";
                      } else {
                        type = "1";
                      }

                      await searchProvider.getSearch(
                          controller.text.toString(), type, 0);
                    } else {
                      searchProvider.searchList?.clear();
                      searchProvider.setSearch("0");
                    }
                  },
                ),
              );
            }),
            /* Tab With Login Button */
            const SizedBox(width: 15),
            Row(
              mainAxisAlignment: MainAxisAlignment.end,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                Constant.userID == null
                    ? SizedBox.shrink()
                    : buildIconTab(
                        onTap: () async {
                          if (Utils.checkLoginUser(context)) {
                            if (generalprovider.isNotification == false) {
                              generalprovider
                                  .getNotificationSectionShowHide(true);
                            } else {
                              generalprovider
                                  .getNotificationSectionShowHide(false);
                            }
                          }
                        },
                        icon: Icons.notifications_none_outlined),

                // _buildThem(),
                buildIconTab(
                    onTap: () {
                      Utils.languageChangeDialogWeb(context);
                    },
                    icon: Icons.translate_outlined),
                /* Login Logout Text */
                Consumer<ProfileProvider>(
                    builder: (context, profileprovider, child) {
                  return Constant.userID == null
                      ? MediaQuery.of(context).size.width > 1200
                          ? InkWell(
                              hoverColor: transparent,
                              splashColor: transparent,
                              focusColor: transparent,
                              highlightColor: transparent,
                              onTap: () async {
                                Utils.navigatePage(context, WebLogin(), "2");
                              },
                              child: AnimatedScale(
                                scale: 1,
                                duration: const Duration(milliseconds: 150),
                                curve: Curves.easeInOut,
                                child: Container(
                                  height: 32,
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 16, vertical: 6),
                                  decoration: BoxDecoration(
                                      color: transparent,
                                      borderRadius: BorderRadius.circular(12),
                                      border: Border.all(
                                          width: 1,
                                          color: white.withValues(alpha: 0.6),
                                          style: BorderStyle.solid)),
                                  child: MyText(
                                      color: white,
                                      multilanguage: true,
                                      text: "log_in",
                                      textalign: TextAlign.left,
                                      fontsizeNormal: Dimens.textMedium,
                                      fontsizeWeb: Dimens.textSmall,
                                      maxline: 1,
                                      fontwaight: FontWeight.w500,
                                      overflow: TextOverflow.ellipsis,
                                      fontstyle: FontStyle.normal),
                                ),
                              ),
                            )
                          : buildIconTab(
                              onTap: () {
                                Utils.navigatePage(context, WebLogin(), "2");
                              },
                              icon: Icons.login)
                      : InkWell(
                          hoverColor: transparent,
                          highlightColor: transparent,
                          onTap: () async {
                            generalprovider.setHomeTab("0");
                            Utils.navigatePage(context, WebProfile(), "2");

                            // if (generalprovider.isProfile == false) {
                            //   await generalprovider
                            //       .getOpenProfileSection(true);
                            //   if (!context.mounted) return;
                            //   await profileProvider.getprofile(context);
                            // } else {
                            //   await generalprovider
                            //       .getOpenProfileSection(false);
                            // }
                          },
                          child: MyNetworkImage(
                            imgWidth: 30,
                            radius: 50,
                            imgHeight: 30,
                            imageUrl: Constant.userImage ?? "",
                            fit: BoxFit.cover,
                          ),
                        );
                }),
                SizedBox(width: 10),
                /* Sign up Text */
                MediaQuery.of(context).size.width > 1200
                    ? InteractiveContainer(child: (isHovered) {
                        return InkWell(
                          hoverColor: transparent,
                          splashColor: transparent,
                          focusColor: transparent,
                          highlightColor: transparent,
                          onTap: () {
                            Utils.navigatePage(context, WebRegister(), "2");
                          },
                          borderRadius: BorderRadius.circular(5),
                          child: Consumer<ProfileProvider>(
                              builder: (context, profileprovider, child) {
                            return Constant.userID == null
                                ? AnimatedScale(
                                    scale: isHovered ? 1.05 : 1,
                                    duration: const Duration(milliseconds: 150),
                                    curve: Curves.easeInOut,
                                    child: Container(
                                      height: 32,
                                      padding: EdgeInsets.symmetric(
                                          horizontal: 16, vertical: 6),
                                      decoration: BoxDecoration(
                                          color: colorAccent,
                                          borderRadius:
                                              BorderRadius.circular(12),
                                          border: Border.all(
                                              width: 1,
                                              color: colorAccent,
                                              style: BorderStyle.solid)),
                                      child: Row(
                                        spacing: 4,
                                        children: [
                                          Icon(
                                            Icons.timelapse_outlined,
                                            size: 18,
                                            color: white,
                                          ),
                                          MyText(
                                              color: white,
                                              multilanguage: true,
                                              text: "signup",
                                              textalign: TextAlign.left,
                                              fontsizeNormal: Dimens.textMedium,
                                              fontsizeWeb: Dimens.textSmall,
                                              maxline: 1,
                                              fontwaight: FontWeight.w500,
                                              overflow: TextOverflow.ellipsis,
                                              fontstyle: FontStyle.normal),
                                        ],
                                      ),
                                    ),
                                  )
                                : SizedBox.shrink();
                          }),
                        );
                      })
                    : SizedBox.shrink(),
              ],
            ),
          ],
        ),
      );
    });
  }

/* END */

  Widget buildTab({String? name, onTap, count}) {
    return InkWell(
      hoverColor: transparent,
      splashColor: transparent,
      focusColor: transparent,
      highlightColor: transparent,
      onTap: onTap,
      child: Container(
        decoration: BoxDecoration(
            border: Border(
                bottom: BorderSide(
                    width: 1,
                    color: generalProvider.isTab == count
                        ? colorAccent
                        : transparent,
                    style: BorderStyle.solid))),
        padding: MediaQuery.of(context).size.width > 800
            ? const EdgeInsets.fromLTRB(10, 12, 10, 12)
            : const EdgeInsets.fromLTRB(5, 8, 5, 8),
        margin: const EdgeInsets.only(right: 6),
        child: AnimatedScale(
          scale: 1,
          duration: const Duration(milliseconds: 100),
          curve: Curves.easeInOut,
          child: MyText(
              color: white,
              multilanguage: true,
              text: name ?? "",
              textalign: TextAlign.left,
              fontsizeNormal: Dimens.textMedium,
              fontsizeWeb: Dimens.textMedium,
              maxline: 1,
              fontwaight: FontWeight.w500,
              overflow: TextOverflow.ellipsis,
              fontstyle: FontStyle.normal),
        ),
      ),
    );
  }

  Widget buildIconTab({IconData? icon, onTap, count}) {
    return InkWell(
      hoverColor: transparent,
      splashColor: transparent,
      focusColor: transparent,
      highlightColor: transparent,
      onTap: onTap,
      borderRadius: BorderRadius.circular(5),
      child: Container(
        decoration: BoxDecoration(
            border: Border(
                bottom: BorderSide(
                    width: 1,
                    color: generalProvider.isTab == count
                        ? colorAccent
                        : transparent,
                    style: BorderStyle.solid))),
        padding: MediaQuery.of(context).size.width > 800
            ? const EdgeInsets.fromLTRB(8, 12, 8, 12)
            : const EdgeInsets.fromLTRB(5, 8, 5, 8),
        margin: const EdgeInsets.only(right: 4),
        child: AnimatedScale(
            scale: 1,
            duration: const Duration(milliseconds: 100),
            curve: Curves.easeInOut,
            child: Icon(icon, color: white)),
      ),
    );
  }
}
