import 'package:prakah/provider/generalprovider.dart';
import 'package:flutter/material.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/services.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:provider/provider.dart';

class ForgotPassword extends StatefulWidget {
  const ForgotPassword({super.key});

  @override
  State<ForgotPassword> createState() => _ForgotPasswordState();
}

class _ForgotPasswordState extends State<ForgotPassword> {
  GeneralProvider generalProvider = GeneralProvider();
  final forgotPasswordController = TextEditingController();

  bool obscureTextPassword = true;
  @override
  initState() {
    super.initState();
    generalProvider = Provider.of<GeneralProvider>(context, listen: false);
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: colorPrimaryDark,
        surfaceTintColor: transparent,
        systemOverlayStyle: SystemUiOverlayStyle(
            statusBarColor: transparent, systemNavigationBarColor: transparent),
        leading: Utils.backButton(context),
      ),
      body:
          Consumer<GeneralProvider>(builder: (context, profileprovider, child) {
        return Center(
          child: SingleChildScrollView(
            padding: EdgeInsets.fromLTRB(20, 10, 20, 10),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                MyImage(
                  width: 90,
                  fit: BoxFit.contain,
                  height: 90,
                  imagePath: "ic_forgotpassword.png",
                  color: Theme.of(context).colorScheme.surface,
                ),
                const SizedBox(height: 20),
                MyText(
                  color: Theme.of(context).colorScheme.surface,
                  text: "passwordreset",
                  maxline: 1,
                  fontwaight: FontWeight.w500,
                  fontsizeNormal: Dimens.textlargeBig,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.center,
                  fontstyle: FontStyle.normal,
                  multilanguage: true,
                ),
                const SizedBox(height: 20),
                MyText(
                  color: Theme.of(context).colorScheme.surface,
                  text: "passwordresetdisc",
                  maxline: 3,
                  fontwaight: FontWeight.w400,
                  fontsizeNormal: Dimens.textMedium,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.center,
                  fontstyle: FontStyle.normal,
                  multilanguage: true,
                ),
                const SizedBox(height: 25),
                /* Password */
                TextFormField(
                  keyboardType: TextInputType.emailAddress,
                  controller: forgotPasswordController,
                  textInputAction: TextInputAction.done,
                  cursorColor: Theme.of(context).colorScheme.surface,
                  style: TextStyle(
                      fontSize: Dimens.textMedium,
                      fontStyle: FontStyle.normal,
                      color: Theme.of(context).colorScheme.surface,
                      fontWeight: FontWeight.w500),
                  decoration: InputDecoration(
                    prefixIcon: Icon(
                      Icons.email,
                      size: 20,
                      color: black,
                    ),
                    focusedBorder: OutlineInputBorder(
                      borderRadius: const BorderRadius.all(Radius.circular(7)),
                      borderSide: BorderSide(
                          width: 1, color: gray.withValues(alpha: 0.50)),
                    ),
                    disabledBorder: OutlineInputBorder(
                      borderRadius: const BorderRadius.all(Radius.circular(7)),
                      borderSide: BorderSide(
                          width: 1, color: gray.withValues(alpha: 0.50)),
                    ),
                    enabledBorder: OutlineInputBorder(
                      borderRadius: const BorderRadius.all(Radius.circular(7)),
                      borderSide: BorderSide(
                          width: 1, color: gray.withValues(alpha: 0.50)),
                    ),
                    border: OutlineInputBorder(
                      borderRadius: const BorderRadius.all(Radius.circular(7)),
                      borderSide: BorderSide(
                          width: 1, color: gray.withValues(alpha: 0.50)),
                    ),
                    labelText: Locales.string(context, "email"),
                    labelStyle: GoogleFonts.inter(
                        fontSize: Dimens.textSmall,
                        fontStyle: FontStyle.normal,
                        color: Theme.of(context).colorScheme.surface,
                        fontWeight: FontWeight.w400),
                  ),
                ),
                const SizedBox(height: 25),
                /* Logout Button */
                InkWell(
                  onTap: () async {
                    if (forgotPasswordController.text.isEmpty) {
                      Utils.showSnackbar(
                          context, "fail", "pleaseenteryourpassword", true);
                    } else {
                      profileprovider.setLoading(true);

                      await profileprovider
                          .getForgetPassword(forgotPasswordController.text);

                      if (profileprovider.successModel.status == 200) {
                        Utils().showToast(
                            profileprovider.successModel.message ?? "");
                        profileprovider.setLoading(false);
                        if (!context.mounted) return;
                        Navigator.pop(context);

                        forgotPasswordController.clear();
                      } else {
                        profileprovider.setLoading(false);
                        Utils().showToast(
                            profileprovider.successModel.message ?? "");
                        if (!context.mounted) return;
                      }
                    }
                  },
                  child: AnimatedContainer(
                    duration: const Duration(milliseconds: 80),
                    clipBehavior: Clip.antiAliasWithSaveLayer,
                    curve: Curves.bounceInOut,
                    width: generalProvider.isProgressLoading
                        ? 100
                        : MediaQuery.of(context).size.width,
                    height: 45,
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                      color: colorPrimaryDark,
                      borderRadius: BorderRadius.circular(10),
                    ),
                    child: generalProvider.isProgressLoading
                        ? const SizedBox(
                            width: 25,
                            height: 25,
                            child: CircularProgressIndicator(
                              color: white,
                              strokeWidth: 2,
                            ),
                          )
                        : MyText(
                            color: white,
                            text: "forgotpasswordtitle",
                            maxline: 1,
                            fontwaight: FontWeight.w600,
                            fontsizeNormal: Dimens.textMedium,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.center,
                            fontstyle: FontStyle.normal,
                            multilanguage: true,
                          ),
                  ),
                ),
              ],
            ),
          ),
        );
      }),
    );
  }
}
