import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/provider/profileprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webvideobyidviewall.dart';
import 'package:prakah/webwidget/interactive_icon.dart';
import 'package:prakah/webwidget/interactive_networkicon.dart';
import 'package:prakah/webwidget/interactive_text.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_staggered_grid_view/flutter_staggered_grid_view.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:provider/provider.dart';

class FooterWeb extends StatefulWidget {
  const FooterWeb({super.key});

  @override
  State<FooterWeb> createState() => _FooterWebState();
}

class _FooterWebState extends State<FooterWeb> {
  SharedPre sharedPref = SharedPre();
  late ProfileProvider profileProvider;

  @override
  void initState() {
    super.initState();
    profileProvider = Provider.of<ProfileProvider>(context, listen: false);
    // getApi();
  }

  // getApi() async {
  //   final generaProvider = Provider.of<GeneralProvider>(context, listen: false);
  //   final exploreProvider =
  //       Provider.of<ExploreProvider>(context, listen: false);
  //   await generaProvider.getGeneralsetting(context);
  //   await exploreProvider.getCategory(0);
  //   await profileProvider.getPages();
  //   await profileProvider.getSocialLink();
  //   if (Constant.userID != null) {
  //     if (!mounted) return;
  //     await profileProvider.getprofile(context);
  //   }
  // }

  @override
  Widget build(BuildContext context) {
    return Consumer<GeneralProvider>(
        builder: (context, exploreprovider, child) {
      return Column(
        children: [
          Container(
            padding: EdgeInsets.fromLTRB(
                (MediaQuery.of(context).size.width > 1000) ? 200 : 20,
                50,
                (MediaQuery.of(context).size.width > 1000) ? 200 : 20,
                50),
            decoration: const BoxDecoration(
                shape: BoxShape.rectangle, color: colorPrimaryDark),
            child: (MediaQuery.of(context).size.width < 1250)
                ? _buildColumnFooter()
                : _buildRowFooter(),
          ),
          Container(
            height: 50,
            width: MediaQuery.sizeOf(context).width,
            color: black,
            alignment: Alignment.center,
            child: RichText(
              text: TextSpan(
                text: 'Copyright © 2025 ',
                style: GoogleFonts.sora(
                    fontSize: Dimens.textTitle,
                    color: white,
                    fontWeight: FontWeight.w400),
                children: <TextSpan>[
                  TextSpan(
                      text: 'Prakah Education  ',
                      style: GoogleFonts.sora(
                          fontSize: Dimens.textTitle,
                          color: colorPrimaryDark,
                          fontWeight: FontWeight.w600)),
                  TextSpan(
                    text: '|| All Rights Reserved',
                    style: GoogleFonts.sora(
                        fontSize: Dimens.textTitle,
                        color: white,
                        fontWeight: FontWeight.w400),
                  ),
                ],
              ),
            ),
          )
        ],
      );
    });
  }

  Widget _buildRowFooter() {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      crossAxisAlignment: CrossAxisAlignment.start,
      spacing: 30,
      children: [
        /* App Icon & Desc. */
        Flexible(
          fit: FlexFit.loose,
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              MyImage(
                width: Dimens.appiconFooterWidth,
                height: Dimens.appiconFooterheight,
                fit: BoxFit.fill,
                isAppicon: true,
                imagePath: "appiconweb.png",
              ),
              const SizedBox(height: 30),
              MyText(
                color: white,
                multilanguage: false,
                text: Constant.appDescription ?? "",
                fontwaight: FontWeight.w600,
                fontsizeWeb: Dimens.textTitle,
                fontsizeNormal: Dimens.textTitle,
                textalign: TextAlign.start,
                fontstyle: FontStyle.normal,
                maxline: 5,
                overflow: TextOverflow.ellipsis,
              ),
              SizedBox(height: 20),

              /* Store Icons */
            ],
          ),
        ),

        /* Quick Links */
        Flexible(
          fit: FlexFit.loose,
          child: _buildPages(),
        ),

        /* Category */
        Flexible(
          fit: FlexFit.loose,
          child: _buildCategory(),
        ),
        Flexible(
          fit: FlexFit.loose,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 20,
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              _buildSocialLink(),

              /* Available On */
              Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 10,
                children: [
                  Row(
                    children: [
                      MyText(
                        color: white,
                        multilanguage: false,
                        text: Constant.appName,
                        fontwaight: FontWeight.w600,
                        fontsizeWeb: Dimens.textSmall,
                        fontsizeNormal: Dimens.textSmall,
                        textalign: TextAlign.start,
                        fontstyle: FontStyle.normal,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                        color: white,
                        multilanguage: true,
                        text: "avalableon",
                        fontwaight: FontWeight.w600,
                        fontsizeWeb: Dimens.textSmall,
                        fontsizeNormal: Dimens.textSmall,
                        textalign: TextAlign.start,
                        fontstyle: FontStyle.normal,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                      ),
                    ],
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      InkWell(
                        onTap: () {},
                        borderRadius: BorderRadius.circular(3),
                        child: InteractiveIcon(
                          imagePath: "playstore.png",
                          height: 25,
                          width: 25,
                          withBG: true,
                          bgRadius: 3,
                          bgColor: transparent,
                          bgHoverColor: colorPrimary,
                        ),
                      ),
                      const SizedBox(width: 5),
                      InkWell(
                        onTap: () {},
                        borderRadius: BorderRadius.circular(3),
                        child: InteractiveIcon(
                          height: 25,
                          width: 25,
                          imagePath: "applestore.png",
                          iconColor: white,
                          withBG: true,
                          bgRadius: 3,
                          bgColor: transparent,
                          bgHoverColor: colorPrimary,
                        ),
                      ),
                    ],
                  ),
                ],
              ),
            ],
          ),
        ),
      ],
    );
  }

  Widget _buildColumnFooter() {
    return Column(
      mainAxisAlignment: MainAxisAlignment.start,
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        /* App Icon & Desc. */
        MyImage(
          width: Dimens.appiconFooterWidth,
          height: Dimens.appiconFooterheight,
          fit: BoxFit.fill,
          isAppicon: true,
          imagePath: "appiconweb.png",
        ),
        const SizedBox(height: 30),
        MyText(
          color: white,
          multilanguage: false,
          text: Constant.appDescription ?? "",
          fontwaight: FontWeight.w600,
          fontsizeWeb: Dimens.textTitle,
          fontsizeNormal: Dimens.textTitle,
          textalign: TextAlign.start,
          fontstyle: FontStyle.normal,
          maxline: 5,
          overflow: TextOverflow.ellipsis,
        ),
        /* Contact With us & Store Icons */
        /* Social Icons */
        const SizedBox(height: 20),
        _buildSocialLink(),
        const SizedBox(height: 20),

        /* Available On */
        Row(
          children: [
            MyText(
              color: white,
              multilanguage: false,
              text: Constant.appName,
              fontwaight: FontWeight.w600,
              fontsizeWeb: Dimens.textMedium,
              fontsizeNormal: Dimens.textMedium,
              textalign: TextAlign.start,
              fontstyle: FontStyle.normal,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
            ),
            const SizedBox(width: 5),
            MyText(
              color: white,
              multilanguage: true,
              text: "avalableon",
              fontwaight: FontWeight.w600,
              fontsizeWeb: Dimens.textMedium,
              fontsizeNormal: Dimens.textMedium,
              textalign: TextAlign.start,
              fontstyle: FontStyle.normal,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
            ),
          ],
        ),
        const SizedBox(height: 8),

        /* Store Icons */
        Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            InkWell(
              onTap: () {},
              borderRadius: BorderRadius.circular(3),
              child: InteractiveIcon(
                imagePath: "playstore.png",
                height: 25,
                width: 25,
                withBG: true,
                bgRadius: 3,
                bgColor: transparent,
                bgHoverColor: colorPrimary,
              ),
            ),
            const SizedBox(width: 5),
            InkWell(
              onTap: () {},
              borderRadius: BorderRadius.circular(3),
              child: InteractiveIcon(
                height: 25,
                width: 25,
                imagePath: "applestore.png",
                iconColor: white,
                withBG: true,
                bgRadius: 3,
                bgColor: transparent,
                bgHoverColor: colorPrimary,
              ),
            ),
          ],
        ),
        const SizedBox(height: 40),

        /* Quick Links */
        _buildPages(),
        const SizedBox(height: 30),

        /* Quick Links */
        _buildCategory(),
        const SizedBox(height: 30),
      ],
    );
  }

  Widget _buildCategory() {
    return Consumer<GeneralProvider>(
        builder: (context, exploreprovider, child) {
      if (exploreprovider.loading) {
        return _shimmer();
      } else {
        if (exploreprovider.categoryModel.status == 200 &&
            exploreprovider.categoryModel.result != null) {
          return Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              MyText(
                color: colorAccent,
                multilanguage: true,
                text: "footercategorytitle",
                fontwaight: FontWeight.w600,
                fontsizeWeb: Dimens.textBig,
                fontsizeNormal: Dimens.textBig,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.start,
                fontstyle: FontStyle.normal,
              ),
              SizedBox(height: 20),
              AlignedGridView.count(
                shrinkWrap: true,
                crossAxisCount: 1,
                crossAxisSpacing: 20,
                mainAxisSpacing: 20,
                itemCount:
                    (exploreprovider.categoryModel.result?.length ?? 0) > 5
                        ? 5
                        : exploreprovider.categoryModel.result?.length ?? 0,
                padding: EdgeInsets.zero,
                physics: const NeverScrollableScrollPhysics(),
                itemBuilder: (BuildContext context, int position) {
                  return buildCategoryItem(
                    pageName:
                        exploreprovider.categoryModel.result?[position].name ??
                            "",
                    onClick: () {
                      Navigator.of(context).push(
                        PageRouteBuilder(
                          transitionDuration: const Duration(milliseconds: 200),
                          pageBuilder: (BuildContext context,
                              Animation<double> animation,
                              Animation<double> secondaryAnimation) {
                            return WebVideoByIdViewAll(
                              title: exploreprovider
                                      .categoryModel.result?[position].name ??
                                  "",
                              contentId: exploreprovider
                                      .categoryModel.result?[position].id
                                      .toString() ??
                                  "",
                              apiType: "category",
                            );
                          },
                          transitionsBuilder: (BuildContext context,
                              Animation<double> animation,
                              Animation<double> secondaryAnimation,
                              Widget child) {
                            return Align(
                              child: FadeTransition(
                                opacity: animation,
                                child: child,
                              ),
                            );
                          },
                        ),
                      );
                    },
                  );
                },
              ),
            ],
          );
        } else {
          return const SizedBox.shrink();
        }
      }
    });
  }

  Widget buildCategoryItem({
    required String pageName,
    required Function() onClick,
  }) {
    return InkWell(
      onTap: onClick,
      child: Row(
        children: [
          MyText(
            color: white,
            text: ">",
            fontsizeWeb: Dimens.textTitle,
            fontsizeNormal: Dimens.textTitle,
            fontwaight: FontWeight.w500,
            textalign: TextAlign.justify,
            fontstyle: FontStyle.normal,
            multilanguage: false,
          ),
          const SizedBox(width: 8),
          Expanded(
            child: InteractiveText(
              text: pageName,
              multilanguage: false,
              maxline: 2,
              textalign: TextAlign.justify,
              fontstyle: FontStyle.normal,
              fontsizeWeb: Dimens.textTitle,
              fontweight: FontWeight.w500,
              activeColor: colorAccent,
              inctiveColor: white,
            ),
          ),
        ],
      ),
    );
  }

  Widget _buildPages() {
    return Consumer<ProfileProvider>(
        builder: (context, profileprovider, child) {
      if (profileprovider.pageLoding) {
        return _shimmer();
      } else {
        if (profileprovider.getpagemodel.status == 200 &&
            profileprovider.getpagemodel.result != null) {
          return Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              MyText(
                color: colorAccent,
                multilanguage: true,
                text: "quicklink",
                fontsizeWeb: Dimens.textBig,
                fontsizeNormal: Dimens.textBig,
                fontwaight: FontWeight.w600,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.start,
                fontstyle: FontStyle.normal,
              ),
              SizedBox(height: 20),
              AlignedGridView.count(
                shrinkWrap: true,
                crossAxisCount: 1,
                crossAxisSpacing: 20,
                mainAxisSpacing: 20,
                itemCount: (profileprovider.getpagemodel.result?.length ?? 0),
                padding: EdgeInsets.zero,
                physics: const NeverScrollableScrollPhysics(),
                itemBuilder: (BuildContext context, int position) {
                  return _buildPageItem(
                    pageName:
                        profileprovider.getpagemodel.result?[position].title ??
                            "",
                    onClick: () {
                      Utils.lanchUrl(
                          profileprovider.getpagemodel.result?[position].url ??
                              "");
                    },
                  );
                },
              ),
            ],
          );
        } else {
          return const SizedBox.shrink();
        }
      }
    });
  }

  Widget _buildPageItem({
    required String pageName,
    required Function() onClick,
  }) {
    return InkWell(
      onTap: onClick,
      child: Row(
        children: [
          MyText(
            color: white,
            text: ">",
            fontsizeWeb: Dimens.textTitle,
            fontsizeNormal: Dimens.textTitle,
            fontwaight: FontWeight.w500,
            textalign: TextAlign.justify,
            fontstyle: FontStyle.normal,
            multilanguage: false,
          ),
          const SizedBox(width: 8),
          Expanded(
            child: InteractiveText(
              text: pageName,
              multilanguage: false,
              maxline: 2,
              textalign: TextAlign.justify,
              fontstyle: FontStyle.normal,
              fontsizeWeb: Dimens.textTitle,
              fontweight: FontWeight.w500,
              activeColor: colorAccent,
              inctiveColor: white,
            ),
          ),
        ],
      ),
    );
  }

  Widget _buildSocialLink() {
    return Consumer<ProfileProvider>(
        builder: (context, profileprovider, child) {
      if (profileprovider.loading) {
        return const SizedBox.shrink();
      } else {
        if (profileprovider.socialLinkModel.status == 200 &&
            profileprovider.socialLinkModel.result != null) {
          return Wrap(
            spacing: 16,
            runSpacing: 10,
            children: List.generate(
              profileProvider.socialLinkModel.result?.length ?? 0,
              (index) {
                return buildSocialIcon(
                  iconUrl:
                      profileProvider.socialLinkModel.result?[index].image ??
                          "",
                  onClick: () {
                    Utils.lanchUrl(
                        profileProvider.socialLinkModel.result?[index].url ??
                            "");
                  },
                );
              },
            ),
          );
        } else {
          return const SizedBox.shrink();
        }
      }
    });
  }

  Widget buildSocialIcon({
    required String iconUrl,
    required Function() onClick,
  }) {
    return SizedBox(
      height: Dimens.heightSocialBtn,
      width: Dimens.widthSocialBtn,
      child: InkWell(
        borderRadius: BorderRadius.circular(3.0),
        onTap: onClick,
        child: InteractiveNetworkIcon(
          height: 30,
          width: 30,
          iconFit: BoxFit.contain,
          imagePath: iconUrl,
          withBG: true,
          bgRadius: 200,
          bgColor: colorPrimary.withValues(alpha: 0.3),
          bgHoverColor: colorPrimary.withValues(alpha: 0.2),
        ),
      ),
    );
  }

/* Pages and Category Shimmer */
  Widget _shimmer() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        CustomWidget.roundcorner(height: 18, width: 100),
        SizedBox(height: 10),
        ListView.builder(
          itemCount: 4,
          shrinkWrap: true,
          physics: NeverScrollableScrollPhysics(),
          itemBuilder: (context, index) {
            return CustomWidget.roundcorner(height: 16, width: 100);
          },
        )
      ],
    );
  }
}
