import 'dart:convert';
import 'dart:io';
import 'dart:isolate';
import 'package:prakah/model/applycouponmodel.dart';
import 'package:prakah/model/cartmodel.dart';
import 'package:prakah/model/chapternamemodel.dart';
import 'package:prakah/model/classhistorydetailsmodel.dart';
import 'package:prakah/model/classhistorymodel.dart';
import 'package:prakah/model/coursemodel.dart';
import 'package:prakah/model/coursenamemodel.dart';
import 'package:prakah/model/liveclasssectionmodel.dart';
import 'package:prakah/model/meetingdetailsmodel.dart';
import 'package:prakah/model/meetinglistmodel.dart';
import 'package:prakah/model/meetingstatusmodel.dart';
import 'package:prakah/model/promocodemodel.dart';
import 'package:prakah/model/relatedblogmodel.dart';
import 'package:prakah/model/searchliveclassmodel.dart';
import 'package:prakah/model/selectedtimeslotemodel.dart';
import 'package:prakah/model/transcationlistmodel.dart';
import 'package:prakah/model/usermeetingmodel.dart';
import 'package:prakah/model/viewseriesmodel.dart';
import 'package:prakah/model/viewsessionmodel.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:hive/hive.dart';
import 'package:intl/intl.dart';
import 'package:pretty_dio_logger/pretty_dio_logger.dart';
import 'package:provider/provider.dart';
import 'package:prakah/model/blogdetailmodel.dart';
import 'package:prakah/model/certificatemodel.dart';
import 'package:prakah/model/download_item.dart';
import 'package:prakah/model/ebookdetailmodel.dart';
import 'package:prakah/model/reviewmodel.dart';
import 'package:prakah/model/ebookmodel.dart';
import 'package:prakah/model/getvideobychapter.dart';
import 'package:prakah/model/introscreenmodel.dart';
import 'package:prakah/model/notificationmodel.dart';
import 'package:prakah/model/packagemodel.dart';
import 'package:prakah/model/relatedbookmodel.dart';
import 'package:prakah/model/savequestionreportmodel.dart';
import 'package:prakah/model/sectiondetailmodel.dart';
import 'package:prakah/model/sectionlistmodel.dart';
import 'package:prakah/model/sociallinkmodel.dart';
import 'package:prakah/provider/showdownloadprovider.dart';
import 'package:prakah/utils/utils.dart';
import 'package:dio/dio.dart';
import 'package:prakah/model/successModel.dart';
import 'package:prakah/model/categorymodel.dart';
import 'package:prakah/model/coursedetailsmodel.dart';
import 'package:prakah/model/generalsettingmodel.dart';
import 'package:prakah/model/pagemodel.dart';
import 'package:prakah/model/getquestionbycategorymodel.dart';
import 'package:prakah/model/commanmodel.dart';
import 'package:prakah/model/usermodel.dart';
import 'package:prakah/model/mycoursemodel.dart';
import 'package:prakah/model/paymentoptionmodel.dart';
import 'package:prakah/model/profilemodel.dart';
import 'package:prakah/model/relatedcoursemodel.dart';
import 'package:prakah/model/tutorprofilemodel.dart';
import 'package:prakah/utils/constant.dart';
import 'package:path/path.dart';
import 'package:path/path.dart' as path;
import 'package:http_parser/http_parser.dart';
import 'package:prakah/model/getvideobychapter.dart' as episode;
import 'package:prakah/model/coursedetailsmodel.dart' as contentdetails;

class ApiService {
  String baseUrl = Constant.baseurl;

  late Dio dio;
  Options optHeaders = Options(headers: <String, dynamic>{
    'Content-Type': 'application/json',
  });
  ApiService() {
    dio = Dio();
    dio.interceptors.add(
      PrettyDioLogger(
        requestHeader: true,
        requestBody: true,
        responseBody: true,
        responseHeader: false,
        compact: false,
      ),
    );
  }

  /* General APi Start */

  Future<GeneralSettingModel> genaralSetting() async {
    GeneralSettingModel generalSettingModel;
    String apiname = "general_setting";
    Response response = await dio.post('$baseUrl$apiname', options: optHeaders);
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;

    generalSettingModel = GeneralSettingModel.fromJson(data);
    return generalSettingModel;
  }

  Future<IntroScreenModel> getOnboardingScreen() async {
    IntroScreenModel introScreenModel;
    String apiName = "get_onboarding_screen";
    Response response = await dio.post('$baseUrl$apiName',
        options: optHeaders); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    introScreenModel = IntroScreenModel.fromJson(data);
    return introScreenModel;
  }

  Future<UserModel> login(
      String type, email, password, deviceType, deviceToken) async {
    UserModel userModel;
    String login = "login";
    Response response = await dio.post('$baseUrl$login',
        options: optHeaders,
        data: FormData.fromMap({
          'type': type,
          'email': email,
          'password': password,
          'device_type': deviceType,
          'device_token': deviceToken,
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    userModel = UserModel.fromJson(data);
    return userModel;
  }

  Future<UserModel> otpLogin(String type, countryCode, number, countryName,
      deviceType, deviceToken) async {
    UserModel userModel;
    String login = "login";
    Response response = await dio.post('$baseUrl$login',
        options: optHeaders,
        data: FormData.fromMap({
          'type': type,
          'country_code': countryCode,
          'mobile_number': number,
          'country_name': countryName,
          'device_type': deviceType,
          'device_token': deviceToken,
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    userModel = UserModel.fromJson(data);
    return userModel;
  }

  Future<UserModel> socilaLogin(
      String type, email, deviceType, deviceToken) async {
    UserModel userModel;
    String login = "login";
    Response response = await dio.post('$baseUrl$login',
        options: optHeaders,
        data: FormData.fromMap({
          'type': type,
          'email': email,
          'device_type': deviceType,
          'device_token': deviceToken,
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    userModel = UserModel.fromJson(data);
    return userModel;
  }

  Future<UserModel> register(String fullname, email, number, password,
      countryCode, countryName, deviceType, deviceToken) async {
    UserModel registermodel;
    String apiname = "registration";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'full_name': fullname,
          'email': email,
          'mobile_number': number,
          'password': password,
          'country_code': countryCode,
          'country_name': countryName,
          'device_type': deviceType,
          'device_token': deviceToken,
        }));

    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    registermodel = UserModel.fromJson(data);
    return registermodel;
  }

  Future<ProfileModel> profile() async {
    ProfileModel profileModel;
    String apiname = "get_profile";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap(
            {'user_id': (Constant.userID == null) ? 0 : Constant.userID}));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    profileModel = ProfileModel.fromJson(data);
    return profileModel;
  }

  Future<ProfileModel> updateprofile(
      String userName,
      fullname,
      mobilenumber,
      email,
      countryCode,
      countryName,
      imagefile,
      fileName,
      mediaType,
      deviceType,
      deviceToken) async {
    ProfileModel updateprofilemodel;
    String updateprofile = "update_profile";
    Response response = await dio.post('$baseUrl$updateprofile',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          "user_name": userName,
          'full_name': fullname,
          'email': email,
          'mobile_number': mobilenumber,
          'country_code': countryCode,
          'country_name': countryName,
          if (imagefile != null)
            "image": (imagefile is Uint8List) // Web image handling
                ? MultipartFile.fromBytes(
                    imagefile,
                    filename: fileName,
                    contentType: MediaType(
                      'image',
                      mediaType,
                    ),
                  )
                : imagefile.path != ""
                    ? await MultipartFile.fromFile(imagefile.path,
                        filename: path.basename(imagefile.path))
                    : "",
          'device_type': deviceType,
          'device_token': deviceToken,
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    updateprofilemodel = ProfileModel.fromJson(data);
    return updateprofilemodel;
  }

  Future<SuccessModel> forgotPasswordResponse(String email) async {
    SuccessModel forgotpasswordModel;
    String updateprofile = "forgot_password";
    Response response = await dio.post('$baseUrl$updateprofile',
        data: FormData.fromMap({
          'email': email,
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    forgotpasswordModel = SuccessModel.fromJson(data);
    return forgotpasswordModel;
  }

  Future<PageModel> getpage() async {
    PageModel getPageModel;
    String apiname = "get_pages";
    Response response =
        await dio.post('$baseUrl$apiname'); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    getPageModel = PageModel.fromJson(data);
    return getPageModel;
  }

  Future<SocialLinkModel> getSocialLink() async {
    SocialLinkModel socialLinkModel;
    String apiname = "get_social_link";
    Response response =
        await dio.post('$baseUrl$apiname'); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    socialLinkModel = SocialLinkModel.fromJson(data);
    return socialLinkModel;
  }

  /* General APi End */

  Future<SectionListModel> sectionList(int pageno) async {
    SectionListModel sectionListModel;
    String apiname = "section_list";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'page_no': pageno,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    sectionListModel = SectionListModel.fromJson(data);
    return sectionListModel;
  }

  Future<SectionDetailModel> sectionDetail(String sectionId, pageno) async {
    SectionDetailModel sectionDetailModel;
    String apiname = "section_detail";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'section_id': sectionId,
          'page_no': pageno,
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    sectionDetailModel = SectionDetailModel.fromJson(data);
    return sectionDetailModel;
  }

  Future<CategoryModel> category(int pageNo) async {
    CategoryModel categoryModel;
    String apiname = "get_category";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'page_no': pageNo,
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    categoryModel = CategoryModel.fromJson(data);
    return categoryModel;
  }

  Future<MyCourseModel> mycourse(int pageno) async {
    MyCourseModel mycoursemodel;
    String apiname = "my_course";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'page_no': pageno,
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    mycoursemodel = MyCourseModel.fromJson(data);
    return mycoursemodel;
  }

  Future<CommanModel> search(String name, type, pageNo) async {
    CommanModel searchModel;
    String apiname = "search_content";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'name': name,
          'type': type,
          "page_no": pageNo
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    searchModel = CommanModel.fromJson(data);
    return searchModel;
  }

/* Video By Category & Language */

  Future<CourseModel> getContentbyCategoryId(String categoryId, pageNo) async {
    CourseModel videobyIdModel;
    String apiname = "get_content_by_category";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'category_id': categoryId,
          'page_no': pageNo,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    videobyIdModel = CourseModel.fromJson(data);
    return videobyIdModel;
  }

  Future<CourseModel> getContentbyLanguageId(String languageId, pageNo) async {
    CourseModel videobyIdModel;
    String apiname = "get_content_by_language";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'language_id': languageId,
          'page_no': pageNo,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    videobyIdModel = CourseModel.fromJson(data);
    return videobyIdModel;
  }

  /* Detail Page All Api's Start */

  Future<CourseDetailsModel> courseDetail(String courseId) async {
    CourseDetailsModel courseDetailsModel;
    String apiname = "course_detail";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'course_id': courseId,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    courseDetailsModel = CourseDetailsModel.fromJson(data);
    return courseDetailsModel;
  }

  Future<ReviewModel> courseReviewList(String type, contentId, pageNo) async {
    ReviewModel getCourseReviewModel;
    String apiname = "get_review_by_content";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'type': type,
          'content_id': contentId,
          'page_no': pageNo,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    getCourseReviewModel = ReviewModel.fromJson(data);
    return getCourseReviewModel;
  }

  Future<SuccessModel> addContentView(String type, contentId, videoId) async {
    SuccessModel successModel;
    String apiname = "add_content_view";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'type': type,
          'content_id': contentId,
          'video_id': videoId,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    successModel = SuccessModel.fromJson(data);
    return successModel;
  }

  Future<SuccessModel> addVideoRead(
    String courseId,
    chapterId,
    videoId,
    stopTime,
  ) async {
    SuccessModel successVideoReadModel;
    String apiname = "add_video_read";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'course_id': courseId,
          'chapter_id': chapterId,
          'video_id': videoId,
          "stop_time": stopTime
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    successVideoReadModel = SuccessModel.fromJson(data);
    return successVideoReadModel;
  }

  Future<RelatedCourseModel> relatedcourse(String courseId, pageNo) async {
    RelatedCourseModel relatedCourseModel;
    String apiname = "get_related_course";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'course_id': courseId,
          'page_no': pageNo,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    relatedCourseModel = RelatedCourseModel.fromJson(data);
    return relatedCourseModel;
  }

  Future<GetVideoByChapterModel> videoByChapter(
      String courseId, chapterId, pageNo) async {
    GetVideoByChapterModel getVideoByChapterModel;
    String apiname = "get_video_by_chapter";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'course_id': courseId,
          'chapter_id': chapterId,
          'page_no': pageNo,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    getVideoByChapterModel = GetVideoByChapterModel.fromJson(data);
    return getVideoByChapterModel;
  }

  Future<SuccessModel> addContentReview(
      String type, contentId, comment, rating) async {
    printLog("rating ==> $rating");
    SuccessModel successModel;
    String apiname = "add_content_review";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'type': type,
          'content_id': contentId,
          'comment': comment,
          'rating': rating,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    successModel = SuccessModel.fromJson(data);
    return successModel;
  }

  Future<CertificateModel> fetchCertificate(String courseId) async {
    CertificateModel certificateModel;
    String apiname = "download_certificate";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'course_id': courseId,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    certificateModel = CertificateModel.fromJson(data);
    return certificateModel;
  }

  /* Detail Page All Api's End */

  /* (Wishlist Api Start) */

  Future<CommanModel> wishlist(String type, pageno) async {
    CommanModel wishlistmodel;
    String apiname = "get_wishlist_content";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'type': type,
          'page_no': pageno,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    wishlistmodel = CommanModel.fromJson(data);
    return wishlistmodel;
  }

  Future<SuccessModel> addRemoveWishlist(String type, contentId) async {
    SuccessModel successModel;
    String apiname = "add_remove_wishlist";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'type': type,
          'content_id': contentId,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    successModel = SuccessModel.fromJson(data);
    return successModel;
  }

  /* Wishlist Api End */

  /* Subscription Start */

  Future<PackageModel> package(int pageNo) async {
    PackageModel packageModel;
    String apiname = "get_package";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'page_no': pageNo,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    packageModel = PackageModel.fromJson(data);
    return packageModel;
  }

  Future<PaymentOptionModel> paymentOption() async {
    PaymentOptionModel paymentOptionModel;
    String apiname = "get_payment_option";
    Response response =
        await dio.post('$baseUrl$apiname'); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    paymentOptionModel = PaymentOptionModel.fromJson(data);
    return paymentOptionModel;
  }

  Future<SuccessModel> addPackageTransaction(
      String type, contentId, price, transectionId) async {
    SuccessModel successModel;
    String apiname = "add_transaction";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          "type": type,
          'content_id': contentId,
          'price': price,
          'transaction_id': transectionId,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    successModel = SuccessModel.fromJson(data);
    return successModel;
  }

/* Subscription End */

  Future<CommanModel> getContentByTutor(String type, tutorId, pageNo) async {
    CommanModel courselistbytutoridModel;
    String apiname = "get_content_by_tutor";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'type': type,
          'tutor_id': tutorId,
          'page_no': pageNo,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    courselistbytutoridModel = CommanModel.fromJson(data);
    return courselistbytutoridModel;
  }

  Future<Tutorprofilemodel> tutorprofile(String tutorid) async {
    Tutorprofilemodel tutorprofilemodel;
    String apiname = "tutor_profile";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'tutor_id': tutorid,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    tutorprofilemodel = Tutorprofilemodel.fromJson(data);
    return tutorprofilemodel;
  }

  Future<SuccessModel> buyCourseResponse(String type, totalPrice, discountPrice,
      promoCodeId, courseId, transactionId) async {
    SuccessModel buyCourseModel;
    String apiname = "buy_course";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          "type": type,
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          "total_price": totalPrice,
          "discount_price": discountPrice,
          "promo_code_id": promoCodeId,
          "course_id": courseId,
          "transaction_id": transactionId
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buyCourseModel = SuccessModel.fromJson(data);
    return buyCourseModel;
  }

/* Quize Api Start */

  Future<GetQuestionByChapterModel> questionByChapter(
      String courseId, chapterId) async {
    GetQuestionByChapterModel getQuestionByCategoryModel;
    String apiname = "get_question_by_chapter";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'course_id': courseId,
          'chapter_id': chapterId,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    getQuestionByCategoryModel = GetQuestionByChapterModel.fromJson(data);
    return getQuestionByCategoryModel;
  }

  Future<SaveQuestionReportModel> saveCourseQuestionReport(
    String courseId,
    chapterId,
    totalQuestion,
    questionsAttended,
    correctAnswers,
  ) async {
    SaveQuestionReportModel saveQuestionReportModel;
    String content = "save_course_question_report";
    Response response = await dio.post('$baseUrl$content',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'course_id': courseId,
          'chapter_id': chapterId,
          'total_questions': totalQuestion,
          'questions_attended': questionsAttended,
          'correct_answers': correctAnswers,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    saveQuestionReportModel = SaveQuestionReportModel.fromJson((data));
    return saveQuestionReportModel;
  }

/* Quize Api End */
/* Become a Tutor APi */
  Future<SuccessModel> becomeTutor(String fullName, email, password,
      mobileNumber, countryCode, countryName, designation) async {
    SuccessModel becometutorModel;
    String apiname = "become_tutor";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          "full_name": fullName,
          "email": email,
          "password": password,
          "mobile_number": mobileNumber,
          "country_code": countryCode,
          "country_name": countryName,
          "designation": designation,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    becometutorModel = SuccessModel.fromJson(data);
    return becometutorModel;
  }

  Future<NotificationModel> getNotification(int pageNo) async {
    NotificationModel notificationModel;
    String apiname = "get_notification";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'page_no': pageNo,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    notificationModel = NotificationModel.fromJson(data);
    return notificationModel;
  }

  Future<SuccessModel> readNotification(String notificationId) async {
    SuccessModel successModel;
    String apiname = "read_notification";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'notification_id': notificationId,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    successModel = SuccessModel.fromJson(data);
    return successModel;
  }

/* Books Related APi Start */

  Future<EbookModel> bookList(int pageNo) async {
    EbookModel getEbookModel;
    String apiname = "get_latest_book";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap(
            {'page_no': pageNo})); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    getEbookModel = EbookModel.fromJson(data);
    return getEbookModel;
  }

  Future<EbookDetailModel> bookDetail(String bookId) async {
    EbookDetailModel ebookDetailModel;
    String apiname = "book_detail";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'book_id': bookId,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    ebookDetailModel = EbookDetailModel.fromJson(data);
    return ebookDetailModel;
  }

  Future<RelatedBookModel> relatedBooks(String bookId, pageNo) async {
    RelatedBookModel relatedBookModel;
    String apiname = "get_related_book";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          'book_id': bookId,
          'page_no': pageNo,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    relatedBookModel = RelatedBookModel.fromJson(data);
    return relatedBookModel;
  }

  Future<BlogDetailModel> blogDetail(String blogId) async {
    BlogDetailModel blogDetailModel;
    String apiname = "blog_detail";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'blog_id': blogId,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    blogDetailModel = BlogDetailModel.fromJson(data);
    return blogDetailModel;
  }

  Future<RelatedBlogModel> relatedBlogResponse(String blogId, pageNo) async {
    RelatedBlogModel blogDetailModel;
    String apiname = "get_related_blog";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'blog_id': blogId,
          "page_no": pageNo
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    blogDetailModel = RelatedBlogModel.fromJson(data);
    return blogDetailModel;
  }
  /* Blog Related Api End */

/* Live Class Section api */

  Future<LiveClassSectionModel> liveClassSectionResponse(int pageNo) async {
    LiveClassSectionModel buybookmodel;
    String apiname = "live_class_section";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          "page_no": pageNo
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = LiveClassSectionModel.fromJson(data);
    return buybookmodel;
  }

/* Join Call API */
  Future<SuccessModel> joinLiveClassResponse(String liveClassId) async {
    SuccessModel buybookmodel;
    String apiname = "join_live_class";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          "live_class_id": liveClassId
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = SuccessModel.fromJson(data);
    return buybookmodel;
  }

/* View Series API */
  Future<ViewSeriesModel> viewSeriesResponse(String liveClassId) async {
    ViewSeriesModel buybookmodel;
    String apiname = "view_series";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          "live_class_id": liveClassId
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = ViewSeriesModel.fromJson(data);
    return buybookmodel;
  }

/* Class Histroy Api */
  Future<ClassHistoryModel> classHistoryResponse(int pageNo) async {
    ClassHistoryModel buybookmodel;
    String apiname = "my_class_history";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          "page_no": pageNo
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = ClassHistoryModel.fromJson(data);
    return buybookmodel;
  }

/* Class Histroy Details Api */
  Future<ClassHistoryDetailsModel> classHistoryDetailsResponse(
      String attendingLiveclassId) async {
    ClassHistoryDetailsModel buybookmodel;
    String apiname = "class_history_details";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          "attending_liveclass_id": attendingLiveclassId
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = ClassHistoryDetailsModel.fromJson(data);
    return buybookmodel;
  }

/* Class Histroy Details Api */
  Future<SearchLiveClassModel> searchLiveClassResponse(
      dynamic formDate, toDate, isFree, courseId, classStatus, pageNo) async {
    SearchLiveClassModel buybookmodel;
    String apiname = "search_live_class";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          "form_date": DateFormat("yyyy-MM-dd").format(formDate),
          "to_date": DateFormat("yyyy-MM-dd").format(toDate),
          "is_free": isFree,
          "course_id": courseId,
          "class_status": classStatus,
          "page_no": pageNo,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = SearchLiveClassModel.fromJson(data);
    return buybookmodel;
  }

/* Course name api */
  Future<CourseNameModel> courseNameResponse() async {
    CourseNameModel buybookmodel;
    String apiname = "get_course_name";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({})); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = CourseNameModel.fromJson(data);
    return buybookmodel;
  }

/* Course add to cart */
  Future<SuccessModel> addToCartCourse(String courseId) async {
    SuccessModel buybookmodel;
    String apiname = "add_course_to_cart";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          "course_id": courseId
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = SuccessModel.fromJson(data);
    return buybookmodel;
  }

/* Course remove to cart */
  Future<SuccessModel> removeToCartCourse(String courseId) async {
    SuccessModel buybookmodel;
    String apiname = "remove_cart";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          "course_id": courseId
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = SuccessModel.fromJson(data);
    return buybookmodel;
  }

/* Course remove to cart */
  Future<TransactionListModel> transcationListReponse(
      String type, pageNo) async {
    TransactionListModel buybookmodel;
    String apiname = "get_transaction_list";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          "type": type,
          "page_no": pageNo
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = TransactionListModel.fromJson(data);
    return buybookmodel;
  }

/* Neeting status api */

  Future<MeetingStatusModel> meetingStatusResponse() async {
    MeetingStatusModel buybookmodel;
    String apiname = "get_metting_status";
    Response response =
        await dio.post('$baseUrl$apiname', data: FormData.fromMap({}));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = MeetingStatusModel.fromJson(data);
    return buybookmodel;
  }

  Future<MeetingListModel> meetingListResponse(String courseId, pageNo) async {
    MeetingListModel buybookmodel;
    String apiname = "get_mettings_list";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          "course_id": courseId,
          "page_no": pageNo,
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = MeetingListModel.fromJson(data);
    return buybookmodel;
  }

  Future<UserMeetingModel> userMeetingResponse(String status, pageNo) async {
    UserMeetingModel buybookmodel;
    String apiname = "get_user_mettings";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
          "status": status,
          "page_no": pageNo,
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = UserMeetingModel.fromJson(data);
    return buybookmodel;
  }

  Future<CartModel> cartListResponse() async {
    CartModel buybookmodel;
    String apiname = "get_cart_list";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          'user_id': (Constant.userID == null) ? 0 : Constant.userID,
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = CartModel.fromJson(data);
    return buybookmodel;
  }

  Future<PromocodeModel> promocodeResponse(int pageNo) async {
    PromocodeModel buybookmodel;
    String apiname = "get_promocode";
    Response response = await dio.post('$baseUrl$apiname',
        data: FormData.fromMap({
          "page_no": pageNo,
        }));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    buybookmodel = PromocodeModel.fromJson(data);
    return buybookmodel;
  }

  Future<ApplyCouponModel> applyCouponResponse(
      String promocodeId, totalPrice) async {
    ApplyCouponModel bookingModel;
    String apiName = "apply_promo_code";
    Response response = await dio.post('$baseUrl$apiName',
        data: FormData.fromMap({
          "user_id": (Constant.userID == null) ? 0 : Constant.userID,
          "promo_code_id": promocodeId,
          "total_price": totalPrice,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    bookingModel = ApplyCouponModel.fromJson((data));
    return bookingModel;
  }

  Future<ApplyCouponModel> removeCouponResponse(String totalPrice) async {
    ApplyCouponModel bookingModel;
    String apiName = "remove_apply_coupon";
    Response response = await dio.post('$baseUrl$apiName',
        data: FormData.fromMap({"total_price": totalPrice}));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    bookingModel = ApplyCouponModel.fromJson((data));
    return bookingModel;
  }

/* Time Slot Api */
  Future<SelectedTimeSloteModel> timeSlotSelectResponse(
      String meetinId, date) async {
    SelectedTimeSloteModel bookingModel;
    String apiName = "get_selected_timeslote";
    Response response = await dio.post('$baseUrl$apiName',
        data: FormData.fromMap({
          // "user_id": (Constant.userID == null) ? 0 : Constant.userID,
          "metting_id": meetinId,
          "date": DateFormat("yyyy-MM-dd").format(date),
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    bookingModel = SelectedTimeSloteModel.fromJson((data));
    return bookingModel;
  }

/* Chapter name Api */
  Future<ChapterNameModel> chapterNameResponse(String courseId) async {
    ChapterNameModel bookingModel;
    String apiName = "get_chapter_name";
    Response response = await dio.post('$baseUrl$apiName',
        data: FormData.fromMap({"course_id": courseId}));
    // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    bookingModel = ChapterNameModel.fromJson(data);
    return bookingModel;
  }

  /* Book session api call */
  Future<SuccessModel> bookSessionResponse(
    String mettingId,
    mettingScheduleId,
    date,
    chapterId,
    totalPrice,
    details,
    attachment,
    transactionId,
    promoCodeId,
    fileName,
    mediaType,
  ) async {
    SuccessModel bookingModel;
    String apiName = "book_session";
    Response response = await dio.post(
      '$baseUrl$apiName',
      data: FormData.fromMap({
        "user_id": (Constant.userID == null) ? 0 : Constant.userID,
        "metting_id": mettingId,
        "metting_schedule_id": mettingScheduleId,
        "date": date,
        "course_id": chapterId,
        "total_price": totalPrice,
        "details": details,
        if (attachment != null)
          "attachment": (attachment is Uint8List) // Web image handling
              ? MultipartFile.fromBytes(
                  attachment,
                  filename: fileName,
                  contentType: MediaType(
                    'image',
                    mediaType,
                  ),
                )
              : attachment != ""
                  ? await MultipartFile.fromFile(attachment,
                      filename: basename(attachment))
                  : "",
        "transaction_id": transactionId,
        "promo_code_id": promoCodeId,
      }),
    ); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    bookingModel = SuccessModel.fromJson(data);
    return bookingModel;
  }

  Future<MeetingDetailsModel> meetingDetailsResponse(String mettingId) async {
    MeetingDetailsModel bookingModel;
    String apiName = "metting_details";
    Response response = await dio.post('$baseUrl$apiName',
        data: FormData.fromMap({
          "user_id": (Constant.userID == null) ? 0 : Constant.userID,
          "metting_id": mettingId,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    bookingModel = MeetingDetailsModel.fromJson(data);
    return bookingModel;
  }

/* View Session data */
  Future<ViewSessionModel> viewSessionData(String appointmentId) async {
    ViewSessionModel bookingModel;
    String apiName = "view_book_session";
    Response response = await dio.post('$baseUrl$apiName',
        data: FormData.fromMap({
          "user_id": (Constant.userID == null) ? 0 : Constant.userID,
          "appointment_id": appointmentId,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    bookingModel = ViewSessionModel.fromJson(data);
    return bookingModel;
  }

/* Cancel appointment Api */
  Future<SuccessModel> cancelAppointment(String appointmentId) async {
    SuccessModel bookingModel;
    String apiName = "cancel_appointment";
    Response response = await dio.post('$baseUrl$apiName',
        data: FormData.fromMap({
          "user_id": (Constant.userID == null) ? 0 : Constant.userID,
          "appointment_id": appointmentId
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    bookingModel = SuccessModel.fromJson(data);
    return bookingModel;
  }

/* Reschedules appointment Api */
  Future<SuccessModel> reschedulesAppointment(
      String appointmentId, mettingScheduleId, date) async {
    SuccessModel bookingModel;
    String apiName = "reschedules_appointment";
    Response response = await dio.post('$baseUrl$apiName',
        data: FormData.fromMap({
          "user_id": (Constant.userID == null) ? 0 : Constant.userID,
          "appointment_id": appointmentId,
          "metting_schedule_id": mettingScheduleId,
          "date": date,
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    bookingModel = SuccessModel.fromJson(data);
    return bookingModel;
  }

/* Add Wallet Mony Data */
  Future<SuccessModel> addWalletMoney(String amount, transactionId) async {
    SuccessModel bookingModel;
    String apiName = "add_wallet_amount";
    Response response = await dio.post('$baseUrl$apiName',
        data: FormData.fromMap({
          "user_id": (Constant.userID == null) ? 0 : Constant.userID,
          "amount": amount,
          "transaction_id": transactionId
        })); // Check the type of response.data
    final data =
        response.data is String ? jsonDecode(response.data) : response.data;
    bookingModel = SuccessModel.fromJson((data));
    return bookingModel;
  }
}

Future<void> prepareShowDownload(
  BuildContext context, {
  required contentdetails.Result? contentDetails,
  required int? seasonPos,
  required int? episodePos,
  required episode.Result? episodeDetails,
}) async {
  final receivePort = ReceivePort();
  contentdetails.Result? courseDetails = contentDetails;
  int seasonPosition = seasonPos ?? 0;
  int epiPos = episodePos ?? 0;
  episode.Result? epiDetails = episodeDetails;

  final downloadProvider =
      Provider.of<ShowDownloadProvider>(context, listen: false);
  downloadProvider.setCurrentDownload(epiDetails?.id ?? 0);

  Dio dio = Dio();

  /* Hive */
  var dowonloadBox = Hive.box<DownloadItem>(
      '${Constant.hiveDownloadBox}_${(Constant.userID == null) ? 0 : Constant.userID}');
  var dowonloadSeasonBox = Hive.box<ChapterItem>(
      '${Constant.hiveSeasonDownloadBox}_${(Constant.userID == null) ? 0 : Constant.userID}');
  var dowonloadEpiBox = Hive.box<EpisodeItem>(
      '${Constant.hiveEpiDownloadBox}_${(Constant.userID == null) ? 0 : Constant.userID}');
  if (!dowonloadBox.isOpen) {
    return;
  }

  DateTime now = DateTime.now();
  String timeStamp = now.millisecondsSinceEpoch.abs().toString();

  /* Prepare Target Video File START ************* */
  File? mTargetFile;
  String? localPath;
  String? mFileName = '${(courseDetails?.title ?? "").replaceAll(" ", "")}'
      '${(courseDetails?.id ?? 0)}${((Constant.userID == null) ? 0 : Constant.userID)}';
  try {
    localPath = await Utils.prepareShowSaveDir(
        (courseDetails?.title ?? "").replaceAll(RegExp('\\W+'), ''),
        (courseDetails?.chapter?[seasonPosition].name ?? "")
            .replaceAll(RegExp('\\W+'), ''));
    printLog("localPath ====> $localPath");
    String? mFileName =
        '${(courseDetails?.chapter?[seasonPosition].name ?? "").replaceAll(RegExp('\\W+'), '')}'
        '_Ep${(epiPos + 1)}_${episodeDetails?.id}${((Constant.userID == null) ? 0 : Constant.userID)}';

    mTargetFile = File(path.join(localPath, '$mFileName.${'mp4'}'));
  } catch (e) {
    printLog("saveShowStorage Exception ===> $e");
  }
  printLog("mFileName ======> $mFileName");
  printLog("mTargetFile ====> ${mTargetFile?.absolute.path ?? ""}");
  /* *************** Prepare Target Video File END */

  /* Prepare Target Image Files START ************* */
  File? mShowPortImageFile,
      mShowLandImageFile,
      mEpiPortImageFile,
      mEpiLandImageFile;
  String? mShowPortImgFileName = 'port_$timeStamp';
  String? mShowLandImgFileName = 'land_$timeStamp';
  String? mEpiPortImgFileName = 'port_epi_$timeStamp';
  String? mEpiLandImgFileName = 'land_epi_$timeStamp';
  if (localPath != null) {
    try {
      mShowPortImageFile =
          File(path.join(localPath, '$mShowPortImgFileName.png'));
      mShowLandImageFile =
          File(path.join(localPath, '$mShowLandImgFileName.png'));
      mEpiPortImageFile =
          File(path.join(localPath, '$mEpiPortImgFileName.png'));
      mEpiLandImageFile =
          File(path.join(localPath, '$mEpiLandImgFileName.png'));
    } catch (e) {
      printLog("saveShowStorage Exception ===> $e");
    }
  } else {
    return;
  }
  printLog("mPortImageFileName ======> $mShowPortImgFileName");
  printLog(
      "mTargetPortImageFile ====> ${mShowPortImageFile?.absolute.path ?? ""}");
  printLog("mLandImageFileName ======> $mShowLandImgFileName");
  printLog(
      "mTargetLandImageFile ====> ${mShowLandImageFile?.absolute.path ?? ""}");
  printLog("mEpiPortImgFileName =====> $mEpiPortImgFileName");
  printLog(
      "mEpiPortImageFile =======> ${mEpiPortImageFile?.absolute.path ?? ""}");
  printLog("mEpiLandImgFileName =====> $mEpiLandImgFileName");
  printLog(
      "mEpiLandImageFile =======> ${mEpiLandImageFile?.absolute.path ?? ""}");
  /* *************** Prepare Target Image Files END */

  try {
    if (!context.mounted) return;
    Utils.showSnackbar(context, "showFor", "Download started", false);

    /* Save Video/Show */
    List<DownloadItem> myDownloadList = [];
    DownloadItem downloadedItem = DownloadItem(
      id: courseDetails?.id,
      securityKey: "",
      title: courseDetails?.title,
      description: courseDetails?.description,
      savedDir: localPath,
      savedFile: "",
      isFree: courseDetails?.isFree,
      isBuy: courseDetails?.isBuy,
      isDownloadCertificate: courseDetails?.isDownloadCertificate,
      avgRating: courseDetails?.avgRating,
      categoryId: courseDetails?.categoryId,
      categoryName: courseDetails?.categoryName,
      createdAt: courseDetails?.createdAt,
      isUserBuy: courseDetails?.isUserBuy,
      isWishlist: courseDetails?.isWishlist,
      languageId: courseDetails?.languageId,
      languageName: courseDetails?.languageName,
      price: courseDetails?.price,
      status: courseDetails?.status,
      totalDuration: courseDetails?.totalDuration,
      totalView: courseDetails?.totalView,
      tutorId: courseDetails?.tutorId,
      tutorName: courseDetails?.tutorName,
      updatedAt: courseDetails?.updatedAt,
      thumbnailImg: mShowPortImageFile?.path,
      landscapeImg: mShowLandImageFile?.path,
      chapter: null,
    );
    /* Check in Download Box */
    myDownloadList = dowonloadBox.values.where((myDowonloadItem) {
      return (myDowonloadItem.id == courseDetails?.id);
    }).toList();

    if (myDownloadList.isEmpty) {
      /* Potrait Image Download */
      dio.download(courseDetails?.thumbnailImg ?? "",
          path.join(localPath, '$mShowPortImgFileName.png'),
          onReceiveProgress: (received, total) {});

      /* Landscape Image Download */
      dio.download(courseDetails?.landscapeImg ?? "",
          path.join(localPath, '$mShowLandImgFileName.png'),
          onReceiveProgress: (received, total) {});
    }

    /* Potrait Episode Image Download */
    dio.download(epiDetails?.thumbnailImg ?? "",
        path.join(localPath, '$mEpiPortImgFileName.png'),
        onReceiveProgress: (received, total) {});

    /* Landscape Episode Image Download */
    dio.download(epiDetails?.landscapeImg ?? "",
        path.join(localPath, '$mEpiLandImgFileName.png'),
        onReceiveProgress: (received, total) {});

    /* Video Download */
    await dio.download(epiDetails?.videoUrl ?? "", mTargetFile?.path,
        onReceiveProgress: (received, total) async {
      if (total != -1) {
        downloadProvider.setDownloadProgress(
            (received / total * 100).round(), epiDetails?.id ?? 0);
      }
    });

    /* Encrypt Episode File START ************** */
    String generateKey = Utils.generateRandomKey(32);
    printLog("generateKey =======> $generateKey");
    var rootToken = RootIsolateToken.instance!;
    final isolate = await Isolate.spawn(encryptFile,
        [mTargetFile, generateKey, receivePort.sendPort, rootToken]);
    receivePort.listen((message) {
      printLog("message =======> $message");
      if (message != null) {
        receivePort.close();
        isolate.kill(priority: Isolate.immediate);
      }
    });
    /* ***************** Encrypt Episode File END */

    /* Check In Downloaded Items START **************** */
    List<ChapterItem> mySavedSeasonList = [];
    List<EpisodeItem> mySavedEpiList = [];

    /* Save Episode */
    EpisodeItem episodeItem = EpisodeItem(
      id: episodeDetails?.id,
      securityKey: generateKey,
      courseId: courseDetails?.id,
      chapterId: episodeDetails?.chapterId,
      thumbnailImg: mEpiPortImageFile?.path,
      landscapeImg: mEpiLandImageFile?.path,
      videoUrl: episodeDetails?.videoUrl,
      duration: episodeDetails?.duration.toString(),
      videoType: episodeDetails?.videoType,
      description: episodeDetails?.description,
      status: episodeDetails?.status,
      savedDir: localPath,
      savedFile: mTargetFile?.path ?? "",
      isDownloaded: 1,
      isBuy: 1,
      createdAt: episodeDetails?.createdAt.toString(),
      isRead: episodeDetails?.isRead,
      title: episodeDetails?.title,
      totalView: episodeDetails?.totalView,
      updatedAt: episodeDetails?.updatedAt,
    );
    /* Save Season */
    ChapterItem sessionItem = ChapterItem(
      id: courseDetails?.chapter?[seasonPosition].id,
      courseId: courseDetails?.id,
      sessionPosition: seasonPosition,
      name: courseDetails?.chapter?[seasonPosition].name,
      status: courseDetails?.chapter?[seasonPosition].status,
      isDownload: 1,
      episode: null,
    );

    /* Check in Season Box */
    mySavedSeasonList = dowonloadSeasonBox.values.where((mySeasonItem) {
      return (mySeasonItem.courseId == courseDetails?.id &&
          mySeasonItem.id == courseDetails?.chapter?[seasonPosition].id);
    }).toList();
    /* Check in Episode Box */
    mySavedEpiList = dowonloadEpiBox.values.where((myEpiItem) {
      return (myEpiItem.courseId == courseDetails?.id &&
          myEpiItem.id == episodeDetails?.id &&
          myEpiItem.chapterId == courseDetails?.chapter?[seasonPosition].id);
    }).toList();
    printLog("myDownloadList =======> ${myDownloadList.length}");
    printLog("mySavedSeasonList ====> ${mySavedSeasonList.length}");
    printLog("mySavedEpiList =======> ${mySavedEpiList.length}");
    /* ****************** Check In Downloaded Items END */

    /* Insert in Hive */
    if (mySavedEpiList.isEmpty) {
      dowonloadEpiBox.add(episodeItem);
    }
    if (mySavedSeasonList.isEmpty) {
      dowonloadSeasonBox.add(sessionItem);
    }
    if (myDownloadList.isEmpty) {
      dowonloadBox.add(downloadedItem);
    }

    downloadProvider.setDownloadProgress(-1, 0);
    downloadProvider.setCurrentDownload(null);
    downloadProvider.setLoading(false);
    if (!context.mounted) return;
    Utils.showSnackbar(context, "success", "Download completed", false);
  } catch (e) {
    if (!context.mounted) return;
    if (!context.mounted) return;
    Utils.showSnackbar(context, "fail", "Download Faild", false);
  }
}
/* ========================== Download Shows ========================== */