import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/wishlistprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webblogdetail.dart';
import 'package:prakah/webpages/webdetails.dart';
import 'package:prakah/webpages/webebookdetail.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class WebWishList extends StatefulWidget {
  const WebWishList({super.key});

  @override
  State<WebWishList> createState() => WebWishListState();
}

class WebWishListState extends State<WebWishList> {
  WishlistProvider wishlistProvider = WishlistProvider();
  final ScrollController _scrollController = ScrollController();
  double? width;
  double? height;

  @override
  initState() {
    super.initState();
    wishlistProvider = Provider.of<WishlistProvider>(context, listen: false);

    _scrollController.addListener(_scrollListener);
    /* Course List Api */
    _fetchData("3", 0);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (wishlistProvider.currentPage ?? 0) <
            (wishlistProvider.totalPage ?? 0)) {
      wishlistProvider.setLoadMore(true);
      if (wishlistProvider.layoutType == Constant.courseType) {
        _fetchData("3", wishlistProvider.currentPage ?? 0);
      } else if (wishlistProvider.layoutType == Constant.bookType) {
        _fetchData("2", wishlistProvider.currentPage ?? 0);
      } else {
        _fetchData("1", wishlistProvider.currentPage ?? 0);
      }
    }
  }

  Future<void> _fetchData(String type, int? nextPage) async {
    await wishlistProvider.getWishList(type, (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();
    wishlistProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.of(context).size.width;
    height = MediaQuery.of(context).size.height;
    return Consumer<WishlistProvider>(
        builder: (context, wishlistprovider, child) {
      return Utils.hoverItemWithPage(
        myWidget: SingleChildScrollView(
          scrollDirection: Axis.vertical,
          controller: _scrollController,
          child: _buildSearch(),
        ),
      );
    });
  }

/* New UI */
  Widget _buildSearch() {
    return Column(
      mainAxisAlignment: MainAxisAlignment.start,
      crossAxisAlignment: CrossAxisAlignment.start,
      spacing: 10,
      children: [
        tabButton(),
        setLayout(),
        if (wishlistProvider.loadMore)
          Utils.pageLoader()
        else
          const SizedBox.shrink(),
      ],
    );
  }

  Widget tabButton() {
    return Container(
      margin: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(100, 16, 100, 0)
          : const EdgeInsets.fromLTRB(20, 16, 20, 0),
      padding: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(14),
        color: colorPrimary.withValues(alpha: 0.18),
      ),
      child: Row(
        mainAxisSize: MainAxisSize.min,
        spacing: 15,
        children: [
          InkWell(
            borderRadius: BorderRadius.circular(10),
            focusColor: transparent,
            highlightColor: transparent,
            hoverColor: transparent,
            splashColor: transparent,
            onTap: () async {
              wishlistProvider.selectLayout(Constant.courseType);
              wishlistProvider.clearWishList();
              _fetchData("3", 0);
            },
            child: Container(
              padding: const EdgeInsets.all(10),
              alignment: Alignment.center,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(10),
                color: wishlistProvider.layoutType == Constant.courseType
                    ? colorPrimary
                    : transparent,
              ),
              child: MyText(
                  color: wishlistProvider.layoutType == Constant.courseType
                      ? white
                      : Theme.of(context).colorScheme.surface,
                  text: "course",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textSmall,
                  fontwaight: FontWeight.w600,
                  maxline: 3,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            ),
          ),
          InkWell(
            borderRadius: BorderRadius.circular(10),
            focusColor: transparent,
            highlightColor: transparent,
            hoverColor: transparent,
            splashColor: transparent,
            onTap: () async {
              wishlistProvider.selectLayout(Constant.bookType);
              wishlistProvider.clearWishList();
              _fetchData("2", 0);
            },
            child: Container(
              padding: const EdgeInsets.all(10),
              alignment: Alignment.center,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(10),
                color: wishlistProvider.layoutType == Constant.bookType
                    ? colorPrimary
                    : transparent,
              ),
              child: MyText(
                  color: wishlistProvider.layoutType == Constant.bookType
                      ? white
                      : Theme.of(context).colorScheme.surface,
                  text: "book",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textSmall,
                  fontwaight: FontWeight.w600,
                  maxline: 3,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            ),
          ),
          InkWell(
            borderRadius: BorderRadius.circular(10),
            focusColor: transparent,
            highlightColor: transparent,
            hoverColor: transparent,
            splashColor: transparent,
            onTap: () async {
              wishlistProvider.selectLayout(Constant.blogType);
              wishlistProvider.clearWishList();
              _fetchData("1", 0);
            },
            child: Container(
              padding: const EdgeInsets.all(10),
              alignment: Alignment.center,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(10),
                color: wishlistProvider.layoutType == Constant.blogType
                    ? colorPrimary
                    : transparent,
              ),
              child: MyText(
                  color: wishlistProvider.layoutType == Constant.blogType
                      ? white
                      : Theme.of(context).colorScheme.surface,
                  text: "blog",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textSmall,
                  fontwaight: FontWeight.w600,
                  maxline: 3,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            ),
          ),
        ],
      ),
    );
  }

  Widget setLayout() {
    if (wishlistProvider.loading && !wishlistProvider.loadMore) {
      return Padding(
        padding: MediaQuery.of(context).size.width > 800
            ? const EdgeInsets.fromLTRB(100, 25, 100, 20)
            : const EdgeInsets.fromLTRB(20, 25, 20, 20),
        child: (wishlistProvider.layoutType == Constant.courseType)
            ? courseShimmer()
            : (wishlistProvider.layoutType == Constant.bookType)
                ? bookShimmer()
                : blogShimmer(),
      );
    } else {
      if (wishlistProvider.wishList != null &&
          (wishlistProvider.wishList?.length ?? 0) > 0) {
        return Padding(
          padding: MediaQuery.of(context).size.width > 800
              ? const EdgeInsets.fromLTRB(100, 25, 100, 20)
              : const EdgeInsets.fromLTRB(20, 25, 20, 20),
          child: (wishlistProvider.layoutType == Constant.courseType)
              ? _buildCourseData()
              : (wishlistProvider.layoutType == Constant.bookType)
                  ? buildBookItem()
                  : buildBlogItem(),
        );
      } else {
        return const NoData();
      }
    }
  }

/* Build Course Data */
  Widget _buildCourseData() {
    return Container(
      decoration: BoxDecoration(
        color: white,
        border: Border.all(
          width: 1,
          color: gray,
          style: BorderStyle.solid,
        ),
      ),
      child: Column(
        children: [
          Container(
            padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
            decoration: BoxDecoration(
                color: gray,
                border: Border.all(
                    width: 1, color: gray, style: BorderStyle.solid)),
            child: Row(
              children: [
                Expanded(
                  flex: 5,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: "products",
                      multilanguage: true,
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
                Expanded(
                  flex: 2,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      multilanguage: true,
                      text: "prices",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
                Expanded(
                  flex: 3,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      multilanguage: true,
                      text: "actions",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
              ],
            ),
          ),
          Padding(
            padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
            child: courseItem(),
          ),
        ],
      ),
    );
  }

  Widget courseItem() {
    return ListView.separated(
        shrinkWrap: true,
        physics: NeverScrollableScrollPhysics(),
        itemBuilder: (context, index) {
          return InkWell(
            onTap: () {
              Navigator.of(context).push(
                PageRouteBuilder(
                  transitionDuration: const Duration(milliseconds: 200),
                  pageBuilder: (BuildContext context,
                      Animation<double> animation,
                      Animation<double> secondaryAnimation) {
                    return WebDetail(
                        courseId:
                            wishlistProvider.wishList?[index].id.toString() ??
                                "");
                  },
                  transitionsBuilder: (BuildContext context,
                      Animation<double> animation,
                      Animation<double> secondaryAnimation,
                      Widget child) {
                    return Align(
                      child: FadeTransition(
                        opacity: animation,
                        child: child,
                      ),
                    );
                  },
                ),
              );
            },
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Expanded(
                  flex: 5,
                  child: Row(
                    spacing: 10,
                    children: [
                      MyNetworkImage(
                          imgWidth: 72,
                          imgHeight: 72,
                          fit: BoxFit.fill,
                          radius: 10,
                          imageUrl: wishlistProvider
                                  .wishList?[index].thumbnailImg
                                  .toString() ??
                              ""),
                      MyText(
                          color: Theme.of(context).colorScheme.surface,
                          text: wishlistProvider.wishList?[index].title
                                  .toString() ??
                              "",
                          fontsizeNormal: Dimens.textMedium,
                          fontwaight: FontWeight.w600,
                          maxline: 2,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                ),
                Expanded(
                  flex: 2,
                  child: MyText(
                      color: black,
                      text: (wishlistProvider.wishList?[index].isFree ?? 0) == 0
                          ? (wishlistProvider.wishList?[index].isUserBuy ??
                                      0) ==
                                  1
                              ? Locales.string(context, "free")
                              : "${Constant.currencyCode} ${wishlistProvider.wishList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
                Expanded(
                  flex: 3,
                  child: Row(
                    spacing: 10,
                    children: [
                      InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        onTap: () async {
                          if ((wishlistProvider.wishList?[index].isFree ?? 0) ==
                              0) {
                            if ((wishlistProvider.wishList?[index].isUserBuy ??
                                        0) ==
                                    0 &&
                                (wishlistProvider.wishList?[index].isCart ??
                                        0) ==
                                    0) {
                              await wishlistProvider.getAddToCart(
                                  index,
                                  wishlistProvider.wishList?[index].id
                                          .toString() ??
                                      "");
                            } else {
                              printLog("You already buy");
                            }
                          }
                        },
                        child: Container(
                          padding: EdgeInsets.fromLTRB(16, 6, 16, 6),
                          decoration: BoxDecoration(
                              color:
                                  (wishlistProvider.wishList?[index].isFree ??
                                              0) ==
                                          0
                                      ? (wishlistProvider.wishList?[index]
                                                          .isUserBuy ??
                                                      0) ==
                                                  0 &&
                                              (wishlistProvider.wishList?[index]
                                                          .isCart ??
                                                      0) ==
                                                  0
                                          ? colorPrimaryDark
                                          : gray
                                      : gray,
                              borderRadius: BorderRadius.circular(4)),
                          child: MyText(
                              color: white,
                              text: "add_to_cart",
                              multilanguage: true,
                              fontsizeNormal: Dimens.textMedium,
                              fontwaight: FontWeight.w600,
                              maxline: 2,
                              overflow: TextOverflow.ellipsis,
                              textalign: TextAlign.left,
                              fontstyle: FontStyle.normal),
                        ),
                      ),
                      InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        onTap: () async {
                          if (Utils.checkLoginUser(context)) {
                            await wishlistProvider.addremoveWatchLater(
                              "3",
                              index,
                              wishlistProvider.wishList?[index].id.toString() ??
                                  "",
                            );
                          }
                        },
                        child: Icon(
                          Icons.close_rounded,
                          size: 20,
                          color: gray,
                        ),
                      )
                    ],
                  ),
                )
              ],
            ),
          );
        },
        separatorBuilder: (context, index) {
          return SizedBox(height: 10);
        },
        itemCount: wishlistProvider.wishList?.length ?? 0);
  }

  Widget buildBookItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 3,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 8,
            height1200: 6,
            height800: 4,
            height400: 3),
        horizontalGridSpacing: 16,
        verticalGridSpacing: 12,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children:
            List.generate(wishlistProvider.wishList?.length ?? 0, (index) {
          return InkWell(
            onTap: () {
              Navigator.of(context).push(
                PageRouteBuilder(
                  pageBuilder: (context, animation, secondaryAnimation) =>
                      WebEbookDetails(
                    ebookId:
                        wishlistProvider.wishList?[index].id.toString() ?? "",
                    ebookName:
                        wishlistProvider.wishList?[index].title.toString() ??
                            "",
                  ),
                  transitionsBuilder:
                      (context, animation, secondaryAnimation, child) {
                    const begin = Offset(1.0, 0.0);
                    const end = Offset.zero;
                    const curve = Curves.ease;

                    var tween = Tween(begin: begin, end: end)
                        .chain(CurveTween(curve: curve));

                    return SlideTransition(
                      position: animation.drive(tween),
                      child: child,
                    );
                  },
                ),
              );
            },
            child: SizedBox(
              width: 150,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 4,
                children: [
                  Stack(
                    children: [
                      MyNetworkImage(
                          radius: 5,
                          imgWidth: width,
                          imgHeight: 155,
                          imageUrl: wishlistProvider
                                  .wishList?[index].thumbnailImg
                                  .toString() ??
                              "",
                          fit: BoxFit.fill),
                      Positioned.fill(
                        top: 5,
                        left: 10,
                        right: 10,
                        child: Align(
                          alignment: Alignment.topRight,
                          child: InkWell(
                            splashColor: transparent,
                            focusColor: transparent,
                            hoverColor: transparent,
                            onTap: () async {
                              if (Utils.checkLoginUser(context)) {
                                await wishlistProvider.addremoveWatchLater(
                                  "2",
                                  index,
                                  wishlistProvider.wishList?[index].id
                                          .toString() ??
                                      "",
                                );
                              }
                            },
                            child: Container(
                              padding: EdgeInsets.all(6),
                              decoration: BoxDecoration(
                                  color: gray, shape: BoxShape.circle),
                              child: Icon(
                                wishlistProvider.wishList?[index].isWishlist ==
                                        1
                                    ? Icons.favorite
                                    : Icons.favorite_border,
                                color: wishlistProvider
                                            .wishList?[index].isWishlist ==
                                        1
                                    ? red
                                    : white,
                              ),
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                  const SizedBox(height: 10),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text:
                          wishlistProvider.wishList?[index].title.toString() ??
                              "",
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textSmall,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      fontwaight: FontWeight.w600,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  MyText(
                      color: gray,
                      text: wishlistProvider.wishList?[index].tutorName
                              .toString() ??
                          "",
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textSmall,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      fontwaight: FontWeight.w600,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    children: [
                      MyRating(
                        size: 13,
                        rating: double.parse(
                          wishlistProvider.wishList?[index].avgRating
                                  .toString() ??
                              "",
                        ),
                        spacing: 3,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text: "${double.parse(
                            wishlistProvider.wishList?[index].avgRating
                                    .toString() ??
                                "",
                          )}",
                          fontsizeNormal: Dimens.textBigSmall,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (wishlistProvider.wishList?[index].isFree
                                      .toString() ??
                                  "") ==
                              "0"
                          ? "${Constant.currencyCode} ${wishlistProvider.wishList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          );
        }),
      ),
    );
  }

/* Blog Data */

  Widget buildBlogItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 300,
        minItemsPerRow: 1,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 6,
            height1200: 4,
            height800: 2,
            height400: 2),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children:
            List.generate(wishlistProvider.wishList?.length ?? 0, (index) {
          return InkWell(
            onTap: () {
              Navigator.of(context).push(
                PageRouteBuilder(
                  pageBuilder: (context, animation, secondaryAnimation) =>
                      WebBlogDetail(
                    blogId:
                        wishlistProvider.wishList?[index].id.toString() ?? "",
                  ),
                  transitionsBuilder:
                      (context, animation, secondaryAnimation, child) {
                    const begin = Offset(1.0, 0.0);
                    const end = Offset.zero;
                    const curve = Curves.ease;

                    var tween = Tween(begin: begin, end: end)
                        .chain(CurveTween(curve: curve));

                    return SlideTransition(
                      position: animation.drive(tween),
                      child: child,
                    );
                  },
                ),
              );
            },
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                Stack(
                  children: [
                    MyNetworkImage(
                        radius: 10,
                        imgWidth: width,
                        imgHeight: 155,
                        imageUrl: wishlistProvider.wishList?[index].image
                                .toString() ??
                            "",
                        fit: BoxFit.fill),
                    Positioned.fill(
                      top: 5,
                      left: 10,
                      right: 10,
                      child: Align(
                        alignment: Alignment.topRight,
                        child: InkWell(
                          splashColor: transparent,
                          focusColor: transparent,
                          hoverColor: transparent,
                          onTap: () async {
                            if (Utils.checkLoginUser(context)) {
                              await wishlistProvider.addremoveWatchLater(
                                "1",
                                index,
                                wishlistProvider.wishList?[index].id
                                        .toString() ??
                                    "",
                              );
                            }
                          },
                          child: Container(
                            padding: EdgeInsets.all(6),
                            decoration: BoxDecoration(
                                color: gray, shape: BoxShape.circle),
                            child: Icon(
                              wishlistProvider.wishList?[index].isWishlist == 1
                                  ? Icons.favorite
                                  : Icons.favorite_border,
                              color: wishlistProvider
                                          .wishList?[index].isWishlist ==
                                      1
                                  ? red
                                  : white,
                            ),
                          ),
                        ),
                      ),
                    ),
                  ],
                ),
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text: wishlistProvider.wishList?[index].title.toString() ??
                        "",
                    fontsizeNormal: Dimens.textBig,
                    fontsizeWeb: Dimens.textSmall,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                MyText(
                    color: gray,
                    text: wishlistProvider.wishList?[index].tutorName
                            .toString() ??
                        "",
                    fontsizeNormal: Dimens.textMedium,
                    fontsizeWeb: Dimens.textSmall,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
          );
        }),
      ),
    );
  }

  Widget courseShimmer() {
    return Container(
      decoration: BoxDecoration(
        color: white,
        border: Border.all(
          width: 1,
          color: gray,
          style: BorderStyle.solid,
        ),
      ),
      child: Column(
        children: [
          Container(
            padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
            decoration: BoxDecoration(
                color: gray,
                border: Border.all(
                    width: 1, color: gray, style: BorderStyle.solid)),
            child: Row(
              children: [
                Expanded(
                  flex: 5,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: "products",
                      multilanguage: true,
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
                Expanded(
                  flex: 2,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      multilanguage: true,
                      text: "prices",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
                Expanded(
                  flex: 3,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      multilanguage: true,
                      text: "actions",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
              ],
            ),
          ),
          Padding(
            padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
            child: ListView.separated(
                shrinkWrap: true,
                physics: NeverScrollableScrollPhysics(),
                itemBuilder: (context, index) {
                  return Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      Expanded(
                        flex: 5,
                        child: Row(
                          spacing: 10,
                          children: [
                            CustomWidget.roundcorner(height: 72, width: 72),
                            CustomWidget.roundcorner(height: 16, width: 150),
                          ],
                        ),
                      ),
                      Expanded(
                        flex: 2,
                        child: CustomWidget.roundcorner(height: 16, width: 80),
                      ),
                      Expanded(
                        flex: 3,
                        child: Row(
                          spacing: 10,
                          children: [
                            Container(
                              padding: EdgeInsets.fromLTRB(16, 6, 16, 6),
                              decoration: BoxDecoration(
                                  color: colorPrimaryDark,
                                  borderRadius: BorderRadius.circular(4)),
                              child: CustomWidget.roundcorner(
                                  height: 16, width: 80),
                            ),
                            CustomWidget.circular(height: 20, width: 20)
                          ],
                        ),
                      )
                    ],
                  );
                },
                separatorBuilder: (context, index) {
                  return SizedBox(height: 10);
                },
                itemCount: 10),
          ),
        ],
      ),
    );
  }

  Widget bookShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 3,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 8,
            height1200: 6,
            height800: 4,
            height400: 3),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(10, (index) {
          return SizedBox(
            width: 140,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                CustomWidget.roundrectborder(
                  width: width ?? 0,
                  height: 155,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
              ],
            ),
          );
        }),
      ),
    );
  }

  Widget blogShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 300,
        minItemsPerRow: 1,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 6,
            height1200: 4,
            height800: 2,
            height400: 2),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(10, (index) {
          return Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 4,
            children: [
              Stack(
                children: [
                  CustomWidget.roundcorner(width: width ?? 0, height: 155),
                  Positioned.fill(
                    top: 5,
                    left: 10,
                    right: 10,
                    child: Align(
                      alignment: Alignment.topRight,
                      child: CustomWidget.circular(width: 30, height: 30),
                    ),
                  ),
                ],
              ),
              CustomWidget.roundcorner(width: width ?? 0.0, height: 16),
              CustomWidget.roundcorner(width: (width ?? 0.0) * 0.5, height: 14),
            ],
          );
        }),
      ),
    );
  }
}
