import 'package:dotted_border/dotted_border.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/provider/viewallprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webblogdetail.dart';
import 'package:prakah/webpages/webdetails.dart';
import 'package:prakah/webpages/webebookdetail.dart';
import 'package:prakah/webpages/websearch.dart';
import 'package:prakah/webpages/webtutorprofile.dart';
import 'package:prakah/webpages/webvideobyidviewall.dart';
import 'package:prakah/webwidget/footerweb.dart';
import 'package:prakah/webwidget/interactivecontainer.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';
import '../model/sectiondetailmodel.dart';

class WebViewAll extends StatefulWidget {
  final String? contentId, title, viewAllType, screenLayout;
  const WebViewAll(
      {super.key,
      this.contentId,
      this.viewAllType,
      this.title,
      this.screenLayout});

  @override
  State<WebViewAll> createState() => WebViewAllState();
}

class WebViewAllState extends State<WebViewAll> {
  late ViewAllProvider viewAllProvider = ViewAllProvider();
  PageController pageController = PageController();
  final searchController = TextEditingController();
  final ScrollController _scrollController = ScrollController();
  double? width;
  double? height;

  List<Color> colorList = [
    colorPrimary,
    red,
    green,
    gray,
    colorPrimaryDark,
    colorAccent,
  ];
  @override
  void initState() {
    super.initState();
    viewAllProvider = Provider.of<ViewAllProvider>(context, listen: false);

    _scrollController.addListener(_scrollListener);
    _fetchSectionDetail(0);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (viewAllProvider.currentPage ?? 0) < (viewAllProvider.totalPage ?? 0)) {
      viewAllProvider.setLoadMore(true);
      _fetchSectionDetail(viewAllProvider.currentPage ?? 0);
    }
  }

  Future<void> _fetchSectionDetail(int? nextPage) async {
    await viewAllProvider.getSeactionDetail(
        widget.contentId.toString(), (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();
    viewAllProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.of(context).size.width;
    height = MediaQuery.of(context).size.height;
    return _buildSearchHome();
  }

  Widget _buildSearchHome() {
    return Consumer<SearchProvider>(builder: (context, homeprovider, child) {
      if (homeprovider.isSearch == "0") {
        return Scaffold(
          appBar: Utils.webMainAppbar(controller: searchController),
          body: _buildAllData(),
        );
      } else {
        return WebSearch(
          searchController: searchController,
        );
      }
    });
  }

  Widget _buildAllData() {
    return Consumer<ViewAllProvider>(
        builder: (context, viewallprovider, child) {
      return Utils.hoverItemWithPage(
        myWidget: SingleChildScrollView(
          controller: _scrollController,
          physics: const AlwaysScrollableScrollPhysics(),
          child: Column(
            children: [
              Utils.buildWebDetailsAppBar(
                  context: context,
                  title: widget.title ?? "",
                  multilanguage: false),
              selectLayout(),
              buildSection(),
              const FooterWeb(),
            ],
          ),
        ),
      );
    });
  }

  Widget selectLayout() {
    if (widget.viewAllType == "section" &&
        widget.screenLayout != "blog" &&
        widget.screenLayout != "tutor" &&
        widget.screenLayout != "category" &&
        widget.screenLayout != "language" &&
        widget.screenLayout != "book") {
      return Container(
        width: MediaQuery.of(context).size.width,
        alignment: Alignment.centerLeft,
        padding: MediaQuery.of(context).size.width > 800
            ? const EdgeInsets.fromLTRB(200, 20, 200, 20)
            : const EdgeInsets.fromLTRB(20, 20, 20, 20),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            InkWell(
              hoverColor: transparent,
              highlightColor: transparent,
              splashColor: transparent,
              focusColor: transparent,
              onTap: () async {
                await viewAllProvider.selectLayout(Constant.grid);
              },
              child: Container(
                padding: const EdgeInsets.all(12),
                decoration: BoxDecoration(
                  shape: BoxShape.circle,
                  color: viewAllProvider.layoutType == Constant.grid
                      ? colorPrimary
                      : transparent,
                ),
                child: MyImage(
                  width: 20,
                  height: 20,
                  imagePath: "ic_grid.png",
                  color: viewAllProvider.layoutType == Constant.grid
                      ? white
                      : gray,
                ),
              ),
            ),
            const SizedBox(width: 15),
            InkWell(
              onTap: () async {
                await viewAllProvider.selectLayout(Constant.square);
              },
              child: Padding(
                padding: const EdgeInsets.all(8),
                child: MyImage(
                  width: 20,
                  height: 20,
                  imagePath: "ic_square.png",
                  color: viewAllProvider.layoutType == Constant.square
                      ? colorPrimary
                      : gray,
                ),
              ),
            ),
            const SizedBox(width: 15),
            InkWell(
              hoverColor: transparent,
              highlightColor: transparent,
              splashColor: transparent,
              focusColor: transparent,
              onTap: () async {
                await viewAllProvider.selectLayout(Constant.list);
              },
              child: Container(
                padding: const EdgeInsets.all(12),
                decoration: BoxDecoration(
                  shape: BoxShape.circle,
                  color: viewAllProvider.layoutType == Constant.list
                      ? colorPrimary
                      : transparent,
                ),
                child: MyImage(
                  width: 20,
                  height: 20,
                  imagePath: "ic_list.png",
                  color: viewAllProvider.layoutType == Constant.list
                      ? white
                      : gray,
                ),
              ),
            ),
          ],
        ),
      );
    } else {
      return const SizedBox.shrink();
    }
  }

  Widget buildSection() {
    if (widget.screenLayout == "blog") {
      return buildBlog();
    } else if (widget.screenLayout == "book") {
      return buildBook();
    } else if (widget.screenLayout == "category" ||
        widget.screenLayout == "language") {
      return buildCategoryAndLanguage();
    } else if (widget.screenLayout == "tutor") {
      return buildTutor();
    } else {
      return buildSectionItem();
    }
  }

  Widget buildSectionItem() {
    if (viewAllProvider.loading && !viewAllProvider.loadmore) {
      return buildShimmer();
    } else {
      if (viewAllProvider.sectionDetailModel.status == 200 &&
          viewAllProvider.sectionDetailList != null) {
        if ((viewAllProvider.sectionDetailList?.length ?? 0) > 0) {
          return Padding(
            padding: MediaQuery.of(context).size.width > 800
                ? const EdgeInsets.fromLTRB(200, 20, 100, 20)
                : const EdgeInsets.fromLTRB(20, 25, 20, 25),
            child: Column(
              children: [
                MediaQuery.removePadding(
                  context: context,
                  removeTop: true,
                  child: ResponsiveGridList(
                    minItemWidth: 120,
                    minItemsPerRow: itemCount(),
                    maxItemsPerRow: itemCount(),
                    horizontalGridSpacing: 5,
                    verticalGridSpacing: 10,
                    listViewBuilderOptions: ListViewBuilderOptions(
                      scrollDirection: Axis.vertical,
                      shrinkWrap: true,
                      physics: const BouncingScrollPhysics(),
                    ),
                    children: List.generate(
                        viewAllProvider.sectionDetailList?.length ?? 0,
                        (index) {
                      return buildSectionLayout(index);
                    }),
                  ),
                ),
                if (viewAllProvider.loadmore)
                  Container(
                    height: 50,
                    margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                    child: Utils.pageLoader(),
                  )
                else
                  const SizedBox.shrink(),
              ],
            ),
          );
        } else {
          return const NoData();
        }
      } else {
        return const NoData();
      }
    }
  }

  /* Section Layout's Start */

  Widget buildSectionLayout(int index) {
    if (viewAllProvider.layoutType == Constant.grid) {
      return bigPortrait(
          index: index, courseList: viewAllProvider.sectionDetailList ?? []);
    } else if (viewAllProvider.layoutType == Constant.square) {
      return square(
          index: index,
          sectionDetailList: viewAllProvider.sectionDetailList ?? []);
    } else {
      return listView(
          index: index,
          sectionDetailList: viewAllProvider.sectionDetailList ?? []);
    }
  }

  /* Listview  */
  Widget listView(
      {required int index, required List<Result>? sectionDetailList}) {
    return InkWell(
      hoverColor: transparent,
      highlightColor: transparent,
      splashColor: transparent,
      focusColor: transparent,
      onTap: () {
        Navigator.of(context).push(
          PageRouteBuilder(
            transitionDuration: const Duration(milliseconds: 200),
            pageBuilder: (BuildContext context, Animation<double> animation,
                Animation<double> secondaryAnimation) {
              return WebDetail(
                  courseId: sectionDetailList?[index].id.toString() ?? "");
            },
            transitionsBuilder: (BuildContext context,
                Animation<double> animation,
                Animation<double> secondaryAnimation,
                Widget child) {
              return Align(
                child: FadeTransition(
                  opacity: animation,
                  child: child,
                ),
              );
            },
          ),
        );
      },
      child: InteractiveContainer(child: (isHovered) {
        return Row(
          children: [
            MyNetworkImage(
              imgWidth: 120,
              imgHeight: 160,
              radius: 24,
              imageUrl: sectionDetailList?[index].landscapeImg.toString() ?? "",
              fit: BoxFit.fill,
            ),
            const SizedBox(width: 10),
            Expanded(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: sectionDetailList?[index].title.toString() ?? "",
                      fontsizeNormal: Dimens.textBigSmall,
                      fontwaight: FontWeight.w700,
                      maxline: 1,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    spacing: 4,
                    children: [
                      Icon(
                        Icons.person_outline_rounded,
                        size: 16,
                        color: gray,
                      ),
                      Expanded(
                        child: MyText(
                            color: green,
                            text: sectionDetailList?[index]
                                    .tutorName
                                    .toString() ??
                                "",
                            fontsizeNormal: Dimens.textMedium,
                            fontsizeWeb: Dimens.textSmall,
                            fontwaight: FontWeight.w500,
                            maxline: 1,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                      ),
                    ],
                  ),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: sectionDetailList?[index].description.toString() ??
                          "",
                      fontsizeNormal: Dimens.textBigSmall,
                      fontwaight: FontWeight.w400,
                      maxline: 3,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      MyText(
                          color: gray,
                          text: Utils.kmbGenerator(int.parse(
                              sectionDetailList?[index].totalView.toString() ??
                                  "")),
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      const SizedBox(width: 5),
                      MyText(
                          color: gray,
                          text: "students",
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          multilanguage: true,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  const SizedBox(height: 8),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: (sectionDetailList?[index].isFree ?? 0) == 0 &&
                              (sectionDetailList?[index].isUserBuy ?? 0) == 0
                          ? "${Constant.currencyCode} ${sectionDetailList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          ],
        );
      }),
    );
  }

  /* Square */
  Widget square(
      {required int index, required List<Result>? sectionDetailList}) {
    return InkWell(
      hoverColor: transparent,
      highlightColor: transparent,
      splashColor: transparent,
      focusColor: transparent,
      onTap: () {
        Navigator.of(context).push(
          PageRouteBuilder(
            transitionDuration: const Duration(milliseconds: 200),
            pageBuilder: (BuildContext context, Animation<double> animation,
                Animation<double> secondaryAnimation) {
              return WebDetail(
                  courseId: sectionDetailList?[index].id.toString() ?? "");
            },
            transitionsBuilder: (BuildContext context,
                Animation<double> animation,
                Animation<double> secondaryAnimation,
                Widget child) {
              return Align(
                child: FadeTransition(
                  opacity: animation,
                  child: child,
                ),
              );
            },
          ),
        );
      },
      child: Container(
        width: 140,
        margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
        child: Column(
          children: [
            Stack(
              children: [
                AnimatedScale(
                  curve: Curves.easeInOut,
                  duration: const Duration(milliseconds: 500),
                  scale: 1,
                  child: MyNetworkImage(
                      imgWidth: MediaQuery.of(context).size.width,
                      imgHeight: 145,
                      radius: 24,
                      fit: BoxFit.fill,
                      islandscap: true,
                      imageUrl:
                          sectionDetailList?[index].thumbnailImg.toString() ??
                              ""),
                ),
                (sectionDetailList?[index].isFree.toString() ?? "") == "1"
                    ? SizedBox.shrink()
                    : Positioned(
                        left: 10,
                        top: 10,
                        child: IntrinsicWidth(
                          // Wrap with IntrinsicWidth
                          child: Container(
                            padding: EdgeInsets.symmetric(
                                horizontal: 8, vertical: 4),
                            decoration: BoxDecoration(
                              color: colorAccent,
                              borderRadius: BorderRadius.circular(4),
                            ),
                            child: Row(
                              mainAxisSize: MainAxisSize
                                  .min, // Ensures the Row only takes necessary space
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Icon(
                                  Icons.workspace_premium_outlined,
                                  size: 14,
                                  color: white,
                                ),
                                SizedBox(
                                    width: 5), // Spacing between icon and text
                                Flexible(
                                  fit: FlexFit.loose,
                                  child: MyText(
                                    color: white,
                                    text: "premium",
                                    maxline: 1,
                                    multilanguage: true,
                                    fontsizeNormal: Dimens.textMedium,
                                    fontwaight: FontWeight.w500,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      )
              ],
            ),
            const SizedBox(height: 8),
            Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text: sectionDetailList?[index].title.toString() ?? "",
                    fontsizeNormal: Dimens.textBigSmall,
                    fontsizeWeb: Dimens.textMedium,
                    fontwaight: FontWeight.w700,
                    maxline: 1,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                const SizedBox(height: 5),
                Row(
                  mainAxisAlignment: MainAxisAlignment.start,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  spacing: 4,
                  children: [
                    Icon(
                      Icons.person_outline_rounded,
                      size: 16,
                      color: gray,
                    ),
                    MyText(
                        color: green,
                        text: sectionDetailList?[index].tutorName.toString() ??
                            "",
                        fontsizeNormal: Dimens.textMedium,
                        fontsizeWeb: Dimens.textSmall,
                        fontwaight: FontWeight.w500,
                        maxline: 1,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ],
                ),
                const SizedBox(height: 5),
                MyText(
                    color: gray,
                    text:
                        sectionDetailList?[index].description.toString() ?? "",
                    fontsizeNormal: Dimens.textMedium,
                    fontsizeWeb: Dimens.textSmall,
                    fontwaight: FontWeight.w500,
                    maxline: 3,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                Row(
                  children: [
                    MyRating(
                      size: 18,
                      rating: double.parse(
                          (sectionDetailList?[index].avgRating.toString() ??
                              "")),
                      spacing: 3,
                    ),
                    const SizedBox(width: 5),
                    MyText(
                        color: colorAccent,
                        text:
                            "${double.parse(sectionDetailList?[index].avgRating.toString() ?? "")}",
                        fontsizeNormal: Dimens.textTitle,
                        fontsizeWeb: Dimens.textTitle,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ],
                ),
                MyText(
                    color: black,
                    text: (sectionDetailList?[index].isFree ?? 0) == 0 &&
                            (sectionDetailList?[index].isUserBuy ?? 0) == 0
                        ? "${Constant.currencyCode} ${sectionDetailList?[index].price.toString() ?? ""}"
                        : Locales.string(context, "free"),
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w500,
                    maxline: 1,
                    multilanguage: false,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
          ],
        ),
      ),
    );
  }

  /* Big Portrait */
  Widget bigPortrait({required int index, required List<Result>? courseList}) {
    return InteractiveContainer(child: (isHovered) {
      return InkWell(
        splashColor: transparent,
        focusColor: transparent,
        hoverColor: transparent,
        highlightColor: transparent,
        onTap: () {
          Navigator.of(context).push(
            PageRouteBuilder(
              transitionDuration: const Duration(milliseconds: 200),
              pageBuilder: (BuildContext context, Animation<double> animation,
                  Animation<double> secondaryAnimation) {
                return WebDetail(
                    courseId: courseList?[index].id.toString() ?? "");
              },
              transitionsBuilder: (BuildContext context,
                  Animation<double> animation,
                  Animation<double> secondaryAnimation,
                  Widget child) {
                return Align(
                  child: FadeTransition(
                    opacity: animation,
                    child: child,
                  ),
                );
              },
            ),
          );
        },
        child: Container(
          width: 200,
          margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
          child: Column(
            children: [
              Stack(
                children: [
                  AnimatedScale(
                    curve: Curves.easeInOut,
                    duration: const Duration(milliseconds: 500),
                    scale: isHovered ? 1.03 : 1,
                    child: MyNetworkImage(
                        imgWidth: MediaQuery.of(context).size.width,
                        imgHeight: 145,
                        radius: 24,
                        fit: BoxFit.fill,
                        islandscap: true,
                        imageUrl:
                            courseList?[index].thumbnailImg.toString() ?? ""),
                  ),
                  (courseList?[index].isFree.toString() ?? "") == "1"
                      ? SizedBox.shrink()
                      : Positioned(
                          left: 10,
                          top: 10,
                          child: IntrinsicWidth(
                            // Wrap with IntrinsicWidth
                            child: Container(
                              padding: EdgeInsets.symmetric(
                                  horizontal: 8, vertical: 4),
                              decoration: BoxDecoration(
                                color: colorAccent,
                                borderRadius: BorderRadius.circular(4),
                              ),
                              child: Row(
                                mainAxisSize: MainAxisSize
                                    .min, // Ensures the Row only takes necessary space
                                crossAxisAlignment: CrossAxisAlignment.center,
                                children: [
                                  Icon(
                                    Icons.workspace_premium_outlined,
                                    size: 14,
                                    color: white,
                                  ),
                                  SizedBox(
                                      width:
                                          5), // Spacing between icon and text
                                  Flexible(
                                    fit: FlexFit.loose,
                                    child: MyText(
                                      color: white,
                                      text: "premium",
                                      maxline: 1,
                                      multilanguage: true,
                                      fontsizeNormal: Dimens.textMedium,
                                      fontwaight: FontWeight.w500,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ),
                        )
                ],
              ),
              const SizedBox(height: 8),
              Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: courseList?[index].title.toString() ?? "",
                      fontsizeNormal: Dimens.textBigSmall,
                      fontsizeWeb: Dimens.textMedium,
                      fontwaight: FontWeight.w700,
                      maxline: 1,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  const SizedBox(height: 5),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    spacing: 4,
                    children: [
                      Icon(
                        Icons.person_outline_rounded,
                        size: 16,
                        color: gray,
                      ),
                      MyText(
                          color: green,
                          text: courseList?[index].tutorName.toString() ?? "",
                          fontsizeNormal: Dimens.textMedium,
                          fontsizeWeb: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  const SizedBox(height: 5),
                  MyText(
                      color: gray,
                      text: courseList?[index].description.toString() ?? "",
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textSmall,
                      fontwaight: FontWeight.w500,
                      maxline: 3,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    children: [
                      MyRating(
                        size: 18,
                        rating: double.parse(
                            (courseList?[index].avgRating.toString() ?? "")),
                        spacing: 3,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text:
                              "${double.parse(courseList?[index].avgRating.toString() ?? "")}",
                          fontsizeNormal: Dimens.textTitle,
                          fontsizeWeb: Dimens.textTitle,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (courseList?[index].isFree ?? 0) == 0 &&
                              (courseList?[index].isUserBuy ?? 0) == 0
                          ? "${Constant.currencyCode} ${courseList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textSmall,
                      fontwaight: FontWeight.w500,
                      maxline: 1,
                      multilanguage: false,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ],
          ),
        ),
      );
    });
  }

  /* Section Layout's End */

/* Blog Item  */

  Widget buildBlog() {
    if (viewAllProvider.loading && !viewAllProvider.loadmore) {
      return buildShimmer();
    } else {
      if (viewAllProvider.sectionDetailModel.status == 200 &&
          viewAllProvider.sectionDetailList != null) {
        if ((viewAllProvider.sectionDetailList?.length ?? 0) > 0) {
          return Padding(
            padding: MediaQuery.of(context).size.width > 800
                ? const EdgeInsets.fromLTRB(200, 20, 100, 20)
                : const EdgeInsets.fromLTRB(20, 25, 20, 25),
            child: Column(
              children: [
                MediaQuery.removePadding(
                  context: context,
                  removeTop: true,
                  child: ResponsiveGridList(
                    minItemWidth: 120,
                    minItemsPerRow: Utils.customCrossAxisCount(
                        context: context,
                        height1600: 6,
                        height1200: 5,
                        height800: 3,
                        height400: 2),
                    maxItemsPerRow: Utils.customCrossAxisCount(
                        context: context,
                        height1600: 6,
                        height1200: 5,
                        height800: 3,
                        height400: 2),
                    horizontalGridSpacing: 5,
                    verticalGridSpacing: 10,
                    listViewBuilderOptions: ListViewBuilderOptions(
                      scrollDirection: Axis.vertical,
                      shrinkWrap: true,
                      physics: const BouncingScrollPhysics(),
                    ),
                    children: List.generate(
                        viewAllProvider.sectionDetailList?.length ?? 0,
                        (index) {
                      return buildBlogItem(
                          index: index,
                          blogList: viewAllProvider.sectionDetailList ?? []);
                    }),
                  ),
                ),
                if (viewAllProvider.loadmore)
                  Container(
                    height: 50,
                    margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                    child: Utils.pageLoader(),
                  )
                else
                  const SizedBox.shrink(),
              ],
            ),
          );
        } else {
          return const NoData();
        }
      } else {
        return const NoData();
      }
    }
  }

  Widget buildBlogItem({required int index, required List<Result>? blogList}) {
    return InkWell(
      focusColor: transparent,
      highlightColor: transparent,
      hoverColor: transparent,
      splashColor: transparent,
      onTap: () {
        Navigator.of(context).push(
          PageRouteBuilder(
            transitionDuration: const Duration(milliseconds: 200),
            pageBuilder: (BuildContext context, Animation<double> animation,
                Animation<double> secondaryAnimation) {
              return WebBlogDetail(
                  blogId: blogList?[index].id.toString() ?? "");
            },
            transitionsBuilder: (BuildContext context,
                Animation<double> animation,
                Animation<double> secondaryAnimation,
                Widget child) {
              return Align(
                child: FadeTransition(
                  opacity: animation,
                  child: child,
                ),
              );
            },
          ),
        );
      },
      child: Container(
        width: 200,
        margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
        child: Column(
          children: [
            ClipRRect(
              borderRadius: BorderRadius.circular(10),
              child: MyNetworkImage(
                  imgWidth: MediaQuery.sizeOf(context).width,
                  imgHeight: 110,
                  fit: BoxFit.fill,
                  islandscap: true,
                  imageUrl: blogList?[index].image.toString() ?? ""),
            ),
            const SizedBox(height: 8),
            Expanded(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: blogList?[index].title.toString() ?? "",
                      fontsizeNormal: Dimens.textBigSmall,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  const SizedBox(height: 5),
                  MyText(
                      color: gray,
                      text: Utils.timeAgoCustom(
                        DateTime.parse(
                            blogList?[index].createdAt.toString() ?? ""),
                      ),
                      fontsizeNormal: Dimens.textSmall,
                      fontwaight: FontWeight.w600,
                      maxline: 3,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

/* Book Item */

  Widget buildBook() {
    if (viewAllProvider.loading && !viewAllProvider.loadmore) {
      return buildShimmer();
    } else {
      if (viewAllProvider.sectionDetailModel.status == 200 &&
          viewAllProvider.sectionDetailList != null) {
        if ((viewAllProvider.sectionDetailList?.length ?? 0) > 0) {
          return Padding(
            padding: MediaQuery.of(context).size.width > 1000
                ? const EdgeInsets.fromLTRB(200, 20, 100, 20)
                : const EdgeInsets.fromLTRB(20, 25, 20, 25),
            child: Column(
              children: [
                MediaQuery.removePadding(
                  context: context,
                  removeTop: true,
                  child: ResponsiveGridList(
                    minItemWidth: 120,
                    minItemsPerRow: Utils.customCrossAxisCount(
                        context: context,
                        height1600: 9,
                        height1200: 8,
                        height800: 6,
                        height400: 3),
                    maxItemsPerRow: Utils.customCrossAxisCount(
                        context: context,
                        height1600: 9,
                        height1200: 8,
                        height800: 6,
                        height400: 3),
                    horizontalGridSpacing: 10,
                    verticalGridSpacing: 10,
                    listViewBuilderOptions: ListViewBuilderOptions(
                      scrollDirection: Axis.vertical,
                      shrinkWrap: true,
                      physics: const BouncingScrollPhysics(),
                    ),
                    children: List.generate(
                        viewAllProvider.sectionDetailList?.length ?? 0,
                        (index) {
                      return buildBookItem(
                          index: index,
                          bookList: viewAllProvider.sectionDetailList ?? []);
                    }),
                  ),
                ),
                if (viewAllProvider.loadmore)
                  Container(
                    height: 50,
                    margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                    child: Utils.pageLoader(),
                  )
                else
                  const SizedBox.shrink(),
              ],
            ),
          );
        } else {
          return const NoData();
        }
      } else {
        return const NoData();
      }
    }
  }

  Widget buildBookItem({required int index, required List<Result>? bookList}) {
    return InkWell(
      focusColor: transparent,
      highlightColor: transparent,
      hoverColor: transparent,
      splashColor: transparent,
      onTap: () {
        Navigator.of(context).push(
          PageRouteBuilder(
            pageBuilder: (context, animation, secondaryAnimation) =>
                WebEbookDetails(
              ebookId: bookList?[index].id.toString() ?? "",
              ebookName: bookList?[index].title.toString() ?? "",
            ),
            transitionsBuilder:
                (context, animation, secondaryAnimation, child) {
              const begin = Offset(1.0, 0.0);
              const end = Offset.zero;
              const curve = Curves.ease;

              var tween =
                  Tween(begin: begin, end: end).chain(CurveTween(curve: curve));

              return SlideTransition(
                position: animation.drive(tween),
                child: child,
              );
            },
          ),
        );
      },
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          MyNetworkImage(
              radius: 16,
              imgWidth: width,
              imgHeight: 170,
              imageUrl: bookList?[index].thumbnailImg.toString() ?? "",
              fit: BoxFit.cover),
          const SizedBox(height: 10),
          MyText(
              color: Theme.of(context).colorScheme.surface,
              text: bookList?[index].title.toString() ?? "",
              fontsizeNormal: Dimens.textSmall,
              fontsizeWeb: Dimens.textSmall,
              maxline: 1,
              fontwaight: FontWeight.w600,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
          const SizedBox(height: 5),
          MyText(
              color: gray,
              text: bookList?[index].tutorName.toString() ?? "",
              fontsizeNormal: Dimens.textSmall,
              fontsizeWeb: Dimens.textSmall,
              maxline: 2,
              fontwaight: FontWeight.w600,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
          const SizedBox(height: 5),
          Row(
            children: [
              MyRating(
                size: 13,
                rating:
                    double.parse((bookList?[index].avgRating.toString() ?? "")),
                spacing: 3,
              ),
              const SizedBox(width: 5),
              MyText(
                  color: colorAccent,
                  text: "(${bookList?[index].avgRating.toString() ?? ""})",
                  fontsizeNormal: Dimens.textBigSmall,
                  fontwaight: FontWeight.w600,
                  maxline: 1,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            ],
          ),
          MyText(
              color: black,
              text: (bookList?[index].isFree ?? 0) == 0 &&
                      (bookList?[index].isUserBuy ?? 0) == 0
                  ? "${Constant.currencyCode} ${bookList?[index].price.toString() ?? ""}"
                  : Locales.string(context, "free"),
              fontsizeNormal: Dimens.textBigSmall,
              fontwaight: FontWeight.w600,
              maxline: 1,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
        ],
      ),
    );
  }

/* Category And Language Layout Item */

  Widget buildCategoryAndLanguage() {
    if (viewAllProvider.loading && !viewAllProvider.loadmore) {
      return buildCategoryAndLanguageShimmer();
    } else {
      if (viewAllProvider.sectionDetailModel.status == 200 &&
          viewAllProvider.sectionDetailList != null) {
        if ((viewAllProvider.sectionDetailList?.length ?? 0) > 0) {
          return Column(
            children: [
              MediaQuery.removePadding(
                context: context,
                removeTop: true,
                child: ResponsiveGridList(
                  minItemWidth: 200,
                  minItemsPerRow: Utils.customCrossAxisCount(
                      context: context,
                      height1600: 6,
                      height1200: 4,
                      height800: 3,
                      height400: 3),
                  maxItemsPerRow: Utils.customCrossAxisCount(
                      context: context,
                      height1600: 8,
                      height1200: 6,
                      height800: 4,
                      height400: 4),
                  horizontalGridMargin:
                      MediaQuery.of(context).size.width > 800 ? 90 : 20,
                  verticalGridMargin: 20,
                  verticalGridSpacing: 16,
                  horizontalGridSpacing: 16,
                  listViewBuilderOptions: ListViewBuilderOptions(
                      shrinkWrap: true,
                      physics: NeverScrollableScrollPhysics(),
                      padding: EdgeInsets.zero),
                  children: List.generate(
                      viewAllProvider.sectionDetailList?.length ?? 0, (index) {
                    return buildCategoryAndLangageItem(
                        index: index,
                        categoryList: viewAllProvider.sectionDetailList ?? []);
                  }),
                ),
              ),
              if (viewAllProvider.loadmore)
                Container(
                  height: 50,
                  margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                  child: Utils.pageLoader(),
                )
              else
                const SizedBox.shrink(),
            ],
          );
        } else {
          return const NoData();
        }
      } else {
        return const NoData();
      }
    }
  }

  Widget buildCategoryAndLangageItem(
      {required int index, required List<Result>? categoryList}) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      highlightColor: transparent,
      onTap: () {
        Navigator.of(context).push(
          PageRouteBuilder(
            transitionDuration: const Duration(milliseconds: 200),
            pageBuilder: (BuildContext context, Animation<double> animation,
                Animation<double> secondaryAnimation) {
              return WebVideoByIdViewAll(
                title: categoryList?[index].name.toString() ?? "",
                contentId: categoryList?[index].id.toString() ?? "",
                apiType: widget.screenLayout,
              );
            },
            transitionsBuilder: (BuildContext context,
                Animation<double> animation,
                Animation<double> secondaryAnimation,
                Widget child) {
              return Align(
                child: FadeTransition(
                  opacity: animation,
                  child: child,
                ),
              );
            },
          ),
        );
      },
      child: Container(
        padding: const EdgeInsets.fromLTRB(14, 10, 14, 10),
        alignment: Alignment.center,
        decoration: BoxDecoration(
          color: colorList[index % colorList.length].withValues(alpha: 0.16),
          borderRadius: const BorderRadius.all(Radius.circular(10)),
        ),
        child: Row(
          spacing: 10,
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.center,
          mainAxisSize: MainAxisSize.min,
          children: [
            DottedBorder(
              child: MyNetworkImage(
                imageUrl: categoryList?[index].image.toString() ?? "",
                fit: BoxFit.cover,
                radius: 200,
                imgHeight: 40,
                imgWidth: 40,
              ),
            ),
            Expanded(
                child: MyText(
                    color: black,
                    text: categoryList?[index].name.toString() ?? "",
                    fontsizeNormal: Dimens.textMedium,
                    maxline: 2,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.center,
                    fontstyle: FontStyle.normal))
          ],
        ),
      ),
    );
  }

  Widget buildCategoryAndLanguageShimmer() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(200, 20, 100, 20)
          : const EdgeInsets.fromLTRB(20, 25, 20, 25),
      child: MediaQuery.removePadding(
        context: context,
        removeTop: true,
        child: ResponsiveGridList(
          minItemWidth: 120,
          minItemsPerRow: Utils.customCrossAxisCount(
              context: context,
              height1600: 8,
              height1200: 6,
              height800: 4,
              height400: 2),
          maxItemsPerRow: Utils.customCrossAxisCount(
              context: context,
              height1600: 8,
              height1200: 6,
              height800: 4,
              height400: 2),
          horizontalGridSpacing: 2,
          verticalGridSpacing: 2,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
          ),
          children: List.generate(40, (index) {
            return const CustomWidget.circleborder(height: 40);
          }),
        ),
      ),
    );
  }

/* Tutor Item */

  Widget buildTutor() {
    if (viewAllProvider.loading && !viewAllProvider.loadmore) {
      return buildTutorShimmer();
    } else {
      if (viewAllProvider.sectionDetailModel.status == 200 &&
          viewAllProvider.sectionDetailList != null) {
        if ((viewAllProvider.sectionDetailList?.length ?? 0) > 0) {
          return Padding(
            padding: MediaQuery.of(context).size.width > 800
                ? const EdgeInsets.fromLTRB(200, 20, 100, 20)
                : const EdgeInsets.fromLTRB(20, 25, 20, 25),
            child: Column(
              children: [
                MediaQuery.removePadding(
                  context: context,
                  removeTop: true,
                  child: ResponsiveGridList(
                    minItemWidth: 240,
                    minItemsPerRow: 2,
                    maxItemsPerRow: Utils.customCrossAxisCount(
                        context: context,
                        height1600: 6,
                        height1200: 4,
                        height800: 3,
                        height400: 2),
                    horizontalGridSpacing: 10,
                    verticalGridSpacing: 10,
                    listViewBuilderOptions: ListViewBuilderOptions(
                      scrollDirection: Axis.vertical,
                      shrinkWrap: true,
                      physics: const BouncingScrollPhysics(),
                    ),
                    children: List.generate(
                        viewAllProvider.sectionDetailList?.length ?? 0,
                        (index) {
                      return buildTutorItem(
                          index: index,
                          tutorList: viewAllProvider.sectionDetailList ?? []);
                    }),
                  ),
                ),
                if (viewAllProvider.loadmore)
                  Container(
                    height: 50,
                    margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                    child: Utils.pageLoader(),
                  )
                else
                  const SizedBox.shrink(),
              ],
            ),
          );
        } else {
          return const NoData();
        }
      } else {
        return const NoData();
      }
    }
  }

  Widget buildTutorItem(
      {required int index, required List<Result>? tutorList}) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      highlightColor: transparent,
      onTap: () {
        Navigator.of(context).push(
          PageRouteBuilder(
            pageBuilder: (context, animation, secondaryAnimation) =>
                WebTutorProfile(
              tutorid: tutorList?[index].id.toString() ?? "",
            ),
            transitionsBuilder:
                (context, animation, secondaryAnimation, child) {
              const begin = Offset(1.0, 0.0);
              const end = Offset.zero;
              const curve = Curves.ease;

              var tween =
                  Tween(begin: begin, end: end).chain(CurveTween(curve: curve));

              return SlideTransition(
                position: animation.drive(tween),
                child: child,
              );
            },
          ),
        );
      },
      child: AnimatedScale(
        curve: Curves.easeInOut,
        duration: const Duration(milliseconds: 500),
        scale: 1,
        child: Container(
          width: 280,
          margin: const EdgeInsets.fromLTRB(0, 0, 10, 0),
          padding: const EdgeInsets.fromLTRB(20, 20, 20, 15),
          color: colorPrimary.withValues(alpha: 0.12),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  ClipRRect(
                    borderRadius: BorderRadius.circular(50),
                    child: MyNetworkImage(
                        imgWidth: 80,
                        imgHeight: 80,
                        fit: BoxFit.cover,
                        imageUrl: tutorList?[index].image.toString() ?? ""),
                  ),
                  const SizedBox(width: 10),
                  Expanded(
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        MyText(
                            color: Theme.of(context).colorScheme.surface,
                            text: tutorList?[index].fullName == ""
                                ? "Guest User"
                                : tutorList?[index].fullName.toString() ?? "",
                            fontsizeNormal: Dimens.textBig,
                            fontsizeWeb: Dimens.textBig,
                            fontwaight: FontWeight.w600,
                            maxline: 1,
                            textalign: TextAlign.center,
                            fontstyle: FontStyle.normal),
                        const SizedBox(height: 5),
                        MyText(
                            color: gray,
                            text: tutorList?[index].email.toString() ?? "",
                            fontsizeNormal: Dimens.textMedium,
                            fontsizeWeb: Dimens.textMedium,
                            fontwaight: FontWeight.w400,
                            maxline: 1,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                      ],
                    ),
                  ),
                ],
              ),
              const SizedBox(height: 10),
              Expanded(
                child: MyText(
                    color: gray,
                    text: tutorList?[index].description.toString() ?? "",
                    fontsizeNormal: Dimens.textSmall,
                    fontsizeWeb: Dimens.textSmall,
                    fontwaight: FontWeight.w400,
                    maxline: 5,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
              const SizedBox(height: 10),
              Align(
                alignment: Alignment.center,
                child: Container(
                  padding: const EdgeInsets.fromLTRB(18, 8, 18, 8),
                  decoration: BoxDecoration(
                    color: transparent,
                    borderRadius: BorderRadius.circular(50),
                    border: Border.all(width: 0.8, color: colorPrimary),
                  ),
                  child: MyText(
                      color: colorPrimary,
                      text: "View Profile",
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textSmall,
                      fontwaight: FontWeight.w500,
                      maxline: 1,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget buildTutorShimmer() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(200, 20, 100, 20)
          : const EdgeInsets.fromLTRB(20, 25, 20, 25),
      child: MediaQuery.removePadding(
        context: context,
        removeTop: true,
        child: ResponsiveGridList(
          minItemWidth: 240,
          minItemsPerRow: 2,
          maxItemsPerRow: Utils.customCrossAxisCount(
              context: context,
              height1600: 6,
              height1200: 4,
              height800: 3,
              height400: 2),
          horizontalGridSpacing: 10,
          verticalGridSpacing: 10,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
          ),
          children: List.generate(40, (index) {
            return Container(
              width: 260,
              padding: const EdgeInsets.fromLTRB(20, 20, 20, 15),
              color: Theme.of(context).secondaryHeaderColor,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      const CustomWidget.circular(width: 60, height: 60),
                      Expanded(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            CustomWidget.roundrectborder(
                                width: MediaQuery.of(context).size.width,
                                height: 5),
                            CustomWidget.roundrectborder(
                                width: MediaQuery.of(context).size.width,
                                height: 5),
                          ],
                        ),
                      )
                    ],
                  ),
                  const SizedBox(height: 10),
                  CustomWidget.roundrectborder(
                      width: MediaQuery.of(context).size.width, height: 5),
                  CustomWidget.roundrectborder(
                      width: MediaQuery.of(context).size.width, height: 5),
                  CustomWidget.roundrectborder(
                      width: MediaQuery.of(context).size.width, height: 5),
                  const SizedBox(height: 10),
                  CustomWidget.circleborder(
                    width: MediaQuery.of(context).size.width,
                    height: 35,
                  ),
                ],
              ),
            );
          }),
        ),
      ),
    );
  }

/* Shimmer Widget */
  Widget buildShimmer() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(200, 20, 200, 20)
          : const EdgeInsets.fromLTRB(20, 25, 20, 25),
      child: MediaQuery.removePadding(
        context: context,
        removeTop: true,
        child: ResponsiveGridList(
          minItemWidth: 120,
          minItemsPerRow: itemCount(),
          maxItemsPerRow: itemCount(),
          horizontalGridSpacing: 15,
          verticalGridSpacing: 15,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
          ),
          children: List.generate(10, (index) {
            return SizedBox(
              width: 200,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  CustomWidget.roundcorner(
                    width: MediaQuery.sizeOf(context).width,
                    height: 170,
                  ),
                  const SizedBox(height: 8),
                  const Expanded(
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        CustomWidget.rectangular(
                          width: 150,
                          height: 5,
                        ),
                        CustomWidget.rectangular(
                          width: 100,
                          height: 5,
                        ),
                        CustomWidget.rectangular(
                          width: 40,
                          height: 5,
                        ),
                        CustomWidget.rectangular(
                          width: 100,
                          height: 5,
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            );
          }),
        ),
      ),
    );
  }

  int itemCount() {
    if (viewAllProvider.layoutType == Constant.grid) {
      return Utils.customCrossAxisCount(
          context: context,
          height1600: 6,
          height1200: 5,
          height800: 3,
          height400: 2);
    } else if (viewAllProvider.layoutType == Constant.square) {
      return Utils.customCrossAxisCount(
          context: context,
          height1600: 8,
          height1200: 6,
          height800: 4,
          height400: 2);
    } else {
      return Utils.customCrossAxisCount(
          context: context,
          height1600: 3,
          height1200: 2,
          height800: 1,
          height400: 1);
    }
  }
}
