import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/provider/videobyidviewallprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webdetails.dart';
import 'package:prakah/webpages/websearch.dart';
import 'package:prakah/webwidget/footerweb.dart';
import 'package:prakah/webwidget/interactivecontainer.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';
import 'package:prakah/model/coursemodel.dart' as videobyid;

class WebVideoByIdViewAll extends StatefulWidget {
  final String? contentId, title, apiType;
  const WebVideoByIdViewAll(
      {super.key, this.contentId, this.apiType, this.title});

  @override
  State<WebVideoByIdViewAll> createState() => ViewAllState();
}

class ViewAllState extends State<WebVideoByIdViewAll> {
  VideoByIdViewAllProvider videoByIdViewAllProvider =
      VideoByIdViewAllProvider();
  final searchController = TextEditingController();
  final ScrollController _scrollController = ScrollController();
  double? width;
  double? height;

  @override
  void initState() {
    super.initState();
    videoByIdViewAllProvider =
        Provider.of<VideoByIdViewAllProvider>(context, listen: false);

    _scrollController.addListener(_scrollListener);
    _fetchData(0);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (videoByIdViewAllProvider.currentPage ?? 0) <
            (videoByIdViewAllProvider.totalPage ?? 0)) {
      videoByIdViewAllProvider.setLoadMore(true);
      _fetchData(videoByIdViewAllProvider.currentPage ?? 0);
    }
  }

  Future<void> _fetchData(int? nextPage) async {
    await videoByIdViewAllProvider.getVideoById(
        widget.contentId.toString(), widget.apiType, (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();
    videoByIdViewAllProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.of(context).size.width;
    height = MediaQuery.of(context).size.height;
    return _buildSearchHome();
  }

  Widget _buildSearchHome() {
    return Consumer<SearchProvider>(builder: (context, homeprovider, child) {
      if (homeprovider.isSearch == "0") {
        return Scaffold(
          appBar: Utils.webMainAppbar(controller: searchController),
          body: Utils.hoverItemWithPage(
            myWidget: SingleChildScrollView(
              controller: _scrollController,
              physics: const AlwaysScrollableScrollPhysics(),
              child: Column(
                children: [
                  Utils.buildWebDetailsAppBar(
                      context: context,
                      title: widget.title ?? "",
                      multilanguage: false),
                  selectLayout(),
                  buildVideoById(),
                  SizedBox(height: 30),
                  const FooterWeb(),
                ],
              ),
            ),
          ),
        );
      } else {
        return WebSearch(
          searchController: searchController,
        );
      }
    });
  }

  Widget selectLayout() {
    return Consumer<VideoByIdViewAllProvider>(
        builder: (context, videoByIdViewAllProvider, child) {
      return Container(
        width: MediaQuery.of(context).size.width,
        alignment: Alignment.centerLeft,
        padding: MediaQuery.of(context).size.width > 800
            ? const EdgeInsets.fromLTRB(200, 20, 200, 20)
            : const EdgeInsets.fromLTRB(20, 20, 20, 20),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            InkWell(
              hoverColor: transparent,
              highlightColor: transparent,
              splashColor: transparent,
              focusColor: transparent,
              onTap: () async {
                await videoByIdViewAllProvider.selectLayout(Constant.grid);
              },
              child: Container(
                padding: const EdgeInsets.all(12),
                decoration: BoxDecoration(
                  shape: BoxShape.circle,
                  color: videoByIdViewAllProvider.layoutType == Constant.grid
                      ? colorPrimary
                      : transparent,
                ),
                child: MyImage(
                  width: 20,
                  height: 20,
                  imagePath: "ic_grid.png",
                  color: videoByIdViewAllProvider.layoutType == Constant.grid
                      ? white
                      : gray,
                ),
              ),
            ),
            const SizedBox(width: 15),
            InkWell(
              onTap: () async {
                await videoByIdViewAllProvider.selectLayout(Constant.square);
              },
              child: Padding(
                padding: const EdgeInsets.all(8),
                child: MyImage(
                  width: 20,
                  height: 20,
                  imagePath: "ic_square.png",
                  color: videoByIdViewAllProvider.layoutType == Constant.square
                      ? colorPrimary
                      : gray,
                ),
              ),
            ),
            const SizedBox(width: 15),
            InkWell(
              hoverColor: transparent,
              highlightColor: transparent,
              splashColor: transparent,
              focusColor: transparent,
              onTap: () async {
                await videoByIdViewAllProvider.selectLayout(Constant.list);
              },
              child: Container(
                padding: const EdgeInsets.all(12),
                decoration: BoxDecoration(
                  shape: BoxShape.circle,
                  color: videoByIdViewAllProvider.layoutType == Constant.list
                      ? colorPrimary
                      : transparent,
                ),
                child: MyImage(
                  width: 20,
                  height: 20,
                  imagePath: "ic_list.png",
                  color: videoByIdViewAllProvider.layoutType == Constant.list
                      ? white
                      : gray,
                ),
              ),
            ),
          ],
        ),
      );
    });
  }

  Widget buildVideoById() {
    return Consumer<VideoByIdViewAllProvider>(
        builder: (context, videobyidviewallprovider, child) {
      if (videoByIdViewAllProvider.loading &&
          !videoByIdViewAllProvider.loadmore) {
        return buildShimmer();
      } else {
        if (videobyidviewallprovider.videobyIdModel.status == 200 &&
            videobyidviewallprovider.getCourseList != null) {
          if ((videobyidviewallprovider.getCourseList?.length ?? 0) > 0) {
            return Padding(
              padding: MediaQuery.of(context).size.width > 800
                  ? const EdgeInsets.fromLTRB(200, 20, 200, 20)
                  : const EdgeInsets.fromLTRB(20, 25, 20, 25),
              child: Column(
                children: [
                  MediaQuery.removePadding(
                    context: context,
                    removeTop: true,
                    child: ResponsiveGridList(
                      minItemWidth: 120,
                      minItemsPerRow: itemCount(),
                      maxItemsPerRow: itemCount(),
                      horizontalGridSpacing: 5,
                      verticalGridSpacing: 10,
                      listViewBuilderOptions: ListViewBuilderOptions(
                        scrollDirection: Axis.vertical,
                        shrinkWrap: true,
                        physics: const BouncingScrollPhysics(),
                      ),
                      children: List.generate(
                          videobyidviewallprovider.getCourseList?.length ?? 0,
                          (index) {
                        return buildVideoByIdLayout(index);
                      }),
                    ),
                  ),
                  if (videobyidviewallprovider.loadmore)
                    Container(
                      height: 50,
                      margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                      child: Utils.pageLoader(),
                    )
                  else
                    const SizedBox.shrink(),
                ],
              ),
            );
          } else {
            return const NoData();
          }
        } else {
          return const NoData();
        }
      }
    });
  }

  Widget buildVideoByIdLayout(int index) {
    if (videoByIdViewAllProvider.layoutType == Constant.grid) {
      return bigPortrait(
          index: index,
          courseList: videoByIdViewAllProvider.getCourseList ?? []);
    } else if (videoByIdViewAllProvider.layoutType == Constant.square) {
      return square(
          index: index,
          sectionDetailList: videoByIdViewAllProvider.getCourseList ?? []);
    } else {
      return listView(
          index: index,
          sectionDetailList: videoByIdViewAllProvider.getCourseList ?? []);
    }
  }

/* Category And Language Layouts Start */

  /* Listview  */
  Widget listView(
      {required int index,
      required List<videobyid.Result>? sectionDetailList}) {
    return InkWell(
      hoverColor: transparent,
      highlightColor: transparent,
      splashColor: transparent,
      focusColor: transparent,
      onTap: () {
        Navigator.of(context).push(
          PageRouteBuilder(
            transitionDuration: const Duration(milliseconds: 200),
            pageBuilder: (BuildContext context, Animation<double> animation,
                Animation<double> secondaryAnimation) {
              return WebDetail(
                  courseId: sectionDetailList?[index].id.toString() ?? "");
            },
            transitionsBuilder: (BuildContext context,
                Animation<double> animation,
                Animation<double> secondaryAnimation,
                Widget child) {
              return Align(
                child: FadeTransition(
                  opacity: animation,
                  child: child,
                ),
              );
            },
          ),
        );
      },
      child: InteractiveContainer(child: (isHovered) {
        return Row(
          children: [
            MyNetworkImage(
              imgWidth: 120,
              imgHeight: 160,
              radius: 24,
              imageUrl: sectionDetailList?[index].landscapeImg.toString() ?? "",
              fit: BoxFit.fill,
            ),
            const SizedBox(width: 10),
            Expanded(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: sectionDetailList?[index].title.toString() ?? "",
                      fontsizeNormal: Dimens.textBigSmall,
                      fontwaight: FontWeight.w700,
                      maxline: 1,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    spacing: 4,
                    children: [
                      Icon(
                        Icons.person_outline_rounded,
                        size: 16,
                        color: gray,
                      ),
                      Expanded(
                        child: MyText(
                            color: green,
                            text: sectionDetailList?[index]
                                    .tutorName
                                    .toString() ??
                                "",
                            fontsizeNormal: Dimens.textMedium,
                            fontsizeWeb: Dimens.textSmall,
                            fontwaight: FontWeight.w500,
                            maxline: 1,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                      ),
                    ],
                  ),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: sectionDetailList?[index].description.toString() ??
                          "",
                      fontsizeNormal: Dimens.textBigSmall,
                      fontwaight: FontWeight.w400,
                      maxline: 3,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      MyText(
                          color: gray,
                          text: Utils.kmbGenerator(int.parse(
                              sectionDetailList?[index].totalView.toString() ??
                                  "")),
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      const SizedBox(width: 5),
                      MyText(
                          color: gray,
                          text: "students",
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          multilanguage: true,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  const SizedBox(height: 8),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: (sectionDetailList?[index].isFree ?? 0) == 0 &&
                              (sectionDetailList?[index].isUserBuy ?? 0) == 0
                          ? "${Constant.currencyCode} ${sectionDetailList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          ],
        );
      }),
    );
  }

  /* Square */
  Widget square(
      {required int index,
      required List<videobyid.Result>? sectionDetailList}) {
    return InkWell(
      hoverColor: transparent,
      highlightColor: transparent,
      splashColor: transparent,
      focusColor: transparent,
      onTap: () {
        Navigator.of(context).push(
          PageRouteBuilder(
            transitionDuration: const Duration(milliseconds: 200),
            pageBuilder: (BuildContext context, Animation<double> animation,
                Animation<double> secondaryAnimation) {
              return WebDetail(
                  courseId: sectionDetailList?[index].id.toString() ?? "");
            },
            transitionsBuilder: (BuildContext context,
                Animation<double> animation,
                Animation<double> secondaryAnimation,
                Widget child) {
              return Align(
                child: FadeTransition(
                  opacity: animation,
                  child: child,
                ),
              );
            },
          ),
        );
      },
      child: Container(
        width: 140,
        margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
        child: Column(
          children: [
            Stack(
              children: [
                AnimatedScale(
                  curve: Curves.easeInOut,
                  duration: const Duration(milliseconds: 500),
                  scale: 1,
                  child: MyNetworkImage(
                      imgWidth: MediaQuery.of(context).size.width,
                      imgHeight: 145,
                      radius: 24,
                      fit: BoxFit.fill,
                      islandscap: true,
                      imageUrl:
                          sectionDetailList?[index].thumbnailImg.toString() ??
                              ""),
                ),
                (sectionDetailList?[index].isFree.toString() ?? "") == "1"
                    ? SizedBox.shrink()
                    : Positioned(
                        left: 10,
                        top: 10,
                        child: IntrinsicWidth(
                          // Wrap with IntrinsicWidth
                          child: Container(
                            padding: EdgeInsets.symmetric(
                                horizontal: 8, vertical: 4),
                            decoration: BoxDecoration(
                              color: colorAccent,
                              borderRadius: BorderRadius.circular(4),
                            ),
                            child: Row(
                              mainAxisSize: MainAxisSize
                                  .min, // Ensures the Row only takes necessary space
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Icon(
                                  Icons.workspace_premium_outlined,
                                  size: 14,
                                  color: white,
                                ),
                                SizedBox(
                                    width: 5), // Spacing between icon and text
                                Flexible(
                                  fit: FlexFit.loose,
                                  child: MyText(
                                    color: white,
                                    text: "premium",
                                    maxline: 1,
                                    multilanguage: true,
                                    fontsizeNormal: Dimens.textMedium,
                                    fontwaight: FontWeight.w500,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      )
              ],
            ),
            const SizedBox(height: 8),
            Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text: sectionDetailList?[index].title.toString() ?? "",
                    fontsizeNormal: Dimens.textBigSmall,
                    fontsizeWeb: Dimens.textMedium,
                    fontwaight: FontWeight.w700,
                    maxline: 1,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                const SizedBox(height: 5),
                Row(
                  mainAxisAlignment: MainAxisAlignment.start,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  spacing: 4,
                  children: [
                    Icon(
                      Icons.person_outline_rounded,
                      size: 16,
                      color: gray,
                    ),
                    MyText(
                        color: green,
                        text: sectionDetailList?[index].tutorName.toString() ??
                            "",
                        fontsizeNormal: Dimens.textMedium,
                        fontsizeWeb: Dimens.textSmall,
                        fontwaight: FontWeight.w500,
                        maxline: 1,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ],
                ),
                const SizedBox(height: 5),
                MyText(
                    color: gray,
                    text:
                        sectionDetailList?[index].description.toString() ?? "",
                    fontsizeNormal: Dimens.textMedium,
                    fontsizeWeb: Dimens.textSmall,
                    fontwaight: FontWeight.w500,
                    maxline: 3,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                Row(
                  children: [
                    MyRating(
                      size: 18,
                      rating: double.parse(
                          (sectionDetailList?[index].avgRating.toString() ??
                              "")),
                      spacing: 3,
                    ),
                    const SizedBox(width: 5),
                    MyText(
                        color: colorAccent,
                        text:
                            "${double.parse(sectionDetailList?[index].avgRating.toString() ?? "")}",
                        fontsizeNormal: Dimens.textTitle,
                        fontsizeWeb: Dimens.textTitle,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ],
                ),
                MyText(
                    color: black,
                    text: (sectionDetailList?[index].isFree ?? 0) == 0 &&
                            (sectionDetailList?[index].isUserBuy ?? 0) == 0
                        ? "${Constant.currencyCode} ${sectionDetailList?[index].price.toString() ?? ""}"
                        : Locales.string(context, "free"),
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w500,
                    maxline: 1,
                    multilanguage: false,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
          ],
        ),
      ),
    );
  }

  /* Big Portrait */
  Widget bigPortrait(
      {required int index, required List<videobyid.Result>? courseList}) {
    return InteractiveContainer(child: (isHovered) {
      return InkWell(
        splashColor: transparent,
        focusColor: transparent,
        hoverColor: transparent,
        highlightColor: transparent,
        onTap: () {
          Navigator.of(context).push(
            PageRouteBuilder(
              transitionDuration: const Duration(milliseconds: 200),
              pageBuilder: (BuildContext context, Animation<double> animation,
                  Animation<double> secondaryAnimation) {
                return WebDetail(
                    courseId: courseList?[index].id.toString() ?? "");
              },
              transitionsBuilder: (BuildContext context,
                  Animation<double> animation,
                  Animation<double> secondaryAnimation,
                  Widget child) {
                return Align(
                  child: FadeTransition(
                    opacity: animation,
                    child: child,
                  ),
                );
              },
            ),
          );
        },
        child: Container(
          width: 200,
          margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
          child: Column(
            children: [
              Stack(
                children: [
                  AnimatedScale(
                    curve: Curves.easeInOut,
                    duration: const Duration(milliseconds: 500),
                    scale: isHovered ? 1.03 : 1,
                    child: MyNetworkImage(
                        imgWidth: MediaQuery.of(context).size.width,
                        imgHeight: 145,
                        radius: 24,
                        fit: BoxFit.fill,
                        islandscap: true,
                        imageUrl:
                            courseList?[index].thumbnailImg.toString() ?? ""),
                  ),
                  (courseList?[index].isFree.toString() ?? "") == "1"
                      ? SizedBox.shrink()
                      : Positioned(
                          left: 10,
                          top: 10,
                          child: IntrinsicWidth(
                            // Wrap with IntrinsicWidth
                            child: Container(
                              padding: EdgeInsets.symmetric(
                                  horizontal: 8, vertical: 4),
                              decoration: BoxDecoration(
                                color: colorAccent,
                                borderRadius: BorderRadius.circular(4),
                              ),
                              child: Row(
                                mainAxisSize: MainAxisSize
                                    .min, // Ensures the Row only takes necessary space
                                crossAxisAlignment: CrossAxisAlignment.center,
                                children: [
                                  Icon(
                                    Icons.workspace_premium_outlined,
                                    size: 14,
                                    color: white,
                                  ),
                                  SizedBox(
                                      width:
                                          5), // Spacing between icon and text
                                  Flexible(
                                    fit: FlexFit.loose,
                                    child: MyText(
                                      color: white,
                                      text: "premium",
                                      maxline: 1,
                                      multilanguage: true,
                                      fontsizeNormal: Dimens.textMedium,
                                      fontwaight: FontWeight.w500,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ),
                        )
                ],
              ),
              const SizedBox(height: 8),
              Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: courseList?[index].title.toString() ?? "",
                      fontsizeNormal: Dimens.textBigSmall,
                      fontsizeWeb: Dimens.textMedium,
                      fontwaight: FontWeight.w700,
                      maxline: 1,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  const SizedBox(height: 5),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    spacing: 4,
                    children: [
                      Icon(
                        Icons.person_outline_rounded,
                        size: 16,
                        color: gray,
                      ),
                      MyText(
                          color: green,
                          text: courseList?[index].tutorName.toString() ?? "",
                          fontsizeNormal: Dimens.textMedium,
                          fontsizeWeb: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  const SizedBox(height: 5),
                  MyText(
                      color: gray,
                      text: courseList?[index].description.toString() ?? "",
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textSmall,
                      fontwaight: FontWeight.w500,
                      maxline: 3,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    children: [
                      MyRating(
                        size: 18,
                        rating: double.parse(
                            (courseList?[index].avgRating.toString() ?? "")),
                        spacing: 3,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text:
                              "${double.parse(courseList?[index].avgRating.toString() ?? "")}",
                          fontsizeNormal: Dimens.textTitle,
                          fontsizeWeb: Dimens.textTitle,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (courseList?[index].isFree ?? 0) == 0 &&
                              (courseList?[index].isUserBuy ?? 0) == 0
                          ? "${Constant.currencyCode} ${courseList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textSmall,
                      fontwaight: FontWeight.w500,
                      maxline: 1,
                      multilanguage: false,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ],
          ),
        ),
      );
    });
  }

/* Category And Language Layouts End */
/* Shimmer Widget */
  Widget buildShimmer() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(200, 20, 200, 20)
          : const EdgeInsets.fromLTRB(20, 25, 20, 25),
      child: MediaQuery.removePadding(
        context: context,
        removeTop: true,
        child: ResponsiveGridList(
          minItemWidth: 120,
          minItemsPerRow: itemCount(),
          maxItemsPerRow: itemCount(),
          horizontalGridSpacing: 15,
          verticalGridSpacing: 15,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
          ),
          children: List.generate(10, (index) {
            return SizedBox(
              width: 200,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  CustomWidget.roundcorner(
                    width: MediaQuery.sizeOf(context).width,
                    height: 170,
                  ),
                  const SizedBox(height: 8),
                  const Expanded(
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        CustomWidget.rectangular(
                          width: 150,
                          height: 5,
                        ),
                        CustomWidget.rectangular(
                          width: 100,
                          height: 5,
                        ),
                        CustomWidget.rectangular(
                          width: 40,
                          height: 5,
                        ),
                        CustomWidget.rectangular(
                          width: 100,
                          height: 5,
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            );
          }),
        ),
      ),
    );
  }

  /* Item Count */
  int itemCount() {
    if (videoByIdViewAllProvider.layoutType == Constant.grid) {
      return Utils.customCrossAxisCount(
          context: context,
          height1600: 6,
          height1200: 5,
          height800: 3,
          height400: 2);
    } else if (videoByIdViewAllProvider.layoutType == Constant.square) {
      return Utils.customCrossAxisCount(
          context: context,
          height1600: 8,
          height1200: 6,
          height800: 4,
          height400: 2);
    } else {
      return Utils.customCrossAxisCount(
          context: context,
          height1600: 3,
          height1200: 2,
          height800: 1,
          height400: 1);
    }
  }
}
