import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/provider/tutorprofileprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webblogdetail.dart';
import 'package:prakah/webpages/webdetails.dart';
import 'package:prakah/webpages/websearch.dart';
import 'package:prakah/webwidget/footerweb.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:provider/provider.dart';
import 'package:readmore/readmore.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';
import 'package:badges/badges.dart' as badges;

class WebTutorProfile extends StatefulWidget {
  final String tutorid;
  const WebTutorProfile({
    super.key,
    required this.tutorid,
  });

  @override
  State<WebTutorProfile> createState() => WebTutorProfileState();
}

class WebTutorProfileState extends State<WebTutorProfile> {
  TutorProfileProvider tutorProvider = TutorProfileProvider();
  final searchController = TextEditingController();
  final ScrollController _scrollController = ScrollController();
  double? height;
  double? width;

  @override
  initState() {
    super.initState();
    tutorProvider = Provider.of<TutorProfileProvider>(context, listen: false);

    _scrollController.addListener(_scrollListener);
    WidgetsBinding.instance.addPostFrameCallback((_) {
      getApi();
    });
  }

  Future<void> getApi() async {
    tutorProvider.setLoading(true);
    await tutorProvider.getTutorprofile(widget.tutorid);
    _fetchData("1", 0);
  }

  Future<void> _fetchData(String type, int? nextPage) async {
    await tutorProvider.getContentByTutor(
        type, widget.tutorid, (nextPage ?? 0) + 1);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (tutorProvider.currentPage ?? 0) < (tutorProvider.totalPage ?? 0)) {
      tutorProvider.setLoadMore(true);
      if (tutorProvider.layoutType == Constant.blogType) {
        _fetchData("1", tutorProvider.currentPage ?? 0);
      } else if (tutorProvider.layoutType == Constant.bookType) {
        _fetchData("2", tutorProvider.currentPage ?? 0);
      } else {
        _fetchData("3", tutorProvider.currentPage ?? 0);
      }
    }
  }

  @override
  void dispose() {
    super.dispose();
    tutorProvider.clearProvider();
  }

  @override
  Widget build(BuildContext context) {
    height = MediaQuery.of(context).size.height;
    width = MediaQuery.of(context).size.width;
    return _buildSearchHome();
  }

  Widget _buildSearchHome() {
    return Consumer<SearchProvider>(builder: (context, homeprovider, child) {
      if (homeprovider.isSearch == "0") {
        return Scaffold(
          appBar: Utils.webMainAppbar(controller: searchController),
          body: _buildWebTutorProfile(),
        );
      } else {
        return WebSearch(
          searchController: searchController,
        );
      }
    });
  }

  Widget _buildWebTutorProfile() {
    return Consumer<TutorProfileProvider>(builder: (context, tutoritem, child) {
      return SingleChildScrollView(
        scrollDirection: Axis.vertical,
        controller: _scrollController,
        physics: const BouncingScrollPhysics(),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Utils.buildWebDetailsAppBar(
                context: context, title: "tutorprofile"),
            buildTutor(),
            tabButton(),
            setLayout(),
            const FooterWeb(),
          ],
        ),
      );
    });
  }

  Widget buildTutor() {
    return Consumer<TutorProfileProvider>(
      builder: (context, tutoritem, child) {
        if (tutoritem.loading) {
          return shimmer();
        } else {
          return Container(
            padding: MediaQuery.of(context).size.width > 800
                ? const EdgeInsets.fromLTRB(200, 25, 200, 0)
                : const EdgeInsets.fromLTRB(20, 25, 20, 0),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(5),
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                tutorProfile(),
                tutorAbout(),
              ],
            ),
          );
        }
      },
    );
  }

  Widget tutorProfile() {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      crossAxisAlignment: CrossAxisAlignment.center,
      children: [
        ClipRRect(
          borderRadius: BorderRadius.circular(50),
          child: MyNetworkImage(
              imageUrl:
                  tutorProvider.tutorprofilemodel.result?[0].image.toString() ??
                      "",
              fit: BoxFit.fill,
              imgHeight: 80,
              imgWidth: 80),
        ),
        const SizedBox(width: 15),
        Column(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text: tutorProvider.tutorprofilemodel.result?[0].fullName
                        .toString() ??
                    "",
                maxline: 2,
                fontwaight: FontWeight.w700,
                fontsizeNormal: Dimens.textlargeBig,
                fontsizeWeb: Dimens.textlargeBig,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
            const SizedBox(height: 8),
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text: tutorProvider.tutorprofilemodel.result?[0].email
                        .toString() ??
                    "",
                maxline: 2,
                fontwaight: FontWeight.w400,
                fontsizeNormal: Dimens.textMedium,
                fontsizeWeb: Dimens.textMedium,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal),
          ],
        ),
      ],
    );
  }

  Widget tutorAbout() {
    return Padding(
      padding: const EdgeInsets.fromLTRB(0, 15, 0, 15),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          MyText(
              color: Theme.of(context).colorScheme.surface,
              text: "About Me",
              maxline: 2,
              fontwaight: FontWeight.w700,
              fontsizeNormal: Dimens.textBig,
              fontsizeWeb: Dimens.textBig,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
          const SizedBox(height: 15),
          ReadMoreText(
            tutorProvider.tutorprofilemodel.result?[0].description.toString() ??
                "",
            trimLines: 5,
            textAlign: TextAlign.left,
            style: TextStyle(
                fontSize: Dimens.textMedium,
                fontWeight: FontWeight.w400,
                color: gray),
            trimCollapsedText: 'Read More',
            colorClickableText: black,
            trimMode: TrimMode.Line,
            trimExpandedText: 'Read less',
            lessStyle: TextStyle(
                fontSize: Dimens.textMedium,
                fontWeight: FontWeight.w600,
                color: black),
            moreStyle: TextStyle(
                fontSize: Dimens.textMedium,
                fontWeight: FontWeight.w600,
                color: black),
          ),
        ],
      ),
    );
  }

  Widget tabButton() {
    return Container(
      margin: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(200, 16, 200, 0)
          : const EdgeInsets.fromLTRB(20, 16, 20, 0),
      padding: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(14),
        color: colorPrimary.withValues(alpha: 0.18),
      ),
      child: Row(
        mainAxisSize: MainAxisSize.min,
        spacing: 15,
        children: [
          newTap(
              onTap: () {
                tutorProvider.selectLayout(Constant.blogType);
                tutorProvider.clearContent();
                tutorProvider.setLoading(false);
                _fetchData("1", 0);
              },
              count: tutorProvider.tutorprofilemodel.result?[0].totalBlog
                      .toString() ??
                  "",
              layOut: Constant.blogType,
              title: "blog"),
          newTap(
              onTap: () {
                tutorProvider.selectLayout(Constant.bookType);
                tutorProvider.clearContent();
                tutorProvider.setLoading(false);
                _fetchData("2", 0);
              },
              count: tutorProvider.tutorprofilemodel.result?[0].totalBook
                      .toString() ??
                  "",
              layOut: Constant.bookType,
              title: "book"),
          newTap(
              onTap: () {
                tutorProvider.selectLayout(Constant.courseType);
                tutorProvider.clearContent();
                tutorProvider.setLoading(false);
                _fetchData("3", 0);
              },
              count: tutorProvider.tutorprofilemodel.result?[0].totalCourse
                      .toString() ??
                  "",
              layOut: Constant.courseType,
              title: "course"),
        ],
      ),
    );
  }

/* New Tab */
  Widget newTap({required VoidCallback onTap, layOut, count, title}) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: onTap,
      child: Container(
        padding: const EdgeInsets.fromLTRB(10, 4, 10, 4),
        alignment: Alignment.center,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color:
              tutorProvider.layoutType == layOut ? colorPrimary : transparent,
        ),
        child: badges.Badge(
          badgeStyle: badges.BadgeStyle(
              shape: badges.BadgeShape.circle,
              padding: EdgeInsets.all(6),
              badgeColor: black),
          position: badges.BadgePosition.topEnd(top: -12, end: -20),
          badgeContent: MyText(
              color: white,
              text: count,
              multilanguage: false,
              fontsizeNormal: Dimens.textSmall,
              fontwaight: FontWeight.w600,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              fontstyle: FontStyle.normal),
          child: MyText(
              color: tutorProvider.layoutType == layOut
                  ? white
                  : Theme.of(context).colorScheme.surface,
              text: title,
              multilanguage: true,
              fontsizeNormal: Dimens.textMedium,
              fontwaight: FontWeight.w600,
              maxline: 3,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
        ),
      ),
    );
  }

  Widget setLayout() {
    if (tutorProvider.tutorContentLoading && !tutorProvider.loadMore) {
      return Padding(
        padding: MediaQuery.of(context).size.width > 800
            ? const EdgeInsets.fromLTRB(200, 25, 200, 0)
            : const EdgeInsets.fromLTRB(20, 25, 20, 0),
        child: (tutorProvider.layoutType == Constant.blogType)
            ? blogShimmer()
            : (tutorProvider.layoutType == Constant.bookType)
                ? bookShimmer()
                : courseShimmer(),
      );
    } else {
      if (tutorProvider.courseList != null &&
          (tutorProvider.courseList?.length ?? 0) > 0) {
        return Padding(
          padding: MediaQuery.of(context).size.width > 800
              ? const EdgeInsets.fromLTRB(200, 25, 200, 20)
              : const EdgeInsets.fromLTRB(20, 25, 20, 20),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              (tutorProvider.layoutType == Constant.blogType)
                  ? buildBlogItem()
                  : (tutorProvider.layoutType == Constant.bookType)
                      ? buildBookItem()
                      : allcourseItem(),
              if (tutorProvider.loadMore)
                Container(
                  height: 50,
                  margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                  child: Utils.pageLoader(),
                )
              else
                const SizedBox.shrink(),
            ],
          ),
        );
      } else {
        return const NoData();
      }
    }
  }

  Widget buildBlogItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 300,
        minItemsPerRow: 1,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 6,
            height1200: 4,
            height800: 2,
            height400: 2),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(tutorProvider.courseList?.length ?? 0, (index) {
          return InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: () {
              Navigator.of(context).push(
                PageRouteBuilder(
                  pageBuilder: (context, animation, secondaryAnimation) =>
                      WebBlogDetail(
                    blogId:
                        tutorProvider.courseList?[index].id.toString() ?? "",
                  ),
                  transitionsBuilder:
                      (context, animation, secondaryAnimation, child) {
                    const begin = Offset(1.0, 0.0);
                    const end = Offset.zero;
                    const curve = Curves.ease;

                    var tween = Tween(begin: begin, end: end)
                        .chain(CurveTween(curve: curve));

                    return SlideTransition(
                      position: animation.drive(tween),
                      child: child,
                    );
                  },
                ),
              );
            },
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                Stack(
                  children: [
                    MyNetworkImage(
                        radius: 10,
                        imgWidth: width,
                        imgHeight: 170,
                        imageUrl:
                            tutorProvider.courseList?[index].image.toString() ??
                                "",
                        fit: BoxFit.fill),
                    Positioned(
                      top: 10,
                      right: 10,
                      child: Container(
                        padding: EdgeInsets.all(5),
                        decoration: BoxDecoration(
                            shape: BoxShape.circle,
                            color: black.withValues(alpha: 0.4)),
                        child: InkWell(
                          splashColor: transparent,
                          focusColor: transparent,
                          hoverColor: transparent,
                          onTap: () async {
                            if (Utils.checkLoginUser(context)) {
                              await tutorProvider.addRemoveWishlist(
                                index,
                                "1",
                                tutorProvider.courseList?[index].id
                                        .toString() ??
                                    "",
                              );
                            }
                          },
                          child: Container(
                            padding: EdgeInsets.all(6),
                            decoration: BoxDecoration(
                                color: gray, shape: BoxShape.circle),
                            child: Icon(
                              tutorProvider.courseList?[index].isWishlist == 1
                                  ? Icons.favorite
                                  : Icons.favorite_border,
                              color:
                                  tutorProvider.courseList?[index].isWishlist ==
                                          1
                                      ? red
                                      : white,
                            ),
                          ),
                        ),
                      ),
                    ),
                  ],
                ),
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text:
                        tutorProvider.courseList?[index].title.toString() ?? "",
                    fontsizeNormal: Dimens.textBig,
                    fontsizeWeb: Dimens.textSmall,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                MyText(
                    color: gray,
                    text:
                        tutorProvider.courseList?[index].tutorName.toString() ??
                            "",
                    fontsizeNormal: Dimens.textMedium,
                    fontsizeWeb: Dimens.textSmall,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
          );
        }),
      ),
    );
  }

  Widget buildBookItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 3,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 8,
            height1200: 6,
            height800: 4,
            height400: 3),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(tutorProvider.courseList?.length ?? 0, (index) {
          return InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: () {
              Navigator.of(context).push(
                PageRouteBuilder(
                  pageBuilder: (context, animation, secondaryAnimation) =>
                      WebBlogDetail(
                    blogId:
                        tutorProvider.courseList?[index].id.toString() ?? "",
                  ),
                  transitionsBuilder:
                      (context, animation, secondaryAnimation, child) {
                    const begin = Offset(1.0, 0.0);
                    const end = Offset.zero;
                    const curve = Curves.ease;

                    var tween = Tween(begin: begin, end: end)
                        .chain(CurveTween(curve: curve));

                    return SlideTransition(
                      position: animation.drive(tween),
                      child: child,
                    );
                  },
                ),
              );
            },
            child: SizedBox(
              width: 150,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 4,
                children: [
                  Stack(
                    children: [
                      MyNetworkImage(
                          radius: 5,
                          imgWidth: width,
                          imgHeight: 155,
                          imageUrl: tutorProvider
                                  .courseList?[index].thumbnailImg
                                  .toString() ??
                              "",
                          fit: BoxFit.cover),
                      Positioned(
                        top: 10,
                        right: 10,
                        child: Container(
                          padding: EdgeInsets.all(5),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              color: black.withValues(alpha: 0.4)),
                          child: InkWell(
                            splashColor: transparent,
                            focusColor: transparent,
                            hoverColor: transparent,
                            onTap: () async {
                              if (Utils.checkLoginUser(context)) {
                                await tutorProvider.addRemoveWishlist(
                                  index,
                                  "2",
                                  tutorProvider.courseList?[index].id
                                          .toString() ??
                                      "",
                                );
                              }
                            },
                            child: Container(
                              padding: EdgeInsets.all(6),
                              decoration: BoxDecoration(
                                  color: gray, shape: BoxShape.circle),
                              child: Icon(
                                tutorProvider.courseList?[index].isWishlist == 1
                                    ? Icons.favorite
                                    : Icons.favorite_border,
                                color: tutorProvider
                                            .courseList?[index].isWishlist ==
                                        1
                                    ? red
                                    : white,
                              ),
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                  const SizedBox(height: 10),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: tutorProvider.courseList?[index].title.toString() ??
                          "",
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textSmall,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      fontwaight: FontWeight.w600,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  MyText(
                      color: gray,
                      text: tutorProvider.courseList?[index].tutorName
                              .toString() ??
                          "",
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textSmall,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      fontwaight: FontWeight.w600,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    children: [
                      MyRating(
                        size: 13,
                        rating: double.parse(
                          tutorProvider.courseList?[index].avgRating
                                  .toString() ??
                              "",
                        ),
                        spacing: 3,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text: "${double.parse(
                            tutorProvider.courseList?[index].avgRating
                                    .toString() ??
                                "",
                          )}",
                          fontsizeNormal: Dimens.textBigSmall,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (tutorProvider.courseList?[index].isFree
                                      .toString() ??
                                  "") ==
                              "0"
                          ? "${Constant.currencyCode} ${tutorProvider.courseList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          );
        }),
      ),
    );
  }

  Widget allcourseItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
          minItemWidth: 120,
          minItemsPerRow: 2,
          maxItemsPerRow: Utils.customCrossAxisCount(
              context: context,
              height1600: 6,
              height1200: 4,
              height800: 2,
              height400: 2),
          horizontalGridSpacing: 5,
          verticalGridSpacing: 5,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics(),
          ),
          children:
              List.generate(tutorProvider.courseList?.length ?? 0, (index) {
            return InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              onTap: () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        WebDetail(
                      courseId:
                          tutorProvider.courseList?[index].id.toString() ?? "",
                    ),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              },
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 4,
                children: [
                  Stack(
                    children: [
                      MyNetworkImage(
                          imgWidth: MediaQuery.sizeOf(context).width,
                          imgHeight: 110,
                          fit: BoxFit.fill,
                          radius: 10,
                          islandscap: true,
                          imageUrl: tutorProvider
                                  .courseList?[index].thumbnailImg
                                  .toString() ??
                              ""),
                      Positioned(
                        top: 5,
                        right: 10,
                        child: Container(
                          padding: EdgeInsets.all(5),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              color: black.withValues(alpha: 0.4)),
                          child: InkWell(
                            splashColor: transparent,
                            focusColor: transparent,
                            hoverColor: transparent,
                            onTap: () async {
                              if (Utils.checkLoginUser(context)) {
                                await tutorProvider.addRemoveWishlist(
                                  index,
                                  "3",
                                  tutorProvider.courseList?[index].id
                                          .toString() ??
                                      "",
                                );
                              }
                            },
                            child: Container(
                              padding: EdgeInsets.all(6),
                              decoration: BoxDecoration(
                                  color: gray, shape: BoxShape.circle),
                              child: Icon(
                                tutorProvider.courseList?[index].isWishlist == 1
                                    ? Icons.favorite
                                    : Icons.favorite_border,
                                color: tutorProvider
                                            .courseList?[index].isWishlist ==
                                        1
                                    ? red
                                    : white,
                              ),
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: tutorProvider.courseList?[index].title.toString() ??
                          "",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      MyText(
                          color: gray,
                          text: Utils.kmbGenerator(int.parse(tutorProvider
                                  .courseList?[index].totalView
                                  .toString() ??
                              "")),
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      const SizedBox(width: 5),
                      MyText(
                          color: gray,
                          text: "students",
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          multilanguage: true,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  Row(
                    children: [
                      MyRating(
                        size: 15,
                        rating: double.parse(tutorProvider
                                .courseList?[index].avgRating
                                .toString() ??
                            ""),
                        spacing: 2,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text:
                              "${double.parse(tutorProvider.courseList?[index].avgRating.toString() ?? "")}",
                          fontsizeNormal: Dimens.textMedium,
                          fontwaight: FontWeight.w600,
                          maxline: 2,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (tutorProvider.courseList?[index].isFree
                                      .toString() ??
                                  "") ==
                              "0"
                          ? "${Constant.currencyCode} ${tutorProvider.courseList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            );
          })),
    );
  }

  Widget courseShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 2,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 6,
            height1200: 4,
            height800: 2,
            height400: 2),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(
          10,
          (index) {
            return Container(
              width: 200,
              margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  CustomWidget.rectangular(
                    width: MediaQuery.sizeOf(context).width,
                    height: 110,
                  ),
                  const SizedBox(height: 8),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                ],
              ),
            );
          },
        ),
      ),
    );
  }

  Widget bookShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 3,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 8,
            height1200: 6,
            height800: 4,
            height400: 3),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(10, (index) {
          return SizedBox(
            width: 140,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                CustomWidget.roundrectborder(
                  width: width ?? 0,
                  height: 155,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
              ],
            ),
          );
        }),
      ),
    );
  }

  Widget blogShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 300,
        minItemsPerRow: 1,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 6,
            height1200: 4,
            height800: 2,
            height400: 2),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(10, (index) {
          return Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 4,
            children: [
              Stack(
                children: [
                  CustomWidget.roundcorner(width: width ?? 0, height: 155),
                  Positioned.fill(
                    top: 5,
                    left: 10,
                    right: 10,
                    child: Align(
                      alignment: Alignment.topRight,
                      child: CustomWidget.circular(width: 30, height: 30),
                    ),
                  ),
                ],
              ),
              CustomWidget.roundcorner(width: width ?? 0.0, height: 16),
              CustomWidget.roundcorner(width: (width ?? 0.0) * 0.5, height: 14),
            ],
          );
        }),
      ),
    );
  }

  Widget shimmer() {
    return Container(
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(200, 50, 200, 20)
          : const EdgeInsets.fromLTRB(20, 25, 20, 20),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(5),
        border: Border.all(width: 1, color: gray),
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          const Row(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              CustomWidget.circular(height: 80, width: 80),
              SizedBox(width: 15),
              Expanded(
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    CustomWidget.roundrectborder(height: 10, width: 350),
                    SizedBox(height: 8),
                    CustomWidget.roundrectborder(height: 8, width: 250),
                  ],
                ),
              ),
            ],
          ),
          const Padding(
            padding: EdgeInsets.fromLTRB(15, 15, 15, 15),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                CustomWidget.roundrectborder(height: 10, width: 250),
                SizedBox(height: 15),
                CustomWidget.roundrectborder(height: 5, width: 400),
                CustomWidget.roundrectborder(height: 5, width: 400),
                CustomWidget.roundrectborder(height: 5, width: 400),
                CustomWidget.roundrectborder(height: 5, width: 400),
                CustomWidget.roundrectborder(height: 5, width: 400),
                CustomWidget.roundrectborder(height: 5, width: 400),
              ],
            ),
          ),
        ],
      ),
    );
  }
}
