import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webblogdetail.dart';
import 'package:prakah/webpages/webdetails.dart';
import 'package:prakah/webpages/webebookdetail.dart';
import 'package:prakah/webwidget/footerweb.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class WebSearch extends StatefulWidget {
  final TextEditingController? searchController;
  const WebSearch({super.key, required this.searchController});

  @override
  State<WebSearch> createState() => _WebSearchState();
}

class _WebSearchState extends State<WebSearch> {
  SearchProvider searchProvider = SearchProvider();
  final ScrollController _scrollController = ScrollController();
  String? name;

  double? width;
  double? height;

  @override
  void initState() {
    super.initState();
    searchProvider = Provider.of<SearchProvider>(context, listen: false);
    _scrollController.addListener(_scrollListener);
    name = widget.searchController?.text ?? "";
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (searchProvider.currentPage ?? 0) < (searchProvider.totalPage ?? 0)) {
      printLog("load more====>");
      searchProvider.setLoadMore(true);
      if (searchProvider.layoutType == Constant.courseType) {
        _fetchData("3", searchProvider.currentPage ?? 0);
      } else if (searchProvider.layoutType == Constant.bookType) {
        _fetchData("2", searchProvider.currentPage ?? 0);
      } else {
        _fetchData("1", searchProvider.currentPage ?? 0);
      }
    }
  }

  Future<void> _fetchData(String type, int? nextPage) async {
    await searchProvider.getSearch(name ?? "", type, (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();

    searchProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.of(context).size.width;
    height = MediaQuery.of(context).size.height;
    return Scaffold(
      appBar: Utils.webMainAppbar(controller: widget.searchController),
      body: Utils.hoverItemWithPage(myWidget:
          Consumer<SearchProvider>(builder: (context, searchprovider, child) {
        return _buildSearch();
      })),
    );
  }

  Widget _buildSearch() {
    return SingleChildScrollView(
      controller: _scrollController,
      physics: BouncingScrollPhysics(),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 10,
        children: [
          tabButton(),
          setLayout(),
          if (searchProvider.loadMore)
            Utils.pageLoader()
          else
            const SizedBox.shrink(),
          SizedBox(height: 30),
          FooterWeb(),
        ],
      ),
    );
  }

  Widget tabButton() {
    return Container(
      margin: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(100, 16, 100, 0)
          : const EdgeInsets.fromLTRB(20, 16, 20, 0),
      padding: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(14),
        color: colorPrimary.withValues(alpha: 0.18),
      ),
      child: Row(
        mainAxisSize: MainAxisSize.min,
        spacing: 15,
        children: [
          InkWell(
            borderRadius: BorderRadius.circular(10),
            focusColor: transparent,
            highlightColor: transparent,
            hoverColor: transparent,
            splashColor: transparent,
            onTap: () {
              searchProvider.selectLayout(Constant.courseType);
              searchProvider.clearWishList();
              _fetchData("3", 0);
            },
            child: Container(
              padding: const EdgeInsets.all(10),
              alignment: Alignment.center,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(10),
                color: searchProvider.layoutType == Constant.courseType
                    ? colorPrimary
                    : transparent,
              ),
              child: MyText(
                  color: searchProvider.layoutType == Constant.courseType
                      ? white
                      : Theme.of(context).colorScheme.surface,
                  text: "course",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textSmall,
                  fontwaight: FontWeight.w600,
                  maxline: 3,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            ),
          ),
          InkWell(
            borderRadius: BorderRadius.circular(10),
            focusColor: transparent,
            highlightColor: transparent,
            hoverColor: transparent,
            splashColor: transparent,
            onTap: () {
              searchProvider.selectLayout(Constant.bookType);
              searchProvider.clearWishList();
              _fetchData("2", 0);
            },
            child: Container(
              padding: const EdgeInsets.all(10),
              alignment: Alignment.center,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(10),
                color: searchProvider.layoutType == Constant.bookType
                    ? colorPrimary
                    : transparent,
              ),
              child: MyText(
                  color: searchProvider.layoutType == Constant.bookType
                      ? white
                      : Theme.of(context).colorScheme.surface,
                  text: "book",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textSmall,
                  fontwaight: FontWeight.w600,
                  maxline: 3,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            ),
          ),
          InkWell(
            borderRadius: BorderRadius.circular(10),
            focusColor: transparent,
            highlightColor: transparent,
            hoverColor: transparent,
            splashColor: transparent,
            onTap: () {
              searchProvider.selectLayout(Constant.blogType);
              searchProvider.clearWishList();
              _fetchData("1", 0);
            },
            child: Container(
              padding: const EdgeInsets.all(10),
              alignment: Alignment.center,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(10),
                color: searchProvider.layoutType == Constant.blogType
                    ? colorPrimary
                    : transparent,
              ),
              child: MyText(
                  color: searchProvider.layoutType == Constant.blogType
                      ? white
                      : Theme.of(context).colorScheme.surface,
                  text: "blog",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textSmall,
                  fontwaight: FontWeight.w600,
                  maxline: 3,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            ),
          ),
        ],
      ),
    );
  }

  Widget setLayout() {
    if (searchProvider.loading && !searchProvider.loadMore) {
      return Padding(
        padding: MediaQuery.of(context).size.width > 800
            ? const EdgeInsets.fromLTRB(100, 25, 100, 20)
            : const EdgeInsets.fromLTRB(20, 25, 20, 20),
        child: (searchProvider.layoutType == Constant.courseType)
            ? courseShimmer()
            : (searchProvider.layoutType == Constant.bookType)
                ? bookShimmer()
                : blogShimmer(),
      );
    } else {
      if (searchProvider.searchList != null &&
          (searchProvider.searchList?.length ?? 0) > 0) {
        return Padding(
          padding: MediaQuery.of(context).size.width > 800
              ? const EdgeInsets.fromLTRB(100, 25, 100, 20)
              : const EdgeInsets.fromLTRB(20, 25, 20, 20),
          child: (searchProvider.layoutType == Constant.courseType)
              ? courseItem()
              : (searchProvider.layoutType == Constant.bookType)
                  ? buildBookItem()
                  : buildBlogItem(),
        );
      } else {
        return const NoData();
      }
    }
  }

  Widget courseItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
          minItemWidth: 120,
          minItemsPerRow: 2,
          maxItemsPerRow: Utils.customCrossAxisCount(
              context: context,
              height1600: 8,
              height1200: 6,
              height800: 4,
              height400: 2),
          horizontalGridSpacing: 16,
          verticalGridSpacing: 12,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics(),
          ),
          children:
              List.generate(searchProvider.searchList?.length ?? 0, (index) {
            return InkWell(
              onTap: () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    transitionDuration: const Duration(milliseconds: 200),
                    pageBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation) {
                      return WebDetail(
                          courseId:
                              searchProvider.searchList?[index].id.toString() ??
                                  "");
                    },
                    transitionsBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation,
                        Widget child) {
                      return Align(
                        child: FadeTransition(
                          opacity: animation,
                          child: child,
                        ),
                      );
                    },
                  ),
                );
              },
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 4,
                children: [
                  Stack(
                    children: [
                      MyNetworkImage(
                          imgWidth: MediaQuery.sizeOf(context).width,
                          imgHeight: 110,
                          fit: BoxFit.fill,
                          radius: 10,
                          islandscap: true,
                          imageUrl: searchProvider
                                  .searchList?[index].thumbnailImg
                                  .toString() ??
                              ""),
                      Positioned.fill(
                        top: 5,
                        left: 10,
                        right: 10,
                        child: Align(
                          alignment: Alignment.topRight,
                          child: InkWell(
                            splashColor: transparent,
                            focusColor: transparent,
                            hoverColor: transparent,
                            onTap: () {
                              if (Utils.checkLoginUser(context)) {
                                searchProvider.addRemoveWishlist(
                                  index,
                                  "3",
                                  searchProvider.searchList?[index].id
                                          .toString() ??
                                      "",
                                );
                              }
                            },
                            child: Container(
                              padding: EdgeInsets.all(6),
                              decoration: BoxDecoration(
                                  color: gray, shape: BoxShape.circle),
                              child: Icon(
                                searchProvider.searchList?[index].isWishlist ==
                                        1
                                    ? Icons.favorite
                                    : Icons.favorite_border,
                                color: searchProvider
                                            .searchList?[index].isWishlist ==
                                        1
                                    ? red
                                    : white,
                              ),
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text:
                          searchProvider.searchList?[index].title.toString() ??
                              "",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    spacing: 4,
                    children: [
                      Icon(
                        Icons.person_outline_rounded,
                        size: 16,
                        color: gray,
                      ),
                      MyText(
                          color: green,
                          text: searchProvider.searchList?[index].tutorName
                                  .toString() ??
                              "",
                          fontsizeNormal: Dimens.textMedium,
                          fontsizeWeb: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      MyText(
                          color: gray,
                          text: Utils.kmbGenerator(int.parse(searchProvider
                                  .searchList?[index].totalView
                                  .toString() ??
                              "")),
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      const SizedBox(width: 5),
                      MyText(
                          color: gray,
                          text: "students",
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          multilanguage: true,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  Row(
                    children: [
                      MyRating(
                        size: 15,
                        rating: double.parse(searchProvider
                                .searchList?[index].avgRating
                                .toString() ??
                            ""),
                        spacing: 2,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text:
                              "${double.parse(searchProvider.searchList?[index].avgRating.toString() ?? "")}",
                          fontsizeNormal: Dimens.textMedium,
                          fontwaight: FontWeight.w600,
                          maxline: 2,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (searchProvider.searchList?[index].isFree ?? 0) ==
                                  0 &&
                              (searchProvider.searchList?[index].isUserBuy ??
                                      0) ==
                                  0
                          ? "${Constant.currencyCode} ${searchProvider.searchList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            );
          })),
    );
  }

  Widget buildBookItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 3,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 8,
            height1200: 6,
            height800: 4,
            height400: 3),
        horizontalGridSpacing: 16,
        verticalGridSpacing: 12,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children:
            List.generate(searchProvider.searchList?.length ?? 0, (index) {
          return InkWell(
            onTap: () {
              Navigator.of(context).push(
                PageRouteBuilder(
                  pageBuilder: (context, animation, secondaryAnimation) =>
                      WebEbookDetails(
                    ebookId:
                        searchProvider.searchList?[index].id.toString() ?? "",
                    ebookName:
                        searchProvider.searchList?[index].title.toString() ??
                            "",
                  ),
                  transitionsBuilder:
                      (context, animation, secondaryAnimation, child) {
                    const begin = Offset(1.0, 0.0);
                    const end = Offset.zero;
                    const curve = Curves.ease;

                    var tween = Tween(begin: begin, end: end)
                        .chain(CurveTween(curve: curve));

                    return SlideTransition(
                      position: animation.drive(tween),
                      child: child,
                    );
                  },
                ),
              );
            },
            child: SizedBox(
              width: 150,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 4,
                children: [
                  Stack(
                    children: [
                      MyNetworkImage(
                          radius: 20,
                          imgWidth: width,
                          imgHeight: 155,
                          imageUrl: searchProvider
                                  .searchList?[index].thumbnailImg
                                  .toString() ??
                              "",
                          fit: BoxFit.fill),
                      Positioned.fill(
                        top: 5,
                        left: 10,
                        right: 10,
                        child: Align(
                          alignment: Alignment.topRight,
                          child: InkWell(
                            splashColor: transparent,
                            focusColor: transparent,
                            hoverColor: transparent,
                            onTap: () {
                              if (Utils.checkLoginUser(context)) {
                                searchProvider.addRemoveWishlist(
                                  index,
                                  "2",
                                  searchProvider.searchList?[index].id
                                          .toString() ??
                                      "",
                                );
                              }
                            },
                            child: Container(
                              padding: EdgeInsets.all(6),
                              decoration: BoxDecoration(
                                  color: gray, shape: BoxShape.circle),
                              child: Icon(
                                searchProvider.searchList?[index].isWishlist ==
                                        1
                                    ? Icons.favorite
                                    : Icons.favorite_border,
                                color: searchProvider
                                            .searchList?[index].isWishlist ==
                                        1
                                    ? red
                                    : white,
                              ),
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                  const SizedBox(height: 10),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text:
                          searchProvider.searchList?[index].title.toString() ??
                              "",
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textSmall,
                      maxline: 1,
                      fontwaight: FontWeight.w600,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  MyText(
                      color: gray,
                      text: searchProvider.searchList?[index].tutorName
                              .toString() ??
                          "",
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textSmall,
                      maxline: 2,
                      fontwaight: FontWeight.w600,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    children: [
                      MyRating(
                        size: 13,
                        rating: double.parse(
                          searchProvider.searchList?[index].avgRating
                                  .toString() ??
                              "",
                        ),
                        spacing: 3,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text: "${double.parse(
                            searchProvider.searchList?[index].avgRating
                                    .toString() ??
                                "",
                          )}",
                          fontsizeNormal: Dimens.textBigSmall,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (searchProvider.searchList?[index].isFree ?? 0) ==
                                  0 &&
                              (searchProvider.searchList?[index].isUserBuy ??
                                      0) ==
                                  0
                          ? "${Constant.currencyCode} ${searchProvider.searchList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          );
        }),
      ),
    );
  }

/* Blog Data */

  Widget buildBlogItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 300,
        minItemsPerRow: 1,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 6,
            height1200: 4,
            height800: 2,
            height400: 2),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children:
            List.generate(searchProvider.searchList?.length ?? 0, (index) {
          return InkWell(
            onTap: () {
              Navigator.of(context).push(
                PageRouteBuilder(
                  pageBuilder: (context, animation, secondaryAnimation) =>
                      WebBlogDetail(
                    blogId:
                        searchProvider.searchList?[index].id.toString() ?? "",
                  ),
                  transitionsBuilder:
                      (context, animation, secondaryAnimation, child) {
                    const begin = Offset(1.0, 0.0);
                    const end = Offset.zero;
                    const curve = Curves.ease;

                    var tween = Tween(begin: begin, end: end)
                        .chain(CurveTween(curve: curve));

                    return SlideTransition(
                      position: animation.drive(tween),
                      child: child,
                    );
                  },
                ),
              );
            },
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                Stack(
                  children: [
                    MyNetworkImage(
                        radius: 20,
                        imgWidth: width,
                        imgHeight: 155,
                        imageUrl: searchProvider.searchList?[index].image
                                .toString() ??
                            "",
                        fit: BoxFit.fill),
                    Positioned.fill(
                      top: 5,
                      left: 10,
                      right: 10,
                      child: Align(
                        alignment: Alignment.topRight,
                        child: InkWell(
                          splashColor: transparent,
                          focusColor: transparent,
                          hoverColor: transparent,
                          onTap: () {
                            if (Utils.checkLoginUser(context)) {
                              searchProvider.addRemoveWishlist(
                                index,
                                "1",
                                searchProvider.searchList?[index].id
                                        .toString() ??
                                    "",
                              );
                            }
                          },
                          child: Container(
                            padding: EdgeInsets.all(6),
                            decoration: BoxDecoration(
                                color: gray, shape: BoxShape.circle),
                            child: Icon(
                              searchProvider.searchList?[index].isWishlist == 1
                                  ? Icons.favorite
                                  : Icons.favorite_border,
                              color: searchProvider
                                          .searchList?[index].isWishlist ==
                                      1
                                  ? red
                                  : white,
                            ),
                          ),
                        ),
                      ),
                    ),
                  ],
                ),
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text: searchProvider.searchList?[index].title.toString() ??
                        "",
                    fontsizeNormal: Dimens.textBig,
                    fontsizeWeb: Dimens.textSmall,
                    maxline: 1,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                MyText(
                    color: gray,
                    text: searchProvider.searchList?[index].tutorName
                            .toString() ??
                        "",
                    fontsizeNormal: Dimens.textMedium,
                    fontsizeWeb: Dimens.textSmall,
                    maxline: 2,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
          );
        }),
      ),
    );
  }

  Widget courseShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 2,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 6,
            height1200: 4,
            height800: 2,
            height400: 2),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(
          10,
          (index) {
            return Container(
              width: 200,
              margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  CustomWidget.rectangular(
                    width: MediaQuery.sizeOf(context).width,
                    height: 110,
                  ),
                  const SizedBox(height: 8),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                ],
              ),
            );
          },
        ),
      ),
    );
  }

  Widget bookShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 3,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 8,
            height1200: 6,
            height800: 4,
            height400: 3),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(10, (index) {
          return SizedBox(
            width: 140,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                CustomWidget.roundrectborder(
                  width: width ?? 0,
                  height: 155,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
              ],
            ),
          );
        }),
      ),
    );
  }

  Widget blogShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 300,
        minItemsPerRow: 1,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 6,
            height1200: 4,
            height800: 2,
            height400: 2),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(10, (index) {
          return Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 4,
            children: [
              Stack(
                children: [
                  CustomWidget.roundcorner(width: width ?? 0, height: 155),
                  Positioned.fill(
                    top: 5,
                    left: 10,
                    right: 10,
                    child: Align(
                      alignment: Alignment.topRight,
                      child: CustomWidget.circular(width: 30, height: 30),
                    ),
                  ),
                ],
              ),
              CustomWidget.roundcorner(width: width ?? 0.0, height: 16),
              CustomWidget.roundcorner(width: (width ?? 0.0) * 0.5, height: 14),
            ],
          );
        }),
      ),
    );
  }
}
