import 'dart:io';

import 'package:prakah/utils/constant.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/foundation.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:intl_phone_field/country_picker_dialog.dart';
import 'package:intl_phone_field/intl_phone_field.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/weblogin.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

class WebRegister extends StatefulWidget {
  const WebRegister({super.key});

  @override
  State<WebRegister> createState() => WebRegisterState();
}

class WebRegisterState extends State<WebRegister> {
  late GeneralProvider generalProvider;
  TextEditingController fullnameController = TextEditingController();
  TextEditingController emailController = TextEditingController();
  TextEditingController passwordController = TextEditingController();
  TextEditingController confPasswordController = TextEditingController();
  TextEditingController numberController = TextEditingController();
  bool obscureTextPassword = true;
  bool obscureTextPassword1 = true;
  String? strDeviceType, strDeviceToken;

  String? mobilenumber = "",
      countrycode = "",
      countryname = "",
      strPrivacyAndTNC = "";

  @override
  void initState() {
    super.initState();
    generalProvider = Provider.of<GeneralProvider>(context, listen: false);
    _getDeviceToken();
    _getData();
  }

  Future<void> _getDeviceToken() async {
    try {
      if (kIsWeb) {
        strDeviceType = "3";
        strDeviceToken = Constant.webToken;
      } else {
        if (Platform.isAndroid) {
          strDeviceType = "1";
        } else {
          strDeviceType = "2";
        }
        strDeviceToken = await FirebaseMessaging.instance.getToken();
      }
    } catch (e) {
      printLog("_getDeviceToken Exception ===> $e");
    }
  }

  Future<void> _getData() async {
    String? privacyUrl, termsConditionUrl;
    await generalProvider.getPages();
    if (!generalProvider.loading) {
      if (generalProvider.getPageModel.status == 200 &&
          generalProvider.getPageModel.result != null) {
        if ((generalProvider.getPageModel.result?.length ?? 0) > 0) {
          for (var i = 0;
              i < (generalProvider.getPageModel.result?.length ?? 0);
              i++) {
            if ((generalProvider.getPageModel.result?[i].pageName ?? "")
                .toLowerCase()
                .contains("privacy")) {
              privacyUrl = generalProvider.getPageModel.result?[i].url;
            }
            if ((generalProvider.getPageModel.result?[i].pageName ?? "")
                .toLowerCase()
                .contains("terms")) {
              termsConditionUrl = generalProvider.getPageModel.result?[i].url;
            }
          }
        }
      }
    }

    strPrivacyAndTNC = await Utils.getPrivacyTandCText(
      privacyUrl: privacyUrl ?? "",
      termsConditionUrl: termsConditionUrl ?? "",
    );
    printLog('strPrivacyAndTNC ==> $strPrivacyAndTNC');
  }

  @override
  void dispose() {
    generalProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: white,
      body:
          Consumer<GeneralProvider>(builder: (context, generalprovider, child) {
        return Row(
          children: [
            MediaQuery.of(context).size.width > 800
                ? Expanded(
                    child: MyImage(
                    width: MediaQuery.of(context).size.width > 1200
                        ? MediaQuery.of(context).size.width * 0.5
                        : MediaQuery.of(context).size.width > 800
                            ? MediaQuery.of(context).size.width * 0.30
                            : MediaQuery.of(context).size.width,
                    height: MediaQuery.sizeOf(context).height,
                    imagePath: 'web_login_bg.png',
                    fit: BoxFit.cover,
                  ))
                : SizedBox.shrink(),
            Expanded(
              child: Container(
                width: MediaQuery.sizeOf(context).width,
                height: MediaQuery.sizeOf(context).height,
                alignment: Alignment.center,
                padding: MediaQuery.of(context).size.width > 1200
                    ? EdgeInsets.fromLTRB(100, 40, 100, 40)
                    : MediaQuery.of(context).size.width > 600
                        ? EdgeInsets.fromLTRB(40, 40, 40, 40)
                        : EdgeInsets.fromLTRB(20, 40, 20, 40),
                decoration: const BoxDecoration(color: white),
                child: SingleChildScrollView(
                  child: Column(
                    children: [
                      InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        highlightColor: transparent,
                        onTap: () {
                          if (Navigator.canPop(context)) {
                            Navigator.pop(context);
                          }
                        },
                        child: Align(
                          alignment: Alignment.topRight,
                          child: Container(
                            padding: EdgeInsets.all(4),
                            decoration: BoxDecoration(
                                shape: BoxShape.circle,
                                color: colorPrimaryDark),
                            child: Icon(
                              Icons.close,
                              size: 20,
                              color: white,
                            ),
                          ),
                        ),
                      ),
                      SizedBox(height: 60),
                      Center(
                          child: MyImage(
                        width: 150,
                        height: 150,
                        imagePath: 'appiconweb.png',
                        fit: BoxFit.contain,
                        isAppicon: true,
                      )),
                      const SizedBox(height: 15),
                      MyText(
                          text: "signup",
                          fontsizeWeb: Dimens.textExtraBig,
                          fontsizeNormal: Dimens.textExtraBig,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.center,
                          multilanguage: true,
                          fontstyle: FontStyle.normal),
                      const SizedBox(height: 20),
                      MyText(
                          text: "sign_up_details",
                          fontsizeWeb: Dimens.textBig,
                          fontsizeNormal: Dimens.textExtraBig,
                          fontwaight: FontWeight.w400,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.center,
                          multilanguage: true,
                          fontstyle: FontStyle.normal),
                      const SizedBox(height: 20),
                      registerField(),
                      _rememberData(),
                      const SizedBox(height: 30),
                      signUpBtn(),
                      const SizedBox(height: 10),
                      loginText(),
                    ],
                  ),
                ),
              ),
            )
          ],
        );
      }),
    );
  }

  Widget registerField() {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      crossAxisAlignment: CrossAxisAlignment.start,
      spacing: 10,
      children: [
        MyText(
            color: black,
            text: "full_name",
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            multilanguage: true,
            fontstyle: FontStyle.normal),
        TextFormField(
          obscureText: false,
          keyboardType: TextInputType.text,
          controller: fullnameController,
          textInputAction: TextInputAction.next,
          cursorColor: black,
          style: GoogleFonts.lato(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: black,
              fontWeight: FontWeight.w600),
          decoration: InputDecoration(
            prefixIcon: Icon(
              Icons.person,
              size: 20,
              color: gray,
            ),
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            hintText: "John Doe",
            hintStyle: GoogleFonts.lato(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                color: gray.withValues(alpha: 0.50),
                fontWeight: FontWeight.w400),
          ),
        ),
        MyText(
            color: black,
            text: "email_address",
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            multilanguage: true,
            fontstyle: FontStyle.normal),
        TextFormField(
          obscureText: false,
          keyboardType: TextInputType.emailAddress,
          controller: emailController,
          textInputAction: TextInputAction.next,
          cursorColor: black,
          style: GoogleFonts.lato(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: black,
              fontWeight: FontWeight.w600),
          decoration: InputDecoration(
            prefixIcon: Icon(
              Icons.mail,
              size: 20,
              color: gray,
            ),
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            hintText: "example@gmail.com",
            hintStyle: GoogleFonts.lato(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                color: gray.withValues(alpha: 0.50),
                fontWeight: FontWeight.w400),
          ),
        ),
        MyText(
            color: black,
            text: "mobile_number",
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            multilanguage: true,
            fontstyle: FontStyle.normal),
        IntlPhoneField(
          disableLengthCheck: true,
          textAlignVertical: TextAlignVertical.center,
          cursorColor: Theme.of(context).colorScheme.surface,
          autovalidateMode: AutovalidateMode.disabled,
          controller: numberController,
          style: GoogleFonts.lato(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: Theme.of(context).colorScheme.surface,
              letterSpacing: 1.0,
              fontWeight: FontWeight.w600),
          showCountryFlag: true,
          showDropdownIcon: false,
          initialCountryCode: Constant.initialCountryCode,
          pickerDialogStyle: PickerDialogStyle(
              backgroundColor: white,
              countryNameStyle: GoogleFonts.lato(color: gray),
              countryCodeStyle: GoogleFonts.lato(color: gray)),
          dropdownTextStyle: GoogleFonts.lato(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: Theme.of(context).colorScheme.surface,
              letterSpacing: 1.0,
              fontWeight: FontWeight.w600),
          keyboardType: TextInputType.number,
          textInputAction: TextInputAction.next,
          decoration: InputDecoration(
            hintStyle: GoogleFonts.inter(
                fontSize: Dimens.textSmall,
                fontStyle: FontStyle.normal,
                letterSpacing: 1.0,
                color: gray.withValues(alpha: 0.50),
                fontWeight: FontWeight.w400),
            hintText: "245786534",
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
          ),
          onChanged: (phone) {
            mobilenumber = phone.completeNumber;
            countryname = phone.countryISOCode;
            countrycode = phone.countryCode;
          },
          onCountryChanged: (country) {
            countryname = country.code.replaceAll('+', '');
            countrycode = "+${country.dialCode.toString()}";
          },
        ),
        MyText(
            color: black,
            text: "password",
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            multilanguage: true,
            fontstyle: FontStyle.normal),
        TextFormField(
          obscureText: obscureTextPassword,
          keyboardType: TextInputType.visiblePassword,
          controller: passwordController,
          textInputAction: TextInputAction.done,
          cursorColor: black,
          style: GoogleFonts.lato(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: black,
              fontWeight: FontWeight.w600),
          decoration: InputDecoration(
            suffixIcon: InkWell(
              onTap: () {
                setState(() {
                  obscureTextPassword = !obscureTextPassword;
                });
              },
              child: Container(
                width: 25,
                height: 25,
                alignment: Alignment.center,
                child: Icon(
                  obscureTextPassword ? Icons.visibility : Icons.visibility_off,
                  color: gray,
                ),
              ),
            ),
            prefixIcon: Icon(
              Icons.lock,
              size: 20,
              color: gray,
            ),
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: gray.withValues(alpha: 0.50)),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: gray.withValues(alpha: 0.50)),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: gray.withValues(alpha: 0.50)),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: gray.withValues(alpha: 0.50)),
            ),
            hintText: "● ● ● ● ● ●",
            hintStyle: GoogleFonts.lato(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                color: gray.withValues(alpha: 0.50),
                fontWeight: FontWeight.w400),
          ),
          onChanged: (value) {},
        ),
        MyText(
            color: black,
            text: "conf_password",
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            multilanguage: true,
            fontstyle: FontStyle.normal),
        TextFormField(
          obscureText: obscureTextPassword1,
          keyboardType: TextInputType.visiblePassword,
          controller: confPasswordController,
          textInputAction: TextInputAction.done,
          cursorColor: black,
          style: GoogleFonts.lato(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: black,
              fontWeight: FontWeight.w600),
          decoration: InputDecoration(
            suffixIcon: InkWell(
              onTap: () {
                setState(() {
                  obscureTextPassword1 = !obscureTextPassword1;
                });
              },
              child: Container(
                width: 25,
                height: 25,
                alignment: Alignment.center,
                child: Icon(
                  obscureTextPassword1
                      ? Icons.visibility
                      : Icons.visibility_off,
                  color: gray,
                ),
              ),
            ),
            prefixIcon: Icon(
              Icons.lock,
              size: 20,
              color: gray,
            ),
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: gray.withValues(alpha: 0.50)),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: gray.withValues(alpha: 0.50)),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: gray.withValues(alpha: 0.50)),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: gray.withValues(alpha: 0.50)),
            ),
            hintText: "● ● ● ● ● ●",
            hintStyle: GoogleFonts.lato(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                color: gray.withValues(alpha: 0.50),
                fontWeight: FontWeight.w400),
          ),
          onChanged: (value) {},
        ),
      ],
    );
  }

  Widget _rememberData() {
    if (strPrivacyAndTNC != null) {
      return Row(
        spacing: 20,
        crossAxisAlignment: CrossAxisAlignment.center,
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          Flexible(
            fit: FlexFit.loose,
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              mainAxisAlignment: MainAxisAlignment.start,
              spacing: 5,
              children: [
                Checkbox(
                  activeColor: colorPrimary,
                  autofocus: true,
                  checkColor: white,
                  hoverColor: transparent,
                  mouseCursor: MouseCursor.defer,
                  splashRadius: 2,
                  side: BorderSide(
                      width: 1, color: webTextFiled, style: BorderStyle.solid),
                  value: generalProvider.isCheck,
                  onChanged: (value) {
                    generalProvider.setCheck(value!);
                  },
                ),
                Flexible(
                  fit: FlexFit.loose,
                  child: Utils.htmlTexts(context, strPrivacyAndTNC),
                ),
              ],
            ),
          ),
        ],
      );
    } else {
      return SizedBox.shrink();
    }
  }

  Widget signUpBtn() {
    if (!generalProvider.isCheck) {
      return Container(
        width: MediaQuery.of(context).size.width,
        height: 45,
        alignment: Alignment.center,
        decoration: BoxDecoration(
          color: gray.withValues(alpha: 0.7),
          borderRadius: BorderRadius.circular(10),
        ),
        child: MyText(
          color: white,
          text: "signup",
          fontsizeNormal: Dimens.textTitle,
          fontsizeWeb: Dimens.textTitle,
          fontwaight: FontWeight.w600,
          maxline: 1,
          multilanguage: true,
          overflow: TextOverflow.ellipsis,
          textalign: TextAlign.center,
          fontstyle: FontStyle.normal,
        ),
      );
    } else {
      return InkWell(
        onTap: () async {
          if (fullnameController.text.isEmpty) {
            Utils.showSnackbar(context, "fail", "pleasenterfullname", true);
          } else if (emailController.text.isEmpty) {
            Utils.showSnackbar(context, "fail", "pleasenteremail", true);
          } else if (numberController.text.isEmpty) {
            Utils.showSnackbar(context, "fail", "pleaseenteryourmobile", true);
          } else if (passwordController.text.isEmpty) {
            Utils.showSnackbar(
                context, "fail", "pleaseenteryourpassword", true);
          } else if (passwordController.text.length < 6) {
            Utils.showSnackbar(
                context, "fail", "pleaseenterpasswordonlysixdigit", true);
          } else if (confPasswordController.text != passwordController.text) {
            Utils.showSnackbar(context, "fail", "confirm_message_pass", true);
          } else {
            generalProvider.setLoading(true);
            await generalProvider.getRegister(
              fullnameController.text,
              emailController.text,
              numberController.text,
              passwordController.text,
              countrycode,
              countryname,
              strDeviceType,
              strDeviceToken,
            );

            if (generalProvider.loginmodel.status == 200) {
              generalProvider.setLoading(false);
              if (!mounted) return;

              Utils.navigatePage(context, const WebLogin(), "");
            } else {
              generalProvider.setLoading(false);
              if (!mounted) return;
              Utils.showSnackbar(context, "fail",
                  generalProvider.loginmodel.message ?? "", false);
            }
          }
        },
        child: AnimatedContainer(
          duration: const Duration(milliseconds: 80),
          clipBehavior: Clip.antiAliasWithSaveLayer,
          curve: Curves.bounceInOut,
          width: generalProvider.isProgressLoading
              ? 100
              : MediaQuery.of(context).size.width,
          height: 45,
          alignment: Alignment.center,
          decoration: BoxDecoration(
            color: colorPrimary,
            borderRadius: BorderRadius.circular(10),
          ),
          child: generalProvider.isProgressLoading
              ? const SizedBox(
                  width: 25,
                  height: 25,
                  child: CircularProgressIndicator(
                    color: white,
                    strokeWidth: 2,
                  ),
                )
              : MyText(
                  color: white,
                  text: "signup",
                  fontsizeNormal: Dimens.textTitle,
                  fontsizeWeb: Dimens.textTitle,
                  fontwaight: FontWeight.w600,
                  maxline: 1,
                  multilanguage: true,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.center,
                  fontstyle: FontStyle.normal,
                ),
        ),
      );
    }
  }

  Widget loginText() {
    return InkWell(
      onTap: () {
        Utils.navigatePage(context, const WebLogin(), "1");
      },
      child: Row(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          MyText(
              color: gray,
              text: "alreadyhaveanaccount",
              fontsizeWeb: Dimens.textMedium,
              fontsizeNormal: Dimens.textMedium,
              fontwaight: FontWeight.w400,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              fontstyle: FontStyle.normal,
              multilanguage: true),
          const SizedBox(width: 5),
          MyText(
              color: colorPrimary,
              text: "login",
              fontsizeWeb: Dimens.textMedium,
              fontsizeNormal: Dimens.textMedium,
              fontwaight: FontWeight.w500,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              fontstyle: FontStyle.normal,
              multilanguage: true),
        ],
      ),
    );
  }
}
