import 'dart:io';

import 'package:prakah/pages/nodata.dart';
import 'package:prakah/pages/readbook.dart';
import 'package:prakah/provider/couponprovider.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/provider/meetingprovider.dart';
import 'package:prakah/provider/profileprovider.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/subscription/allpayment.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webdetails.dart';
import 'package:prakah/webpages/weblogin.dart';
import 'package:prakah/webpages/webmycourse.dart';
import 'package:prakah/webpages/websearch.dart';
import 'package:prakah/webpages/webwishlist.dart';
import 'package:prakah/webwidget/footerweb.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:easy_date_timeline/easy_date_timeline.dart';
import 'package:firebase_auth/firebase_auth.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:font_awesome_flutter/font_awesome_flutter.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:google_sign_in/google_sign_in.dart';
import 'package:intl/intl.dart';
import 'package:intl_phone_field/country_picker_dialog.dart';
import 'package:intl_phone_field/intl_phone_field.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';
import '../model/packagemodel.dart';

class WebProfile extends StatefulWidget {
  const WebProfile({super.key});

  @override
  State<WebProfile> createState() => _WebProfileState();
}

class _WebProfileState extends State<WebProfile> {
  ProfileProvider profileProvider = ProfileProvider();
  MeetingProvider meetingProvider = MeetingProvider();
  CouponProvider couponProvider = CouponProvider();
  final FirebaseAuth _auth = FirebaseAuth.instance;
  final ScrollController _scrollController = ScrollController();
  final ScrollController _scrollCouponController = ScrollController();
  final TextEditingController walletController = TextEditingController();

  final TextEditingController userNameController = TextEditingController();
  final TextEditingController nameController = TextEditingController();
  final TextEditingController emailController = TextEditingController();
  final TextEditingController numberController = TextEditingController();
  String? countrycode = "", countryname = "", showType = "0";

  final TextEditingController detsilsController = TextEditingController();
  final searchController = TextEditingController();
  String? strDeviceType, strDeviceToken;
  List weekDayList = [
    'Monday',
    'Tuesday',
    'Wednesday',
    'Thursday',
    'Friday',
    'Saturday',
    'Sunday',
  ];
  @override
  void initState() {
    super.initState();
    profileProvider = Provider.of<ProfileProvider>(context, listen: false);
    meetingProvider = Provider.of<MeetingProvider>(context, listen: false);
    couponProvider = Provider.of<CouponProvider>(context, listen: false);
    _scrollController.addListener(_scrollListener);
    _scrollCouponController.addListener(_scrollCouponeListener);
    _getDeviceToken();

    getApi();
  }

  Future<void> _getDeviceToken() async {
    try {
      if (kIsWeb) {
        strDeviceType = "3";
        strDeviceToken = Constant.webToken;
      } else {
        if (Platform.isAndroid) {
          strDeviceType = "1";
        } else {
          strDeviceType = "2";
        }
        strDeviceToken = await FirebaseMessaging.instance.getToken();
      }
    } catch (e) {
      printLog("_getDeviceToken Exception ===> $e");
    }
    printLog("===>diviceType $strDeviceType");
    printLog("===>diviceToken $strDeviceToken");
  }

/* Coupone Data */
  void _scrollCouponeListener() {
    if (!_scrollCouponController.hasClients) return;
    if (_scrollCouponController.offset >=
            _scrollCouponController.position.maxScrollExtent &&
        !_scrollCouponController.position.outOfRange &&
        (couponProvider.currentPage ?? 0) < (couponProvider.totalPage ?? 0)) {
      couponProvider.setLoadMore(true);
      getCouponApi(couponProvider.currentPage ?? 0);
    }
  }

  Future<void> getCouponApi(int? nextPage) async {
    await couponProvider.getUseMeeting((nextPage ?? 0) + 1);
  }

/* END */

  Future<void> getApi() async {
    await profileProvider.getprofile(context);
    if (profileProvider.profileModel.status == 200) {
      userNameController.text =
          profileProvider.profileModel.result?[0].userName.toString() ?? "";
      nameController.text =
          profileProvider.profileModel.result?[0].fullName.toString() ?? "";
      emailController.text =
          profileProvider.profileModel.result?[0].email.toString() ?? "";
      numberController.text =
          profileProvider.profileModel.result?[0].mobileNumber.toString() ?? "";
      countrycode =
          profileProvider.profileModel.result?[0].countryCode.toString() ?? "";
      countryname =
          profileProvider.profileModel.result?[0].countryName.toString() ?? "";
    }
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange) {
      if (profileProvider.webSelect == "3") {
        if ((meetingProvider.currentPage ?? 0) <
            (meetingProvider.totalPage ?? 0)) {
          if (meetingProvider.selectedIndex == "1") {
            _fetchMeetingData(meetingProvider.courseId ?? "",
                meetingProvider.currentPage ?? 0);
          } else {
            _fetchUserData(
                meetingProvider.myTab, meetingProvider.currentPage ?? 0);
          }
        }
      } else {
        if ((profileProvider.currentPage ?? 0) <
            (profileProvider.totalPage ?? 0)) {
          profileProvider.setLoadMore(true);
          if (profileProvider.webSelect == "5") {
            _fetchData(profileProvider.currentPage ?? 0);
          } else if (profileProvider.webSelect == "4") {
            getApiData(profileProvider.selectType ?? "",
                profileProvider.currentPage ?? 0);
          } else if (profileProvider.webSelect == "9") {
            _fetcCoursehData(profileProvider.currentPage ?? 0);
          } else {
            printLog("No Pagenation");
          }
        }
      }
    }
  }

  Future<void> _fetcCoursehData(int? nextPage) async {
    await profileProvider.getMyCourse((nextPage ?? 0) + 1);
  }

  Future<void> getApiData(String type, pageno) async {
    await profileProvider.getSectionList(type, (pageno ?? 0) + 1);
  }

  Future<void> _fetchData(int? nextPage) async {
    await profileProvider.getPackage((nextPage ?? 0) + 1);
  }

  Future<void> getMeetingApi() async {
    await meetingProvider.getCourseName();
    await _fetchMeetingData(meetingProvider.courseId ?? "", 0);
  }

  Future<void> _fetchMeetingData(dynamic ids, int? nextPage) async {
    meetingProvider.getMeeting(ids, (nextPage ?? 0) + 1);
  }

  Future<void> _fetchUserData(dynamic status, int? nextPage) async {
    await meetingProvider.getUseMeeting(status, (nextPage ?? 0) + 1);
  }

/* Appointment Api */

  Future<void> getAppointmentApi() async {
    await Future.wait([
      profileProvider.getCourseName(),
      getTimeSoltApi(profileProvider.selectedValue),
    ]);
  }

  Future<void> getTimeSoltApi(DateTime time) async {
    await profileProvider.getTimeSlot(profileProvider.meetingId ?? "", time);
  }

  EdgeInsets getResponsivePadding(BuildContext context) {
    final width = MediaQuery.of(context).size.width;

    if (width > 1200) return const EdgeInsets.symmetric(horizontal: 200);
    if (width > 1000) return const EdgeInsets.symmetric(horizontal: 120);
    if (width > 800) return const EdgeInsets.symmetric(horizontal: 80);
    return const EdgeInsets.symmetric(horizontal: 20);
  }

  @override
  void dispose() {
    _scrollController.dispose();
    _scrollCouponController.dispose();
    profileProvider.clearWeb();
    couponProvider.clearProvider();
    meetingProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return _buildSearchHome();
  }

  Widget _buildSearchHome() {
    return Consumer<SearchProvider>(builder: (context, homeprovider, child) {
      if (homeprovider.isSearch == "0") {
        return Scaffold(
          appBar: Utils.webMainAppbar(controller: searchController),
          body: _buildWebProfileData(),
        );
      } else {
        return WebSearch(
          searchController: searchController,
        );
      }
    });
  }

  Widget _buildWebProfileData() {
    return Consumer<ProfileProvider>(
        builder: (context, profileProvider, child) {
      return Utils.hoverItemWithPage(
        myWidget: SingleChildScrollView(
          controller: _scrollController,
          physics: AlwaysScrollableScrollPhysics(),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 20,
            children: [
              (profileProvider.webSelect == "3")
                  ? buildAppBar()
                  : Utils.buildWebDetailsAppBar(
                      context: context,
                      title: profileProvider.webSelectTabName ?? ""),
              showType == "0" ? _buildData() : successAppoinment(),
              if (profileProvider.loadMore)
                Container(
                  height: 50,
                  margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                  child: Utils.pageLoader(),
                )
              else
                const SizedBox.shrink(),
              FooterWeb()
            ],
          ),
        ),
      );
    });
  }

/* Main app bar data */
  Widget buildAppBar() {
    return Container(
      height: 75,
      width: MediaQuery.sizeOf(context).width,
      color: gray.withValues(alpha: 0.3),
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
          : const EdgeInsets.fromLTRB(20, 0, 20, 0),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        spacing: 14,
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            highlightColor: transparent,
            onTap: () {
              if (Navigator.canPop(context)) {
                Navigator.pop(context);
              }
            },
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              spacing: 14,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Icon(
                  Icons.home,
                  size: 25,
                  color: black.withValues(alpha: 0.4),
                ),
                MyText(
                  text: "home",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textMedium,
                  fontsizeWeb: Dimens.textTitle,
                  fontwaight: FontWeight.w600,
                  color: black,
                ),
              ],
            ),
          ),
          InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: () {
              profileProvider.setAppoinment(
                index: "0",
                name: "",
                ids: "",
              );
            },
            child: Row(
              children: [
                Icon(
                  Icons.keyboard_arrow_right_rounded,
                  size: 25,
                  color: black.withValues(alpha: 0.4),
                ),
                MyText(
                  text: profileProvider.webSelectTabName ?? "",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textMedium,
                  fontsizeWeb: Dimens.textTitle,
                  fontwaight: FontWeight.w600,
                  color: (profileProvider.isAppoinment == "0")
                      ? colorPrimaryDark
                      : black,
                ),
              ],
            ),
          ),
          (profileProvider.isAppoinment == "0")
              ? SizedBox.shrink()
              : InkWell(
                  splashColor: transparent,
                  focusColor: transparent,
                  hoverColor: transparent,
                  onTap: () {
                    profileProvider.setConfAppoinment(
                        index: "0",
                        name: "",
                        ids: profileProvider.meetingId ?? "");
                  },
                  child: Row(
                    children: [
                      Icon(
                        Icons.keyboard_arrow_right_rounded,
                        size: 25,
                        color: black.withValues(alpha: 0.4),
                      ),
                      MyText(
                        text: profileProvider.isAppoinmentName,
                        multilanguage: true,
                        fontsizeNormal: Dimens.textMedium,
                        fontsizeWeb: Dimens.textTitle,
                        fontwaight: FontWeight.w600,
                        color: (profileProvider.isConfAppoinment == "0")
                            ? colorPrimaryDark
                            : black,
                      ),
                    ],
                  ),
                ),
          (profileProvider.isConfAppoinment == "0")
              ? SizedBox.shrink()
              : InkWell(
                  splashColor: transparent,
                  focusColor: transparent,
                  hoverColor: transparent,
                  onTap: () {},
                  child: Row(
                    children: [
                      Icon(
                        Icons.keyboard_arrow_right_rounded,
                        size: 25,
                        color: black.withValues(alpha: 0.4),
                      ),
                      MyText(
                        text: profileProvider.isConfAppoinmentName,
                        multilanguage: true,
                        fontsizeNormal: Dimens.textMedium,
                        fontsizeWeb: Dimens.textTitle,
                        fontwaight: FontWeight.w600,
                        color: colorPrimaryDark,
                      ),
                    ],
                  ),
                )
        ],
      ),
    );
  }

  /* Profile Data show */
  Widget _buildData() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 1000
          ? const EdgeInsets.fromLTRB(200, 25, 200, 0)
          : const EdgeInsets.fromLTRB(20, 25, 20, 0),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          leftSideData(),
          SizedBox(width: 20),
          Expanded(child: rightSideData())
        ],
      ),
    );
  }

  Widget leftSideData() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      spacing: 10,
      children: [
        MyText(
          text: "manage_account",
          multilanguage: true,
          fontsizeNormal: Dimens.textTitle,
          fontsizeWeb: Dimens.textTitle,
          fontwaight: FontWeight.w600,
          color: colorPrimaryDark,
        ),
        _buildWidget(
          onTap: () {
            profileProvider.setWebSelect("1", "my_profile");
            profileProvider.clearWebContent();
            getApi();
          },
          title: "my_profile",
          count: "1",
        ),
        _buildWidget(
          onTap: () {
            profileProvider.setWebSelect("2", "certificate");
          },
          title: "certificate",
          count: "2",
        ),
        _buildWidget(
          onTap: () {
            profileProvider.setWebSelect("3", "tutor_meetings");

            /* Api Call */
            profileProvider.clearWebContent();
            meetingProvider.clearProvider();
            meetingProvider.setLoading(false);
            getMeetingApi();
          },
          title: "tutor_meetings",
          count: "3",
        ),
        _buildWidget(
          onTap: () {
            profileProvider.setWebSelect("4", "wishlist");

            /* Api Call */
            profileProvider.clearWebContent();
            meetingProvider.clearProvider();
            meetingProvider.setLoading(false);
            getMeetingApi();
          },
          title: "wishlist",
          count: "4",
        ),
        _buildWidget(
          onTap: () {
            profileProvider.setWebSelect("9", "mycourse");
            profileProvider.clearWebContent();
            _fetcCoursehData(0);
          },
          title: "mycourse",
          count: "9",
        ),
        _buildWidget(
          onTap: () {
            profileProvider.setWebSelect("10", "my_purchases");
            /* APi Call */
            profileProvider.clearWebContent();

            getApiData("4", 0);
          },
          title: "my_purchases",
          count: "10",
        ),
        MyText(
          text: "my_wallet",
          multilanguage: true,
          fontsizeNormal: Dimens.textTitle,
          fontsizeWeb: Dimens.textTitle,
          fontwaight: FontWeight.w600,
          color: colorPrimaryDark,
        ),
        _buildWidget(
          onTap: () {
            profileProvider.setWebSelect("5", "my_transactions");
            /* APi Call */
            profileProvider.clearWebContent();

            getApiData("1", 0);
          },
          title: "my_transactions",
          count: "5",
        ),
        _buildWidget(
          onTap: () {
            profileProvider.setWebSelect("6", "subscription_plan");
            /* APi Call */
            profileProvider.clearWebContent();
            _fetchData(0);
          },
          title: "subscription_plan",
          count: "6",
        ),
        MyText(
          text: "other",
          multilanguage: true,
          fontsizeNormal: Dimens.textTitle,
          fontsizeWeb: Dimens.textTitle,
          fontwaight: FontWeight.w600,
          color: colorPrimaryDark,
        ),
        _buildWidget(
          onTap: () {
            profileProvider.setWebSelect("7", "delete_accounts");

            _logoutDeleteDialog(
              title: "delete_accounts",
              subtitle: "delete_account_msg",
            );
          },
          title: "delete_accounts",
          count: "7",
        ),
        _buildWidget(
          onTap: () {
            profileProvider.setWebSelect("8", "log_out");
            _logoutDeleteDialog(
              title: "logoutsure",
              subtitle: "areyousurewanttologout",
            );
          },
          title: "log_out",
          count: "8",
        ),
      ],
    );
  }

  Widget _buildWidget({required VoidCallback onTap, title, count}) {
    return Padding(
      padding: const EdgeInsets.only(left: 20),
      child: InkWell(
        splashColor: transparent,
        focusColor: transparent,
        hoverColor: transparent,
        onTap: onTap,
        child: MyText(
          text: title,
          fontsizeNormal: Dimens.textTitle,
          fontsizeWeb: Dimens.textTitle,
          fontwaight: FontWeight.w400,
          multilanguage: true,
          color: profileProvider.webSelect == count ? colorPrimaryDark : black,
        ),
      ),
    );
  }

  Widget rightSideData() {
    if (profileProvider.webSelect == "1") {
      return _myProfile();
    } else if (profileProvider.webSelect == "2") {
      return certificateData();
    } else if (profileProvider.webSelect == "3") {
      return _buildMeetingData();
    } else if (profileProvider.webSelect == "4") {
      return WebWishList();
    } else if (profileProvider.webSelect == "5") {
      return _buildTranscationData();
    } else if (profileProvider.webSelect == "6") {
      return Padding(
        padding: getResponsivePadding(context),
        child: buildPackage(),
      );
    } else if (profileProvider.webSelect == "9") {
      return buildPage();
    } else if (profileProvider.webSelect == "10") {
      return _buildMyPurchasesBookData();
    } else {
      return SizedBox.shrink();
    }
  }
/* My purchaeses Book Data */

  Widget _buildMyPurchasesBookData() {
    if (profileProvider.contentLoading && !profileProvider.loadMore) {
      return bookPurchShimmer();
    } else {
      if (profileProvider.histroyList != null &&
          (profileProvider.histroyList?.length ?? 0) > 0) {
        return Column(
          children: [
            _buildBookTr(),
            const SizedBox(height: 10),
            if (profileProvider.loadMore)
              Utils.pageLoader()
            else
              const SizedBox.shrink(),
            const SizedBox(height: 30),
          ],
        );
      } else {
        return const NoData();
      }
    }
  }

  Widget _buildBookTr() {
    return ResponsiveGridList(
        minItemWidth: 120,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 6,
            height1200: 5,
            height800: 4,
            height400: 2),
        minItemsPerRow: 1,
        verticalGridMargin: 20,
        horizontalGridMargin: 10,
        verticalGridSpacing: 10,
        horizontalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
            padding: EdgeInsets.zero,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          profileProvider.histroyList?.length ?? 0,
          (index) {
            final trans = profileProvider.histroyList?[index];

            return InkWell(
              onTap: () {
                if (Utils.checkLoginUser(context)) {
                  Navigator.of(context).push(
                    PageRouteBuilder(
                      pageBuilder: (context, animation, secondaryAnimation) =>
                          ReadBook(
                        bookId: trans?.contentId.toString() ?? "",
                        bookName: trans?.bookName.toString() ?? "",
                        pdfURL: trans?.bookUrl.toString() ?? "",
                      ),
                      transitionsBuilder:
                          (context, animation, secondaryAnimation, child) {
                        const begin = Offset(1.0, 0.0);
                        const end = Offset.zero;
                        const curve = Curves.ease;

                        var tween = Tween(begin: begin, end: end)
                            .chain(CurveTween(curve: curve));

                        return SlideTransition(
                          position: animation.drive(tween),
                          child: child,
                        );
                      },
                    ),
                  );
                }
              },
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 10,
                children: [
                  MyNetworkImage(
                      imgHeight: 200,
                      imgWidth: MediaQuery.sizeOf(context).width,
                      radius: 10,
                      imageUrl: trans?.bookImage ?? "",
                      fit: BoxFit.cover),
                  MyText(
                    text: trans?.bookName ?? "",
                    multilanguage: false,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    fontsizeNormal: Dimens.textMedium,
                    color: black,
                    fontwaight: FontWeight.w600,
                  ),
                ],
              ),
            );
          },
        ));
  }

  Widget bookPurchShimmer() {
    return ResponsiveGridList(
        minItemWidth: 120,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 6,
            height1200: 5,
            height800: 4,
            height400: 2),
        minItemsPerRow: 1,
        verticalGridMargin: 20,
        horizontalGridMargin: 10,
        verticalGridSpacing: 10,
        horizontalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
            padding: EdgeInsets.zero,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          10,
          (index) {
            return Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                CustomWidget.roundcorner(
                  height: 200,
                  width: MediaQuery.sizeOf(context).width,
                ),
                CustomWidget.roundcorner(
                    height: 14, width: MediaQuery.sizeOf(context).width),
                CustomWidget.roundcorner(
                    height: 14, width: MediaQuery.sizeOf(context).width),
              ],
            );
          },
        ));
  }

  /* My Profile Widget Started */

  Widget _myProfile() {
    if (profileProvider.loading) {
      return Column(
        children: [
          CustomWidget.circular(height: 120, width: 120),
          SizedBox(height: 20),
          CustomWidget.roundcorner(
              height: 22, width: MediaQuery.sizeOf(context).width),
          CustomWidget.roundcorner(
              height: 22, width: MediaQuery.sizeOf(context).width),
          CustomWidget.roundcorner(
              height: 22, width: MediaQuery.sizeOf(context).width),
          CustomWidget.roundcorner(
              height: 22, width: MediaQuery.sizeOf(context).width),
        ],
      );
    } else {
      if (profileProvider.profileModel.status == 200 &&
          (profileProvider.profileModel.result?.length ?? 0) > 0) {
        return Padding(
          padding: getResponsivePadding(context),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 16,
            children: [
              Align(alignment: Alignment.center, child: _buildImage()),
              editableTextField(
                  controller: userNameController,
                  keybordType: TextInputType.text,
                  hintText: "username",
                  textInputAction: TextInputAction.next),
              editableTextField(
                  controller: nameController,
                  keybordType: TextInputType.text,
                  hintText: "fullname",
                  textInputAction: TextInputAction.next),
              editableTextField(
                  controller: emailController,
                  keybordType: TextInputType.text,
                  hintText: "email",
                  textInputAction: TextInputAction.next),
              phoneFiled(),
              SizedBox(height: 10),
              InkWell(
                splashColor: transparent,
                focusColor: transparent,
                hoverColor: transparent,
                highlightColor: transparent,
                onTap: () async {
                  await profileProvider.getUpdateProfile(
                      userNameController.text,
                      nameController.text.toString(),
                      numberController.text.toString(),
                      emailController.text.toString(),
                      countrycode,
                      countryname,
                      profileProvider.imageBytes,
                      profileProvider.fileName ?? "",
                      profileProvider.mediaType ?? "",
                      strDeviceType ?? "",
                      strDeviceToken ?? "");

                  if (profileProvider.profileModel.status == 200) {
                    Utils.saveUserCreds(
                      userID:
                          profileProvider.profileModel.result?[0].id.toString(),
                      userName: profileProvider.profileModel.result?[0].userName
                              .toString() ??
                          "",
                      fullName: profileProvider.profileModel.result?[0].fullName
                              .toString() ??
                          "",
                      email: profileProvider.profileModel.result?[0].email
                              .toString() ??
                          "",
                      mobileNumber: profileProvider
                              .profileModel.result?[0].mobileNumber
                              .toString() ??
                          "",
                      image: profileProvider.profileModel.result?[0].image
                              .toString() ??
                          "",
                      deviceType: profileProvider
                              .profileModel.result?[0].deviceType
                              .toString() ??
                          "",
                      deviceToken: profileProvider
                              .profileModel.result?[0].deviceToken
                              .toString() ??
                          "",
                      userIsBuy: profileProvider.profileModel.result?[0].isBuy
                              .toString() ??
                          "",
                      type: profileProvider.profileModel.result?[0].type
                              .toString() ??
                          "",
                    );
                    if (!mounted) return;
                    await profileProvider.getprofile(context);
                  } else {
                    if (!mounted) return;
                    Utils.showSnackbar(context, "fail",
                        profileProvider.profileModel.message.toString(), false);
                  }
                },
                child: Align(
                  alignment: Alignment.center,
                  child: AnimatedContainer(
                    duration: const Duration(milliseconds: 80),
                    clipBehavior: Clip.antiAliasWithSaveLayer,
                    curve: Curves.bounceInOut,
                    width: profileProvider.loadingUpdate
                        ? 100
                        : MediaQuery.of(context).size.width * 0.2,
                    height: 45,
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                      color: colorPrimary,
                      borderRadius: BorderRadius.circular(50),
                    ),
                    child: profileProvider.loadingUpdate
                        ? const SizedBox(
                            width: 25,
                            height: 25,
                            child: CircularProgressIndicator(
                              color: white,
                              strokeWidth: 2,
                            ),
                          )
                        : MyText(
                            color: white,
                            text: "updatetext",
                            fontsizeNormal: Dimens.textTitle,
                            maxline: 1,
                            fontwaight: FontWeight.w600,
                            textalign: TextAlign.center,
                            fontstyle: FontStyle.normal,
                            multilanguage: true),
                  ),
                ),
              ),
            ],
          ),
        );
      } else {
        return NoData();
      }
    }
  }

  Widget phoneFiled() {
    String initialCountryCode =
        (profileProvider.profileModel.result?[0].countryName?.isNotEmpty ??
                false)
            ? (profileProvider.profileModel.result![0].countryName ?? "")
            : Constant.initialCountryCode ?? "";

    return Container(
      decoration: BoxDecoration(
          border: Border(
              bottom: BorderSide(
                  width: 1, color: black, style: BorderStyle.solid))),
      child: IntlPhoneField(
        disableLengthCheck: true,
        textAlignVertical: TextAlignVertical.center,
        autovalidateMode: AutovalidateMode.disabled,
        showCountryFlag: true,
        showDropdownIcon: false,
        initialCountryCode:
            initialCountryCode, // Dynamically set the initial country code
        onChanged: (phone) {
          // Update global variables
          countryname = phone.countryISOCode;
          countrycode = phone.countryCode;
        },
        onCountryChanged: (country) {
          countrycode = "+${country.dialCode}";
          countryname = country.code;
        },
        pickerDialogStyle: PickerDialogStyle(backgroundColor: white),
        dropdownTextStyle: GoogleFonts.inter(
            fontSize: Dimens.textMedium,
            fontStyle: FontStyle.normal,
            color: black,
            fontWeight: FontWeight.w400),
        style: GoogleFonts.inter(
            fontSize: Dimens.textMedium,
            fontStyle: FontStyle.normal,
            color: black,
            fontWeight: FontWeight.w400),
        controller: numberController,
        keyboardType: TextInputType.phone,
        textInputAction: TextInputAction.done,
        decoration: InputDecoration(
            enabledBorder: InputBorder.none,
            errorBorder: InputBorder.none,
            border: InputBorder.none,
            focusedBorder: InputBorder.none,
            hintText: "8254768....",
            hintStyle: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                color: gray,
                fontWeight: FontWeight.w400)),
      ),
    );
  }

  Widget _buildImage() {
    return Container(
        padding: const EdgeInsets.all(6),
        alignment: Alignment.center,
        decoration: BoxDecoration(
            shape: BoxShape.circle,
            border:
                Border.all(width: 1, color: black, style: BorderStyle.solid)),
        child: Stack(children: [
          profileProvider.imageBytes != null
              ? Container(
                  height: 100,
                  width: 100,
                  decoration: BoxDecoration(
                      shape: BoxShape.circle,
                      image: DecorationImage(
                        image: MemoryImage(profileProvider.imageBytes!),
                        fit: BoxFit.cover,
                      )))
              : MyNetworkImage(
                  imageUrl: profileProvider.profileModel.status == 200 &&
                          (profileProvider.profileModel.result?.length ?? 0) > 0
                      ? (profileProvider.profileModel.result?[0].image ?? "")
                      : "",
                  imgHeight: 120,
                  imgWidth: 120,
                  radius: 200,
                  fit: BoxFit.fill),
          Positioned(
              bottom: 0,
              right: 2,
              child: InkWell(
                  splashColor: transparent,
                  focusColor: transparent,
                  hoverColor: transparent,
                  onTap: () async {
                    await profileProvider.pickImageWEB();
                  },
                  child: const Icon(
                    Icons.camera_alt_rounded,
                    size: 25,
                    color: black,
                  )))
        ]));
  }

  Widget editableTextField(
      {TextEditingController? controller,
      hintText,
      textInputAction,
      keybordType}) {
    return Container(
      decoration: BoxDecoration(
          border: Border(
              bottom: BorderSide(
                  width: 1, color: black, style: BorderStyle.solid))),
      child: TextFormField(
        autofocus: false,
        showCursor: true,
        keyboardType: keybordType,
        controller: controller,
        textInputAction: textInputAction,
        cursorColor: black,
        style: GoogleFonts.lato(
            fontSize: Dimens.textMedium,
            fontStyle: FontStyle.normal,
            color: black,
            fontWeight: FontWeight.w400),
        decoration: InputDecoration(
          enabledBorder: InputBorder.none,
          errorBorder: InputBorder.none,
          border: InputBorder.none,
          focusedBorder: InputBorder.none,
          hintText: Locales.string(context, hintText),
          hintStyle: GoogleFonts.lato(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: black,
              fontWeight: FontWeight.w400),
        ),
      ),
    );
  }

/* certificate Data */
  Widget certificateData() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
          : const EdgeInsets.fromLTRB(20, 0, 20, 0),
      child: Row(
        spacing: 20,
        crossAxisAlignment: CrossAxisAlignment.center,
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          Expanded(
            child: Column(
              children: [
                MyNetworkImage(
                  imageUrl:
                      "https://marketplace.canva.com/EAE5W0peQ78/1/0/1600w/canva-white-and-blue-elegant-public-speaking-course-certificate-template--qpA_9iguQA.jpg",
                  fit: BoxFit.fill,
                  imgHeight: 250,
                  imgWidth: MediaQuery.sizeOf(context).width,
                ),
                MyText(
                  color: Theme.of(context).colorScheme.surface,
                  text: "UI/Ux  Courses",
                  maxline: 1,
                  multilanguage: false,
                  fontsizeNormal: Dimens.textExtraBig,
                  fontwaight: FontWeight.w500,
                ),
              ],
            ),
          ),
          Expanded(
            child: Column(
              children: [
                Stack(
                  alignment: Alignment.center,
                  children: [
                    MyNetworkImage(
                      imageUrl:
                          "https://marketplace.canva.com/EAE5W0peQ78/1/0/1600w/canva-white-and-blue-elegant-public-speaking-course-certificate-template--qpA_9iguQA.jpg",
                      fit: BoxFit.fill,
                      imgHeight: 250,
                      imgWidth: MediaQuery.sizeOf(context).width,
                    ),
                    Positioned.fill(
                      child: Container(
                        color: transparent.withValues(alpha: 0.5),
                      ),
                    ),
                    Column(
                      spacing: 6,
                      children: [
                        Icon(
                          Icons.lock,
                          size: 25,
                          color: white,
                        ),
                        MyText(
                          color: white,
                          text: "Complete your courses to get the certificate",
                          maxline: 2,
                          multilanguage: false,
                          fontsizeNormal: Dimens.textBig,
                          fontwaight: FontWeight.w500,
                          textalign: TextAlign.center,
                        ),
                        InkWell(
                          onTap: () {
                            Navigator.of(context).push(
                              PageRouteBuilder(
                                pageBuilder:
                                    (context, animation, secondaryAnimation) =>
                                        const WebMyCourse(),
                                transitionsBuilder: (context, animation,
                                    secondaryAnimation, child) {
                                  const begin = Offset(1.0, 0.0);
                                  const end = Offset.zero;
                                  const curve = Curves.ease;

                                  var tween = Tween(begin: begin, end: end)
                                      .chain(CurveTween(curve: curve));

                                  return SlideTransition(
                                    position: animation.drive(tween),
                                    child: child,
                                  );
                                },
                              ),
                            );
                          },
                          child: Container(
                            padding: EdgeInsets.symmetric(
                                horizontal: 10, vertical: 8),
                            decoration: BoxDecoration(
                                color: white,
                                borderRadius: BorderRadius.circular(8)),
                            child: MyText(
                              color: black,
                              text: "Go to my courses",
                              maxline: 2,
                              multilanguage: false,
                              fontsizeNormal: Dimens.textSmall,
                              fontwaight: FontWeight.w500,
                              textalign: TextAlign.center,
                            ),
                          ),
                        )
                      ],
                    )
                  ],
                ),
                MyText(
                  color: Theme.of(context).colorScheme.surface,
                  text: "Master Data Excel Courses",
                  maxline: 1,
                  multilanguage: false,
                  fontsizeNormal: Dimens.textExtraBig,
                  fontwaight: FontWeight.w500,
                )
              ],
            ),
          ),
        ],
      ),
    );
  }

/* Subscription Plan Data Data  */
  Widget buildPackage() {
    if (profileProvider.contentLoading && !profileProvider.loadMore) {
      return buildShimmer();
    } else {
      if ((profileProvider.packageList?.length ?? 0) > 0 &&
          profileProvider.packageList != null) {
        return _subData();
      } else {
        return const NoData();
      }
    }
  }

  Widget _subData() {
    return ResponsiveGridList(
      minItemWidth: 160,
      minItemsPerRow: 1,
      maxItemsPerRow: 1,
      listViewBuilderOptions: ListViewBuilderOptions(
        shrinkWrap: true,
        physics: const NeverScrollableScrollPhysics(),
      ),
      children: List.generate(
        profileProvider.packageList?.length ?? 0,
        (index) {
          return InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            highlightColor: transparent,
            onTap: () {
              _checkAndPay(profileProvider.packageList ?? [], index);
            },
            child: Align(
              alignment: Alignment.center,
              child: AnimatedScale(
                scale: 1,
                duration: const Duration(milliseconds: 500),
                curve: Curves.easeInOut,
                child: Container(
                  margin: const EdgeInsets.fromLTRB(40, 0, 40, 20),
                  padding: const EdgeInsets.all(20),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(15),
                    color: transparent,
                    border: Border.all(
                      width: 1.5,
                      color: gray.withValues(alpha: 0.20),
                    ),
                  ),
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Expanded(
                            child: Align(
                              alignment: Alignment.topLeft,
                              child: MyText(
                                color: Theme.of(context).colorScheme.surface,
                                text: profileProvider
                                        .packageModel.result?[index].name
                                        .toString()
                                        .toUpperCase() ??
                                    "",
                                maxline: 1,
                                fontwaight: FontWeight.w700,
                                fontsizeNormal: Dimens.textTitle,
                                fontsizeWeb: Dimens.textlargeBig,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal,
                                multilanguage: false,
                              ),
                            ),
                          ),
                          MyText(
                            color: green,
                            text:
                                "${Constant.currencyCode} ${profileProvider.packageList?[index].price.toString() ?? ""}",
                            maxline: 1,
                            fontwaight: FontWeight.w700,
                            fontsizeNormal: Dimens.textBig,
                            fontsizeWeb: Dimens.textBig,
                            textalign: TextAlign.center,
                            fontstyle: FontStyle.normal,
                            multilanguage: false,
                          ),
                        ],
                      ),
                      const SizedBox(height: 10),
                      MyText(
                        color: gray,
                        text:
                            "Get all the premium courses for ${profileProvider.packageList?[index].durationDays.toString() ?? ""} Days. You can access up to ${profileProvider.packageList?[index].maxCoursesAllowed.toString() ?? ""} Course",
                        maxline: 1,
                        fontwaight: FontWeight.w400,
                        fontsizeNormal: Dimens.textSmall,
                        fontsizeWeb: Dimens.textMedium,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal,
                        multilanguage: false,
                      ),
                      const SizedBox(height: 15),
                      InkWell(
                        onTap: () {
                          _checkAndPay(
                              profileProvider.packageList ?? [], index);
                        },
                        child: Container(
                          width: 100,
                          height: 40,
                          alignment: Alignment.center,
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(50),
                            color:
                                (profileProvider.packageList?[index].isBuy == 1)
                                    ? colorAccent
                                    : colorPrimary,
                          ),
                          child: MyText(
                            color:
                                (profileProvider.packageList?[index].isBuy == 1)
                                    ? black
                                    : white,
                            text:
                                (profileProvider.packageList?[index].isBuy == 1)
                                    ? "active"
                                    : "subscribe",
                            maxline: 1,
                            fontwaight:
                                (profileProvider.packageList?[index].isBuy == 1)
                                    ? FontWeight.w600
                                    : FontWeight.w500,
                            fontsizeNormal: Dimens.textSmall,
                            fontsizeWeb: Dimens.textTitle,
                            textalign: TextAlign.center,
                            fontstyle: FontStyle.normal,
                            multilanguage: true,
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ),
          );
        },
      ),
    );
  }

  Widget buildShimmer() {
    return ResponsiveGridList(
      minItemWidth: 160,
      minItemsPerRow: 1,
      maxItemsPerRow: 1,
      listViewBuilderOptions: ListViewBuilderOptions(
        shrinkWrap: true,
        physics: const NeverScrollableScrollPhysics(),
      ),
      children: List.generate(
        5,
        (index) {
          return Container(
            padding: const EdgeInsets.fromLTRB(20, 20, 20, 20),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(15),
              border: Border.all(
                width: 1.5,
                color: gray.withValues(alpha: 0.20),
              ),
            ),
            child: const Column(
              mainAxisAlignment: MainAxisAlignment.center,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    CustomWidget.roundrectborder(
                      height: 8,
                      width: 100,
                    ),
                    CustomWidget.roundrectborder(
                      height: 8,
                      width: 50,
                    ),
                  ],
                ),
                SizedBox(height: 10),
                CustomWidget.roundrectborder(
                  height: 8,
                ),
                SizedBox(height: 15),
                CustomWidget.circleborder(
                  height: 40,
                  width: 100,
                ),
              ],
            ),
          );
        },
      ),
    );
  }

  Future<void> _checkAndPay(List<Result>? packageList, int index) async {
    if (Constant.userID != null) {
      // for (var i = 0; i < (packageList?.length ?? 0); i++) {
      //   if (packageList?[i].isBuy == 1) {
      //     printLog("<============= Purchaged =============>");
      //     Utils.showSnackbar(context, "fail", "already_purchased", true);
      //     return;
      //   }
      // }
      if (Utils.checkLoginUser(context)) {
        await Navigator.push(
          context,
          MaterialPageRoute(
            builder: (context) {
              return AllPayment(
                payType: 'Package',
                contentType: "1",
                itemId: packageList?[index].id.toString() ?? '',
                price: packageList?[index].price.toString() ?? '',
                itemTitle: packageList?[index].name.toString() ?? '',
                productPackage: (!kIsWeb)
                    ? (Platform.isIOS
                        ? (packageList?[index].iosProductPackage.toString() ??
                            '')
                        : (packageList?[index]
                                .androidProductPackage
                                .toString() ??
                            ''))
                    : '',
              );
            },
          ),
        );
      }
    }
  }

/* Transaction List Data */

  Widget _buildTranscationData() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(100, 0, 100, 0)
          : const EdgeInsets.fromLTRB(20, 0, 20, 0),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 20,
        children: [
          _buildSubData(),
          _buildBoxDataShow(),
          const SizedBox(height: 10),
          if (profileProvider.loadMore)
            Utils.pageLoader()
          else
            const SizedBox.shrink(),
          const SizedBox(height: 30),
        ],
      ),
    );
  }

/* Add money Wallet */

  Widget _buildSubData() {
    if (MediaQuery.of(context).size.width > 1200) {
      return Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 30,
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          Expanded(child: _addWalletData()),
          Expanded(child: _upGradePlane()),
        ],
      );
    } else {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 10,
        children: [
          _addWalletData(),
          _upGradePlane(),
        ],
      );
    }
  }

  Widget _addWalletData() {
    return Container(
      padding: EdgeInsets.fromLTRB(20, 25, 20, 25),
      decoration: BoxDecoration(
          color: white,
          borderRadius: BorderRadius.circular(10),
          boxShadow: [
            BoxShadow(
                blurRadius: 11,
                color: transparent.withValues(alpha: 0.08),
                blurStyle: BlurStyle.outer,
                offset: Offset(0, 3),
                spreadRadius: 0)
          ]),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Expanded(
              child: Column(
            children: [
              profileProvider.loading
                  ? CustomWidget.roundcorner(height: 10, width: 60)
                  : MyText(
                      color: colorPrimaryDark,
                      text: ((profileProvider.profileModel.status == 200 &&
                              (profileProvider.profileModel.result?.length ??
                                      0) >
                                  0))
                          ? "${Constant.currencyCode} ${profileProvider.profileModel.result?[0].walletAmount.toString() ?? "0"}"
                          : "0",
                      multilanguage: false,
                      fontsizeNormal: Dimens.textTitle,
                      fontwaight: FontWeight.w600,
                      maxline: 1,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
              MyText(
                  color: black,
                  text: "your_wallet_balance",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textSmall,
                  fontwaight: FontWeight.w600,
                  maxline: 1,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            ],
          )),
          InkWell(
              borderRadius: BorderRadius.circular(10),
              focusColor: transparent,
              highlightColor: transparent,
              hoverColor: transparent,
              splashColor: transparent,
              onTap: () {
                showAddMoneyDialog();
              },
              child: Container(
                padding: const EdgeInsets.all(10),
                alignment: Alignment.center,
                decoration: BoxDecoration(
                    color: white,
                    borderRadius: BorderRadius.circular(4),
                    boxShadow: [
                      BoxShadow(
                          blurRadius: 11,
                          color: transparent.withValues(alpha: 0.08),
                          blurStyle: BlurStyle.outer,
                          offset: Offset(0, 3),
                          spreadRadius: 0)
                    ]),
                child: Row(
                  children: [
                    Icon(
                      Icons.add,
                      size: 20,
                      color: black,
                    ),
                    MyText(
                        color: black,
                        text: "add_money",
                        multilanguage: true,
                        fontsizeNormal: Dimens.textMedium,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ],
                ),
              ))
        ],
      ),
    );
  }

  /* Add Money dialog Data */

  Future showAddMoneyDialog() {
    return showDialog(
      context: context,
      builder: (context) {
        return Consumer<ProfileProvider>(
            builder: (context, profileProvider, child) {
          return AlertDialog(
            backgroundColor: white,
            elevation: 10,
            title: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 6,
              children: [
                InkWell(
                    splashColor: transparent,
                    highlightColor: transparent,
                    hoverColor: transparent,
                    focusColor: transparent,
                    onTap: () {
                      if (Navigator.canPop(context)) {
                        Navigator.of(context).pop();
                      }
                    },
                    child: Icon(Icons.close, size: 20, color: black)),
                MyText(
                    color: black,
                    text: "add_money",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textMedium,
                    fontwaight: FontWeight.w600,
                    maxline: 1,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                MyText(
                    color: black,
                    text:
                        "${Locales.string(context, "available_balance")} ${Constant.currencyCode} ${profileProvider.profileModel.result?[0].walletAmount.toString() ?? ""}",
                    multilanguage: false,
                    fontsizeNormal: Dimens.textMedium,
                    fontwaight: FontWeight.w600,
                    maxline: 1,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
            content: TextFormField(
              keyboardType: TextInputType.number,
              controller: walletController,
              textInputAction: TextInputAction.next,
              cursorColor: black,
              style: GoogleFonts.lato(
                  fontSize: Dimens.textMedium,
                  fontStyle: FontStyle.normal,
                  color: black,
                  fontWeight: FontWeight.w600),
              decoration: InputDecoration(
                prefixIcon: Icon(Icons.wallet, size: 20, color: gray),
                focusedBorder: OutlineInputBorder(
                  borderRadius: const BorderRadius.all(Radius.circular(10)),
                  borderSide: BorderSide(
                      width: 1, color: webTextFiled, style: BorderStyle.solid),
                ),
                disabledBorder: OutlineInputBorder(
                  borderRadius: const BorderRadius.all(Radius.circular(10)),
                  borderSide: BorderSide(
                      width: 1, color: webTextFiled, style: BorderStyle.solid),
                ),
                enabledBorder: OutlineInputBorder(
                  borderRadius: const BorderRadius.all(Radius.circular(10)),
                  borderSide: BorderSide(
                      width: 1, color: webTextFiled, style: BorderStyle.solid),
                ),
                border: OutlineInputBorder(
                  borderRadius: const BorderRadius.all(Radius.circular(10)),
                  borderSide: BorderSide(
                      width: 1, color: webTextFiled, style: BorderStyle.solid),
                ),
                hintText: "Enter the amount",
                hintStyle: GoogleFonts.lato(
                    fontSize: Dimens.textMedium,
                    fontStyle: FontStyle.normal,
                    color: gray,
                    fontWeight: FontWeight.w400),
              ),
            ),
            actions: [
              Align(
                alignment: Alignment.center,
                child: InkWell(
                    borderRadius: BorderRadius.circular(10),
                    focusColor: transparent,
                    highlightColor: transparent,
                    hoverColor: transparent,
                    splashColor: transparent,
                    onTap: () async {
                      /* trabsaction id */
                      String? transactionId = Utils.generateRandomOrderID();
                      if (walletController.text.isEmpty) {
                        Utils.showSnackbar(
                            context, "fail", "pleaseenteramount", true);
                      } else {
                        profileProvider.setWallet(true);

                        await profileProvider.getAddWallet(
                            walletController.text, transactionId);

                        if (profileProvider.successModel.status == 200) {
                          profileProvider.setWallet(false);
                          if (!context.mounted) return;
                          if (Navigator.canPop(context)) {
                            Navigator.of(context).pop();
                          }
                          /* APi Call */
                          profileProvider.clearWebContent();
                          getApi();
                          getApiData("1", 0);

                          walletController.clear();
                          FocusManager.instance.primaryFocus?.unfocus();
                        } else {
                          profileProvider.setWallet(false);
                          if (!context.mounted) return;
                          Utils.showSnackbar(
                              context,
                              "fail",
                              profileProvider.successModel.message ?? "",
                              false);
                        }
                      }
                    },
                    child: AnimatedContainer(
                      duration: Duration(milliseconds: 120),
                      padding: const EdgeInsets.all(10),
                      alignment: Alignment.center,
                      width: profileProvider.walletLoading
                          ? 60
                          : MediaQuery.sizeOf(context).width * 0.16,
                      decoration: BoxDecoration(
                          color: colorPrimaryDark,
                          borderRadius: BorderRadius.circular(4),
                          boxShadow: [
                            BoxShadow(
                                blurRadius: 11,
                                color: transparent.withValues(alpha: 0.08),
                                blurStyle: BlurStyle.outer,
                                offset: Offset(0, 3),
                                spreadRadius: 0)
                          ]),
                      child: profileProvider.walletLoading
                          ? SizedBox(
                              height: 20,
                              width: 20,
                              child: CircularProgressIndicator(
                                color: white,
                              ),
                            )
                          : MyText(
                              color: white,
                              text: "proceed_add_money",
                              multilanguage: true,
                              fontsizeNormal: Dimens.textMedium,
                              fontwaight: FontWeight.w600,
                              maxline: 1,
                              textalign: TextAlign.left,
                              fontstyle: FontStyle.normal),
                    )),
              )
            ],
          );
        });
      },
    );
  }

  Widget _upGradePlane() {
    return Container(
      padding: EdgeInsets.fromLTRB(20, 25, 20, 25),
      decoration: BoxDecoration(
          color: white,
          borderRadius: BorderRadius.circular(10),
          boxShadow: [
            BoxShadow(
                blurRadius: 11,
                color: transparent.withValues(alpha: 0.08),
                blurStyle: BlurStyle.outer,
                offset: Offset(0, 3),
                spreadRadius: 0)
          ]),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.center,
        spacing: 30,
        children: [
          Expanded(
              child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            spacing: 10,
            children: [
              MyText(
                  color: black,
                  text: "current_plan",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textTitle,
                  fontwaight: FontWeight.w600,
                  maxline: 1,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
              profileProvider.loading
                  ? CustomWidget.roundcorner(height: 10, width: 80)
                  : MyText(
                      color: black,
                      text: ((profileProvider.profileModel.status == 200 &&
                              (profileProvider.profileModel.result?.length ??
                                      0) >
                                  0))
                          ? (profileProvider.profileModel.result?[0].packageName
                                  .toString() ??
                              "")
                          : "0",
                      multilanguage: false,
                      fontsizeNormal: Dimens.textTitle,
                      fontwaight: FontWeight.w600,
                      maxline: 1,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
              InkWell(
                  borderRadius: BorderRadius.circular(10),
                  focusColor: transparent,
                  highlightColor: transparent,
                  hoverColor: transparent,
                  splashColor: transparent,
                  onTap: () {
                    profileProvider.setWebSelect("6", "subscription_plan");

                    /* APi Call */
                    profileProvider.clearWebContent();
                    _fetchData(0);
                  },
                  child: Container(
                    width: 110,
                    padding: const EdgeInsets.fromLTRB(10, 4, 10, 4),
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                      color: colorPrimaryDark,
                      borderRadius: BorderRadius.circular(4),
                    ),
                    child: MyText(
                        color: white,
                        text: "upgrade_now",
                        multilanguage: true,
                        fontsizeNormal: Dimens.textMedium,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ))
            ],
          )),
          MyImage(
            width: 100,
            height: 111,
            imagePath: "tr_image.png",
            fit: BoxFit.fill,
          )
        ],
      ),
    );
  }

  Widget _buildBoxDataShow() {
    return Container(
      decoration: BoxDecoration(
        color: white,
        border: Border.all(
          width: 1,
          color: gray,
          style: BorderStyle.solid,
        ),
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisSize: MainAxisSize.min,
        children: [
          tabButton(),
          Container(
            padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
            decoration: BoxDecoration(
                color: gray,
                border: Border.all(
                    width: 1, color: gray, style: BorderStyle.solid)),
            child: Row(
              children: [
                Expanded(
                  flex: 2,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: "ref_id",
                      multilanguage: true,
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
                Expanded(
                  flex: 4,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      multilanguage: true,
                      text: "transaction_date",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
                Expanded(
                  flex: 2,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      multilanguage: true,
                      text: "amount",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
                Expanded(
                  flex: 2,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      multilanguage: true,
                      text: "status",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
              ],
            ),
          ),
          _buildMain(),
        ],
      ),
    );
  }

  Widget tabButton() {
    return Padding(
        padding: const EdgeInsets.all(10),
        child: SingleChildScrollView(
            scrollDirection: Axis.horizontal,
            child: Row(spacing: 15, mainAxisSize: MainAxisSize.min, children: [
              _buildTab(
                  title: "package",
                  count: "1",
                  onTap: () {
                    profileProvider.setType("1");
                    profileProvider.clearContent();
                    getApiData(profileProvider.selectType ?? "", 0);
                  }),
              _buildTab(
                  title: "wallet",
                  count: "2",
                  onTap: () {
                    profileProvider.setType("2");
                    profileProvider.clearContent();
                    getApiData(profileProvider.selectType ?? "", 0);
                  }),
              _buildTab(
                  title: "live_classes",
                  count: "3",
                  onTap: () {
                    profileProvider.setType("3");
                    profileProvider.clearContent();
                    getApiData(profileProvider.selectType ?? "", 0);
                  }),
              _buildTab(
                  title: "books",
                  count: "4",
                  onTap: () {
                    profileProvider.setType("4");
                    profileProvider.clearContent();
                    getApiData(profileProvider.selectType ?? "", 0);
                  }),
              _buildTab(
                  title: "course",
                  count: "5",
                  onTap: () {
                    profileProvider.setType("5");
                    profileProvider.clearContent();
                    getApiData(profileProvider.selectType ?? "", 0);
                  }),
              _buildTab(
                  title: "meetings",
                  count: "6",
                  onTap: () {
                    profileProvider.setType("6");
                    profileProvider.clearContent();
                    getApiData(profileProvider.selectType ?? "", 0);
                  }),
            ])));
  }

  Widget _buildTab({String? title, onTap, count}) {
    return InkWell(
        borderRadius: BorderRadius.circular(10),
        focusColor: transparent,
        highlightColor: transparent,
        hoverColor: transparent,
        splashColor: transparent,
        onTap: onTap,
        child: Container(
          padding: const EdgeInsets.all(10),
          alignment: Alignment.center,
          decoration: BoxDecoration(
              border: Border(
                  bottom: BorderSide(
                      width: 1,
                      color: profileProvider.selectType == count
                          ? colorPrimaryDark
                          : transparent)),
              color: transparent),
          child: MyText(
              color:
                  profileProvider.selectType == count ? colorPrimaryDark : gray,
              text: title ?? "",
              multilanguage: true,
              fontsizeNormal: Dimens.textSmall,
              fontwaight: FontWeight.w600,
              maxline: 1,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
        ));
  }

/* Tab Data END */

  Widget _buildMain() {
    if (profileProvider.contentLoading && !profileProvider.loadMore) {
      return tranShimmer();
    } else {
      if (profileProvider.histroyList != null &&
          (profileProvider.histroyList?.length ?? 0) > 0) {
        return _buildTrData();
      } else {
        return const NoData();
      }
    }
  }

  Widget _buildTrData() {
    return ListView.separated(
        itemBuilder: (context, index) {
          final trans = profileProvider.histroyList?[index];
          return Padding(
            padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
            child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  Expanded(
                    flex: 2,
                    child: MyText(
                        text: (trans?.transactionId.toString() ?? "").isNotEmpty
                            ? profileProvider.selectType == "5"
                                ? trans?.purchaseId.toString() ?? ""
                                : trans?.transactionId.toString() ?? ""
                            : trans?.id.toString() ?? "",
                        multilanguage: false,
                        maxline: 1,
                        fontsizeNormal: Dimens.textMedium,
                        color: black,
                        fontwaight: FontWeight.w400),
                  ),
                  Expanded(
                    flex: 4,
                    child: MyText(
                        text: DateFormat('d MMM yyyy, h:mm a')
                            .format(DateTime.parse(trans?.createdAt ?? "")),
                        multilanguage: false,
                        maxline: 1,
                        fontsizeNormal: Dimens.textSmall,
                        color: black.withValues(alpha: .5),
                        fontwaight: FontWeight.w400),
                  ),
                  Expanded(
                    flex: 2,
                    child: (profileProvider.selectType == "5")
                        ? MyText(
                            text:
                                "${Constant.currencyCode} ${trans?.coursePrice.toString() ?? "0"}",
                            multilanguage: false,
                            maxline: 1,
                            overflow: TextOverflow.ellipsis,
                            fontsizeNormal: Dimens.textBig,
                            color: black,
                            fontwaight: FontWeight.w600,
                          )
                        : MyText(
                            text:
                                "${Constant.currencyCode} ${(profileProvider.selectType == "6") ? trans?.totalPrice.toString() : profileProvider.selectType == "4" ? trans?.bookPrice.toString() : trans?.price.toString()}",
                            multilanguage: false,
                            maxline: 1,
                            fontsizeNormal: Dimens.textTitle,
                            color: black,
                            fontwaight: FontWeight.w400),
                  ),
                  Expanded(
                    flex: 2,
                    child: MyText(
                        text: trans?.status == 0 ? "expired" : "active",
                        multilanguage: true,
                        maxline: 1,
                        fontsizeNormal: Dimens.textTitle,
                        color: trans?.status == 0 ? red : green,
                        fontwaight: FontWeight.w400),
                  )
                ]),
          );
        },
        shrinkWrap: true,
        physics: NeverScrollableScrollPhysics(),
        separatorBuilder: (context, index) {
          return Divider(thickness: 1, color: gray, height: 10);
        },
        itemCount: profileProvider.histroyList?.length ?? 0);
  }

  Widget tranShimmer() {
    return ListView.separated(
        itemBuilder: (context, index) {
          return Padding(
            padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
            child: Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
              Expanded(
                  flex: 2,
                  child: CustomWidget.roundcorner(height: 12, width: 120)),
              Expanded(
                  flex: 4,
                  child: CustomWidget.roundcorner(height: 12, width: 60)),
              Expanded(
                  flex: 2,
                  child: CustomWidget.roundcorner(height: 12, width: 60)),
              Expanded(
                  flex: 2,
                  child: CustomWidget.roundcorner(height: 12, width: 60))
            ]),
          );
        },
        shrinkWrap: true,
        physics: NeverScrollableScrollPhysics(),
        separatorBuilder: (context, index) {
          return Divider(thickness: 1, color: gray, height: 10);
        },
        itemCount: 10);
  }

  Widget shimmer() {
    return ResponsiveGridList(
        minItemWidth: 400,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 3,
            height1200: 2,
            height800: 1,
            height400: 1),
        minItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 3,
            height1200: 2,
            height800: 1,
            height400: 1),
        verticalGridMargin: 0,
        horizontalGridMargin: 20,
        verticalGridSpacing: 0,
        listViewBuilderOptions: ListViewBuilderOptions(
            padding: EdgeInsets.zero,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics()),
        children: List.generate(10, (index) {
          return Column(children: [
            Row(children: [
              CustomWidget.circular(height: 30, width: 30),
              Expanded(
                  child: CustomWidget.roundcorner(
                      height: 20, width: MediaQuery.sizeOf(context).width)),
              CustomWidget.roundcorner(height: 20, width: 60)
            ]),
            const SizedBox(height: 8),
            Row(children: [
              Expanded(
                  child: CustomWidget.roundcorner(
                      height: 20, width: MediaQuery.sizeOf(context).width)),
              const SizedBox(width: 50),
              Expanded(
                  child: CustomWidget.roundcorner(
                      height: 20, width: MediaQuery.sizeOf(context).width))
            ])
          ]);
        }));
  }

/* Tutor Meeting data started */

  Widget _buildMeetingData() {
    return Consumer<MeetingProvider>(
      builder: (context, meetingProvider, child) {
        return Padding(
          padding: const EdgeInsets.fromLTRB(20, 0, 0, 25),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 20,
            children: [
              tabData(),
              _buildMeetingTabbar(),
            ],
          ),
        );
      },
    );
  }

  Widget tabData() {
    return Container(
      padding: EdgeInsets.all(12),
      decoration: BoxDecoration(
        color: white,
        boxShadow: [
          BoxShadow(
              blurRadius: 11,
              blurStyle: BlurStyle.outer,
              color: transparent.withValues(alpha: 0.08),
              offset: Offset(0, 3),
              spreadRadius: 0)
        ],
        borderRadius: BorderRadius.circular(12),
      ),
      child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          spacing: 20,
          mainAxisSize: MainAxisSize.min,
          children: [
            Flexible(
              fit: FlexFit.loose,
              child: _buildMeetingTab(
                  title: Locales.string(context, "upcoming"),
                  count: "1",
                  onTap: () {
                    meetingProvider.setTab("1");

                    meetingProvider.clearContent();
                    meetingProvider.setLoading(false);
                    profileProvider.setAppoinment(
                        index: "0", name: "", ids: "");
                    profileProvider.setConfAppoinment(
                        index: "0",
                        name: "check_out",
                        ids: profileProvider.meetingId ?? "");
                    getMeetingApi();
                  }),
            ),
            Flexible(
              fit: FlexFit.loose,
              child: _buildMeetingTab(
                  title: Locales.string(context, "my_meeting"),
                  count: "2",
                  onTap: () {
                    meetingProvider.setTab("2");
                    profileProvider.setAppoinment(
                      index: "0",
                      name: "",
                      ids: "",
                    );
                    meetingProvider.clearContent();
                    // meetingProvider.setLoading(false);
                    meetingProvider.getMeetingStatus();
                    _fetchUserData(meetingProvider.myTab, 0);
                  }),
            ),
          ]),
    );
  }

  Widget _buildMeetingTab({String? title, onTap, count}) {
    return InkWell(
      focusColor: transparent,
      highlightColor: transparent,
      hoverColor: transparent,
      splashColor: transparent,
      onTap: onTap,
      child: Container(
        padding: const EdgeInsets.fromLTRB(25, 10, 25, 10),
        alignment: Alignment.center,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color: meetingProvider.selectedIndex == count
              ? colorPrimaryDark
              : transparent,
        ),
        child: MyText(
            color:
                meetingProvider.selectedIndex == count ? white : colorPrimary,
            text: title ?? "",
            multilanguage: false,
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            textalign: TextAlign.left,
            fontstyle: FontStyle.normal),
      ),
    );
  }

  Widget _buildMeetingTabbar() {
    return meetingProvider.selectedIndex == "1"
        ?
        /* Appoint book session show */
        profileProvider.isConfAppoinment == "1"
            ? _buildConfiData()
            : profileProvider.isAppoinment == "1"
                ? _buildAppointment()
                /* Conf Appointment Show */
                : Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    spacing: 20,
                    children: [
                      courseNameData(),
                      _buildUpcomingData(),
                    ],
                  )
        : _buildMyMeeting();
  }

  Widget courseNameData() {
    if (meetingProvider.courseNameLoading) {
      return SingleChildScrollView(
        padding: EdgeInsets.zero,
        scrollDirection: Axis.horizontal,
        physics: NeverScrollableScrollPhysics(),
        child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            crossAxisAlignment: CrossAxisAlignment.center,
            spacing: 20,
            children: List.generate(
              10,
              (index) {
                return Container(
                  padding: const EdgeInsets.all(10),
                  alignment: Alignment.center,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(10),
                    color: transparent,
                  ),
                  child: CustomWidget.roundcorner(
                    height: 14,
                    width: 100,
                  ),
                );
              },
            )),
      );
    } else {
      if (meetingProvider.courseNameModel.status == 200 &&
          (meetingProvider.courseNameModel.result?.length ?? 0) > 0) {
        return SingleChildScrollView(
          physics: BouncingScrollPhysics(),
          padding: EdgeInsets.zero,
          scrollDirection: Axis.horizontal,
          child: Row(
            children: [
              InkWell(
                focusColor: transparent,
                highlightColor: transparent,
                hoverColor: transparent,
                splashColor: transparent,
                onTap: () {
                  meetingProvider.setCourseId("0");

                  meetingProvider.clearMeetingData();
                  meetingProvider.setLoading(false);
                  _fetchMeetingData(meetingProvider.courseId ?? "", 0);
                },
                child: Container(
                  padding: const EdgeInsets.fromLTRB(16, 6, 16, 6),
                  alignment: Alignment.center,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(10),
                    color: meetingProvider.courseId == "0"
                        ? colorPrimary.withValues(alpha: 0.3)
                        : transparent,
                  ),
                  child: MyText(
                      color: colorPrimaryDark,
                      text: "all",
                      multilanguage: true,
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 1,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
              ),
              Row(
                children: List.generate(
                  meetingProvider.courseNameModel.result?.length ?? 0,
                  (index) {
                    return InkWell(
                      focusColor: transparent,
                      highlightColor: transparent,
                      hoverColor: transparent,
                      splashColor: transparent,
                      onTap: () async {
                        meetingProvider.setCourseId(meetingProvider
                                .courseNameModel.result?[index].id
                                .toString() ??
                            "");

                        meetingProvider.clearMeetingData();
                        meetingProvider.setLoading(false);
                        await _fetchMeetingData(
                            meetingProvider.courseId ?? "", 0);
                      },
                      child: Container(
                        padding: const EdgeInsets.fromLTRB(10, 6, 10, 6),
                        alignment: Alignment.center,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(10),
                          color: meetingProvider.courseId ==
                                  (meetingProvider
                                          .courseNameModel.result?[index].id
                                          .toString() ??
                                      "")
                              ? colorPrimary.withValues(alpha: 0.3)
                              : transparent,
                        ),
                        child: MyText(
                            color: colorPrimaryDark,
                            text: meetingProvider
                                    .courseNameModel.result?[index].title ??
                                "",
                            multilanguage: false,
                            fontsizeNormal: Dimens.textMedium,
                            fontwaight: FontWeight.w600,
                            maxline: 1,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                      ),
                    );
                  },
                ),
              )
            ],
          ),
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }
  /* Tutor meeting data */

  Widget _buildUpcomingData() {
    if (meetingProvider.loading && !meetingProvider.loadMore) {
      return _upcomingShimmer();
    } else {
      if (meetingProvider.meetingList != null &&
          (meetingProvider.meetingList?.length ?? 0) > 0) {
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            buildMeetingUpcommingData(),
            const SizedBox(height: 30),
            if (meetingProvider.loadMore)
              Utils.pageLoader()
            else
              const SizedBox.shrink(),
            const SizedBox(height: 10),
          ],
        );
      } else {
        return NoData();
      }
    }
  }

  Widget buildMeetingUpcommingData() {
    return ResponsiveGridList(
        minItemWidth: 300,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 4,
            height1200: 3,
            height800: 2,
            height400: 2),
        minItemsPerRow: 1,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            padding: EdgeInsets.zero,
            physics: NeverScrollableScrollPhysics()),
        children: List.generate(
          meetingProvider.meetingList?.length ?? 0,
          (index) {
            final meetingListData = meetingProvider.meetingList?[index];
            return Card(
              color: white,
              elevation: 10,
              shadowColor: transparent.withValues(alpha: 0.3),
              child: Padding(
                padding: const EdgeInsets.fromLTRB(15, 10, 15, 10),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  spacing: 10,
                  children: [
                    Row(
                      spacing: 20,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          padding: EdgeInsets.all(4),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              border: Border.all(
                                  width: 1,
                                  color: colorPrimaryDark,
                                  style: BorderStyle.solid)),
                          child: MyNetworkImage(
                              radius: 50,
                              imgHeight: 80,
                              imgWidth: 80,
                              imageUrl: meetingListData?.lecturerImage ?? "",
                              fit: BoxFit.fill),
                        ),
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            spacing: 4,
                            children: [
                              Container(
                                padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                                decoration: BoxDecoration(
                                    color: red.withValues(alpha: 0.2),
                                    borderRadius: BorderRadius.circular(8)),
                                child: Row(
                                  mainAxisSize: MainAxisSize.min,
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  spacing: 4,
                                  children: [
                                    Icon(
                                      Icons.favorite,
                                      size: 14,
                                      color: red,
                                    ),
                                    MyText(
                                      text: meetingListData?.avgRating ?? "",
                                      multilanguage: false,
                                      color: red,
                                      fontsizeNormal: Dimens.textSmall,
                                      fontsizeWeb: Dimens.textBig,
                                      fontwaight: FontWeight.w600,
                                    ),
                                  ],
                                ),
                              ),
                              MyText(
                                text: meetingListData?.lecturerName ?? "",
                                multilanguage: false,
                                color: black,
                                maxline: 1,
                                fontsizeNormal: Dimens.textTitle,
                                fontsizeWeb: Dimens.textBig,
                                fontwaight: FontWeight.w600,
                              ),
                              MyText(
                                text: meetingListData?.title ?? "",
                                multilanguage: false,
                                color: black,
                                maxline: 1,
                                fontsizeNormal: Dimens.textMedium,
                                fontsizeWeb: Dimens.textMedium,
                                fontwaight: FontWeight.w400,
                              ),
                            ],
                          ),
                        ),
                        Container(
                          padding: EdgeInsets.fromLTRB(10, 6, 10, 6),
                          decoration: BoxDecoration(
                              color:
                                  (meetingListData?.isFree.toString() ?? "") ==
                                          "0"
                                      ? red
                                      : green,
                              borderRadius: BorderRadius.circular(8)),
                          child: MyText(
                            text: (meetingListData?.isFree.toString() ?? "") ==
                                    "0"
                                ? "paid"
                                : "free",
                            multilanguage: true,
                            color: white,
                            fontsizeNormal: Dimens.textMedium,
                            fontsizeWeb: Dimens.textBig,
                            fontwaight: FontWeight.w600,
                          ),
                        )
                      ],
                    ),
                    (meetingListData?.isFree.toString() ?? "") == "0"
                        ? Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            spacing: 20,
                            children: [
                              MyText(
                                text:
                                    "${Constant.currencyCode} ${meetingListData?.price.toString() ?? ""}",
                                multilanguage: false,
                                color: black,
                                fontsizeNormal: Dimens.textTitle,
                                fontsizeWeb: Dimens.textBig,
                                fontwaight: FontWeight.w600,
                              ),
                              InkWell(
                                splashColor: transparent,
                                focusColor: transparent,
                                hoverColor: transparent,
                                onTap: () async {
                                  profileProvider.setAppoinment(
                                      index: "1",
                                      name: "book_appointment",
                                      ids:
                                          meetingListData?.id.toString() ?? "");

                                  profileProvider.setPrice(
                                      value:
                                          meetingListData?.price.toString() ??
                                              "");

                                  /* APi Call */

                                  await getAppointmentApi();
                                },
                                child: Container(
                                  padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                                  decoration: BoxDecoration(
                                      color: colorPrimaryDark,
                                      borderRadius: BorderRadius.circular(4)),
                                  child: Row(
                                    mainAxisSize: MainAxisSize.min,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    spacing: 6,
                                    children: [
                                      Icon(
                                        Icons.calendar_month_rounded,
                                        size: 14,
                                        color: white,
                                      ),
                                      MyText(
                                        text: "book_a_session",
                                        multilanguage: true,
                                        color: white,
                                        fontsizeNormal: Dimens.textSmall,
                                        fontsizeWeb: Dimens.textBig,
                                        fontwaight: FontWeight.w600,
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ],
                          )
                        : _btnWidget(
                            color: colorPrimaryDark,
                            textColor: white,
                            onTap: () {
                              Utils.lanchUrl(
                                  meetingListData?.meetingLink ?? "");
                            },
                            borderColor: colorPrimaryDark,
                            title: "join_now")
                  ],
                ),
              ),
            );
          },
        ));
  }

  Widget _btnWidget({String? title, textColor, color, borderColor, onTap}) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: onTap,
      child: Container(
        padding: EdgeInsets.fromLTRB(24, 10, 24, 10),
        alignment: Alignment.center,
        width: MediaQuery.sizeOf(context).width,
        decoration: BoxDecoration(
            border: Border.all(
                width: 1, color: borderColor, style: BorderStyle.solid),
            color: color,
            borderRadius: BorderRadius.circular(10)),
        child: MyText(
          text: title ?? "",
          multilanguage: true,
          color: textColor,
          fontsizeNormal: Dimens.textMedium,
          fontsizeWeb: Dimens.textMedium,
          fontwaight: FontWeight.w600,
        ),
      ),
    );
  }

  Widget _upcomingShimmer() {
    return ResponsiveGridList(
        minItemWidth: 300,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 4,
            height1200: 3,
            height800: 2,
            height400: 2),
        minItemsPerRow: 1,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            padding: EdgeInsets.zero,
            physics: NeverScrollableScrollPhysics()),
        children: List.generate(
          10,
          (index) {
            return Card(
              color: white,
              elevation: 10,
              shadowColor: transparent.withValues(alpha: 0.3),
              child: Padding(
                padding: const EdgeInsets.fromLTRB(15, 10, 15, 10),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Row(
                      spacing: 20,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          padding: EdgeInsets.all(4),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              border: Border.all(
                                  width: 1,
                                  color: colorPrimaryDark,
                                  style: BorderStyle.solid)),
                          child: CustomWidget.circular(height: 80, width: 80),
                        ),
                        Expanded(
                          child: Align(
                            alignment: Alignment.bottomCenter,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              spacing: 6,
                              children: [
                                CustomWidget.roundcorner(
                                    height: 14, width: 100),
                                CustomWidget.roundcorner(
                                    height: 14, width: 100),
                                CustomWidget.roundcorner(
                                    height: 12, width: 100),
                              ],
                            ),
                          ),
                        ),
                        Container(
                          padding: EdgeInsets.fromLTRB(10, 6, 10, 6),
                          decoration: BoxDecoration(
                              color: green,
                              borderRadius: BorderRadius.circular(8)),
                          child:
                              CustomWidget.roundcorner(height: 20, width: 40),
                        )
                      ],
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      spacing: 20,
                      children: [
                        CustomWidget.roundcorner(height: 14, width: 100),
                        Container(
                          padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                          decoration: BoxDecoration(
                              color: colorPrimaryDark,
                              borderRadius: BorderRadius.circular(4)),
                          child:
                              CustomWidget.roundcorner(height: 14, width: 100),
                        ),
                      ],
                    )
                  ],
                ),
              ),
            );
          },
        ));
  }

/* My meeting Data */

  Widget _buildMyMeeting() {
    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      mainAxisAlignment: MainAxisAlignment.start,
      spacing: 20,
      children: [
        Expanded(
          flex: 7,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 20,
            children: [
              myMeetingTab(),
              _buildCommanData(),
            ],
          ),
        ),
        (meetingProvider.myTab == "2")
            ? (profileProvider.isShowDetails ?? "") == "1"
                ? Expanded(flex: 3, child: userMeetingDetails())
                : SizedBox.shrink()
            : SizedBox.shrink(),
      ],
    );
  }

  Widget myMeetingTab() {
    if (meetingProvider.statusLoading) {
      return Container(
        padding: EdgeInsets.all(12),
        decoration: BoxDecoration(
          color: white,
          borderRadius: BorderRadius.circular(12),
        ),
        child: SingleChildScrollView(
          padding: EdgeInsets.zero,
          scrollDirection: Axis.horizontal,
          physics: NeverScrollableScrollPhysics(),
          child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              crossAxisAlignment: CrossAxisAlignment.center,
              spacing: 20,
              children: List.generate(
                4,
                (index) {
                  return Container(
                    padding: const EdgeInsets.all(10),
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(10),
                      color: transparent,
                    ),
                    child: CustomWidget.roundcorner(
                      height: 14,
                      width: 100,
                    ),
                  );
                },
              )),
        ),
      );
    } else {
      if ((meetingProvider.meetingStatusModel.result?.length ?? 0) > 0) {
        return SingleChildScrollView(
          padding: EdgeInsets.zero,
          scrollDirection: Axis.horizontal,
          physics: BouncingScrollPhysics(),
          child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              crossAxisAlignment: CrossAxisAlignment.center,
              spacing: 0,
              children: List.generate(
                meetingProvider.meetingStatusModel.result?.length ?? 0,
                (index) {
                  return _buildMyTab(
                      title: meetingProvider
                              .meetingStatusModel.result?[index].name ??
                          "",
                      count: meetingProvider
                              .meetingStatusModel.result?[index].value
                              .toString() ??
                          "",
                      onTap: () {
                        meetingProvider.setMyTab(meetingProvider
                                .meetingStatusModel.result?[index].value
                                .toString() ??
                            "");
                        /* Hide  details */
                        profileProvider.setDetails("0");

                        meetingProvider.clearUserMeetingContent();
                        meetingProvider.setLoading(false);
                        _fetchUserData(
                            meetingProvider
                                    .meetingStatusModel.result?[index].value
                                    .toString() ??
                                "",
                            0);
                      });
                },
              )),
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }

  Widget _buildMyTab({String? title, onTap, count}) {
    return InkWell(
      borderRadius: BorderRadius.circular(10),
      focusColor: transparent,
      highlightColor: transparent,
      hoverColor: transparent,
      splashColor: transparent,
      onTap: onTap,
      child: Container(
        padding: const EdgeInsets.fromLTRB(12, 10, 12, 10),
        alignment: Alignment.center,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color:
              meetingProvider.myTab == count ? colorPrimaryDark : transparent,
        ),
        child: MyText(
            color: meetingProvider.myTab == count ? white : colorPrimary,
            text: title ?? "",
            multilanguage: false,
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            textalign: TextAlign.left,
            fontstyle: FontStyle.normal),
      ),
    );
  }

  Widget _buildCommanData() {
    if (meetingProvider.loading && !meetingProvider.loadMore) {
      return _userMeetingShimmer();
    } else {
      if (meetingProvider.userMeetingList != null &&
          (meetingProvider.userMeetingList?.length ?? 0) > 0) {
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            _commanData(),
            const SizedBox(height: 30),
            if (meetingProvider.loadMore)
              Utils.pageLoader()
            else
              const SizedBox.shrink(),
            const SizedBox(height: 10),
          ],
        );
      } else {
        return NoData();
      }
    }
  }

  Widget _commanData() {
    return ResponsiveGridList(
        minItemWidth: 300,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            padding: EdgeInsets.zero,
            physics: NeverScrollableScrollPhysics()),
        children: List.generate(
          meetingProvider.userMeetingList?.length ?? 0,
          (index) {
            final meetingListData = meetingProvider.userMeetingList?[index];
            return Card(
              color: white,
              elevation: 10,
              shadowColor: transparent.withValues(alpha: 0.3),
              child: Padding(
                padding: const EdgeInsets.fromLTRB(14, 12, 14, 12),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  spacing: 14,
                  children: [
                    Row(
                      spacing: 14,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          padding: EdgeInsets.all(4),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              border: Border.all(
                                  width: 1,
                                  color: colorPrimaryDark,
                                  style: BorderStyle.solid)),
                          child: MyNetworkImage(
                              radius: 50,
                              imgHeight: 80,
                              imgWidth: 80,
                              imageUrl: meetingListData?.lecturerImage ?? "",
                              fit: BoxFit.fill),
                        ),
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            spacing: 6,
                            children: [
                              MyText(
                                text: meetingListData?.lecturerName ?? "",
                                multilanguage: false,
                                color: black,
                                fontsizeNormal: Dimens.textTitle,
                                fontsizeWeb: Dimens.textBig,
                                fontwaight: FontWeight.w600,
                              ),
                              Row(
                                spacing: 4,
                                crossAxisAlignment: CrossAxisAlignment.center,
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Flexible(
                                    fit: FlexFit.loose,
                                    child: MyText(
                                      text: meetingListData?.courseTitle ?? "",
                                      multilanguage: false,
                                      maxline: 1,
                                      color: black,
                                      fontsizeNormal: Dimens.textMedium,
                                      fontsizeWeb: Dimens.textBig,
                                      fontwaight: FontWeight.w400,
                                    ),
                                  ),
                                  Container(
                                    height: 4,
                                    width: 4,
                                    color: gray,
                                  ),
                                  Flexible(
                                    fit: FlexFit.loose,
                                    child: MyText(
                                      text: meetingListData?.date ?? "",
                                      multilanguage: false,
                                      maxline: 1,
                                      color: black,
                                      fontsizeNormal: Dimens.textMedium,
                                      fontsizeWeb: Dimens.textBig,
                                      fontwaight: FontWeight.w400,
                                    ),
                                  ),
                                ],
                              ),
                              Row(
                                crossAxisAlignment: CrossAxisAlignment.center,
                                mainAxisAlignment: MainAxisAlignment.start,
                                spacing: 4,
                                children: [
                                  Container(
                                    padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                                    decoration: BoxDecoration(
                                        color:
                                            _statusColor(meetingProvider.myTab)
                                                .withValues(alpha: 0.3),
                                        borderRadius: BorderRadius.circular(8)),
                                    child: MyText(
                                      text: _statusName(meetingProvider.myTab),
                                      multilanguage: true,
                                      color: _statusTextColor(
                                          meetingProvider.myTab),
                                      fontsizeNormal: Dimens.textSmall,
                                      fontsizeWeb: Dimens.textBig,
                                      fontwaight: FontWeight.w600,
                                    ),
                                  ),
                                  Flexible(
                                    fit: FlexFit.loose,
                                    child: MyText(
                                      maxline: 1,
                                      text: Utils.formateTime(
                                          staTime:
                                              meetingListData?.startTime ?? "",
                                          enTime:
                                              meetingListData?.endTime ?? ""),
                                      multilanguage: false,
                                      color: black,
                                      fontsizeNormal: Dimens.textMedium,
                                      fontsizeWeb: Dimens.textBig,
                                      fontwaight: FontWeight.w400,
                                    ),
                                  ),
                                ],
                              ),
                            ],
                          ),
                        ),
                        MyText(
                          text:
                              "${Constant.currencyCode} ${meetingListData?.totalPrice.toString() ?? ""}",
                          multilanguage: false,
                          color: colorPrimaryDark,
                          fontsizeNormal: Dimens.textBig,
                          fontsizeWeb: Dimens.textBig,
                          fontwaight: FontWeight.w600,
                        ),
                      ],
                    ),
                    (meetingProvider.myTab == "1")
                        ? Row(
                            spacing: 20,
                            children: [
                              Expanded(
                                child: _btnWidget(
                                    color: colorPrimaryDark,
                                    textColor: white,
                                    onTap: () {
                                      Utils.lanchUrl(
                                          meetingListData?.joinLinks ?? "");
                                    },
                                    borderColor: colorPrimaryDark,
                                    title: "join_now"),
                              ),
                              Expanded(
                                child: _btnWidget(
                                    color: white,
                                    textColor: colorPrimaryDark,
                                    onTap: () async {
                                      Utils()
                                          .showProgress(context, "Please Wait");
                                      await meetingProvider
                                          .getCancelAppointment(
                                              meetingListData?.id.toString() ??
                                                  "");
                                      if (!mounted) return;

                                      Utils().hideProgress(context);
                                      /* API Call */

                                      meetingProvider.clearUserMeetingContent();
                                      meetingProvider.setMyTab("3");
                                      meetingProvider.getUseMeeting("3", 0);
                                    },
                                    borderColor: colorPrimaryDark,
                                    title: "cancel"),
                              ),
                            ],
                          )
                        : (meetingProvider.myTab == "3")
                            ? _btnWidget(
                                color: colorPrimaryDark,
                                textColor: white,
                                onTap: () async {
                                  meetingProvider.clearTimeSolt();

                                  showDateAndTime(
                                      meetingListData?.mettingId.toString() ??
                                          "",
                                      meetingListData?.id.toString() ?? "");

                                  // /* Api Call */

                                  await meetingProvider.getTimeSlotSelect(
                                      meetingListData?.mettingId.toString() ??
                                          "",
                                      meetingProvider.selectedValue);
                                },
                                borderColor: colorPrimaryDark,
                                title: "re_schedule")
                            : Row(
                                spacing: 20,
                                children: [
                                  Expanded(
                                    child: _btnWidget(
                                        color: colorPrimaryDark,
                                        textColor: white,
                                        borderColor: colorPrimaryDark,
                                        onTap: () {
                                          profileProvider.setDetails("1");

                                          /* APi call */
                                          profileProvider.clearSession();
                                          profileProvider.getViewSession(
                                              meetingListData?.id.toString() ??
                                                  "");
                                        },
                                        title: "view_details"),
                                  ),
                                  Expanded(
                                    child: _btnWidget(
                                        color: white,
                                        borderColor: colorPrimaryDark,
                                        textColor: colorPrimaryDark,
                                        onTap: () {},
                                        title: "write_review"),
                                  )
                                ],
                              ),
                  ],
                ),
              ),
            );
          },
        ));
  }

/* Reschldeldata */

  void showDateAndTime(String meetingId, appointmentId) {
    showModalBottomSheet(
      backgroundColor: white,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      context: context,
      builder: (context) {
        return Consumer<MeetingProvider>(
            builder: (context, meetingProvider, child) {
          return Container(
            padding: EdgeInsets.fromLTRB(20, 10, 20, 0),
            height: 600,
            width: MediaQuery.sizeOf(context).width,
            child: SingleChildScrollView(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 16,
                children: [
                  resDateCalender(meetingId),
                  resTimeSlotData(),
                  SizedBox(
                    height: 20,
                  ),
                  _btnWidget(
                      borderColor: transparent,
                      color: colorPrimary,
                      textColor: white,
                      title: "submit",
                      onTap: () {
                        String? dateC = DateFormat("yyyy-MM-dd")
                            .format(meetingProvider.selectedValue);
                        redchduledAPI(appointmentId,
                            meetingProvider.meetingScheduledId, dateC);
                      }),
                ],
              ),
            ),
          );
        });
      },
    );
  }

  Widget resDateCalender(String meetingId) {
    return Column(
      children: [
        Align(
          alignment: Alignment.centerLeft,
          child: MyText(
            text: "choose_date",
            multilanguage: true,
            fontsizeNormal: Dimens.textTitle,
            fontwaight: FontWeight.w700,
            fontstyle: FontStyle.normal,
            color: black,
          ),
        ),
        EasyDateTimeLine(
          timeLineProps: EasyTimeLineProps(margin: EdgeInsets.zero),
          initialDate: meetingProvider.selectedValue,
          onDateChange: (selectedDate) async {
            meetingProvider.setDate(selectedDate);
            // Get weekday name (e.g., Monday)
            final weekDayName = DateFormat('EEEE').format(selectedDate);
            meetingProvider.setWeekDay(weekDayName);
            meetingProvider.clearContent();

            await meetingProvider.getTimeSlotSelect(
                meetingId, meetingProvider.selectedValue);
          },
          activeColor: white,
          headerProps: EasyHeaderProps(
              showHeader: true,
              padding: EdgeInsets.zero,
              monthPickerType: MonthPickerType.switcher,
              showMonthPicker: true,
              centerHeader: true,
              monthStyle: GoogleFonts.lato(
                  fontSize: Dimens.textMedium,
                  color: colorPrimaryDark,
                  fontWeight: FontWeight.w600),
              showSelectedDate: false),
          locale: "en",
          dayProps: EasyDayProps(
              todayHighlightStyle: TodayHighlightStyle.withBackground,
              borderColor: gray,
              dayStructure: DayStructure.dayNumDayStr,
              height: 80,
              width: 50,
              inactiveDayStyle: DayStyle(
                  borderRadius: 10,
                  decoration: BoxDecoration(
                      color: white,
                      borderRadius: BorderRadius.circular(20),
                      border: Border.all(
                          width: 1, color: gray, style: BorderStyle.solid)),
                  dayNumStyle: GoogleFonts.lato(
                      fontSize: Dimens.textBig,
                      color: black,
                      fontWeight: FontWeight.w600)),
              activeDayStyle: DayStyle(
                  borderRadius: 10,
                  decoration: BoxDecoration(
                      color: white,
                      borderRadius: BorderRadius.circular(20),
                      border: Border.all(
                          width: 1,
                          color: colorPrimaryDark,
                          style: BorderStyle.solid)),
                  dayStrStyle: GoogleFonts.lato(
                      fontSize: Dimens.textMedium,
                      color: colorPrimaryDark,
                      fontWeight: FontWeight.w600),
                  monthStrStyle: GoogleFonts.lato(
                      fontSize: Dimens.textTitle,
                      color: colorPrimaryDark,
                      fontWeight: FontWeight.w600),
                  dayNumStyle: GoogleFonts.lato(
                      fontSize: Dimens.textBig,
                      color: colorPrimaryDark,
                      fontWeight: FontWeight.w600))),
        )
      ],
    );
  }

  Widget resTimeSlotData() {
    if (meetingProvider.timeSelectLoading) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 10,
        children: [
          MyText(
            text: 'choose_time_slot',
            multilanguage: true,
            fontsizeNormal: Dimens.textTitle,
            fontwaight: FontWeight.w600,
            fontstyle: FontStyle.normal,
            color: black,
          ),
          SingleChildScrollView(
            padding: EdgeInsets.zero,
            scrollDirection: Axis.horizontal,
            physics: NeverScrollableScrollPhysics(),
            child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                crossAxisAlignment: CrossAxisAlignment.center,
                spacing: 20,
                children: List.generate(
                  4,
                  (index) {
                    return Container(
                      padding: const EdgeInsets.all(10),
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(10),
                        color: transparent,
                      ),
                      child: CustomWidget.roundcorner(
                        height: 14,
                        width: 100,
                      ),
                    );
                  },
                )),
          ),
        ],
      );
    } else {
      /* Main Result Data */
      if (meetingProvider.selectedTimeSloteModel.status == 200 &&
          (meetingProvider.selectedTimeSloteModel.result?.length ?? 0) > 0) {
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          spacing: 10,
          children: [
            MyText(
              text: 'choose_time_slot',
              multilanguage: true,
              fontsizeNormal: Dimens.textTitle,
              fontwaight: FontWeight.w600,
              fontstyle: FontStyle.normal,
              color: black,
            ),
            SingleChildScrollView(
              scrollDirection: Axis.horizontal,
              padding: EdgeInsets.zero,
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.start,
                children: List.generate(
                  meetingProvider.selectedTimeSloteModel.result?.length ?? 0,
                  (index) {
                    final timeSlot =
                        meetingProvider.selectedTimeSloteModel.result?[index];
                    /* Time slot Data Result show */
                    return Row(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: List.generate(
                        timeSlot?.timeSlotes?.length ?? 0,
                        (postion) {
                          final subTimeSlot = timeSlot?.timeSlotes?[postion];
                          /* Time schedul Data Result show */
                          return Row(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            spacing: 10,
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: List.generate(
                              subTimeSlot?.timeSchedul?.length ?? 0,
                              (timeSchedulPostion) {
                                final subTimeSlotSchedul = subTimeSlot
                                    ?.timeSchedul?[timeSchedulPostion];
                                return InkWell(
                                  splashColor: transparent,
                                  focusColor: transparent,
                                  hoverColor: transparent,
                                  onTap: () {
                                    if ((subTimeSlotSchedul?.isBook
                                                .toString() ??
                                            "") ==
                                        "1") {
                                      printLog("selecte the time slot");
                                    } else {
                                      meetingProvider.setMeetingId(
                                          id: subTimeSlotSchedul?.id
                                                  .toString() ??
                                              "",
                                          start: subTimeSlotSchedul?.startTime
                                                  .toString() ??
                                              "",
                                          end: subTimeSlotSchedul?.endTime
                                                  .toString() ??
                                              "");
                                    }
                                  },
                                  child: Container(
                                    padding: const EdgeInsets.fromLTRB(
                                        15, 10, 15, 10),
                                    alignment: Alignment.center,
                                    decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(10),
                                        color: (subTimeSlotSchedul?.isBook
                                                        .toString() ??
                                                    "") ==
                                                "1"
                                            ? colorPrimary
                                            : meetingProvider
                                                        .meetingScheduledId ==
                                                    (subTimeSlotSchedul?.id
                                                            .toString() ??
                                                        "")
                                                ? colorPrimaryDark
                                                : transparent),
                                    child: MyText(
                                      text: Utils.formateTime(
                                          staTime:
                                              subTimeSlotSchedul?.startTime ??
                                                  "",
                                          enTime: subTimeSlotSchedul?.endTime ??
                                              ""),
                                      fontsizeNormal: Dimens.textMedium,
                                      fontwaight: FontWeight.w600,
                                      color: (subTimeSlotSchedul?.isBook
                                                      .toString() ??
                                                  "") ==
                                              "1"
                                          ? white
                                          : meetingProvider
                                                      .meetingScheduledId ==
                                                  (subTimeSlotSchedul?.id
                                                          .toString() ??
                                                      "")
                                              ? white
                                              : black,
                                    ),
                                  ),
                                );
                              },
                            ),
                          );
                        },
                      ),
                    );
                  },
                ),
              ),
            ),
          ],
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }

/* API Call Reschduled */

  Future<void> redchduledAPI(
      String appointmentId, mettingScheduleId, date) async {
    Utils().showProgress(context, "Please Wait");
    await meetingProvider.getReschedulesAppointment(
        appointmentId, mettingScheduleId, date);

    if (meetingProvider.successModel.status == 200) {
      if (!mounted) return;
      Utils().hideProgress(context);
      if (Navigator.canPop(context)) {
        Navigator.of(context).pop();
      }

      /* API Call */

      meetingProvider.clearUserMeetingContent();
      meetingProvider.setMyTab("1");
      meetingProvider.getUseMeeting("1", 0);
    } else {
      if (!mounted) return;
      Utils().hideProgress(context);

      Utils.showSnackbar(
          context, "fail", meetingProvider.successModel.message ?? "", false);
      printLog(meetingProvider.successModel.message ?? "");
    }
  }

/* User meeting competed started the details page */

  Widget userMeetingDetails() {
    if (profileProvider.viewSessionLoading) {
      return userMeetinDetailShimmer();
    } else {
      if (profileProvider.viewSessionModel.status == 200 &&
          (profileProvider.viewSessionModel.result?.length ?? 0) > 0) {
        return Container(
          padding: EdgeInsets.all(16),
          decoration: BoxDecoration(
              color: white,
              borderRadius: BorderRadius.circular(16),
              boxShadow: [
                BoxShadow(
                    blurRadius: 4,
                    blurStyle: BlurStyle.solid,
                    color: transparent.withValues(alpha: 0.25),
                    offset: Offset(0, 4),
                    spreadRadius: 0)
              ]),
          child: SingleChildScrollView(
            physics: AlwaysScrollableScrollPhysics(),
            child: Stack(
              children: [
                SizedBox(
                  height: 430,
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    spacing: 20,
                    children: [
                      _details(),
                      _seeNoteData(),
                      _downloadSessions(),
                    ],
                  ),
                ),
                Positioned(
                  top: 350,
                  left: 10,
                  right: 10,
                  child: Stack(
                    alignment: Alignment.center,
                    children: [
                      MyImage(
                        width: MediaQuery.sizeOf(context).width,
                        height: 80,
                        imagePath: "download_session.png",
                        fit: BoxFit.fill,
                      ),
                      MyText(
                        text: "Download  Sessions",
                        multilanguage: false,
                        color: white,
                        fontsizeNormal: Dimens.textBig,
                        fontsizeWeb: Dimens.textBig,
                        fontwaight: FontWeight.w600,
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ),
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }

  Widget _details() {
    return Card(
      color: white,
      elevation: 10,
      shadowColor: transparent.withValues(alpha: 0.3),
      child: Padding(
        padding: const EdgeInsets.fromLTRB(14, 12, 14, 12),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          spacing: 14,
          children: [
            Row(
              spacing: 14,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Container(
                  padding: EdgeInsets.all(4),
                  decoration: BoxDecoration(
                      shape: BoxShape.circle,
                      border: Border.all(
                          width: 1,
                          color: colorPrimaryDark,
                          style: BorderStyle.solid)),
                  child: MyNetworkImage(
                      radius: 50,
                      imgHeight: 60,
                      imgWidth: 60,
                      imageUrl: profileProvider
                              .viewSessionModel.result?[0].lecturerImage ??
                          "",
                      fit: BoxFit.fill),
                ),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    spacing: 6,
                    children: [
                      MyText(
                        text: profileProvider
                                .viewSessionModel.result?[0].lecturerName ??
                            "",
                        multilanguage: false,
                        color: black,
                        fontsizeNormal: Dimens.textTitle,
                        fontsizeWeb: Dimens.textBig,
                        fontwaight: FontWeight.w600,
                      ),
                      Row(
                        spacing: 4,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          Flexible(
                            fit: FlexFit.loose,
                            child: MyText(
                              text: profileProvider.viewSessionModel.result?[0]
                                      .courseTitle ??
                                  "",
                              multilanguage: false,
                              maxline: 1,
                              color: black,
                              fontsizeNormal: Dimens.textMedium,
                              fontsizeWeb: Dimens.textBig,
                              fontwaight: FontWeight.w400,
                            ),
                          ),
                          Container(
                            height: 4,
                            width: 4,
                            color: gray,
                          ),
                          Flexible(
                            fit: FlexFit.loose,
                            child: MyText(
                              text: profileProvider
                                      .viewSessionModel.result?[0].date ??
                                  "",
                              multilanguage: false,
                              maxline: 1,
                              color: black,
                              fontsizeNormal: Dimens.textMedium,
                              fontsizeWeb: Dimens.textBig,
                              fontwaight: FontWeight.w400,
                            ),
                          ),
                        ],
                      ),
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.start,
                        spacing: 4,
                        children: [
                          Container(
                            padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                            decoration: BoxDecoration(
                                color: green.withValues(alpha: 0.3),
                                borderRadius: BorderRadius.circular(8)),
                            child: MyText(
                              text: "completed",
                              multilanguage: true,
                              color: green,
                              fontsizeNormal: Dimens.textSmall,
                              fontsizeWeb: Dimens.textBig,
                              fontwaight: FontWeight.w600,
                            ),
                          ),
                          Flexible(
                            fit: FlexFit.loose,
                            child: MyText(
                              maxline: 1,
                              text: Utils.formateTime(
                                  staTime: profileProvider.viewSessionModel
                                          .result?[0].startTime ??
                                      "",
                                  enTime: profileProvider.viewSessionModel
                                          .result?[0].endTime ??
                                      ""),
                              multilanguage: false,
                              color: black,
                              fontsizeNormal: Dimens.textMedium,
                              fontsizeWeb: Dimens.textBig,
                              fontwaight: FontWeight.w400,
                            ),
                          ),
                        ],
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _seeNoteData() {
    return Card(
      color: white,
      elevation: 10,
      shadowColor: transparent.withValues(alpha: 0.3),
      child: Padding(
        padding: const EdgeInsets.fromLTRB(14, 12, 14, 12),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          spacing: 10,
          children: [
            Expanded(
              child: MyText(
                text: "see_notes",
                multilanguage: true,
                color: black,
                fontsizeNormal: Dimens.textMedium,
                fontsizeWeb: Dimens.textBig,
                fontwaight: FontWeight.w600,
              ),
            ),
            Icon(
              Icons.visibility,
              size: 20,
              color: black,
            ),
            Icon(
              Icons.download,
              size: 20,
              color: black,
            ),
          ],
        ),
      ),
    );
  }

  Widget _downloadSessions() {
    return Stack(
      children: [
        Container(
          padding: EdgeInsets.fromLTRB(16, 16, 16, 23),
          decoration: BoxDecoration(
              color: colorPrimary.withValues(alpha: 0.6),
              borderRadius: BorderRadius.circular(10)),
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisSize: MainAxisSize.min,
            children: [
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    MyText(
                      text: "Download Recorded Sessions",
                      multilanguage: false,
                      maxline: 2,
                      color: colorPrimaryDark,
                      fontsizeNormal: Dimens.textExtraBig,
                      fontsizeWeb: Dimens.textBig,
                      fontwaight: FontWeight.w600,
                    ),
                    RichText(
                      text: TextSpan(
                        text: 'Sent you by  ',
                        style: GoogleFonts.lato(
                            fontSize: Dimens.textMedium,
                            color: black,
                            fontWeight: FontWeight.w400),
                        children: <TextSpan>[
                          TextSpan(
                              text:
                                  '${profileProvider.viewSessionModel.result?[0].lecturerName ?? ""},  ',
                              style: GoogleFonts.lato(
                                  fontSize: Dimens.textMedium,
                                  color: black,
                                  fontWeight: FontWeight.w600)),
                          TextSpan(
                            text: 'your last Meeting  session Recording',
                            style: GoogleFonts.lato(
                                fontSize: Dimens.textMedium,
                                color: black,
                                fontWeight: FontWeight.w400),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
              MyImage(
                width: 120,
                height: 120,
                imagePath: "download_re_se.png",
                fit: BoxFit.cover,
              ),
            ],
          ),
        ),
      ],
    );
  }

  Widget userMeetinDetailShimmer() {
    return Container(
      padding: EdgeInsets.all(16),
      decoration: BoxDecoration(
          color: white,
          borderRadius: BorderRadius.circular(16),
          boxShadow: [
            BoxShadow(
                blurRadius: 4,
                blurStyle: BlurStyle.solid,
                color: transparent.withValues(alpha: 0.25),
                offset: Offset(0, 4),
                spreadRadius: 0)
          ]),
      child: Card(
        color: white,
        elevation: 10,
        shadowColor: transparent.withValues(alpha: 0.3),
        child: Padding(
          padding: const EdgeInsets.fromLTRB(14, 12, 14, 12),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 14,
            children: [
              Row(
                spacing: 14,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                      padding: EdgeInsets.all(4),
                      decoration: BoxDecoration(
                          shape: BoxShape.circle,
                          border: Border.all(
                              width: 1,
                              color: colorPrimaryDark,
                              style: BorderStyle.solid)),
                      child: CustomWidget.circular(height: 60, width: 60)),
                  Expanded(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      spacing: 6,
                      children: [
                        CustomWidget.roundcorner(height: 16, width: 200),
                        Row(
                          spacing: 4,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Flexible(
                              fit: FlexFit.loose,
                              child: CustomWidget.roundcorner(
                                  height: 12, width: 200),
                            ),
                            Container(
                              height: 4,
                              width: 4,
                              color: gray,
                            ),
                            Flexible(
                              fit: FlexFit.loose,
                              child: CustomWidget.roundcorner(
                                  height: 12, width: 200),
                            ),
                          ],
                        ),
                        Row(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisAlignment: MainAxisAlignment.start,
                          spacing: 4,
                          children: [
                            Container(
                              padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                              decoration: BoxDecoration(
                                  color: green.withValues(alpha: 0.3),
                                  borderRadius: BorderRadius.circular(8)),
                              child: MyText(
                                text: "completed",
                                multilanguage: true,
                                color: green,
                                fontsizeNormal: Dimens.textSmall,
                                fontsizeWeb: Dimens.textBig,
                                fontwaight: FontWeight.w600,
                              ),
                            ),
                            Flexible(
                              fit: FlexFit.loose,
                              child: CustomWidget.roundcorner(
                                  height: 12, width: 200),
                            ),
                          ],
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }

/* END */
  String _statusName(String index) {
    switch (index) {
      case "1":
        return "upcoming";
      case "2":
        return "completed";
      case "3":
        return "cancelled";
      default:
        return "";
    }
  }

  Color _statusTextColor(String index) {
    switch (index) {
      case "1":
        return colorAccent;
      case "2":
        return green;
      case "3":
        return red;
      default:
        return white;
    }
  }

  Color _statusColor(String index) {
    switch (index) {
      case "1":
        return colorAccent;
      case "2":
        return green;
      case "3":
        return red;
      default:
        return white;
    }
  }

  Widget _userMeetingShimmer() {
    return ResponsiveGridList(
        minItemWidth: 300,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            padding: EdgeInsets.zero,
            physics: NeverScrollableScrollPhysics()),
        children: List.generate(
          10,
          (index) {
            return Card(
              color: white,
              elevation: 10,
              shadowColor: transparent.withValues(alpha: 0.3),
              child: Padding(
                padding: const EdgeInsets.fromLTRB(15, 10, 15, 10),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  spacing: 10,
                  children: [
                    Row(
                      spacing: 20,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          padding: EdgeInsets.all(4),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              border: Border.all(
                                  width: 1,
                                  color: colorPrimaryDark,
                                  style: BorderStyle.solid)),
                          child: CustomWidget.circular(height: 80, width: 80),
                        ),
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            spacing: 6,
                            children: [
                              CustomWidget.roundcorner(height: 14, width: 100),
                              CustomWidget.roundcorner(height: 12, width: 100),
                              CustomWidget.roundcorner(height: 12, width: 100),
                            ],
                          ),
                        ),
                        CustomWidget.roundcorner(height: 20, width: 40)
                      ],
                    ),
                    Container(
                      padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                      width: MediaQuery.sizeOf(context).width,
                      decoration: BoxDecoration(
                          color: colorPrimaryDark,
                          borderRadius: BorderRadius.circular(4)),
                      child: CustomWidget.roundcorner(height: 14, width: 100),
                    ),
                  ],
                ),
              ),
            );
          },
        ));
  }

/* Appointment Data Started */

  Widget _buildAppointment() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      spacing: 20,
      children: [
        dateCalender(),
        timeSlotData(),
        MyText(
          text: 'discussion_topic',
          multilanguage: true,
          fontsizeNormal: Dimens.textTitle,
          fontwaight: FontWeight.w600,
          fontstyle: FontStyle.normal,
          color: black,
        ),
        chapterNameData(),
        TextFormField(
          obscureText: false,
          keyboardType: TextInputType.multiline,
          controller: detsilsController,
          textInputAction: TextInputAction.newline,
          minLines: 3,
          maxLines: 5,
          cursorColor: black,
          style: GoogleFonts.inter(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: black,
              letterSpacing: 1,
              fontWeight: FontWeight.w600),
          decoration: InputDecoration(
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: black, style: BorderStyle.solid),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: black, style: BorderStyle.solid),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: black, style: BorderStyle.solid),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: black, style: BorderStyle.solid),
            ),
            hintText: "Write your brief details here",
            hintStyle: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                letterSpacing: 1,
                color: gray,
                fontWeight: FontWeight.w500),
            labelText: Locales.string(context, "details"),
            labelStyle: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                letterSpacing: 1,
                color: gray,
                fontWeight: FontWeight.w500),
          ),
        ),
        _attachMentData(),
        _bookingBtn(),
      ],
    );
  }

  Widget dateCalender() {
    return Column(
      children: [
        Align(
          alignment: Alignment.centerLeft,
          child: MyText(
            text: "choose_date",
            multilanguage: true,
            fontsizeNormal: Dimens.textTitle,
            fontwaight: FontWeight.w700,
            fontstyle: FontStyle.normal,
            color: black,
          ),
        ),
        EasyDateTimeLine(
          timeLineProps: EasyTimeLineProps(margin: EdgeInsets.zero),
          initialDate: profileProvider.selectedValue,
          onDateChange: (selectedDate) {
            if (!selectedDate
                .isBefore(DateTime.now().subtract(Duration(days: 1)))) {
              // Only allow today and future dates
              profileProvider
                  .setDate(selectedDate); // Get weekday name (e.g., Monday)
              final weekDayName = DateFormat('EEEE').format(selectedDate);
              profileProvider.setWeekDay(weekDayName);
              profileProvider.clearContent();
              getTimeSoltApi(profileProvider.selectedValue);
            }
          },
          activeColor: white,
          headerProps: EasyHeaderProps(
              showHeader: true,
              padding: EdgeInsets.zero,
              monthPickerType: MonthPickerType.switcher,
              showMonthPicker: true,
              centerHeader: true,
              monthStyle: GoogleFonts.lato(
                  fontSize: Dimens.textMedium,
                  color: colorPrimaryDark,
                  fontWeight: FontWeight.w600),
              showSelectedDate: false),
          locale: "en",
          dayProps: EasyDayProps(
              todayHighlightStyle: TodayHighlightStyle.withBackground,
              borderColor: gray,
              dayStructure: DayStructure.dayNumDayStr,
              height: 80,
              width: 50,
              inactiveDayStyle: DayStyle(
                  borderRadius: 10,
                  decoration: BoxDecoration(
                      color: white,
                      borderRadius: BorderRadius.circular(20),
                      border: Border.all(
                          width: 1, color: gray, style: BorderStyle.solid)),
                  dayNumStyle: GoogleFonts.lato(
                      fontSize: Dimens.textBig,
                      color: black,
                      fontWeight: FontWeight.w600)),
              activeDayStyle: DayStyle(
                  borderRadius: 10,
                  decoration: BoxDecoration(
                      color: white,
                      borderRadius: BorderRadius.circular(20),
                      border: Border.all(
                          width: 1,
                          color: colorPrimaryDark,
                          style: BorderStyle.solid)),
                  dayStrStyle: GoogleFonts.lato(
                      fontSize: Dimens.textMedium,
                      color: colorPrimaryDark,
                      fontWeight: FontWeight.w600),
                  monthStrStyle: GoogleFonts.lato(
                      fontSize: Dimens.textTitle,
                      color: colorPrimaryDark,
                      fontWeight: FontWeight.w600),
                  dayNumStyle: GoogleFonts.lato(
                      fontSize: Dimens.textBig,
                      color: colorPrimaryDark,
                      fontWeight: FontWeight.w600))),
        )
      ],
    );
  }

  Widget timeSlotData() {
    if (profileProvider.timeSlotLoading) {
      return SingleChildScrollView(
        padding: EdgeInsets.zero,
        scrollDirection: Axis.horizontal,
        physics: NeverScrollableScrollPhysics(),
        child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            crossAxisAlignment: CrossAxisAlignment.center,
            spacing: 20,
            children: List.generate(
              4,
              (index) {
                return Container(
                  padding: const EdgeInsets.all(10),
                  alignment: Alignment.center,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(10),
                    color: transparent,
                  ),
                  child: CustomWidget.roundcorner(
                    height: 14,
                    width: 100,
                  ),
                );
              },
            )),
      );
    } else {
      /* Main Result Data */
      if (profileProvider.selectedTimeSloteModel.status == 200 &&
          (profileProvider.selectedTimeSloteModel.result?.length ?? 0) > 0) {
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          spacing: 10,
          children: [
            MyText(
              text: 'choose_time_slot',
              multilanguage: true,
              fontsizeNormal: Dimens.textTitle,
              fontwaight: FontWeight.w600,
              fontstyle: FontStyle.normal,
              color: black,
            ),
            SingleChildScrollView(
              scrollDirection: Axis.horizontal,
              padding: EdgeInsets.zero,
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.start,
                children: List.generate(
                  profileProvider.selectedTimeSloteModel.result?.length ?? 0,
                  (index) {
                    final timeSlot =
                        profileProvider.selectedTimeSloteModel.result?[index];
                    /* Time slot Data Result show */
                    return Row(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: List.generate(
                        timeSlot?.timeSlotes?.length ?? 0,
                        (postion) {
                          final subTimeSlot = timeSlot?.timeSlotes?[postion];
                          /* Time schedul Data Result show */
                          return Row(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            spacing: 10,
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: List.generate(
                              subTimeSlot?.timeSchedul?.length ?? 0,
                              (timeSchedulPostion) {
                                final subTimeSlotSchedul = subTimeSlot
                                    ?.timeSchedul?[timeSchedulPostion];
                                return InkWell(
                                  splashColor: transparent,
                                  focusColor: transparent,
                                  hoverColor: transparent,
                                  onTap: () {
                                    if ((subTimeSlotSchedul?.isBook
                                                .toString() ??
                                            "") ==
                                        "1") {
                                      printLog("selecte the time slot");
                                    } else {
                                      profileProvider.setMeetingId(
                                          id: subTimeSlotSchedul?.id
                                                  .toString() ??
                                              "",
                                          start: subTimeSlotSchedul?.startTime
                                                  .toString() ??
                                              "",
                                          end: subTimeSlotSchedul?.endTime
                                                  .toString() ??
                                              "");
                                    }
                                  },
                                  child: Container(
                                    padding: const EdgeInsets.fromLTRB(
                                        15, 10, 15, 10),
                                    alignment: Alignment.center,
                                    decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(10),
                                        color: (subTimeSlotSchedul?.isBook
                                                        .toString() ??
                                                    "") ==
                                                "1"
                                            ? colorPrimary
                                            : profileProvider
                                                        .meetingScheduledId ==
                                                    (subTimeSlotSchedul?.id
                                                            .toString() ??
                                                        "")
                                                ? colorPrimaryDark
                                                : transparent),
                                    child: MyText(
                                      text: Utils.formateTime(
                                          staTime:
                                              subTimeSlotSchedul?.startTime ??
                                                  "",
                                          enTime: subTimeSlotSchedul?.endTime ??
                                              ""),
                                      fontsizeNormal: Dimens.textMedium,
                                      fontwaight: FontWeight.w600,
                                      color: (subTimeSlotSchedul?.isBook
                                                      .toString() ??
                                                  "") ==
                                              "1"
                                          ? white
                                          : profileProvider
                                                      .meetingScheduledId ==
                                                  (subTimeSlotSchedul?.id
                                                          .toString() ??
                                                      "")
                                              ? white
                                              : black,
                                    ),
                                  ),
                                );
                              },
                            ),
                          );
                        },
                      ),
                    );
                  },
                ),
              ),
            ),
          ],
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }

  /* Course name Started */
  Widget chapterNameData() {
    if (profileProvider.courseNameLoading) {
      return CustomWidget.roundcorner(
        height: 50,
        width: MediaQuery.sizeOf(context).width,
      );
    } else {
      if (profileProvider.courseNameModel.status == 200 &&
          (profileProvider.courseNameModel.result?.length ?? 0) > 0) {
        return Card(
          color: white,
          elevation: 6,
          shadowColor: transparent.withValues(alpha: .6),
          child: DropdownMenu(
            initialSelection: profileProvider.chapterId,
            onSelected: (value) {
              if (value != null) {
                profileProvider.setCourseId(value);
              }
            },
            trailingIcon:
                Icon(Icons.keyboard_arrow_down, color: black, size: 20),
            selectedTrailingIcon:
                Icon(Icons.keyboard_arrow_up, color: black, size: 20),
            width: MediaQuery.sizeOf(context).width,
            menuStyle: MenuStyle(
                visualDensity: VisualDensity.comfortable,
                backgroundColor: WidgetStatePropertyAll(white)),
            inputDecorationTheme: InputDecorationTheme(
                enabledBorder: OutlineInputBorder(
                    borderSide: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .5),
                        style: BorderStyle.none),
                    borderRadius: BorderRadius.circular(12)),
                errorBorder: OutlineInputBorder(
                    borderSide: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .5),
                        style: BorderStyle.none),
                    borderRadius: BorderRadius.circular(12)),
                focusedBorder: OutlineInputBorder(
                    borderSide: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .5),
                        style: BorderStyle.none),
                    borderRadius: BorderRadius.circular(12)),
                border: OutlineInputBorder(
                    borderSide: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .5),
                        style: BorderStyle.none),
                    borderRadius: BorderRadius.circular(12))),
            hintText: "Select the Subject Name...",
            textStyle: GoogleFonts.manrope(
                fontSize: Dimens.textTitle,
                fontWeight: FontWeight.w500,
                fontStyle: FontStyle.normal,
                color: black),
            dropdownMenuEntries:
                (profileProvider.courseNameModel.result ?? []).map((category) {
              return DropdownMenuEntry(
                  value: category.id.toString(), label: category.title ?? "");
            }).toList(),
          ),
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget _attachMentData() {
    return Container(
      width: MediaQuery.sizeOf(context).width,
      padding: EdgeInsets.all(16),
      decoration: BoxDecoration(
          color: white,
          borderRadius: BorderRadius.circular(16),
          boxShadow: [
            BoxShadow(
                blurRadius: 12,
                blurStyle: BlurStyle.outer,
                color: transparent.withValues(alpha: 0.6),
                offset: Offset(0, 2),
                spreadRadius: 0)
          ]),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 10,
        children: [
          MyText(
            text: "attach_notes",
            multilanguage: true,
            fontsizeNormal: Dimens.textTitle,
            fontwaight: FontWeight.w700,
            fontstyle: FontStyle.normal,
            color: black,
          ),
          MyText(
            text: ((profileProvider.fileName ?? "") != "")
                ? (profileProvider.fileName ?? "")
                : "JPEG, PNG, PDF (min 4MB - max 8MB)",
            multilanguage: false,
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w500,
            fontstyle: FontStyle.normal,
            color: black,
          ),
          InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: () {
              profileProvider.pickImageWEB();
            },
            child: Container(
              padding: EdgeInsets.fromLTRB(24, 10, 24, 10),
              alignment: Alignment.center,
              width: MediaQuery.sizeOf(context).width,
              decoration: BoxDecoration(
                  border: Border.all(
                      width: 1,
                      color: colorPrimaryDark,
                      style: BorderStyle.solid),
                  color: white,
                  borderRadius: BorderRadius.circular(20)),
              child: MyText(
                text: 'upload_file',
                multilanguage: true,
                color: colorPrimaryDark,
                fontsizeNormal: Dimens.textMedium,
                fontsizeWeb: Dimens.textMedium,
                fontwaight: FontWeight.w600,
              ),
            ),
          )
        ],
      ),
    );
  }

/* Booking Btn */
  Widget _bookingBtn() {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: () {
        if (profileProvider.meetingScheduledId == "") {
          Utils.showSnackbar(context, "info", "ple_select_time", true);
        } else if (profileProvider.chapterId == "") {
          Utils.showSnackbar(context, "info", "ple_select_topic", true);
        } else {
          profileProvider.setConfAppoinment(
              index: "1",
              name: "check_out",
              ids: profileProvider.meetingId ?? "");

          /* Api call meeting details */
          profileProvider.getMeetingDetails(profileProvider.meetingId ?? "");
        }
      },
      child: Container(
        padding: EdgeInsets.fromLTRB(24, 12, 24, 12),
        alignment: Alignment.center,
        width: MediaQuery.sizeOf(context).width,
        decoration: BoxDecoration(
            border: Border.all(
                width: 1, color: transparent, style: BorderStyle.solid),
            color: colorPrimaryDark,
            borderRadius: BorderRadius.circular(20)),
        child: MyText(
          text: 'book_appointment',
          multilanguage: true,
          color: white,
          fontsizeNormal: Dimens.textMedium,
          fontsizeWeb: Dimens.textMedium,
          fontwaight: FontWeight.w500,
        ),
      ),
    );
  }

  /* Confirm appointment Data show */
  Widget _buildConfiData() {
    final screenWidth = MediaQuery.sizeOf(context).width;

    if (screenWidth > 1200) {
      return Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisAlignment: MainAxisAlignment.start,
        spacing: 20,
        children: [
          Expanded(
            child: Column(
              spacing: 20,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                MyText(
                  text: "booking_info",
                  multilanguage: true,
                  color: black,
                  maxline: 1,
                  fontsizeNormal: Dimens.textTitle,
                  fontsizeWeb: Dimens.textMedium,
                  fontwaight: FontWeight.w600,
                ),
                bookingInfoData(),
                SizedBox(height: 10),
              ],
            ),
          ),
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 20,
              children: [
                MyText(
                  text: "payment_info",
                  multilanguage: true,
                  color: black,
                  maxline: 1,
                  fontsizeNormal: Dimens.textTitle,
                  fontsizeWeb: Dimens.textMedium,
                  fontwaight: FontWeight.w600,
                ),
                paymentSummaryData(),
                _couponeShowdata(),
              ],
            ),
          ),
        ],
      );
    } else {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 20,
        children: [
          MyText(
            text: "booking_info",
            multilanguage: true,
            color: black,
            maxline: 1,
            fontsizeNormal: Dimens.textTitle,
            fontsizeWeb: Dimens.textMedium,
            fontwaight: FontWeight.w600,
          ),
          bookingInfoData(),
          SizedBox(height: 10),
          MyText(
            text: "payment_info",
            multilanguage: true,
            color: black,
            maxline: 1,
            fontsizeNormal: Dimens.textTitle,
            fontsizeWeb: Dimens.textMedium,
            fontwaight: FontWeight.w600,
          ),
          paymentSummaryData(),
          _couponeShowdata(),
        ],
      );
    }
  }

  Widget bookingInfoData() {
    if (profileProvider.detailsLoading) {
      return meetingdetailsShimmer();
    } else {
      if (profileProvider.meetingDetailsModel.status == 200 &&
          (profileProvider.meetingDetailsModel.result?.length ?? 0) > 0) {
        final meetingListData = profileProvider.meetingDetailsModel.result?[0];
        return Container(
          width: MediaQuery.sizeOf(context).width,
          padding: EdgeInsets.fromLTRB(16, 10, 16, 10),
          decoration: BoxDecoration(
              color: white,
              borderRadius: BorderRadius.circular(12),
              boxShadow: [
                BoxShadow(
                    blurRadius: 11,
                    blurStyle: BlurStyle.outer,
                    offset: Offset(0, 3),
                    color: transparent.withValues(alpha: 0.08),
                    spreadRadius: 0)
              ]),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 10,
            children: [
              Row(
                spacing: 20,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                    padding: EdgeInsets.all(4),
                    decoration: BoxDecoration(
                        shape: BoxShape.circle,
                        border: Border.all(
                            width: 1,
                            color: colorPrimaryDark,
                            style: BorderStyle.solid)),
                    child: MyNetworkImage(
                        radius: 50,
                        imgHeight: 80,
                        imgWidth: 80,
                        imageUrl: meetingListData?.lecturerImage ?? "",
                        fit: BoxFit.fill),
                  ),
                  Expanded(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      spacing: 4,
                      children: [
                        MyText(
                          text: meetingListData?.lecturerName ?? "",
                          multilanguage: false,
                          color: black,
                          maxline: 1,
                          fontsizeNormal: Dimens.textTitle,
                          fontsizeWeb: Dimens.textMedium,
                          fontwaight: FontWeight.w600,
                        ),
                        Row(
                          spacing: 2,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            MyText(
                              text: Locales.string(context, "topic"),
                              multilanguage: false,
                              color: black,
                              maxline: 1,
                              fontsizeNormal: Dimens.textMedium,
                              fontsizeWeb: Dimens.textMedium,
                              fontwaight: FontWeight.w400,
                            ),
                            Expanded(
                              child: MyText(
                                text: meetingListData?.title ?? "",
                                multilanguage: false,
                                color: gray,
                                maxline: 1,
                                fontsizeNormal: Dimens.textMedium,
                                fontsizeWeb: Dimens.textMedium,
                                fontwaight: FontWeight.w400,
                              ),
                            ),
                          ],
                        ),
                      ],
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.fromLTRB(10, 6, 10, 6),
                    decoration: BoxDecoration(
                        color: red, borderRadius: BorderRadius.circular(8)),
                    child: MyText(
                      text: "paid",
                      multilanguage: true,
                      color: white,
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                    ),
                  )
                ],
              ),
              Container(
                width: MediaQuery.sizeOf(context).width,
                padding: EdgeInsets.fromLTRB(10, 6, 10, 6),
                decoration: BoxDecoration(
                    color: colorPrimary.withValues(alpha: 0.4),
                    borderRadius: BorderRadius.circular(8)),
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  mainAxisAlignment: MainAxisAlignment.start,
                  mainAxisSize: MainAxisSize.min,
                  spacing: 10,
                  children: [
                    Icon(
                      Icons.watch_later,
                      size: 20,
                      color: colorPrimaryDark,
                    ),
                    Flexible(
                      fit: FlexFit.loose,
                      child: MyText(
                        text: profileProvider.weekDayName ?? "",
                        multilanguage: false,
                        color: black,
                        fontsizeNormal: Dimens.textMedium,
                        fontsizeWeb: Dimens.textMedium,
                        fontwaight: FontWeight.w600,
                      ),
                    ),
                    Flexible(
                      fit: FlexFit.loose,
                      child: MyText(
                        text: DateFormat("yyyy-MM-dd")
                            .format(profileProvider.selectedValue),
                        multilanguage: false,
                        color: black,
                        fontstyle: FontStyle.normal,
                        fontsizeNormal: Dimens.textMedium,
                        fontsizeWeb: Dimens.textMedium,
                        fontwaight: FontWeight.w400,
                      ),
                    ),
                    Flexible(
                      fit: FlexFit.tight,
                      child: MyText(
                        text: Utils.formateTime(
                            staTime: profileProvider.meetingScheduledStartTime,
                            enTime: profileProvider.meetingScheduledEndTime),
                        multilanguage: false,
                        color: black,
                        maxline: 1,
                        fontstyle: FontStyle.normal,
                        fontsizeNormal: Dimens.textMedium,
                        fontsizeWeb: Dimens.textMedium,
                        fontwaight: FontWeight.w400,
                      ),
                    ),
                  ],
                ),
              )
            ],
          ),
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }

  Widget meetingdetailsShimmer() {
    return Container(
      width: MediaQuery.sizeOf(context).width,
      padding: EdgeInsets.fromLTRB(16, 10, 16, 10),
      decoration: BoxDecoration(
          color: white,
          borderRadius: BorderRadius.circular(12),
          boxShadow: [
            BoxShadow(
                blurRadius: 11,
                blurStyle: BlurStyle.outer,
                offset: Offset(0, 3),
                color: transparent.withValues(alpha: 0.08),
                spreadRadius: 0)
          ]),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 10,
        children: [
          Row(
            spacing: 20,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Container(
                  padding: EdgeInsets.all(4),
                  decoration: BoxDecoration(
                      shape: BoxShape.circle,
                      border: Border.all(
                          width: 1,
                          color: colorPrimaryDark,
                          style: BorderStyle.solid)),
                  child: CustomWidget.circular(height: 80, width: 80)),
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  spacing: 4,
                  children: [
                    CustomWidget.roundcorner(height: 16, width: 150),
                    CustomWidget.roundcorner(height: 14, width: 130),
                    CustomWidget.roundcorner(height: 14, width: 130),
                  ],
                ),
              ),
              Container(
                padding: EdgeInsets.fromLTRB(10, 6, 10, 6),
                decoration: BoxDecoration(
                    color: red, borderRadius: BorderRadius.circular(8)),
                child: CustomWidget.roundcorner(height: 16, width: 60),
              )
            ],
          ),
          Container(
            width: MediaQuery.sizeOf(context).width,
            padding: EdgeInsets.fromLTRB(10, 6, 10, 6),
            decoration: BoxDecoration(
                color: colorPrimary.withValues(alpha: 0.4),
                borderRadius: BorderRadius.circular(8)),
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              mainAxisAlignment: MainAxisAlignment.start,
              spacing: 10,
              children: [
                CustomWidget.circular(height: 16, width: 16),
                Expanded(
                    child: CustomWidget.roundcorner(height: 16, width: 150)),
                Expanded(
                    child: CustomWidget.roundcorner(height: 16, width: 150)),
              ],
            ),
          )
        ],
      ),
    );
  } /* coupone apply code ui show or not */

  Widget _couponeShowdata() {
    return InkWell(
      onTap: () async {
        couponShowBottomSheet();

        await getCouponApi(0);
      },
      child: Container(
        padding: EdgeInsets.fromLTRB(15, 10, 15, 10),
        decoration: BoxDecoration(
            color: white,
            borderRadius: BorderRadius.circular(12),
            border: Border.all(
                width: 1,
                color: gray.withValues(alpha: 0.3),
                style: BorderStyle.solid)),
        child: Row(
          spacing: 10,
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            Icon(Icons.discount, size: 20, color: colorPrimary),
            Expanded(
              child: MyText(
                text: ((profileProvider.promocodeName ?? "").isEmpty)
                    ? Locales.string(context, "add_coupon")
                    : profileProvider.promocodeName ?? "",
                multilanguage: false,
                maxline: 1,
                fontsizeNormal: Dimens.textBig,
                color: black,
                fontwaight: FontWeight.w500,
              ),
            ),
            (profileProvider.promocodeName ?? "").isEmpty
                ? SizedBox.shrink()
                : InkWell(
                    splashColor: transparent,
                    focusColor: transparent,
                    hoverColor: transparent,
                    highlightColor: transparent,
                    onTap: () async {
                      await profileProvider.getRemoveCoupone(
                          profileProvider.priceMeeting ?? "0");

                      if (profileProvider.applyCouponModel.status == 200) {
                        profileProvider.discountPrice = profileProvider
                            .applyCouponModel.result?[0].discountAmount
                            .toString();
                        profileProvider.totalPrice = profileProvider
                            .applyCouponModel.result?[0].price
                            .toString();
                        profileProvider.promocodeName = "";
                        profileProvider.promocodeId = "";
                      } else {
                        if (!mounted) return;

                        Utils.showSnackbar(
                            context,
                            "fail",
                            profileProvider.applyCouponModel.message ?? "",
                            false);
                      }
                    },
                    child: Container(
                      height: 24,
                      width: 24,
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                          color: gray.withValues(alpha: 0.3),
                          shape: BoxShape.circle),
                      child: Icon(
                        FontAwesomeIcons.xmark,
                        size: 20,
                        color: black,
                      ),
                    ),
                  ),
            Container(
              height: 24,
              width: 24,
              alignment: Alignment.center,
              decoration: BoxDecoration(
                  color: gray.withValues(alpha: 0.3), shape: BoxShape.circle),
              child: Icon(
                Icons.keyboard_arrow_right,
                size: 20,
                color: black,
              ),
            ),
          ],
        ),
      ),
    );
  }
  /* PaymentSummary Data */

  Widget paymentSummaryData() {
    return Container(
      width: MediaQuery.sizeOf(context).width,
      padding: const EdgeInsets.fromLTRB(15, 15, 25, 15),
      decoration: BoxDecoration(
          color: white,
          borderRadius: BorderRadius.circular(12),
          border: Border.all(
              width: 1,
              color: gray.withValues(alpha: 0.3),
              style: BorderStyle.solid)),
      child: Column(
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              MyText(
                text: 'item_total',
                multilanguage: true,
                maxline: 1,
                fontsizeNormal: Dimens.textTitle,
                color: gray,
                fontwaight: FontWeight.w500,
              ),
              MyText(
                text:
                    '${Constant.currencyCode} ${profileProvider.priceMeeting ?? "0"}',
                multilanguage: false,
                maxline: 1,
                fontsizeNormal: Dimens.textTitle,
                color: black,
                fontwaight: FontWeight.w500,
              ),
            ],
          ),
          const SizedBox(height: 10),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              MyText(
                text: 'taxes_fee',
                decoration: TextDecoration.underline,
                decorationStyle: TextDecorationStyle.dotted,
                decorationColor: black,
                multilanguage: true,
                maxline: 1,
                fontsizeNormal: Dimens.textTitle,
                color: gray,
                fontwaight: FontWeight.w500,
              ),
              MyText(
                text:
                    '${Constant.currencyCode} ${profileProvider.discountPrice ?? 0}',
                multilanguage: false,
                maxline: 1,
                fontsizeNormal: Dimens.textTitle,
                color: black,
                fontwaight: FontWeight.w500,
              ),
            ],
          ),
          Divider(
            thickness: 1,
            height: 20,
            color: gray.withValues(alpha: .8),
          ),
          const SizedBox(height: 10),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              MyText(
                text: 'total_price',
                multilanguage: true,
                maxline: 1,
                fontsizeNormal: Dimens.textTitle,
                color: gray,
                fontwaight: FontWeight.w500,
              ),
              MyText(
                text:
                    '${Constant.currencyCode} ${profileProvider.totalPrice ?? profileProvider.priceMeeting}',
                multilanguage: false,
                maxline: 1,
                fontsizeNormal: Dimens.textTitle,
                color: black,
                fontwaight: FontWeight.w500,
              ),
            ],
          ),
          const SizedBox(height: 10),
          _btnConfWidget()
        ],
      ),
    );
  }

  Widget _btnConfWidget() {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: () async {
        String? dateformatData =
            DateFormat("yyyy-MM-dd").format(profileProvider.selectedValue);
        String? totalPrice = (profileProvider.totalPrice ?? "").isNotEmpty
            ? profileProvider.totalPrice
            : profileProvider.priceMeeting ?? "";
        final result = await Navigator.of(context).push(
          PageRouteBuilder(
            pageBuilder: (context, animation, secondaryAnimation) => AllPayment(
              payType: "book_session",
              mettingId: profileProvider.meetingId ?? "",
              date: dateformatData,
              imageFileA: profileProvider.imageBytes,
              mettingScheduleId: profileProvider.meetingScheduledId,
              chapterId: profileProvider.chapterId ?? "",
              price: totalPrice,
              details: detsilsController.text,
              promoCodeId: profileProvider.promocodeId ?? "",
              fileName: profileProvider.fileName ?? "",
              mediaType: profileProvider.mediaType ?? "",
            ),
            transitionsBuilder:
                (context, animation, secondaryAnimation, child) {
              const begin = Offset(1.0, 0.0);
              const end = Offset.zero;
              const curve = Curves.ease;

              var tween =
                  Tween(begin: begin, end: end).chain(CurveTween(curve: curve));

              return SlideTransition(
                position: animation.drive(tween),
                child: child,
              );
            },
          ),
        );
        if (result != null) {
          showType = result['isType'];
          profileProvider.providerNotifi();
        }
      },
      child: Container(
        padding: EdgeInsets.fromLTRB(20, 8, 20, 8),
        alignment: Alignment.center,
        width: MediaQuery.sizeOf(context).width,
        decoration: BoxDecoration(
            border: Border.all(
                width: 1, color: transparent, style: BorderStyle.solid),
            color: colorPrimaryDark,
            borderRadius: BorderRadius.circular(36)),
        child: Icon(
          Icons.arrow_forward,
          size: 20,
          color: white,
        ),
      ),
    );
  }

/* Coupone list show bottom sheet */

  void couponShowBottomSheet() {
    showModalBottomSheet(
      context: context,
      backgroundColor: white,
      showDragHandle: true,
      isDismissible: true,
      isScrollControlled: true,
      enableDrag: true,
      builder: (context) {
        return Consumer<CouponProvider>(
            builder: (context, meetingProvider, child) {
          return SizedBox(
            height: 600,
            width: MediaQuery.sizeOf(context).width,
            child: _buildCouponeData(),
          );
        });
      },
    );
  }

  Widget _buildCouponeData() {
    if (couponProvider.loading) {
      return shimmer();
    } else {
      if (couponProvider.cartList != null &&
          (couponProvider.cartList?.length ?? 0) > 0) {
        return SingleChildScrollView(
          controller: _scrollCouponController,
          padding: const EdgeInsets.fromLTRB(15, 10, 15, 10),
          clipBehavior: Clip.antiAliasWithSaveLayer,
          physics: const AlwaysScrollableScrollPhysics(),
          child: Column(
            children: [
              couponData(),
              const SizedBox(height: 10),
              if (couponProvider.loadMore)
                Utils.pageLoader()
              else
                const SizedBox.shrink(),
              const SizedBox(height: 20),
            ],
          ),
        );
      } else {
        return const NoData();
      }
    }
  }

  Widget couponData() {
    return ResponsiveGridList(
        minItemWidth: 300,
        verticalGridMargin: 0,
        horizontalGridMargin: 0,
        verticalGridSpacing: 10,
        horizontalGridSpacing: 10,
        minItemsPerRow: 1,
        maxItemsPerRow: 2,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true, physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          couponProvider.cartList?.length ?? 0,
          (index) {
            return InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              onTap: () {
                applyApi(
                    index,
                    couponProvider.cartList?[index].id.toString() ?? "",
                    profileProvider.priceMeeting ?? "",
                    couponProvider.cartList?[index].name.toString() ?? "");

                printLog("this is api call");
              },
              child: Card(
                color: white,
                child: Padding(
                  padding: const EdgeInsets.fromLTRB(14, 10, 14, 10),
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    spacing: 20,
                    children: [
                      MyNetworkImage(
                          imageUrl: couponProvider.cartList?[index].image
                                  .toString() ??
                              "",
                          imgHeight: 60,
                          imgWidth: 60,
                          radius: 10,
                          fit: BoxFit.contain),
                      Expanded(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            MyText(
                              text: couponProvider.cartList?[index].name
                                      .toString() ??
                                  "",
                              maxline: 2,
                              multilanguage: false,
                              fontsizeNormal: Dimens.textMedium,
                              color: black,
                              fontwaight: FontWeight.w500,
                            ),
                            MyText(
                              text:
                                  "${Locales.string(context, "use_code")} : ${couponProvider.cartList?[index].promoCode.toString() ?? ""}",
                              maxline: 2,
                              multilanguage: false,
                              fontsizeNormal: Dimens.textMedium,
                              color: black,
                              fontwaight: FontWeight.w500,
                            ),
                            const SizedBox(height: 5),
                            MyText(
                              text: (couponProvider.cartList?[index].type
                                              .toString() ??
                                          "") ==
                                      "1"
                                  ? '${Constant.currencyCode} ${couponProvider.cartList?[index].discountAmount ?? ""}'
                                  : "% ${couponProvider.cartList?[index].discountAmount.toString() ?? ""}",
                              maxline: 2,
                              multilanguage: false,
                              fontsizeNormal: Dimens.textMedium,
                              color: colorPrimaryDark,
                              fontwaight: FontWeight.w400,
                            ),
                          ],
                        ),
                      ),
                      InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        onTap: () {
                          applyApi(
                              index,
                              couponProvider.cartList?[index].id.toString() ??
                                  "",
                              profileProvider.priceMeeting ?? "",
                              couponProvider.cartList?[index].name.toString() ??
                                  "");

                          printLog("this is api call");
                        },
                        child: AnimatedContainer(
                          duration: Duration(milliseconds: 600),
                          padding: const EdgeInsets.fromLTRB(10, 4, 10, 4),
                          decoration: BoxDecoration(
                              color: white,
                              borderRadius: BorderRadius.circular(6),
                              border: Border.all(
                                  width: 1,
                                  color: gray,
                                  style: BorderStyle.solid)),
                          child: couponProvider.applyLoded &&
                                  couponProvider.index == index
                              ? SizedBox(
                                  height: 20,
                                  width: 20,
                                  child: CircularProgressIndicator(
                                    color: colorPrimaryDark,
                                  ),
                                )
                              : MyText(
                                  text: 'apply',
                                  maxline: 2,
                                  multilanguage: true,
                                  fontsizeNormal: Dimens.textSmall,
                                  color: black,
                                  fontwaight: FontWeight.w400,
                                ),
                        ),
                      )
                    ],
                  ),
                ),
              ),
            );
          },
        ));
  }

  Widget shimmerCoupon() {
    return ResponsiveGridList(
        minItemWidth: 300,
        verticalGridMargin: 10,
        horizontalGridMargin: 10,
        verticalGridSpacing: 10,
        horizontalGridSpacing: 10,
        minItemsPerRow: 1,
        maxItemsPerRow: 2,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true, physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          10,
          (index) {
            return const Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                CustomWidget.circular(height: 20, width: 20),
                SizedBox(width: 20),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      CustomWidget.roundcorner(height: 22, width: 100),
                      SizedBox(height: 3),
                      CustomWidget.roundcorner(height: 16, width: 200),
                      SizedBox(height: 3),
                      CustomWidget.roundcorner(height: 18, width: 100),
                    ],
                  ),
                )
              ],
            );
          },
        ));
  }

  /* Apply coupen Api */
  Future<void> applyApi(
      dynamic index, promocodeId, totalPrice, promocodeName) async {
    couponProvider.setApplyLoding(true);

    await couponProvider.getApplyCoupon(index, promocodeId, totalPrice);
    if (!mounted) return;
    if (couponProvider.applyCouponModel.status == 200 &&
        (couponProvider.applyCouponModel.result?.length ?? 0) > 0) {
      couponProvider.setApplyLoding(false);

      Navigator.of(context).pop();

      profileProvider.setPrice(
          disPri: couponProvider.applyCouponModel.result?[0].discountAmount
                  .toString() ??
              "",
          value: couponProvider.applyCouponModel.result?[0].totalPrice
                  .toString() ??
              "",
          proId: promocodeId,
          proName: promocodeName,
          totPrice:
              couponProvider.applyCouponModel.result?[0].price.toString() ??
                  "");
    } else {
      couponProvider.setApplyLoding(false);

      printLog(couponProvider.applyCouponModel.message ?? "");
    }
  }

  /* Appointment Meetting success data  */
  Widget successAppoinment() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.center,
      spacing: 10,
      children: [
        Container(
          height: 88,
          width: 88,
          decoration: BoxDecoration(
              shape: BoxShape.circle,
              color: green.withValues(alpha: 0.5),
              border:
                  Border.all(width: 3, color: green, style: BorderStyle.solid)),
          child: Icon(
            Icons.check,
            size: 50,
            color: green,
          ),
        ),
        MyText(
          text: 'su_title',
          maxline: 2,
          multilanguage: true,
          fontsizeNormal: Dimens.textTitle,
          color: black,
          fontwaight: FontWeight.w600,
        ),
        MyText(
          text: 'su_desc',
          maxline: 2,
          multilanguage: true,
          fontsizeNormal: Dimens.textMedium,
          color: gray,
          fontwaight: FontWeight.w400,
        ),
        Row(
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.center,
          spacing: 20,
          children: [
            InkWell(
              onTap: () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        WebProfile(),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
                profileProvider.setWebSelect("3", "tutor_meetings");

/* Tutor meetiing data show */

                meetingProvider.setTab("1");
                meetingProvider.clearContent();
                meetingProvider.setLoading(false);

                /* Profile pages  */
                profileProvider.setAppoinment(index: "0", name: "", ids: "");
                profileProvider.setConfAppoinment(
                    index: "0",
                    name: "check_out",
                    ids: profileProvider.meetingId ?? "");

                meetingProvider.getCourseName();
                meetingProvider.getMeeting("0", 1);

                showType = "0";
                profileProvider.providerNotifi();
              },
              child: Container(
                height: 42,
                width: 200,
                decoration: BoxDecoration(
                    color: white,
                    border: Border.all(
                        width: 1,
                        color: colorPrimaryDark,
                        style: BorderStyle.solid)),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  spacing: 16,
                  children: [
                    Icon(
                      Icons.layers_outlined,
                      size: 20,
                      color: colorPrimaryDark,
                    ),
                    Flexible(
                      fit: FlexFit.loose,
                      child: MyText(
                        text: 'go_to_dashboard',
                        maxline: 2,
                        multilanguage: true,
                        fontsizeNormal: Dimens.textMedium,
                        color: colorPrimaryDark,
                        fontwaight: FontWeight.w400,
                      ),
                    ),
                  ],
                ),
              ),
            ),
            InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              onTap: () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        WebProfile(),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
                profileProvider.setWebSelect("3", "tutor_meetings");
                profileProvider.setAppoinment(
                    index: "1", name: "book_appointment", ids: "");
                profileProvider.setConfAppoinment(
                    index: "1",
                    name: "check_out",
                    ids: profileProvider.meetingId ?? "");

/* Tutor meetiing data show */
                meetingProvider.clearProvider();
                meetingProvider.setLoading(false);
                meetingProvider.setTab("2");
                meetingProvider.getMeetingStatus();
                meetingProvider.getUseMeeting("1", 1);

                showType = "0";
                profileProvider.providerNotifi();
              },
              child: Container(
                height: 42,
                width: 200,
                decoration: BoxDecoration(
                  color: colorPrimaryDark,
                ),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  spacing: 16,
                  children: [
                    Flexible(
                      fit: FlexFit.loose,
                      child: MyText(
                        text: 'view_meeting',
                        maxline: 2,
                        multilanguage: true,
                        fontsizeNormal: Dimens.textMedium,
                        color: white,
                        fontwaight: FontWeight.w400,
                      ),
                    ),
                    Icon(
                      Icons.arrow_forward,
                      size: 20,
                      color: white,
                    ),
                  ],
                ),
              ),
            ),
          ],
        ),
      ],
    );
  }

/* Logout and delete Account */
  void _logoutDeleteDialog({required String? title, required String subtitle}) {
    showDialog(
      context: context,
      builder: (context) {
        return AlertDialog(
          backgroundColor: white,
          title: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Container(
                height: 50,
                width: 50,
                padding: const EdgeInsets.all(8),
                decoration: BoxDecoration(
                    color: colorPrimaryDark.withValues(alpha: .2),
                    shape: BoxShape.circle),
                child: Container(
                  height: 25,
                  width: 25,
                  padding: const EdgeInsets.all(5),
                  decoration: BoxDecoration(
                      color: colorPrimaryDark.withValues(alpha: 0.3),
                      shape: BoxShape.circle),
                  child: const Icon(FontAwesomeIcons.trash,
                      size: 20, color: colorPrimaryDark),
                ),
              ),
              InkWell(
                  splashColor: transparent,
                  focusColor: transparent,
                  hoverColor: transparent,
                  onTap: () {
                    Navigator.of(context).pop();
                  },
                  child:
                      const Icon(FontAwesomeIcons.xmark, size: 20, color: gray))
            ],
          ),
          content: Wrap(
            crossAxisAlignment: WrapCrossAlignment.start,
            children: [
              MyText(
                color: black,
                text: title ?? "",
                multilanguage: true,
                textalign: TextAlign.start,
                fontsizeNormal: Dimens.textBig,
                fontwaight: FontWeight.w600,
                maxline: 1,
                fontstyle: FontStyle.normal,
              ),
              const SizedBox(height: 3),
              MyText(
                color: black,
                text: subtitle,
                multilanguage: true,
                textalign: TextAlign.start,
                fontsizeNormal: Dimens.textMedium,
                fontwaight: FontWeight.w400,
                maxline: 2,
                fontstyle: FontStyle.normal,
              )
            ],
          ),
          actions: [
            Column(
              children: [
                InkWell(
                  splashColor: transparent,
                  hoverColor: transparent,
                  focusColor: transparent,
                  onTap: () async {
                    final generalProvider =
                        Provider.of<GeneralProvider>(context, listen: false);
                    await _auth.signOut();
                    await GoogleSignIn.instance.disconnect();
                    Utils.setUserId();
                    Constant.userID = null;
                    Constant.userImage = null;
                    Constant.isSearch = "0";
                    Constant.isBuy = null;
                    printLog("UserIds====>${Constant.userID}");
                    /* Clear Local Data */
                    profileProvider.clearProvider();
                    generalProvider.clearProvider();

                    if (!context.mounted) return;
                    /* Clear Local Data End */
                    if (Navigator.canPop(context)) {
                      Navigator.pop(context);
                    }
                    Navigator.of(context).pushReplacement(
                      PageRouteBuilder(
                        pageBuilder: (context, animation, secondaryAnimation) =>
                            const WebLogin(),
                        transitionsBuilder:
                            (context, animation, secondaryAnimation, child) {
                          const begin = Offset(1.0, 0.0);
                          const end = Offset.zero;
                          const curve = Curves.ease;

                          var tween = Tween(begin: begin, end: end)
                              .chain(CurveTween(curve: curve));

                          return SlideTransition(
                            position: animation.drive(tween),
                            child: child,
                          );
                        },
                      ),
                    );
                  },
                  child: Container(
                    constraints: const BoxConstraints(
                      minWidth: 75,
                    ),
                    height: 50,
                    padding: const EdgeInsets.only(left: 10, right: 10),
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                      color: colorPrimaryDark,
                      border: Border.all(
                        color: colorPrimaryDark,
                        width: 1,
                      ),
                      borderRadius: BorderRadius.circular(8),
                      shape: BoxShape.rectangle,
                    ),
                    child: MyText(
                      color: white,
                      text: "confirm",
                      textalign: TextAlign.center,
                      fontsizeNormal: Dimens.textTitle,
                      multilanguage: true,
                      maxline: 1,
                      fontwaight: FontWeight.w600,
                      fontstyle: FontStyle.normal,
                    ),
                  ),
                ),
                const SizedBox(height: 20),
                InkWell(
                  onTap: () {
                    if (Navigator.canPop(context)) {
                      Navigator.pop(context);
                    }
                  },
                  child: Container(
                    constraints: const BoxConstraints(
                      minWidth: 75,
                    ),
                    height: 50,
                    padding: const EdgeInsets.only(left: 10, right: 10),
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                      border: Border.all(
                        color: gray,
                        width: 1,
                      ),
                      borderRadius: BorderRadius.circular(8),
                    ),
                    child: MyText(
                      color: colorPrimaryDark,
                      text: "cancel",
                      multilanguage: true,
                      textalign: TextAlign.center,
                      fontsizeNormal: Dimens.textTitle,
                      maxline: 1,
                      fontwaight: FontWeight.w600,
                      fontstyle: FontStyle.normal,
                    ),
                  ),
                ),
              ],
            ),
          ],
        );
      },
    ).then((value) async {
      if (!mounted) return;
      // final generalProvider =
      //     Provider.of<GeneralProvider>(context, listen: false);
      if (!mounted) return;
      // Notify UI about the changes
      profileProvider.getprofile(context);
      profileProvider.providerNotifi();
    });
  }
/* My Course Data stated */

  Widget buildPage() {
    if (profileProvider.loading && !profileProvider.loadMore) {
      return buildCourseShimmer();
    } else {
      if (profileProvider.mycourseList != null &&
          (profileProvider.mycourseList?.length ?? 0) > 0) {
        return Column(
          children: [
            mycourselist(),
            if (profileProvider.loadMore)
              Container(
                height: 50,
                margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                child: Utils.pageLoader(),
              )
            else
              const SizedBox.shrink(),
          ],
        );
      } else {
        return const NoData();
      }
    }
  }

  Widget mycourselist() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 200,
        minItemsPerRow: 1,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 6,
            height1200: 4,
            height800: 3,
            height400: 2),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          padding: EdgeInsets.zero,
          physics: const BouncingScrollPhysics(),
        ),
        children: List.generate(
          profileProvider.mycourseList?.length ?? 0,
          (index) {
            return InkWell(
              onTap: () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    transitionDuration: const Duration(milliseconds: 200),
                    pageBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation) {
                      return WebDetail(
                          courseId: profileProvider.mycourseList?[index].id
                                  .toString() ??
                              "");
                    },
                    transitionsBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation,
                        Widget child) {
                      return Align(
                        child: FadeTransition(
                          opacity: animation,
                          child: child,
                        ),
                      );
                    },
                  ),
                );
              },
              child: Column(
                spacing: 10,
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  MyNetworkImage(
                    radius: 20,
                    imgWidth: 285,
                    imgHeight: 160,
                    imageUrl: profileProvider.mycourseList?[index].thumbnailImg
                            .toString() ??
                        "",
                    fit: BoxFit.fill,
                  ),
                  MyText(
                      color: gray,
                      text: profileProvider.mycourseList?[index].title ?? "",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w500,
                      maxline: 1,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    spacing: 5,
                    children: [
                      MyText(
                          color: gray,
                          text: Utils.kmbGenerator(
                            profileProvider.mycourseList?[index].totalView ?? 0,
                          ),
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      MyText(
                          color: gray,
                          text: "students",
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          multilanguage: true,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      Container(
                        height: 5,
                        width: 5,
                        decoration:
                            BoxDecoration(color: gray, shape: BoxShape.circle),
                      ),
                    ],
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      MyRating(
                        size: 13,
                        rating: double.parse(profileProvider
                                .mycourseList?[index].avgRating
                                .toString() ??
                            ""),
                        spacing: 2,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text:
                              "${double.parse(profileProvider.mycourseList?[index].avgRating.toString() ?? "")}",
                          fontsizeNormal: Dimens.textBigSmall,
                          fontwaight: FontWeight.w600,
                          maxline: 2,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                ],
              ),
            );
          },
        ),
      ),
    );
  }

  Widget buildCourseShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 200,
        minItemsPerRow: 1,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 6,
            height1200: 4,
            height800: 3,
            height400: 2),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          padding: EdgeInsets.zero,
          physics: const BouncingScrollPhysics(),
        ),
        children: List.generate(
          10,
          (index) {
            return Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                CustomWidget.rectangular(width: 285, height: 160),
                SizedBox(width: 10),
                CustomWidget.rectangular(height: 14, width: 285),
                SizedBox(height: 8),
                CustomWidget.rectangular(height: 10, width: 160),
                SizedBox(height: 8),
                CustomWidget.rectangular(height: 10, width: 100),
              ],
            );
          },
        ),
      ),
    );
  }
}
