import 'package:prakah/utils/constant.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webregister.dart';
import 'package:prakah/webpages/webverifyotp.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:intl_phone_field/country_picker_dialog.dart';
import 'package:intl_phone_field/intl_phone_field.dart';

class WebMobileLogin extends StatefulWidget {
  const WebMobileLogin({super.key});

  @override
  State<WebMobileLogin> createState() => WebMobileLoginState();
}

class WebMobileLoginState extends State<WebMobileLogin> {
  TextEditingController numberController = TextEditingController();
  String mobilenumber = "", countrycode = "", countryname = "";

  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: white,
      body: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          MediaQuery.of(context).size.width > 800
              ? Expanded(
                  child: MyImage(
                  width: MediaQuery.of(context).size.width > 1200
                      ? MediaQuery.of(context).size.width * 0.5
                      : MediaQuery.of(context).size.width > 800
                          ? MediaQuery.of(context).size.width * 0.30
                          : MediaQuery.of(context).size.width,
                  height: MediaQuery.sizeOf(context).height,
                  imagePath: 'web_login_bg.png',
                  fit: BoxFit.cover,
                ))
              : SizedBox.shrink(),
          Expanded(
            child: Container(
              width: MediaQuery.sizeOf(context).width,
              height: MediaQuery.sizeOf(context).height,
              alignment: Alignment.center,
              padding: MediaQuery.of(context).size.width > 1200
                  ? EdgeInsets.fromLTRB(100, 10, 100, 40)
                  : MediaQuery.of(context).size.width > 600
                      ? EdgeInsets.fromLTRB(40, 10, 40, 40)
                      : EdgeInsets.fromLTRB(20, 10, 20, 40),
              decoration: const BoxDecoration(color: white),
              child: SingleChildScrollView(
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.start,
                  children: [
                    Align(
                      alignment: Alignment.topRight,
                      child: InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        highlightColor: transparent,
                        onTap: () {
                          if (Navigator.canPop(context)) {
                            Navigator.pop(context);
                          }
                        },
                        child: Container(
                          padding: EdgeInsets.all(4),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle, color: colorPrimaryDark),
                          child: Icon(
                            Icons.close,
                            size: 20,
                            color: white,
                          ),
                        ),
                      ),
                    ),
                    SizedBox(height: 80),
                    Center(
                        child: MyImage(
                      width: 150,
                      height: 150,
                      imagePath: 'appiconweb.png',
                      fit: BoxFit.contain,
                      isAppicon: true,
                    )),
                    const SizedBox(height: 15),
                    MyText(
                        text: "enteryourmobile",
                        fontsizeNormal: Dimens.textExtraBig,
                        fontsizeWeb: Dimens.textExtraBig,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        multilanguage: true,
                        fontstyle: FontStyle.normal),
                    const SizedBox(height: 15),
                    MyText(
                        text: "youwillreceive6digitcode",
                        fontsizeNormal: Dimens.textTitle,
                        fontsizeWeb: Dimens.textTitle,
                        fontwaight: FontWeight.w400,
                        maxline: 2,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal,
                        multilanguage: true),
                    const SizedBox(height: 30),
                    numberTextField(),
                    const SizedBox(height: 50),
                    sendOTP(),
                  ],
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget numberTextField() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      spacing: 10,
      children: [
        MyText(
            color: black,
            text: "mobile_number",
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            multilanguage: true,
            fontstyle: FontStyle.normal),
        IntlPhoneField(
          disableLengthCheck: true,
          textAlignVertical: TextAlignVertical.center,
          cursorColor: Theme.of(context).colorScheme.surface,
          autovalidateMode: AutovalidateMode.disabled,
          controller: numberController,
          style: GoogleFonts.lato(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: Theme.of(context).colorScheme.surface,
              letterSpacing: 1.0,
              fontWeight: FontWeight.w600),
          showCountryFlag: true,
          showDropdownIcon: false,
          initialCountryCode: Constant.initialCountryCode,
          pickerDialogStyle: PickerDialogStyle(
              backgroundColor: white,
              countryNameStyle: GoogleFonts.lato(color: gray),
              countryCodeStyle: GoogleFonts.lato(color: gray)),
          dropdownTextStyle: GoogleFonts.lato(
              fontSize: Dimens.textSmall,
              fontStyle: FontStyle.normal,
              letterSpacing: 1.0,
              color: gray.withValues(alpha: 0.70),
              fontWeight: FontWeight.w400),
          keyboardType: TextInputType.number,
          textInputAction: TextInputAction.next,
          decoration: InputDecoration(
            hintStyle: GoogleFonts.inter(
                fontSize: Dimens.textSmall,
                fontStyle: FontStyle.normal,
                letterSpacing: 1.0,
                color: gray.withValues(alpha: 0.50),
                fontWeight: FontWeight.w400),
            hintText: "245786534",
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
          ),
          onChanged: (phone) {
            mobilenumber = phone.completeNumber;
            countryname = phone.countryISOCode;
            countrycode = phone.countryCode;
          },
          onCountryChanged: (country) {
            countryname = country.code.replaceAll('+', '');
            countrycode = "+${country.dialCode.toString()}";
          },
        ),
      ],
    );
  }

  Widget sendOTP() {
    return InkWell(
      onTap: () {
        if (numberController.text.isEmpty) {
          Utils().showToast("Please Enter Your Mobile Number");
        } else {
          Navigator.of(context).push(
            PageRouteBuilder(
              transitionDuration: const Duration(milliseconds: 200),
              pageBuilder: (BuildContext context, Animation<double> animation,
                  Animation<double> secondaryAnimation) {
                return WebVerifyOtp(
                  fullnumber: mobilenumber,
                  countrycode: countrycode,
                  countryName: countryname,
                  number: numberController.text,
                );
              },
              transitionsBuilder: (BuildContext context,
                  Animation<double> animation,
                  Animation<double> secondaryAnimation,
                  Widget child) {
                return Align(
                  child: FadeTransition(
                    opacity: animation,
                    child: child,
                  ),
                );
              },
            ),
          );
        }
      },
      child: Container(
        width: MediaQuery.of(context).size.width,
        height: 45,
        alignment: Alignment.center,
        decoration: BoxDecoration(
          color: colorPrimary,
          borderRadius: BorderRadius.circular(10),
        ),
        child: MyText(
            color: white,
            text: "sendotp",
            fontsizeNormal: 14,
            fontwaight: FontWeight.w500,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            fontstyle: FontStyle.normal,
            multilanguage: true),
      ),
    );
  }

  Widget registerText() {
    return InkWell(
      onTap: () {
        Navigator.of(context).push(
          PageRouteBuilder(
            transitionDuration: const Duration(milliseconds: 200),
            pageBuilder: (BuildContext context, Animation<double> animation,
                Animation<double> secondaryAnimation) {
              return const WebRegister();
            },
            transitionsBuilder: (BuildContext context,
                Animation<double> animation,
                Animation<double> secondaryAnimation,
                Widget child) {
              return Align(
                child: FadeTransition(
                  opacity: animation,
                  child: child,
                ),
              );
            },
          ),
        );
      },
      child: Row(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          MyText(
              color: gray,
              text: "donthaveanaccount",
              fontsizeNormal: Dimens.textMedium,
              fontwaight: FontWeight.w400,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              fontstyle: FontStyle.normal,
              multilanguage: true),
          const SizedBox(width: 5),
          MyText(
              color: colorPrimary,
              text: "register",
              fontsizeNormal: Dimens.textMedium,
              fontwaight: FontWeight.w500,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              fontstyle: FontStyle.normal,
              multilanguage: true),
        ],
      ),
    );
  }
}
