import 'dart:io';
import 'package:cloud_firestore/cloud_firestore.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/firebaseconstant.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webforgetpassword.dart';
import 'package:prakah/webpages/webhome.dart';
import 'package:prakah/webpages/webmobilelogin.dart';
import 'package:prakah/webpages/webregister.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:firebase_auth/firebase_auth.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:google_sign_in/google_sign_in.dart';
import 'package:provider/provider.dart';

class WebLogin extends StatefulWidget {
  const WebLogin({super.key});

  @override
  State<WebLogin> createState() => WebLoginState();
}

class WebLoginState extends State<WebLogin> {
  late GeneralProvider generalProvider;
  TextEditingController emailController = TextEditingController();
  TextEditingController passwordController = TextEditingController();
  bool obscureTextPassword = true;
  final FirebaseAuth auth = FirebaseAuth.instance;
  String email = "", password = "";
  String? userName;
  File? mProfileImg;
  String? strDeviceType, strDeviceToken;
  final GoogleSignIn googleSignIn = GoogleSignIn.instance;
  bool initialized = false;

  @override
  initState() {
    super.initState();
    generalProvider = Provider.of<GeneralProvider>(context, listen: false);
    _getDeviceToken();
  }

  Future<void> _getDeviceToken() async {
    try {
      if (kIsWeb) {
        strDeviceType = "3";
        strDeviceToken = Constant.webToken;
      } else {
        if (Platform.isAndroid) {
          strDeviceType = "1";
        } else {
          strDeviceType = "2";
        }
        strDeviceToken = await FirebaseMessaging.instance.getToken();
      }
    } catch (e) {
      printLog("_getDeviceToken Exception ===> $e");
    }
  }

  @override
  void dispose() {
    generalProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: white,
      body: Row(
        children: [
          MediaQuery.of(context).size.width > 800
              ? Expanded(
                  child: MyImage(
                  width: MediaQuery.of(context).size.width > 1200
                      ? MediaQuery.of(context).size.width * 0.5
                      : MediaQuery.of(context).size.width > 800
                          ? MediaQuery.of(context).size.width * 0.30
                          : MediaQuery.of(context).size.width,
                  height: MediaQuery.sizeOf(context).height,
                  imagePath: 'web_login_bg.png',
                  fit: BoxFit.cover,
                ))
              : SizedBox.shrink(),
          Expanded(
            child: Container(
              width: MediaQuery.sizeOf(context).width,
              height: MediaQuery.sizeOf(context).height,
              alignment: Alignment.center,
              padding: MediaQuery.of(context).size.width > 1200
                  ? EdgeInsets.fromLTRB(100, 40, 100, 40)
                  : MediaQuery.of(context).size.width > 600
                      ? EdgeInsets.fromLTRB(40, 40, 40, 40)
                      : EdgeInsets.fromLTRB(20, 40, 20, 40),
              decoration: const BoxDecoration(color: white),
              child: SingleChildScrollView(
                child: Column(
                  children: [
                    InkWell(
                      splashColor: transparent,
                      focusColor: transparent,
                      hoverColor: transparent,
                      highlightColor: transparent,
                      onTap: () {
                        if (Navigator.canPop(context)) {
                          Navigator.pop(context);
                        }
                      },
                      child: Align(
                        alignment: Alignment.topRight,
                        child: Container(
                          padding: EdgeInsets.all(4),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle, color: colorPrimaryDark),
                          child: Icon(
                            Icons.close,
                            size: 20,
                            color: white,
                          ),
                        ),
                      ),
                    ),
                    SizedBox(height: 60),
                    Center(
                        child: MyImage(
                      width: 150,
                      height: 150,
                      imagePath: 'appiconweb.png',
                      fit: BoxFit.contain,
                      isAppicon: true,
                    )),
                    const SizedBox(height: 15),
                    MyText(
                        text: "login",
                        fontsizeWeb: Dimens.textExtraBig,
                        fontsizeNormal: Dimens.textExtraBig,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        multilanguage: true,
                        fontstyle: FontStyle.normal),
                    const SizedBox(height: 20),
                    MyText(
                        text: "login_web_des",
                        fontsizeWeb: Dimens.textBig,
                        fontsizeNormal: Dimens.textExtraBig,
                        fontwaight: FontWeight.w400,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        multilanguage: true,
                        fontstyle: FontStyle.normal),
                    const SizedBox(height: 20),
                    emailAndpassword(),
                    const SizedBox(height: 10),
                    _rememberData(),
                    const SizedBox(height: 30),
                    loginBtn(),
                    const SizedBox(height: 20),
                    orSection(),
                    const SizedBox(height: 20),
                    loginWithSocial(),
                    const SizedBox(height: 25),
                    goingRegister(),
                    const SizedBox(height: 25),
                  ],
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget emailAndpassword() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      spacing: 10,
      children: [
        /* Email */
        MyText(
            color: black,
            text: "email",
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            multilanguage: true,
            fontstyle: FontStyle.normal),
        TextFormField(
          obscureText: false,
          keyboardType: TextInputType.emailAddress,
          controller: emailController,
          textInputAction: TextInputAction.next,
          cursorColor: black,
          style: GoogleFonts.lato(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: black,
              fontWeight: FontWeight.w600),
          decoration: InputDecoration(
            prefixIcon: Icon(
              Icons.mail,
              size: 20,
              color: gray,
            ),
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide: BorderSide(
                  width: 1, color: webTextFiled, style: BorderStyle.solid),
            ),
            hintText: "example@gmail.com",
            hintStyle: GoogleFonts.lato(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                color: gray.withValues(alpha: 0.50),
                fontWeight: FontWeight.w400),
          ),
        ),
        const SizedBox(height: 10),
        /* Password */
        MyText(
            color: black,
            text: "password",
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            multilanguage: true,
            fontstyle: FontStyle.normal),
        TextFormField(
          obscureText: obscureTextPassword,
          keyboardType: TextInputType.text,
          controller: passwordController,
          textInputAction: TextInputAction.done,
          cursorColor: black,
          style: GoogleFonts.lato(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: black,
              fontWeight: FontWeight.w600),
          decoration: InputDecoration(
            suffixIcon: InkWell(
              onTap: () {
                setState(() {
                  obscureTextPassword = !obscureTextPassword;
                });
              },
              child: Container(
                width: 25,
                height: 25,
                alignment: Alignment.center,
                child: Icon(
                  obscureTextPassword ? Icons.visibility : Icons.visibility_off,
                  color: gray,
                ),
              ),
            ),
            prefixIcon: Icon(
              Icons.lock,
              size: 20,
              color: gray,
            ),
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: gray.withValues(alpha: 0.50)),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: gray.withValues(alpha: 0.50)),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: gray.withValues(alpha: 0.50)),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(10)),
              borderSide:
                  BorderSide(width: 1, color: gray.withValues(alpha: 0.50)),
            ),
            hintText: "● ● ● ● ● ●",
            hintStyle: GoogleFonts.lato(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                color: gray.withValues(alpha: 0.50),
                fontWeight: FontWeight.w400),
          ),
        ),
      ],
    );
  }

  Widget _rememberData() {
    return Consumer<GeneralProvider>(
        builder: (context, generalprovider, child) {
      return Row(
        spacing: 20,
        crossAxisAlignment: CrossAxisAlignment.center,
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Flexible(
            fit: FlexFit.loose,
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              mainAxisAlignment: MainAxisAlignment.start,
              spacing: 5,
              children: [
                Checkbox(
                  activeColor: colorPrimary,
                  autofocus: true,
                  checkColor: white,
                  hoverColor: transparent,
                  mouseCursor: MouseCursor.defer,
                  splashRadius: 2,
                  side: BorderSide(
                      width: 1, color: webTextFiled, style: BorderStyle.solid),
                  value: generalprovider.isCheck,
                  onChanged: (value) {
                    generalprovider.setCheck(value ?? false);
                  },
                ),
                Flexible(
                  fit: FlexFit.loose,
                  child: MyText(
                      text: "remember_me",
                      fontsizeWeb: Dimens.textBig,
                      fontsizeNormal: Dimens.textBig,
                      fontwaight: FontWeight.w500,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.center,
                      multilanguage: true,
                      fontstyle: FontStyle.normal),
                ),
              ],
            ),
          ),
          Flexible(
            fit: FlexFit.loose,
            child: InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              onTap: () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    transitionDuration: const Duration(milliseconds: 200),
                    pageBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation) {
                      return const WebForgetPassword();
                    },
                    transitionsBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation,
                        Widget child) {
                      return Align(
                        child: FadeTransition(
                          opacity: animation,
                          child: child,
                        ),
                      );
                    },
                  ),
                );
              },
              child: MyText(
                  color: colorPrimary,
                  text: "forget_password",
                  fontsizeWeb: Dimens.textBig,
                  fontsizeNormal: Dimens.textBig,
                  fontwaight: FontWeight.w400,
                  maxline: 1,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.center,
                  multilanguage: true,
                  fontstyle: FontStyle.normal),
            ),
          ),
        ],
      );
    });
  }

  Widget orSection() {
    return Row(
      crossAxisAlignment: CrossAxisAlignment.center,
      mainAxisAlignment: MainAxisAlignment.center,
      spacing: 16,
      children: [
        Flexible(
          fit: FlexFit.loose,
          child: Container(
            height: 2,
            width: MediaQuery.sizeOf(context).width,
            color: gray.withValues(alpha: 0.5),
          ),
        ),
        Flexible(
          fit: FlexFit.loose,
          child: MyText(
              color: gray.withValues(alpha: 0.5),
              text: "or_te",
              fontsizeWeb: Dimens.textTitle,
              fontsizeNormal: Dimens.textTitle,
              fontwaight: FontWeight.w500,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              multilanguage: true,
              fontstyle: FontStyle.normal),
        ),
        Flexible(
          fit: FlexFit.loose,
          child: Container(
            height: 2,
            width: MediaQuery.sizeOf(context).width,
            color: gray.withValues(alpha: 0.5),
          ),
        ),
      ],
    );
  }

  Widget loginBtn() {
    return Consumer<GeneralProvider>(
        builder: (context, generalprovider, child) {
      if (!generalprovider.isCheck) {
        return Container(
          width: MediaQuery.of(context).size.width,
          height: 45,
          alignment: Alignment.center,
          decoration: BoxDecoration(
            color: gray.withValues(alpha: 0.7),
            borderRadius: BorderRadius.circular(10),
          ),
          child: MyText(
            color: white,
            text: "login",
            fontsizeNormal: Dimens.textTitle,
            fontsizeWeb: Dimens.textTitle,
            fontwaight: FontWeight.w600,
            maxline: 1,
            multilanguage: true,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            fontstyle: FontStyle.normal,
          ),
        );
      } else {
        return InkWell(
          onTap: () async {
            email = emailController.text.toString();
            password = passwordController.text.toString();

            bool emailValidation = RegExp(
                    r"^[a-zA-Z0-9.a-zA-Z0-9.!#$%&'*+-/=?^_`{|}~]+@[a-zA-Z0-9]+\.[a-zA-Z]+")
                .hasMatch(email);

            if (emailController.text.isEmpty) {
              Utils.showSnackbar(context, "fail", "pleasenteremail", true);
            } else if (passwordController.text.isEmpty) {
              Utils.showSnackbar(
                  context, "fail", "pleaseenteryourpassword", true);
            } else if (password.length < 6) {
              Utils.showSnackbar(
                  context, "fail", "pleaseenterpasswordonlysixdigit", true);
            } else if (!emailValidation) {
              Utils.showSnackbar(context, "fail", "invalidemailaddress", true);
            } else {
              normalLogin(email, password, "4");
            }
          },
          child: AnimatedContainer(
            duration: const Duration(milliseconds: 80),
            clipBehavior: Clip.antiAliasWithSaveLayer,
            curve: Curves.bounceInOut,
            width: generalprovider.isProgressLoading
                ? 100
                : MediaQuery.of(context).size.width,
            height: 45,
            alignment: Alignment.center,
            decoration: BoxDecoration(
              color: colorPrimary,
              borderRadius: BorderRadius.circular(10),
            ),
            child: generalprovider.isProgressLoading
                ? const SizedBox(
                    width: 25,
                    height: 25,
                    child: CircularProgressIndicator(
                      color: white,
                      strokeWidth: 2,
                    ),
                  )
                : MyText(
                    color: white,
                    text: "login",
                    fontsizeNormal: Dimens.textTitle,
                    fontsizeWeb: Dimens.textTitle,
                    fontwaight: FontWeight.w600,
                    maxline: 1,
                    multilanguage: true,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.center,
                    fontstyle: FontStyle.normal,
                  ),
          ),
        );
      }
    });
  }

  Widget goingRegister() {
    return InkWell(
      onTap: () {
        Utils.navigatePage(context, const WebRegister(), "1");
      },
      child: Row(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Flexible(
            fit: FlexFit.loose,
            child: MyText(
                color: gray,
                text: "donthaveanaccount",
                fontsizeWeb: Dimens.textMedium,
                fontsizeNormal: Dimens.textMedium,
                maxline: 1,
                fontwaight: FontWeight.w400,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal,
                multilanguage: true),
          ),
          const SizedBox(width: 5),
          Flexible(
            fit: FlexFit.loose,
            child: MyText(
                color: colorPrimary,
                text: "register",
                fontsizeWeb: Dimens.textMedium,
                fontsizeNormal: Dimens.textMedium,
                maxline: 1,
                fontwaight: FontWeight.w500,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal,
                multilanguage: true),
          ),
        ],
      ),
    );
  }

  Widget mobileLogin() {
    return InkWell(
      onTap: () {
        Utils.navigatePage(context, const WebMobileLogin(), "2");
      },
      child: Container(
        width: MediaQuery.of(context).size.width,
        height: 45,
        alignment: Alignment.center,
        margin: const EdgeInsets.fromLTRB(30, 0, 30, 0),
        decoration: BoxDecoration(
          color: colorPrimary,
          borderRadius: BorderRadius.circular(5),
        ),
        child: MyText(
            color: white,
            text: "signinwithmobileno",
            fontsizeWeb: 16,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            fontstyle: FontStyle.normal,
            multilanguage: true),
      ),
    );
  }

  Widget loginWithSocial() {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      crossAxisAlignment: CrossAxisAlignment.center,
      spacing: 20,
      children: [
        Flexible(
          fit: FlexFit.loose,
          child: InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: (() {
              gmailLogin();
            }),
            child: Container(
              width: MediaQuery.of(context).size.width,
              height: 50,
              alignment: Alignment.center,
              decoration: BoxDecoration(
                  color: white,
                  border: Border.all(
                      width: 1, color: webTextFiled, style: BorderStyle.solid),
                  borderRadius: BorderRadius.circular(10)),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.center,
                spacing: 10,
                children: [
                  MyImage(width: 20, height: 20, imagePath: "ic_gmail.png"),
                  Flexible(
                    fit: FlexFit.loose,
                    child: MyText(
                        text: "sign_google",
                        fontsizeWeb: 16,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal,
                        multilanguage: true),
                  ),
                ],
              ),
            ),
          ),
        ),
        Flexible(
          fit: FlexFit.loose,
          child: InkWell(
            onTap: (() {
              Utils.navigatePage(context, const WebMobileLogin(), "2");
            }),
            child: Container(
              width: MediaQuery.of(context).size.width,
              height: 50,
              alignment: Alignment.center,
              decoration: BoxDecoration(
                  color: white,
                  border: Border.all(
                      width: 1, color: webTextFiled, style: BorderStyle.solid),
                  borderRadius: BorderRadius.circular(10)),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.center,
                spacing: 10,
                children: [
                  MyImage(width: 20, height: 20, imagePath: "ic_mobile.png"),
                  Flexible(
                    fit: FlexFit.loose,
                    child: MyText(
                        text: "sign_phone",
                        fontsizeWeb: 16,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal,
                        multilanguage: true),
                  ),
                ],
              ),
            ),
          ),
        ),
      ],
    );
  }

  /* Google(Gmail) Login */
  Future<void> _initGoogleSignIn() async {
    try {
      await googleSignIn.initialize(
        /* Web client → used as serverClientId in your code.
            web server client id pass
         */

        serverClientId:
            kIsWeb ? null : 'Web client → used as serverClientId in your code.',
      );
      initialized = true;
    } catch (e) {
      debugPrint("GoogleSignIn initialization failed: $e");
      return;
    }
  }

  Future<void> gmailLogin() async {
    if (!initialized) {
      await _initGoogleSignIn();
    }

    if (!mounted) return;
    generalProvider.setLoading(true);

    try {
      UserCredential userCredential;

      // ---- FIX FOR WEB ----
      GoogleAuthProvider authProvider = GoogleAuthProvider();
      authProvider.addScope('email');
      authProvider.addScope('profile');
      userCredential = await auth.signInWithPopup(authProvider);

      if (!mounted) return;

      assert(await userCredential.user?.getIdToken() != null);

      final firebaseId = userCredential.user?.uid ?? "";
      await SharedPre().save("firebaseId", firebaseId);

      checkAndNavigate(userCredential.user?.email ?? "", "2");
    } on FirebaseAuthException catch (e) {
      printLog('FirebaseAuthException ===CODE====> ${e.code}');
      printLog('FirebaseAuthException ==MESSAGE==> ${e.message}');
      generalProvider.setLoading(false);
    }
  }

  void updateDataInFirestore({required String firebasedid}) {
    // Update data to Firestore
    FirebaseFirestore.instance
        .collection(FirestoreConstants.pathUserCollection)
        .doc(firebasedid)
        .update({FirestoreConstants.deviceToken: strDeviceToken})
        .then((value) => printLog("User Updated"))
        .onError((error, stackTrace) {
          printLog("updateDataFirestore error ===> ${error.toString()}");
          printLog(
              "updateDataFirestore stackTrace ===> ${stackTrace.toString()}");
        });
  }

  void normalLogin(
    String email,
    String password,
    String type,
  ) async {
    generalProvider.setLoading(true);
    try {
      await generalProvider.login(
          type, email, password, strDeviceType ?? "", strDeviceToken ?? "");

      if (!mounted) return;
      if (generalProvider.loginmodel.status == 200) {
        Utils.saveUserCreds(
          userID: generalProvider.loginmodel.result?[0].id.toString(),
          userName:
              generalProvider.loginmodel.result?[0].userName.toString() ?? "",
          fullName:
              generalProvider.loginmodel.result?[0].fullName.toString() ?? "",
          email: generalProvider.loginmodel.result?[0].email.toString() ?? "",
          mobileNumber:
              generalProvider.loginmodel.result?[0].mobileNumber.toString() ??
                  "",
          image: generalProvider.loginmodel.result?[0].image.toString() ?? "",
          deviceType:
              generalProvider.loginmodel.result?[0].deviceType.toString() ?? "",
          deviceToken:
              generalProvider.loginmodel.result?[0].deviceToken.toString() ??
                  "",
          userIsBuy:
              generalProvider.loginmodel.result?[0].isBuy.toString() ?? "",
          type: generalProvider.loginmodel.result?[0].type.toString() ?? "",
        );
        generalProvider.setLoading(false);
        Utils.navigatePage(context, const WebHome(), "");
      } else {
        // Hide Progress Dialog
        generalProvider.setLoading(false);

        Utils.showSnackbar(
            context, "fail", "${generalProvider.loginmodel.message}", false);
      }
    } catch (e) {
      // Hide Progress Dialog
      generalProvider.setLoading(false);

      Utils.showSnackbar(
          context, "fail", "${generalProvider.loginmodel.message}", false);
    }
  }

/* Gmail and Apple */
  void checkAndNavigate(
    String email,
    String type,
  ) async {
    Utils().showProgress(context, "Please Wait");
    try {
      await generalProvider.getSocialLogin(
          type, email, strDeviceType ?? "", strDeviceToken ?? "");

      if (generalProvider.loginmodel.status == 200) {
        Utils.saveUserCreds(
          userID: generalProvider.loginmodel.result?[0].id.toString(),
          userName:
              generalProvider.loginmodel.result?[0].userName.toString() ?? "",
          fullName:
              generalProvider.loginmodel.result?[0].fullName.toString() ?? "",
          email: generalProvider.loginmodel.result?[0].email.toString() ?? "",
          mobileNumber:
              generalProvider.loginmodel.result?[0].mobileNumber.toString() ??
                  "",
          image: generalProvider.loginmodel.result?[0].image.toString() ?? "",
          deviceType:
              generalProvider.loginmodel.result?[0].deviceType.toString() ?? "",
          deviceToken:
              generalProvider.loginmodel.result?[0].deviceToken.toString() ??
                  "",
          userIsBuy:
              generalProvider.loginmodel.result?[0].isBuy.toString() ?? "",
          type: generalProvider.loginmodel.result?[0].type.toString() ?? "",
        );
        if (!mounted) return;
        Utils().hideProgress(context);
        Utils.navigatePage(context, const WebHome(), "");
      } else {
        // Hide Progress Dialog
        if (!mounted) return;
        Utils().hideProgress(context);
        Utils.showSnackbar(
            context, "fail", "${generalProvider.loginmodel.message}", false);
      }
    } catch (e) {
      Utils().hideProgress(context);
      // Hide Progress Dialog
      if (!mounted) return;
      Utils.showSnackbar(
          context, "fail", "${generalProvider.loginmodel.message}", false);
    }
  }
}
