import 'package:prakah/pages/bottombar_pages/liveclass.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/provider/liveclassprovider.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/subscription/allpayment.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webhome.dart';
import 'package:prakah/webpages/websearch.dart';
import 'package:prakah/webwidget/footerweb.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:prakah/model/liveclasssectionmodel.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:intl/intl.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class WebLiveClass extends StatefulWidget {
  const WebLiveClass({super.key});

  @override
  State<WebLiveClass> createState() => _WebLiveClassState();
}

class _WebLiveClassState extends State<WebLiveClass> {
  LiveClassProvider liveClassProvider = LiveClassProvider();
  PageController pageController = PageController();
  DateTime endDate = DateTime.now();
  final _scrollController = ScrollController();
  final _historyScrollController = ScrollController();
  final searchController = TextEditingController();

  double? width;
  double? height;

  @override
  void initState() {
    super.initState();
    liveClassProvider = Provider.of<LiveClassProvider>(context, listen: false);
    _scrollController.addListener(_scrollListener);
    _historyScrollController.addListener(_historyScrollListener);

    WidgetsBinding.instance.addPostFrameCallback((_) {
      getApi();
    });
  }

  void getApi() {
    liveClassProvider.setLoding(true);
    _fetchData(0);
    _fetchHistoryData(0);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange) {
      if (liveClassProvider.isSearch == "0") {
        if ((liveClassProvider.sectioncurrentPage ?? 0) <
            (liveClassProvider.sectiontotalPage ?? 0)) {
          liveClassProvider.setLoadMore(true);
          _fetchData(liveClassProvider.sectioncurrentPage ?? 0);
        }
      } else {
        if ((liveClassProvider.searchcurrentPage ?? 0) <
            (liveClassProvider.searchtotalPage ?? 0)) {
          liveClassProvider.setSearchLoadMore(true);
          _fetchsearchData(liveClassProvider.searchcurrentPage ?? 0);
        }
      }
    }
  }

  void _fetchData(int? nextPage) {
    liveClassProvider.getSeactionList((nextPage ?? 0) + 1);
  }

  void _historyScrollListener() {
    if (!_historyScrollController.hasClients) return;
    if (_historyScrollController.offset >=
            _historyScrollController.position.maxScrollExtent &&
        !_historyScrollController.position.outOfRange &&
        (liveClassProvider.histroycurrentPage ?? 0) <
            (liveClassProvider.histroytotalPage ?? 0)) {
      liveClassProvider.setHistroyLoadMore(true);
      _fetchHistoryData(liveClassProvider.histroycurrentPage ?? 0);
    }
  }

  void _fetchHistoryData(int? nextPage) {
    liveClassProvider.getHistroyList((nextPage ?? 0) + 1);
  }

/* Search */
  Future<void> _fetchsearchData(int? nextPage) async {
    await liveClassProvider.getSearchList(
        liveClassProvider.startDate,
        endDate,
        liveClassProvider.isFree,
        liveClassProvider.courseId ?? "",
        liveClassProvider.classTimeStatus ?? "",
        (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    super.dispose();
    liveClassProvider.clearProvider();
  }

  @override
  Widget build(BuildContext context) {
    return _buildSearchHome();
  }

  Widget _buildSearchHome() {
    return Consumer<SearchProvider>(builder: (context, homeprovider, child) {
      if (homeprovider.isSearch == "0") {
        return Scaffold(
          appBar: Utils.webMainAppbar(controller: searchController),
          body: _buildLiveClassData(),
        );
      } else {
        return WebSearch(
          searchController: searchController,
        );
      }
    });
  }

  Widget _buildLiveClassData() {
    return Consumer<LiveClassProvider>(
        builder: (context, liveClassProvider, child) {
      return Utils.hoverItemWithPage(
          myWidget: SingleChildScrollView(
        controller: _scrollController,
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          spacing: 10,
          children: [
            buildWebDetailsAppBar(),
            _buildSearch(),
            _buildClickShow(),
            liveClassProvider.isSearch == "0"
                ? buildPage()
                : _buildSearchItam(),
            FooterWeb()
          ],
        ),
      ));
    });
  }

  Widget buildWebDetailsAppBar() {
    return Consumer<GeneralProvider>(
        builder: (context, generalprovider, child) {
      return Container(
        height: 75,
        width: MediaQuery.sizeOf(context).width,
        color: gray.withValues(alpha: 0.3),
        padding: MediaQuery.of(context).size.width > 1000
            ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
            : const EdgeInsets.fromLTRB(20, 0, 20, 0),
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.center,
          spacing: 14,
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              highlightColor: transparent,
              onTap: () async {
                generalprovider.setHomeTab("1");
                Navigator.of(context).pushAndRemoveUntil(
                    PageRouteBuilder(
                        transitionDuration: const Duration(milliseconds: 150),
                        pageBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation) {
                          return const WebHome();
                        },
                        transitionsBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation,
                            Widget child) {
                          return Align(
                              child: FadeTransition(
                                  opacity: animation, child: child));
                        }),
                    (route) => false);
              },
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                spacing: 14,
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  Icon(
                    Icons.home,
                    size: 25,
                    color: black.withValues(alpha: 0.4),
                  ),
                  MyText(
                    text: "home",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textMedium,
                    fontsizeWeb: Dimens.textTitle,
                    fontwaight: FontWeight.w600,
                    color: black,
                  ),
                ],
              ),
            ),
            InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              onTap: () {},
              child: Row(
                children: [
                  Icon(
                    Icons.keyboard_arrow_right_rounded,
                    size: 25,
                    color: black.withValues(alpha: 0.4),
                  ),
                  MyText(
                      text: "live_class",
                      multilanguage: true,
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textTitle,
                      fontwaight: FontWeight.w600,
                      color: colorPrimaryDark),
                ],
              ),
            ),
          ],
        ),
      );
    });
  }

  Widget buildPage() {
    if (liveClassProvider.loading && !liveClassProvider.loadmore) {
      return Padding(
        padding: MediaQuery.of(context).size.width > 1000
            ? const EdgeInsets.fromLTRB(200, 25, 200, 0)
            : const EdgeInsets.fromLTRB(20, 25, 20, 0),
        child: Column(
          children: [landscapeShimmer(), recordingPortriatShimmer()],
        ),
      );
    } else {
      return Padding(
        padding: MediaQuery.of(context).size.width > 1000
            ? const EdgeInsets.fromLTRB(200, 25, 200, 0)
            : const EdgeInsets.fromLTRB(20, 25, 20, 0),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            setSectionByType(),
            classhistoryData(),
            if (liveClassProvider.loadmore)
              SizedBox(
                height: 50,
                child: Utils.pageLoader(),
              )
            else
              const SizedBox.shrink(),
          ],
        ),
      );
    }
  }

  Widget setSectionByType() {
    if (liveClassProvider.livesectionList != null &&
        (liveClassProvider.livesectionList?.length ?? 0) > 0) {
      return MediaQuery.removePadding(
        context: context,
        removeTop: true,
        child: ListView.builder(
          itemCount: liveClassProvider.livesectionList?.length ?? 0,
          shrinkWrap: true,
          reverse: false,
          physics: const NeverScrollableScrollPhysics(),
          itemBuilder: (BuildContext context, int index) {
            if (liveClassProvider.livesectionList?[index].data != null &&
                (liveClassProvider.livesectionList?[index].data?.length ?? 0) >
                    0) {
              return Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  // Section Title
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: liveClassProvider.livesectionList?[index].title
                              .toString() ??
                          "",
                      fontsizeNormal: Dimens.textBig,
                      fontwaight: FontWeight.w600,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.start,
                      fontstyle: FontStyle.normal,
                      multilanguage: false),
                  const SizedBox(height: 5),
                  (liveClassProvider.livesectionList?[index].shortTitle
                                  .toString() ??
                              "") ==
                          ""
                      ? SizedBox.shrink()
                      : MyText(
                          color: gray,
                          multilanguage: false,
                          text: liveClassProvider
                                  .livesectionList?[index].shortTitle
                                  .toString() ??
                              "",
                          textalign: TextAlign.center,
                          fontsizeNormal: 12,
                          fontsizeWeb: 12,
                          maxline: 1,
                          fontwaight: FontWeight.w400,
                          overflow: TextOverflow.ellipsis,
                          fontstyle: FontStyle.normal),
                  const SizedBox(height: 10),
                  // Section Data List
                  setSectionData(
                      index: index,
                      sectionList: liveClassProvider.livesectionList),
                  const SizedBox(height: 6),
                ],
              );
            } else {
              return const SizedBox.shrink();
            }
          },
        ),
      );
    } else {
      return const NoData();
    }
  }

  Widget setSectionData(
      {required int index, required List<Result>? sectionList}) {
    if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "index_landscape") {
      if ((sectionList?[index].type.toString() ?? "") == "1") {
        return indexLandscapeData(index, sectionList);
      } else {
        return recordingIndexLandscape(index, sectionList);
      }
    } else if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "index_portrait") {
      if ((sectionList?[index].type.toString() ?? "") == "1") {
        return indexLandscapeData(index, sectionList);
      } else {
        return recordingIndexLandscape(index, sectionList);
      }
    } else {
      return const SizedBox.shrink();
    }
  } /* index_landscape Data Started */

  Widget indexLandscapeData(int sectionindex, List<Result>? sectionList) {
    return SingleChildScrollView(
      padding: EdgeInsets.zero,
      scrollDirection: Axis.horizontal,
      physics: BouncingScrollPhysics(),
      child: Row(
        children: List.generate(
          sectionList?[sectionindex].data?.length ?? 0,
          (index) {
            final commanList = sectionList?[sectionindex].data?[index];
            return Container(
              padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
              width: 350,
              margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
              decoration: BoxDecoration(
                  color: white,
                  borderRadius: BorderRadius.circular(16),
                  border: Border.all(width: 1, color: transparent),
                  boxShadow: [
                    BoxShadow(
                        blurRadius: 4,
                        blurStyle: BlurStyle.solid,
                        offset: Offset(0, 4),
                        spreadRadius: 0,
                        color: transparent.withValues(alpha: 0.25))
                  ]),
              child: Column(
                spacing: 10,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.start,
                    spacing: 5,
                    children: [
                      Container(
                        padding:
                            EdgeInsets.symmetric(horizontal: 10, vertical: 4),
                        decoration: BoxDecoration(
                            color: (commanList?.isFree.toString() ?? "") ==
                                        "1" &&
                                    ((commanList?.isUserBuy.toString() ?? "") ==
                                        "0")
                                ? green
                                : red,
                            borderRadius: BorderRadius.circular(10)),
                        child: MyText(
                          text: (commanList?.isFree.toString() ?? "") == "1" &&
                                  ((commanList?.isUserBuy.toString() ?? "") ==
                                      "0")
                              ? Locales.string(context, "free")
                              : commanList?.price.toString() ?? "",
                          color: white,
                          fontsizeNormal: Dimens.textSmall,
                          fontsizeWeb: Dimens.textTitle,
                          fontwaight: FontWeight.w600,
                        ),
                      ),
                      Container(
                        padding:
                            EdgeInsets.symmetric(horizontal: 6, vertical: 4),
                        decoration: BoxDecoration(
                            color: liveTextColor,
                            borderRadius: BorderRadius.circular(7)),
                        child: MyText(
                          text: commanList?.title.toString() ?? "",
                          color: black,
                          fontsizeNormal: Dimens.textSmall,
                          fontsizeWeb: Dimens.textTitle,
                          fontwaight: FontWeight.w400,
                        ),
                      )
                    ],
                  ),
                  Stack(
                    alignment: Alignment.center,
                    children: [
                      Row(
                        spacing: 14,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          SizedBox(
                            width: 160,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              spacing: 20,
                              children: [
                                MyText(
                                  text:
                                      commanList?.courseTitle.toString() ?? "",
                                  color: black,
                                  fontsizeNormal: Dimens.textMedium,
                                  fontsizeWeb: Dimens.textTitle,
                                  fontwaight: FontWeight.w500,
                                ),
                                Row(
                                  children: [
                                    ((commanList?.status.toString() ?? "") ==
                                            "2")
                                        ? MyNetworkImage(
                                            imageUrl:
                                                "https://i.fbcd.co/products/resized/resized-750-500/2419-9ff351c8d3c2dcbe30da81041c911438a6559890b83490e3a1fd55f8e3b4fc06.jpg",
                                            radius: 0,
                                            imgHeight: 20,
                                            imgWidth: 20,
                                            fit: BoxFit.cover)
                                        : ((commanList?.status.toString() ??
                                                    "") ==
                                                "1")
                                            ? MyText(
                                                text: "start_on",
                                                multilanguage: true,
                                                color: black,
                                                fontsizeNormal:
                                                    Dimens.textSmall,
                                                fontwaight: FontWeight.w400,
                                              )
                                            : SizedBox.shrink(),
                                    ((commanList?.status.toString() ?? "") ==
                                                "2" ||
                                            (commanList?.status.toString() ??
                                                    "") ==
                                                "1")
                                        ? SizedBox(width: 4)
                                        : SizedBox.shrink(),
                                    Flexible(
                                      fit: FlexFit.loose,
                                      child: (commanList?.status.toString() ??
                                                  "") ==
                                              "1"
                                          ? Row(
                                              children: [
                                                Container(
                                                  padding: EdgeInsets.symmetric(
                                                      horizontal: 6,
                                                      vertical: 4),
                                                  decoration: BoxDecoration(
                                                      color: red.withValues(
                                                          alpha: 0.2),
                                                      borderRadius:
                                                          BorderRadius.only(
                                                              topLeft: Radius
                                                                  .circular(7),
                                                              bottomLeft: Radius
                                                                  .circular(
                                                                      7))),
                                                  child: MyText(
                                                      text: DateFormat("dd MMM")
                                                          .format(commanList
                                                                  ?.startedDate ??
                                                              DateTime.now()),
                                                      multilanguage: false,
                                                      color: red,
                                                      fontsizeNormal:
                                                          Dimens.textSmall,
                                                      fontwaight:
                                                          FontWeight.w400),
                                                ),
                                                Container(
                                                  padding: EdgeInsets.symmetric(
                                                      horizontal: 6,
                                                      vertical: 4),
                                                  decoration: BoxDecoration(
                                                      color: red.withValues(
                                                          alpha: 0.6),
                                                      borderRadius:
                                                          BorderRadius.only(
                                                              topRight: Radius
                                                                  .circular(7),
                                                              bottomRight:
                                                                  Radius
                                                                      .circular(
                                                                          7))),
                                                  child: MyText(
                                                    text:
                                                        commanList?.startTime ??
                                                            "",
                                                    multilanguage: false,
                                                    color: white,
                                                    fontsizeNormal:
                                                        Dimens.textSmall,
                                                    fontwaight: FontWeight.w400,
                                                  ),
                                                ),
                                              ],
                                            )
                                          : Container(
                                              padding: EdgeInsets.symmetric(
                                                  horizontal: 6, vertical: 4),
                                              decoration: BoxDecoration(
                                                  gradient: LinearGradient(
                                                      colors: [
                                                        red.withValues(
                                                            alpha: 0.5),
                                                        red.withValues(
                                                            alpha: 0.6)
                                                      ],
                                                      tileMode: TileMode.mirror,
                                                      begin:
                                                          Alignment.topCenter,
                                                      end: Alignment
                                                          .bottomCenter),
                                                  borderRadius:
                                                      BorderRadius.circular(7)),
                                              child: MyText(
                                                text: (commanList?.status
                                                                .toString() ??
                                                            "") ==
                                                        "2"
                                                    ? "live_now"
                                                    : (commanList?.status
                                                                    .toString() ??
                                                                "") ==
                                                            "3"
                                                        ? "completed"
                                                        : "cancelled",
                                                multilanguage: true,
                                                color: black,
                                                fontsizeNormal:
                                                    Dimens.textSmall,
                                                fontsizeWeb: Dimens.textTitle,
                                                fontwaight: FontWeight.w400,
                                              ),
                                            ),
                                    ),
                                  ],
                                )
                              ],
                            ),
                          ),
                        ],
                      ),
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.end,
                        children: [
                          MyNetworkImage(
                              imageUrl:
                                  commanList?.lecturerImage.toString() ?? "",
                              radius: 10,
                              imgHeight: 100,
                              imgWidth: 100,
                              fit: BoxFit.cover),
                          SizedBox(height: 2),
                          ClipPath(
                            clipper: LeftDiagonalClipper(),
                            child: Container(
                              padding: EdgeInsets.fromLTRB(
                                  18, 4, 6, 4), // increased left padding

                              decoration: BoxDecoration(
                                color: black,
                              ),
                              child: MyText(
                                text: commanList?.lecturerName.toString() ?? "",
                                color: white,
                                fontsizeNormal: Dimens.textSmall,
                                fontsizeWeb: Dimens.textTitle,
                                fontwaight: FontWeight.w600,
                              ),
                            ),
                          ),
                          Container(
                            height: 1,
                            width: width,
                            color: gray,
                          ),
                        ],
                      ),
                    ],
                  ),
                  Row(
                    spacing: 20,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                          child: btnWidget(
                        text: "remind_me",
                        color: colorPrimaryDark,
                        textColor: white,
                        borderColor: colorPrimaryDark,
                      )),
                      Expanded(
                          child: btnWidget(
                        onTap: () {
                          if (Utils.checkLoginUser(context)) {
                            if ((commanList?.isFree.toString() ?? "") == "1" &&
                                ((commanList?.isUserBuy.toString() ?? "") ==
                                    "0")) {
                              Utils.lanchUrl(
                                  commanList?.meetingLink.toString() ?? "");
                            } else {
                              Navigator.of(context).push(
                                PageRouteBuilder(
                                  pageBuilder: (context, animation,
                                          secondaryAnimation) =>
                                      AllPayment(
                                    contentType: "3",
                                    payType: 'Package',
                                    itemId: commanList?.id.toString() ?? "",
                                    price: commanList?.price.toString() ?? "",
                                    itemTitle:
                                        commanList?.title.toString() ?? "",
                                  ),
                                  transitionsBuilder: (context, animation,
                                      secondaryAnimation, child) {
                                    const begin = Offset(1.0, 0.0);
                                    const end = Offset.zero;
                                    const curve = Curves.ease;

                                    var tween = Tween(begin: begin, end: end)
                                        .chain(CurveTween(curve: curve));

                                    return SlideTransition(
                                      position: animation.drive(tween),
                                      child: child,
                                    );
                                  },
                                ),
                              );
                            }
                          }
                        },
                        text: "jion_this_class",
                        color: white,
                        textColor: colorPrimaryDark,
                        borderColor: colorPrimaryDark,
                      ))
                    ],
                  )
                ],
              ),
            );
          },
        ),
      ),
    );
  }

  Widget btnWidget({String? text, color, textColor, borderColor, onTap}) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: onTap,
      child: Container(
        padding: EdgeInsets.symmetric(horizontal: 6, vertical: 10),
        alignment: Alignment.center,
        decoration: BoxDecoration(
            color: color,
            borderRadius: BorderRadius.circular(8),
            border: Border.all(
                width: 1, color: borderColor, style: BorderStyle.solid)),
        child: MyText(
          text: text ?? "",
          color: textColor,
          multilanguage: true,
          fontsizeNormal: Dimens.textMedium,
          fontsizeWeb: Dimens.textTitle,
          fontwaight: FontWeight.w600,
        ),
      ),
    );
  } /* Class Recording Sction Data */

  Widget recordingIndexLandscape(int sectionindex, List<Result>? sectionList) {
    return SingleChildScrollView(
        scrollDirection: Axis.horizontal,
        padding: EdgeInsets.zero,
        physics: BouncingScrollPhysics(),
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: List.generate(
            sectionList?[sectionindex].data?.length ?? 0,
            (index) {
              final commanList = sectionList?[sectionindex].data?[index];
              return InkWell(
                splashColor: transparent,
                focusColor: transparent,
                hoverColor: transparent,
                onTap: () {
                  Utils.openPlayer(
                    context: context,
                    viewApiType: 2,
                    secreateKey: "",
                    type: "video",
                    videoId: commanList?.id ?? 0,
                    videoUrl: commanList?.recordingUrl.toString() ?? "",
                    vUploadType: "external",
                    videoThumb: commanList?.courseImage.toString() ?? "",
                    courseId: commanList?.id ?? 0,
                    chepterId: 0,
                  );
                },
                child: Container(
                  margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
                  padding:
                      const EdgeInsets.symmetric(horizontal: 12, vertical: 14),
                  width: 360,
                  decoration: BoxDecoration(
                      color: white,
                      borderRadius: BorderRadius.circular(10),
                      border: Border.all(width: 1, color: transparent),
                      boxShadow: [
                        BoxShadow(
                            blurRadius: 4,
                            blurStyle: BlurStyle.solid,
                            offset: Offset(0, 4),
                            spreadRadius: 0,
                            color: transparent.withValues(alpha: 0.25))
                      ]),
                  child: Row(
                    spacing: 14,
                    children: [
                      MyNetworkImage(
                          imgHeight: 90,
                          imgWidth: 130,
                          radius: 5,
                          imageUrl: commanList?.courseImage ?? "",
                          fit: BoxFit.fill),
                      Expanded(
                          child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        spacing: 4,
                        children: [
                          MyText(
                            text: commanList?.title.toString() ?? "",
                            maxline: 1,
                            color: black,
                            fontsizeNormal: Dimens.textMedium,
                            fontsizeWeb: Dimens.textTitle,
                            fontwaight: FontWeight.w400,
                          ),
                          MyText(
                            text: commanList?.categoryName.toString() ?? "",
                            maxline: 1,
                            color: black,
                            fontsizeNormal: Dimens.textSmall,
                            fontsizeWeb: Dimens.textTitle,
                            fontwaight: FontWeight.w400,
                          ),
                          Row(
                            spacing: 20,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Expanded(
                                child: Row(
                                  children: [
                                    Icon(Icons.date_range_sharp,
                                        size: 16, color: gray),
                                    Expanded(
                                      child: MyText(
                                        text: Utils.dateConvert(
                                            commanList?.updatedAt.toString() ??
                                                "",
                                            "dd MMM yyyy"),
                                        maxline: 1,
                                        color: black,
                                        fontsizeNormal: Dimens.textSmall,
                                        fontsizeWeb: Dimens.textTitle,
                                        fontwaight: FontWeight.w400,
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                              Expanded(
                                child: Row(
                                  spacing: 10,
                                  children: [
                                    Icon(Icons.watch_later_outlined,
                                        size: 16, color: gray),
                                    Expanded(
                                      child: MyText(
                                        text: Utils.dateConvert(
                                            commanList?.updatedAt.toString() ??
                                                "",
                                            "hh:mm a"),
                                        maxline: 1,
                                        color: black,
                                        fontsizeNormal: Dimens.textSmall,
                                        fontsizeWeb: Dimens.textTitle,
                                        fontwaight: FontWeight.w400,
                                      ),
                                    ),
                                  ],
                                ),
                              )
                            ],
                          ),
                          InkWell(
                            splashColor: transparent,
                            focusColor: transparent,
                            hoverColor: transparent,
                            onTap: () {
                              Utils.openPlayer(
                                context: context,
                                secreateKey: "",
                                viewApiType: 2,
                                type: "video",
                                videoId: commanList?.id ?? 0,
                                videoUrl:
                                    commanList?.recordingUrl.toString() ?? "",
                                vUploadType: "external",
                                videoThumb:
                                    commanList?.courseImage.toString() ?? "",
                                courseId: commanList?.id ?? 0,
                                chepterId: 0,
                              );
                            },
                            child: Container(
                              padding: EdgeInsets.symmetric(
                                  horizontal: 6, vertical: 4),
                              alignment: Alignment.center,
                              decoration: BoxDecoration(
                                  color: colorPrimaryDark,
                                  borderRadius: BorderRadius.circular(8),
                                  border: Border.all(
                                      width: 1,
                                      color: colorPrimaryDark,
                                      style: BorderStyle.solid)),
                              child: MyText(
                                text: "watchrecording",
                                color: white,
                                multilanguage: true,
                                fontsizeNormal: Dimens.textSmall,
                                fontsizeWeb: Dimens.textTitle,
                                fontwaight: FontWeight.w600,
                              ),
                            ),
                          )
                        ],
                      ))
                    ],
                  ),
                ),
              );
            },
          ),
        ));
  }

  /* Class History Data Started */
  Widget classhistoryData() {
    if (liveClassProvider.histroyLoding && !liveClassProvider.histroyLoadmore) {
      return landscapeShimmer();
    } else {
      if (liveClassProvider.histroyList != null &&
          (liveClassProvider.histroyList?.length ?? 0) > 0) {
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text: "my_class_history",
                fontsizeNormal: Dimens.textBig,
                fontwaight: FontWeight.w600,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.start,
                fontstyle: FontStyle.normal,
                multilanguage: true),
            const SizedBox(height: 5),
            Row(
              spacing: 16,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                Expanded(
                  child: SingleChildScrollView(
                    controller: _historyScrollController,
                    physics: BouncingScrollPhysics(),
                    scrollDirection: Axis.horizontal,
                    padding: EdgeInsets.zero,
                    child: _buildClassHistory(),
                  ),
                ),
                if (liveClassProvider.histroyLoadmore)
                  Utils.pageLoader()
                else
                  SizedBox.shrink()
              ],
            ),
          ],
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }

  Widget _buildClassHistory() {
    return Row(
        children: List.generate(
      liveClassProvider.histroyList?.length ?? 0,
      (index) {
        final commanList = liveClassProvider.histroyList?[index];
        return Container(
          padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
          width: 350,
          margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
          decoration: BoxDecoration(
              color: white,
              borderRadius: BorderRadius.circular(16),
              border: Border.all(width: 1, color: transparent),
              boxShadow: [
                BoxShadow(
                    blurRadius: 4,
                    blurStyle: BlurStyle.solid,
                    offset: Offset(0, 4),
                    spreadRadius: 0,
                    color: transparent.withValues(alpha: 0.25))
              ]),
          child: Column(
            spacing: 10,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.start,
                spacing: 5,
                children: [
                  Container(
                    padding: EdgeInsets.symmetric(horizontal: 10, vertical: 4),
                    decoration: BoxDecoration(
                        color: green, borderRadius: BorderRadius.circular(14)),
                    child: MyText(
                      text: Locales.string(context, "free"),
                      color: white,
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textTitle,
                      fontwaight: FontWeight.w600,
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.symmetric(horizontal: 6, vertical: 4),
                    decoration: BoxDecoration(
                        color: liveTextColor,
                        borderRadius: BorderRadius.circular(7)),
                    child: MyText(
                      text: commanList?.categoryName.toString() ?? "",
                      color: black,
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textTitle,
                      fontwaight: FontWeight.w400,
                    ),
                  )
                ],
              ),
              Stack(
                alignment: Alignment.center,
                children: [
                  Row(
                    spacing: 14,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      SizedBox(
                        width: 160,
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          spacing: 20,
                          children: [
                            MyText(
                              text: commanList?.liveClassTitle.toString() ?? "",
                              color: black,
                              fontsizeNormal: Dimens.textMedium,
                              fontsizeWeb: Dimens.textTitle,
                              fontwaight: FontWeight.w500,
                            ),
                            Container(
                              padding: EdgeInsets.symmetric(
                                  horizontal: 6, vertical: 4),
                              decoration: BoxDecoration(
                                  gradient: LinearGradient(
                                      colors: [
                                        red.withValues(alpha: 0.5),
                                        red.withValues(alpha: 0.6)
                                      ],
                                      tileMode: TileMode.mirror,
                                      begin: Alignment.topCenter,
                                      end: Alignment.bottomCenter),
                                  borderRadius: BorderRadius.circular(7)),
                              child: MyText(
                                text: "lesson_end",
                                multilanguage: true,
                                color: black,
                                fontsizeNormal: Dimens.textSmall,
                                fontsizeWeb: Dimens.textTitle,
                                fontwaight: FontWeight.w400,
                              ),
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.end,
                    children: [
                      MyNetworkImage(
                          imageUrl: commanList?.lecturerImage.toString() ?? "",
                          radius: 10,
                          imgHeight: 100,
                          imgWidth: 100,
                          fit: BoxFit.cover),
                      SizedBox(height: 2),
                      ClipPath(
                        clipper: LeftDiagonalClipper(),
                        child: Container(
                          padding: EdgeInsets.fromLTRB(
                              18, 4, 6, 4), // increased left padding

                          decoration: BoxDecoration(
                            color: black,
                          ),
                          child: MyText(
                            text: commanList?.lecturerName.toString() ?? "",
                            color: white,
                            fontsizeNormal: Dimens.textSmall,
                            fontsizeWeb: Dimens.textTitle,
                            fontwaight: FontWeight.w600,
                          ),
                        ),
                      ),
                      Container(
                        height: 1,
                        width: width,
                        color: gray,
                      ),
                    ],
                  ),
                ],
              ),
              Row(
                spacing: 20,
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Expanded(
                      child: btnWidget(
                    text: "view_certificates",
                    color: colorPrimaryDark,
                    textColor: white,
                    borderColor: colorPrimaryDark,
                  )),
                  Expanded(
                      child: btnWidget(
                    onTap: () {},
                    text: "view_details",
                    color: white,
                    textColor: colorPrimaryDark,
                    borderColor: colorPrimaryDark,
                  ))
                ],
              )
            ],
          ),
        );
      },
    ));
  }
/* Class Histroy Data END */

/* Search Live Class Started */
  Widget _buildSearch() {
    return SingleChildScrollView(
      padding: MediaQuery.of(context).size.width > 1000
          ? const EdgeInsets.fromLTRB(200, 20, 200, 0)
          : const EdgeInsets.fromLTRB(20, 20, 20, 0),
      scrollDirection: Axis.horizontal,
      physics: AlwaysScrollableScrollPhysics(),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        mainAxisAlignment: MainAxisAlignment.start,
        spacing: 20,
        children: [
          _buildSearchWidget(
              onTap: () async {
                liveClassProvider.setFilter("1");

                DateTime? pickedDate = await showDatePicker(
                  context: context,
                  initialDate: liveClassProvider.startDate,
                  firstDate: DateTime(2000),
                  lastDate: DateTime(2100),
                  locale: const Locale('en'),
                  builder: (context, child) {
                    return Theme(
                      data: Theme.of(context).copyWith(
                        colorScheme: ColorScheme.light(
                          primary: colorPrimaryDark,
                          onPrimary: white,
                          onSurface: black,
                        ),
                        textButtonTheme: TextButtonThemeData(
                          style: TextButton.styleFrom(
                            foregroundColor: colorPrimaryDark,
                          ),
                        ),
                      ),
                      child: child!,
                    );
                  },
                );
                if (pickedDate != null &&
                    pickedDate != liveClassProvider.startDate) {
                  liveClassProvider.setDateValue(pickedDate);
                  // liveClassProvider.clearContent();
                  //, title: "from"),
                }
              },
              value: "1",
              title: "from"),
          // _buildSearchWidget(
          //     onTap: () {
          //       liveClassProvider.setFilter("2");
          //     },
          //     value: "2",
          //     title: "to"),
          _buildSearchWidget(
              onTap: () {
                liveClassProvider.setFilter("3");

                liveClassProvider.setCourseId("");
              },
              value: "3",
              title: "classes_plan"),
          _buildSearchWidget(
              onTap: () async {
                liveClassProvider.setFilter("4");

                liveClassProvider.setCourseId("");
                /* Course name api call */

                await liveClassProvider.getCourseName();
              },
              value: "4",
              title: "subject"),
          _buildSearchWidget(
              onTap: () {
                liveClassProvider.setFilter("5");
                liveClassProvider.setCourseId("");
              },
              value: "5",
              title: "classes_time"),
          SizedBox(width: 20),
          /* Apply Button */
          Row(
            spacing: 20,
            crossAxisAlignment: CrossAxisAlignment.center,
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              InkWell(
                splashColor: transparent,
                focusColor: transparent,
                hoverColor: transparent,
                onTap: () {
                  liveClassProvider.setSearch("1");
                  liveClassProvider.searchList?.clear();
                  _fetchsearchData(0);
                },
                child: Container(
                  alignment: Alignment.center,
                  padding: EdgeInsets.fromLTRB(14, 10, 14, 10),
                  decoration: BoxDecoration(
                    color: white,
                    border: Border.all(
                        width: 1,
                        color: colorPrimaryDark,
                        style: BorderStyle.solid),
                    borderRadius: BorderRadius.circular(12),
                  ),
                  child: MyText(
                    text: "apply_filters",
                    color: colorPrimaryDark,
                    multilanguage: true,
                    fontsizeNormal: Dimens.textMedium,
                    fontwaight: FontWeight.w500,
                  ),
                ),
              ),
              InkWell(
                splashColor: transparent,
                focusColor: transparent,
                hoverColor: transparent,
                onTap: () {
                  liveClassProvider.resetFilters();
                  liveClassProvider.setFilter("");
                  liveClassProvider.searchList?.clear();
                  liveClassProvider.setSearch("0");
                  printLog("this is click btn");
                },
                child: Container(
                  alignment: Alignment.center,
                  padding: EdgeInsets.fromLTRB(14, 10, 14, 10),
                  decoration: BoxDecoration(
                    color: colorPrimary.withValues(alpha: 0.3),
                    border: Border.all(
                        width: 1,
                        color: colorPrimaryDark,
                        style: BorderStyle.solid),
                    borderRadius: BorderRadius.circular(12),
                  ),
                  child: MyText(
                    text: "reset_all",
                    color: colorPrimaryDark,
                    multilanguage: true,
                    fontsizeNormal: Dimens.textMedium,
                    fontwaight: FontWeight.w500,
                  ),
                ),
              ),
            ],
          )
        ],
      ),
    );
  }

/* Click and Widget show */
  Widget _buildClickShow() {
    if (liveClassProvider.isFilter == "3") {
      return planWidget();
    } else if (liveClassProvider.isFilter == "4") {
      return courseNameData();
    } else if (liveClassProvider.isFilter == "5") {
      return timeWidget();
    } else {
      return SizedBox.shrink();
    }
  }

  Widget planWidget() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 1000
          ? const EdgeInsets.fromLTRB(200, 20, 200, 0)
          : const EdgeInsets.fromLTRB(20, 20, 20, 0),
      child: RadioGroup(
        groupValue: liveClassProvider.isFree,
        onChanged: (value) {
          liveClassProvider.setPlan(value ?? "");
        },
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Row(
              children: [
                Radio(
                  activeColor: green,
                  focusColor: transparent,
                  hoverColor: transparent,
                  splashRadius: 0,
                  value: "0",
                ),
                MyText(
                  text: "paid",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textMedium,
                  fontwaight: FontWeight.w500,
                ),
              ],
            ),
            Row(
              children: [
                Radio(
                  activeColor: green,
                  focusColor: transparent,
                  hoverColor: transparent,
                  splashRadius: 0,
                  value: "1",
                ),
                MyText(
                  text: "free",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textMedium,
                  fontwaight: FontWeight.w500,
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _buildSearchWidget({required VoidCallback onTap, title, value}) {
    return InkWell(
      onTap: onTap,
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      child: Container(
        padding: EdgeInsets.fromLTRB(10, 4, 10, 4),
        decoration: BoxDecoration(
            color:
                liveClassProvider.isFilter == value ? colorPrimaryDark : white,
            borderRadius: BorderRadius.circular(10),
            border: Border.all(
                width: 1, color: colorPrimaryDark, style: BorderStyle.solid)),
        child: Row(
          spacing: 16,
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            Icon(Icons.watch_later_outlined,
                color: liveClassProvider.isFilter == value
                    ? white
                    : colorPrimaryDark,
                size: 20),
            MyText(
              text: title,
              multilanguage: true,
              fontsizeNormal: Dimens.textMedium,
              fontsizeWeb: Dimens.textTitle,
              fontwaight: FontWeight.w600,
              color: liveClassProvider.isFilter == value
                  ? white
                  : colorPrimaryDark,
            ),
            Icon(
                liveClassProvider.isFilter == value
                    ? Icons.arrow_drop_up
                    : Icons.arrow_drop_down,
                color: liveClassProvider.isFilter == value
                    ? white
                    : colorPrimaryDark,
                size: 20),
          ],
        ),
      ),
    );
  }

/* Course name Started */
  Widget courseNameData() {
    if (liveClassProvider.courseNameLoading) {
      return SingleChildScrollView(
          padding: MediaQuery.of(context).size.width > 1000
              ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
              : const EdgeInsets.fromLTRB(20, 0, 20, 0),
          scrollDirection: Axis.horizontal,
          physics: AlwaysScrollableScrollPhysics(),
          child: Wrap(
              spacing: 10,
              runSpacing: 10,
              children: List.generate(20, (index) {
                return Container(
                    padding: EdgeInsets.all(6),
                    decoration: BoxDecoration(
                        color: white,
                        border: Border.all(
                            width: 1,
                            color: colorPrimaryDark,
                            style: BorderStyle.solid),
                        borderRadius: BorderRadius.circular(10)),
                    child: CustomWidget.roundcorner(height: 25, width: 80));
              })));
    } else {
      if (liveClassProvider.courseNameModel.status == 200 &&
          (liveClassProvider.courseNameModel.result?.length ?? 0) > 0) {
        return SingleChildScrollView(
          padding: MediaQuery.of(context).size.width > 1000
              ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
              : const EdgeInsets.fromLTRB(20, 0, 20, 0),
          scrollDirection: Axis.horizontal,
          physics: AlwaysScrollableScrollPhysics(),
          child: Wrap(
            spacing: 10,
            runSpacing: 10,
            children: List.generate(
              liveClassProvider.courseNameModel.result?.length ?? 0,
              (index) {
                return InkWell(
                  onTap: () {
                    liveClassProvider.setCourseId(liveClassProvider
                            .courseNameModel.result?[index].id
                            .toString() ??
                        "");
                  },
                  splashColor: transparent,
                  focusColor: transparent,
                  hoverColor: transparent,
                  child: Container(
                    padding: EdgeInsets.all(6),
                    decoration: BoxDecoration(
                        color: liveClassProvider.courseId ==
                                (liveClassProvider
                                        .courseNameModel.result?[index].id
                                        .toString() ??
                                    "")
                            ? colorPrimaryDark
                            : white,
                        border: Border.all(
                            width: 1,
                            color: colorPrimaryDark,
                            style: BorderStyle.solid),
                        borderRadius: BorderRadius.circular(10)),
                    child: MyText(
                      text: liveClassProvider
                              .courseNameModel.result?[index].title ??
                          "",
                      multilanguage: false,
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textTitle,
                      fontwaight: FontWeight.w600,
                      color: liveClassProvider.courseId ==
                              (liveClassProvider
                                      .courseNameModel.result?[index].id
                                      .toString() ??
                                  "")
                          ? white
                          : black,
                    ),
                  ),
                );
              },
            ),
          ),
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget timeWidget() {
    return SingleChildScrollView(
      padding: MediaQuery.of(context).size.width > 1000
          ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
          : const EdgeInsets.fromLTRB(20, 0, 20, 0),
      physics: BouncingScrollPhysics(),
      scrollDirection: Axis.horizontal,
      child: Row(
        spacing: 10,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          _statusShow(
              onTap: () {
                liveClassProvider.setStatus("1");
              },
              value: "1",
              title: "scheduled"),
          _statusShow(
              onTap: () {
                liveClassProvider.setStatus("2");
              },
              value: "2",
              title: "ongoing"),
          _statusShow(
              onTap: () {
                liveClassProvider.setStatus("3");
              },
              value: "3",
              title: "completed"),
          _statusShow(
              onTap: () {
                liveClassProvider.setStatus("4");
              },
              value: "4",
              title: "cancelled"),
        ],
      ),
    );
  }

  Widget _statusShow({required VoidCallback onTap, String? title, value}) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: onTap,
      child: Container(
        alignment: Alignment.center,
        padding: EdgeInsets.fromLTRB(16, 12, 16, 12),
        decoration: BoxDecoration(
          color: liveClassProvider.classTimeStatus == value
              ? colorPrimaryDark
              : white,
          border: Border.all(
              width: 1, color: colorPrimaryDark, style: BorderStyle.solid),
          borderRadius: BorderRadius.circular(12),
        ),
        child: MyText(
          text: title ?? "",
          color: liveClassProvider.classTimeStatus == value
              ? white
              : colorPrimaryDark,
          multilanguage: true,
          fontsizeNormal: Dimens.textMedium,
          fontwaight: FontWeight.w500,
        ),
      ),
    );
  }

/* Search itam show */

  Widget _buildSearchItam() {
    if (liveClassProvider.searchLoding && !liveClassProvider.searchLoadmore) {
      return Padding(
        padding: MediaQuery.of(context).size.width > 1000
            ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
            : const EdgeInsets.fromLTRB(20, 0, 20, 0),
        child: _searchShimmer(),
      );
    } else {
      if (liveClassProvider.searchList != null &&
          (liveClassProvider.searchList?.length ?? 0) > 0) {
        return Padding(
          padding: MediaQuery.of(context).size.width > 1000
              ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
              : const EdgeInsets.fromLTRB(20, 0, 20, 0),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              _buildLiveSearchData(),
              if (liveClassProvider.searchLoadmore)
                SizedBox(
                  height: 50,
                  child: Utils.pageLoader(),
                )
              else
                const SizedBox.shrink(),
            ],
          ),
        );
      } else {
        return NoData();
      }
    }
  }

  Widget _buildLiveSearchData() {
    return ResponsiveGridList(
      minItemWidth: 200,
      maxItemsPerRow: Utils.customCrossAxisCount(
          context: context,
          height1600: 4,
          height1200: 3,
          height800: 2,
          height400: 1),
      minItemsPerRow: 1,
      listViewBuilderOptions: ListViewBuilderOptions(
          shrinkWrap: true,
          padding: EdgeInsets.zero,
          physics: NeverScrollableScrollPhysics()),
      children: List.generate(
        liveClassProvider.searchList?.length ?? 0,
        (index) {
          final commanList = liveClassProvider.searchList?[index];
          return Container(
            padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
            margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
            decoration: BoxDecoration(
                color: white,
                borderRadius: BorderRadius.circular(16),
                border: Border.all(width: 1, color: transparent),
                boxShadow: [
                  BoxShadow(
                      blurRadius: 4,
                      blurStyle: BlurStyle.solid,
                      offset: Offset(0, 4),
                      spreadRadius: 0,
                      color: transparent.withValues(alpha: 0.25))
                ]),
            child: Column(
              spacing: 10,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  mainAxisAlignment: MainAxisAlignment.start,
                  spacing: 5,
                  children: [
                    Container(
                      padding:
                          EdgeInsets.symmetric(horizontal: 10, vertical: 4),
                      decoration: BoxDecoration(
                          color: (commanList?.isFree.toString() ?? "") == "1" &&
                                  ((commanList?.isUserBuy.toString() ?? "") ==
                                      "0")
                              ? green
                              : red,
                          borderRadius: BorderRadius.circular(10)),
                      child: MyText(
                        text: (commanList?.isFree.toString() ?? "") == "1" &&
                                ((commanList?.isUserBuy.toString() ?? "") ==
                                    "0")
                            ? Locales.string(context, "free")
                            : commanList?.price.toString() ?? "",
                        color: white,
                        fontsizeNormal: Dimens.textSmall,
                        fontsizeWeb: Dimens.textTitle,
                        fontwaight: FontWeight.w600,
                      ),
                    ),
                    Container(
                      padding: EdgeInsets.symmetric(horizontal: 6, vertical: 4),
                      decoration: BoxDecoration(
                          color: liveTextColor,
                          borderRadius: BorderRadius.circular(7)),
                      child: MyText(
                        text: commanList?.title.toString() ?? "",
                        color: black,
                        fontsizeNormal: Dimens.textSmall,
                        fontsizeWeb: Dimens.textTitle,
                        fontwaight: FontWeight.w400,
                      ),
                    )
                  ],
                ),
                Stack(
                  alignment: Alignment.center,
                  children: [
                    Row(
                      spacing: 14,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        SizedBox(
                          width: 200,
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            spacing: 20,
                            children: [
                              MyText(
                                text: commanList?.courseTitle.toString() ?? "",
                                color: black,
                                fontsizeNormal: Dimens.textMedium,
                                fontsizeWeb: Dimens.textTitle,
                                fontwaight: FontWeight.w500,
                              ),
                              Row(
                                children: [
                                  ((commanList?.status.toString() ?? "") == "2")
                                      ? MyNetworkImage(
                                          imageUrl:
                                              "https://i.fbcd.co/products/resized/resized-750-500/2419-9ff351c8d3c2dcbe30da81041c911438a6559890b83490e3a1fd55f8e3b4fc06.jpg",
                                          radius: 0,
                                          imgHeight: 20,
                                          imgWidth: 20,
                                          fit: BoxFit.cover)
                                      : ((commanList?.status.toString() ??
                                                  "") ==
                                              "1")
                                          ? MyText(
                                              text: "start_on",
                                              multilanguage: true,
                                              color: black,
                                              fontsizeNormal: Dimens.textSmall,
                                              fontwaight: FontWeight.w400,
                                            )
                                          : SizedBox.shrink(),
                                  ((commanList?.status.toString() ?? "") ==
                                              "2" ||
                                          (commanList?.status.toString() ??
                                                  "") ==
                                              "1")
                                      ? SizedBox(width: 4)
                                      : SizedBox.shrink(),
                                  Flexible(
                                    fit: FlexFit.loose,
                                    child: (commanList?.status.toString() ??
                                                "") ==
                                            "1"
                                        ? Row(
                                            children: [
                                              Container(
                                                padding: EdgeInsets.symmetric(
                                                    horizontal: 6, vertical: 4),
                                                decoration: BoxDecoration(
                                                    color: red.withValues(
                                                        alpha: 0.2),
                                                    borderRadius:
                                                        BorderRadius.only(
                                                            topLeft: Radius
                                                                .circular(7),
                                                            bottomLeft:
                                                                Radius.circular(
                                                                    7))),
                                                child: MyText(
                                                    text: commanList
                                                            ?.startedDate ??
                                                        "",
                                                    multilanguage: false,
                                                    color: red,
                                                    fontsizeNormal:
                                                        Dimens.textSmall,
                                                    fontwaight:
                                                        FontWeight.w400),
                                              ),
                                              Container(
                                                padding: EdgeInsets.symmetric(
                                                    horizontal: 6, vertical: 4),
                                                decoration: BoxDecoration(
                                                    color: red.withValues(
                                                        alpha: 0.6),
                                                    borderRadius:
                                                        BorderRadius.only(
                                                            topRight: Radius
                                                                .circular(7),
                                                            bottomRight:
                                                                Radius.circular(
                                                                    7))),
                                                child: MyText(
                                                  text: commanList?.startTime ??
                                                      "",
                                                  multilanguage: false,
                                                  color: white,
                                                  fontsizeNormal:
                                                      Dimens.textSmall,
                                                  fontwaight: FontWeight.w400,
                                                ),
                                              ),
                                            ],
                                          )
                                        : Container(
                                            padding: EdgeInsets.symmetric(
                                                horizontal: 6, vertical: 4),
                                            decoration: BoxDecoration(
                                                gradient: LinearGradient(
                                                    colors: [
                                                      red.withValues(
                                                          alpha: 0.5),
                                                      red.withValues(alpha: 0.6)
                                                    ],
                                                    tileMode: TileMode.mirror,
                                                    begin: Alignment.topCenter,
                                                    end:
                                                        Alignment.bottomCenter),
                                                borderRadius:
                                                    BorderRadius.circular(7)),
                                            child: MyText(
                                              text: (commanList?.status
                                                              .toString() ??
                                                          "") ==
                                                      "2"
                                                  ? "live_now"
                                                  : (commanList?.status
                                                                  .toString() ??
                                                              "") ==
                                                          "3"
                                                      ? "completed"
                                                      : "cancelled",
                                              multilanguage: true,
                                              color: black,
                                              fontsizeNormal: Dimens.textSmall,
                                              fontsizeWeb: Dimens.textTitle,
                                              fontwaight: FontWeight.w400,
                                            ),
                                          ),
                                  ),
                                ],
                              )
                            ],
                          ),
                        ),
                      ],
                    ),
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.end,
                      children: [
                        MyNetworkImage(
                            imageUrl:
                                commanList?.lecturerImage.toString() ?? "",
                            radius: 10,
                            imgHeight: 100,
                            imgWidth: 100,
                            fit: BoxFit.cover),
                        SizedBox(height: 2),
                        ClipPath(
                          clipper: LeftDiagonalClipper(),
                          child: Container(
                            padding: EdgeInsets.fromLTRB(
                                18, 4, 6, 4), // increased left padding

                            decoration: BoxDecoration(
                              color: black,
                            ),
                            child: MyText(
                              text: commanList?.lecturerName.toString() ?? "",
                              color: white,
                              fontsizeNormal: Dimens.textSmall,
                              fontsizeWeb: Dimens.textTitle,
                              fontwaight: FontWeight.w600,
                            ),
                          ),
                        ),
                        Container(
                          height: 1,
                          width: width,
                          color: gray,
                        ),
                      ],
                    ),
                  ],
                ),
                Row(
                  spacing: 20,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Expanded(
                        child: btnWidget(
                      text: "remind_me",
                      color: colorPrimaryDark,
                      textColor: white,
                      borderColor: colorPrimaryDark,
                    )),
                    Expanded(
                        child: btnWidget(
                      onTap: () {
                        if (Utils.checkLoginUser(context)) {
                          if ((commanList?.isFree.toString() ?? "") == "1" &&
                              ((commanList?.isUserBuy.toString() ?? "") ==
                                  "0")) {
                            Utils.lanchUrl(
                                commanList?.meetingLink.toString() ?? "");
                          } else {
                            Navigator.of(context).push(
                              PageRouteBuilder(
                                pageBuilder:
                                    (context, animation, secondaryAnimation) =>
                                        AllPayment(
                                  contentType: "3",
                                  payType: 'Package',
                                  itemId: commanList?.id.toString() ?? "",
                                  price: commanList?.price.toString() ?? "",
                                  itemTitle: commanList?.title.toString() ?? "",
                                ),
                                transitionsBuilder: (context, animation,
                                    secondaryAnimation, child) {
                                  const begin = Offset(1.0, 0.0);
                                  const end = Offset.zero;
                                  const curve = Curves.ease;

                                  var tween = Tween(begin: begin, end: end)
                                      .chain(CurveTween(curve: curve));

                                  return SlideTransition(
                                    position: animation.drive(tween),
                                    child: child,
                                  );
                                },
                              ),
                            );
                          }
                        }
                      },
                      text: "jion_this_class",
                      color: white,
                      textColor: colorPrimaryDark,
                      borderColor: colorPrimaryDark,
                    ))
                  ],
                )
              ],
            ),
          );
        },
      ),
    );
  }

  Widget _searchShimmer() {
    return ResponsiveGridList(
        minItemWidth: 200,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 4,
            height1200: 3,
            height800: 2,
            height400: 1),
        minItemsPerRow: 1,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            padding: EdgeInsets.zero,
            physics: NeverScrollableScrollPhysics()),
        children: List.generate(
          10,
          (index) {
            return Container(
              padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
              margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
              decoration: BoxDecoration(
                  color: white,
                  borderRadius: BorderRadius.circular(16),
                  border: Border.all(width: 1, color: transparent),
                  boxShadow: [
                    BoxShadow(
                        blurRadius: 4,
                        blurStyle: BlurStyle.solid,
                        offset: Offset(0, 4),
                        spreadRadius: 0,
                        color: transparent.withValues(alpha: 0.25))
                  ]),
              child: Column(
                spacing: 10,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.start,
                    spacing: 5,
                    children: [
                      Container(
                        padding:
                            EdgeInsets.symmetric(horizontal: 10, vertical: 4),
                        decoration: BoxDecoration(
                            color: green,
                            borderRadius: BorderRadius.circular(14)),
                        child: CustomWidget.roundcorner(height: 4, width: 50),
                      ),
                      Container(
                        padding:
                            EdgeInsets.symmetric(horizontal: 6, vertical: 4),
                        decoration: BoxDecoration(
                            color: liveTextColor,
                            borderRadius: BorderRadius.circular(7)),
                        child: CustomWidget.roundcorner(height: 4, width: 100),
                      )
                    ],
                  ),
                  Stack(
                    alignment: Alignment.center,
                    children: [
                      Row(
                        spacing: 14,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          SizedBox(
                            width: 200,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              spacing: 20,
                              children: [
                                CustomWidget.roundcorner(
                                    height: 14, width: 120),
                                Row(
                                  spacing: 4,
                                  children: [
                                    CustomWidget.roundcorner(
                                        height: 14, width: 50),
                                    Expanded(
                                      child: Container(
                                        padding: EdgeInsets.symmetric(
                                            horizontal: 6, vertical: 4),
                                        decoration: BoxDecoration(
                                            gradient: LinearGradient(
                                                colors: [
                                                  red.withValues(alpha: 0.5),
                                                  red.withValues(alpha: 0.6)
                                                ],
                                                tileMode: TileMode.mirror,
                                                begin: Alignment.topCenter,
                                                end: Alignment.bottomCenter),
                                            borderRadius:
                                                BorderRadius.circular(7)),
                                        child: CustomWidget.roundcorner(
                                            height: 14, width: 120),
                                      ),
                                    ),
                                  ],
                                )
                              ],
                            ),
                          ),
                        ],
                      ),
                      SizedBox(height: 2),
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.end,
                        children: [
                          CustomWidget.roundcorner(height: 100, width: 100),
                          SizedBox(height: 2),
                          ClipPath(
                            clipper: LeftDiagonalClipper(),
                            child: Container(
                              padding: EdgeInsets.fromLTRB(
                                  18, 4, 6, 4), // increased left padding

                              decoration: BoxDecoration(
                                color: black,
                              ),
                              child: CustomWidget.roundcorner(
                                  height: 14, width: 120),
                            ),
                          ),
                          Container(
                            height: 1,
                            width: width,
                            color: gray,
                          ),
                        ],
                      ),
                    ],
                  ),
                  Row(
                    spacing: 20,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        child: CustomWidget.roundcorner(height: 30, width: 120),
                      ),
                      Expanded(
                        child: CustomWidget.roundcorner(height: 30, width: 120),
                      )
                    ],
                  )
                ],
              ),
            );
          },
        ));
  }
/* Search Live class END */

  Widget landscapeShimmer() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        CustomWidget.roundrectborder(height: 10, width: 150),
        SizedBox(height: 5),
        CustomWidget.roundrectborder(height: 10, width: 80),
        SingleChildScrollView(
          padding: EdgeInsets.zero,
          scrollDirection: Axis.horizontal,
          physics: BouncingScrollPhysics(),
          child: Row(
            children: List.generate(
              10,
              (index) {
                return Container(
                  padding:
                      const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
                  width: 320,
                  margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
                  decoration: BoxDecoration(
                      color: white,
                      borderRadius: BorderRadius.circular(16),
                      border: Border.all(width: 1, color: transparent),
                      boxShadow: [
                        BoxShadow(
                            blurRadius: 4,
                            blurStyle: BlurStyle.solid,
                            offset: Offset(0, 4),
                            spreadRadius: 0,
                            color: transparent.withValues(alpha: 0.25))
                      ]),
                  child: Column(
                    spacing: 10,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.start,
                        spacing: 5,
                        children: [
                          Container(
                            padding: EdgeInsets.symmetric(
                                horizontal: 10, vertical: 4),
                            decoration: BoxDecoration(
                                color: green,
                                borderRadius: BorderRadius.circular(14)),
                            child:
                                CustomWidget.roundcorner(height: 4, width: 50),
                          ),
                          Container(
                            padding: EdgeInsets.symmetric(
                                horizontal: 6, vertical: 4),
                            decoration: BoxDecoration(
                                color: liveTextColor,
                                borderRadius: BorderRadius.circular(7)),
                            child:
                                CustomWidget.roundcorner(height: 4, width: 100),
                          )
                        ],
                      ),
                      Stack(
                        alignment: Alignment.center,
                        children: [
                          Row(
                            spacing: 14,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: [
                              SizedBox(
                                width: 160,
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  spacing: 20,
                                  children: [
                                    CustomWidget.roundcorner(
                                        height: 14, width: 120),
                                    Row(
                                      spacing: 4,
                                      children: [
                                        CustomWidget.roundcorner(
                                            height: 14, width: 50),
                                        Expanded(
                                          child: Container(
                                            padding: EdgeInsets.symmetric(
                                                horizontal: 6, vertical: 4),
                                            decoration: BoxDecoration(
                                                gradient: LinearGradient(
                                                    colors: [
                                                      red.withValues(
                                                          alpha: 0.5),
                                                      red.withValues(alpha: 0.6)
                                                    ],
                                                    tileMode: TileMode.mirror,
                                                    begin: Alignment.topCenter,
                                                    end:
                                                        Alignment.bottomCenter),
                                                borderRadius:
                                                    BorderRadius.circular(7)),
                                            child: CustomWidget.roundcorner(
                                                height: 14, width: 120),
                                          ),
                                        ),
                                      ],
                                    )
                                  ],
                                ),
                              ),
                            ],
                          ),
                          SizedBox(height: 2),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.end,
                            children: [
                              CustomWidget.roundcorner(height: 100, width: 100),
                              SizedBox(height: 2),
                              ClipPath(
                                clipper: LeftDiagonalClipper(),
                                child: Container(
                                  padding: EdgeInsets.fromLTRB(
                                      18, 4, 6, 4), // increased left padding

                                  decoration: BoxDecoration(
                                    color: black,
                                  ),
                                  child: CustomWidget.roundcorner(
                                      height: 14, width: 120),
                                ),
                              ),
                              Container(
                                height: 1,
                                width: width,
                                color: gray,
                              ),
                            ],
                          ),
                        ],
                      ),
                      Row(
                        spacing: 20,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Expanded(
                            child: CustomWidget.roundcorner(
                                height: 30, width: 120),
                          ),
                          Expanded(
                            child: CustomWidget.roundcorner(
                                height: 30, width: 120),
                          )
                        ],
                      )
                    ],
                  ),
                );
              },
            ),
          ),
        ),
      ],
    );
  }

  Widget recordingPortriatShimmer() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        CustomWidget.roundrectborder(height: 10, width: 200),
        SizedBox(height: 5),
        CustomWidget.roundrectborder(height: 10, width: 130),
        SingleChildScrollView(
            scrollDirection: Axis.horizontal,
            padding: EdgeInsets.zero,
            physics: BouncingScrollPhysics(),
            child: Row(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: List.generate(
                  5,
                  (index) {
                    return Container(
                      padding: const EdgeInsets.symmetric(
                          horizontal: 16, vertical: 14),
                      width: 320,
                      margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
                      decoration: BoxDecoration(
                          color: white,
                          borderRadius: BorderRadius.circular(16),
                          border: Border.all(width: 1, color: transparent),
                          boxShadow: [
                            BoxShadow(
                                blurRadius: 4,
                                blurStyle: BlurStyle.solid,
                                offset: Offset(0, 4),
                                spreadRadius: 0,
                                color: transparent.withValues(alpha: 0.25))
                          ]),
                      child: Row(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        spacing: 20,
                        children: [
                          CustomWidget.roundcorner(height: 80, width: 90),
                          Expanded(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              spacing: 10,
                              children: [
                                CustomWidget.roundcorner(
                                    height: 10, width: 130),
                                CustomWidget.roundcorner(
                                    height: 10, width: 130),
                                CustomWidget.roundcorner(
                                    height: 10, width: 130),
                                CustomWidget.roundcorner(height: 30, width: 80)
                              ],
                            ),
                          ),
                        ],
                      ),
                    );
                  },
                ))),
      ],
    );
  }
}
