import 'package:carousel_slider/carousel_slider.dart';
import 'package:dotted_border/dotted_border.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/provider/homeprovider.dart';
import 'package:prakah/provider/profileprovider.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webblogdetail.dart';
import 'package:prakah/webpages/webdetails.dart';
import 'package:prakah/webpages/webebookdetail.dart';
import 'package:prakah/webpages/websearch.dart';
import 'package:prakah/webpages/webtutorprofile.dart';
import 'package:prakah/webpages/webvideobyidviewall.dart';
import 'package:prakah/webpages/webviewall.dart';
import 'package:prakah/webwidget/footerweb.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:flutter_rating_bar/flutter_rating_bar.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';
import '../model/sectionlistmodel.dart';

class WebHome extends StatefulWidget {
  const WebHome({super.key});

  @override
  State<WebHome> createState() => WebHomeState();
}

class WebHomeState extends State<WebHome> {
  CarouselSliderController pageController = CarouselSliderController();
  final ScrollController _scrollController = ScrollController();
  double? width;
  double? height;
  HomeProvider homeProvider = HomeProvider();
  GeneralProvider generalProvider = GeneralProvider();
  ProfileProvider profileProvider = ProfileProvider();
  final searchController = TextEditingController();
  List<Color> colorList = [
    colorPrimary,
    red,
    green,
    gray,
    colorPrimaryDark,
    colorAccent,
  ];

  @override
  void initState() {
    super.initState();
    homeProvider = Provider.of<HomeProvider>(context, listen: false);
    generalProvider = Provider.of<GeneralProvider>(context, listen: false);
    profileProvider = Provider.of<ProfileProvider>(context, listen: false);

    _scrollController.addListener(_scrollListener);
    getProfileData();

    _fetchData(0);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange) {
      if ((homeProvider.sectioncurrentPage ?? 0) <
          (homeProvider.sectiontotalPage ?? 0)) {
        homeProvider.setLoadMore(true);
        _fetchData(homeProvider.sectioncurrentPage ?? 0);
      }
    }
  }

  Future<void> _fetchData(int? nextPage) async {
    await homeProvider.getSeactionList((nextPage ?? 0) + 1);
  }

/* Device Tocken */
  Future<void> getProfileData() async {
    await generalProvider.getGeneralsetting(context);
    if (!mounted) return;
    await profileProvider.getprofile(context);

    if (!mounted) return;
    Utils().getDeviceTokenWithPermissionWeb();
  }

  double getResponsiveImageWidth(BuildContext context) {
    double width = MediaQuery.of(context).size.width;

    if (width > 1400) {
      return width * 0.35;
    } else if (width > 1200) {
      return width * 0.25;
    } else if (width > 992) {
      return width * 0.16;
    } else if (width > 768) {
      return width * 0.12;
    } else {
      return width; // Full width on small screens
    }
  }

  @override
  void dispose() {
    _scrollController.dispose();
    _scrollController.removeListener(_scrollListener);
    homeProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.of(context).size.width;
    height = MediaQuery.of(context).size.height;
    return _buildSearchHome();
  }

/* Home and Search Data Both show */

  Widget _buildSearchHome() {
    return Consumer<SearchProvider>(builder: (context, homeprovider, child) {
      if (homeprovider.isSearch == "0") {
        return Scaffold(
          appBar: Utils.webMainAppbar(controller: searchController),
          body: Utils.hoverItemWithPage(
            myWidget: SingleChildScrollView(
              controller: _scrollController,
              physics: const AlwaysScrollableScrollPhysics(),
              padding: EdgeInsets.only(top: 10),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  // Utils.childPanel(context),

                  buildPage(),
                  const FooterWeb(),
                ],
              ),
            ),
          ),
        );
      } else {
        return WebSearch(
          searchController: searchController,
        );
      }
    });
  }

  Widget buildPage() {
    return Consumer<HomeProvider>(builder: (context, homeprovider, child) {
      if (homeProvider.loading && !homeProvider.loadmore) {
        return commanShimmer();
      } else {
        return Column(
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            setSectionByType(),
            if (homeProvider.loadmore)
              SizedBox(height: 50, child: Utils.pageLoader())
            else
              const SizedBox.shrink(),
            const SizedBox(height: 20)
          ],
        );
      }
    });
  }

  Widget setSectionByType() {
    if (homeProvider.sectionListModel.status == 200 &&
        homeProvider.sectionList != null) {
      if ((homeProvider.sectionList?.length ?? 0) > 0) {
        return MediaQuery.removePadding(
          context: context,
          removeTop: true,
          child: ListView.builder(
            itemCount: homeProvider.sectionList?.length ?? 0,
            shrinkWrap: true,
            reverse: false,
            padding: EdgeInsets.zero,
            physics: const NeverScrollableScrollPhysics(),
            itemBuilder: (BuildContext context, int index) {
              if (homeProvider.sectionList?[index].data != null &&
                  (homeProvider.sectionList?[index].data?.length ?? 0) > 0) {
                return Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    // Section Title
                    homeProvider.sectionList?[index].screenLayout == "banner"
                        ? const SizedBox.shrink()
                        : Padding(
                            padding: MediaQuery.of(context).size.width > 1000
                                ? const EdgeInsets.fromLTRB(200, 25, 200, 0)
                                : const EdgeInsets.fromLTRB(20, 25, 20, 0),
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Expanded(
                                  child: Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      MyText(
                                          color: Theme.of(context)
                                              .colorScheme
                                              .surface,
                                          text: homeProvider
                                                  .sectionList?[index].title
                                                  .toString() ??
                                              "",
                                          fontsizeNormal: Dimens.textExtraBig,
                                          fontsizeWeb: Dimens.textExtraBig,
                                          fontwaight: FontWeight.w600,
                                          maxline: 1,
                                          textalign: TextAlign.start,
                                          fontstyle: FontStyle.normal,
                                          multilanguage: false),
                                      const SizedBox(height: 8),
                                      ((homeProvider.sectionList?[index]
                                                      .shortTitle
                                                      .toString() ??
                                                  "")
                                              .isEmpty)
                                          ? SizedBox.shrink()
                                          : MyText(
                                              color: gray,
                                              multilanguage: false,
                                              text: homeProvider
                                                      .sectionList?[index]
                                                      .shortTitle
                                                      .toString() ??
                                                  "",
                                              textalign: TextAlign.center,
                                              fontsizeNormal: Dimens.textMedium,
                                              fontsizeWeb: Dimens.textMedium,
                                              maxline: 1,
                                              fontwaight: FontWeight.w400,
                                              fontstyle: FontStyle.normal),
                                    ],
                                  ),
                                ),
                                homeProvider.sectionList?[index].viewAll == 1
                                    ? InkWell(
                                        hoverColor: transparent,
                                        highlightColor: transparent,
                                        onTap: () {
                                          Utils.navigatePage(
                                              context,
                                              WebViewAll(
                                                screenLayout: homeProvider
                                                        .sectionList?[index]
                                                        .screenLayout
                                                        .toString() ??
                                                    "",
                                                viewAllType: "section",
                                                title: homeProvider
                                                        .sectionList?[index]
                                                        .title
                                                        .toString() ??
                                                    "",
                                                contentId: homeProvider
                                                        .sectionList?[index].id
                                                        .toString() ??
                                                    "",
                                              ),
                                              "2");
                                        },
                                        child: Container(
                                          padding: const EdgeInsets.fromLTRB(
                                              20, 12, 20, 12),
                                          decoration: BoxDecoration(
                                            border: Border.all(
                                                width: 0.5, color: black),
                                            color: transparent,
                                            borderRadius:
                                                BorderRadius.circular(50),
                                          ),
                                          child: MyText(
                                              color: Theme.of(context)
                                                  .colorScheme
                                                  .surface,
                                              text: "more",
                                              fontsizeNormal: Dimens.textTitle,
                                              fontsizeWeb: Dimens.textTitle,
                                              fontwaight: FontWeight.w500,
                                              maxline: 1,
                                              textalign: TextAlign.right,
                                              fontstyle: FontStyle.normal,
                                              multilanguage: true),
                                        ))
                                    : const SizedBox.shrink(),
                              ],
                            ),
                          ),
                    homeProvider.sectionList?[index].screenLayout == "banner"
                        ? const SizedBox.shrink()
                        : const SizedBox(height: 12),
                    // Section Data List
                    homeProvider.sectionList?[index].screenLayout == "list_view"
                        ? listView(index, homeProvider.sectionList)
                        : setSectionData(
                            index: index, sectionList: homeProvider.sectionList)
                  ],
                );
              } else {
                return const SizedBox.shrink();
              }
            },
          ),
        );
      } else {
        return const NoData();
      }
    } else {
      return const NoData();
    }
  }

  Widget setSectionData(
      {required int index, required List<Result>? sectionList}) {
    if ((sectionList?[index].screenLayout.toString() ?? "") == "banner") {
      return buildBanner(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "landscape") {
      return landscap(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "portrait") {
      return portrait(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "list_view") {
      return listView(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "category") {
      return category(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "language") {
      return language(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") == "tutor") {
      return buildTutor(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") == "blog") {
      return buildBlog(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") == "book") {
      return buildBook(index, sectionList);
    } else {
      return const SizedBox.shrink();
    }
  }

  /* Banner */

  Widget buildBanner(int sectionindex, List<Result>? sectionList) {
    if (MediaQuery.of(context).size.width > 700) {
      return buildWebBanner(sectionindex, sectionList);
    } else {
      return Padding(
        padding: MediaQuery.of(context).size.width > 1000
            ? const EdgeInsets.fromLTRB(200, 20, 200, 0)
            : const EdgeInsets.fromLTRB(20, 20, 20, 0),
        child: buildMobileBanner(sectionindex, sectionList),
      );
    }
  }

  Widget buildWebBanner(int sectionindex, List<Result>? sectionList) {
    return Stack(
      children: [
        Container(
          width: MediaQuery.of(context).size.width,
          height: 500,
          padding: MediaQuery.of(context).size.width > 800
              ? const EdgeInsets.fromLTRB(40, 0, 0, 0)
              : const EdgeInsets.fromLTRB(20, 0, 0, 0),
          margin: MediaQuery.of(context).size.width > 1000
              ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
              : const EdgeInsets.fromLTRB(20, 0, 20, 0),
          decoration: BoxDecoration(
              image: DecorationImage(
                  image: AssetImage('assets/images/banner_back.png'),
                  fit: BoxFit.fill)),
          child: CarouselSlider.builder(
            itemCount: sectionList?[sectionindex].data?.length ?? 0,
            carouselController: pageController,
            options: CarouselOptions(
              initialPage: 0,
              height: MediaQuery.of(context).size.height,
              enlargeCenterPage: false,
              enlargeStrategy: CenterPageEnlargeStrategy.zoom,
              autoPlay: true,
              autoPlayCurve: Curves.linear,
              enableInfiniteScroll: true,
              viewportFraction: 1.0,
              autoPlayInterval: const Duration(seconds: 5),
              autoPlayAnimationDuration: const Duration(seconds: 3),
              onPageChanged: (index, reason) {
                homeProvider.setCurrentBanner(index);
              },
            ),
            itemBuilder: (BuildContext context, int index, int pageViewIndex) {
              return InkWell(
                hoverColor: transparent,
                highlightColor: transparent,
                splashColor: transparent,
                focusColor: transparent,
                onTap: () {
                  Utils.navigatePage(
                      context,
                      WebDetail(
                          courseId: sectionList?[sectionindex]
                                  .data?[index]
                                  .id
                                  .toString() ??
                              ""),
                      "2");
                },
                child: Stack(
                  alignment: Alignment.bottomCenter,
                  children: [
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      spacing: 20,
                      children: [
                        Expanded(
                          child: Padding(
                            padding: const EdgeInsets.only(left: 20, top: 70),
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              spacing: 20,
                              children: [
                                MyText(
                                    color: colorPrimary,
                                    text: sectionList?[sectionindex]
                                            .data?[index]
                                            .title
                                            .toString() ??
                                        "",
                                    fontsizeNormal: Dimens.textExtralargeBig,
                                    fontsizeWeb: Dimens.textExtralargeBig,
                                    fontwaight: FontWeight.w700,
                                    maxline: 3,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                                MyText(
                                    color:
                                        Theme.of(context).colorScheme.surface,
                                    text: sectionList?[sectionindex]
                                            .data?[index]
                                            .description
                                            .toString() ??
                                        "",
                                    fontsizeNormal: Dimens.textTitle,
                                    fontsizeWeb: Dimens.textTitle,
                                    fontwaight: FontWeight.w400,
                                    maxline: 4,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                                Container(
                                  padding: EdgeInsets.fromLTRB(10, 4, 10, 4),
                                  decoration: BoxDecoration(
                                      color: colorPrimary,
                                      borderRadius: BorderRadius.circular(30)),
                                  child: Row(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    spacing: 20,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    mainAxisSize: MainAxisSize.min,
                                    children: [
                                      MyText(
                                          color: white,
                                          text: "Find Course",
                                          fontsizeNormal: Dimens.textTitle,
                                          fontsizeWeb: Dimens.textTitle,
                                          fontwaight: FontWeight.w400,
                                          maxline: 4,
                                          textalign: TextAlign.left,
                                          fontstyle: FontStyle.normal),
                                      Container(
                                        height: 40,
                                        width: 40,
                                        decoration: BoxDecoration(
                                          color: colorPrimaryDark,
                                          shape: BoxShape.circle,
                                        ),
                                        child: Icon(
                                          Icons.arrow_forward,
                                          size: 16,
                                          color: white,
                                        ),
                                      ),
                                    ],
                                  ),
                                )
                              ],
                            ),
                          ),
                        ),
                        Expanded(
                          child: MyNetworkImage(
                              radius: 15,
                              islandscap: true,
                              imgWidth: getResponsiveImageWidth(context),
                              imgHeight: MediaQuery.sizeOf(context).height,
                              fit: MediaQuery.of(context).size.width > 800
                                  ? BoxFit.fill
                                  : BoxFit.cover,
                              imageUrl: sectionList?[sectionindex]
                                      .data?[index]
                                      .landscapeImg
                                      .toString() ??
                                  ""),
                        ),
                      ],
                    ),
                    Positioned(
                      bottom: 60,
                      child: Container(
                        height: 100,
                        width: 250,
                        alignment: Alignment.center,
                        decoration: BoxDecoration(
                            color: white,
                            borderRadius: BorderRadius.circular(12),
                            boxShadow: [
                              BoxShadow(
                                color: colorPrimary.withValues(alpha: 0.2),
                                blurRadius: 10,
                                spreadRadius: 2,
                              ),
                            ]),
                        child: Column(
                          mainAxisSize: MainAxisSize.min,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          spacing: 18,
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                MyText(
                                    color: colorPrimary,
                                    text: Utils.kmbGenerator(int.parse(
                                        sectionList?[sectionindex]
                                                .data?[index]
                                                .totalView
                                                .toString() ??
                                            "")),
                                    fontsizeNormal: Dimens.textExtraBig,
                                    fontsizeWeb: Dimens.textExtraBig,
                                    fontwaight: FontWeight.w500,
                                    maxline: 1,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                                const SizedBox(width: 8),
                                MyText(
                                    color: colorPrimary,
                                    text: "students",
                                    fontsizeNormal: Dimens.textExtraBig,
                                    fontsizeWeb: Dimens.textExtraBig,
                                    fontwaight: FontWeight.w500,
                                    maxline: 1,
                                    multilanguage: true,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
              );
            },
          ),
        ),
      ],
    );
  }

  Widget buildMobileBanner(int sectionindex, List<Result>? sectionList) {
    return SizedBox(
      width: MediaQuery.of(context).size.width,
      height: 280,
      child: CarouselSlider.builder(
        itemCount: sectionList?[sectionindex].data?.length ?? 0,
        options: CarouselOptions(
          height: MediaQuery.of(context).size.height,
          enlargeCenterPage: true,
          enlargeStrategy: CenterPageEnlargeStrategy.zoom,
          autoPlay: true,
          autoPlayCurve: Curves.linear,
          enableInfiniteScroll: true,
          autoPlayInterval: const Duration(seconds: 5),
          autoPlayAnimationDuration: const Duration(seconds: 1),
          viewportFraction: 0.8,
          onPageChanged: (index, reason) {
            homeProvider.setInde(index);
          },
        ),
        itemBuilder: (BuildContext context, int index, int pageViewIndex) {
          return InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            highlightColor: transparent,
            onTap: () {
              Utils.navigatePage(
                  context,
                  WebDetail(
                      courseId: sectionList?[sectionindex]
                              .data?[index]
                              .id
                              .toString() ??
                          ""),
                  "2");
            },
            child: Container(
              margin: EdgeInsets.only(
                  right: 10, left: 0.0, top: 10.0, bottom: 12.0),
              padding: EdgeInsets.zero,
              decoration: BoxDecoration(
                color: white,
                borderRadius: BorderRadius.circular(15),
                boxShadow: [
                  BoxShadow(
                    blurRadius: 4,
                    color: transparent.withValues(alpha: 0.17),
                  )
                ],
              ),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 6,
                children: [
                  ClipRRect(
                    borderRadius: BorderRadius.only(
                        topLeft: Radius.circular(15),
                        topRight: Radius.circular(15)),
                    child: MyNetworkImage(
                        islandscap: true,
                        imgWidth: MediaQuery.of(context).size.width,
                        imgHeight: 180,
                        fit: BoxFit.fill,
                        imageUrl: sectionList?[sectionindex]
                                .data?[index]
                                .landscapeImg
                                .toString() ??
                            ""),
                  ),
                  Padding(
                    padding: const EdgeInsets.fromLTRB(10, 0, 10, 6),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        MyText(
                            color: black,
                            text: sectionList?[sectionindex]
                                    .data?[index]
                                    .title
                                    .toString() ??
                                "",
                            fontsizeNormal: Dimens.textMedium,
                            fontwaight: FontWeight.w600,
                            maxline: 1,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        MyText(
                            color: black,
                            text:
                                "${Utils.kmbGenerator(sectionList?[sectionindex].data?[index].totalView ?? 0)} Students",
                            fontsizeNormal: Dimens.textMedium,
                            fontwaight: FontWeight.w600,
                            maxline: 1,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          spacing: 4,
                          children: [
                            MyRating(
                                rating: double.parse(sectionList?[sectionindex]
                                        .data?[index]
                                        .avgRating
                                        .toString() ??
                                    ""),
                                spacing: 5,
                                size: 15),
                            MyText(
                                color: colorAccent,
                                text:
                                    "${double.parse(sectionList?[sectionindex].data?[index].avgRating.toString() ?? "")}",
                                fontsizeNormal: Dimens.textMedium,
                                fontwaight: FontWeight.w600,
                                maxline: 1,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ],
                        ),
                      ],
                    ),
                  )
                ],
              ),
            ),
          );
        },
      ),
    );
  }

  Widget bannerShimmer() {
    if (MediaQuery.of(context).size.width > 800) {
      return Stack(
        children: [
          Container(
            width: MediaQuery.of(context).size.width,
            height: 500,
            padding: MediaQuery.of(context).size.width > 800
                ? const EdgeInsets.fromLTRB(40, 0, 0, 0)
                : const EdgeInsets.fromLTRB(20, 0, 0, 0),
            margin: MediaQuery.of(context).size.width > 1000
                ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
                : const EdgeInsets.fromLTRB(20, 0, 20, 0),
            decoration: BoxDecoration(
                image: DecorationImage(
                    image: AssetImage('assets/images/banner_back.png'),
                    fit: BoxFit.fill)),
            child: PageView.builder(
              itemCount: 10,
              allowImplicitScrolling: true,
              itemBuilder: (BuildContext context, int index) {
                return Padding(
                  padding: EdgeInsets.only(left: 20, right: 20),
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    spacing: 20,
                    children: [
                      Expanded(
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.center,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            CustomWidget.roundrectborder(
                                height: 15,
                                width: MediaQuery.sizeOf(context).width),
                            CustomWidget.roundrectborder(
                                height: 15,
                                width: MediaQuery.sizeOf(context).width),
                            CustomWidget.roundrectborder(
                                height: 15,
                                width: MediaQuery.sizeOf(context).width),
                            CustomWidget.roundrectborder(
                                height: 10,
                                width: MediaQuery.sizeOf(context).width),
                            CustomWidget.roundrectborder(
                                height: 10,
                                width: MediaQuery.sizeOf(context).width),
                            SizedBox(height: 15),
                            CustomWidget.roundrectborder(
                                height: 30, width: 200),
                            SizedBox(height: 15),
                            CustomWidget.roundrectborder(
                                height: 10, width: 350),
                          ],
                        ),
                      ),
                      CustomWidget.roundcorner(
                        width: 420,
                        height: MediaQuery.sizeOf(context).height,
                      ),
                    ],
                  ),
                );
              },
            ),
          ),
        ],
      );
    } else {
      return SizedBox(
        width: MediaQuery.of(context).size.width,
        height: 300,
        child: CarouselSlider.builder(
          itemCount: 10,
          options: CarouselOptions(
            initialPage: 0,
            height: MediaQuery.of(context).size.height,
            enlargeCenterPage: true,
            enlargeStrategy: CenterPageEnlargeStrategy.zoom,
            autoPlay: false,
            autoPlayCurve: Curves.linear,
            enableInfiniteScroll: true,
            autoPlayInterval: const Duration(seconds: 5),
            autoPlayAnimationDuration: const Duration(seconds: 3),
            viewportFraction: 0.7,
            onPageChanged: (index, reason) async {},
          ),
          itemBuilder: (BuildContext context, int index, int pageViewIndex) {
            return Container(
              margin: const EdgeInsets.fromLTRB(5, 15, 5, 15),
              decoration: BoxDecoration(
                color: Theme.of(context).cardColor,
                borderRadius: BorderRadius.circular(5),
                boxShadow: [
                  BoxShadow(
                    color: Colors.grey.withValues(alpha: 0.08),
                    spreadRadius: 1.5,
                    blurRadius: 0.5,
                    offset: const Offset(0, 1),
                  ),
                ],
              ),
              child: Column(
                children: [
                  CustomWidget.roundrectborder(
                    width: MediaQuery.of(context).size.width,
                    height: 150,
                  ),
                  Padding(
                    padding: const EdgeInsets.fromLTRB(8, 10, 8, 10),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        CustomWidget.roundrectborder(
                          width: MediaQuery.of(context).size.width,
                          height: 5,
                        ),
                        const SizedBox(height: 5),
                        const CustomWidget.roundrectborder(
                          width: 100,
                          height: 5,
                        ),
                        const SizedBox(height: 4),
                        const CustomWidget.roundrectborder(
                          width: 200,
                          height: 5,
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            );
          },
        ),
      );
    }
  }

  /* Category */

  Widget category(int sectionindex, List<Result>? sectionList) {
    return ResponsiveGridList(
      minItemWidth: 200,
      minItemsPerRow: Utils.customCrossAxisCount(
          context: context,
          height1600: 6,
          height1200: 4,
          height800: 3,
          height400: 3),
      maxItemsPerRow: Utils.customCrossAxisCount(
          context: context,
          height1600: 8,
          height1200: 6,
          height800: 4,
          height400: 4),
      horizontalGridMargin: MediaQuery.of(context).size.width > 1000 ? 200 : 20,
      verticalGridMargin: 0,
      verticalGridSpacing: 16,
      horizontalGridSpacing: 16,
      listViewBuilderOptions: ListViewBuilderOptions(
          shrinkWrap: true,
          physics: NeverScrollableScrollPhysics(),
          padding: EdgeInsets.zero),
      children: List.generate(
        sectionList?[sectionindex].data?.length ?? 0,
        (index) {
          final sectList = sectionList?[sectionindex].data?[index];
          return InkWell(
            hoverColor: transparent,
            highlightColor: transparent,
            splashColor: transparent,
            focusColor: transparent,
            onTap: () {
              Utils.navigatePage(
                  context,
                  WebVideoByIdViewAll(
                    title: sectList?.name.toString() ?? "",
                    contentId: sectList?.id.toString() ?? "",
                    apiType: "category",
                  ),
                  "2");
            },
            child: Container(
              padding: const EdgeInsets.fromLTRB(14, 10, 14, 10),
              alignment: Alignment.center,
              decoration: BoxDecoration(
                color:
                    colorList[index % colorList.length].withValues(alpha: 0.16),
                borderRadius: const BorderRadius.all(Radius.circular(10)),
              ),
              child: Row(
                spacing: 10,
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.center,
                mainAxisSize: MainAxisSize.min,
                children: [
                  DottedBorder(
                    options: CircularDottedBorderOptions(
                        padding: EdgeInsets.all(6),
                        borderPadding: EdgeInsets.all(4),
                        color: colorList[index % colorList.length]),
                    child: MyNetworkImage(
                      imageUrl: sectList?.image.toString() ?? "",
                      fit: BoxFit.cover,
                      radius: 200,
                      imgHeight: 40,
                      imgWidth: 40,
                    ),
                  ),
                  Expanded(
                      child: MyText(
                          color: black,
                          text: sectList?.name.toString() ?? "",
                          fontsizeNormal: Dimens.textMedium,
                          maxline: 2,
                          fontwaight: FontWeight.w600,
                          textalign: TextAlign.center,
                          fontstyle: FontStyle.normal))
                ],
              ),
            ),
          );
        },
      ),
    );
  }

  Widget language(int sectionindex, List<Result>? sectionList) {
    return ResponsiveGridList(
        minItemWidth: 200,
        minItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 8,
            height1200: 6,
            height800: 4,
            height400: 3),
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 10,
            height1200: 8,
            height800: 6,
            height400: 4),
        horizontalGridMargin:
            MediaQuery.of(context).size.width > 1000 ? 200 : 20,
        verticalGridMargin: 0,
        verticalGridSpacing: 16,
        horizontalGridSpacing: 16,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            physics: NeverScrollableScrollPhysics(),
            padding: EdgeInsets.zero),
        children: List.generate(sectionList?[sectionindex].data?.length ?? 0,
            (index) {
          final sectList = sectionList?[sectionindex].data?[index];
          return InkWell(
              hoverColor: transparent,
              highlightColor: transparent,
              splashColor: transparent,
              focusColor: transparent,
              onTap: () {
                Utils.navigatePage(
                    context,
                    WebVideoByIdViewAll(
                      title: sectList?.name.toString() ?? "",
                      contentId: sectList?.id.toString() ?? "",
                      apiType: "language",
                    ),
                    "2");
              },
              child: Container(
                  padding: const EdgeInsets.fromLTRB(14, 10, 14, 10),
                  alignment: Alignment.center,
                  decoration: BoxDecoration(
                    color: colorList[index % colorList.length]
                        .withValues(alpha: 0.16),
                    borderRadius: const BorderRadius.all(Radius.circular(10)),
                  ),
                  child: Row(
                      spacing: 10,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        DottedBorder(
                          options: CircularDottedBorderOptions(
                              padding: EdgeInsets.all(6),
                              borderPadding: EdgeInsets.all(4),
                              color: colorList[index % colorList.length]),
                          child: MyNetworkImage(
                            imageUrl: sectList?.image.toString() ?? "",
                            fit: BoxFit.cover,
                            radius: 200,
                            imgHeight: 40,
                            imgWidth: 40,
                          ),
                        ),
                        Expanded(
                            child: MyText(
                                color: black,
                                text: sectList?.name.toString() ?? "",
                                fontsizeNormal: Dimens.textMedium,
                                maxline: 2,
                                fontwaight: FontWeight.w600,
                                textalign: TextAlign.center,
                                fontstyle: FontStyle.normal))
                      ])));
        }));
  }

  /* landscap List */

  Widget landscap(int sectionindex, List<Result>? sectionList) {
    if (MediaQuery.of(context).size.width > 800) {
      return buildWebLandscap(sectionindex, sectionList);
    } else {
      return buildMobileLandscap(sectionindex, sectionList);
    }
  }

  Widget buildWebLandscap(int sectionindex, List<Result>? sectionList) {
    return Container(
        margin: MediaQuery.of(context).size.width > 1000
            ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
            : const EdgeInsets.fromLTRB(15, 0, 15, 0),
        child: SingleChildScrollView(
          physics: BouncingScrollPhysics(),
          scrollDirection: Axis.horizontal,
          child: Row(
            mainAxisSize: MainAxisSize.min,
            children: List.generate(
              sectionList?[sectionindex].data?.length ?? 0,
              (index) {
                final sectList = sectionList?[sectionindex].data?[index];
                return InkWell(
                    hoverColor: transparent,
                    highlightColor: transparent,
                    splashColor: transparent,
                    focusColor: transparent,
                    onTap: () {
                      Utils.navigatePage(
                          context,
                          WebDetail(courseId: sectList?.id.toString() ?? ""),
                          "2");
                    },
                    child: Container(
                        width: 300,
                        margin: const EdgeInsets.fromLTRB(10, 0, 10, 5),
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(15),
                        ),
                        child: Column(
                            mainAxisAlignment: MainAxisAlignment.center,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            mainAxisSize: MainAxisSize.min,
                            children: [
                              Stack(
                                children: [
                                  MyNetworkImage(
                                      imgWidth:
                                          MediaQuery.of(context).size.width,
                                      imgHeight: 180,
                                      radius: 24,
                                      fit: BoxFit.fill,
                                      islandscap: true,
                                      imageUrl:
                                          sectList?.thumbnailImg.toString() ??
                                              ""),
                                  (sectionList?[sectionindex]
                                                  .isFree
                                                  .toString() ??
                                              "") ==
                                          "1"
                                      ? SizedBox.shrink()
                                      : Positioned(
                                          left: 10,
                                          top: 10,
                                          child: IntrinsicWidth(
                                            // Wrap with IntrinsicWidth
                                            child: Container(
                                              padding: EdgeInsets.symmetric(
                                                  horizontal: 8, vertical: 4),
                                              decoration: BoxDecoration(
                                                color: colorAccent,
                                                borderRadius:
                                                    BorderRadius.circular(4),
                                              ),
                                              child: Row(
                                                mainAxisSize: MainAxisSize
                                                    .min, // Ensures the Row only takes necessary space
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.center,
                                                children: [
                                                  Icon(
                                                    Icons
                                                        .workspace_premium_outlined,
                                                    size: 14,
                                                    color: white,
                                                  ),
                                                  SizedBox(
                                                      width:
                                                          5), // Spacing between icon and text
                                                  Flexible(
                                                    fit: FlexFit.loose,
                                                    child: MyText(
                                                      color: white,
                                                      text: "premium",
                                                      maxline: 1,
                                                      multilanguage: true,
                                                      fontsizeNormal:
                                                          Dimens.textMedium,
                                                      fontwaight:
                                                          FontWeight.w500,
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ),
                                          ),
                                        )
                                ],
                              ),
                              Padding(
                                  padding: EdgeInsets.fromLTRB(6, 4, 6, 4),
                                  child: Column(
                                      mainAxisAlignment:
                                          MainAxisAlignment.start,
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        MyText(
                                            color: Theme.of(context)
                                                .colorScheme
                                                .surface,
                                            text: sectList?.title.toString() ??
                                                "",
                                            fontsizeNormal: Dimens.textBigSmall,
                                            fontsizeWeb: Dimens.textMedium,
                                            fontwaight: FontWeight.w700,
                                            maxline: 1,
                                            textalign: TextAlign.left,
                                            fontstyle: FontStyle.normal),
                                        const SizedBox(height: 5),
                                        Row(
                                          mainAxisAlignment:
                                              MainAxisAlignment.start,
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          spacing: 4,
                                          children: [
                                            Icon(
                                              Icons.person_outline_rounded,
                                              size: 16,
                                              color: gray,
                                            ),
                                            MyText(
                                                color: green,
                                                text: sectList?.tutorName
                                                        .toString() ??
                                                    "",
                                                fontsizeNormal:
                                                    Dimens.textMedium,
                                                fontsizeWeb: Dimens.textSmall,
                                                fontwaight: FontWeight.w500,
                                                maxline: 1,
                                                textalign: TextAlign.left,
                                                fontstyle: FontStyle.normal),
                                          ],
                                        ),
                                        const SizedBox(height: 5),
                                        MyText(
                                            color: gray,
                                            text: sectList?.description
                                                    .toString() ??
                                                "",
                                            fontsizeNormal: Dimens.textMedium,
                                            fontsizeWeb: Dimens.textSmall,
                                            fontwaight: FontWeight.w400,
                                            maxline: 3,
                                            textalign: TextAlign.left,
                                            fontstyle: FontStyle.normal),
                                        Row(children: [
                                          MyRating(
                                            size: 18,
                                            rating: double.parse(
                                                (sectionList?[sectionindex]
                                                        .data?[index]
                                                        .avgRating
                                                        .toString() ??
                                                    "")),
                                            spacing: 3,
                                          ),
                                          const SizedBox(width: 5),
                                          MyText(
                                              color: colorAccent,
                                              text:
                                                  "${double.parse(sectList?.avgRating.toString() ?? "")}",
                                              fontsizeNormal: Dimens.textTitle,
                                              fontsizeWeb: Dimens.textTitle,
                                              fontwaight: FontWeight.w600,
                                              maxline: 1,
                                              textalign: TextAlign.left,
                                              fontstyle: FontStyle.normal)
                                        ]),
                                        MyText(
                                            color: black,
                                            text: ((sectList?.isFree
                                                            .toString() ??
                                                        "") ==
                                                    "0")
                                                ? ((sectList?.isUserBuy
                                                                .toString() ??
                                                            "") ==
                                                        "0")
                                                    ? "${Constant.currencyCode} ${sectList?.price ?? 0}"
                                                    : Locales.string(
                                                        context, "free")
                                                : Locales.string(
                                                    context, "free"),
                                            fontsizeNormal: Dimens.textSmall,
                                            fontwaight: FontWeight.w500,
                                            maxline: 1,
                                            multilanguage: false,
                                            textalign: TextAlign.left,
                                            fontstyle: FontStyle.normal),
                                      ])),
                            ])));
              },
            ),
          ),
        ));
  }

  Widget buildMobileLandscap(int sectionindex, List<Result>? sectionList) {
    return Container(
        color: colorPrimary.withValues(alpha: 0.10),
        width: MediaQuery.of(context).size.width,
        alignment: Alignment.centerLeft,
        height: 250,
        padding: const EdgeInsets.only(top: 8, bottom: 8),
        child: ListView.builder(
            scrollDirection: Axis.horizontal,
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
            padding: const EdgeInsets.fromLTRB(10, 0, 10, 0),
            itemCount: sectionList?[sectionindex].data?.length ?? 0,
            itemBuilder: (BuildContext context, int index) {
              final sectList = sectionList?[sectionindex].data?[index];
              return InkWell(
                  hoverColor: transparent,
                  highlightColor: transparent,
                  splashColor: transparent,
                  focusColor: transparent,
                  onTap: () {
                    Utils.navigatePage(
                        context,
                        WebDetail(courseId: sectList?.id.toString() ?? ""),
                        "2");
                  },
                  child: Container(
                      width: 200,
                      height: MediaQuery.sizeOf(context).height,
                      margin: const EdgeInsets.fromLTRB(10, 0, 10, 5),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(15),
                      ),
                      child: Column(
                          mainAxisAlignment: MainAxisAlignment.center,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            Stack(
                              children: [
                                AnimatedScale(
                                  curve: Curves.easeInOut,
                                  duration: const Duration(milliseconds: 500),
                                  scale: 1,
                                  child: MyNetworkImage(
                                      imgWidth:
                                          MediaQuery.of(context).size.width,
                                      imgHeight: 130,
                                      radius: 23,
                                      fit: BoxFit.fill,
                                      islandscap: true,
                                      imageUrl:
                                          sectList?.thumbnailImg.toString() ??
                                              ""),
                                ),
                                (sectionList?[sectionindex].isFree.toString() ??
                                            "") ==
                                        "1"
                                    ? SizedBox.shrink()
                                    : Positioned(
                                        left: 10,
                                        top: 10,
                                        child: IntrinsicWidth(
                                          // Wrap with IntrinsicWidth
                                          child: Container(
                                            padding: EdgeInsets.symmetric(
                                                horizontal: 8, vertical: 4),
                                            decoration: BoxDecoration(
                                              color: colorAccent,
                                              borderRadius:
                                                  BorderRadius.circular(4),
                                            ),
                                            child: Row(
                                              mainAxisSize: MainAxisSize
                                                  .min, // Ensures the Row only takes necessary space
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.center,
                                              children: [
                                                Icon(
                                                  Icons
                                                      .workspace_premium_outlined,
                                                  size: 14,
                                                  color: white,
                                                ),
                                                SizedBox(
                                                    width:
                                                        5), // Spacing between icon and text
                                                Flexible(
                                                  fit: FlexFit.loose,
                                                  child: MyText(
                                                    color: white,
                                                    text: "premium",
                                                    maxline: 1,
                                                    multilanguage: true,
                                                    fontsizeNormal:
                                                        Dimens.textMedium,
                                                    fontwaight: FontWeight.w500,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                        ),
                                      )
                              ],
                            ),
                            Expanded(
                                child: Padding(
                                    padding:
                                        const EdgeInsets.fromLTRB(0, 8, 0, 5),
                                    child: Column(
                                        mainAxisAlignment:
                                            MainAxisAlignment.start,
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          MyText(
                                              color: Theme.of(context)
                                                  .colorScheme
                                                  .surface,
                                              text:
                                                  sectList?.title.toString() ??
                                                      "",
                                              fontsizeNormal:
                                                  Dimens.textBigSmall,
                                              fontsizeWeb: Dimens.textBigSmall,
                                              fontwaight: FontWeight.w600,
                                              maxline: 2,
                                              textalign: TextAlign.left,
                                              fontstyle: FontStyle.normal),
                                          const SizedBox(height: 5),
                                          Row(
                                            mainAxisAlignment:
                                                MainAxisAlignment.start,
                                            crossAxisAlignment:
                                                CrossAxisAlignment.center,
                                            children: [
                                              MyText(
                                                  color: gray,
                                                  text: Utils.kmbGenerator(
                                                    int.parse(sectList
                                                            ?.totalView
                                                            .toString() ??
                                                        ""),
                                                  ),
                                                  fontsizeNormal:
                                                      Dimens.textSmall,
                                                  fontsizeWeb: Dimens.textSmall,
                                                  fontwaight: FontWeight.w500,
                                                  maxline: 1,
                                                  overflow:
                                                      TextOverflow.ellipsis,
                                                  textalign: TextAlign.left,
                                                  fontstyle: FontStyle.normal),
                                              const SizedBox(width: 5),
                                              MyText(
                                                  color: gray,
                                                  text: "students",
                                                  fontsizeNormal:
                                                      Dimens.textSmall,
                                                  fontsizeWeb: Dimens.textSmall,
                                                  fontwaight: FontWeight.w500,
                                                  maxline: 1,
                                                  multilanguage: true,
                                                  overflow:
                                                      TextOverflow.ellipsis,
                                                  textalign: TextAlign.left,
                                                  fontstyle: FontStyle.normal),
                                            ],
                                          ),
                                          const SizedBox(height: 5),
                                          Row(children: [
                                            MyRating(
                                              size: 13,
                                              rating: double.parse((sectList
                                                      ?.avgRating
                                                      .toString() ??
                                                  "")),
                                              spacing: 3,
                                            ),
                                            const SizedBox(width: 5),
                                            MyText(
                                                color: colorAccent,
                                                text:
                                                    "${double.parse(sectList?.avgRating.toString() ?? "")}",
                                                fontsizeNormal:
                                                    Dimens.textBigSmall,
                                                fontsizeWeb:
                                                    Dimens.textBigSmall,
                                                fontwaight: FontWeight.w600,
                                                maxline: 1,
                                                textalign: TextAlign.left,
                                                fontstyle: FontStyle.normal)
                                          ])
                                        ])))
                          ])));
            }));
  }

  Widget landscapShimmer() {
    return Column(
      children: [
        SizedBox(
          width: MediaQuery.of(context).size.width,
          height: 80,
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              CustomWidget.roundrectborder(
                  height: 15, width: MediaQuery.of(context).size.width * 0.30),
              const SizedBox(
                height: 10,
              ),
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Container(
                    width: 70,
                    height: 1,
                    color: gray,
                  ),
                  const SizedBox(
                    width: 10,
                  ),
                  CustomWidget.roundrectborder(
                      height: 15,
                      width: MediaQuery.of(context).size.width * 0.20),
                  const SizedBox(
                    width: 10,
                  ),
                  Container(
                    width: 70,
                    height: 1,
                    color: gray,
                  ),
                ],
              ),
            ],
          ),
        ),
        Container(
          width: MediaQuery.of(context).size.width,
          height: 250,
          alignment: Alignment.centerLeft,
          child: ListView.builder(
            scrollDirection: Axis.horizontal,
            shrinkWrap: true,
            itemCount: 3,
            itemBuilder: (BuildContext context, int index) {
              return Padding(
                padding: const EdgeInsets.fromLTRB(20, 0, 20, 0),
                child: Container(
                  width: 220,
                  height: 220,
                  margin: const EdgeInsets.fromLTRB(0, 0, 0, 5),
                  decoration: BoxDecoration(
                    color: white,
                    border: Border.all(width: 1, color: colorAccent),
                  ),
                  child: Column(
                    children: [
                      SizedBox(
                        width: MediaQuery.of(context).size.width,
                        height: 120,
                        child: Padding(
                          padding: const EdgeInsets.all(5),
                          child: CustomWidget.roundrectborder(
                              height: MediaQuery.of(context).size.height,
                              width: MediaQuery.of(context).size.width),
                        ),
                      ),
                      Container(
                        width: MediaQuery.of(context).size.width,
                        height: 120,
                        padding: const EdgeInsets.only(left: 5),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.center,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            CustomWidget.roundrectborder(
                                height:
                                    MediaQuery.of(context).size.height * 0.02,
                                width:
                                    MediaQuery.of(context).size.width * 0.20),
                            const SizedBox(height: 10),
                            CustomWidget.roundrectborder(
                                height:
                                    MediaQuery.of(context).size.height * 0.02,
                                width:
                                    MediaQuery.of(context).size.width * 0.25),
                            const SizedBox(height: 10),
                            Row(
                              children: [
                                RatingBar(
                                  initialRating: 5,
                                  direction: Axis.horizontal,
                                  allowHalfRating: true,
                                  itemCount: 5,
                                  itemSize: 10,
                                  ratingWidget: RatingWidget(
                                    full: const CustomWidget.roundrectborder(
                                        height: 15, width: 15),
                                    half: const CustomWidget.roundrectborder(
                                        height: 15, width: 15),
                                    empty: const CustomWidget.roundrectborder(
                                        height: 15, width: 15),
                                  ),
                                  itemPadding:
                                      const EdgeInsets.fromLTRB(1, 0, 1, 0),
                                  onRatingUpdate: (rating) {
                                    printLog("$rating");
                                  },
                                ),
                                const SizedBox(width: 5),
                                CustomWidget.roundrectborder(
                                    height: MediaQuery.of(context).size.height *
                                        0.02,
                                    width: MediaQuery.of(context).size.width *
                                        0.30),
                              ],
                            )
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              );
            },
          ),
        ),
      ],
    );
  }

  /* Portrait List */

  Widget portrait(int sectionindex, List<Result>? sectionList) {
    if (MediaQuery.of(context).size.width > 800) {
      return buildWebportrait(sectionindex, sectionList);
    } else {
      return buildMobileportrait(sectionindex, sectionList);
    }
  }

  Widget buildWebportrait(int sectionindex, List<Result>? sectionList) {
    return Container(
        margin: MediaQuery.of(context).size.width > 1000
            ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
            : const EdgeInsets.fromLTRB(15, 0, 15, 0),
        child: SingleChildScrollView(
          physics: BouncingScrollPhysics(),
          scrollDirection: Axis.horizontal,
          child: Row(
            mainAxisSize: MainAxisSize.min,
            children: List.generate(
              sectionList?[sectionindex].data?.length ?? 0,
              (index) {
                final sectList = sectionList?[sectionindex].data?[index];
                return InkWell(
                    hoverColor: transparent,
                    highlightColor: transparent,
                    splashColor: transparent,
                    focusColor: transparent,
                    onTap: () {
                      Utils.navigatePage(
                          context,
                          WebDetail(courseId: sectList?.id.toString() ?? ""),
                          "2");
                    },
                    child: Container(
                        width: 150,
                        margin: const EdgeInsets.fromLTRB(10, 0, 10, 5),
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(15),
                        ),
                        child: Column(
                            mainAxisAlignment: MainAxisAlignment.center,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            mainAxisSize: MainAxisSize.min,
                            children: [
                              Stack(
                                children: [
                                  MyNetworkImage(
                                      imgWidth:
                                          MediaQuery.of(context).size.width,
                                      imgHeight: 180,
                                      radius: 24,
                                      fit: BoxFit.fill,
                                      islandscap: true,
                                      imageUrl:
                                          sectList?.thumbnailImg.toString() ??
                                              ""),
                                  (sectionList?[sectionindex]
                                                  .isFree
                                                  .toString() ??
                                              "") ==
                                          "1"
                                      ? SizedBox.shrink()
                                      : Positioned(
                                          left: 10,
                                          top: 10,
                                          child: IntrinsicWidth(
                                            // Wrap with IntrinsicWidth
                                            child: Container(
                                              padding: EdgeInsets.symmetric(
                                                  horizontal: 8, vertical: 4),
                                              decoration: BoxDecoration(
                                                color: colorAccent,
                                                borderRadius:
                                                    BorderRadius.circular(4),
                                              ),
                                              child: Row(
                                                mainAxisSize: MainAxisSize
                                                    .min, // Ensures the Row only takes necessary space
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.center,
                                                children: [
                                                  Icon(
                                                    Icons
                                                        .workspace_premium_outlined,
                                                    size: 14,
                                                    color: white,
                                                  ),
                                                  SizedBox(
                                                      width:
                                                          5), // Spacing between icon and text
                                                  Flexible(
                                                    fit: FlexFit.loose,
                                                    child: MyText(
                                                      color: white,
                                                      text: "premium",
                                                      maxline: 1,
                                                      multilanguage: true,
                                                      fontsizeNormal:
                                                          Dimens.textMedium,
                                                      fontwaight:
                                                          FontWeight.w500,
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ),
                                          ),
                                        )
                                ],
                              ),
                              Padding(
                                  padding: EdgeInsets.fromLTRB(6, 4, 6, 4),
                                  child: Column(
                                      mainAxisAlignment:
                                          MainAxisAlignment.start,
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        MyText(
                                            color: Theme.of(context)
                                                .colorScheme
                                                .surface,
                                            text: sectList?.title.toString() ??
                                                "",
                                            fontsizeNormal: Dimens.textBigSmall,
                                            fontsizeWeb: Dimens.textMedium,
                                            fontwaight: FontWeight.w700,
                                            maxline: 1,
                                            textalign: TextAlign.left,
                                            fontstyle: FontStyle.normal),
                                        const SizedBox(height: 5),
                                        Row(
                                          mainAxisAlignment:
                                              MainAxisAlignment.start,
                                          crossAxisAlignment:
                                              CrossAxisAlignment.center,
                                          spacing: 4,
                                          children: [
                                            Icon(
                                              Icons.person_outline_rounded,
                                              size: 16,
                                              color: gray,
                                            ),
                                            Expanded(
                                              child: MyText(
                                                  color: green,
                                                  text: sectList?.tutorName
                                                          .toString() ??
                                                      "",
                                                  fontsizeNormal:
                                                      Dimens.textMedium,
                                                  fontsizeWeb: Dimens.textSmall,
                                                  fontwaight: FontWeight.w500,
                                                  maxline: 1,
                                                  textalign: TextAlign.left,
                                                  fontstyle: FontStyle.normal),
                                            ),
                                          ],
                                        ),
                                        const SizedBox(height: 5),
                                        MyText(
                                            color: gray,
                                            text: sectList?.description
                                                    .toString() ??
                                                "",
                                            fontsizeNormal: Dimens.textMedium,
                                            fontsizeWeb: Dimens.textSmall,
                                            fontwaight: FontWeight.w400,
                                            maxline: 3,
                                            textalign: TextAlign.left,
                                            fontstyle: FontStyle.normal),
                                        Row(children: [
                                          Expanded(
                                            child: MyRating(
                                              size: 18,
                                              rating: double.parse((sectList
                                                      ?.avgRating
                                                      .toString() ??
                                                  "")),
                                              spacing: 3,
                                            ),
                                          ),
                                          const SizedBox(width: 5),
                                          MyText(
                                              color: colorAccent,
                                              text:
                                                  "(${sectList?.avgRating.toString() ?? ""})",
                                              fontsizeNormal: Dimens.textTitle,
                                              fontsizeWeb: Dimens.textTitle,
                                              fontwaight: FontWeight.w600,
                                              maxline: 1,
                                              textalign: TextAlign.left,
                                              fontstyle: FontStyle.normal)
                                        ]),
                                        MyText(
                                            color: black,
                                            text: ((sectList?.isFree
                                                            .toString() ??
                                                        "") ==
                                                    "0")
                                                ? ((sectList?.isUserBuy
                                                                .toString() ??
                                                            "") ==
                                                        "0")
                                                    ? "${Constant.currencyCode} ${sectList?.price ?? 0}"
                                                    : Locales.string(
                                                        context, "free")
                                                : Locales.string(
                                                    context, "free"),
                                            fontsizeNormal: Dimens.textSmall,
                                            fontwaight: FontWeight.w500,
                                            maxline: 1,
                                            multilanguage: false,
                                            textalign: TextAlign.left,
                                            fontstyle: FontStyle.normal),
                                      ])),
                            ])));
              },
            ),
          ),
        ));
  }

  Widget buildMobileportrait(int sectionindex, List<Result>? sectionList) {
    return SingleChildScrollView(
      physics: BouncingScrollPhysics(),
      scrollDirection: Axis.horizontal,
      child: Row(
          children: List.generate(
        sectionList?[sectionindex].data?.length ?? 0,
        (index) {
          final sectList = sectionList?[sectionindex].data?[index];
          return InkWell(
            hoverColor: transparent,
            highlightColor: transparent,
            splashColor: transparent,
            focusColor: transparent,
            onTap: () {
              Utils.navigatePage(context,
                  WebDetail(courseId: sectList?.id.toString() ?? ""), "2");
            },
            child: Container(
              width: 240,
              margin: const EdgeInsets.fromLTRB(4, 10, 10, 10),
              decoration: BoxDecoration(
                  color: Theme.of(context).cardColor,
                  borderRadius: BorderRadius.circular(16),
                  boxShadow: [
                    BoxShadow(
                        color: transparent.withValues(alpha: 0.4),
                        blurRadius: 4,
                        blurStyle: BlurStyle.outer,
                        offset: Offset(0, 3))
                  ]),
              child: Column(
                children: [
                  Stack(
                    children: [
                      ClipRRect(
                        borderRadius: BorderRadius.only(
                            topLeft: Radius.circular(16),
                            topRight: Radius.circular(16)),
                        child: MyNetworkImage(
                            imgWidth: MediaQuery.of(context).size.width,
                            imgHeight: 140,
                            fit: BoxFit.fill,
                            islandscap: true,
                            imageUrl: sectList?.landscapeImg.toString() ?? ""),
                      ),
                      (sectionList?[sectionindex].isFree.toString() ?? "") ==
                              "1"
                          ? SizedBox.shrink()
                          : Positioned(
                              left: 10,
                              top: 10,
                              child: IntrinsicWidth(
                                // Wrap with IntrinsicWidth
                                child: Container(
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 8, vertical: 4),
                                  decoration: BoxDecoration(
                                    color: colorAccent,
                                    borderRadius: BorderRadius.circular(4),
                                  ),
                                  child: Row(
                                    mainAxisSize: MainAxisSize
                                        .min, // Ensures the Row only takes necessary space
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    children: [
                                      Icon(
                                        Icons.workspace_premium_outlined,
                                        size: 14,
                                        color: white,
                                      ),
                                      SizedBox(
                                          width:
                                              5), // Spacing between icon and text
                                      Flexible(
                                        fit: FlexFit.loose,
                                        child: MyText(
                                          color: white,
                                          text: "premium",
                                          maxline: 1,
                                          multilanguage: true,
                                          fontsizeNormal: Dimens.textMedium,
                                          fontwaight: FontWeight.w500,
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            )
                    ],
                  ),
                  const SizedBox(height: 8),
                  Padding(
                    padding: EdgeInsets.fromLTRB(12, 0, 12, 10),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        MyText(
                            color: Theme.of(context).colorScheme.surface,
                            text: sectList?.title.toString() ?? "",
                            fontsizeNormal: Dimens.textBigSmall,
                            fontwaight: FontWeight.w600,
                            maxline: 2,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        const SizedBox(height: 2),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            MyText(
                                color: gray,
                                text: Utils.kmbGenerator(
                                  int.parse(
                                      sectList?.totalView.toString() ?? ""),
                                ),
                                fontsizeNormal: Dimens.textSmall,
                                fontwaight: FontWeight.w500,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                            const SizedBox(width: 2),
                            MyText(
                                color: gray,
                                text: "students",
                                fontsizeNormal: Dimens.textSmall,
                                fontwaight: FontWeight.w500,
                                maxline: 1,
                                multilanguage: true,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ],
                        ),
                        const SizedBox(height: 2),
                        Row(
                          children: [
                            MyRating(
                              size: 15,
                              rating: double.parse(
                                  (sectList?.avgRating.toString() ?? "")),
                              spacing: 3,
                            ),
                            const SizedBox(width: 5),
                            MyText(
                                color: colorAccent,
                                text:
                                    "${double.parse(sectList?.avgRating.toString() ?? "")}",
                                fontsizeNormal: Dimens.textBigSmall,
                                fontwaight: FontWeight.w600,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ],
                        ),
                        MyText(
                            color: black,
                            text: ((sectList?.isFree.toString() ?? "") == "0")
                                ? ((sectList?.isUserBuy.toString() ?? "") ==
                                        "0")
                                    ? "${Constant.currencyCode} ${sectList?.price ?? 0}"
                                    : Locales.string(context, "free")
                                : Locales.string(context, "free"),
                            fontsizeNormal: Dimens.textSmall,
                            fontwaight: FontWeight.w500,
                            maxline: 1,
                            multilanguage: false,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          );
        },
      )),
    );
  }

  /* Listview  */

  Widget listView(int sectionindex, List<Result>? sectionList) {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: Padding(
        padding: MediaQuery.of(context).size.width > 1000
            ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
            : const EdgeInsets.fromLTRB(20, 0, 20, 0),
        child: ResponsiveGridList(
          minItemWidth: 120,
          minItemsPerRow: Utils.customCrossAxisCount(
              context: context,
              height1600: 3,
              height1200: 2,
              height800: 1,
              height400: 1),
          maxItemsPerRow: Utils.customCrossAxisCount(
              context: context,
              height1600: 3,
              height1200: 2,
              height800: 1,
              height400: 1),
          horizontalGridSpacing: 10,
          verticalGridSpacing: 10,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
          ),
          children: List.generate(
            sectionList?[sectionindex].data?.length ?? 0,
            (index) {
              final sectList = sectionList?[sectionindex].data?[index];
              return InkWell(
                hoverColor: transparent,
                highlightColor: transparent,
                splashColor: transparent,
                focusColor: transparent,
                onTap: () {
                  Utils.navigatePage(context,
                      WebDetail(courseId: sectList?.id.toString() ?? ""), "2");
                },
                child: Row(
                  children: [
                    MyNetworkImage(
                      imgWidth: 120,
                      imgHeight: 160,
                      radius: 10,
                      imageUrl: sectList?.landscapeImg.toString() ?? "",
                      fit: BoxFit.fill,
                    ),
                    const SizedBox(width: 10),
                    Expanded(
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          MyText(
                              color: Theme.of(context).colorScheme.surface,
                              text: sectList?.title.toString() ?? "",
                              fontsizeNormal: Dimens.textBigSmall,
                              fontwaight: FontWeight.w700,
                              maxline: 1,
                              textalign: TextAlign.left,
                              fontstyle: FontStyle.normal),
                          Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            spacing: 4,
                            children: [
                              Icon(
                                Icons.person_outline_rounded,
                                size: 16,
                                color: gray,
                              ),
                              MyText(
                                  color: green,
                                  text: sectList?.tutorName.toString() ?? "",
                                  fontsizeNormal: Dimens.textMedium,
                                  fontsizeWeb: Dimens.textSmall,
                                  fontwaight: FontWeight.w500,
                                  maxline: 1,
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal),
                            ],
                          ),
                          MyText(
                              color: Theme.of(context).colorScheme.surface,
                              text: sectList?.description.toString() ?? "",
                              fontsizeNormal: Dimens.textBigSmall,
                              fontwaight: FontWeight.w400,
                              maxline: 3,
                              textalign: TextAlign.left,
                              fontstyle: FontStyle.normal),
                          Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              MyText(
                                  color: gray,
                                  text: Utils.kmbGenerator(int.parse(
                                      sectList?.totalView.toString() ?? "")),
                                  fontsizeNormal: Dimens.textSmall,
                                  fontwaight: FontWeight.w500,
                                  maxline: 1,
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal),
                              const SizedBox(width: 5),
                              MyText(
                                  color: gray,
                                  text: "students",
                                  fontsizeNormal: Dimens.textSmall,
                                  fontwaight: FontWeight.w500,
                                  maxline: 1,
                                  multilanguage: true,
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal),
                            ],
                          ),
                          const SizedBox(height: 8),
                          MyText(
                              color: Theme.of(context).colorScheme.surface,
                              text: ((sectList?.isFree.toString() ?? "") == "0")
                                  ? ((sectList?.isUserBuy.toString() ?? "") ==
                                          "0")
                                      ? "${Constant.currencyCode} ${sectList?.price ?? 0}"
                                      : Locales.string(context, "free")
                                  : Locales.string(context, "free"),
                              fontsizeNormal: Dimens.textMedium,
                              fontwaight: FontWeight.w600,
                              maxline: 2,
                              textalign: TextAlign.left,
                              fontstyle: FontStyle.normal),
                        ],
                      ),
                    ),
                  ],
                ),
              );
            },
          ),
        ),
      ),
    );
  }

  /* Big Portrait */

  /* Top Tutor */

  Widget buildTutor(int sectionindex, List<Result>? sectionList) {
    if (MediaQuery.of(context).size.width > 800) {
      return buildWebTutorList(sectionindex, sectionList);
    } else {
      return buildMobileTutorlist(sectionindex, sectionList);
    }
  }

  Widget buildWebTutorList(int sectionindex, List<Result>? sectionList) {
    return Container(
      height: 260,
      margin: MediaQuery.of(context).size.width > 1000
          ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
          : const EdgeInsets.fromLTRB(20, 0, 20, 0),
      alignment: Alignment.centerLeft,
      child: ListView.builder(
        scrollDirection: Axis.horizontal,
        shrinkWrap: true,
        physics: const BouncingScrollPhysics(),
        padding: EdgeInsets.zero,
        itemCount: sectionList?[sectionindex].data?.length ?? 0,
        itemBuilder: (BuildContext context, int index) {
          final sectList = sectionList?[sectionindex].data?[index];

          return InkWell(
              hoverColor: transparent,
              highlightColor: transparent,
              splashColor: transparent,
              focusColor: transparent,
              onTap: () {
                Utils.navigatePage(
                    context,
                    WebTutorProfile(
                      tutorid: sectList?.id.toString() ?? "",
                    ),
                    "2");
              },
              child: AnimatedScale(
                curve: Curves.easeInOut,
                duration: const Duration(milliseconds: 500),
                scale: 1,
                child: Container(
                  width: 280,
                  margin: const EdgeInsets.fromLTRB(0, 0, 10, 0),
                  padding: const EdgeInsets.fromLTRB(20, 20, 20, 15),
                  color: colorPrimary.withValues(alpha: 0.12),
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          ClipRRect(
                            borderRadius: BorderRadius.circular(50),
                            child: MyNetworkImage(
                                imgWidth: 80,
                                imgHeight: 80,
                                fit: BoxFit.cover,
                                imageUrl: sectList?.image.toString() ?? ""),
                          ),
                          const SizedBox(width: 10),
                          Expanded(
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.center,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                MyText(
                                    color:
                                        Theme.of(context).colorScheme.surface,
                                    text: sectList?.fullName == ""
                                        ? "Guest User"
                                        : sectList?.fullName.toString() ?? "",
                                    fontsizeNormal: Dimens.textBig,
                                    fontsizeWeb: Dimens.textBig,
                                    fontwaight: FontWeight.w600,
                                    maxline: 1,
                                    textalign: TextAlign.center,
                                    fontstyle: FontStyle.normal),
                                const SizedBox(height: 5),
                                MyText(
                                    color: gray,
                                    text: sectList?.email.toString() ?? "",
                                    fontsizeNormal: Dimens.textMedium,
                                    fontsizeWeb: Dimens.textMedium,
                                    fontwaight: FontWeight.w400,
                                    maxline: 1,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                              ],
                            ),
                          ),
                        ],
                      ),
                      const SizedBox(height: 10),
                      Expanded(
                        child: MyText(
                            color: gray,
                            text: sectList?.description.toString() ?? "",
                            fontsizeNormal: Dimens.textSmall,
                            fontsizeWeb: Dimens.textSmall,
                            fontwaight: FontWeight.w400,
                            maxline: 5,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                      ),
                      const SizedBox(height: 10),
                      Align(
                        alignment: Alignment.center,
                        child: Container(
                          padding: const EdgeInsets.fromLTRB(18, 8, 18, 8),
                          decoration: BoxDecoration(
                            color: transparent,
                            borderRadius: BorderRadius.circular(50),
                            border: Border.all(width: 0.8, color: colorPrimary),
                          ),
                          child: MyText(
                              color: colorPrimary,
                              text: "View Profile",
                              fontsizeNormal: Dimens.textSmall,
                              fontsizeWeb: Dimens.textSmall,
                              fontwaight: FontWeight.w500,
                              maxline: 1,
                              textalign: TextAlign.left,
                              fontstyle: FontStyle.normal),
                        ),
                      ),
                    ],
                  ),
                ),
              ));
        },
      ),
    );
  }

  Widget buildMobileTutorlist(int sectionindex, List<Result>? sectionList) {
    return Container(
      width: MediaQuery.of(context).size.width,
      height: 200,
      alignment: Alignment.centerLeft,
      child: ListView.builder(
        scrollDirection: Axis.horizontal,
        shrinkWrap: true,
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.fromLTRB(15, 0, 15, 0),
        itemCount: sectionList?[sectionindex].data?.length ?? 0,
        itemBuilder: (BuildContext context, int index) {
          final sectList = sectionList?[sectionindex].data?[index];

          return InkWell(
              hoverColor: transparent,
              highlightColor: transparent,
              splashColor: transparent,
              focusColor: transparent,
              onTap: () {
                Utils.navigatePage(
                    context,
                    WebTutorProfile(
                      tutorid: sectList?.id.toString() ?? "",
                    ),
                    "2");
              },
              child: AnimatedScale(
                curve: Curves.easeInOut,
                duration: const Duration(milliseconds: 500),
                scale: 1,
                child: Container(
                  width: 260,
                  margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
                  padding: const EdgeInsets.fromLTRB(20, 20, 20, 15),
                  color: colorPrimary.withValues(alpha: 0.07),
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          ClipRRect(
                            borderRadius: BorderRadius.circular(50),
                            child: MyNetworkImage(
                                imgWidth: 60,
                                imgHeight: 60,
                                fit: BoxFit.cover,
                                imageUrl: sectList?.image.toString() ?? ""),
                          ),
                          const SizedBox(width: 10),
                          Expanded(
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.center,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                MyText(
                                    color:
                                        Theme.of(context).colorScheme.surface,
                                    text: sectList?.fullName == ""
                                        ? "Guest User"
                                        : sectList?.fullName.toString() ?? "",
                                    fontsizeNormal: Dimens.textDesc,
                                    fontwaight: FontWeight.w600,
                                    maxline: 1,
                                    textalign: TextAlign.center,
                                    fontstyle: FontStyle.normal),
                                const SizedBox(height: 5),
                                MyText(
                                    color: gray,
                                    text: sectList?.email.toString() ?? "",
                                    fontsizeNormal: Dimens.textBigSmall,
                                    fontwaight: FontWeight.w400,
                                    maxline: 1,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                              ],
                            ),
                          ),
                        ],
                      ),
                      const SizedBox(height: 10),
                      Expanded(
                        child: MyText(
                            color: gray,
                            text: sectList?.description.toString() ?? "",
                            fontsizeNormal: Dimens.textSmall,
                            fontwaight: FontWeight.w400,
                            maxline: 2,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                      ),
                      const SizedBox(height: 10),
                      Align(
                        alignment: Alignment.center,
                        child: Container(
                          padding: const EdgeInsets.fromLTRB(18, 8, 18, 8),
                          decoration: BoxDecoration(
                            color: transparent,
                            borderRadius: BorderRadius.circular(50),
                            border: Border.all(width: 0.8, color: colorPrimary),
                          ),
                          child: MyText(
                              color: colorPrimary,
                              text: "View Profile",
                              fontsizeNormal: Dimens.textSmall,
                              fontwaight: FontWeight.w500,
                              maxline: 1,
                              textalign: TextAlign.left,
                              fontstyle: FontStyle.normal),
                        ),
                      ),
                    ],
                  ),
                ),
              ));
        },
      ),
    );
  }

  /* Blog  */

  Widget buildBlog(int sectionindex, List<Result>? sectionList) {
    return Container(
      margin: MediaQuery.of(context).size.width > 1000
          ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
          : const EdgeInsets.fromLTRB(15, 0, 15, 0),
      width: MediaQuery.of(context).size.width,
      child: SingleChildScrollView(
        padding: EdgeInsets.zero,
        scrollDirection: Axis.horizontal,
        physics: AlwaysScrollableScrollPhysics(),
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          mainAxisAlignment: MainAxisAlignment.start,
          spacing: 10,
          children: List.generate(
            sectionList?[sectionindex].data?.length ?? 0,
            (index) {
              final sectList = sectionList?[sectionindex].data?[index];
              return InkWell(
                hoverColor: transparent,
                highlightColor: transparent,
                splashColor: transparent,
                focusColor: transparent,
                onTap: () {
                  Utils.navigatePage(
                      context,
                      WebBlogDetail(blogId: sectList?.id.toString() ?? ""),
                      "2");
                },
                child: SizedBox(
                  width: 300,
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      MyNetworkImage(
                          imgWidth: width,
                          imgHeight: 145,
                          radius: 10,
                          fit: BoxFit.fill,
                          islandscap: true,
                          imageUrl: sectList?.image.toString() ?? ""),
                      const SizedBox(height: 8),
                      MyText(
                          color: Theme.of(context).colorScheme.surface,
                          text: sectList?.title.toString() ?? "",
                          fontsizeNormal: Dimens.textBigSmall,
                          fontwaight: FontWeight.w600,
                          maxline: 2,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      const SizedBox(height: 5),
                      MyText(
                          color: gray,
                          text: Utils.timeAgoCustom(DateTime.parse(
                              sectList?.createdAt.toString() ?? "")),
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w600,
                          maxline: 3,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                ),
              );
            },
          ),
        ),
      ),
    );
  }

  /* Book  */

  Widget buildBook(int sectionindex, List<Result>? sectionList) {
    if (MediaQuery.of(context).size.width > 800) {
      return buildWebBookList(sectionindex, sectionList);
    } else {
      return buildMobileBookList(sectionindex, sectionList);
    }
  }

  Widget buildWebBookList(int sectionindex, List<Result>? sectionList) {
    return Container(
        width: MediaQuery.of(context).size.width,
        margin: MediaQuery.of(context).size.width > 1000
            ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
            : const EdgeInsets.fromLTRB(15, 0, 15, 0),
        alignment: Alignment.centerLeft,
        child: SingleChildScrollView(
          padding: EdgeInsets.zero,
          scrollDirection: Axis.horizontal,
          physics: AlwaysScrollableScrollPhysics(),
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.start,
            spacing: 10,
            children: List.generate(
              sectionList?[sectionindex].data?.length ?? 0,
              (index) {
                final sectList = sectionList?[sectionindex].data?[index];
                return InkWell(
                  focusColor: transparent,
                  highlightColor: transparent,
                  hoverColor: transparent,
                  splashColor: transparent,
                  onTap: () {
                    Utils.navigatePage(
                        context,
                        WebEbookDetails(
                          ebookId: sectList?.id.toString() ?? "",
                          ebookName: sectList?.name.toString() ?? "",
                        ),
                        "2");
                  },
                  child: SizedBox(
                    width: 155,
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        MyNetworkImage(
                            imgWidth: width,
                            imgHeight: 170,
                            radius: 16,
                            imageUrl: sectList?.thumbnailImg.toString() ?? "",
                            fit: BoxFit.cover),
                        const SizedBox(height: 10),
                        MyText(
                            color: Theme.of(context).colorScheme.surface,
                            text: sectList?.title.toString() ?? "",
                            fontsizeNormal: Dimens.textSmall,
                            fontsizeWeb: Dimens.textSmall,
                            maxline: 1,
                            fontwaight: FontWeight.w600,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        const SizedBox(height: 4),
                        MyText(
                            color: gray,
                            text: sectList?.tutorName.toString() ?? "",
                            fontsizeNormal: Dimens.textSmall,
                            fontsizeWeb: Dimens.textSmall,
                            maxline: 2,
                            fontwaight: FontWeight.w600,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        const SizedBox(height: 4),
                        Row(
                          children: [
                            MyRating(
                              size: 13,
                              rating: double.parse(
                                  (sectList?.avgRating.toString() ?? "")),
                              spacing: 3,
                            ),
                            const SizedBox(width: 5),
                            MyText(
                                color: colorAccent,
                                text:
                                    "${double.parse(sectList?.avgRating.toString() ?? "")}",
                                fontsizeNormal: Dimens.textBigSmall,
                                fontwaight: FontWeight.w600,
                                maxline: 1,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ],
                        ),
                        MyText(
                            color: black,
                            text: (sectList?.isFree ?? 0) == 0 &&
                                    (sectList?.isUserBuy ?? 0) == 0
                                ? "${Constant.currencyCode} ${sectList?.price.toString() ?? ""}"
                                : Locales.string(context, "free"),
                            fontsizeNormal: Dimens.textBigSmall,
                            fontwaight: FontWeight.w600,
                            maxline: 1,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                      ],
                    ),
                  ),
                );
              },
            ),
          ),
        ));
  }

  Widget buildMobileBookList(int sectionindex, List<Result>? sectionList) {
    return Container(
        width: MediaQuery.of(context).size.width,
        margin: const EdgeInsets.fromLTRB(20, 0, 20, 0),
        alignment: Alignment.centerLeft,
        child: SingleChildScrollView(
          padding: EdgeInsets.zero,
          scrollDirection: Axis.horizontal,
          physics: AlwaysScrollableScrollPhysics(),
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.start,
            spacing: 10,
            children: List.generate(
              sectionList?[sectionindex].data?.length ?? 0,
              (index) {
                final sectList = sectionList?[sectionindex].data?[index];
                return InkWell(
                  focusColor: transparent,
                  highlightColor: transparent,
                  hoverColor: transparent,
                  splashColor: transparent,
                  onTap: () {
                    Utils.navigatePage(
                        context,
                        WebEbookDetails(
                          ebookId: sectList?.id.toString() ?? "",
                          ebookName: sectList?.name.toString() ?? "",
                        ),
                        "2");
                  },
                  child: SizedBox(
                    width: 155,
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        MyNetworkImage(
                            imgWidth: width,
                            imgHeight: 155,
                            radius: 12,
                            imageUrl: sectList?.thumbnailImg.toString() ?? "",
                            fit: BoxFit.cover),
                        const SizedBox(height: 10),
                        MyText(
                            color: Theme.of(context).colorScheme.surface,
                            text: sectList?.title.toString() ?? "",
                            fontsizeNormal: Dimens.textSmall,
                            fontsizeWeb: Dimens.textSmall,
                            maxline: 1,
                            fontwaight: FontWeight.w600,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        const SizedBox(height: 4),
                        MyText(
                            color: gray,
                            text: sectList?.tutorName.toString() ?? "",
                            fontsizeNormal: Dimens.textSmall,
                            fontsizeWeb: Dimens.textSmall,
                            maxline: 2,
                            fontwaight: FontWeight.w600,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        const SizedBox(height: 4),
                        Row(
                          children: [
                            MyRating(
                              size: 13,
                              rating: double.parse(
                                  (sectList?.avgRating.toString() ?? "")),
                              spacing: 3,
                            ),
                            const SizedBox(width: 5),
                            MyText(
                                color: colorAccent,
                                text:
                                    "${double.parse(sectList?.avgRating.toString() ?? "")}",
                                fontsizeNormal: Dimens.textBigSmall,
                                fontwaight: FontWeight.w600,
                                maxline: 1,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ],
                        ),
                        MyText(
                            color: black,
                            text: (sectList?.isFree ?? 0) == 0 &&
                                    (sectList?.isUserBuy ?? 0) == 0
                                ? "${Constant.currencyCode} ${sectList?.price.toString() ?? ""}"
                                : Locales.string(context, "free"),
                            fontsizeNormal: Dimens.textBigSmall,
                            fontwaight: FontWeight.w600,
                            maxline: 1,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                      ],
                    ),
                  ),
                );
              },
            ),
          ),
        ));
  }

/* Comman Shimmer */

/* Banner Shimmer */
  Padding shimmerTitle() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 1000
          ? const EdgeInsets.fromLTRB(200, 25, 200, 10)
          : const EdgeInsets.fromLTRB(20, 25, 20, 10),
      child: const Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                CustomWidget.roundrectborder(height: 10, width: 250),
                SizedBox(height: 8),
                CustomWidget.roundrectborder(height: 5, width: 150),
              ],
            ),
          ),
          CustomWidget.roundrectborder(height: 8, width: 80),
        ],
      ),
    );
  }

  Container shimmerItem() {
    if (MediaQuery.of(context).size.width > 800) {
      return Container(
        width: MediaQuery.of(context).size.width,
        alignment: Alignment.centerLeft,
        height: 310,
        padding: const EdgeInsets.only(top: 10, bottom: 10),
        child: ListView.builder(
          scrollDirection: Axis.horizontal,
          shrinkWrap: true,
          physics: const BouncingScrollPhysics(),
          padding: MediaQuery.of(context).size.width > 1000
              ? const EdgeInsets.fromLTRB(200, 25, 200, 0)
              : const EdgeInsets.fromLTRB(20, 25, 20, 0),
          itemCount: 10,
          itemBuilder: (BuildContext context, int index) {
            return Container(
              width: 285,
              height: MediaQuery.sizeOf(context).height,
              margin: const EdgeInsets.fromLTRB(10, 0, 10, 0),
              alignment: Alignment.centerLeft,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  CustomWidget.rectangular(
                      width: MediaQuery.sizeOf(context).width, height: 170),
                  const SizedBox(height: 8),
                  CustomWidget.rectangular(width: 200, height: 5),
                  SizedBox(height: 8),
                  CustomWidget.rectangular(width: 150, height: 5),
                  SizedBox(height: 8),
                  CustomWidget.rectangular(width: 200, height: 5)
                ],
              ),
            );
          },
        ),
      );
    } else {
      return Container(
        width: MediaQuery.of(context).size.width,
        height: 250,
        alignment: Alignment.centerLeft,
        child: ListView.builder(
          scrollDirection: Axis.horizontal,
          shrinkWrap: true,
          physics: const BouncingScrollPhysics(),
          padding: const EdgeInsets.fromLTRB(10, 0, 10, 0),
          itemCount: 10,
          itemBuilder: (BuildContext context, int index) {
            return Container(
              width: 200,
              height: MediaQuery.sizeOf(context).height,
              margin: const EdgeInsets.fromLTRB(10, 0, 10, 0),
              decoration: BoxDecoration(
                color: Theme.of(context).cardColor,
              ),
              child: Column(
                children: [
                  CustomWidget.rectangular(
                    width: MediaQuery.of(context).size.width,
                    height: 130,
                  ),
                  const SizedBox(height: 8),
                  const Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      CustomWidget.rectangular(
                        width: 250,
                        height: 5,
                      ),
                      SizedBox(height: 8),
                      CustomWidget.rectangular(
                        width: 200,
                        height: 5,
                      ),
                      SizedBox(height: 8),
                      CustomWidget.rectangular(
                        width: 200,
                        height: 5,
                      ),
                    ],
                  ),
                ],
              ),
            );
          },
        ),
      );
    }
  }

  Widget commanShimmer() {
    return Column(children: [
      bannerShimmer(),
      const SizedBox(height: 15),
      shimmerTitle(),
      categoryShimer(),
      shimmerTitle(),
      shimmerItem(),
      shimmerTitle(),
      shimmerItem(),
      shimmerTitle(),
      categoryShimer(),
      shimmerTitle(),
      shimmerItem(),
      shimmerTitle(),
      shimmerItem(),
    ]);
  }

  Widget categoryShimer() {
    return ResponsiveGridList(
        minItemWidth: 150,
        minItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 6,
            height1200: 4,
            height800: 3,
            height400: 3),
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 8,
            height1200: 6,
            height800: 4,
            height400: 4),
        horizontalGridMargin:
            MediaQuery.of(context).size.width > 1000 ? 200 : 20,
        verticalGridMargin: 0,
        verticalGridSpacing: 16,
        horizontalGridSpacing: 16,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            physics: NeverScrollableScrollPhysics(),
            padding: EdgeInsets.zero),
        children: List.generate(
            10,
            (index) => Container(
                padding: const EdgeInsets.fromLTRB(10, 5, 10, 5),
                alignment: Alignment.center,
                decoration: BoxDecoration(
                    color: transparent,
                    borderRadius: const BorderRadius.all(Radius.circular(16)),
                    border: Border.all(width: 0.8, color: gray)),
                child: Row(
                    spacing: 10,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      CustomWidget.roundcorner(height: 50, width: 60),
                      Expanded(
                        child: CustomWidget.roundcorner(height: 10, width: 60),
                      )
                    ]))));
  }
}
