import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/webpages/weblogin.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';

class WebForgetPassword extends StatefulWidget {
  const WebForgetPassword({super.key});

  @override
  State<WebForgetPassword> createState() => _WebForgetPasswordState();
}

class _WebForgetPasswordState extends State<WebForgetPassword> {
  TextEditingController emailController = TextEditingController();
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: SingleChildScrollView(
        scrollDirection: Axis.vertical,
        physics: const BouncingScrollPhysics(),
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            MediaQuery.of(context).size.width > 800
                ? Expanded(
                    child: MyImage(
                    width: MediaQuery.of(context).size.width > 1200
                        ? MediaQuery.of(context).size.width * 0.5
                        : MediaQuery.of(context).size.width > 800
                            ? MediaQuery.of(context).size.width * 0.30
                            : MediaQuery.of(context).size.width,
                    height: MediaQuery.sizeOf(context).height,
                    imagePath: 'web_login_bg.png',
                    fit: BoxFit.cover,
                  ))
                : SizedBox.shrink(),
            Expanded(
                child: Container(
              width: MediaQuery.sizeOf(context).width,
              height: MediaQuery.sizeOf(context).height,
              alignment: Alignment.center,
              padding: MediaQuery.of(context).size.width > 1200
                  ? EdgeInsets.fromLTRB(100, 40, 100, 40)
                  : MediaQuery.of(context).size.width > 600
                      ? EdgeInsets.fromLTRB(40, 40, 40, 40)
                      : EdgeInsets.fromLTRB(20, 40, 20, 40),
              decoration: const BoxDecoration(color: white),
              child: SingleChildScrollView(
                child: Column(
                  children: [
                    InkWell(
                      splashColor: transparent,
                      focusColor: transparent,
                      hoverColor: transparent,
                      highlightColor: transparent,
                      onTap: () {
                        if (Navigator.canPop(context)) {
                          Navigator.pop(context);
                        }
                      },
                      child: Align(
                        alignment: Alignment.topRight,
                        child: Container(
                          padding: EdgeInsets.all(4),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle, color: colorPrimaryDark),
                          child: Icon(
                            Icons.close,
                            size: 20,
                            color: white,
                          ),
                        ),
                      ),
                    ),
                    Center(
                        child: MyImage(
                      width: 150,
                      height: 150,
                      imagePath: 'appiconweb.png',
                      fit: BoxFit.contain,
                      isAppicon: true,
                    )),
                    const SizedBox(height: 15),
                    MyText(
                        text: "forget_password",
                        fontsizeWeb: Dimens.textExtraBig,
                        fontsizeNormal: Dimens.textExtraBig,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        multilanguage: true,
                        fontstyle: FontStyle.normal),
                    const SizedBox(height: 20),
                    MyText(
                        text: "forget_password_desc",
                        fontsizeWeb: Dimens.textBig,
                        fontsizeNormal: Dimens.textExtraBig,
                        fontwaight: FontWeight.w400,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        multilanguage: true,
                        fontstyle: FontStyle.normal),
                    const SizedBox(height: 20),
                    /* Email */
                    Align(
                      alignment: Alignment.topLeft,
                      child: MyText(
                          color: black,
                          text: "email",
                          fontsizeNormal: Dimens.textMedium,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.center,
                          multilanguage: true,
                          fontstyle: FontStyle.normal),
                    ),
                    const SizedBox(height: 10),
                    TextFormField(
                      autofillHints: const [AutofillHints.email],
                      obscureText: false,
                      keyboardType: TextInputType.text,
                      controller: emailController,
                      textInputAction: TextInputAction.next,
                      cursorColor: black,
                      style: GoogleFonts.lato(
                          fontSize: Dimens.textMedium,
                          fontStyle: FontStyle.normal,
                          color: black,
                          fontWeight: FontWeight.w600),
                      decoration: InputDecoration(
                        prefixIcon: Icon(
                          Icons.mail,
                          size: 20,
                          color: gray,
                        ),
                        focusedBorder: OutlineInputBorder(
                          borderRadius:
                              const BorderRadius.all(Radius.circular(10)),
                          borderSide: BorderSide(
                              width: 1,
                              color: webTextFiled,
                              style: BorderStyle.solid),
                        ),
                        disabledBorder: OutlineInputBorder(
                          borderRadius:
                              const BorderRadius.all(Radius.circular(10)),
                          borderSide: BorderSide(
                              width: 1,
                              color: webTextFiled,
                              style: BorderStyle.solid),
                        ),
                        enabledBorder: OutlineInputBorder(
                          borderRadius:
                              const BorderRadius.all(Radius.circular(10)),
                          borderSide: BorderSide(
                              width: 1,
                              color: webTextFiled,
                              style: BorderStyle.solid),
                        ),
                        border: OutlineInputBorder(
                          borderRadius:
                              const BorderRadius.all(Radius.circular(10)),
                          borderSide: BorderSide(
                              width: 1,
                              color: webTextFiled,
                              style: BorderStyle.solid),
                        ),
                        hintText: "example@gmail.com",
                        hintStyle: GoogleFonts.lato(
                            fontSize: Dimens.textMedium,
                            fontStyle: FontStyle.normal,
                            color: gray.withValues(alpha: 0.50),
                            fontWeight: FontWeight.w400),
                      ),
                    ),
                    SizedBox(height: 30),
                    Container(
                      width: MediaQuery.of(context).size.width,
                      height: 45,
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        color: colorPrimary,
                        borderRadius: BorderRadius.circular(10),
                      ),
                      child: MyText(
                        color: white,
                        text: "send_reset_link",
                        fontsizeNormal: Dimens.textTitle,
                        fontsizeWeb: Dimens.textTitle,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        multilanguage: true,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal,
                      ),
                    ),
                    SizedBox(height: 30),
                    goingRegister(),
                    SizedBox(height: 30),
                  ],
                ),
              ),
            ))
          ],
        ),
      ),
    );
  }

  Widget goingRegister() {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      crossAxisAlignment: CrossAxisAlignment.center,
      spacing: 4,
      children: [
        Flexible(
          fit: FlexFit.loose,
          child: MyText(
              color: gray,
              text: "go_to",
              fontsizeWeb: Dimens.textTitle,
              fontsizeNormal: Dimens.textTitle,
              maxline: 1,
              fontwaight: FontWeight.w400,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              fontstyle: FontStyle.normal,
              multilanguage: true),
        ),
        Flexible(
          fit: FlexFit.loose,
          child: InkWell(
            onTap: () {
              Navigator.of(context).push(
                PageRouteBuilder(
                  transitionDuration: const Duration(milliseconds: 200),
                  pageBuilder: (BuildContext context,
                      Animation<double> animation,
                      Animation<double> secondaryAnimation) {
                    return const WebLogin();
                  },
                  transitionsBuilder: (BuildContext context,
                      Animation<double> animation,
                      Animation<double> secondaryAnimation,
                      Widget child) {
                    return Align(
                      child: FadeTransition(
                        opacity: animation,
                        child: child,
                      ),
                    );
                  },
                ),
              );
            },
            child: MyText(
                color: colorPrimary,
                text: "login",
                fontsizeWeb: Dimens.textTitle,
                fontsizeNormal: Dimens.textTitle,
                maxline: 1,
                fontwaight: FontWeight.w500,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal,
                multilanguage: true),
          ),
        ),
      ],
    );
  }
}
