import 'package:prakah/pages/readbook.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/webpages/websearch.dart';
import 'package:prakah/webwidget/footerweb.dart';
import 'package:prakah/webwidget/interactivecontainer.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:flutter_rating_bar/flutter_rating_bar.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';
import 'package:prakah/provider/ebookdetailprovider.dart';
import 'package:prakah/subscription/allpayment.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import '../utils/utils.dart';

class WebEbookDetails extends StatefulWidget {
  final String ebookId, ebookName;
  const WebEbookDetails({
    super.key,
    required this.ebookId,
    required this.ebookName,
  });

  @override
  State<WebEbookDetails> createState() => WebEbookDetailsState();
}

class WebEbookDetailsState extends State<WebEbookDetails> {
  EbookDetailProvider ebookDetailProvider = EbookDetailProvider();
  final ScrollController _scrollController = ScrollController();
  final searchController = TextEditingController();
  TextEditingController commentController = TextEditingController();
  double? height, width;
  double addrating = 0.0;
  @override
  void initState() {
    super.initState();
    ebookDetailProvider =
        Provider.of<EbookDetailProvider>(context, listen: false);

    _scrollController.addListener(_scrollListener);
    getApi();
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (ebookDetailProvider.currentPage ?? 0) <
            (ebookDetailProvider.totalPage ?? 0)) {
      ebookDetailProvider.setLoadMore(true);
      _fetchReviewData(ebookDetailProvider.currentPage ?? 0);
    }
  }

  Future<void> _fetchReviewData(int? nextPage) async {
    await ebookDetailProvider.getReviewByBook(
        "1", widget.ebookId, (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();
    ebookDetailProvider.clearProvider();
    super.dispose();
  }

  Future<void> getApi() async {
    await ebookDetailProvider.getEbooksDetail(widget.ebookId.toString());
    _fetchReviewData(0);
  }

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.of(context).size.width;
    height = MediaQuery.of(context).size.height;
    return _buildSearchHome();
  }

  Widget _buildSearchHome() {
    return Consumer<SearchProvider>(builder: (context, homeprovider, child) {
      if (homeprovider.isSearch == "0") {
        return Scaffold(
            appBar: Utils.webMainAppbar(controller: searchController),
            body: buildData());
      } else {
        return WebSearch(
          searchController: searchController,
        );
      }
    });
  }

  Widget buildData() {
    return Consumer<EbookDetailProvider>(
        builder: (context, ebookdetailprovider, child) {
      return Utils.hoverItemWithPage(
        myWidget: SingleChildScrollView(
          scrollDirection: Axis.vertical,
          controller: _scrollController,
          physics: const BouncingScrollPhysics(),
          child: Column(
            children: [
              Utils.buildWebDetailsAppBar(
                  context: context, title: "course_detail"),
              (MediaQuery.of(context).size.width > 800)
                  ? bookInformation()
                  : _buildMobile(),
              tabWithItem(),
              aboutAuthor(),
              buildStudentFeedback(),
              const FooterWeb(),
            ],
          ),
        ),
      );
    });
  }

  Widget bookInformation() {
    if (ebookDetailProvider.loading) {
      return bookInformationShimmer();
    } else {
      if (ebookDetailProvider.ebookDetailModel.status == 200 &&
          ebookDetailProvider.ebookDetailModel.result!.isNotEmpty) {
        final detailsList = ebookDetailProvider.ebookDetailModel.result?[0];
        return Padding(
            padding: MediaQuery.of(context).size.width > 800
                ? const EdgeInsets.fromLTRB(200, 25, 200, 25)
                : const EdgeInsets.fromLTRB(20, 20, 20, 20),
            child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        MyNetworkImage(
                            imgWidth: 210,
                            radius: 5,
                            imgHeight: 250,
                            imageUrl:
                                detailsList?.thumbnailImg.toString() ?? "",
                            fit: BoxFit.fill),
                        const SizedBox(width: 15),
                        Expanded(
                            child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                              MyText(
                                  color: Theme.of(context).colorScheme.surface,
                                  text: detailsList?.title.toString() ?? "",
                                  fontsizeNormal: Dimens.textExtraBig,
                                  fontsizeWeb: Dimens.textExtralargeBig,
                                  fontwaight: FontWeight.w700,
                                  maxline: 2,
                                  overflow: TextOverflow.ellipsis,
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal),
                              const SizedBox(height: 20),
                              Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                crossAxisAlignment: CrossAxisAlignment.center,
                                children: [
                                  MyText(
                                    color: gray,
                                    text: "update",
                                    fontsizeNormal: Dimens.textMedium,
                                    fontsizeWeb: Dimens.textMedium,
                                    fontwaight: FontWeight.w600,
                                    maxline: 2,
                                    multilanguage: true,
                                    overflow: TextOverflow.ellipsis,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal,
                                  ),
                                  const SizedBox(width: 10),
                                  MyText(
                                    color: gray,
                                    text: Utils.formateDate(
                                        detailsList?.createdAt.toString() ?? "",
                                        Constant.dateformat),
                                    fontsizeNormal: Dimens.textMedium,
                                    fontsizeWeb: Dimens.textMedium,
                                    fontwaight: FontWeight.w600,
                                    maxline: 2,
                                    overflow: TextOverflow.ellipsis,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal,
                                  ),
                                ],
                              ),
                              const SizedBox(height: 10),
                              Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                crossAxisAlignment: CrossAxisAlignment.center,
                                children: [
                                  MyText(
                                    color: gray,
                                    text: "createdby",
                                    fontsizeNormal: Dimens.textMedium,
                                    fontsizeWeb: Dimens.textMedium,
                                    fontwaight: FontWeight.w600,
                                    maxline: 2,
                                    multilanguage: true,
                                    overflow: TextOverflow.ellipsis,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal,
                                  ),
                                  const SizedBox(width: 5),
                                  MyText(
                                    color: gray,
                                    text:
                                        detailsList?.tutorName.toString() ?? "",
                                    fontsizeNormal: Dimens.textMedium,
                                    fontsizeWeb: Dimens.textMedium,
                                    fontwaight: FontWeight.w600,
                                    maxline: 2,
                                    overflow: TextOverflow.ellipsis,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal,
                                  ),
                                ],
                              ),
                              const SizedBox(height: 20),
                              Row(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  children: [
                                    buyButton(),
                                    const SizedBox(width: 15),
                                    InkWell(
                                        hoverColor: transparent,
                                        highlightColor: transparent,
                                        focusColor: transparent,
                                        splashColor: transparent,
                                        onTap: () async {
                                          if (Utils.checkLoginUser(context)) {
                                            ebookDetailProvider
                                                .addRemoveWishlist(
                                                    "2",
                                                    detailsList?.id
                                                            .toString() ??
                                                        "");
                                          }
                                        },
                                        child: InteractiveContainer(
                                            child: (isHovered) {
                                          return Container(
                                              width: 45,
                                              height: 45,
                                              alignment: Alignment.center,
                                              padding:
                                                  const EdgeInsets.fromLTRB(
                                                      0, 8, 0, 8),
                                              decoration: BoxDecoration(
                                                borderRadius:
                                                    BorderRadius.circular(50),
                                                border: Border.all(
                                                  width: 0.8,
                                                  color: Theme.of(context)
                                                      .colorScheme
                                                      .surface,
                                                ),
                                                color: isHovered
                                                    ? gray.withValues(
                                                        alpha: 0.20)
                                                    : transparent,
                                              ),
                                              child: AnimatedScale(
                                                  scale: isHovered ? 1.03 : 1,
                                                  duration: const Duration(
                                                      milliseconds: 500),
                                                  curve: Curves.easeInOut,
                                                  child: Icon(
                                                      detailsList?.isWishlist ==
                                                              1
                                                          ? Icons.favorite
                                                          : Icons
                                                              .favorite_border,
                                                      color: detailsList
                                                                  ?.isWishlist ==
                                                              1
                                                          ? red
                                                          : Theme.of(context)
                                                              .colorScheme
                                                              .surface)));
                                        })),
                                    const SizedBox(width: 15),
                                    InkWell(
                                        hoverColor: transparent,
                                        highlightColor: transparent,
                                        focusColor: transparent,
                                        splashColor: transparent,
                                        onTap: () {
                                          if (Utils.checkLoginUser(context)) {
                                            if (detailsList?.isFree == 0) {
                                              if (detailsList?.isUserBuy == 0) {
                                                /* Primium Page  */
                                                Utils.navigatePage(
                                                    context,
                                                    AllPayment(
                                                      contentType: "4",
                                                      payType: 'Package',
                                                      itemId: detailsList?.id
                                                              .toString() ??
                                                          "",
                                                      price: detailsList?.price
                                                              .toString() ??
                                                          "",
                                                      itemTitle: detailsList
                                                              ?.title
                                                              .toString() ??
                                                          "",
                                                    ),
                                                    "2");
                                              } else {
                                                addReviewBottomSheet(
                                                    context, widget.ebookId);
                                              }
                                            } else {
                                              addReviewBottomSheet(
                                                  context, widget.ebookId);
                                            }
                                          }
                                        },
                                        child: InteractiveContainer(
                                            child: (isHovered) {
                                          return Container(
                                              width: 45,
                                              height: 45,
                                              alignment: Alignment.center,
                                              padding:
                                                  const EdgeInsets.fromLTRB(
                                                      0, 8, 0, 8),
                                              decoration: BoxDecoration(
                                                borderRadius:
                                                    BorderRadius.circular(50),
                                                border: Border.all(
                                                  width: 0.8,
                                                  color: Theme.of(context)
                                                      .colorScheme
                                                      .surface,
                                                ),
                                                color: isHovered
                                                    ? gray.withValues(
                                                        alpha: 0.20)
                                                    : transparent,
                                              ),
                                              child: AnimatedScale(
                                                  scale: isHovered ? 1.03 : 1,
                                                  duration: const Duration(
                                                      milliseconds: 500),
                                                  curve: Curves.easeInOut,
                                                  child: const Icon(Icons.star,
                                                      color: colorAccent)));
                                        }))
                                  ])
                            ]))
                      ])
                ]));
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget bookInformationShimmer() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(200, 25, 200, 25)
          : const EdgeInsets.fromLTRB(20, 20, 20, 20),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              CustomWidget.roundcorner(height: 250, width: 210),
              const SizedBox(width: 15),
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    CustomWidget.roundcorner(height: 20, width: 210),
                    const SizedBox(height: 20),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        MyText(
                          color: gray,
                          text: "update",
                          fontsizeNormal: Dimens.textMedium,
                          fontsizeWeb: Dimens.textMedium,
                          fontwaight: FontWeight.w600,
                          maxline: 2,
                          multilanguage: true,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal,
                        ),
                        const SizedBox(width: 10),
                        CustomWidget.roundcorner(height: 12, width: 100),
                      ],
                    ),
                    const SizedBox(height: 10),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        MyText(
                          color: gray,
                          text: "createdby",
                          fontsizeNormal: Dimens.textMedium,
                          fontsizeWeb: Dimens.textMedium,
                          fontwaight: FontWeight.w600,
                          maxline: 2,
                          multilanguage: true,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal,
                        ),
                        const SizedBox(width: 5),
                        CustomWidget.roundcorner(height: 12, width: 110),
                      ],
                    ),
                    const SizedBox(height: 20),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        CustomWidget.roundcorner(height: 25, width: 100),
                        const SizedBox(width: 15),
                        CustomWidget.circular(height: 45, width: 45),
                        const SizedBox(width: 15),
                        CustomWidget.circular(height: 45, width: 45),
                      ],
                    ),
                  ],
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }

  Widget tabWithItem() {
    if (ebookDetailProvider.loading) {
      return tabWithItemShimmer();
    } else {
      if (ebookDetailProvider.ebookDetailModel.status == 200 &&
          (ebookDetailProvider.ebookDetailModel.result?.length ?? 0) > 0) {
        final detailsList = ebookDetailProvider.ebookDetailModel.result?[0];
        return Padding(
          padding: MediaQuery.of(context).size.width > 800
              ? const EdgeInsets.fromLTRB(200, 25, 200, 25)
              : const EdgeInsets.fromLTRB(20, 20, 20, 20),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              _buildTabData(),
              const SizedBox(height: 20),
              Padding(
                padding: const EdgeInsets.fromLTRB(20, 0, 20, 0),
                child: MyText(
                    color: gray,
                    text: ebookDetailProvider.ebookType == 0
                        ? (detailsList?.summary.toString() ?? "")
                        : (detailsList?.specification.toString() ?? ""),
                    fontsizeNormal: Dimens.textDesc,
                    fontsizeWeb: Dimens.textDesc,
                    maxline: 20,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w500,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              )
            ],
          ),
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget _buildTabData() {
    return Stack(
      children: [
        Positioned(
          bottom: 0,
          child: Container(
            height: 2,
            width: MediaQuery.sizeOf(context).width,
            color: gray.withValues(alpha: 0.6),
          ),
        ),
        Row(
          children: [
            _buildTabItem(
              context: context,
              label: "summary",
              value: 0,
            ),
            SizedBox(width: 20),
            _buildTabItem(
              context: context,
              label: "specification",
              value: 1,
            ),
          ],
        ),
      ],
    );
  }

  Widget _buildTabItem({
    required BuildContext context,
    required String label,
    required int value,
  }) {
    bool isSelected = ebookDetailProvider.ebookType == value;

    return InkWell(
      onTap: () {
        ebookDetailProvider.ebookTab(value);
      },
      child: Container(
        padding: const EdgeInsets.only(bottom: 8),
        decoration: BoxDecoration(
          border: Border(
            bottom: BorderSide(
              color: isSelected ? colorPrimary : transparent,
              width: 2,
            ),
          ),
        ),
        child: MyText(
          color: isSelected ? colorPrimary : black,
          multilanguage: true,
          text: label,
          textalign: TextAlign.left,
          fontsizeNormal: Dimens.textBig,
          maxline: 1,
          fontwaight: FontWeight.w600,
          overflow: TextOverflow.ellipsis,
          fontstyle: FontStyle.normal,
        ),
      ),
    );
  }

  Widget tabWithItemShimmer() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(200, 25, 200, 25)
          : const EdgeInsets.fromLTRB(20, 20, 20, 20),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Stack(
            children: [
              Positioned(
                bottom: 0,
                child: Container(
                  height: 2,
                  width: MediaQuery.sizeOf(context).width,
                  color: gray.withValues(alpha: 0.6),
                ),
              ),
              Row(
                children: [
                  _buildTabItem(
                    context: context,
                    label: "summary",
                    value: 0,
                  ),
                  SizedBox(width: 20),
                  _buildTabItem(
                    context: context,
                    label: "specification",
                    value: 1,
                  ),
                ],
              ),
            ],
          ),
          Column(
            children: [
              Container(
                width: width,
                height: 1,
                margin: const EdgeInsets.fromLTRB(20, 0, 20, 0),
                color: gray,
              ),
              const SizedBox(height: 20),
              Column(
                children: [
                  CustomWidget.roundrectborder(
                    height: 10,
                    width: width ?? 0.0 * 0.75,
                  ),
                  const SizedBox(height: 10),
                  CustomWidget.roundrectborder(
                    height: 10,
                    width: width ?? 0.0 * 0.75,
                  ),
                  const SizedBox(height: 10),
                  CustomWidget.roundrectborder(
                    height: 10,
                    width: width ?? 0.0 * 0.75,
                  ),
                  const SizedBox(height: 10),
                  CustomWidget.roundrectborder(
                    height: 10,
                    width: width ?? 0.0 * 0.75,
                  ),
                  const SizedBox(height: 10),
                  CustomWidget.roundrectborder(
                    height: 10,
                    width: width ?? 0.0 * 0.75,
                  ),
                ],
              ),
            ],
          ),
        ],
      ),
    );
  }

  Widget aboutAuthor() {
    if (ebookDetailProvider.loading) {
      return aboutAuthorShimmer();
    } else {
      if (ebookDetailProvider.ebookDetailModel.status == 200 &&
          (ebookDetailProvider.ebookDetailModel.result?.length ?? 0) > 0) {
        final detailsList = ebookDetailProvider.ebookDetailModel.result?[0];
        return Padding(
          padding: MediaQuery.of(context).size.width > 800
              ? const EdgeInsets.fromLTRB(200, 25, 200, 25)
              : const EdgeInsets.fromLTRB(20, 20, 20, 20),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              MyText(
                  color: colorPrimary,
                  text: "aboutauthor",
                  fontsizeNormal: Dimens.textExtraBig,
                  fontsizeWeb: Dimens.textExtraBig,
                  maxline: 1,
                  multilanguage: true,
                  overflow: TextOverflow.ellipsis,
                  fontwaight: FontWeight.w700,
                  textalign: TextAlign.center,
                  fontstyle: FontStyle.normal),
              const SizedBox(height: 20),
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Column(
                    children: [
                      ClipRRect(
                        borderRadius: BorderRadius.circular(10),
                        child: MyNetworkImage(
                            imgWidth: 150,
                            imgHeight: 180,
                            fit: BoxFit.fill,
                            imageUrl:
                                detailsList?.thumbnailImg.toString() ?? ""),
                      ),
                      const SizedBox(height: 15),
                      MyText(
                          color: black,
                          text: detailsList?.tutorName.toString() ?? "",
                          fontsizeNormal: Dimens.textBig,
                          fontsizeWeb: Dimens.textBig,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          fontwaight: FontWeight.w700,
                          textalign: TextAlign.center,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  const Spacer(),
                  Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      MyText(
                          color: colorPrimary,
                          text: "reviews",
                          fontsizeNormal: Dimens.textBig,
                          fontsizeWeb: Dimens.textBig,
                          maxline: 1,
                          multilanguage: true,
                          overflow: TextOverflow.ellipsis,
                          fontwaight: FontWeight.w700,
                          textalign: TextAlign.center,
                          fontstyle: FontStyle.normal),
                      const SizedBox(height: 25),
                      MyText(
                          color: colorPrimary,
                          text: detailsList?.avgRating.toString() ?? "",
                          fontsizeNormal: Dimens.textExtraBig,
                          fontsizeWeb: Dimens.textExtraBig,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          fontwaight: FontWeight.w800,
                          textalign: TextAlign.center,
                          fontstyle: FontStyle.normal),
                      const SizedBox(height: 25),
                      MyRating(
                          rating: double.parse(
                              detailsList?.avgRating.toString() ?? ""),
                          spacing: 5,
                          size: 16),
                    ],
                  ),
                ],
              ),
              const SizedBox(height: 20),
              Utils.htmlTexts(
                  context, detailsList?.description.toString() ?? ""),
            ],
          ),
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget aboutAuthorShimmer() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(200, 25, 200, 25)
          : const EdgeInsets.fromLTRB(20, 20, 20, 20),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          const CustomWidget.roundrectborder(height: 15, width: 200),
          const SizedBox(height: 20),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Column(
                children: [
                  ClipRRect(
                    borderRadius: BorderRadius.circular(10),
                    child: const CustomWidget.roundcorner(
                      width: 150,
                      height: 180,
                    ),
                  ),
                  const SizedBox(height: 15),
                  const CustomWidget.roundrectborder(
                    width: 150,
                    height: 15,
                  ),
                ],
              ),
              const Spacer(),
              const Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  CustomWidget.roundrectborder(
                    width: 150,
                    height: 15,
                  ),
                  SizedBox(height: 25),
                  CustomWidget.circular(
                    width: 20,
                    height: 20,
                  ),
                  SizedBox(height: 25),
                  CustomWidget.roundrectborder(
                    width: 150,
                    height: 10,
                  ),
                ],
              ),
            ],
          ),
          const SizedBox(height: 20),
          CustomWidget.roundrectborder(height: 10, width: width ?? 0.0 * 0.75),
          const SizedBox(height: 10),
          CustomWidget.roundrectborder(height: 10, width: width ?? 0.0 * 0.75),
          const SizedBox(height: 10),
          CustomWidget.roundrectborder(height: 10, width: width ?? 0.0 * 0.75),
          const SizedBox(height: 10),
          CustomWidget.roundrectborder(height: 10, width: width ?? 0.0 * 0.75),
          const SizedBox(height: 10),
          CustomWidget.roundrectborder(height: 10, width: width ?? 0.0 * 0.75),
        ],
      ),
    );
  }

/* Related BookList */

  Widget buildRelatedBook() {
    if (ebookDetailProvider.relatedBookLoading &&
        !ebookDetailProvider.relatedBookloadMore) {
      return relatedBookItemShimmer();
    } else {
      if (ebookDetailProvider.relatedBookModel.status == 200 &&
          ebookDetailProvider.relatedBookModel.result != null) {
        if ((ebookDetailProvider.relatedBookModel.result?.length ?? 0) > 0) {
          return Padding(
            padding: MediaQuery.of(context).size.width > 800
                ? const EdgeInsets.fromLTRB(200, 25, 200, 25)
                : const EdgeInsets.fromLTRB(20, 20, 20, 20),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text: "relatedbooks",
                    fontsizeNormal: Dimens.textTitle,
                    fontsizeWeb: Dimens.textTitle,
                    maxline: 2,
                    multilanguage: true,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                const SizedBox(height: 25),
                relatedBookItem(),
                if (ebookDetailProvider.relatedBookloadMore)
                  Container(
                    height: 50,
                    margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                    child: Utils.pageLoader(),
                  )
                else
                  const SizedBox.shrink(),
              ],
            ),
          );
        } else {
          return const SizedBox.shrink();
        }
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget relatedBookItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
          minItemWidth: 120,
          minItemsPerRow: 1,
          maxItemsPerRow: 1,
          horizontalGridSpacing: 5,
          verticalGridSpacing: 10,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
          ),
          children: List.generate(
              ebookDetailProvider.relatedBookList?.length ?? 0, (index) {
            return InkWell(
              focusColor: transparent,
              splashColor: transparent,
              highlightColor: transparent,
              hoverColor: transparent,
              onTap: () {},
              child: Row(
                children: [
                  ClipRRect(
                    borderRadius: BorderRadius.circular(5),
                    child: MyNetworkImage(
                        imgWidth: 125,
                        imgHeight: 110,
                        imageUrl: ebookDetailProvider
                                .relatedBookList?[index].landscapeImg
                                .toString() ??
                            "",
                        fit: BoxFit.fill),
                  ),
                  const SizedBox(width: 10),
                  Expanded(
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        MyText(
                            color: Theme.of(context).colorScheme.surface,
                            text: ebookDetailProvider
                                    .relatedBookList?[index].title
                                    .toString() ??
                                "",
                            fontsizeNormal: Dimens.textSmall,
                            fontsizeWeb: Dimens.textSmall,
                            maxline: 2,
                            overflow: TextOverflow.ellipsis,
                            fontwaight: FontWeight.w600,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        const SizedBox(height: 10),
                        Row(
                          children: [
                            Container(
                              padding: const EdgeInsets.fromLTRB(10, 5, 10, 5),
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(50),
                                color: colorAccent.withValues(alpha: 0.50),
                              ),
                              child: ebookDetailProvider
                                          .relatedBookList?[index].isFree !=
                                      1
                                  ? MyText(
                                      color:
                                          Theme.of(context).colorScheme.surface,
                                      text:
                                          "${Constant.currencyCode} ${ebookDetailProvider.relatedBookList?[index].price.toString() ?? ""}",
                                      fontsizeNormal: Dimens.textMedium,
                                      fontsizeWeb: Dimens.textMedium,
                                      maxline: 2,
                                      overflow: TextOverflow.ellipsis,
                                      fontwaight: FontWeight.w600,
                                      textalign: TextAlign.left,
                                      fontstyle: FontStyle.normal)
                                  : MyText(
                                      color:
                                          Theme.of(context).colorScheme.surface,
                                      text: "free",
                                      fontsizeNormal: Dimens.textSmall,
                                      fontsizeWeb: Dimens.textSmall,
                                      maxline: 1,
                                      multilanguage: true,
                                      overflow: TextOverflow.ellipsis,
                                      fontwaight: FontWeight.w600,
                                      textalign: TextAlign.left,
                                      fontstyle: FontStyle.normal),
                            ),
                            const SizedBox(width: 8),
                            MyText(
                                color: gray,
                                text: ebookDetailProvider
                                        .relatedBookList?[index].tutorName
                                        .toString() ??
                                    "",
                                fontsizeNormal: Dimens.textSmall,
                                fontsizeWeb: Dimens.textSmall,
                                maxline: 2,
                                overflow: TextOverflow.ellipsis,
                                fontwaight: FontWeight.w600,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ],
                        ),
                        const SizedBox(height: 10),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            MyRating(
                              size: 13,
                              rating: double.parse(ebookDetailProvider
                                      .relatedBookList?[index].avgRating
                                      .toString() ??
                                  ""),
                              spacing: 2,
                            ),
                            const SizedBox(width: 5),
                            MyText(
                                color: colorAccent,
                                text:
                                    "${double.parse(ebookDetailProvider.relatedBookList?[index].avgRating.toString() ?? "")}",
                                fontsizeNormal: Dimens.textBigSmall,
                                fontwaight: FontWeight.w600,
                                maxline: 2,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ],
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            );
          })),
    );
  }

  Widget relatedBookItemShimmer() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(200, 25, 200, 25)
          : const EdgeInsets.fromLTRB(20, 20, 20, 20),
      child: ResponsiveGridList(
        minItemWidth: 160,
        minItemsPerRow: 1,
        maxItemsPerRow: 1,
        listViewBuilderOptions: ListViewBuilderOptions(
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(
          10,
          (index) {
            return const Row(
              children: [
                CustomWidget.roundrectborder(
                  width: 125,
                  height: 110,
                ),
                SizedBox(width: 10),
                Expanded(
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      CustomWidget.roundcorner(
                        width: 180,
                        height: 5,
                      ),
                      SizedBox(height: 8),
                      CustomWidget.roundcorner(
                        width: 180,
                        height: 5,
                      ),
                      SizedBox(height: 8),
                      CustomWidget.roundcorner(
                        width: 180,
                        height: 5,
                      ),
                    ],
                  ),
                ),
              ],
            );
          },
        ),
      ),
    );
  }

/* Review List  */

  Widget buildStudentFeedback() {
    if (ebookDetailProvider.reviewloading &&
        !ebookDetailProvider.reviewloadmore) {
      return const SizedBox.shrink();
    } else {
      if (ebookDetailProvider.getCourseReviewModel.status == 200 &&
          ebookDetailProvider.reviewList != null) {
        if ((ebookDetailProvider.reviewList?.length ?? 0) > 0) {
          return Padding(
            padding: MediaQuery.of(context).size.width > 800
                ? const EdgeInsets.fromLTRB(200, 25, 200, 25)
                : const EdgeInsets.fromLTRB(20, 20, 20, 20),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text: "studentfeedback",
                    fontsizeNormal: Dimens.textTitle,
                    fontwaight: FontWeight.w600,
                    maxline: 1,
                    multilanguage: true,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.center,
                    fontstyle: FontStyle.normal),
                const SizedBox(height: 15),
                buildStudentFeedbackItem(),
                if (ebookDetailProvider.reviewloadmore)
                  Container(
                    height: 50,
                    margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                    child: Utils.pageLoader(),
                  )
                else
                  const SizedBox.shrink(),
              ],
            ),
          );
        } else {
          return const SizedBox.shrink();
        }
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget buildStudentFeedbackItem() {
    return ResponsiveGridList(
      minItemWidth: 120,
      minItemsPerRow: 1,
      maxItemsPerRow: 2,
      horizontalGridSpacing: 10,
      verticalGridSpacing: 15,
      listViewBuilderOptions: ListViewBuilderOptions(
        scrollDirection: Axis.vertical,
        shrinkWrap: true,
        physics: const NeverScrollableScrollPhysics(),
      ),
      children: List.generate(
        ebookDetailProvider.reviewList?.length ?? 0,
        (index) {
          return IntrinsicWidth(
            child: Container(
              padding: const EdgeInsets.fromLTRB(15, 5, 15, 5),
              decoration: BoxDecoration(
                color: Theme.of(context).cardColor,
                borderRadius: BorderRadius.circular(5),
                boxShadow: [
                  BoxShadow(
                    color: gray.withValues(alpha: 0.08),
                    spreadRadius: 1.5,
                    blurRadius: 0.5,
                    offset: const Offset(0, 1),
                  ),
                ],
              ),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      MyNetworkImage(
                        imgWidth: 30,
                        radius: 200,
                        imgHeight: 30,
                        imageUrl:
                            ebookDetailProvider.reviewList?[index].userImage ??
                                "",
                        fit: BoxFit.fill,
                      ),
                      const SizedBox(width: 8),
                      Flexible(
                        fit: FlexFit.loose,
                        child: Align(
                            alignment: Alignment.centerLeft,
                            child: MyText(
                                color: Theme.of(context).colorScheme.surface,
                                text: (ebookDetailProvider
                                                .reviewList?[index].firstName ==
                                            "" &&
                                        (ebookDetailProvider.reviewList?[index]
                                                    .firstName ??
                                                "")
                                            .isEmpty)
                                    ? (ebookDetailProvider
                                            .reviewList?[index].userName
                                            .toString() ??
                                        "")
                                    : ebookDetailProvider
                                            .reviewList?[index].firstName
                                            .toString() ??
                                        "",
                                fontsizeNormal: Dimens.textMedium,
                                fontwaight: FontWeight.w700,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.center,
                                fontstyle: FontStyle.normal)),
                      ),
                      const SizedBox(width: 8),
                      MyText(
                          color: colorPrimary,
                          text: Utils.formateDate(
                              ebookDetailProvider.reviewList?[index].createdAt
                                      .toString() ??
                                  "",
                              Constant.dateformat),
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  const SizedBox(height: 10),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      MyRating(
                        size: 18,
                        rating: double.parse((ebookDetailProvider
                                .reviewList?[index].rating
                                .toString() ??
                            "")),
                        spacing: 3,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text:
                              "${double.parse((ebookDetailProvider.reviewList?[index].rating.toString() ?? ""))}",
                          fontsizeNormal: Dimens.textMedium,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  const SizedBox(height: 10),
                  MyText(
                      color: gray,
                      text: ebookDetailProvider.reviewList?[index].comment
                              .toString() ??
                          "",
                      fontsizeNormal: Dimens.textSmall,
                      fontwaight: FontWeight.w400,
                      maxline: 5,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          );
        },
      ),
    );
  }

/* Buy Button in Bottom */

  Widget buyButton() {
    return Consumer<EbookDetailProvider>(
        builder: (context, ebookdetailprovider, child) {
      if (ebookdetailprovider.loading) {
        return const SizedBox.shrink();
      } else {
        return InkWell(
          hoverColor: transparent,
          highlightColor: transparent,
          focusColor: transparent,
          splashColor: transparent,
          onTap: () async {
            if (Utils.checkLoginUser(context)) {
              if (ebookDetailProvider.ebookDetailModel.result?[0].isFree == 0) {
                if (ebookDetailProvider.ebookDetailModel.result?[0].isUserBuy ==
                    0) {
                  /* Primium Page  */
                  Utils.navigatePage(
                      context,
                      AllPayment(
                        contentType: "4",
                        payType: 'Package',
                        itemId: ebookDetailProvider
                                .ebookDetailModel.result?[0].id
                                .toString() ??
                            "",
                        price: ebookDetailProvider
                                .ebookDetailModel.result?[0].price
                                .toString() ??
                            "",
                        itemTitle: ebookDetailProvider
                                .ebookDetailModel.result?[0].title
                                .toString() ??
                            "",
                      ),
                      '2');
                } else {
                  if (ebookdetailprovider.ebookDetailModel.result?[0].bookUrl ==
                          "" ||
                      ebookdetailprovider.ebookDetailModel.result?[0].bookUrl ==
                          null) {
                    Utils.showSnackbar(
                        context, "fail", "bookcontentnotavailable", true);
                  } else {
                    Utils.navigatePage(
                        context,
                        ReadBook(
                          bookId: ebookdetailprovider
                                  .ebookDetailModel.result?[0].id
                                  .toString() ??
                              "",
                          bookName: ebookdetailprovider
                                  .ebookDetailModel.result?[0].title
                                  .toString() ??
                              "",
                          pdfURL: ebookdetailprovider
                                  .ebookDetailModel.result?[0].bookUrl
                                  .toString() ??
                              "",
                        ),
                        '2');
                  }
                }
              } else {
                if (ebookdetailprovider.ebookDetailModel.result?[0].bookUrl ==
                        "" ||
                    ebookdetailprovider.ebookDetailModel.result?[0].bookUrl ==
                        null) {
                  Utils.showSnackbar(
                      context, "fail", "bookcontentnotavailable", true);
                } else {
                  Utils.navigatePage(
                      context,
                      ReadBook(
                        bookId: ebookdetailprovider
                                .ebookDetailModel.result?[0].id
                                .toString() ??
                            "",
                        bookName: ebookdetailprovider
                                .ebookDetailModel.result?[0].title
                                .toString() ??
                            "",
                        pdfURL: ebookdetailprovider
                                .ebookDetailModel.result?[0].bookUrl
                                .toString() ??
                            "",
                      ),
                      "2");
                }
              }
            }
          },
          child: Container(
            width: MediaQuery.of(context).size.width > 800
                ? 250
                : MediaQuery.of(context).size.width,
            height: 50,
            alignment: Alignment.center,
            padding: const EdgeInsets.fromLTRB(0, 8, 0, 8),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(50),
              color: colorPrimary,
            ),
            child: MyText(
                color: white,
                text: (ebookdetailprovider.ebookDetailModel.result?[0].isFree ==
                        0)
                    ? (ebookdetailprovider
                                .ebookDetailModel.result?[0].isUserBuy ==
                            1)
                        ? "readnow"
                        : "buynow"
                    : "readnow",
                multilanguage: true,
                fontsizeNormal: Dimens.textTitle,
                fontwaight: FontWeight.w600,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
          ),
        );
      }
    });
  }

/* Mobile View Data */
  Widget _buildMobile() {
    return Padding(
      padding: const EdgeInsets.fromLTRB(20, 10, 20, 10),
      child: bookInformationMobile(),
    );
  }

  Widget bookInformationMobile() {
    if (ebookDetailProvider.loading) {
      return bookInformationMobileShimmer();
    } else {
      if (ebookDetailProvider.ebookDetailModel.status == 200 &&
          (ebookDetailProvider.ebookDetailModel.result?.length ?? 0) > 0) {
        return Column(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            MyNetworkImage(
                imgWidth: 150,
                radius: 5,
                imgHeight: 170,
                imageUrl: ebookDetailProvider
                        .ebookDetailModel.result?[0].thumbnailImg
                        .toString() ??
                    "",
                fit: BoxFit.fill),
            const SizedBox(height: 15),
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text: ebookDetailProvider.ebookDetailModel.result?[0].title
                        .toString() ??
                    "",
                fontsizeNormal: Dimens.textBig,
                fontwaight: FontWeight.w700,
                maxline: 3,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal),
            const SizedBox(height: 10),
            MyText(
                color: gray,
                text: ebookDetailProvider.ebookDetailModel.result?[0].tutorName
                        .toString() ??
                    "",
                fontsizeNormal: Dimens.textMedium,
                fontwaight: FontWeight.w500,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal),
          ],
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget bookInformationMobileShimmer() {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      crossAxisAlignment: CrossAxisAlignment.center,
      children: [
        CustomWidget.roundrectborder(
          width: 150,
          height: 170,
        ),
        CustomWidget.roundrectborder(width: 250, height: 10),
        CustomWidget.roundrectborder(width: 150, height: 10),
      ],
    );
  }

/* Add Review BottomSheet */

  Future<Future> addReviewBottomSheet(
      BuildContext context, String courseId) async {
    return showDialog(
        context: context,
        barrierColor: transparent,
        builder: (context) {
          return Dialog(
            shape:
                RoundedRectangleBorder(borderRadius: BorderRadius.circular(15)),
            clipBehavior: Clip.antiAliasWithSaveLayer,
            backgroundColor: Theme.of(context).cardColor,
            child: Consumer<EbookDetailProvider>(
                builder: (context, detailprovider, child) {
              return Container(
                padding: EdgeInsets.all(20.0),
                constraints: BoxConstraints(
                  minWidth: 500,
                  maxWidth: 550,
                  minHeight: 250,
                  maxHeight: 300,
                ),
                color: Theme.of(context).cardColor,
                child: Wrap(
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        MyText(
                            color: Theme.of(context).colorScheme.surface,
                            fontsizeNormal: Dimens.textBig,
                            fontsizeWeb: Dimens.textBig,
                            multilanguage: true,
                            maxline: 1,
                            fontwaight: FontWeight.w600,
                            text: "addreview",
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        RatingBar(
                          initialRating: 0,
                          direction: Axis.horizontal,
                          allowHalfRating: true,
                          itemSize: 25,
                          itemCount: 5,
                          ratingWidget: RatingWidget(
                            full: const Icon(
                              Icons.star,
                              color: colorAccent,
                            ),
                            half:
                                const Icon(Icons.star_half, color: colorAccent),
                            empty: const Icon(Icons.star_border,
                                color: colorAccent),
                          ),
                          itemPadding:
                              const EdgeInsets.symmetric(horizontal: 4.0),
                          onRatingUpdate: (rating) {
                            addrating = rating;
                          },
                        ),
                      ],
                    ),
                    Padding(
                      padding: const EdgeInsets.fromLTRB(0, 20, 0, 20),
                      child: TextField(
                        textAlign: TextAlign.start,
                        controller: commentController,
                        cursorColor: Theme.of(context).colorScheme.surface,
                        keyboardType: TextInputType.multiline,
                        textInputAction: TextInputAction.newline,
                        minLines: 2,
                        maxLines: 5,
                        style: GoogleFonts.inter(
                          fontSize: Dimens.textTitle,
                          fontStyle: FontStyle.normal,
                          color: Theme.of(context).colorScheme.surface,
                          fontWeight: FontWeight.w400,
                        ),
                        decoration: InputDecoration(
                          hintText: Locales.string(context, "addcomment"),
                          hintStyle: GoogleFonts.inter(
                            fontSize: Dimens.textTitle,
                            fontStyle: FontStyle.normal,
                            color: colorPrimary.withValues(alpha: 0.40),
                            fontWeight: FontWeight.w400,
                          ),
                          border: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(8),
                            borderSide: BorderSide(
                                width: 1,
                                color: colorPrimaryDark,
                                style: BorderStyle.solid),
                          ),
                          errorBorder: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(8),
                            borderSide: BorderSide(
                                width: 1,
                                color: colorPrimaryDark,
                                style: BorderStyle.solid),
                          ),
                          focusedBorder: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(8),
                            borderSide: BorderSide(
                                width: 1,
                                color: colorPrimaryDark,
                                style: BorderStyle.solid),
                          ),
                          enabledBorder: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(8),
                            borderSide: BorderSide(
                                width: 1,
                                color: colorPrimaryDark,
                                style: BorderStyle.solid),
                          ),
                          filled: true,
                          contentPadding: const EdgeInsets.all(15),
                          fillColor: white,
                        ),
                      ),
                    ),
                    Padding(
                      padding: const EdgeInsets.fromLTRB(0, 20, 0, 55),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.end,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          InkWell(
                            onTap: () {
                              if (Navigator.canPop(context)) {
                                Navigator.pop(context);
                              }

                              commentController.clear();

                              addrating = 0;
                            },
                            child: Container(
                              padding: const EdgeInsets.fromLTRB(15, 8, 15, 8),
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(5),
                                border: Border.all(
                                  width: 0.8,
                                  color: gray,
                                ),
                              ),
                              child: MyText(
                                  color: black,
                                  fontsizeNormal: Dimens.textTitle,
                                  fontsizeWeb: Dimens.textTitle,
                                  multilanguage: true,
                                  maxline: 1,
                                  fontwaight: FontWeight.w500,
                                  text: "cancel",
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal),
                            ),
                          ),
                          const SizedBox(width: 15),
                          InkWell(
                            onTap: () async {
                              if (addrating == 0.0) {
                                Utils.showSnackbar(
                                    context, "fail", "pleaseenterrating", true);
                              } else if (commentController.text.toString() ==
                                  "") {
                                Utils.showSnackbar(context, "fail",
                                    "pleaseentercomment", true);
                              } else {
                                detailprovider.setAddReviewLoding(true);
                                try {
                                  await detailprovider.addReview("1", courseId,
                                      commentController.text, addrating);

                                  if (detailprovider.successModel.status ==
                                      200) {
                                    detailprovider.setAddReviewLoding(false);
                                    if (!context.mounted) return;
                                    if (Navigator.canPop(context)) {
                                      Navigator.pop(context);
                                    }

                                    commentController.clear();
                                    addrating = 0;
                                    _fetchReviewData(0);
                                    await detailprovider
                                        .getEbooksDetail(widget.ebookId);
                                  } else {
                                    detailprovider.setAddReviewLoding(false);
                                    if (!context.mounted) return;
                                    Navigator.pop(context);
                                    Utils.showSnackbar(
                                        context,
                                        "fail",
                                        detailprovider.successModel.message ??
                                            "",
                                        false);
                                  }
                                } catch (e) {
                                  detailprovider.setAddReviewLoding(false);
                                  printLog(e.toString());
                                  if (!context.mounted) return;
                                  Navigator.pop(context);
                                  Utils.showSnackbar(
                                      context,
                                      "fail",
                                      detailprovider.successModel.message ?? "",
                                      false);
                                }
                              }
                            },
                            child: AnimatedContainer(
                              duration: const Duration(milliseconds: 200),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              curve: Curves.bounceInOut,
                              padding: const EdgeInsets.fromLTRB(15, 8, 15, 8),
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(5),
                                color: colorPrimary,
                              ),
                              child: detailprovider.isReviewLoding
                                  ? const CircularProgressIndicator(
                                      color: white,
                                      strokeWidth: 2,
                                    )
                                  : MyText(
                                      color: white,
                                      fontsizeNormal: Dimens.textTitle,
                                      fontsizeWeb: Dimens.textTitle,
                                      multilanguage: true,
                                      maxline: 1,
                                      fontwaight: FontWeight.w700,
                                      text: "submit",
                                      textalign: TextAlign.left,
                                      fontstyle: FontStyle.normal),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              );
            }),
          );
        });
  }
}
