import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/coursedetailsprovider.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/quize/quize.dart';
import 'package:prakah/subscription/allpayment.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webaddtocart.dart';
import 'package:prakah/webpages/weblogin.dart';
import 'package:prakah/webpages/websearch.dart';
import 'package:prakah/webpages/webtutorprofile.dart';
import 'package:prakah/webwidget/footerweb.dart';
import 'package:prakah/webwidget/interactivecontainer.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:flutter_rating_bar/flutter_rating_bar.dart';
import 'package:font_awesome_flutter/font_awesome_flutter.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:provider/provider.dart';
import 'package:readmore/readmore.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class WebDetail extends StatefulWidget {
  final String courseId;
  const WebDetail({super.key, required this.courseId});

  @override
  State<WebDetail> createState() => WebDetailState();
}

class WebDetailState extends State<WebDetail> {
  CourseDetailsProvider detailProvider = CourseDetailsProvider();
  final ScrollController _scrollController = ScrollController();
  final commentController = TextEditingController();
  double addrating = 0.0;
  final searchController = TextEditingController();

  @override
  void initState() {
    super.initState();
    detailProvider = Provider.of<CourseDetailsProvider>(context, listen: false);

    _scrollController.addListener(_scrollListener);
    getApi();
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (detailProvider.reviewcurrentPage ?? 0) <
            (detailProvider.reviewtotalPage ?? 0)) {
      detailProvider.setReviewLoadMore(true);
      getReviewList(detailProvider.reviewcurrentPage ?? 0);
    }
  }

  Future getApi() async {
    await detailProvider.getCourseDetails(widget.courseId);
    getRelatedList(0);
    getReviewList(0);
    final result = detailProvider.courseDetailsModel.result;

    if (result != null && result.isNotEmpty) {
      final chapterList = result[0].chapter;

      if (chapterList != null && chapterList.isNotEmpty) {
        await detailProvider.openChapterVideo(0, true);
        getVideoByChapter(chapterList[0].id ?? 0, 0, false);
      }
    }
  }

  Future<void> getReviewList(int? nextPage) async {
    await detailProvider.getReviewByCourse(
        "2", widget.courseId, (nextPage ?? 0) + 1);
  }

  Future<void> getRelatedList(int? nextPage) async {
    await detailProvider.getRelatedCourse(widget.courseId, (nextPage ?? 0) + 1);
  }

  Future<void> getVideoByChapter(
      dynamic chapterId, int? nextPage, isViewAll) async {
    await detailProvider.getVideoByChapter(
        widget.courseId, chapterId, (nextPage ?? 0) + 1, isViewAll);
  }

  @override
  void dispose() {
    _scrollController.dispose();
    _scrollController.removeListener(_scrollListener);
    detailProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return _buildSearchHome();
  }

  Widget _buildSearchHome() {
    return Consumer<SearchProvider>(builder: (context, homeprovider, child) {
      if (homeprovider.isSearch == "0") {
        return Scaffold(
          appBar: Utils.webMainAppbar(),
          bottomNavigationBar: MediaQuery.of(context).size.width > 800
              ? SizedBox.shrink()
              : BottomAppBar(
                  color: white,
                  child: Consumer<CourseDetailsProvider>(
                      builder: (context, detailprovider, child) {
                    return Container(
                      height: 70,
                      alignment: Alignment.center,
                      padding: const EdgeInsets.fromLTRB(15, 0, 15, 0),
                      width: MediaQuery.of(context).size.width,
                      color: gray.withValues(alpha: 0.15),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          (detailProvider
                                      .courseDetailsModel.result?[0].isFree ==
                                  0)
                              ? (detailProvider.courseDetailsModel.result?[0]
                                          .isUserBuy ==
                                      0)
                                  ? MyImage(
                                      width: 35,
                                      height: 35,
                                      radius: 50,
                                      imagePath: "ic_premium.png")
                                  : Container(
                                      height: 45,
                                      width: 80,
                                      alignment: Alignment.center,
                                      decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(50),
                                        border:
                                            Border.all(width: 0.7, color: gray),
                                      ),
                                      child: MyText(
                                          color: colorPrimary,
                                          text: "free",
                                          multilanguage: true,
                                          fontsizeNormal: Dimens.textTitle,
                                          fontsizeWeb: Dimens.textTitle,
                                          fontwaight: FontWeight.w700,
                                          maxline: 1,
                                          overflow: TextOverflow.ellipsis,
                                          textalign: TextAlign.left,
                                          fontstyle: FontStyle.normal),
                                    )
                              : Container(
                                  height: 45,
                                  width: 80,
                                  alignment: Alignment.center,
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(50),
                                    border: Border.all(width: 0.7, color: gray),
                                  ),
                                  child: MyText(
                                      color: colorPrimary,
                                      text: "free",
                                      multilanguage: true,
                                      fontsizeNormal: Dimens.textTitle,
                                      fontsizeWeb: Dimens.textTitle,
                                      fontwaight: FontWeight.w700,
                                      maxline: 1,
                                      overflow: TextOverflow.ellipsis,
                                      textalign: TextAlign.left,
                                      fontstyle: FontStyle.normal),
                                ),
                          const SizedBox(width: 10),
                          Expanded(
                            child: InkWell(
                              onTap: () async {
                                if (Utils.checkLoginUser(context)) {
                                  if (detailProvider.courseDetailsModel
                                          .result?[0].isFree ==
                                      0) {
                                    if (detailProvider.courseDetailsModel
                                            .result?[0].isUserBuy ==
                                        0) {
                                      if (detailProvider.courseDetailsModel
                                              .result?[0].isCart ==
                                          0) {
                                        await detailProvider
                                            .getAddToCart(widget.courseId);
                                      } else {
                                        Navigator.of(context).push(
                                          PageRouteBuilder(
                                            pageBuilder: (context, animation,
                                                    secondaryAnimation) =>
                                                const WebAddToCart(),
                                            transitionsBuilder: (context,
                                                animation,
                                                secondaryAnimation,
                                                child) {
                                              const begin = Offset(1.0, 0.0);
                                              const end = Offset.zero;
                                              const curve = Curves.ease;

                                              var tween = Tween(
                                                      begin: begin, end: end)
                                                  .chain(
                                                      CurveTween(curve: curve));

                                              return SlideTransition(
                                                position:
                                                    animation.drive(tween),
                                                child: child,
                                              );
                                            },
                                          ),
                                        );
                                      }
                                    } else {
                                      /* Open Video Player */
                                      if ((detailProvider.videoList == null ||
                                              (detailProvider
                                                          .videoList?.length ??
                                                      0) ==
                                                  0) &&
                                          (detailProvider.courseDetailsModel
                                                      .result?[0].chapter ==
                                                  null ||
                                              (detailProvider
                                                          .courseDetailsModel
                                                          .result?[0]
                                                          .chapter
                                                          ?.length ??
                                                      0) ==
                                                  0)) {
                                        Utils.showSnackbar(context, "info",
                                            "video_not_found", true);
                                      } else {
                                        Utils.openPlayer(
                                            context: context,
                                            type: "video",
                                            secreateKey: "",
                                            viewApiType: 1,
                                            videoId:
                                                detailProvider.videoList?[0].id ??
                                                    0,
                                            videoUrl: detailProvider
                                                    .videoList?[0].videoUrl
                                                    .toString() ??
                                                "",
                                            vUploadType: detailProvider
                                                    .videoList?[0].videoType
                                                    .toString() ??
                                                "",
                                            videoThumb: detailProvider
                                                    .videoList?[0].landscapeImg
                                                    .toString() ??
                                                "",
                                            courseId: detailProvider
                                                    .courseDetailsModel
                                                    .result?[0]
                                                    .id ??
                                                0,
                                            chepterId: detailProvider.courseDetailsModel.result?[0].chapter?[0].id ?? 0);
                                      }
                                    }
                                  } else {
                                    /* Open Video Player */
                                    if ((detailProvider.videoList?.length ??
                                                0) <
                                            0 &&
                                        (detailProvider
                                                    .courseDetailsModel
                                                    .result?[0]
                                                    .chapter
                                                    ?.length ??
                                                0) <
                                            0) {
                                      Utils.showSnackbar(context, "info",
                                          "video_not_found", true);
                                    } else {
                                      Utils.openPlayer(
                                          context: context,
                                          type: "video",
                                          secreateKey: "",
                                          viewApiType: 1,
                                          videoId:
                                              detailProvider.videoList?[0].id ??
                                                  0,
                                          videoUrl: detailProvider
                                                  .videoList?[0].videoUrl
                                                  .toString() ??
                                              "",
                                          vUploadType: detailProvider
                                                  .videoList?[0].videoType
                                                  .toString() ??
                                              "",
                                          videoThumb: detailProvider
                                                  .videoList?[0].landscapeImg
                                                  .toString() ??
                                              "",
                                          courseId: detailProvider
                                                  .courseDetailsModel
                                                  .result?[0]
                                                  .id ??
                                              0,
                                          chepterId: detailProvider.courseDetailsModel.result?[0].chapter?[0].id ?? 0);
                                    }
                                  }
                                }
                              },
                              child: Container(
                                width: MediaQuery.of(context).size.width,
                                height: 45,
                                alignment: Alignment.center,
                                padding: const EdgeInsets.fromLTRB(0, 8, 0, 8),
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(50),
                                  color: colorPrimary,
                                ),
                                child: MyText(
                                    color: white,
                                    text: (detailProvider.courseDetailsModel
                                                .result?[0].isFree ==
                                            0)
                                        ? (detailProvider.courseDetailsModel
                                                    .result?[0].isUserBuy ==
                                                0)
                                            ? (detailProvider.courseDetailsModel
                                                        .result?[0].isCart ==
                                                    0)
                                                ? "add_to_cart"
                                                : "view_cart"
                                            : "startcourse"
                                        : "startcourse",
                                    multilanguage: true,
                                    fontsizeNormal: Dimens.textTitle,
                                    fontsizeWeb: Dimens.textTitle,
                                    fontwaight: FontWeight.w600,
                                    maxline: 1,
                                    overflow: TextOverflow.ellipsis,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                              ),
                            ),
                          ),
                        ],
                      ),
                    );
                  }),
                ),
          body: Consumer<CourseDetailsProvider>(
              builder: (context, detailprovider, child) {
            return Utils.hoverItemWithPage(
                myWidget: SingleChildScrollView(
              physics: const BouncingScrollPhysics(),
              scrollDirection: Axis.vertical,
              child: Column(
                spacing: 10,
                children: [
                  Utils.buildWebDetailsAppBar(
                      context: context, title: "course_detail"),
                  (detailprovider.loading)
                      ? commanShimmer()
                      : (detailprovider.courseDetailsModel.status == 200 &&
                              (detailprovider
                                          .courseDetailsModel.result?.length ??
                                      0) >
                                  0)
                          ? buildLayout()
                          : const NoData(),
                ],
              ),
            ));
          }),
        );
      } else {
        return WebSearch(
          searchController: searchController,
        );
      }
    });
  }

  Widget buildLayout() {
    if (MediaQuery.of(context).size.width > 800) {
      return buildWeb();
    } else {
      return buildMobile();
    }
  }

  /* Web Layouts Start */

  Widget buildWeb() {
    return Stack(
      children: [
        Column(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Container(
              constraints: BoxConstraints(
                maxWidth: MediaQuery.of(context).size.width * 0.60,
              ),

              // color: gray,
              padding: EdgeInsets.only(
                left: MediaQuery.of(context).size.width > 1600
                    ? 200
                    : MediaQuery.of(context).size.width > 1200
                        ? 200
                        : 20,
              ),
              child: parentConainerWeb(),
            ),
            Container(
              constraints: BoxConstraints(
                maxWidth: MediaQuery.of(context).size.width * 0.60,
              ),
              padding: EdgeInsets.only(
                top: 10,
                bottom: 50,
                left: MediaQuery.of(context).size.width > 1600
                    ? 200
                    : MediaQuery.of(context).size.width > 1200
                        ? 200
                        : 20,
              ),
              // color: orange,
              child: childItem(),
            ),
            const FooterWeb(),
          ],
        ),
        Positioned.fill(
          top: 100,
          left: 20,
          right: MediaQuery.of(context).size.width > 1600
              ? 200
              : MediaQuery.of(context).size.width > 1200
                  ? 200
                  : MediaQuery.of(context).size.width > 1000
                      ? 50
                      : 20,
          child: Align(
            alignment: Alignment.topRight,
            child: Container(
              constraints: BoxConstraints(
                  maxWidth: MediaQuery.of(context).size.width > 1600
                      ? MediaQuery.of(context).size.width * 0.20
                      : MediaQuery.of(context).size.width > 1200
                          ? MediaQuery.of(context).size.width * 0.22
                          : MediaQuery.of(context).size.width > 1000
                              ? MediaQuery.of(context).size.width * 0.28
                              : MediaQuery.of(context).size.width * 0.34),
              padding: EdgeInsets.fromLTRB(20, 10, 20, 10),
              decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(30),
                  boxShadow: [
                    BoxShadow(
                        blurRadius: 20,
                        color: transparent.withValues(alpha: 0.05),
                        blurStyle: BlurStyle.outer,
                        offset: Offset(0, 6),
                        spreadRadius: 0)
                  ],
                  border: Border.all(
                      width: 0.8, color: gray.withValues(alpha: 0.2)),
                  color: white),
              child: rightLayout(),
            ),
          ),
        ),
      ],
    );
  }

  Widget parentConainerWeb() {
    return SizedBox(
        width: MediaQuery.of(context).size.width * 0.6,
        child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisSize: MainAxisSize.min,
            spacing: 14,
            children: [
              /* Category Name */
              MyText(
                  color: black,
                  text: detailProvider
                          .courseDetailsModel.result?[0].categoryName
                          .toString() ??
                      "",
                  fontsizeNormal: Dimens.textMedium,
                  fontsizeWeb: Dimens.textExtralargeBig,
                  fontwaight: FontWeight.w400,
                  maxline: 1,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),

              // DetailVideo Title Text
              MyText(
                  color: black,
                  text: detailProvider.courseDetailsModel.result?[0].title
                          .toString() ??
                      "",
                  fontsizeNormal: Dimens.textExtra,
                  fontsizeWeb: Dimens.textExtra,
                  fontwaight: FontWeight.w700,
                  maxline: 1,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),

              //  Course Rating with Rating Count
              Row(
                  mainAxisAlignment: MainAxisAlignment.start,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    InkWell(
                      onTap: () {
                        Navigator.of(context).push(
                          PageRouteBuilder(
                            transitionDuration:
                                const Duration(milliseconds: 200),
                            pageBuilder: (BuildContext context,
                                Animation<double> animation,
                                Animation<double> secondaryAnimation) {
                              return WebTutorProfile(
                                tutorid: detailProvider
                                        .courseDetailsModel.result?[0].tutorId
                                        .toString() ??
                                    "",
                              );
                            },
                            transitionsBuilder: (BuildContext context,
                                Animation<double> animation,
                                Animation<double> secondaryAnimation,
                                Widget child) {
                              return Align(
                                child: FadeTransition(
                                  opacity: animation,
                                  child: child,
                                ),
                              );
                            },
                          ),
                        );
                      },
                      child: MyText(
                          color: red,
                          text: detailProvider
                                  .courseDetailsModel.result?[0].tutorName
                                  .toString() ??
                              "",
                          fontsizeNormal: Dimens.textTitle,
                          fontsizeWeb: Dimens.textTitle,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ),
                    const SizedBox(width: 15),
                    Icon(Icons.star,
                        size: 20, color: colorAccent.withValues(alpha: 0.6)),
                    const SizedBox(width: 10),
                    MyText(
                        color: colorAccent,
                        text: detailProvider
                                .courseDetailsModel.result?[0].avgRating
                                .toString() ??
                            "",
                        fontsizeNormal: Dimens.textTitle,
                        fontsizeWeb: Dimens.textTitle,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                    const SizedBox(width: 10),
                    MyText(
                        color: gray,
                        text:
                            "(${Utils.kmbGenerator(detailProvider.courseDetailsModel.result?[0].totalReview ?? 0)})",
                        fontsizeNormal: Dimens.textTitle,
                        fontsizeWeb: Dimens.textTitle,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ]),

              /* Course Image */
              InkWell(
                onTap: () async {
                  if (Utils.checkLoginUser(context)) {
                    if (detailProvider.courseDetailsModel.result?[0].isFree ==
                        0) {
                      if (detailProvider
                              .courseDetailsModel.result?[0].isUserBuy ==
                          0) {
                        await detailProvider.getAddToCart(widget.courseId);
                      } else {
                        /* Open Video Player */
                        if ((detailProvider.videoList == null ||
                                (detailProvider.videoList?.length ?? 0) == 0) &&
                            (detailProvider.courseDetailsModel.result?[0]
                                        .chapter ==
                                    null ||
                                (detailProvider.courseDetailsModel.result?[0]
                                            .chapter?.length ??
                                        0) ==
                                    0)) {
                          Utils.showSnackbar(
                              context, "info", "video_not_found", true);
                        } else {
                          Utils.openPlayer(
                            context: context,
                            secreateKey: "",
                            type: "video",
                            videoId: detailProvider.videoList?[0].id ?? 0,
                            videoUrl: detailProvider.videoList?[0].videoUrl
                                    .toString() ??
                                "",
                            vUploadType: detailProvider.videoList?[0].videoType
                                    .toString() ??
                                "",
                            videoThumb: detailProvider
                                    .videoList?[0].landscapeImg
                                    .toString() ??
                                "",
                            courseId: detailProvider
                                    .courseDetailsModel.result?[0].id ??
                                0,
                            chepterId: detailProvider.courseDetailsModel
                                    .result?[0].chapter?[0].id ??
                                0,
                            viewApiType: 1,
                          );
                        }
                      }
                      /* Primium Page  */
                    } else {
                      /* Open Video Player */
                      if ((detailProvider.videoList == null ||
                              (detailProvider.videoList?.length ?? 0) == 0) &&
                          (detailProvider
                                      .courseDetailsModel.result?[0].chapter ==
                                  null ||
                              (detailProvider.courseDetailsModel.result?[0]
                                          .chapter?.length ??
                                      0) ==
                                  0)) {
                        Utils.showSnackbar(
                            context, "info", "video_not_found", true);
                      } else {
                        Utils.openPlayer(
                          context: context,
                          secreateKey: "",
                          type: "video",
                          videoId: detailProvider.videoList?[0].id ?? 0,
                          videoUrl: detailProvider.videoList?[0].videoUrl
                                  .toString() ??
                              "",
                          vUploadType: detailProvider.videoList?[0].videoType
                                  .toString() ??
                              "",
                          videoThumb: detailProvider.videoList?[0].landscapeImg
                                  .toString() ??
                              "",
                          courseId:
                              detailProvider.courseDetailsModel.result?[0].id ??
                                  0,
                          chepterId: detailProvider.courseDetailsModel
                                  .result?[0].chapter?[0].id ??
                              0,
                          viewApiType: 1,
                        );
                      }
                    }
                  }
                },
                child: Stack(
                  alignment: Alignment.center,
                  children: [
                    MyNetworkImage(
                        imgHeight: 300,
                        radius: 30,
                        fit: BoxFit.contain,
                        islandscap: true,
                        imageUrl: detailProvider
                                .courseDetailsModel.result?[0].thumbnailImg
                                .toString() ??
                            ""),
                    Positioned(
                      child: Align(
                        alignment: Alignment.center,
                        child: Container(
                          height: 60,
                          width: 60,
                          decoration: BoxDecoration(
                              color: black.withValues(alpha: 0.8),
                              borderRadius: BorderRadius.circular(10)),
                          alignment: Alignment.center,
                          child: Icon(Icons.play_arrow_outlined,
                              size: 30, color: colorPrimary),
                        ),
                      ),
                    ),
                  ],
                ),
              ),

              /* Tab Data Show */
              detailsTabData(),
            ]));
  }

  Widget detailsTabData() {
    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      mainAxisAlignment: MainAxisAlignment.start,
      spacing: 24,
      children: [
        InkWell(
          splashColor: transparent,
          focusColor: transparent,
          hoverColor: transparent,
          highlightColor: transparent,
          onTap: () {
            detailProvider.setDetailsTab("1");
          },
          child: Container(
            padding: EdgeInsets.only(bottom: 6),
            decoration: BoxDecoration(
                border: Border(
                    bottom: BorderSide(
                        width: 1,
                        color: detailProvider.tabDetails == "1"
                            ? red
                            : transparent,
                        style: BorderStyle.solid))),
            child: MyText(
                color: black,
                text: "description",
                fontsizeNormal: Dimens.textTitle,
                fontsizeWeb: Dimens.textMedium,
                fontwaight: FontWeight.w400,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
          ),
        ),
        InkWell(
          splashColor: transparent,
          focusColor: transparent,
          hoverColor: transparent,
          highlightColor: transparent,
          onTap: () {
            detailProvider.setDetailsTab("2");

            /* APi call */
            detailProvider.clearVideoChapter();
            getVideoByChapter(
                detailProvider.courseDetailsModel.result?[0].chapter?[0].id
                        .toString() ??
                    "",
                0,
                false);
          },
          child: Container(
            padding: EdgeInsets.only(bottom: 6),
            decoration: BoxDecoration(
                border: Border(
                    bottom: BorderSide(
                        width: 1,
                        color: detailProvider.tabDetails == "2"
                            ? red
                            : transparent,
                        style: BorderStyle.solid))),
            child: MyText(
                color: black,
                text: "courses",
                fontsizeNormal: Dimens.textTitle,
                fontsizeWeb: Dimens.textMedium,
                fontwaight: FontWeight.w400,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
          ),
        )
      ],
    );
  }

  Widget childItem() {
    return SizedBox(
      width: MediaQuery.of(context).size.width * 0.55,
      child: detailProvider.tabDetails == "1"
          ? Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                // Course Discription
                ReadMoreText(
                  "${detailProvider.courseDetailsModel.result?[0].description.toString() ?? ""}  ",
                  trimLines: 5,
                  textAlign: TextAlign.left,
                  style: TextStyle(
                      fontSize: Dimens.textMedium,
                      fontWeight: FontWeight.w400,
                      color: black),
                  trimCollapsedText: 'Read More',
                  colorClickableText: black,
                  trimMode: TrimMode.Line,
                  trimExpandedText: 'Read less',
                  lessStyle: TextStyle(
                      fontSize: Dimens.textMedium,
                      fontWeight: FontWeight.w600,
                      color: colorAccent),
                  moreStyle: TextStyle(
                      fontSize: Dimens.textMedium,
                      fontWeight: FontWeight.w600,
                      color: colorAccent),
                ),

                Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      MyText(
                          color: black,
                          text: "update",
                          multilanguage: true,
                          fontsizeNormal: Dimens.textMedium,
                          fontsizeWeb: Dimens.textMedium,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      const SizedBox(width: 3),
                      MyText(
                          color: black,
                          text: Utils.formateDate(
                              detailProvider
                                      .courseDetailsModel.result?[0].updatedAt
                                      .toString() ??
                                  "",
                              Constant.dateformat),
                          fontsizeNormal: Dimens.textMedium,
                          fontsizeWeb: Dimens.textMedium,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal)
                    ]),
                const SizedBox(height: 20),
                courseInclude(),
                const SizedBox(height: 20),
                whatYouLearn(),
                const SizedBox(height: 20),
                requirementBox(),

                const SizedBox(height: 20),
                relatedCourse(),
                const SizedBox(height: 20),
                buildStudentFeedback(),
              ],
            )
          : courseEpisodes(),
    );
  }

  Widget rightLayout() {
    return Column(
      mainAxisAlignment: MainAxisAlignment.start,
      crossAxisAlignment: CrossAxisAlignment.start,
      mainAxisSize: MainAxisSize.min,
      children: [
        /* Free And Paid Text */
        MyText(
            color: black,
            text: ((detailProvider.courseDetailsModel.result?[0].isFree
                            .toString() ??
                        "") ==
                    "0")
                ? ((detailProvider.courseDetailsModel.result?[0].isUserBuy
                                .toString() ??
                            "") ==
                        "0")
                    ? "${Constant.currencyCode} ${detailProvider.courseDetailsModel.result?[0].price ?? 0}"
                    : Locales.string(context, "free")
                : Locales.string(context, "free"),
            multilanguage: false,
            fontsizeNormal: Dimens.textlargeBig,
            fontsizeWeb: Dimens.textlargeBig,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.left,
            fontstyle: FontStyle.normal),
        const SizedBox(height: 15),
        /* Enroll Button */
        InkWell(
          splashColor: transparent,
          focusColor: transparent,
          hoverColor: transparent,
          onTap: () async {
            if (Utils.checkLoginUser(context)) {
              if (detailProvider.courseDetailsModel.result?[0].isFree == 0) {
                if (detailProvider.courseDetailsModel.result?[0].isUserBuy ==
                    0) {
                  if (detailProvider.courseDetailsModel.result?[0].isCart ==
                      0) {
                    await detailProvider.getAddToCart(widget.courseId);
                  } else {
                    Utils.navigatePage(context, const WebAddToCart(), '2');
                  }
                } else {
                  /* Open Video Player */
                  if ((detailProvider.videoList == null ||
                          (detailProvider.videoList?.length ?? 0) == 0) &&
                      (detailProvider.courseDetailsModel.result?[0].chapter ==
                              null ||
                          (detailProvider.courseDetailsModel.result?[0].chapter
                                      ?.length ??
                                  0) ==
                              0)) {
                    Utils.showSnackbar(
                        context, "info", "video_not_found", true);
                  } else {
                    Utils.openPlayer(
                        context: context,
                        type: "video",
                        viewApiType: 1,
                        secreateKey: "",
                        videoId: detailProvider.videoList?[0].id ?? 0,
                        videoUrl:
                            detailProvider.videoList?[0].videoUrl.toString() ??
                                "",
                        vUploadType:
                            detailProvider.videoList?[0].videoType.toString() ??
                                "",
                        videoThumb: detailProvider.videoList?[0].landscapeImg
                                .toString() ??
                            "",
                        courseId:
                            detailProvider.courseDetailsModel.result?[0].id ??
                                0,
                        chepterId: detailProvider
                                .courseDetailsModel.result?[0].chapter?[0].id ??
                            0);
                  }
                }
              } else {
                /* Open Video Player */
                if ((detailProvider.videoList?.length ?? 0) < 0 &&
                    (detailProvider.courseDetailsModel.result?[0].chapter
                                ?.length ??
                            0) <
                        0) {
                  Utils.showSnackbar(context, "info", "video_not_found", true);
                } else {
                  Utils.openPlayer(
                      context: context,
                      type: "video",
                      secreateKey: "",
                      viewApiType: 1,
                      videoId: detailProvider.videoList?[0].id ?? 0,
                      videoUrl:
                          detailProvider.videoList?[0].videoUrl.toString() ??
                              "",
                      vUploadType:
                          detailProvider.videoList?[0].videoType.toString() ??
                              "",
                      videoThumb: detailProvider.videoList?[0].landscapeImg
                              .toString() ??
                          "",
                      courseId:
                          detailProvider.courseDetailsModel.result?[0].id ?? 0,
                      chepterId: detailProvider
                              .courseDetailsModel.result?[0].chapter?[0].id ??
                          0);
                }
              }
            }
          },
          child: InteractiveContainer(child: (isHovered) {
            return AnimatedScale(
              scale: isHovered ? 1.03 : 1,
              duration: const Duration(milliseconds: 500),
              curve: Curves.easeInOut,
              child: Container(
                width: MediaQuery.of(context).size.width,
                height: 40,
                alignment: Alignment.center,
                padding: const EdgeInsets.fromLTRB(0, 8, 0, 8),
                decoration: BoxDecoration(
                    color: colorPrimaryDark,
                    borderRadius: BorderRadius.circular(18)),
                child: MyText(
                    color: white,
                    text:
                        (detailProvider.courseDetailsModel.result?[0].isFree ==
                                0)
                            ? (detailProvider.courseDetailsModel.result?[0]
                                        .isUserBuy ==
                                    0)
                                ? (detailProvider.courseDetailsModel.result?[0]
                                            .isCart ==
                                        0)
                                    ? "add_to_cart"
                                    : "view_cart"
                                : "startcourse"
                            : "startcourse",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textTitle,
                    fontsizeWeb: Dimens.textTitle,
                    fontwaight: FontWeight.w600,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
            );
          }),
        ),
        SizedBox(height: 15),
        /* Wishlist Button */
        InkWell(
          splashColor: transparent,
          focusColor: transparent,
          hoverColor: transparent,
          onTap: () async {
            if (Utils.checkLoginUser(context)) {
              detailProvider.addRemoveWishlist(
                  "3",
                  detailProvider.courseDetailsModel.result?[0].id.toString() ??
                      "");
            }
          },
          child: InteractiveContainer(child: (isHovered) {
            return Container(
              width: MediaQuery.of(context).size.width,
              height: 40,
              alignment: Alignment.center,
              padding: const EdgeInsets.fromLTRB(0, 8, 0, 8),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(18),
                border: Border.all(
                  width: 0.8,
                  color: gray,
                ),
                color: isHovered ? gray.withValues(alpha: 0.20) : transparent,
              ),
              child: AnimatedScale(
                scale: isHovered ? 1.03 : 1,
                duration: const Duration(milliseconds: 500),
                curve: Curves.easeInOut,
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  mainAxisAlignment: MainAxisAlignment.center,
                  spacing: 10,
                  children: [
                    Icon(
                      detailProvider.courseDetailsModel.result?[0].isWishlist ==
                              1
                          ? Icons.favorite
                          : Icons.favorite_border,
                      color: detailProvider
                                  .courseDetailsModel.result?[0].isWishlist ==
                              1
                          ? red
                          : gray,
                    ),
                    Flexible(
                      fit: FlexFit.loose,
                      child: MyText(
                          color: gray,
                          text: detailProvider.courseDetailsModel.result?[0]
                                      .isWishlist ==
                                  1
                              ? "removetowishlist"
                              : "addtowishlist",
                          multilanguage: true,
                          fontsizeNormal: Dimens.textTitle,
                          fontsizeWeb: Dimens.textTitle,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ),
                  ],
                ),
              ),
            );
          }),
        ),
        /* Add Review */
        const SizedBox(height: 15),
        InkWell(
          splashColor: transparent,
          focusColor: transparent,
          hoverColor: transparent,
          onTap: () async {
            if (Utils.checkLoginUser(context)) {
              if ((detailProvider.courseDetailsModel.result?[0].isFree
                          .toString() ??
                      "") ==
                  "0") {
                if ((detailProvider.courseDetailsModel.result?[0].isUserBuy
                            .toString() ??
                        "") ==
                    "0") {
                  await detailProvider.getAddToCart(detailProvider
                          .courseDetailsModel.result?[0].id
                          .toString() ??
                      "");
                } else {
                  addReviewBottomSheet(
                      context,
                      detailProvider.courseDetailsModel.result?[0].id
                              .toString() ??
                          "");
                }
              } else {
                addReviewBottomSheet(
                    context,
                    detailProvider.courseDetailsModel.result?[0].id
                            .toString() ??
                        "");
              }
            }
          },
          child: InteractiveContainer(child: (isHovered) {
            return Container(
              width: MediaQuery.of(context).size.width,
              height: 40,
              alignment: Alignment.center,
              padding: const EdgeInsets.fromLTRB(0, 8, 0, 8),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(18),
                border: Border.all(
                  width: 0.8,
                  color: gray,
                ),
                color: isHovered ? gray.withValues(alpha: 0.20) : transparent,
              ),
              child: AnimatedScale(
                scale: isHovered ? 1.03 : 1,
                duration: const Duration(milliseconds: 500),
                curve: Curves.easeInOut,
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  mainAxisAlignment: MainAxisAlignment.center,
                  spacing: 10,
                  children: [
                    const Icon(
                      Icons.star,
                      color: colorAccent,
                    ),
                    Flexible(
                      fit: FlexFit.loose,
                      child: MyText(
                          color: gray,
                          text: "addreviewandcomment",
                          multilanguage: true,
                          fontsizeNormal: Dimens.textTitle,
                          fontsizeWeb: Dimens.textTitle,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ),
                  ],
                ),
              ),
            );
          }),
        ),

        /* Total Chepter Count */
        const SizedBox(height: 15),
        Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          spacing: 20,
          children: [
            Icon(Icons.menu_book_rounded, size: 20, color: gray),
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text:
                    "${Utils.kmbGenerator(detailProvider.courseDetailsModel.result?[0].chapter?.length ?? 0)} ${Locales.string(context, "lectures")}",
                multilanguage: false,
                fontsizeNormal: Dimens.textTitle,
                fontsizeWeb: Dimens.textTitle,
                fontwaight: FontWeight.w500,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
          ],
        ),

        /* Studens Enroll Count */
        const SizedBox(height: 15),
        Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          spacing: 20,
          children: [
            Icon(FontAwesomeIcons.user, size: 20, color: gray),
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text:
                    "${Utils.kmbGenerator(detailProvider.courseDetailsModel.result?[0].totalView ?? 0)} ${Locales.string(context, "students")}",
                multilanguage: false,
                fontsizeNormal: Dimens.textTitle,
                fontsizeWeb: Dimens.textTitle,
                fontwaight: FontWeight.w500,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
          ],
        ),
        /* Language  */
        const SizedBox(height: 15),
        Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          spacing: 20,
          children: [
            Icon(Icons.volume_up_rounded, size: 20, color: gray),
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text:
                    "${detailProvider.courseDetailsModel.result?[0].languageName ?? ""} ${Locales.string(context, "language")}",
                multilanguage: false,
                fontsizeNormal: Dimens.textTitle,
                fontsizeWeb: Dimens.textTitle,
                fontwaight: FontWeight.w500,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
          ],
        ),

        /* Total Duration count  */
        const SizedBox(height: 15),
        Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          spacing: 20,
          children: [
            Icon(Icons.live_tv_outlined, size: 20, color: gray),
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text:
                    "${Utils.formatDuration(double.parse(detailProvider.courseDetailsModel.result?[0].totalDuration.toString() ?? ""))} ${Locales.string(context, "total_lenghts")}",
                multilanguage: false,
                fontsizeNormal: Dimens.textTitle,
                fontsizeWeb: Dimens.textTitle,
                fontwaight: FontWeight.w500,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
          ],
        ),

        // generateCertificate(),
      ],
    );
  }

/* Web Layouts End */

/* Mobile Layouts Start */

  Widget buildMobile() {
    return Column(
      children: [
        parentConainerMobile(),
        childContainerMobile(),
        const FooterWeb(),
      ],
    );
  }

  Widget parentConainerMobile() {
    return Padding(
      padding: const EdgeInsets.all(15.0),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Stack(
            children: [
              Container(
                foregroundDecoration: BoxDecoration(
                    color: black.withValues(alpha: 0.25),
                    borderRadius: BorderRadius.circular(10)),
                child: ClipRRect(
                  borderRadius: BorderRadius.circular(10),
                  child: MyNetworkImage(
                      imgHeight: 350,
                      fit: BoxFit.fill,
                      islandscap: true,
                      imageUrl: detailProvider
                              .courseDetailsModel.result?[0].thumbnailImg
                              .toString() ??
                          ""),
                ),
              ),
              Positioned.fill(
                child: InkWell(
                    onTap: () async {
                      if (Utils.checkLoginUser(context)) {
                        if (detailProvider
                                .courseDetailsModel.result?[0].isFree ==
                            0) {
                          if (detailProvider
                                  .courseDetailsModel.result?[0].isUserBuy ==
                              0) {
                            await detailProvider.getAddToCart(widget.courseId);
                          } else {
                            /* Open Video Player */
                            if ((detailProvider.videoList == null &&
                                    (detailProvider.videoList?.length ?? 0) <
                                        0) &&
                                (detailProvider.courseDetailsModel.result?[0]
                                            .chapter?.length ??
                                        0) <
                                    0) {
                              Utils.showSnackbar(
                                  context, "info", "video_not_found", true);
                            } else {
                              Utils.openPlayer(
                                context: context,
                                secreateKey: "",
                                viewApiType: 1,
                                type: "video",
                                videoId: detailProvider.videoList?[0].id ?? 0,
                                videoUrl: detailProvider.videoList?[0].videoUrl
                                        .toString() ??
                                    "",
                                vUploadType: detailProvider
                                        .videoList?[0].videoType
                                        .toString() ??
                                    "",
                                videoThumb: detailProvider
                                        .videoList?[0].landscapeImg
                                        .toString() ??
                                    "",
                                courseId: detailProvider
                                        .courseDetailsModel.result?[0].id ??
                                    0,
                                chepterId: detailProvider.courseDetailsModel
                                        .result?[0].chapter?[0].id ??
                                    0,
                              );
                            }
                          }
                          /* Primium Page  */
                        } else {
                          /* Open Video Player */
                          if ((detailProvider.videoList == null &&
                                  (detailProvider.videoList?.length ?? 0) <
                                      0) &&
                              (detailProvider.courseDetailsModel.result?[0]
                                          .chapter?.length ??
                                      0) <
                                  0) {
                            Utils.showSnackbar(
                                context, "info", "video_not_found", true);
                          } else {
                            Utils.openPlayer(
                              context: context,
                              secreateKey: "",
                              viewApiType: 1,
                              type: "video",
                              videoId: detailProvider.videoList?[0].id ?? 0,
                              videoUrl: detailProvider.videoList?[0].videoUrl
                                      .toString() ??
                                  "",
                              vUploadType: detailProvider
                                      .videoList?[0].videoType
                                      .toString() ??
                                  "",
                              videoThumb: detailProvider
                                      .videoList?[0].landscapeImg
                                      .toString() ??
                                  "",
                              courseId: detailProvider
                                      .courseDetailsModel.result?[0].id ??
                                  0,
                              chepterId: detailProvider.courseDetailsModel
                                      .result?[0].chapter?[0].id ??
                                  0,
                            );
                          }
                        }
                      }
                    },
                    child: Container(
                        height: 60,
                        width: 60,
                        decoration: BoxDecoration(
                            color: black.withValues(alpha: 0.8),
                            borderRadius: BorderRadius.circular(10)),
                        alignment: Alignment.center,
                        child: Icon(Icons.play_arrow_outlined,
                            size: 30, color: colorPrimary))),
              ),
            ],
          ),
          const SizedBox(height: 15),
          // DetailVideo Title Text
          Row(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              Expanded(
                child: MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text: detailProvider.courseDetailsModel.result?[0].title
                            .toString() ??
                        "",
                    fontsizeNormal: Dimens.textBig,
                    fontsizeWeb: Dimens.textBig,
                    fontwaight: FontWeight.w700,
                    maxline: 3,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
              const SizedBox(width: 15),
              InkWell(
                hoverColor: transparent,
                highlightColor: transparent,
                onTap: () async {
                  if (Utils.checkLoginUser(context)) {
                    detailProvider.addRemoveWishlist(
                        "3",
                        detailProvider.courseDetailsModel.result?[0].id
                                .toString() ??
                            "");
                  }
                },
                child: Container(
                  width: 45,
                  height: 45,
                  alignment: Alignment.center,
                  padding: const EdgeInsets.fromLTRB(0, 8, 0, 8),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(50),
                    border: Border.all(
                      width: 0.8,
                      color: Theme.of(context).colorScheme.surface,
                    ),
                    color: transparent,
                  ),
                  child: AnimatedScale(
                    scale: 1,
                    duration: const Duration(milliseconds: 500),
                    curve: Curves.easeInOut,
                    child: Icon(
                      detailProvider.courseDetailsModel.result?[0].isWishlist ==
                              1
                          ? Icons.favorite
                          : Icons.favorite_border,
                      color: detailProvider
                                  .courseDetailsModel.result?[0].isWishlist ==
                              1
                          ? red
                          : Theme.of(context).colorScheme.surface,
                    ),
                  ),
                ),
              ),
              const SizedBox(width: 15),
              InkWell(
                hoverColor: transparent,
                highlightColor: transparent,
                onTap: () async {
                  if (Utils.checkLoginUser(context)) {
                    if ((detailProvider.courseDetailsModel.result?[0].isFree
                                .toString() ??
                            "") ==
                        "0") {
                      if ((detailProvider
                                  .courseDetailsModel.result?[0].isUserBuy
                                  .toString() ??
                              "") ==
                          "0") {
                        await detailProvider.getAddToCart(detailProvider
                                .courseDetailsModel.result?[0].id
                                .toString() ??
                            "");
                      } else {
                        addReviewBottomSheet(
                            context,
                            detailProvider.courseDetailsModel.result?[0].id
                                    .toString() ??
                                "");
                      }
                    } else {
                      addReviewBottomSheet(
                          context,
                          detailProvider.courseDetailsModel.result?[0].id
                                  .toString() ??
                              "");
                    }
                  }
                },
                child: InteractiveContainer(child: (isHovered) {
                  return Container(
                    width: 45,
                    height: 45,
                    alignment: Alignment.center,
                    padding: const EdgeInsets.fromLTRB(0, 8, 0, 8),
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(50),
                      border: Border.all(
                        width: 0.8,
                        color: Theme.of(context).colorScheme.surface,
                      ),
                      color: isHovered
                          ? gray.withValues(alpha: 0.20)
                          : transparent,
                    ),
                    child: AnimatedScale(
                      scale: isHovered ? 1.03 : 1,
                      duration: const Duration(milliseconds: 500),
                      curve: Curves.easeInOut,
                      child: const Icon(
                        Icons.star,
                        color: colorAccent,
                      ),
                    ),
                  );
                }),
              ),
            ],
          ),
          const SizedBox(height: 10),

          //  Course Rating with Rating Count
          Row(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              MyRating(
                  rating: double.parse(
                    detailProvider.courseDetailsModel.result?[0].avgRating
                            .toString() ??
                        "",
                  ),
                  spacing: 1,
                  size: 20),
              const SizedBox(width: 10),
              MyText(
                  color: colorAccent,
                  text:
                      "${double.parse(detailProvider.courseDetailsModel.result?[0].avgRating.toString() ?? "")}",
                  fontsizeNormal: Dimens.textTitle,
                  fontsizeWeb: Dimens.textTitle,
                  fontwaight: FontWeight.w600,
                  maxline: 1,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            ],
          ),
          const SizedBox(height: 10),

          Row(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              MyText(
                  color: gray,
                  text: Utils.kmbGenerator(
                      (detailProvider.courseDetailsModel.result?[0].totalView ??
                              0)
                          .round()),
                  fontsizeNormal: Dimens.textSmall,
                  fontsizeWeb: Dimens.textSmall,
                  fontwaight: FontWeight.w400,
                  maxline: 1,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
              const SizedBox(width: 5),
              MyText(
                  color: gray,
                  text: "students",
                  fontsizeNormal: Dimens.textSmall,
                  fontsizeWeb: Dimens.textSmall,
                  fontwaight: FontWeight.w400,
                  maxline: 1,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal,
                  multilanguage: true),
            ],
          ),
          const SizedBox(height: 10),
          // Course Discription
          ReadMoreText(
            "${detailProvider.courseDetailsModel.result?[0].description.toString() ?? ""}  ",
            trimLines: 5,
            textAlign: TextAlign.left,
            style: TextStyle(
                fontSize: Dimens.textSmall,
                fontWeight: FontWeight.w400,
                color: gray),
            trimCollapsedText: 'Read More',
            colorClickableText: black,
            trimMode: TrimMode.Line,
            trimExpandedText: 'Read less',
            lessStyle: TextStyle(
                fontSize: Dimens.textSmall,
                fontWeight: FontWeight.w600,
                color: black),
            moreStyle: TextStyle(
                fontSize: Dimens.textSmall,
                fontWeight: FontWeight.w600,
                color: black),
          ),

          const SizedBox(height: 10),

          // Created By List
          Row(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              MyText(
                  color: Theme.of(context).colorScheme.surface,
                  text: "createdby",
                  fontsizeNormal: Dimens.textTitle,
                  fontwaight: FontWeight.w600,
                  maxline: 1,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal,
                  multilanguage: true),
              const SizedBox(width: 3),
              Expanded(
                child: InkWell(
                  onTap: () {
                    Navigator.of(context).push(
                      PageRouteBuilder(
                        transitionDuration: const Duration(milliseconds: 200),
                        pageBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation) {
                          return WebTutorProfile(
                            tutorid: detailProvider
                                    .courseDetailsModel.result?[0].tutorId
                                    .toString() ??
                                "",
                          );
                        },
                        transitionsBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation,
                            Widget child) {
                          return Align(
                            child: FadeTransition(
                              opacity: animation,
                              child: child,
                            ),
                          );
                        },
                      ),
                    );
                  },
                  child: MyText(
                      color: colorPrimary,
                      text: detailProvider
                                  .courseDetailsModel.result?[0].tutorName ==
                              ""
                          ? "Guest User"
                          : detailProvider
                                  .courseDetailsModel.result?[0].tutorName
                                  .toString() ??
                              "",
                      fontsizeNormal: Dimens.textTitle,
                      fontwaight: FontWeight.w700,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
              ),
            ],
          ),
          const SizedBox(height: 10),
          Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  MyText(
                      color: gray,
                      text: "totalhours",
                      fontsizeNormal: Dimens.textSmall,
                      multilanguage: true,
                      fontwaight: FontWeight.w500,
                      maxline: 1,
                      fontsizeWeb: Dimens.textSmall,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  const SizedBox(width: 3),
                  MyText(
                      color: gray,
                      text: Utils.formatDuration(double.parse(detailProvider
                              .courseDetailsModel.result?[0].totalDuration
                              .toString() ??
                          "")),
                      fontsizeNormal: Dimens.textSmall,
                      fontwaight: FontWeight.w500,
                      maxline: 1,
                      fontsizeWeb: Dimens.textSmall,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
              const SizedBox(height: 10),
              Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  MyText(
                      color: gray,
                      text: "update",
                      multilanguage: true,
                      fontsizeNormal: Dimens.textSmall,
                      fontwaight: FontWeight.w500,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  const SizedBox(width: 3),
                  MyText(
                      color: gray,
                      text: Utils.formateDate(
                          detailProvider.courseDetailsModel.result?[0].updatedAt
                                  .toString() ??
                              "",
                          Constant.dateformat),
                      fontsizeNormal: Dimens.textSmall,
                      fontwaight: FontWeight.w500,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
              const SizedBox(height: 10),
              Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  MyText(
                      color: gray,
                      text: "language",
                      multilanguage: true,
                      fontsizeNormal: Dimens.textSmall,
                      fontwaight: FontWeight.w500,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  const SizedBox(width: 3),
                  MyText(
                      color: gray,
                      text: detailProvider
                              .courseDetailsModel.result?[0].languageName
                              .toString() ??
                          "",
                      fontsizeNormal: Dimens.textSmall,
                      fontwaight: FontWeight.w500,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ],
          ),
        ],
      ),
    );
  }

  Widget childContainerMobile() {
    return SizedBox(
      width: MediaQuery.of(context).size.width,
      // color: white,
      child: Padding(
        padding: const EdgeInsets.fromLTRB(15, 15, 15, 15),
        child: Column(
          children: [
            courseInclude(),
            const SizedBox(height: 15),
            whatYouLearn(),
            const SizedBox(height: 15),
            requirementBox(),
            const SizedBox(height: 15),
            discription(),
            const SizedBox(height: 15),
            relatedCourse(),
            const SizedBox(height: 15),
            courseEpisodes(),
            generateCertificate(),
            const SizedBox(height: 20),
            buildStudentFeedback(),
          ],
        ),
      ),
    );
  }

/* Mobile Layouts End */

/* This Course Include */

  Widget courseInclude() {
    if (detailProvider.courseDetailsModel.result?[0].inlcude != null &&
        (detailProvider.courseDetailsModel.result?[0].inlcude?.length ?? 0) >
            0) {
      return InteractiveContainer(child: (isHovered) {
        return AnimatedScale(
          scale: isHovered ? 1.03 : 1,
          duration: const Duration(milliseconds: 500),
          curve: Curves.easeInOut,
          child: Container(
            padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
            decoration: BoxDecoration(
              color: colorPrimary.withValues(alpha: 0.10),
              borderRadius: const BorderRadius.all(
                Radius.circular(10.0),
              ),
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    fontwaight: FontWeight.w600,
                    fontsizeNormal: Dimens.textlargeBig,
                    fontsizeWeb: Dimens.textlargeBig,
                    overflow: TextOverflow.ellipsis,
                    maxline: 1,
                    text: "thiscouurseincludes",
                    textalign: TextAlign.center,
                    fontstyle: FontStyle.normal,
                    multilanguage: true),
                const SizedBox(height: 10),
                ListView.builder(
                  scrollDirection: Axis.vertical,
                  shrinkWrap: true,
                  physics: const NeverScrollableScrollPhysics(),
                  itemCount: detailProvider
                      .courseDetailsModel.result?[0].inlcude?.length,
                  itemBuilder: (BuildContext context, int index) {
                    return Padding(
                      padding: const EdgeInsets.fromLTRB(0, 10, 0, 0),
                      child: Row(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          Icon(
                            Icons.check,
                            size: 20,
                            color: colorPrimaryDark,
                          ),
                          const SizedBox(width: 14),
                          Expanded(
                            child: MyText(
                                color: gray,
                                fontwaight: FontWeight.w500,
                                fontsizeNormal: Dimens.textTitle,
                                fontsizeWeb: Dimens.textTitle,
                                overflow: TextOverflow.ellipsis,
                                maxline: 2,
                                text: detailProvider.courseDetailsModel
                                        .result?[0].inlcude?[index].title
                                        .toString() ??
                                    "",
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ),
                        ],
                      ),
                    );
                  },
                ),
                const SizedBox(height: 10),
              ],
            ),
          ),
        );
      });
    } else {
      return const SizedBox.shrink();
    }
  }

/* What You Learn */

  Widget whatYouLearn() {
    if (detailProvider.courseDetailsModel.result?[0].whatYouLearn != null &&
        (detailProvider.courseDetailsModel.result?[0].whatYouLearn?.length ??
                0) >
            0) {
      return InteractiveContainer(child: (isHovered) {
        return AnimatedScale(
          scale: isHovered ? 1.03 : 1,
          duration: const Duration(milliseconds: 500),
          curve: Curves.easeInOut,
          child: Container(
            padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
            decoration: BoxDecoration(
              color: colorPrimary.withValues(alpha: 0.10),
              borderRadius: const BorderRadius.all(
                Radius.circular(10.0),
              ),
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    fontwaight: FontWeight.w600,
                    fontsizeNormal: Dimens.textlargeBig,
                    fontsizeWeb: Dimens.textlargeBig,
                    overflow: TextOverflow.ellipsis,
                    maxline: 1,
                    text: "whatyoulearn",
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal,
                    multilanguage: true),
                const SizedBox(height: 10),
                ListView.builder(
                  scrollDirection: Axis.vertical,
                  shrinkWrap: true,
                  physics: const NeverScrollableScrollPhysics(),
                  itemCount: detailProvider
                          .courseDetailsModel.result?[0].whatYouLearn?.length ??
                      0,
                  itemBuilder: (BuildContext context, int index) {
                    return Padding(
                      padding: const EdgeInsets.only(top: 10),
                      child: Row(
                        children: [
                          Icon(
                            Icons.check,
                            size: 20,
                            color: colorPrimaryDark,
                          ),
                          const SizedBox(width: 14),
                          Expanded(
                            child: MyText(
                                color: gray,
                                fontwaight: FontWeight.w400,
                                fontsizeNormal: Dimens.textTitle,
                                fontsizeWeb: Dimens.textTitle,
                                overflow: TextOverflow.ellipsis,
                                maxline: 3,
                                text: detailProvider.courseDetailsModel
                                        .result?[0].whatYouLearn?[index].title
                                        .toString() ??
                                    "",
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ),
                        ],
                      ),
                    );
                  },
                ),
                const SizedBox(height: 15),
              ],
            ),
          ),
        );
      });
    } else {
      return const SizedBox.shrink();
    }
  }

/* Requirmemt Box */

  Widget requirementBox() {
    if (detailProvider.courseDetailsModel.result![0].requrirment != null &&
        (detailProvider.courseDetailsModel.result![0].requrirment?.length ??
                0) >
            0) {
      return Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          MyText(
              color: Theme.of(context).colorScheme.surface,
              fontwaight: FontWeight.w600,
              fontsizeNormal: Dimens.textlargeBig,
              fontsizeWeb: Dimens.textlargeBig,
              overflow: TextOverflow.ellipsis,
              maxline: 1,
              text: "requirments",
              textalign: TextAlign.center,
              fontstyle: FontStyle.normal,
              multilanguage: true),
          const SizedBox(height: 10),
          ListView.builder(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics(),
            itemCount: detailProvider
                    .courseDetailsModel.result?[0].requrirment?.length ??
                0,
            itemBuilder: (BuildContext context, int index) {
              return Padding(
                padding: const EdgeInsets.only(top: 10),
                child: Column(
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        Icon(
                          Icons.check,
                          size: 20,
                          color: colorPrimaryDark,
                        ),
                        const SizedBox(width: 14),
                        Expanded(
                          child: MyText(
                              color: gray,
                              fontwaight: FontWeight.w400,
                              fontsizeNormal: Dimens.textTitle,
                              fontsizeWeb: Dimens.textTitle,
                              overflow: TextOverflow.ellipsis,
                              maxline: 3,
                              text: detailProvider.courseDetailsModel.result?[0]
                                      .requrirment?[index].title
                                      .toString() ??
                                  "",
                              textalign: TextAlign.left,
                              fontstyle: FontStyle.normal),
                        ),
                      ],
                    ),
                  ],
                ),
              );
            },
          ),
          const SizedBox(height: 10),
        ],
      );
    } else {
      return const SizedBox.shrink();
    }
  }

/* Discription */

  Widget discription() {
    if (detailProvider.courseDetailsModel.result?[0].description != "") {
      return Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          MyText(
              color: Theme.of(context).colorScheme.surface,
              fontwaight: FontWeight.w600,
              fontsizeNormal: Dimens.textlargeBig,
              fontsizeWeb: Dimens.textlargeBig,
              overflow: TextOverflow.ellipsis,
              maxline: 1,
              text: "description",
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal,
              multilanguage: true),
          const SizedBox(height: 10),
          MyText(
              color: gray,
              fontsizeNormal: Dimens.textTitle,
              fontsizeWeb: Dimens.textTitle,
              text: detailProvider.courseDetailsModel.result?[0].description
                      .toString() ??
                  "",
              maxline: 5,
              fontwaight: FontWeight.w400,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
        ],
      );
    } else {
      return const SizedBox.shrink();
    }
  }

/* Related Course */

  Widget relatedCourse() {
    return Consumer<CourseDetailsProvider>(
        builder: (context, detailprovider, child) {
      if (detailprovider.loading && !detailprovider.relatedCourseloadmore) {
        return Utils.pageLoader();
      } else {
        if (detailprovider.relatedCourseModel.status == 200 &&
            detailProvider.relatedCourseList != null &&
            (detailProvider.relatedCourseModel.result?.length ?? 0) > 0) {
          return Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              MyText(
                  color: black,
                  fontwaight: FontWeight.w600,
                  fontsizeNormal: Dimens.textlargeBig,
                  fontsizeWeb: Dimens.textlargeBig,
                  overflow: TextOverflow.ellipsis,
                  maxline: 1,
                  text: "Related Course",
                  textalign: TextAlign.center,
                  fontstyle: FontStyle.normal,
                  multilanguage: false),
              const SizedBox(height: 20),
              relatedCourseItem(),
              if (detailprovider.relatedCourseloadmore)
                Container(
                  height: 50,
                  margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                  child: Utils.pageLoader(),
                )
              else
                const SizedBox.shrink(),
            ],
          );
        } else {
          return const SizedBox.shrink();
        }
      }
    });
  }

  Widget relatedCourseItem() {
    return ResponsiveGridList(
      minItemWidth: 120,
      minItemsPerRow: 1,
      maxItemsPerRow: 1,
      horizontalGridSpacing: 10,
      verticalGridSpacing: 25,
      listViewBuilderOptions: ListViewBuilderOptions(
        scrollDirection: Axis.vertical,
        shrinkWrap: true,
        physics: const NeverScrollableScrollPhysics(),
      ),
      children: List.generate(
        detailProvider.relatedCourseList?.length ?? 0,
        (index) {
          return InkWell(
            onTap: () {
              Navigator.of(context).pushReplacement(
                PageRouteBuilder(
                  transitionDuration: const Duration(milliseconds: 200),
                  pageBuilder: (BuildContext context,
                      Animation<double> animation,
                      Animation<double> secondaryAnimation) {
                    return WebDetail(
                        courseId: detailProvider.relatedCourseList?[index].id
                                .toString() ??
                            "");
                  },
                  transitionsBuilder: (BuildContext context,
                      Animation<double> animation,
                      Animation<double> secondaryAnimation,
                      Widget child) {
                    return Align(
                      child: FadeTransition(
                        opacity: animation,
                        child: child,
                      ),
                    );
                  },
                ),
              );
            },
            child: InteractiveContainer(child: (isHovered) {
              return AnimatedScale(
                scale: isHovered ? 1.03 : 1,
                duration: const Duration(milliseconds: 500),
                curve: Curves.easeInOut,
                child: Container(
                  width: MediaQuery.of(context).size.width,
                  decoration: BoxDecoration(
                    color: Theme.of(context).cardColor,
                    borderRadius: BorderRadius.circular(5),
                    boxShadow: [
                      BoxShadow(
                        color: gray.withValues(alpha: 0.50),
                        blurRadius: 2,
                        offset: const Offset(0.1, 0.1),
                      ),
                    ],
                  ),
                  child: Row(
                    children: [
                      ClipRRect(
                        borderRadius: const BorderRadius.only(
                            bottomLeft: Radius.circular(10),
                            topLeft: Radius.circular(10)),
                        child: MyNetworkImage(
                          imgWidth: MediaQuery.of(context).size.width > 800
                              ? 135
                              : 110,
                          imgHeight: MediaQuery.of(context).size.width > 800
                              ? 110
                              : 100,
                          imageUrl: detailProvider
                                  .relatedCourseList?[index].thumbnailImg
                                  .toString() ??
                              "",
                          fit: BoxFit.fill,
                        ),
                      ),
                      const SizedBox(width: 10),
                      Expanded(
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.center,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            MyText(
                                color: Theme.of(context).colorScheme.surface,
                                text: detailProvider
                                        .relatedCourseList?[index].title
                                        .toString() ??
                                    "",
                                fontsizeNormal:
                                    MediaQuery.of(context).size.width > 800
                                        ? Dimens.textTitle
                                        : Dimens.textBigSmall,
                                fontsizeWeb:
                                    MediaQuery.of(context).size.width > 800
                                        ? Dimens.textTitle
                                        : Dimens.textBigSmall,
                                fontwaight: FontWeight.w600,
                                maxline: 2,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                            const SizedBox(height: 8),
                            MyText(
                                color: gray,
                                text:
                                    "${Utils.kmbGenerator(int.parse(detailProvider.relatedCourseList?[index].totalView.toString() ?? ""))} Students",
                                fontsizeNormal:
                                    MediaQuery.of(context).size.width > 800
                                        ? Dimens.textDesc
                                        : Dimens.textSmall,
                                fontsizeWeb:
                                    MediaQuery.of(context).size.width > 800
                                        ? Dimens.textDesc
                                        : Dimens.textSmall,
                                fontwaight: FontWeight.w400,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                            const SizedBox(height: 8),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              children: [
                                MyRating(
                                    rating: double.parse((detailProvider
                                            .relatedCourseList?[index].avgRating
                                            .toString() ??
                                        "")),
                                    spacing: 1,
                                    size: 18),
                                const SizedBox(width: 8),
                                MyText(
                                    color: colorAccent,
                                    text:
                                        "${(detailProvider.relatedCourseList?[index].avgRating ?? 0)}",
                                    fontsizeNormal:
                                        MediaQuery.of(context).size.width > 800
                                            ? Dimens.textDesc
                                            : Dimens.textSmall,
                                    fontsizeWeb:
                                        MediaQuery.of(context).size.width > 800
                                            ? Dimens.textDesc
                                            : Dimens.textSmall,
                                    fontwaight: FontWeight.w600,
                                    maxline: 1,
                                    overflow: TextOverflow.ellipsis,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              );
            }),
          );
        },
      ),
    );
  }

/* course Episodes */

  Widget courseEpisodes() {
    if (detailProvider.courseDetailsModel.result![0].chapter != null &&
        (detailProvider.courseDetailsModel.result?[0].chapter?.length ?? 0) >
            0) {
      return ListView.builder(
        scrollDirection: Axis.vertical,
        shrinkWrap: true,
        physics: const NeverScrollableScrollPhysics(),
        itemCount:
            detailProvider.courseDetailsModel.result?[0].chapter?.length ?? 0,
        itemBuilder: (BuildContext context, int index) {
          return InkWell(
            hoverColor: transparent,
            highlightColor: transparent,
            focusColor: transparent,
            splashColor: transparent,
            onTap: () async {
              if (detailProvider.chapterIndex == index &&
                  detailProvider.isOpen == true) {
                await detailProvider.openChapterVideo(index, false);
                detailProvider.clearVideoChapter();
              } else {
                await detailProvider.openChapterVideo(index, true);
                getVideoByChapter(
                    detailProvider
                            .courseDetailsModel.result?[0].chapter?[index].id
                            .toString() ??
                        "",
                    0,
                    false);
              }
            },
            child: InteractiveContainer(child: (isHovered) {
              return Padding(
                padding: const EdgeInsets.only(bottom: 10),
                child: AnimatedContainer(
                  duration: const Duration(milliseconds: 800),
                  curve: Curves.easeIn,
                  height: detailProvider.chapterIndex == index &&
                          detailProvider.isOpen == true
                      ? null
                      : 60,
                  alignment: Alignment.center,
                  decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(10),
                      border: Border.all(
                          color: isHovered
                              ? colorPrimary.withValues(alpha: 0.50)
                              : gray.withValues(alpha: 0.50),
                          width: 0.5)),
                  padding: const EdgeInsets.fromLTRB(18, 18, 18, 0),
                  child: SingleChildScrollView(
                    scrollDirection: Axis.vertical,
                    physics: const NeverScrollableScrollPhysics(),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Row(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Expanded(
                              child: MyText(
                                  color: Theme.of(context).colorScheme.surface,
                                  fontsizeNormal: Dimens.textTitle,
                                  fontsizeWeb: Dimens.textTitle,
                                  maxline: 2,
                                  fontwaight: FontWeight.w600,
                                  text:
                                      "${(index + 1)}.  ${detailProvider.courseDetailsModel.result?[0].chapter?[index].name.toString() ?? ""}",
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal),
                            ),
                            Icon(
                              detailProvider.chapterIndex == index &&
                                      detailProvider.isOpen == true
                                  ? Icons.keyboard_arrow_up
                                  : Icons.keyboard_arrow_down,
                              color: gray,
                            ),
                          ],
                        ),
                        const SizedBox(height: 25),
                        chapterVideoList(
                            index,
                            detailProvider.courseDetailsModel.result?[0]
                                    .chapter?[index].id ??
                                0),
                        const SizedBox(height: 10),
                        /* ViewAll Button  */
                        if ((detailProvider.videocurrentPage ?? 0) <
                                (detailProvider.videototalPage ?? 0) &&
                            !detailProvider.videoloadmore)
                          Align(
                            alignment: Alignment.center,
                            child: InkWell(
                              onTap: () async {
                                detailProvider.setVideoLoadMore(true);
                                getVideoByChapter(
                                    detailProvider.courseDetailsModel.result?[0]
                                            .chapter?[index].id
                                            .toString() ??
                                        "",
                                    detailProvider.videocurrentPage ?? 0,
                                    true);
                              },
                              child: Padding(
                                padding:
                                    const EdgeInsets.fromLTRB(15, 20, 15, 20),
                                child: MyText(
                                    color:
                                        Theme.of(context).colorScheme.surface,
                                    fontsizeNormal: Dimens.textMedium,
                                    maxline: 2,
                                    multilanguage: true,
                                    fontwaight: FontWeight.w600,
                                    text: "viewall",
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                              ),
                            ),
                          ),
                        /* ViewAll ProgressBar  */
                        if (detailProvider.videoloadmore)
                          const Align(
                            alignment: Alignment.center,
                            child: SizedBox(
                              width: 20,
                              height: 20,
                              child: CircularProgressIndicator(
                                color: colorPrimary,
                                strokeWidth: 1,
                              ),
                            ),
                          ),
                      ],
                    ),
                  ),
                ),
              );
            }),
          );
        },
      );
    } else {
      return const SizedBox.shrink();
    }
  }

/* Chepter Video List in DropDown */

  Widget chapterVideoList(int index, chapterId) {
    if (detailProvider.chapterIndex == index && detailProvider.isOpen == true) {
      if (detailProvider.videoloading && !detailProvider.videoloadmore) {
        return const Align(
          alignment: Alignment.center,
          child: SizedBox(
            width: 20,
            height: 20,
            child: CircularProgressIndicator(
              color: colorPrimary,
              strokeWidth: 1,
            ),
          ),
        );
      } else {
        if (detailProvider.getVideoByChapterModel.status == 200 &&
            detailProvider.videoList != null) {
          if ((detailProvider.videoList?.length ?? 0) > 0) {
            return Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                ListView.separated(
                  scrollDirection: Axis.vertical,
                  separatorBuilder: (context, indexSaprate) =>
                      const SizedBox(height: 25),
                  itemCount: detailProvider.videoList?.length ?? 0,
                  physics: const NeverScrollableScrollPhysics(),
                  shrinkWrap: true,
                  itemBuilder: (context, position) {
                    return InkWell(
                      hoverColor: transparent,
                      highlightColor: transparent,
                      focusColor: transparent,
                      splashColor: transparent,
                      onTap: () {
                        if (Constant.userID == null) {
                          /* Login Page */
                          Navigator.of(context).push(
                            PageRouteBuilder(
                              transitionDuration:
                                  const Duration(milliseconds: 200),
                              pageBuilder: (BuildContext context,
                                  Animation<double> animation,
                                  Animation<double> secondaryAnimation) {
                                return const WebLogin();
                              },
                              transitionsBuilder: (BuildContext context,
                                  Animation<double> animation,
                                  Animation<double> secondaryAnimation,
                                  Widget child) {
                                return Align(
                                  child: FadeTransition(
                                    opacity: animation,
                                    child: child,
                                  ),
                                );
                              },
                            ),
                          );
                        } else {
                          if (detailProvider
                                      .courseDetailsModel.result?[0].isFree ==
                                  0 &&
                              detailProvider.courseDetailsModel.result?[0]
                                      .isUserBuy !=
                                  1) {
                            /* Primium Page  */

                            Navigator.of(context).push(
                              PageRouteBuilder(
                                transitionDuration:
                                    const Duration(milliseconds: 200),
                                pageBuilder: (BuildContext context,
                                    Animation<double> animation,
                                    Animation<double> secondaryAnimation) {
                                  return AllPayment(
                                    /* ContentType 1 == Book */
                                    /* ContentType 2 == Course */
                                    contentType: "2",
                                    payType: 'Content',
                                    itemId: detailProvider
                                            .courseDetailsModel.result?[0].id
                                            .toString() ??
                                        "",
                                    price: detailProvider
                                            .courseDetailsModel.result?[0].price
                                            .toString() ??
                                        "",
                                    itemTitle: detailProvider
                                            .courseDetailsModel.result?[0].title
                                            .toString() ??
                                        "",
                                    productPackage: "",
                                  );
                                },
                                transitionsBuilder: (BuildContext context,
                                    Animation<double> animation,
                                    Animation<double> secondaryAnimation,
                                    Widget child) {
                                  return Align(
                                    child: FadeTransition(
                                      opacity: animation,
                                      child: child,
                                    ),
                                  );
                                },
                              ),
                            );
                          } else {
                            /* Open Video Player */
                            if (detailProvider.videoList == null ||
                                (detailProvider.videoList?.length ?? 0) == 0) {
                              Utils.showSnackbar(
                                  context, "info", "video_not_found", true);
                            } else {
                              printLog(
                                  "vUploadType==> ${detailProvider.videoList?[position].videoType.toString() ?? ""}");
                              printLog(
                                  "videoUrl==> ${detailProvider.videoList?[position].videoUrl.toString() ?? ""}");
                              if ((detailProvider.videoList == null ||
                                      (detailProvider.videoList?.length ?? 0) ==
                                          0) &&
                                  (detailProvider.courseDetailsModel.result?[0]
                                              .chapter ==
                                          null ||
                                      (detailProvider.courseDetailsModel
                                                  .result?[0].chapter?.length ??
                                              0) ==
                                          0)) {
                                Utils.showSnackbar(
                                    context, "info", "video_not_found", true);
                              } else {
                                Utils.openPlayer(
                                  context: context,
                                  type: "video",
                                  viewApiType: 1,
                                  secreateKey: "",
                                  videoId:
                                      detailProvider.videoList?[position].id ??
                                          0,
                                  videoUrl: detailProvider
                                          .videoList?[position].videoUrl
                                          .toString() ??
                                      "",
                                  vUploadType: detailProvider
                                          .videoList?[position].videoType
                                          .toString() ??
                                      "",
                                  videoThumb: detailProvider
                                          .videoList?[position].landscapeImg
                                          .toString() ??
                                      "",
                                  courseId: detailProvider
                                          .courseDetailsModel.result?[0].id ??
                                      0,
                                  chepterId: chapterId,
                                );
                              }
                            }
                          }
                        }
                      },
                      child: InteractiveContainer(child: (isHovered) {
                        return AnimatedScale(
                          scale: isHovered ? 1.01 : 1,
                          duration: const Duration(milliseconds: 500),
                          curve: Curves.easeInOut,
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              MyText(
                                  color: colorPrimary,
                                  fontsizeNormal: Dimens.textBig,
                                  fontsizeWeb: Dimens.textBig,
                                  maxline: 2,
                                  fontwaight: FontWeight.w600,
                                  text: "${(position + 1)}.",
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal),
                              const SizedBox(width: 15),
                              Expanded(
                                child: MyText(
                                    color: colorPrimary,
                                    fontsizeNormal: Dimens.textDesc,
                                    fontsizeWeb: Dimens.textDesc,
                                    maxline: 3,
                                    fontwaight: FontWeight.w600,
                                    text: detailProvider
                                            .videoList?[position].title
                                            .toString() ??
                                        "",
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                              ),
                              const SizedBox(width: 10),
                              detailProvider.videoList?[position].isRead == 1
                                  ? Container(
                                      decoration: BoxDecoration(
                                        color: colorAccent,
                                        border:
                                            Border.all(width: 1, color: white),
                                      ),
                                      child: const Icon(
                                        Icons.check,
                                        size: 18,
                                        color: white,
                                      ),
                                    )
                                  : const Icon(
                                      Icons.play_circle,
                                      color: colorPrimary,
                                      size: 25,
                                    )
                            ],
                          ),
                        );
                      }),
                    );
                  },
                ),
                detailProvider.courseDetailsModel.result?[0].chapter?[index]
                            .quizStatus ==
                        0
                    ? const SizedBox.shrink()
                    : InkWell(
                        hoverColor: transparent,
                        highlightColor: transparent,
                        focusColor: transparent,
                        splashColor: transparent,
                        onTap: () {
                          if (Constant.userID == null) {
                            Navigator.of(context).push(
                              PageRouteBuilder(
                                transitionDuration:
                                    const Duration(milliseconds: 200),
                                pageBuilder: (BuildContext context,
                                    Animation<double> animation,
                                    Animation<double> secondaryAnimation) {
                                  return const WebLogin();
                                },
                                transitionsBuilder: (BuildContext context,
                                    Animation<double> animation,
                                    Animation<double> secondaryAnimation,
                                    Widget child) {
                                  return Align(
                                    child: FadeTransition(
                                      opacity: animation,
                                      child: child,
                                    ),
                                  );
                                },
                              ),
                            );
                          } else {
                            if (detailProvider.courseDetailsModel.result?[0]
                                    .chapter?[index].isQuizPlay ==
                                0) {
                              Utils.showSnackbar(context, "fail",
                                  "pleasewatchallvideos", true);
                            } else {
                              Navigator.of(context).pushReplacement(
                                PageRouteBuilder(
                                  pageBuilder: (context, animation,
                                          secondaryAnimation) =>
                                      Quize(
                                    courseId: int.parse(widget.courseId),
                                    chapterId: chapterId,
                                  ),
                                  transitionsBuilder: (context, animation,
                                      secondaryAnimation, child) {
                                    const begin = Offset(1.0, 0.0);
                                    const end = Offset.zero;
                                    const curve = Curves.ease;

                                    var tween = Tween(begin: begin, end: end)
                                        .chain(CurveTween(curve: curve));

                                    return SlideTransition(
                                      position: animation.drive(tween),
                                      child: child,
                                    );
                                  },
                                ),
                              );
                            }
                          }
                        },
                        child: Padding(
                          padding: const EdgeInsets.only(top: 25, bottom: 25),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              MyText(
                                  color: colorPrimary,
                                  fontsizeNormal: Dimens.textBig,
                                  fontsizeWeb: Dimens.textBig,
                                  maxline: 2,
                                  fontwaight: FontWeight.w600,
                                  text:
                                      "${((detailProvider.videoList?.length ?? 0) + 1).toString()}.",
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal),
                              const SizedBox(width: 15),
                              Expanded(
                                child: MyText(
                                    color: colorPrimary,
                                    fontsizeNormal: Dimens.textDesc,
                                    fontsizeWeb: Dimens.textDesc,
                                    maxline: 3,
                                    fontwaight: FontWeight.w600,
                                    text: "Play Quiz",
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                              ),
                              const SizedBox(width: 10),
                              detailProvider.courseDetailsModel.result?[0]
                                          .chapter?[index].isQuizPlay ==
                                      1
                                  ? Container(
                                      decoration: BoxDecoration(
                                        color: colorAccent,
                                        border:
                                            Border.all(width: 1, color: white),
                                      ),
                                      child: const Icon(
                                        Icons.check,
                                        size: 16,
                                        color: white,
                                      ),
                                    )
                                  : const Icon(
                                      Icons.play_circle,
                                      color: colorPrimary,
                                      size: 25,
                                    )
                            ],
                          ),
                        ),
                      ),
              ],
            );
          } else {
            return Align(
              alignment: Alignment.centerLeft,
              child: MyText(
                  color: colorPrimary,
                  fontsizeNormal: Dimens.textMedium,
                  maxline: 2,
                  fontwaight: FontWeight.w600,
                  text: "No Video Found",
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            );
          }
        } else {
          return Align(
            alignment: Alignment.centerLeft,
            child: MyText(
                color: colorPrimary,
                fontsizeNormal: Dimens.textMedium,
                maxline: 2,
                fontwaight: FontWeight.w600,
                text: "No Video Found",
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
          );
        }
      }
    } else {
      return const SizedBox.shrink();
    }
  }

/* Student Comments And Review List */

  Widget buildStudentFeedback() {
    if (detailProvider.reviewloading && !detailProvider.reviewloadmore) {
      return Utils.pageLoader();
    } else {
      if (detailProvider.getCourseReviewModel.status == 200 &&
          detailProvider.reviewList != null) {
        if ((detailProvider.reviewList?.length ?? 0) > 0) {
          return Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              MyText(
                  color: Theme.of(context).colorScheme.surface,
                  text: "studentfeedback",
                  fontsizeNormal: Dimens.textlargeBig,
                  fontsizeWeb: Dimens.textlargeBig,
                  fontwaight: FontWeight.w600,
                  maxline: 1,
                  multilanguage: true,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.center,
                  fontstyle: FontStyle.normal),
              const SizedBox(height: 20),
              MediaQuery.of(context).size.width > 800
                  ? buildStudentFeedbackItemWeb()
                  : buildStudentFeedbackItemMobile(),
              if (detailProvider.reviewloadmore)
                Container(
                  height: 50,
                  margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                  child: Utils.pageLoader(),
                )
              else
                const SizedBox.shrink(),
            ],
          );
        } else {
          return const SizedBox.shrink();
        }
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget buildStudentFeedbackItemMobile() {
    return ResponsiveGridList(
      minItemWidth: 120,
      minItemsPerRow: 1,
      maxItemsPerRow: 1,
      horizontalGridSpacing: 10,
      verticalGridSpacing: 15,
      listViewBuilderOptions: ListViewBuilderOptions(
        scrollDirection: Axis.vertical,
        shrinkWrap: true,
        physics: const AlwaysScrollableScrollPhysics(),
      ),
      children: List.generate(
        detailProvider.reviewList?.length ?? 0,
        (index) {
          return Container(
            padding: const EdgeInsets.fromLTRB(15, 5, 15, 5),
            decoration: BoxDecoration(
              color: Theme.of(context).cardColor,
              borderRadius: BorderRadius.circular(5),
              boxShadow: [
                BoxShadow(
                  color: gray.withValues(alpha: 0.08),
                  spreadRadius: 1.5,
                  blurRadius: 0.5,
                  offset: const Offset(0, 1),
                ),
              ],
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.start,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    MyNetworkImage(
                      imgWidth: 30,
                      radius: 200,
                      imgHeight: 30,
                      imageUrl:
                          detailProvider.reviewList?[index].userImage ?? "",
                      fit: BoxFit.fill,
                    ),
                    const SizedBox(width: 8),
                    Expanded(
                      child: Align(
                        alignment: Alignment.centerLeft,
                        child: detailProvider.reviewList?[index].firstName == ""
                            ? MyText(
                                color: Theme.of(context).colorScheme.surface,
                                text: detailProvider.reviewList?[index].userName
                                        .toString() ??
                                    "",
                                fontsizeNormal: Dimens.textMedium,
                                fontwaight: FontWeight.w700,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.center,
                                fontstyle: FontStyle.normal)
                            : MyText(
                                color: Theme.of(context).colorScheme.surface,
                                text: detailProvider
                                        .reviewList?[index].firstName
                                        .toString() ??
                                    "",
                                fontsizeNormal: Dimens.textMedium,
                                fontwaight: FontWeight.w700,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.center,
                                fontstyle: FontStyle.normal),
                      ),
                    ),
                    const SizedBox(width: 8),
                    MyText(
                        color: colorPrimary,
                        text: Utils.formateDate(
                            detailProvider.reviewList?[index].createdAt
                                    .toString() ??
                                "",
                            Constant.dateformat),
                        fontsizeNormal: Dimens.textSmall,
                        fontwaight: FontWeight.w500,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ],
                ),
                const SizedBox(height: 10),
                Row(
                  mainAxisAlignment: MainAxisAlignment.start,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    MyRating(
                      size: 15,
                      rating: double.parse((detailProvider
                              .reviewList?[index].rating
                              .toString() ??
                          "")),
                      spacing: 3,
                    ),
                    const SizedBox(width: 5),
                    MyText(
                        color: colorAccent,
                        text:
                            "${double.parse((detailProvider.reviewList?[index].rating.toString() ?? ""))}",
                        fontsizeNormal: Dimens.textMedium,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ],
                ),
                const SizedBox(height: 10),
                MyText(
                    color: gray,
                    text:
                        detailProvider.reviewList?[index].comment.toString() ??
                            "",
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w400,
                    maxline: 5,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
          );
        },
      ),
    );
  }

  Widget buildStudentFeedbackItemWeb() {
    return Padding(
      padding: const EdgeInsets.only(top: 15),
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 3,
            height1200: 3,
            height800: 2,
            height400: 1),
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 3,
            height1200: 3,
            height800: 2,
            height400: 1),
        horizontalGridSpacing: 40,
        verticalGridSpacing: 20,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const AlwaysScrollableScrollPhysics(),
        ),
        children: List.generate(
          detailProvider.reviewList?.length ?? 0,
          (index) {
            return Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.start,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    MyNetworkImage(
                      imgWidth: 40,
                      imgHeight: 40,
                      radius: 200,
                      imageUrl:
                          detailProvider.reviewList?[index].userImage ?? "",
                      fit: BoxFit.fill,
                    ),
                    const SizedBox(width: 15),
                    Flexible(
                      fit: FlexFit.loose,
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.center,
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          detailProvider.reviewList?[index].firstName == ""
                              ? MyText(
                                  color: Theme.of(context).colorScheme.surface,
                                  text: detailProvider
                                          .reviewList?[index].userName
                                          .toString() ??
                                      "",
                                  fontsizeNormal: Dimens.textTitle,
                                  fontsizeWeb: Dimens.textTitle,
                                  fontwaight: FontWeight.w700,
                                  maxline: 2,
                                  overflow: TextOverflow.ellipsis,
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal)
                              : MyText(
                                  color: Theme.of(context).colorScheme.surface,
                                  text: detailProvider
                                          .reviewList?[index].firstName
                                          .toString() ??
                                      "",
                                  fontsizeNormal: Dimens.textTitle,
                                  fontsizeWeb: Dimens.textTitle,
                                  fontwaight: FontWeight.w700,
                                  maxline: 2,
                                  overflow: TextOverflow.ellipsis,
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal),
                          const SizedBox(height: 20),
                          Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              MyRating(
                                size: 18,
                                rating: double.parse((detailProvider
                                        .reviewList?[index].rating
                                        .toString() ??
                                    "")),
                                spacing: 3,
                              ),
                              const SizedBox(width: 5),
                              MyText(
                                  color: colorAccent,
                                  text:
                                      "${double.parse((detailProvider.reviewList?[index].rating.toString() ?? ""))}",
                                  fontsizeNormal: Dimens.textTitle,
                                  fontsizeWeb: Dimens.textTitle,
                                  fontwaight: FontWeight.w600,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal),
                            ],
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
                const SizedBox(height: 15),
                MyText(
                    color: gray,
                    text:
                        detailProvider.reviewList?[index].comment.toString() ??
                            "",
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w400,
                    maxline: 5,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            );
          },
        ),
      ),
    );
  }

/* Add Review BottomSheet */

  Future<Future> addReviewBottomSheet(
      BuildContext context, String courseId) async {
    return showDialog(
        context: context,
        barrierColor: transparent,
        builder: (context) {
          return Dialog(
            shape:
                RoundedRectangleBorder(borderRadius: BorderRadius.circular(15)),
            clipBehavior: Clip.antiAliasWithSaveLayer,
            backgroundColor: Theme.of(context).cardColor,
            child: Consumer<CourseDetailsProvider>(
                builder: (context, detailprovider, child) {
              return Container(
                padding: EdgeInsets.all(20.0),
                constraints: BoxConstraints(
                  minWidth: 500,
                  maxWidth: 550,
                  minHeight: 250,
                  maxHeight: 300,
                ),
                color: Theme.of(context).cardColor,
                child: Wrap(
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        MyText(
                            color: Theme.of(context).colorScheme.surface,
                            fontsizeNormal: Dimens.textBig,
                            fontsizeWeb: Dimens.textBig,
                            multilanguage: true,
                            maxline: 1,
                            fontwaight: FontWeight.w600,
                            text: "addreview",
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        RatingBar(
                          initialRating: 0,
                          direction: Axis.horizontal,
                          allowHalfRating: true,
                          itemSize: 25,
                          itemCount: 5,
                          ratingWidget: RatingWidget(
                            full: const Icon(
                              Icons.star,
                              color: colorAccent,
                            ),
                            half:
                                const Icon(Icons.star_half, color: colorAccent),
                            empty: const Icon(Icons.star_border,
                                color: colorAccent),
                          ),
                          itemPadding:
                              const EdgeInsets.symmetric(horizontal: 4.0),
                          onRatingUpdate: (rating) {
                            addrating = rating;
                          },
                        ),
                      ],
                    ),
                    Padding(
                      padding: const EdgeInsets.fromLTRB(0, 20, 0, 20),
                      child: TextField(
                        textAlign: TextAlign.start,
                        controller: commentController,
                        cursorColor: Theme.of(context).colorScheme.surface,
                        keyboardType: TextInputType.multiline,
                        textInputAction: TextInputAction.newline,
                        minLines: 2,
                        maxLines: 5,
                        style: GoogleFonts.inter(
                          fontSize: Dimens.textTitle,
                          fontStyle: FontStyle.normal,
                          color: Theme.of(context).colorScheme.surface,
                          fontWeight: FontWeight.w400,
                        ),
                        decoration: InputDecoration(
                          hintText: Locales.string(context, "addcomment"),
                          hintStyle: GoogleFonts.inter(
                            fontSize: Dimens.textTitle,
                            fontStyle: FontStyle.normal,
                            color: colorPrimary.withValues(alpha: 0.40),
                            fontWeight: FontWeight.w400,
                          ),
                          border: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(8),
                            borderSide: BorderSide(
                                width: 1,
                                color: colorPrimaryDark,
                                style: BorderStyle.solid),
                          ),
                          errorBorder: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(8),
                            borderSide: BorderSide(
                                width: 1,
                                color: colorPrimaryDark,
                                style: BorderStyle.solid),
                          ),
                          focusedBorder: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(8),
                            borderSide: BorderSide(
                                width: 1,
                                color: colorPrimaryDark,
                                style: BorderStyle.solid),
                          ),
                          enabledBorder: OutlineInputBorder(
                            borderRadius: BorderRadius.circular(8),
                            borderSide: BorderSide(
                                width: 1,
                                color: colorPrimaryDark,
                                style: BorderStyle.solid),
                          ),
                          filled: true,
                          contentPadding: const EdgeInsets.all(15),
                          fillColor: white,
                        ),
                      ),
                    ),
                    Padding(
                      padding: const EdgeInsets.fromLTRB(0, 20, 0, 55),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.end,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          InkWell(
                            onTap: () {
                              Navigator.pop(context);
                            },
                            child: Container(
                              padding: const EdgeInsets.fromLTRB(15, 8, 15, 8),
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(5),
                                border: Border.all(
                                  width: 0.8,
                                  color: gray,
                                ),
                              ),
                              child: MyText(
                                  color: black,
                                  fontsizeNormal: Dimens.textTitle,
                                  fontsizeWeb: Dimens.textTitle,
                                  multilanguage: true,
                                  maxline: 1,
                                  fontwaight: FontWeight.w500,
                                  text: "cancel",
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal),
                            ),
                          ),
                          const SizedBox(width: 15),
                          InkWell(
                            onTap: () async {
                              if (addrating == 0.0) {
                                Utils.showSnackbar(
                                    context, "fail", "pleaseenterrating", true);
                              } else if (commentController.text.toString() ==
                                  "") {
                                Utils.showSnackbar(context, "fail",
                                    "pleaseentercomment", true);
                              } else {
                                detailprovider.setAddReviewLoding(true);
                                await detailprovider.addReview("2", courseId,
                                    commentController.text, addrating);

                                if (detailprovider.successModel.status == 200) {
                                  if (!context.mounted) return;
                                  Navigator.pop(context);

                                  commentController.clear();
                                  addrating = 0;
                                  getReviewList(0);
                                  detailprovider.setAddReviewLoding(false);
                                } else {
                                  if (!context.mounted) return;
                                  Navigator.pop(context);
                                  Utils.showSnackbar(
                                      context,
                                      "fail",
                                      detailprovider.successModel.message ?? "",
                                      false);
                                  detailprovider.setAddReviewLoding(false);
                                }
                              }
                            },
                            child: AnimatedContainer(
                              duration: const Duration(milliseconds: 200),
                              clipBehavior: Clip.antiAliasWithSaveLayer,
                              curve: Curves.bounceInOut,
                              padding: const EdgeInsets.fromLTRB(15, 8, 15, 8),
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(5),
                                color: colorPrimary,
                              ),
                              child: detailprovider.isReviewLoding
                                  ? Container(
                                      padding: EdgeInsets.all(4),
                                      height: 25,
                                      child: CircularProgressIndicator(
                                        color: white,
                                      ),
                                    )
                                  : MyText(
                                      color: white,
                                      fontsizeNormal: Dimens.textTitle,
                                      fontsizeWeb: Dimens.textTitle,
                                      multilanguage: true,
                                      maxline: 1,
                                      fontwaight: FontWeight.w700,
                                      text: "submit",
                                      textalign: TextAlign.left,
                                      fontstyle: FontStyle.normal),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              );
            }),
          );
        });
  }

/* Shimmer */

  Widget commanShimmer() {
    if (MediaQuery.of(context).size.width > 800) {
      return SingleChildScrollView(
        physics: const BouncingScrollPhysics(),
        scrollDirection: Axis.vertical,
        child: Stack(
          children: [
            Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                /* Parent Item Shimmer */
                Container(
                  width: MediaQuery.of(context).size.width,
                  alignment: Alignment.centerLeft,
                  child: Container(
                    constraints: BoxConstraints(
                      maxWidth: MediaQuery.of(context).size.width * 0.60,
                    ),
                    height: 500,
                    padding: EdgeInsets.only(
                      left: MediaQuery.of(context).size.width > 1600
                          ? 200
                          : MediaQuery.of(context).size.width > 1200
                              ? 200
                              : 20,
                    ),
                    child: SizedBox(
                      width: MediaQuery.of(context).size.width * 0.55,
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.center,
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          // DetailVideo Title Text
                          CustomWidget.roundrectborder(
                              height: 10,
                              width: MediaQuery.of(context).size.width),
                          const SizedBox(height: 15),
                          // Course Discription
                          CustomWidget.roundrectborder(
                              height: 5,
                              width: MediaQuery.of(context).size.width),
                          CustomWidget.roundrectborder(
                              height: 5,
                              width: MediaQuery.of(context).size.width),
                          const SizedBox(height: 15),
                          const CustomWidget.roundrectborder(
                              height: 8, width: 150),
                          const SizedBox(height: 15),
                          CustomWidget.roundrectborder(
                              height: 200,
                              width: MediaQuery.of(context).size.width),
                          const CustomWidget.roundrectborder(
                              height: 5, width: 200),
                          const SizedBox(height: 20),

                          const CustomWidget.roundrectborder(
                              height: 8, width: 250),
                          const SizedBox(height: 15),
                          CustomWidget.roundrectborder(
                              height: 5,
                              width: MediaQuery.of(context).size.width),
                        ],
                      ),
                    ),
                  ),
                ),
                /* Child Item Shimmer */
                Container(
                  constraints: BoxConstraints(
                    maxWidth: MediaQuery.of(context).size.width * 0.60,
                  ),
                  padding: EdgeInsets.only(
                    top: 50,
                    bottom: 50,
                    left: MediaQuery.of(context).size.width > 1600
                        ? 200
                        : MediaQuery.of(context).size.width > 1200
                            ? 200
                            : 20,
                  ),
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
                        decoration: BoxDecoration(
                          color: colorPrimary.withValues(alpha: 0.10),
                          borderRadius: const BorderRadius.all(
                            Radius.circular(10.0),
                          ),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            const CustomWidget.roundrectborder(
                              height: 10,
                              width: 200,
                            ),
                            const SizedBox(height: 10),
                            ListView.builder(
                              scrollDirection: Axis.vertical,
                              shrinkWrap: true,
                              physics: const NeverScrollableScrollPhysics(),
                              itemCount: 5,
                              itemBuilder: (BuildContext context, int index) {
                                return const Padding(
                                  padding: EdgeInsets.fromLTRB(0, 10, 0, 0),
                                  child: Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    children: [
                                      CustomWidget.circular(
                                        height: 15,
                                        width: 15,
                                      ),
                                      SizedBox(width: 14),
                                      CustomWidget.roundrectborder(
                                        height: 5,
                                        width: 200,
                                      ),
                                    ],
                                  ),
                                );
                              },
                            ),
                          ],
                        ),
                      ),
                      const SizedBox(height: 20),
                      Container(
                        padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
                        decoration: BoxDecoration(
                          color: colorPrimary.withValues(alpha: 0.10),
                          borderRadius: const BorderRadius.all(
                            Radius.circular(10.0),
                          ),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            const CustomWidget.roundrectborder(
                              height: 10,
                              width: 200,
                            ),
                            const SizedBox(height: 10),
                            ListView.builder(
                              scrollDirection: Axis.vertical,
                              shrinkWrap: true,
                              physics: const NeverScrollableScrollPhysics(),
                              itemCount: 5,
                              itemBuilder: (BuildContext context, int index) {
                                return const Padding(
                                  padding: EdgeInsets.fromLTRB(0, 10, 0, 0),
                                  child: Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    children: [
                                      CustomWidget.circular(
                                        height: 15,
                                        width: 15,
                                      ),
                                      SizedBox(width: 14),
                                      CustomWidget.roundrectborder(
                                        height: 5,
                                        width: 200,
                                      ),
                                    ],
                                  ),
                                );
                              },
                            ),
                          ],
                        ),
                      ),
                      const SizedBox(height: 20),
                      Container(
                        padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
                        decoration: BoxDecoration(
                          color: colorPrimary.withValues(alpha: 0.10),
                          borderRadius: const BorderRadius.all(
                            Radius.circular(10.0),
                          ),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            const CustomWidget.roundrectborder(
                              height: 10,
                              width: 200,
                            ),
                            const SizedBox(height: 10),
                            ListView.builder(
                              scrollDirection: Axis.vertical,
                              shrinkWrap: true,
                              physics: const NeverScrollableScrollPhysics(),
                              itemCount: 5,
                              itemBuilder: (BuildContext context, int index) {
                                return const Padding(
                                  padding: EdgeInsets.fromLTRB(0, 10, 0, 0),
                                  child: Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    children: [
                                      CustomWidget.circular(
                                        height: 15,
                                        width: 15,
                                      ),
                                      SizedBox(width: 14),
                                      CustomWidget.roundrectborder(
                                        height: 5,
                                        width: 200,
                                      ),
                                    ],
                                  ),
                                );
                              },
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              ],
            ),
            /* Right Item Shimmer */
            Positioned.fill(
              top: 100,
              left: 20,
              right: MediaQuery.of(context).size.width > 1600
                  ? 200
                  : MediaQuery.of(context).size.width > 1200
                      ? 200
                      : MediaQuery.of(context).size.width > 1000
                          ? 50
                          : 20,
              child: Align(
                alignment: Alignment.topRight,
                child: Container(
                  constraints: BoxConstraints(
                      maxWidth: MediaQuery.of(context).size.width > 1600
                          ? MediaQuery.of(context).size.width * 0.20
                          : MediaQuery.of(context).size.width > 1200
                              ? MediaQuery.of(context).size.width * 0.22
                              : MediaQuery.of(context).size.width > 1000
                                  ? MediaQuery.of(context).size.width * 0.28
                                  : MediaQuery.of(context).size.width * 0.34),
                  padding: EdgeInsets.fromLTRB(20, 10, 20, 10),
                  decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(30),
                      boxShadow: [
                        BoxShadow(
                            blurRadius: 20,
                            color: transparent.withValues(alpha: 0.05),
                            blurStyle: BlurStyle.outer,
                            offset: Offset(0, 6),
                            spreadRadius: 0)
                      ],
                      border: Border.all(
                          width: 0.8, color: gray.withValues(alpha: 0.2)),
                      color: white),
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      CustomWidget.roundrectborder(height: 5, width: 120),
                      const SizedBox(height: 15),
                      CustomWidget.roundrectborder(height: 24, width: 200),
                      CustomWidget.roundrectborder(height: 24, width: 200),
                      CustomWidget.roundrectborder(height: 24, width: 200),
                      CustomWidget.roundrectborder(height: 6, width: 100),
                      CustomWidget.roundrectborder(height: 6, width: 100),
                      CustomWidget.roundrectborder(height: 6, width: 100),
                      CustomWidget.roundrectborder(height: 6, width: 100),
                    ],
                  ),
                ),
              ),
            ),
          ],
        ),
      );
    } else {
      return SingleChildScrollView(
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.all(15),
        scrollDirection: Axis.vertical,
        child: Column(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            CustomWidget.roundcorner(
                width: MediaQuery.of(context).size.width, height: 200),
            const SizedBox(height: 15),
            CustomWidget.roundrectborder(
                height: 10, width: MediaQuery.of(context).size.width),
            const CustomWidget.roundrectborder(height: 10, width: 200),
            const SizedBox(height: 10),

            const CustomWidget.roundrectborder(height: 10, width: 150),
            const SizedBox(height: 10),

            const CustomWidget.roundrectborder(height: 10, width: 100),
            const SizedBox(height: 10),
            // Course Discription
            CustomWidget.roundrectborder(
                height: 5, width: MediaQuery.of(context).size.width),
            CustomWidget.roundrectborder(
                height: 5, width: MediaQuery.of(context).size.width),
            CustomWidget.roundrectborder(
                height: 5, width: MediaQuery.of(context).size.width),
            CustomWidget.roundrectborder(
                height: 5, width: MediaQuery.of(context).size.width),
            CustomWidget.roundrectborder(
                height: 5, width: MediaQuery.of(context).size.width),
            const SizedBox(height: 10),
            const CustomWidget.roundrectborder(height: 10, width: 200),
            const SizedBox(height: 10),
            const CustomWidget.roundrectborder(height: 10, width: 200),
            const SizedBox(height: 10),
            const CustomWidget.roundrectborder(height: 10, width: 200),
            const SizedBox(height: 10),
            const CustomWidget.roundrectborder(height: 10, width: 200),
            const SizedBox(height: 15),
            Container(
              padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
              decoration: BoxDecoration(
                color: colorPrimary.withValues(alpha: 0.10),
                borderRadius: const BorderRadius.all(
                  Radius.circular(10.0),
                ),
              ),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  const CustomWidget.roundrectborder(
                    height: 10,
                    width: 200,
                  ),
                  const SizedBox(height: 10),
                  ListView.builder(
                    scrollDirection: Axis.vertical,
                    shrinkWrap: true,
                    physics: const NeverScrollableScrollPhysics(),
                    itemCount: 5,
                    itemBuilder: (BuildContext context, int index) {
                      return const Padding(
                        padding: EdgeInsets.fromLTRB(0, 10, 0, 0),
                        child: Row(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            CustomWidget.circular(
                              height: 15,
                              width: 15,
                            ),
                            SizedBox(width: 14),
                            CustomWidget.roundrectborder(
                              height: 5,
                              width: 200,
                            ),
                          ],
                        ),
                      );
                    },
                  ),
                ],
              ),
            ),
          ],
        ),
      );
    }
  }

/* Generate Certificate Button With Api Calling */

  Widget generateCertificate() {
    if ((detailProvider.courseDetailsModel.result?[0].isDownloadCertificate ??
                0) ==
            1 &&
        Constant.userID != null) {
      return InkWell(
        onTap: () async {
          Utils().showProgress(context, "Generate Certificate...");
          await detailProvider.fetchCertificate(widget.courseId);

          if (!detailProvider.certificateDownloading) {
            if (detailProvider.certificateModel.status == 200 &&
                detailProvider.certificateModel.result != null) {
              if (!mounted) return;
              Utils().hideProgress(context);
              Utils.lanchUrl(
                  detailProvider.certificateModel.result?.pdfUrl ?? "");
            } else {
              if (!mounted) return;
              Utils().hideProgress(context);
              Utils.showSnackbar(context, "fail", "somethingwentwronge", true);
            }
          }
        },
        child: Container(
          width: MediaQuery.of(context).size.width,
          height: 45,
          alignment: Alignment.center,
          decoration: BoxDecoration(
            color: colorPrimary,
            borderRadius: BorderRadius.circular(0),
          ),
          child: MyText(
              color: white,
              fontsizeNormal: Dimens.textMedium,
              maxline: 1,
              fontwaight: FontWeight.w600,
              multilanguage: true,
              overflow: TextOverflow.ellipsis,
              text: "downloadcertificate",
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
        ),
      );
    } else {
      return const SizedBox.shrink();
    }
  }
}
