import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/webpages/websearch.dart';
import 'package:prakah/webpages/webtutorprofile.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/blogdetailprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/webwidget/footerweb.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import '../utils/utils.dart';

class WebBlogDetail extends StatefulWidget {
  final String blogId;
  const WebBlogDetail({super.key, required this.blogId});

  @override
  State<WebBlogDetail> createState() => _WebBlogDetailState();
}

class _WebBlogDetailState extends State<WebBlogDetail> {
  final searchController = TextEditingController();
  late BlogDetailProvider blogDetailProvider;

  @override
  void initState() {
    blogDetailProvider =
        Provider.of<BlogDetailProvider>(context, listen: false);
    super.initState();
    getApi();
  }

  Future<void> getApi() async {
    await blogDetailProvider.getBlogDetail(widget.blogId.toString());
  }

  @override
  Widget build(BuildContext context) {
    return _buildSearchHome();
  }

  Widget _buildSearchHome() {
    return Consumer<SearchProvider>(builder: (context, homeprovider, child) {
      if (homeprovider.isSearch == "0") {
        return Scaffold(
          appBar: Utils.webMainAppbar(controller: searchController),
          body: Utils.hoverItemWithPage(
            myWidget: SingleChildScrollView(
              scrollDirection: Axis.vertical,
              physics: const BouncingScrollPhysics(),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Utils.buildWebDetailsAppBar(
                      context: context, title: "blogdetail"),
                  buildBlogDetails(),
                  const FooterWeb(),
                ],
              ),
            ),
          ),
        );
      } else {
        return WebSearch(
          searchController: searchController,
        );
      }
    });
  }

  Widget buildBlogDetails() {
    return Consumer<BlogDetailProvider>(
        builder: (context, blogDetailProvider, child) {
      if (blogDetailProvider.loading) {
        return shimmer();
      } else {
        if (blogDetailProvider.blogDetailModel.status == 200 &&
            blogDetailProvider.blogDetailModel.result!.isNotEmpty) {
          return Padding(
            padding: MediaQuery.of(context).size.width > 800
                ? const EdgeInsets.fromLTRB(200, 25, 200, 25)
                : const EdgeInsets.fromLTRB(20, 15, 20, 15),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text: blogDetailProvider.blogDetailModel.result?[0].title
                            .toString() ??
                        "",
                    fontsizeNormal: Dimens.textExtralargeBig,
                    fontsizeWeb: Dimens.textExtralargeBig,
                    fontwaight: FontWeight.w700,
                    maxline: 3,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.center,
                    fontstyle: FontStyle.normal),
                const SizedBox(height: 20),
                Stack(
                  children: [
                    MyNetworkImage(
                      radius: 5,
                      imgWidth: MediaQuery.of(context).size.width > 1200
                          ? MediaQuery.of(context).size.width * 0.50
                          : MediaQuery.of(context).size.width,
                      imgHeight:
                          MediaQuery.of(context).size.width > 1200 ? 500 : 200,
                      islandscap: true,
                      imageUrl: blogDetailProvider
                              .blogDetailModel.result?[0].image
                              .toString() ??
                          "",
                      fit: MediaQuery.of(context).size.width > 1200
                          ? BoxFit.cover
                          : BoxFit.fill,
                    ),
                    Positioned(
                        top: 20,
                        right: 20,
                        child: InkWell(
                            onTap: () async {
                              if (Utils.checkLoginUser(context)) {
                                await blogDetailProvider.addRemoveWishlist(
                                    "1",
                                    blogDetailProvider
                                            .blogDetailModel.result?[0].id
                                            .toString() ??
                                        "");
                              }
                            },
                            splashColor: transparent,
                            focusColor: transparent,
                            hoverColor: transparent,
                            child: Container(
                              padding: EdgeInsets.all(10),
                              decoration: BoxDecoration(
                                  color: gray, shape: BoxShape.circle),
                              child: Icon(
                                blogDetailProvider.blogDetailModel.result?[0]
                                            .isWishlist ==
                                        1
                                    ? Icons.favorite
                                    : Icons.favorite_border,
                                color: blogDetailProvider.blogDetailModel
                                            .result?[0].isWishlist ==
                                        1
                                    ? red
                                    : Theme.of(context).colorScheme.surface,
                              ),
                            )))
                  ],
                ),
                const SizedBox(height: 20),
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    MyText(
                      color: gray,
                      text: "update",
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      multilanguage: true,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal,
                    ),
                    const SizedBox(width: 10),
                    MyText(
                      color: gray,
                      text: Utils.formateDate(
                          blogDetailProvider
                                  .blogDetailModel.result?[0].createdAt
                                  .toString() ??
                              "",
                          Constant.dateformat),
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal,
                    ),
                  ],
                ),
                const SizedBox(height: 10),
                InkWell(
                  onTap: () {
                    Navigator.of(context).push(
                      PageRouteBuilder(
                        transitionDuration: const Duration(milliseconds: 200),
                        pageBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation) {
                          return WebTutorProfile(
                            tutorid: blogDetailProvider
                                    .blogDetailModel.result?[0].tutorId
                                    .toString() ??
                                "",
                          );
                        },
                        transitionsBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation,
                            Widget child) {
                          return Align(
                            child: FadeTransition(
                              opacity: animation,
                              child: child,
                            ),
                          );
                        },
                      ),
                    );
                  },
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      MyText(
                        color: gray,
                        text: "createdby",
                        fontsizeNormal: Dimens.textMedium,
                        fontsizeWeb: Dimens.textMedium,
                        fontwaight: FontWeight.w600,
                        maxline: 2,
                        multilanguage: true,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                        color: gray,
                        text: blogDetailProvider
                                .blogDetailModel.result?[0].tutorName
                                .toString() ??
                            "",
                        fontsizeNormal: Dimens.textMedium,
                        fontsizeWeb: Dimens.textMedium,
                        fontwaight: FontWeight.w600,
                        maxline: 2,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal,
                      ),
                    ],
                  ),
                ),
                const SizedBox(height: 15),
                Container(
                  padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
                  decoration: BoxDecoration(
                    color: colorPrimary.withValues(alpha: 0.10),
                    borderRadius: const BorderRadius.all(
                      Radius.circular(10.0),
                    ),
                  ),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      MyText(
                        color: Theme.of(context).colorScheme.surface,
                        text: "discription",
                        fontsizeNormal: Dimens.textTitle,
                        fontsizeWeb: Dimens.textTitle,
                        fontwaight: FontWeight.w600,
                        maxline: 20,
                        multilanguage: true,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal,
                      ),
                      const SizedBox(height: 15),
                      Utils.htmlTexts(
                          context,
                          blogDetailProvider
                                  .blogDetailModel.result?[0].description
                                  .toString() ??
                              ""),
                    ],
                  ),
                ),
              ],
            ),
          );
        } else {
          return const NoData();
        }
      }
    });
  }

  Widget shimmer() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(200, 25, 200, 25)
          : const EdgeInsets.fromLTRB(15, 15, 15, 15),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          CustomWidget.roundrectborder(
            width: MediaQuery.of(context).size.width,
            height: 200,
          ),
          const SizedBox(height: 20),
          CustomWidget.roundrectborder(
            width: MediaQuery.of(context).size.width,
            height: 8,
          ),
          const SizedBox(height: 10),
          const CustomWidget.roundrectborder(
            width: 250,
            height: 8,
          ),
          const SizedBox(height: 10),
          const CustomWidget.roundrectborder(
            width: 250,
            height: 8,
          ),
          const SizedBox(height: 15),
          Container(
            padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
            decoration: BoxDecoration(
              color: colorPrimary.withValues(alpha: 0.10),
              borderRadius: const BorderRadius.all(
                Radius.circular(10.0),
              ),
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                const CustomWidget.roundrectborder(
                  width: 250,
                  height: 8,
                ),
                const SizedBox(height: 15),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 5,
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }
}
