import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/provider/profileprovider.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webhome.dart';
import 'package:prakah/webpages/websearch.dart';
import 'package:prakah/webwidget/footerweb.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:intl_phone_field/country_picker_dialog.dart';
import 'package:intl_phone_field/intl_phone_field.dart';
import 'package:provider/provider.dart';

class WebBecomeTutor extends StatefulWidget {
  final String? tutorStatus;
  const WebBecomeTutor({super.key, required this.tutorStatus});

  @override
  State<WebBecomeTutor> createState() => _WebBecomeTutorState();
}

class _WebBecomeTutorState extends State<WebBecomeTutor> {
  GeneralProvider generalProvider = GeneralProvider();
  TextEditingController numberController = TextEditingController();
  TextEditingController nameController = TextEditingController();
  TextEditingController emailController = TextEditingController();
  TextEditingController passwordController = TextEditingController();
  TextEditingController confPasswordController = TextEditingController();
  TextEditingController designationController = TextEditingController();
  TextEditingController educationController = TextEditingController();
  TextEditingController experienceController = TextEditingController();
  TextEditingController searchController = TextEditingController();
  String mobilenumber = "", countrycode = "", countryname = "";
  bool obscureTextPassword = true;
  bool obscureTextPassword1 = true;
  void _togglePasswordVisibility() {
    setState(() {
      obscureTextPassword = !obscureTextPassword;
    });
  }

  void _toggleConPasswordVisibility() {
    setState(() {
      obscureTextPassword1 = !obscureTextPassword1;
    });
  }

  @override
  void initState() {
    super.initState();
    generalProvider = Provider.of<GeneralProvider>(context, listen: false);
    printLog("My status ${widget.tutorStatus}");
  }

  @override
  Widget build(BuildContext context) {
    return _buildSearchHome();
  }

  Widget _buildSearchHome() {
    return Consumer<SearchProvider>(builder: (context, homeprovider, child) {
      if (homeprovider.isSearch == "0") {
        return Scaffold(
          appBar: Utils.webMainAppbar(controller: searchController),
          body: Utils.hoverItemWithPage(
              myWidget: SingleChildScrollView(
            child: widget.tutorStatus == "pending"
                ? Column(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    spacing: 20,
                    children: [
                      buildWebDetailsAppBar(),
                      Padding(
                        padding: MediaQuery.of(context).size.width > 1200
                            ? const EdgeInsets.fromLTRB(300, 0, 300, 0)
                            : MediaQuery.of(context).size.width > 1000
                                ? const EdgeInsets.fromLTRB(250, 0, 250, 0)
                                : MediaQuery.of(context).size.width > 800
                                    ? const EdgeInsets.fromLTRB(100, 0, 100, 0)
                                    : const EdgeInsets.fromLTRB(20, 0, 20, 0),
                        child: Center(
                          child: Column(
                            spacing: 20,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              MyImage(
                                width: MediaQuery.of(context).size.width > 1200
                                    ? MediaQuery.sizeOf(context).width * 0.6
                                    : MediaQuery.sizeOf(context).width * 0.4,
                                height: 250,
                                imagePath: "conf_tu.png",
                                fit: BoxFit.contain,
                              ),
                              MyText(
                                color: black,
                                text: "profile_under_review",
                                fontsizeNormal: Dimens.textExtra,
                                fontsizeWeb: Dimens.textExtra,
                                fontwaight: FontWeight.w600,
                                maxline: 2,
                                multilanguage: true,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.center,
                                fontstyle: FontStyle.normal,
                              ),
                              MyText(
                                color: black,
                                text: "profile_under_review_desc",
                                fontsizeNormal: Dimens.textMedium,
                                fontsizeWeb: Dimens.textMedium,
                                fontwaight: FontWeight.w500,
                                maxline: 5,
                                multilanguage: true,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.center,
                                fontstyle: FontStyle.normal,
                              ),
                              InkWell(
                                splashColor: transparent,
                                focusColor: transparent,
                                hoverColor: transparent,
                                highlightColor: transparent,
                                onTap: () {
                                  generalProvider.setHomeTab("1");
                                  Navigator.of(context).pushAndRemoveUntil(
                                      PageRouteBuilder(
                                          transitionDuration:
                                              const Duration(milliseconds: 150),
                                          pageBuilder: (BuildContext context,
                                              Animation<double> animation,
                                              Animation<double>
                                                  secondaryAnimation) {
                                            return const WebHome();
                                          },
                                          transitionsBuilder:
                                              (BuildContext context,
                                                  Animation<double> animation,
                                                  Animation<double>
                                                      secondaryAnimation,
                                                  Widget child) {
                                            return Align(
                                                child: FadeTransition(
                                                    opacity: animation,
                                                    child: child));
                                          }),
                                      (route) => false);
                                },
                                child: AnimatedContainer(
                                  duration: const Duration(milliseconds: 80),
                                  clipBehavior: Clip.antiAliasWithSaveLayer,
                                  curve: Curves.bounceInOut,
                                  padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
                                  margin: EdgeInsets.only(bottom: 30),
                                  width:
                                      MediaQuery.of(context).size.width * 0.3,
                                  alignment: Alignment.center,
                                  decoration: BoxDecoration(
                                    color: colorPrimaryDark,
                                    borderRadius: BorderRadius.circular(10),
                                  ),
                                  child: MyText(
                                    color: white,
                                    text: "continue",
                                    fontsizeNormal: Dimens.textBig,
                                    fontsizeWeb: Dimens.textBig,
                                    fontwaight: FontWeight.w600,
                                    maxline: 1,
                                    multilanguage: true,
                                    overflow: TextOverflow.ellipsis,
                                    textalign: TextAlign.center,
                                    fontstyle: FontStyle.normal,
                                  ),
                                ),
                              ),
                            ],
                          ),
                        ),
                      ),
                      FooterWeb()
                    ],
                  )
                : Column(
                    spacing: 20,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      buildWebDetailsAppBar(),
                      registerField(),
                      btnSave(),
                      FooterWeb()
                    ],
                  ),
          )),
        );
      } else {
        return WebSearch(
          searchController: searchController,
        );
      }
    });
  }

  Widget buildWebDetailsAppBar() {
    return Consumer<GeneralProvider>(
        builder: (context, generalprovider, child) {
      return Container(
        height: 75,
        width: MediaQuery.sizeOf(context).width,
        color: gray.withValues(alpha: 0.3),
        padding: MediaQuery.of(context).size.width > 1000
            ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
            : const EdgeInsets.fromLTRB(20, 0, 20, 0),
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.center,
          spacing: 14,
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              highlightColor: transparent,
              onTap: () async {
                generalprovider.setHomeTab("1");
                Navigator.of(context).pushAndRemoveUntil(
                    PageRouteBuilder(
                        transitionDuration: const Duration(milliseconds: 150),
                        pageBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation) {
                          return const WebHome();
                        },
                        transitionsBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation,
                            Widget child) {
                          return Align(
                              child: FadeTransition(
                                  opacity: animation, child: child));
                        }),
                    (route) => false);
              },
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                spacing: 14,
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  Icon(
                    Icons.home,
                    size: 25,
                    color: black.withValues(alpha: 0.4),
                  ),
                  MyText(
                    text: "home",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textMedium,
                    fontsizeWeb: Dimens.textTitle,
                    fontwaight: FontWeight.w600,
                    color: black,
                  ),
                ],
              ),
            ),
            InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              onTap: () {},
              child: Row(
                children: [
                  Icon(
                    Icons.keyboard_arrow_right_rounded,
                    size: 25,
                    color: black.withValues(alpha: 0.4),
                  ),
                  MyText(
                      text: "become_tutor",
                      multilanguage: true,
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textTitle,
                      fontwaight: FontWeight.w600,
                      color: colorPrimaryDark),
                ],
              ),
            ),
          ],
        ),
      );
    });
  }

  Widget registerField() {
    return Padding(
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(400, 20, 400, 0)
          : const EdgeInsets.fromLTRB(20, 20, 20, 0),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 10,
        children: [
          MyText(
              color: black,
              text: "full_name",
              fontsizeNormal: Dimens.textMedium,
              fontwaight: FontWeight.w600,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              multilanguage: true,
              fontstyle: FontStyle.normal),
          _myTextFiles(
              controller: nameController,
              password: false,
              hintText: "Enter the full name",
              textinputAction: TextInputAction.next,
              textinputType: TextInputType.text,
              onTogglePassword: () {},
              isShow: false),
          MyText(
              color: black,
              text: "email_address",
              fontsizeNormal: Dimens.textMedium,
              fontwaight: FontWeight.w600,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              multilanguage: true,
              fontstyle: FontStyle.normal),
          _myTextFiles(
              controller: emailController,
              password: false,
              hintText: "Enter the email",
              textinputAction: TextInputAction.next,
              textinputType: TextInputType.emailAddress,
              onTogglePassword: () {},
              isShow: false),
          MyText(
              color: black,
              text: "mobile_number",
              fontsizeNormal: Dimens.textMedium,
              fontwaight: FontWeight.w600,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              multilanguage: true,
              fontstyle: FontStyle.normal),
          IntlPhoneField(
            disableLengthCheck: true,
            textAlignVertical: TextAlignVertical.center,
            cursorColor: black,
            autovalidateMode: AutovalidateMode.disabled,
            controller: numberController,
            style: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                color: black,
                letterSpacing: 1.0,
                fontWeight: FontWeight.w600),
            showCountryFlag: true,
            showDropdownIcon: false,
            initialCountryCode: Constant.initialCountryCode,
            dropdownTextStyle: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                letterSpacing: 1.0,
                color: black,
                fontWeight: FontWeight.w400),
            pickerDialogStyle: PickerDialogStyle(backgroundColor: white),
            keyboardType: TextInputType.number,
            textInputAction: TextInputAction.next,
            decoration: InputDecoration(
              fillColor: colorPrimary.withValues(alpha: 0.2),
              filled: true,
              focusedBorder: OutlineInputBorder(
                borderRadius: const BorderRadius.all(Radius.circular(15)),
                borderSide: BorderSide.none,
              ),
              disabledBorder: OutlineInputBorder(
                borderRadius: const BorderRadius.all(Radius.circular(15)),
                borderSide: BorderSide.none,
              ),
              enabledBorder: OutlineInputBorder(
                borderRadius: const BorderRadius.all(Radius.circular(15)),
                borderSide: BorderSide.none,
              ),
              border: OutlineInputBorder(
                borderRadius: const BorderRadius.all(Radius.circular(15)),
                borderSide: BorderSide.none,
              ),
              hintText: "Enter the Phone number",
              hintStyle: GoogleFonts.inter(
                  fontSize: Dimens.textMedium,
                  fontStyle: FontStyle.normal,
                  letterSpacing: 1.0,
                  color: gray,
                  fontWeight: FontWeight.w600),
            ),
            onChanged: (phone) {
              mobilenumber = phone.completeNumber;
              countryname = phone.countryISOCode;
              countrycode = phone.countryCode;
            },
            onCountryChanged: (country) {
              countryname = country.code.replaceAll('+', '');
              countrycode = "+${country.dialCode.toString()}";
            },
          ),
          MyText(
              color: black,
              text: "password",
              fontsizeNormal: Dimens.textMedium,
              fontwaight: FontWeight.w600,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              multilanguage: true,
              fontstyle: FontStyle.normal),
          _myTextFiles(
              controller: passwordController,
              password: true,
              hintText: "Enter the password",
              textinputAction: TextInputAction.next,
              textinputType: TextInputType.visiblePassword,
              onTogglePassword: () {
                _togglePasswordVisibility();
              },
              isShow: obscureTextPassword),
          MyText(
              color: black,
              text: "conf_password",
              fontsizeNormal: Dimens.textMedium,
              fontwaight: FontWeight.w600,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              multilanguage: true,
              fontstyle: FontStyle.normal),
          _myTextFiles(
              controller: confPasswordController,
              password: true,
              hintText: "Enter the confi password",
              textinputAction: TextInputAction.next,
              textinputType: TextInputType.visiblePassword,
              onTogglePassword: () {
                _toggleConPasswordVisibility();
              },
              isShow: obscureTextPassword1),
          MyText(
              color: black,
              text:
                  "${Locales.string(context, "designation")}  (${Locales.string(context, "position")})",
              fontsizeNormal: Dimens.textMedium,
              fontwaight: FontWeight.w600,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              multilanguage: false,
              fontstyle: FontStyle.normal),
          _myTextFiles(
              controller: designationController,
              password: false,
              hintText: "Enter the designation",
              textinputAction: TextInputAction.next,
              textinputType: TextInputType.text,
              onTogglePassword: () {},
              isShow: false),
        ],
      ),
    );
  }

  Widget btnSave() {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      highlightColor: transparent,
      onTap: () {
        bool emailValidation = RegExp(
                r"^[a-zA-Z0-9.a-zA-Z0-9.!#$%&'*+-/=?^_`{|}~]+@[a-zA-Z0-9]+\.[a-zA-Z]+")
            .hasMatch(emailController.text);
        if (nameController.text.isEmpty) {
          Utils().showToast("Please Enter Your FirstName");
        } else if (emailController.text.isEmpty) {
          Utils().showToast("Please Enter Your Email");
        } else if (!emailValidation) {
          Utils().showToast("Invalid Email");
        } else if (passwordController.text.isEmpty) {
          Utils().showToast("Please Enter Your Password");
        } else if (passwordController.text.length > 6 &&
            passwordController.text.length <= 10) {
          Utils().showToast("Password Must be 6 Digit Only");
        } else if (confPasswordController.text.isEmpty) {
          Utils().showToast("Please Enter Your Confirm Password");
        } else if (confPasswordController.text != passwordController.text) {
          Utils().showToast(
              "Please Enter Your Password not same, Please Enter the right password");
        } else if (mobilenumber.isEmpty) {
          Utils().showToast("Please Enter Your Mobilenumber");
        } else {
          tutorApi(
              nameController.text,
              emailController.text,
              passwordController.text,
              numberController.text,
              countrycode,
              countryname,
              designationController.text);
        }
      },
      child: AnimatedContainer(
        margin: MediaQuery.of(context).size.width > 800
            ? const EdgeInsets.fromLTRB(600, 0, 600, 0)
            : const EdgeInsets.fromLTRB(20, 0, 20, 0),
        duration: const Duration(milliseconds: 80),
        clipBehavior: Clip.antiAliasWithSaveLayer,
        curve: Curves.bounceInOut,
        width: generalProvider.isProgressLoading
            ? 100
            : MediaQuery.of(context).size.width,
        height: 45,
        alignment: Alignment.center,
        decoration: BoxDecoration(
          color: colorPrimaryDark,
          borderRadius: BorderRadius.circular(29),
        ),
        child: generalProvider.isProgressLoading
            ? const SizedBox(
                width: 25,
                height: 25,
                child: CircularProgressIndicator(
                  color: white,
                  strokeWidth: 2,
                ),
              )
            : MyText(
                color: Theme.of(context).textTheme.bodyMedium!.color,
                text: "save",
                fontsizeNormal: Dimens.textMedium,
                fontsizeWeb: Dimens.textMedium,
                fontwaight: FontWeight.w600,
                maxline: 1,
                multilanguage: true,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal,
              ),
      ),
    );
  }

  Future<void> tutorApi(String fullName, email, password, mobileNumber,
      countryCode, countryName, designation) async {
    final pro = Provider.of<ProfileProvider>(context, listen: false);

    generalProvider.setLoading(true);
    try {
      await generalProvider.getBecomeTutor(fullName, email, password,
          mobileNumber, countryCode, countryName, designation);

      if (generalProvider.successModel.status == 200) {
        generalProvider.setLoading(false);
        if (!mounted) return;
        Utils.navigatePage(context, WebHome(), "");

        /* Profile api call */
        pro.getprofile(context);
      } else {
        Utils().showToast(generalProvider.successModel.message.toString());
        generalProvider.setLoading(false);
      }
    } catch (e) {
      Utils().showToast(generalProvider.successModel.message.toString());
      generalProvider.setLoading(false);
    }
  }

  Widget _myTextFiles({
    required dynamic controller,
    required bool password,
    required String hintText,
    required TextInputAction textinputAction,
    required TextInputType textinputType,
    required VoidCallback onTogglePassword,
    required bool isShow,
  }) {
    return TextFormField(
      obscureText:
          password ? isShow : false, // Hide only if it's a password field
      keyboardType: textinputType,
      controller: controller,
      textInputAction: textinputAction,
      cursorColor: black,
      style: GoogleFonts.inter(
          fontSize: Dimens.textMedium,
          fontStyle: FontStyle.normal,
          color: black,
          letterSpacing: 1.2,
          fontWeight: FontWeight.w600),
      decoration: InputDecoration(
        fillColor: colorPrimary.withValues(alpha: 0.2),
        filled: true,
        suffixIcon: password
            ? InkWell(
                onTap: onTogglePassword,
                child: Icon(
                  isShow ? Icons.visibility : Icons.visibility_off,
                  size: 20,
                  color: gray,
                ),
              )
            : null,
        focusedBorder: OutlineInputBorder(
          borderRadius: const BorderRadius.all(Radius.circular(15)),
          borderSide: BorderSide.none,
        ),
        disabledBorder: OutlineInputBorder(
          borderRadius: const BorderRadius.all(Radius.circular(15)),
          borderSide: BorderSide.none,
        ),
        enabledBorder: OutlineInputBorder(
          borderRadius: const BorderRadius.all(Radius.circular(15)),
          borderSide: BorderSide.none,
        ),
        border: OutlineInputBorder(
          borderRadius: const BorderRadius.all(Radius.circular(15)),
          borderSide: BorderSide.none,
        ),
        hintText: hintText,
        hintStyle: GoogleFonts.inter(
            fontSize: Dimens.textMedium,
            fontStyle: FontStyle.normal,
            letterSpacing: 1.0,
            color: black,
            fontWeight: FontWeight.w400),
      ),
    );
  }
}
