import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/cartprovider.dart';
import 'package:prakah/provider/couponprovider.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/subscription/allpayment.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webdetails.dart';
import 'package:prakah/webpages/webhome.dart';
import 'package:prakah/webpages/websearch.dart';
import 'package:prakah/webwidget/footerweb.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:font_awesome_flutter/font_awesome_flutter.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class WebAddToCart extends StatefulWidget {
  const WebAddToCart({super.key});

  @override
  State<WebAddToCart> createState() => _WebAddToCartState();
}

class _WebAddToCartState extends State<WebAddToCart> {
  CartProvider cartProvider = CartProvider();
  CouponProvider couponProvider = CouponProvider();
  // String? discountPrice, price, promocodeId, promocodeName = "";
  final ScrollController _scrollCouponController = ScrollController();
  final searchController = TextEditingController();
  @override
  void initState() {
    super.initState();
    cartProvider = Provider.of<CartProvider>(context, listen: false);
    couponProvider = Provider.of<CouponProvider>(context, listen: false);
    _scrollCouponController.addListener(_scrollCouponeListener);

    getApi();
  }

/* Coupone Data */
  void _scrollCouponeListener() {
    if (!_scrollCouponController.hasClients) return;
    if (_scrollCouponController.offset >=
            _scrollCouponController.position.maxScrollExtent &&
        !_scrollCouponController.position.outOfRange &&
        (couponProvider.currentPage ?? 0) < (couponProvider.totalPage ?? 0)) {
      couponProvider.setLoadMore(true);
      getCouponApi(couponProvider.currentPage ?? 0);
    }
  }

  Future<void> getCouponApi(int? nextPage) async {
    await couponProvider.getUseMeeting((nextPage ?? 0) + 1);
  }

/* END */
  Future<void> getApi() async {
    await cartProvider.getUseMeeting();
  }

  @override
  void dispose() {
    cartProvider.clearProvider();
    couponProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return _buildSearchHome();
  }

  Widget _buildSearchHome() {
    return Consumer<SearchProvider>(builder: (context, homeprovider, child) {
      if (homeprovider.isSearch == "0") {
        return Scaffold(
          appBar: Utils.webMainAppbar(controller: searchController),
          body: Utils.hoverItemWithPage(
              myWidget: SingleChildScrollView(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 20,
              children: [
                buildWebDetailsAppBar(),
                _buildData(),
                FooterWeb(),
              ],
            ),
          )),
        );
      } else {
        return WebSearch(
          searchController: searchController,
        );
      }
    });
  }

  Widget buildWebDetailsAppBar() {
    return Consumer<GeneralProvider>(
        builder: (context, generalprovider, child) {
      return Container(
        height: 75,
        width: MediaQuery.sizeOf(context).width,
        color: gray.withValues(alpha: 0.3),
        padding: MediaQuery.of(context).size.width > 1000
            ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
            : const EdgeInsets.fromLTRB(20, 0, 20, 0),
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.center,
          spacing: 14,
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              highlightColor: transparent,
              onTap: () async {
                generalprovider.setHomeTab("1");
                Navigator.of(context).pushAndRemoveUntil(
                    PageRouteBuilder(
                        transitionDuration: const Duration(milliseconds: 150),
                        pageBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation) {
                          return const WebHome();
                        },
                        transitionsBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation,
                            Widget child) {
                          return Align(
                              child: FadeTransition(
                                  opacity: animation, child: child));
                        }),
                    (route) => false);
              },
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                spacing: 14,
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  Icon(
                    Icons.home,
                    size: 25,
                    color: black.withValues(alpha: 0.4),
                  ),
                  MyText(
                    text: "home",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textMedium,
                    fontsizeWeb: Dimens.textTitle,
                    fontwaight: FontWeight.w600,
                    color: black,
                  ),
                ],
              ),
            ),
            InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              onTap: () {},
              child: Row(
                children: [
                  Icon(
                    Icons.keyboard_arrow_right_rounded,
                    size: 25,
                    color: black.withValues(alpha: 0.4),
                  ),
                  MyText(
                      text: "my_cart",
                      multilanguage: true,
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textTitle,
                      fontwaight: FontWeight.w600,
                      color: colorPrimaryDark),
                ],
              ),
            ),
          ],
        ),
      );
    });
  }

  Widget _buildData() {
    return Consumer<CartProvider>(builder: (context, cartProvider, child) {
      if (cartProvider.loading) {
        return Padding(
          padding: MediaQuery.of(context).size.width > 800
              ? const EdgeInsets.fromLTRB(200, 25, 200, 20)
              : const EdgeInsets.fromLTRB(20, 25, 20, 20),
          child: courseShimmer(),
        );
      } else {
        if (cartProvider.cartModel.status == 200 &&
            (cartProvider.cartModel.result?.length ?? 0) > 0) {
          return Padding(
            padding: MediaQuery.of(context).size.width > 800
                ? const EdgeInsets.fromLTRB(200, 20, 200, 20)
                : const EdgeInsets.fromLTRB(20, 20, 20, 20),
            child: MediaQuery.of(context).size.width < 1000
                ? Column(
                    children: [_buildCartView(), _buildConfiData()],
                  )
                : Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    spacing: 20,
                    children: [
                      Flexible(fit: FlexFit.tight, child: _buildCartView()),
                      Flexible(fit: FlexFit.loose, child: _buildConfiData())
                    ],
                  ),
          );
        } else {
          return const NoData();
        }
      }
    });
  }

  Widget _buildCartView() {
    return Container(
      decoration: BoxDecoration(
        color: white,
        border: Border.all(
          width: 1,
          color: gray,
          style: BorderStyle.solid,
        ),
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
            child: MyText(
                color: black,
                text: "shopping_cart",
                multilanguage: true,
                fontsizeNormal: Dimens.textTitle,
                fontwaight: FontWeight.w600,
                maxline: 2,
                overflow: TextOverflow.ellipsis,
                fontstyle: FontStyle.normal),
          ),
          Container(
            padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
            decoration: BoxDecoration(
                color: gray,
                border: Border.all(
                    width: 1, color: gray, style: BorderStyle.solid)),
            child: Row(
              children: [
                Expanded(
                  flex: 7,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: "products",
                      multilanguage: true,
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      fontstyle: FontStyle.normal),
                ),
                Expanded(
                  flex: 3,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      multilanguage: true,
                      text: "prices",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
              ],
            ),
          ),
          Padding(
            padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
            child: _buildCartData(),
          ),
        ],
      ),
    );
  }

  Widget _buildCartData() {
    return ListView.separated(
        shrinkWrap: true,
        physics: NeverScrollableScrollPhysics(),
        itemBuilder: (context, index) {
          return InkWell(
            onTap: () {
              Navigator.of(context).push(
                PageRouteBuilder(
                  transitionDuration: const Duration(milliseconds: 200),
                  pageBuilder: (BuildContext context,
                      Animation<double> animation,
                      Animation<double> secondaryAnimation) {
                    return WebDetail(
                        courseId: cartProvider.cartModel.result?[index].id
                                .toString() ??
                            "");
                  },
                  transitionsBuilder: (BuildContext context,
                      Animation<double> animation,
                      Animation<double> secondaryAnimation,
                      Widget child) {
                    return Align(
                      child: FadeTransition(
                        opacity: animation,
                        child: child,
                      ),
                    );
                  },
                ),
              );
            },
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Expanded(
                  flex: 7,
                  child: Row(
                    spacing: 10,
                    children: [
                      InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        onTap: () async {
                          await cartProvider.getRemoveCart(
                              index,
                              cartProvider.cartModel.result?[index].courseId
                                      .toString() ??
                                  "");

                          cartProvider.addPrice();
                        },
                        child: Icon(
                          Icons.close_rounded,
                          size: 20,
                          color: gray,
                        ),
                      ),
                      MyNetworkImage(
                          imgWidth: 72,
                          imgHeight: 72,
                          fit: BoxFit.fill,
                          radius: 10,
                          imageUrl: cartProvider
                                  .cartModel.result?[index].courseImage
                                  .toString() ??
                              ""),
                      Expanded(
                        child: MyText(
                            color: Theme.of(context).colorScheme.surface,
                            text: cartProvider
                                    .cartModel.result?[index].courseTitle
                                    .toString() ??
                                "",
                            fontsizeNormal: Dimens.textMedium,
                            fontwaight: FontWeight.w600,
                            maxline: 2,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                      ),
                    ],
                  ),
                ),
                Expanded(
                  flex: 3,
                  child: MyText(
                      color: black,
                      text: (cartProvider.cartModel.result?[index].price
                                      .toString() ??
                                  "") ==
                              "0"
                          ? Locales.string(context, "free")
                          : "${Constant.currencyCode} ${cartProvider.cartModel.result?[index].price.toString() ?? ""}",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
              ],
            ),
          );
        },
        separatorBuilder: (context, index) {
          return SizedBox(height: 10);
        },
        itemCount: cartProvider.cartModel.result?.length ?? 0);
  }

  Widget courseShimmer() {
    return Container(
      decoration: BoxDecoration(
        color: white,
        border: Border.all(
          width: 1,
          color: gray,
          style: BorderStyle.solid,
        ),
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
            child: MyText(
                color: black,
                text: "shopping_cart",
                multilanguage: true,
                fontsizeNormal: Dimens.textTitle,
                fontwaight: FontWeight.w600,
                maxline: 2,
                overflow: TextOverflow.ellipsis,
                fontstyle: FontStyle.normal),
          ),
          Container(
            padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
            decoration: BoxDecoration(
                color: gray,
                border: Border.all(
                    width: 1, color: gray, style: BorderStyle.solid)),
            child: Row(
              children: [
                Expanded(
                  flex: 7,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: "products",
                      multilanguage: true,
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
                Expanded(
                  flex: 3,
                  child: MyText(
                      color: Theme.of(context).colorScheme.surface,
                      multilanguage: true,
                      text: "prices",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
              ],
            ),
          ),
          Padding(
            padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
            child: ListView.separated(
                shrinkWrap: true,
                physics: NeverScrollableScrollPhysics(),
                itemBuilder: (context, index) {
                  return Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      Expanded(
                        flex: 7,
                        child: Row(
                          spacing: 10,
                          children: [
                            CustomWidget.roundcorner(height: 72, width: 72),
                            CustomWidget.roundcorner(height: 16, width: 150),
                          ],
                        ),
                      ),
                      Expanded(
                        flex: 3,
                        child: CustomWidget.roundcorner(height: 16, width: 80),
                      ),
                    ],
                  );
                },
                separatorBuilder: (context, index) {
                  return SizedBox(height: 10);
                },
                itemCount: 10),
          ),
        ],
      ),
    );
  }

/* Payment info Data started */
  /* Confirm appointment Data show */
  Widget _buildConfiData() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      spacing: 20,
      children: [
        MyText(
          text: "payment_info",
          multilanguage: true,
          color: black,
          maxline: 1,
          fontsizeNormal: Dimens.textTitle,
          fontsizeWeb: Dimens.textMedium,
          fontwaight: FontWeight.w600,
        ),
        paymentSummaryData(),
        _couponeShowdata(),
      ],
    );
  }

  Widget paymentSummaryData() {
    return Container(
      width: MediaQuery.sizeOf(context).width,
      padding: const EdgeInsets.fromLTRB(15, 15, 25, 15),
      decoration: BoxDecoration(
          color: white,
          borderRadius: BorderRadius.circular(12),
          border: Border.all(
              width: 1,
              color: gray.withValues(alpha: 0.3),
              style: BorderStyle.solid)),
      child: Column(
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              MyText(
                text: 'item_total',
                multilanguage: true,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: gray,
                fontwaight: FontWeight.w500,
              ),
              MyText(
                text:
                    '${Constant.currencyCode} ${cartProvider.priceItem.toString()}',
                multilanguage: false,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: black,
                fontwaight: FontWeight.w500,
              ),
            ],
          ),
          const SizedBox(height: 10),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              MyText(
                text: 'taxes_fee',
                decoration: TextDecoration.underline,
                decorationStyle: TextDecorationStyle.dotted,
                decorationColor: black,
                multilanguage: true,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: gray,
                fontwaight: FontWeight.w500,
              ),
              MyText(
                text:
                    '${Constant.currencyCode} ${cartProvider.discountPrice ?? 0}',
                multilanguage: false,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: black,
                fontwaight: FontWeight.w500,
              ),
            ],
          ),
          Divider(
            thickness: 1,
            height: 20,
            color: gray.withValues(alpha: .8),
          ),
          const SizedBox(height: 10),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              MyText(
                text: 'total_price',
                multilanguage: true,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: gray,
                fontwaight: FontWeight.w500,
              ),
              MyText(
                text:
                    '${Constant.currencyCode} ${cartProvider.totalPrice ?? cartProvider.priceItem.toString()}',
                multilanguage: false,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: black,
                fontwaight: FontWeight.w500,
              ),
            ],
          ),
          const SizedBox(height: 10),
          _btnConfWidget()
        ],
      ),
    );
  }

  Widget _btnConfWidget() {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: () {
        String? totalPrice = (cartProvider.totalPrice ?? "").isNotEmpty
            ? cartProvider.totalPrice
            : cartProvider.priceItem.toString();
        Navigator.of(context).push(
          PageRouteBuilder(
            pageBuilder: (context, animation, secondaryAnimation) => AllPayment(
              payType: "cart",
              cartType: "1",
              price: totalPrice,
              discountPrice: cartProvider.discountPrice ?? "0",
              promoCodeId: cartProvider.promocodeId ?? "0",
            ),
            transitionsBuilder:
                (context, animation, secondaryAnimation, child) {
              const begin = Offset(1.0, 0.0);
              const end = Offset.zero;
              const curve = Curves.ease;

              var tween =
                  Tween(begin: begin, end: end).chain(CurveTween(curve: curve));

              return SlideTransition(
                position: animation.drive(tween),
                child: child,
              );
            },
          ),
        );
        // if (result != null) {
        //   showType = result['isType'];
        //   cartProvider.providerNotifi();
        // }
      },
      child: Container(
        padding: EdgeInsets.fromLTRB(20, 8, 20, 8),
        alignment: Alignment.center,
        width: MediaQuery.sizeOf(context).width,
        decoration: BoxDecoration(
            border: Border.all(
                width: 1, color: transparent, style: BorderStyle.solid),
            color: colorPrimaryDark,
            borderRadius: BorderRadius.circular(36)),
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.center,
          spacing: 20,
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Flexible(
              fit: FlexFit.loose,
              child: MyText(
                text: "proceed_checkout".toUpperCase().toString(),
                multilanguage: true,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textMedium,
                color: white,
                fontwaight: FontWeight.w500,
              ),
            ),
            Icon(
              Icons.arrow_forward,
              size: 20,
              color: white,
            ),
          ],
        ),
      ),
    );
  }

  Widget _couponeShowdata() {
    return InkWell(
        onTap: () async {
          couponShowBottomSheet();

          await getCouponApi(0);
        },
        child: Container(
            padding: EdgeInsets.fromLTRB(15, 10, 15, 10),
            decoration: BoxDecoration(
                color: white,
                borderRadius: BorderRadius.circular(12),
                border: Border.all(
                    width: 1,
                    color: gray.withValues(alpha: 0.3),
                    style: BorderStyle.solid)),
            child: Row(
                spacing: 10,
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  Icon(Icons.discount, size: 20, color: colorPrimary),
                  Expanded(
                      child: MyText(
                          text: ((cartProvider.promocodeName ?? "").isEmpty)
                              ? Locales.string(context, "add_coupon")
                              : cartProvider.promocodeName ?? "",
                          multilanguage: false,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          fontsizeNormal: Dimens.textBig,
                          color: black,
                          fontwaight: FontWeight.w500)),
                  ((cartProvider.promocodeName ?? "").isEmpty)
                      ? SizedBox.shrink()
                      : InkWell(
                          splashColor: transparent,
                          focusColor: transparent,
                          hoverColor: transparent,
                          highlightColor: transparent,
                          onTap: () async {
                            await cartProvider.getRemoveCoupone(
                                cartProvider.priceItem.toString());

                            if (cartProvider.applyCouponModel.status == 200) {
                              cartProvider.discountPrice = cartProvider
                                  .applyCouponModel.result?[0].discountAmount
                                  .toString();
                              cartProvider.totalPrice = cartProvider
                                  .applyCouponModel.result?[0].price
                                  .toString();

                              cartProvider.promocodeName = "";
                              cartProvider.promocodeId = "0";
                            } else {
                              if (!mounted) return;

                              Utils.showSnackbar(
                                  context,
                                  "fail",
                                  cartProvider.applyCouponModel.message ?? "",
                                  false);
                            }
                          },
                          child: Container(
                            height: 24,
                            width: 24,
                            alignment: Alignment.center,
                            decoration: BoxDecoration(
                                color: gray.withValues(alpha: 0.3),
                                shape: BoxShape.circle),
                            child: Icon(
                              FontAwesomeIcons.xmark,
                              size: 20,
                              color: black,
                            ),
                          ),
                        ),
                  Container(
                      height: 24,
                      width: 24,
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                          color: gray.withValues(alpha: 0.3),
                          shape: BoxShape.circle),
                      child: Icon(Icons.keyboard_arrow_right,
                          size: 20, color: black))
                ])));
  }

  void couponShowBottomSheet() {
    showModalBottomSheet(
      context: context,
      backgroundColor: white,
      showDragHandle: true,
      isDismissible: true,
      isScrollControlled: true,
      enableDrag: true,
      builder: (context) {
        return Consumer<CouponProvider>(
            builder: (context, cartProvider, child) {
          return SizedBox(
            height: 600,
            width: MediaQuery.sizeOf(context).width,
            child: _buildCouponeData(),
          );
        });
      },
    );
  }

  Widget _buildCouponeData() {
    if (couponProvider.loading) {
      return shimmer();
    } else {
      if (couponProvider.cartList != null &&
          (couponProvider.cartList?.length ?? 0) > 0) {
        return SingleChildScrollView(
          controller: _scrollCouponController,
          padding: const EdgeInsets.fromLTRB(15, 10, 15, 10),
          clipBehavior: Clip.antiAliasWithSaveLayer,
          physics: const AlwaysScrollableScrollPhysics(),
          child: Column(
            children: [
              couponData(),
              const SizedBox(height: 10),
              if (couponProvider.loadMore)
                Utils.pageLoader()
              else
                const SizedBox.shrink(),
              const SizedBox(height: 20),
            ],
          ),
        );
      } else {
        return const NoData();
      }
    }
  }

  Widget couponData() {
    return ResponsiveGridList(
        minItemWidth: 300,
        verticalGridMargin: 0,
        horizontalGridMargin: 0,
        verticalGridSpacing: 10,
        horizontalGridSpacing: 10,
        minItemsPerRow: 1,
        maxItemsPerRow: 2,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true, physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          couponProvider.cartList?.length ?? 0,
          (index) {
            return InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              onTap: () {
                applyApi(
                    index,
                    couponProvider.cartList?[index].id.toString() ?? "",
                    cartProvider.priceItem,
                    couponProvider.cartList?[index].name.toString() ?? "");

                printLog("this is api call");
              },
              child: Card(
                color: white,
                child: Padding(
                  padding: const EdgeInsets.fromLTRB(14, 10, 14, 10),
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    spacing: 20,
                    children: [
                      MyNetworkImage(
                          imageUrl: couponProvider.cartList?[index].image
                                  .toString() ??
                              "",
                          imgHeight: 60,
                          imgWidth: 60,
                          radius: 10,
                          fit: BoxFit.contain),
                      Expanded(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            MyText(
                              text: couponProvider.cartList?[index].name
                                      .toString() ??
                                  "",
                              maxline: 2,
                              overflow: TextOverflow.ellipsis,
                              multilanguage: false,
                              fontsizeNormal: Dimens.textMedium,
                              color: black,
                              fontwaight: FontWeight.w500,
                            ),
                            MyText(
                              text:
                                  "${Locales.string(context, "use_code")} : ${couponProvider.cartList?[index].promoCode.toString() ?? ""}",
                              maxline: 2,
                              overflow: TextOverflow.ellipsis,
                              multilanguage: false,
                              fontsizeNormal: Dimens.textMedium,
                              color: black,
                              fontwaight: FontWeight.w500,
                            ),
                            const SizedBox(height: 5),
                            MyText(
                              text: (couponProvider.cartList?[index].type
                                              .toString() ??
                                          "") ==
                                      "1"
                                  ? '${Constant.currencyCode} ${couponProvider.cartList?[index].discountAmount ?? ""}'
                                  : "% ${couponProvider.cartList?[index].discountAmount.toString() ?? ""}",
                              maxline: 2,
                              overflow: TextOverflow.ellipsis,
                              multilanguage: false,
                              fontsizeNormal: Dimens.textMedium,
                              color: colorPrimaryDark,
                              fontwaight: FontWeight.w400,
                            ),
                          ],
                        ),
                      ),
                      InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        onTap: () {
                          applyApi(
                              index,
                              couponProvider.cartList?[index].id.toString() ??
                                  "",
                              cartProvider.priceItem,
                              couponProvider.cartList?[index].name.toString() ??
                                  "");

                          printLog("this is api call");
                        },
                        child: AnimatedContainer(
                          duration: Duration(milliseconds: 600),
                          padding: const EdgeInsets.fromLTRB(10, 4, 10, 4),
                          decoration: BoxDecoration(
                              color: white,
                              borderRadius: BorderRadius.circular(6),
                              border: Border.all(
                                  width: 1,
                                  color: gray,
                                  style: BorderStyle.solid)),
                          child: couponProvider.applyLoded &&
                                  couponProvider.index == index
                              ? SizedBox(
                                  height: 20,
                                  width: 20,
                                  child: CircularProgressIndicator(
                                    color: colorPrimaryDark,
                                  ),
                                )
                              : MyText(
                                  text: 'apply',
                                  maxline: 2,
                                  overflow: TextOverflow.ellipsis,
                                  multilanguage: true,
                                  fontsizeNormal: Dimens.textSmall,
                                  color: black,
                                  fontwaight: FontWeight.w400,
                                ),
                        ),
                      )
                    ],
                  ),
                ),
              ),
            );
          },
        ));
  }

  Widget shimmerCoupon() {
    return ResponsiveGridList(
        minItemWidth: 300,
        verticalGridMargin: 10,
        horizontalGridMargin: 10,
        verticalGridSpacing: 10,
        horizontalGridSpacing: 10,
        minItemsPerRow: 1,
        maxItemsPerRow: 2,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true, physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          10,
          (index) {
            return const Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                CustomWidget.circular(height: 20, width: 20),
                SizedBox(width: 20),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      CustomWidget.roundcorner(height: 22, width: 100),
                      SizedBox(height: 3),
                      CustomWidget.roundcorner(height: 16, width: 200),
                      SizedBox(height: 3),
                      CustomWidget.roundcorner(height: 18, width: 100),
                    ],
                  ),
                )
              ],
            );
          },
        ));
  }

  Widget shimmer() {
    return ResponsiveGridList(
        minItemWidth: 400,
        maxItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 3,
            height1200: 2,
            height800: 1,
            height400: 1),
        minItemsPerRow: Utils.customCrossAxisCount(
            context: context,
            height1600: 3,
            height1200: 2,
            height800: 1,
            height400: 1),
        verticalGridMargin: 0,
        horizontalGridMargin: 20,
        verticalGridSpacing: 0,
        listViewBuilderOptions: ListViewBuilderOptions(
            padding: EdgeInsets.zero,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics()),
        children: List.generate(10, (index) {
          return Column(children: [
            Row(children: [
              CustomWidget.circular(height: 30, width: 30),
              Expanded(
                  child: CustomWidget.roundcorner(
                      height: 20, width: MediaQuery.sizeOf(context).width)),
              CustomWidget.roundcorner(height: 20, width: 60)
            ]),
            const SizedBox(height: 8),
            Row(children: [
              Expanded(
                  child: CustomWidget.roundcorner(
                      height: 20, width: MediaQuery.sizeOf(context).width)),
              const SizedBox(width: 50),
              Expanded(
                  child: CustomWidget.roundcorner(
                      height: 20, width: MediaQuery.sizeOf(context).width))
            ])
          ]);
        }));
  } /* Apply coupen Api */

  Future<void> applyApi(
      int index, promocodeId, totalPrice, promocodeName) async {
    couponProvider.setApplyLoding(true);

    await couponProvider.getApplyCoupon(index, promocodeId, totalPrice);
    if (!mounted) return;
    if (couponProvider.applyCouponModel.status == 200 &&
        (couponProvider.applyCouponModel.result?.length ?? 0) > 0) {
      couponProvider.setApplyLoding(false);

      Navigator.of(context).pop();

      cartProvider.setPrice(
          disPri: couponProvider.applyCouponModel.result?[0].discountAmount
                  .toString() ??
              "",
          value: couponProvider.applyCouponModel.result?[0].totalPrice ?? 0,
          proId: promocodeId,
          proName: promocodeName,
          totPrice:
              couponProvider.applyCouponModel.result?[0].price.toString() ??
                  "");
    } else {
      couponProvider.setApplyLoding(false);

      printLog(couponProvider.applyCouponModel.message ?? "");
    }
  }
}
