import 'dart:async';
import 'dart:convert';
import 'dart:io';
import 'dart:isolate';
import 'dart:math';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter_html/flutter_html.dart';
import 'package:hive/hive.dart';
import 'package:share_plus/share_plus.dart';
import 'package:url_launcher/url_launcher.dart';
import 'package:prakah/model/download_item.dart';
import 'package:prakah/pages/login.dart';
import 'package:prakah/players/player_video.dart';
import 'package:prakah/players/player_vimeo.dart';
import 'package:prakah/players/player_youtube.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/provider/themeprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/constant.dart';
import 'dart:math' as number;
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/webpages/webdetails.dart';
import 'package:prakah/webpages/weblogin.dart';
import 'package:prakah/webpages/webnotificationpage.dart';
import 'package:prakah/webwidget/webappbar.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:intl/intl.dart';
import 'package:path_provider/path_provider.dart';
import 'package:progress_dialog_null_safe/progress_dialog_null_safe.dart';
import 'package:path/path.dart' as path;
import 'package:http/http.dart' as http;
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';
import 'package:encrypt/encrypt.dart' as excrypt;

void printLog(String message) {
  if (kDebugMode) {
    return print(message);
  }
}

class Utils {
  ProgressDialog? prDialog;

  dynamic showToast(String msg) {
    Fluttertoast.showToast(
        msg: msg,
        toastLength: Toast.LENGTH_SHORT,
        gravity: ToastGravity.BOTTOM,
        timeInSecForIosWeb: 2,
        backgroundColor: colorPrimaryDark,
        textColor: white,
        fontSize: 14);
  }

  static Widget pageLoader() {
    return const Align(
      alignment: Alignment.center,
      child: CircularProgressIndicator(
        color: colorPrimary,
      ),
    );
  }

  static String formateDate(String date, String format) {
    String finalDate = "";
    DateFormat inputDate = DateFormat("yyyy-MM-dd");
    DateFormat outputDate = DateFormat(format);

    DateTime inputTime = inputDate.parse(date);

    finalDate = outputDate.format(inputTime);

    return finalDate;
  }

  static String dateConvert(String date, String format) {
    final DateTime now = DateTime.parse(date);
    final DateFormat formatter = DateFormat(format);
    return formatter.format(now);
  }

  /* String time formate code */
  static String formateTime(
      {required String? staTime, required String? enTime}) {
    if (staTime == null ||
        staTime.isEmpty ||
        enTime == null ||
        enTime.isEmpty) {
      return "";
    }

    try {
      DateTime start = DateFormat("HH:mm").parse(staTime);
      DateTime end = DateFormat("HH:mm").parse(enTime);

      String formattedStart = DateFormat("hh:mm a").format(start);
      String formattedEnd = DateFormat("hh:mm a").format(end);

      return "$formattedStart - $formattedEnd";
    } catch (e) {
      printLog("Time format error: $e");
      return "";
    }
  }

  static String formatDuration(double time) {
    Duration duration = Duration(milliseconds: time.round());

    return [duration.inHours, duration.inMinutes, duration.inSeconds]
        .map((seg) => seg.remainder(60).toString().padLeft(2, '0'))
        .join(':');
  }

  static String timeAgoCustom(DateTime d) {
    // <-- Custom method Time Show  (Display Example  ==> 'Today 7:00 PM')     // WhatsApp Time Show Status Shimila
    Duration diff = DateTime.now().difference(d);
    if (diff.inDays > 365) {
      return "${(diff.inDays / 365).floor()} ${(diff.inDays / 365).floor() == 1 ? "year" : "years"} ago";
    }
    if (diff.inDays > 30) {
      return "${(diff.inDays / 30).floor()} ${(diff.inDays / 30).floor() == 1 ? "month" : "months"} ago";
    }
    if (diff.inDays > 7) {
      return "${(diff.inDays / 7).floor()} ${(diff.inDays / 7).floor() == 1 ? "week" : "weeks"} ago";
    }
    if (diff.inDays > 0) {
      return DateFormat.E().add_jm().format(d);
    }
    if (diff.inHours > 0) return "Today ${DateFormat('jm').format(d)}";
    if (diff.inMinutes > 0) {
      return "${diff.inMinutes} ${diff.inMinutes == 1 ? "minute" : "minutes"} ago";
    }
    return "just now";
  }

  void showProgress(BuildContext context, String message) async {
    if (kIsWeb) {
      prDialog = ProgressDialog(context,
          type: ProgressDialogType.normal,
          isDismissible: false,
          showLogs: false,
          customBody: Container(
            height: 60,
            width: MediaQuery.sizeOf(context).width > 600
                ? 400
                : MediaQuery.sizeOf(context).width,
            decoration: BoxDecoration(
              color: white,
              borderRadius: BorderRadius.circular(6),
            ),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.center,
              spacing: 20,
              children: [
                Container(
                  width: 40,
                  height: 40,
                  padding: const EdgeInsets.all(8),
                  child: CircularProgressIndicator(
                    color: colorPrimaryDark,
                  ),
                ),
                Flexible(
                  fit: FlexFit.loose,
                  child: MyText(
                      text: message,
                      color: colorPrimaryDark,
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textExtraBig,
                      fontwaight: FontWeight.w600,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.center,
                      multilanguage: false,
                      fontstyle: FontStyle.normal),
                ),
              ],
            ),
          ));
    } else {
      prDialog = ProgressDialog(context,
          type: ProgressDialogType.normal,
          isDismissible: false,
          showLogs: false);

      prDialog?.style(
        message: message.toString(),
        borderRadius: 5,
        progressWidget: Container(
          width: 200,
          padding: const EdgeInsets.all(8),
          child: CircularProgressIndicator(
            color: colorPrimaryDark,
          ),
        ),
        maxProgress: 100,
        progressTextStyle: TextStyle(
          color: Theme.of(context).colorScheme.surface,
          fontSize: 13,
          fontWeight: FontWeight.w500,
        ),
        backgroundColor: Theme.of(context).cardColor,
        insetAnimCurve: Curves.easeInOut,
        messageTextStyle: TextStyle(
          color: Theme.of(context).colorScheme.surface,
          fontSize: 14,
          fontWeight: FontWeight.normal,
        ),
      );
    }

    await prDialog!.show();
  }

  void hideProgress(BuildContext context) async {
    prDialog = ProgressDialog(context);
    if (prDialog!.isShowing()) {
      prDialog!.hide();
    }
  }

/* Web register page show the privacy policy */
  static Future<String> getPrivacyTandCText(
      {required String privacyUrl, required String termsConditionUrl}) async {
    printLog('privacyUrl ==> $privacyUrl');
    printLog('T&C Url =====> $termsConditionUrl');

    String strPrivacyAndTNC =
        "<p> I agree with <a href=$termsConditionUrl>Terms</a> and"
        " <a href=$privacyUrl>Privacy Policy</a> </p>";

    printLog('strPrivacyAndTNC =====> $strPrivacyAndTNC');
    return strPrivacyAndTNC;
  }

/* Html Formate Text Write */
  static Html htmlTexts(BuildContext context, var strText) {
    return Html(
      data: strText,
      style: {
        "body": Style(
            margin: Margins.zero, // removes default spacing
            padding: HtmlPaddings.zero, // removes extra padding
            alignment: Alignment.topLeft,
            color: gray,
            fontSize: FontSize(Dimens.textMedium),
            fontWeight: FontWeight.w700,
            fontStyle: FontStyle.normal,
            textAlign: TextAlign.left),
        "a": Style(
            color: colorPrimary,
            fontSize: FontSize(Dimens.textMedium),
            fontWeight: FontWeight.w700,
            fontStyle: FontStyle.normal,
            textAlign: TextAlign.left),
        "p": Style(
            margin: Margins.zero, // removes default spacing
            padding: HtmlPaddings.zero, // removes extra padding
            alignment: Alignment.topLeft,
            color: gray,
            fontSize: FontSize(Dimens.textMedium),
            fontWeight: FontWeight.w700,
            fontStyle: FontStyle.normal,
            textAlign: TextAlign.left),
      },
      onLinkTap: (url, _, ___) async {
        printLog("htmlTexts url =========> $url");
        // Fix the URL using Uri
        Uri? fixedUri = Uri.parse(url ?? "").replace(
          path: Uri.parse(url ?? "").path.replaceAll("//", "/"),
        );

        // Convert the fixed Uri back to a string
        String? fixedUrl = fixedUri.toString();
        printLog("FIX tHos url $fixedUrl");
        if (await canLaunchUrl(Uri.parse(fixedUrl))) {
          await launchUrl(
            Uri.parse(fixedUrl),
            mode: LaunchMode.platformDefault,
          );
        } else {
          throw 'Could not launch $fixedUrl';
        }
      },
      shrinkWrap: true,
    );
  }

/* Back Button  */
  static Widget backButton(BuildContext context) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: () {
        Navigator.of(context).pop();
      },
      child: Icon(
        Icons.arrow_back_outlined,
        size: 20,
        color: white,
      ),
    );
  }

  /* ***************** generate Unique OrderID START ***************** */
  static String generateRandomOrderID() {
    int getRandomNumber;
    String? finalOID;
    printLog("fixFourDigit =>>> ${Constant().fixFourDigit}");
    printLog("fixSixDigit =>>> ${Constant().fixSixDigit}");

    number.Random r = number.Random();
    int ran5thDigit = r.nextInt(9);
    printLog("Random ran5thDigit =>>> $ran5thDigit");

    int randomNumber = number.Random().nextInt(9999999);
    printLog("Random randomNumber =>>> $randomNumber");
    if (randomNumber < 0) {
      randomNumber = -randomNumber;
    }
    getRandomNumber = randomNumber;
    printLog("getRandomNumber =>>> $getRandomNumber");

    finalOID = "${Constant().fixFourDigit.toInt()}"
        "$ran5thDigit"
        "${Constant().fixSixDigit.toInt()}"
        "$getRandomNumber";
    printLog("finalOID =>>> $finalOID");

    return finalOID;
  }
  /* ***************** generate Unique OrderID END ***************** */

  static String formatToHHMMSS(int seconds) {
    if (seconds == 0) {
      return 'Holiday';
    }
    int days = seconds ~/ 86400; // 1 day = 86400 seconds
    int hours = (seconds % 86400) ~/ 3600; // Remaining hours within a day
    int minutes = (seconds % 3600) ~/ 60; // Remaining minutes
    int remainingSeconds = seconds % 60; // Remaining seconds

    // Format HH:MM:SS
    String timeFormatted = '${hours.toString().padLeft(2, '0')}:'
        '${minutes.toString().padLeft(2, '0')}:'
        '${remainingSeconds.toString().padLeft(2, '0')}';

    // If there are days, include them
    return days > 0 ? '$days days $timeFormatted' : timeFormatted;
  }

  static String kmbGenerator(int num) {
    if (num > 999 && num < 99999) {
      return "${(num / 1000).toStringAsFixed(1)} K";
    } else if (num > 99999 && num < 999999) {
      return "${(num / 1000).toStringAsFixed(0)} K";
    } else if (num > 999999 && num < 999999999) {
      return "${(num / 1000000).toStringAsFixed(1)} M";
    } else if (num > 999999999) {
      return "${(num / 1000000000).toStringAsFixed(1)} B";
    } else {
      return num.toString();
    }
  }

  static AppBar myAppBarWithBack({
    required BuildContext context,
    required String? appBarTitle,
    required bool? multilanguage,
    String? editType,
  }) {
    return AppBar(
      backgroundColor: colorPrimaryDark,
      elevation: 0,
      surfaceTintColor: transparent,
      systemOverlayStyle: SystemUiOverlayStyle(
          statusBarColor: transparent,
          systemNavigationBarColor: transparent,
          systemNavigationBarDividerColor: transparent),
      centerTitle: false,
      titleSpacing: 0,
      leading: editType == "1"
          ? InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              onTap: () {
                Navigator.of(context).pop();
              },
              child: Icon(
                Icons.arrow_back_outlined,
                size: 20,
                color: white,
              ),
            )
          : SizedBox.shrink(),
      title: MyText(
        text: appBarTitle ?? "",
        multilanguage: multilanguage,
        fontsizeNormal: Dimens.textTitle,
        fontsizeWeb: Dimens.textTitle,
        fontstyle: FontStyle.normal,
        fontwaight: FontWeight.bold,
        textalign: TextAlign.center,
        color: white,
      ),
    );
  }

  static BoxDecoration setBackground(Color color, double radius) {
    return BoxDecoration(
      color: color,
      borderRadius: BorderRadius.circular(radius),
      shape: BoxShape.rectangle,
    );
  }

  static Future<void> initializeHiveBoxes() async {
    printLog("initializeHiveBoxes userId ==> ${Constant.userID}");
    if (Constant.userID == null) {
      try {
        await Hive.deleteBoxFromDisk(Constant.hiveDownloadBox);
        await Hive.deleteBoxFromDisk(Constant.hiveSeasonDownloadBox);
        await Hive.deleteBoxFromDisk(Constant.hiveEpiDownloadBox);
      } catch (e) {
        printLog("Error ===> ${e.toString()}");
      }
    }

    printLog("hiveDownloadBox ============> ${Constant.hiveDownloadBox}");
    printLog("hiveSeasonDownloadBox ======> ${Constant.hiveSeasonDownloadBox}");
    printLog("hiveEpiDownloadBox =========> ${Constant.hiveEpiDownloadBox}");
    if (Constant.userID != null) {
      bool? isDownloadBoxExists = await Hive.boxExists(
          '${Constant.hiveDownloadBox}_${Constant.userID}');
      bool? isSeasonBoxExists = await Hive.boxExists(
          '${Constant.hiveSeasonDownloadBox}_${Constant.userID}');
      bool? isEpisodeBoxExists = await Hive.boxExists(
          '${Constant.hiveEpiDownloadBox}_${Constant.userID}');

      printLog("isDownloadBoxExists ========> $isDownloadBoxExists");
      printLog("isSeasonBoxExists ==========> $isSeasonBoxExists");
      printLog("isEpisodeBoxExists =========> $isEpisodeBoxExists");
      await Hive.openBox<DownloadItem>(
          '${Constant.hiveDownloadBox}_${Constant.userID}');
      await Hive.openBox<ChapterItem>(
          '${Constant.hiveSeasonDownloadBox}_${Constant.userID}');
      await Hive.openBox<EpisodeItem>(
          '${Constant.hiveEpiDownloadBox}_${Constant.userID}');
    } else {
      await Hive.openBox<DownloadItem>(Constant.hiveDownloadBox);
      await Hive.openBox<ChapterItem>(Constant.hiveSeasonDownloadBox);
      await Hive.openBox<EpisodeItem>(Constant.hiveEpiDownloadBox);
    }
  }

  static void showSnackbar(BuildContext context, String showFor, String message,
      bool multilanguage) {
    ScaffoldMessenger.of(context).showSnackBar(
      SnackBar(
        width: kIsWeb
            ? MediaQuery.of(context).size.width * 0.50
            : MediaQuery.of(context).size.width,
        duration: const Duration(seconds: 1),
        behavior: SnackBarBehavior.floating,
        clipBehavior: Clip.antiAliasWithSaveLayer,
        backgroundColor: showFor == "fail"
            ? red
            : showFor == "info"
                ? gray
                : showFor == "success"
                    ? colorPrimaryDark
                    : colorPrimaryDark,
        content: MyText(
          text: message,
          fontsizeNormal: 14,
          fontsizeWeb: 14,
          multilanguage: multilanguage,
          fontstyle: FontStyle.normal,
          fontwaight: FontWeight.w500,
          color: showFor == "info" ? black : white,
          textalign: TextAlign.center,
        ),
      ),
    );
  }

  static Future<File?> saveImageInStorage(String imgUrl) async {
    try {
      var response = await http.get(Uri.parse(imgUrl));
      Directory? documentDirectory;
      if (Platform.isAndroid) {
        documentDirectory = await getExternalStorageDirectory();
      } else {
        documentDirectory = await getApplicationDocumentsDirectory();
      }
      File file = File(path.join(documentDirectory?.path ?? "",
          '${DateTime.now().millisecondsSinceEpoch.toString()}.png'));
      file.writeAsBytesSync(response.bodyBytes);
      return file;
    } catch (e) {
      printLog("saveImageInStorage Exception ===> $e");
      return null;
    }
  }

  static void getCurrencySymbol() async {
    SharedPre sharedPref = SharedPre();
    Constant.currencyCode = await sharedPref.read("currency_code") ?? "";
    Constant.currency = await sharedPref.read("currency") ?? "";
  }

  static void saveUserCreds({
    required String? userID,
    required String userName,
    required String fullName,
    required String email,
    required String mobileNumber,
    required String image,
    required String deviceType,
    required String deviceToken,
    required String userIsBuy,
    required String type,
  }) async {
    SharedPre sharedPref = SharedPre();
    if (userID != null) {
      await sharedPref.save("userid", userID);
      await sharedPref.save("username", userName);
      await sharedPref.save("fullname", fullName);
      await sharedPref.save("email", email);
      await sharedPref.save("mobilenumber", mobileNumber);
      await sharedPref.save("userimage", image);
      await sharedPref.save("devicetype", deviceType);
      await sharedPref.save("divicetoken", deviceToken);
      await sharedPref.save("userIsBuy", userIsBuy);
      await sharedPref.save("type", type);
    } else {
      await sharedPref.remove("userid");
      await sharedPref.remove("username");
      await sharedPref.remove("fullname");
      await sharedPref.remove("email");
      await sharedPref.remove("mobilenumber");
      await sharedPref.remove("userimage");
      await sharedPref.remove("devicetype");
      await sharedPref.remove("devicetoken");
      await sharedPref.remove("userIsBuy");
      await sharedPref.remove("type");
    }

    Constant.userID = await sharedPref.read("userid");
    Constant.userImage = await sharedPref.read("userimage");
    Constant.isBuy = await sharedPref.read("userIsBuy");

    printLog('setUserId userID ==> ${Constant.userID}');
    printLog('setUserId userID ==> ${Constant.userImage}');
    printLog('setUserId userID ==> ${Constant.isBuy}');
  }

  static void setUserId() async {
    SharedPre sharedPref = SharedPre();

    await sharedPref.remove("userid");
    await sharedPref.remove("username");
    await sharedPref.remove("fullname");
    await sharedPref.remove("email");
    await sharedPref.remove("mobilenumber");
    await sharedPref.remove("userimage");
    await sharedPref.remove("devicetype");
    await sharedPref.remove("devicetoken");
    await sharedPref.remove("userIsBuy");
    await sharedPref.remove("firebaseid");
    await sharedPref.remove("type");
  }

  static void openPlayer(
      {required BuildContext context,
      required int videoId,
      required String videoUrl,
      required String vUploadType,
      required String videoThumb,
      required int courseId,
      required String type,
      required int chepterId,
      required String secreateKey,
      required int viewApiType}) {
    if (kIsWeb) {
      /* Normal, Vimeo & Youtube Player */
      if (!context.mounted) return;
      if (vUploadType == "youtube") {
        Navigator.of(context).push(
          PageRouteBuilder(
            pageBuilder: (context, animation, secondaryAnimation) {
              return PlayerYoutube(
                videoId,
                videoUrl,
                vUploadType,
                videoThumb,
                courseId,
                chepterId,
                viewApiType,
              );
            },
            transitionsBuilder:
                (context, animation, secondaryAnimation, child) {
              return child;
            },
          ),
        );
      } else if (vUploadType == "external") {
        if (videoUrl.contains('youtube')) {
          Navigator.of(context).push(
            PageRouteBuilder(
              pageBuilder: (context, animation, secondaryAnimation) {
                return PlayerYoutube(
                  videoId,
                  videoUrl,
                  vUploadType,
                  videoThumb,
                  courseId,
                  chepterId,
                  viewApiType,
                );
              },
              transitionsBuilder:
                  (context, animation, secondaryAnimation, child) {
                return child;
              },
            ),
          );
        } else {
          Navigator.of(context).push(
            PageRouteBuilder(
              pageBuilder: (context, animation, secondaryAnimation) {
                return PlayerVideo(
                  videoId,
                  videoUrl,
                  vUploadType,
                  chepterId,
                  videoThumb,
                  courseId,
                  type,
                  secreateKey,
                  viewApiType,
                );
              },
              transitionsBuilder:
                  (context, animation, secondaryAnimation, child) {
                return child;
              },
            ),
          );
        }
      } else {
        Navigator.of(context).push(
          PageRouteBuilder(
            pageBuilder: (context, animation, secondaryAnimation) {
              return PlayerVideo(
                videoId,
                videoUrl,
                vUploadType,
                chepterId,
                videoThumb,
                courseId,
                type,
                secreateKey,
                viewApiType,
              );
            },
            transitionsBuilder:
                (context, animation, secondaryAnimation, child) {
              return child;
            },
          ),
        );
      }
    } else {
      /* Better, Youtube & Vimeo Players */
      if (vUploadType == "youtube") {
        Navigator.of(context).push(
          PageRouteBuilder(
            pageBuilder: (context, animation, secondaryAnimation) {
              return PlayerYoutube(
                videoId,
                videoUrl,
                vUploadType,
                videoThumb,
                courseId,
                chepterId,
                viewApiType,
              );
            },
            transitionsBuilder:
                (context, animation, secondaryAnimation, child) {
              return child;
            },
          ),
        );
      } else if (vUploadType == "vimeo") {
        Navigator.of(context).push(
          PageRouteBuilder(
            pageBuilder: (context, animation, secondaryAnimation) {
              return PlayerVimeo(videoId, videoUrl, vUploadType, chepterId,
                  videoThumb, courseId);
            },
            transitionsBuilder:
                (context, animation, secondaryAnimation, child) {
              return child;
            },
          ),
        );
      } else if (vUploadType == "external") {
        if (videoUrl.contains('youtube')) {
          Navigator.push(
            context,
            MaterialPageRoute(
              builder: (context) {
                return PlayerYoutube(
                  videoId,
                  videoUrl,
                  vUploadType,
                  videoThumb,
                  courseId,
                  chepterId,
                  viewApiType,
                );
              },
            ),
          );
        } else {
          Navigator.of(context).push(
            PageRouteBuilder(
              pageBuilder: (context, animation, secondaryAnimation) {
                return PlayerVideo(
                  videoId,
                  videoUrl,
                  vUploadType,
                  chepterId,
                  videoThumb,
                  courseId,
                  type,
                  secreateKey,
                  viewApiType,
                );
              },
              transitionsBuilder:
                  (context, animation, secondaryAnimation, child) {
                return child;
              },
            ),
          );
        }
      } else {
        Navigator.of(context).push(
          PageRouteBuilder(
            pageBuilder: (context, animation, secondaryAnimation) {
              return PlayerVideo(
                videoId,
                videoUrl,
                vUploadType,
                chepterId,
                videoThumb,
                courseId,
                type,
                secreateKey,
                viewApiType,
              );
            },
            transitionsBuilder:
                (context, animation, secondaryAnimation, child) {
              return child;
            },
          ),
        );
      }
    }
  }

  static Widget buildBackBtnDesign(BuildContext context) {
    return Icon(
      Icons.arrow_back_ios_new_outlined,
      size: 20,
      color: black,
    );
  }

  static Future<void> shareApp(String shareMessage) async {
    try {
      SharePlus.instance
          .share(ShareParams(text: shareMessage, subject: Constant.appName));
    } catch (e) {
      printLog("shareApp Exception ===> $e");
      return;
    }
  }

  /* Google AdMob Methods Start */
  static Widget showBannerAd(BuildContext context) {
    if (!kIsWeb) {
      return Container(
        constraints: BoxConstraints(
          minHeight: 0,
          minWidth: 0,
          maxWidth: MediaQuery.of(context).size.width,
        ),
        child: AdHelper.bannerAd(context),
      );
    } else {
      return const SizedBox.shrink();
    }
  }

  static Future<void> loadAds(BuildContext context) async {
    bool? isPremiumBuy = await Utils.checkPremiumUser();
    debugPrint("loadAds isPremiumBuy :==> $isPremiumBuy");
    if (context.mounted) {
      AdHelper.getAds(context);
    }
    if (!kIsWeb && !isPremiumBuy) {
      AdHelper.createInterstitialAd();
      AdHelper.createRewardedAd();
    }
  }
/* Google AdMob Methods End */

  static Future<bool> checkPremiumUser() async {
    SharedPre sharedPre = SharedPre();
    String? isPremiumBuy = await sharedPre.read("userIsBuy");
    Constant.isBuy = await sharedPre.read("userIsBuy");
    printLog('checkPremiumUser isPremiumBuy ==> $isPremiumBuy');
    if (isPremiumBuy != null && isPremiumBuy == "1") {
      return true;
    } else {
      return false;
    }
  }

  static void updatePremium(String isPremiumBuy) async {
    printLog('updatePremium isPremiumBuy ==> $isPremiumBuy');
    SharedPre sharedPre = SharedPre();
    await sharedPre.save("userIsBuy", isPremiumBuy);
    String? isPremium = await sharedPre.read("userIsBuy");
    Constant.isBuy = await sharedPre.read("userIsBuy");
    printLog('updatePremium ===============> $isPremium');
  }

  static bool checkLoginUser(BuildContext context) {
    if (Constant.userID != null) {
      return true;
    }
    if (kIsWeb) {
      navigatePage(context, const WebLogin(), "2");
    } else {
      navigatePage(context, const Login(), "2");
    }

    return false;
  }

  static dynamic lanchUrl(String url) async {
    // ignore: deprecated_member_use
    if (await canLaunch(url)) {
      // ignore: deprecated_member_use
      await launch(url);
    } else {
      throw Utils().showToast("Could Not Lunch This Url $url");
    }
  }

  static Color generateRendomColor() {
    final Random random = Random();
    final int red = random.nextInt(256);
    final int green = random.nextInt(256);
    final int blue = random.nextInt(256);
    final Color color = Color.fromARGB(255, red, green, blue);
    return color;
  }

/* Logout Dilog Both (App) And (Web) */

  /* ***************** Download ***************** */
  static Future<String> prepareSaveDir() async {
    String localPath = (await _getSavedDir())!;
    printLog("localPath ------------> $localPath");
    final savedDir = Directory(localPath);
    printLog("savedDir -------------> $savedDir");
    printLog("is exists ? ----------> ${savedDir.existsSync()}");
    if (!(await savedDir.exists())) {
      await savedDir.create(recursive: true);
    }
    return localPath;
  }

  static Future<String?> _getSavedDir() async {
    String? externalStorageDirPath;

    if (Platform.isAndroid) {
      final directory = await getExternalStorageDirectory();
      try {
        externalStorageDirPath = "${directory?.absolute.path}/downloads/";
      } catch (err, st) {
        printLog('failed to get downloads path: $err, $st');
        externalStorageDirPath = "${directory?.absolute.path}/downloads/";
      }
    } else if (Platform.isIOS) {
      externalStorageDirPath =
          (await getApplicationDocumentsDirectory()).absolute.path;
    }
    printLog("externalStorageDirPath ------------> $externalStorageDirPath");
    return externalStorageDirPath;
  }

  static Future<String> prepareShowSaveDir(
      String showName, String seasonName) async {
    printLog("showName -------------> $showName");
    printLog("seasonName -------------> $seasonName");
    String localPath = (await _getShowSavedDir(showName, seasonName))!;
    final savedDir = Directory(localPath);
    printLog("savedDir -------------> $savedDir");
    printLog("savedDir path --------> ${savedDir.path}");
    if (!savedDir.existsSync()) {
      await savedDir.create(recursive: true);
    }
    return localPath;
  }

  static Future<String?> _getShowSavedDir(
      String showName, String seasonName) async {
    String? externalStorageDirPath;

    if (Platform.isAndroid) {
      try {
        final directory = await getExternalStorageDirectory();
        externalStorageDirPath =
            "${directory?.path}/downloads/${showName.toLowerCase()}/${seasonName.toLowerCase()}";
      } catch (err, st) {
        printLog('failed to get downloads path: $err, $st');
        final directory = await getExternalStorageDirectory();
        externalStorageDirPath =
            "${directory?.path}/downloads/${showName.toLowerCase()}/${seasonName.toLowerCase()}";
      }
    } else if (Platform.isIOS) {
      externalStorageDirPath =
          "${(await getApplicationDocumentsDirectory()).absolute.path}/downloads/${showName.toLowerCase()}/${seasonName.toLowerCase()}";
    }
    return externalStorageDirPath;
  }

  static Future<void> encryptFile(
      File inFile, File outFile, String generateKey) async {
    bool outFileExists = await outFile.exists();

    if (!outFileExists) {
      await outFile.create();
    }

    final videoFileContents = inFile.readAsStringSync(encoding: latin1);

    final key = excrypt.Key.fromUtf8(generateKey);
    final iv = excrypt.IV.fromLength(16);

    final encrypter =
        excrypt.Encrypter(excrypt.AES(key, mode: excrypt.AESMode.ecb));

    final encrypted = encrypter.encrypt(videoFileContents, iv: iv);
    await outFile.writeAsBytes(encrypted.bytes);
  }

  static String generateRandomKey(int len) {
    final random = Random.secure();
    const chars =
        'AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz1234567890';
    return List.generate(len, (index) => chars[random.nextInt(chars.length)])
        .join();
  }

  /* ***************** Download ***************** */

/*----------------------------------------------------------------- Web Utils --------------------------------------------------------------------------------------- */

  static PreferredSize webMainAppbar({TextEditingController? controller}) {
    return PreferredSize(
        preferredSize: const Size.fromHeight(70.0),
        child: AppBar(
            automaticallyImplyLeading: false,
            backgroundColor: colorPrimaryDark,
            centerTitle: true,
            elevation: 0,
            titleSpacing: 0,
            flexibleSpace: WebAppbar(controller: controller)));
  }

  static Widget hoverItemWithPage({required Widget myWidget, isProfile}) {
    return Consumer<GeneralProvider>(
        builder: (context, generalprovider, child) {
      return Stack(
        alignment: Alignment.topCenter,
        children: [
          MouseRegion(
            onHover: (value) {
              generalprovider.getNotificationSectionShowHide(false);
              // await generalprovider.getOpenSearchSection(false);
              // await generalprovider.getOpenProfileSection(false);
            },
            child: Align(
              alignment: Alignment.topCenter,
              child: myWidget,
            ),
          ),
          /* Notification Panel Show Home Page */
          generalprovider.isNotification == true
              ? Align(
                  alignment: Alignment.topRight,
                  child: Container(
                    width: MediaQuery.of(context).size.width > 1200 ? 500 : 400,
                    height: 600,
                    margin: const EdgeInsets.only(left: 20, right: 50),
                    decoration: BoxDecoration(
                      // border: Border.all(width: 0.9, color: colorPrimary),
                      borderRadius: BorderRadius.circular(0),
                      color: Theme.of(context).cardColor,
                    ),
                    child: const WebNotificationPage(),
                  ),
                )
              : const SizedBox.shrink(),
        ],
      );
    });
  }

  static Widget childPanel(BuildContext context) {
    return Consumer<ThemeProvider>(builder: (context, themeprovider, child) {
      return Container(
        width: MediaQuery.of(context).size.width,
        height: 50,
        color: comman,
        padding: MediaQuery.of(context).size.width > 800
            ? const EdgeInsets.fromLTRB(100, 0, 100, 0)
            : const EdgeInsets.fromLTRB(20, 0, 20, 0),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.end,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            InkWell(
              onTap: () {
                languageChangeDialogWeb(context);
              },
              child: Padding(
                padding: const EdgeInsets.fromLTRB(15, 0, 15, 0),
                child: MyText(
                    color: white,
                    text: "language",
                    fontsizeNormal: Dimens.textMedium,
                    maxline: 1,
                    fontwaight: FontWeight.w400,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.center,
                    fontstyle: FontStyle.normal,
                    multilanguage: true),
              ),
            ),
            MyText(
                color: white,
                text: "darkmode",
                fontsizeNormal: Dimens.textMedium,
                maxline: 1,
                fontwaight: FontWeight.w400,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal,
                multilanguage: true),
            Align(
              alignment: Alignment.centerRight,
              child: Container(
                width: 50,
                alignment: Alignment.center,
                margin: const EdgeInsets.fromLTRB(8, 10, 8, 10),
                decoration: BoxDecoration(
                  color: white,
                  borderRadius: BorderRadius.circular(50),
                ),
                child: Switch(
                  activeTrackColor: white,
                  inactiveTrackColor: white,
                  inactiveThumbColor: gray,
                  value: Constant.isDark,
                  onChanged: (value) async {
                    SharedPre sharedpre = SharedPre();
                    themeprovider.changeTheme(value);
                    await sharedpre.remove("isdark");
                    await sharedpre.saveBool("isdark", value);
                    printLog(
                        "ISDARK==> ${sharedpre.readBool("isdark").toString()}");
                  },
                ),
              ),
            ),
          ],
        ),
      );
    });
  }

/* Web Dark mode and ligth mode code */

  static Widget webDark() {
    return Consumer<ThemeProvider>(builder: (context, themeProvider, child) {
      return InkWell(
        onTap: () {
          themeProvider.toggleTheme();
        },
        child: Icon(
          themeProvider.isDarkMode1 ? Icons.dark_mode : Icons.light_mode,
          size: 20,
        ),
      );
    });
  }

  static Widget webProfilePages(BuildContext context, name, onTap) {
    return InkWell(
      onTap: onTap,
      child: Container(
        width: MediaQuery.of(context).size.width,
        padding: const EdgeInsets.fromLTRB(15, 15, 15, 15),
        child: MyText(
            color: Theme.of(context).colorScheme.surface,
            multilanguage: true,
            text: name,
            textalign: TextAlign.left,
            fontsizeNormal: Dimens.textMedium,
            fontsizeWeb: Dimens.textMedium,
            maxline: 1,
            fontwaight: FontWeight.w500,
            overflow: TextOverflow.ellipsis,
            fontstyle: FontStyle.normal),
      ),
    );
  }

  static int customCrossAxisCount(
      {required BuildContext context,
      required int height1600,
      required int height1200,
      required int height800,
      required int height400}) {
    if (MediaQuery.of(context).size.width > 1600) {
      return height1600;
    } else if (MediaQuery.of(context).size.width > 1200) {
      return height1200;
    } else if (MediaQuery.of(context).size.width > 800) {
      return height800;
    } else if (MediaQuery.of(context).size.width > 400) {
      return height400;
    } else {
      return height400;
    }
  }

  static Container pageTitleLayout(
      BuildContext context, title, isMultilanguage) {
    return Container(
      width: MediaQuery.of(context).size.width,
      padding: MediaQuery.of(context).size.width > 800
          ? const EdgeInsets.fromLTRB(100, 30, 100, 30)
          : const EdgeInsets.fromLTRB(20, 20, 20, 20),
      decoration: BoxDecoration(
        gradient: LinearGradient(
          colors: [
            colorPrimary,
            colorPrimary.withValues(alpha: 0.35),
          ],
          begin: Alignment.centerLeft,
          end: Alignment.centerRight,
        ),
      ),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Expanded(
            child: MyText(
                color: white,
                text: title,
                fontsizeNormal: Dimens.textExtralargeBig,
                fontsizeWeb: Dimens.textExtralargeBig,
                fontwaight: FontWeight.w500,
                maxline: 3,
                multilanguage: isMultilanguage,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
          ),
          MyImage(
            width: Dimens.learningPosterWidth,
            height: Dimens.learningPosterHeight,
            imagePath: "ic_courseposter.png",
            fit: BoxFit.contain,
          ),
        ],
      ),
    );
  }

  static void languageChangeDialogMobile(BuildContext context) {
    showModalBottomSheet(
      context: context,
      useSafeArea: true,
      isDismissible: true,
      showDragHandle: true,
      isScrollControlled: true,
      backgroundColor: transparent,
      builder: (BuildContext context) {
        return StatefulBuilder(
          builder: (BuildContext context, state) {
            return Container(
              width: MediaQuery.of(context).size.width,
              padding: const EdgeInsets.all(23),
              decoration: BoxDecoration(
                  color: white,
                  borderRadius:
                      BorderRadius.vertical(top: Radius.circular(20))),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                mainAxisSize: MainAxisSize.min,
                children: [
                  Container(
                    alignment: Alignment.centerLeft,
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        MyText(
                          color: Theme.of(context).colorScheme.surface,
                          text: "language",
                          multilanguage: true,
                          textalign: TextAlign.center,
                          fontsizeNormal: Dimens.textTitle,
                          fontwaight: FontWeight.bold,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          fontstyle: FontStyle.normal,
                        ),
                        const SizedBox(height: 3),
                        MyText(
                          color: gray,
                          text: "selectyourlanguage",
                          multilanguage: true,
                          textalign: TextAlign.center,
                          fontsizeNormal: Dimens.textBigSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          fontstyle: FontStyle.normal,
                        )
                      ],
                    ),
                  ),
                  const SizedBox(height: 20),
                  /* English */
                  InkWell(
                    borderRadius: BorderRadius.circular(5),
                    onTap: () {
                      state(() {});
                      LocaleNotifier.of(context)?.change('en');
                      Navigator.pop(context);
                    },
                    child: Container(
                      constraints: BoxConstraints(
                        minWidth: MediaQuery.of(context).size.width,
                      ),
                      height: 48,
                      padding: const EdgeInsets.only(left: 10, right: 10),
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        border: Border.all(
                          color: colorPrimary,
                          width: .5,
                        ),
                        borderRadius: BorderRadius.circular(5),
                      ),
                      child: MyText(
                        color: Theme.of(context).colorScheme.surface,
                        text: "English",
                        textalign: TextAlign.center,
                        fontsizeNormal: Dimens.textTitle,
                        multilanguage: false,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontwaight: FontWeight.w500,
                        fontstyle: FontStyle.normal,
                      ),
                    ),
                  ),
                  const SizedBox(height: 20),

                  /* Arabic */
                  InkWell(
                    borderRadius: BorderRadius.circular(5),
                    onTap: () {
                      state(() {});
                      LocaleNotifier.of(context)?.change('ar');
                      Navigator.pop(context);
                    },
                    child: Container(
                      constraints: BoxConstraints(
                        minWidth: MediaQuery.of(context).size.width,
                      ),
                      height: 48,
                      padding: const EdgeInsets.only(left: 10, right: 10),
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        border: Border.all(
                          color: colorPrimary,
                          width: .5,
                        ),
                        borderRadius: BorderRadius.circular(5),
                      ),
                      child: MyText(
                        color: Theme.of(context).colorScheme.surface,
                        text: "Arabic",
                        textalign: TextAlign.center,
                        fontsizeNormal: Dimens.textTitle,
                        multilanguage: false,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontwaight: FontWeight.w500,
                        fontstyle: FontStyle.normal,
                      ),
                    ),
                  ),
                  const SizedBox(height: 20),

                  /* Hindi */
                  InkWell(
                    borderRadius: BorderRadius.circular(5),
                    onTap: () {
                      state(() {});
                      LocaleNotifier.of(context)?.change('hi');
                      Navigator.pop(context);
                    },
                    child: Container(
                      constraints: BoxConstraints(
                        minWidth: MediaQuery.of(context).size.width,
                      ),
                      height: 48,
                      padding: const EdgeInsets.only(left: 10, right: 10),
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        border: Border.all(
                          color: colorPrimary,
                          width: .5,
                        ),
                        borderRadius: BorderRadius.circular(5),
                      ),
                      child: MyText(
                        color: Theme.of(context).colorScheme.surface,
                        text: "Hindi",
                        textalign: TextAlign.center,
                        fontsizeNormal: Dimens.textTitle,
                        multilanguage: false,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontwaight: FontWeight.w500,
                        fontstyle: FontStyle.normal,
                      ),
                    ),
                  ),
                  const SizedBox(height: 50),
                ],
              ),
            );
          },
        );
      },
    );
  }

  static Future languageChangeDialogWeb(BuildContext context) {
    return showDialog(
      context: context,
      barrierColor: transparent,
      builder: (context) {
        return Dialog(
          shape:
              RoundedRectangleBorder(borderRadius: BorderRadius.circular(15)),
          clipBehavior: Clip.antiAliasWithSaveLayer,
          backgroundColor: white,
          child: Container(
            width: MediaQuery.of(context).size.width,
            color: white,
            padding: const EdgeInsets.all(20.0),
            constraints: const BoxConstraints(
              minWidth: 400,
              maxWidth: 500,
              minHeight: 450,
              maxHeight: 500,
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: "changelanguage",
                      multilanguage: true,
                      textalign: TextAlign.start,
                      fontsizeNormal: Dimens.textBig,
                      fontsizeWeb: Dimens.textBig,
                      fontwaight: FontWeight.bold,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      fontstyle: FontStyle.normal,
                    ),
                    InkWell(
                      onTap: () {
                        Navigator.pop(context);
                      },
                      child: Icon(
                        Icons.close,
                        size: 25,
                        color: Theme.of(context).colorScheme.surface,
                      ),
                    ),
                  ],
                ),
                const SizedBox(height: 15),
                /* English */
                Expanded(
                  child: SingleChildScrollView(
                    physics: const AlwaysScrollableScrollPhysics(),
                    child: Column(
                      children: [
                        const SizedBox(height: 20),
                        _buildLanguage(
                          context: context,
                          langName: "English",
                          onClick: () {
                            LocaleNotifier.of(context)?.change('en');
                            Navigator.pop(context);
                          },
                        ),

                        /* Arabic */
                        const SizedBox(height: 20),
                        _buildLanguage(
                          context: context,
                          langName: "Arabic",
                          onClick: () {
                            LocaleNotifier.of(context)?.change('ar');
                            Navigator.pop(context);
                          },
                        ),

                        /* Hindi */
                        const SizedBox(height: 20),
                        _buildLanguage(
                          context: context,
                          langName: "Hindi",
                          onClick: () {
                            LocaleNotifier.of(context)?.change('hi');
                            Navigator.pop(context);
                          },
                        ),
                        const SizedBox(height: 20),
                      ],
                    ),
                  ),
                ),
              ],
            ),
          ),
        );
      },
    );
  }

  static Widget _buildLanguage({
    required BuildContext context,
    required String langName,
    required Function() onClick,
  }) {
    return InkWell(
      onTap: onClick,
      borderRadius: BorderRadius.circular(5),
      child: Container(
        constraints: BoxConstraints(
          minWidth: MediaQuery.of(context).size.width,
        ),
        height: 48,
        padding: const EdgeInsets.only(left: 10, right: 10),
        alignment: Alignment.center,
        decoration: BoxDecoration(
          border: Border.all(
            color: Theme.of(context).colorScheme.surface,
            width: .5,
          ),
          // color: colorPrimary,
          borderRadius: BorderRadius.circular(5),
        ),
        child: MyText(
          color: Theme.of(context).colorScheme.surface,
          text: langName,
          textalign: TextAlign.center,
          fontsizeNormal: Dimens.textTitle,
          fontsizeWeb: Dimens.textTitle,
          multilanguage: false,
          maxline: 1,
          overflow: TextOverflow.ellipsis,
          fontwaight: FontWeight.w500,
          fontstyle: FontStyle.normal,
        ),
      ),
    );
  }

  static Widget searchCourse(BuildContext context) {
    return Consumer<SearchProvider>(
      builder: (context, searchprovider, child) {
        if (searchprovider.loading) {
          return buildShimmer(context);
        } else {
          return Padding(
            padding: const EdgeInsets.all(15.0),
            child: MediaQuery.removePadding(
              context: context,
              removeTop: true,
              child: ResponsiveGridList(
                minItemWidth: 120,
                minItemsPerRow: 1,
                maxItemsPerRow: 1,
                horizontalGridSpacing: 5,
                verticalGridSpacing: 10,
                listViewBuilderOptions: ListViewBuilderOptions(
                  scrollDirection: Axis.vertical,
                  shrinkWrap: true,
                  physics: const BouncingScrollPhysics(),
                ),
                children: List.generate(
                  searchprovider.searchModel.result?.length ?? 0,
                  (index) {
                    return InkWell(
                      hoverColor: transparent,
                      highlightColor: transparent,
                      onTap: () async {
                        Navigator.of(context).push(
                          PageRouteBuilder(
                            transitionDuration:
                                const Duration(milliseconds: 200),
                            pageBuilder: (BuildContext context,
                                Animation<double> animation,
                                Animation<double> secondaryAnimation) {
                              return WebDetail(
                                  courseId: searchprovider
                                          .searchModel.result?[index].id
                                          .toString() ??
                                      "");
                            },
                            transitionsBuilder: (BuildContext context,
                                Animation<double> animation,
                                Animation<double> secondaryAnimation,
                                Widget child) {
                              return Align(
                                child: FadeTransition(
                                  opacity: animation,
                                  child: child,
                                ),
                              );
                            },
                          ),
                        );
                        final generalProvider = Provider.of<GeneralProvider>(
                            context,
                            listen: false);
                        generalProvider.getOpenSearchSection(false);
                      },
                      child: Column(
                        children: [
                          Padding(
                            padding: const EdgeInsets.only(top: 10),
                            child: Row(
                              children: [
                                ClipRRect(
                                  borderRadius: const BorderRadius.only(
                                      bottomLeft: Radius.circular(5),
                                      topLeft: Radius.circular(5)),
                                  child: MyNetworkImage(
                                    imgWidth: 115,
                                    imgHeight: 100,
                                    imageUrl: searchprovider.searchModel
                                            .result?[index].thumbnailImg
                                            .toString() ??
                                        "",
                                    fit: BoxFit.fill,
                                  ),
                                ),
                                const SizedBox(width: 10),
                                Expanded(
                                  child: Column(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceEvenly,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      MyText(
                                          color: Theme.of(context)
                                              .colorScheme
                                              .surface,
                                          text: searchprovider.searchModel
                                                  .result?[index].title
                                                  .toString() ??
                                              "",
                                          fontsizeNormal: Dimens.textMedium,
                                          fontsizeWeb: Dimens.textMedium,
                                          fontwaight: FontWeight.w600,
                                          maxline: 2,
                                          overflow: TextOverflow.ellipsis,
                                          textalign: TextAlign.left,
                                          fontstyle: FontStyle.normal),
                                      const SizedBox(height: 8),
                                      Row(
                                        mainAxisAlignment:
                                            MainAxisAlignment.start,
                                        crossAxisAlignment:
                                            CrossAxisAlignment.center,
                                        children: [
                                          MyText(
                                              color: gray,
                                              text: Utils.kmbGenerator(
                                                  int.parse(searchprovider
                                                          .searchModel
                                                          .result?[index]
                                                          .totalView
                                                          .toString() ??
                                                      "")),
                                              fontsizeNormal: Dimens.textSmall,
                                              fontsizeWeb: Dimens.textSmall,
                                              fontwaight: FontWeight.w500,
                                              maxline: 1,
                                              overflow: TextOverflow.ellipsis,
                                              textalign: TextAlign.left,
                                              fontstyle: FontStyle.normal),
                                          const SizedBox(width: 5),
                                          MyText(
                                              color: gray,
                                              text: "students",
                                              fontsizeNormal: Dimens.textSmall,
                                              fontsizeWeb: Dimens.textSmall,
                                              fontwaight: FontWeight.w500,
                                              maxline: 1,
                                              multilanguage: true,
                                              overflow: TextOverflow.ellipsis,
                                              textalign: TextAlign.left,
                                              fontstyle: FontStyle.normal),
                                        ],
                                      ),
                                      const SizedBox(height: 8),
                                      Row(
                                        mainAxisAlignment:
                                            MainAxisAlignment.start,
                                        children: [
                                          MyRating(
                                            size: 13,
                                            rating: double.parse(searchprovider
                                                    .searchModel
                                                    .result?[index]
                                                    .avgRating
                                                    .toString() ??
                                                ""),
                                            spacing: 2,
                                          ),
                                          const SizedBox(width: 5),
                                          MyText(
                                              color: colorAccent,
                                              text:
                                                  "${double.parse(searchprovider.searchModel.result?[index].avgRating.toString() ?? "")}",
                                              fontsizeNormal:
                                                  Dimens.textBigSmall,
                                              fontsizeWeb: Dimens.textBigSmall,
                                              fontwaight: FontWeight.w600,
                                              maxline: 2,
                                              overflow: TextOverflow.ellipsis,
                                              textalign: TextAlign.left,
                                              fontstyle: FontStyle.normal),
                                        ],
                                      ),
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ),
                          const SizedBox(height: 20),
                          searchprovider.searchModel.result?.length == index + 1
                              ? const SizedBox.shrink()
                              : Container(
                                  width: MediaQuery.of(context).size.width,
                                  height: 0.9,
                                  color: gray.withValues(alpha: 0.15),
                                ),
                        ],
                      ),
                    );
                  },
                ),
              ),
            ),
          );
        }
      },
    );
  }

  static Widget buildShimmer(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.all(15.0),
      child: MediaQuery.removePadding(
        context: context,
        removeTop: true,
        child: ResponsiveGridList(
          minItemWidth: 120,
          minItemsPerRow: 1,
          maxItemsPerRow: 1,
          horizontalGridSpacing: 5,
          verticalGridSpacing: 10,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
          ),
          children: List.generate(
            10,
            (index) {
              return Column(
                children: [
                  const Padding(
                    padding: EdgeInsets.only(top: 10),
                    child: Row(
                      children: [
                        ClipRRect(
                          borderRadius: BorderRadius.only(
                              bottomLeft: Radius.circular(5),
                              topLeft: Radius.circular(5)),
                          child: CustomWidget.rectangular(
                            width: 115,
                            height: 90,
                          ),
                        ),
                        SizedBox(width: 10),
                        Expanded(
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              CustomWidget.rectangular(
                                height: 5,
                              ),
                              SizedBox(height: 8),
                              CustomWidget.rectangular(
                                height: 5,
                              ),
                              SizedBox(height: 8),
                              CustomWidget.rectangular(
                                height: 5,
                              ),
                            ],
                          ),
                        ),
                      ],
                    ),
                  ),
                  Container(
                    width: MediaQuery.of(context).size.width,
                    height: 0.9,
                    color: gray.withValues(alpha: 0.15),
                  ),
                ],
              );
            },
          ),
        ),
      ),
    );
  }

/* Web details app bar */
  static Widget buildWebDetailsAppBar(
      {required BuildContext context,
      required String? title,
      bool? multilanguage}) {
    return Container(
      height: 75,
      width: MediaQuery.sizeOf(context).width,
      color: gray.withValues(alpha: 0.3),
      padding: MediaQuery.of(context).size.width > 1000
          ? const EdgeInsets.fromLTRB(200, 0, 200, 0)
          : const EdgeInsets.fromLTRB(20, 0, 20, 0),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        spacing: 14,
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            highlightColor: transparent,
            onTap: () {
              if (Navigator.canPop(context)) {
                Navigator.pop(context);
              }
            },
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              spacing: 14,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Icon(
                  Icons.home,
                  size: 25,
                  color: black.withValues(alpha: 0.4),
                ),
                MyText(
                  text: "home",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textMedium,
                  fontsizeWeb: Dimens.textTitle,
                  fontwaight: FontWeight.w600,
                  color: black,
                ),
              ],
            ),
          ),
          InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: () {},
            child: Row(
              children: [
                Icon(
                  Icons.keyboard_arrow_right_rounded,
                  size: 25,
                  color: black.withValues(alpha: 0.4),
                ),
                MyText(
                    text: title ?? "",
                    multilanguage: multilanguage ?? true,
                    fontsizeNormal: Dimens.textMedium,
                    fontsizeWeb: Dimens.textTitle,
                    fontwaight: FontWeight.w600,
                    color: colorPrimaryDark),
              ],
            ),
          ),
        ],
      ),
    );
  }

  /* ======================= Web Device Token Start ============ */

/* Generate Web Device Token Start */

  Future<void> getDeviceTokenWithPermissionWeb() async {
    NotificationSettings settings =
        await FirebaseMessaging.instance.requestPermission(
      alert: true,
      announcement: false,
      badge: true,
      carPlay: false,
      criticalAlert: false,
      provisional: false,
      sound: true,
    );

    if (settings.authorizationStatus == AuthorizationStatus.authorized) {
      printLog('User granted permission');
      await getToken();
    } else if (settings.authorizationStatus ==
        AuthorizationStatus.provisional) {
      printLog('User granted provisional permission');
    } else {
      printLog('User declined or has not accepted permission');
    }
  }

  Future<void> getToken() async {
    SharedPre sharedPre = SharedPre();
    Constant.vapId = await sharedPre.read(Constant.vapIdKey) ?? "";
    String? token =
        await FirebaseMessaging.instance.getToken(vapidKey: Constant.vapId);

    Constant.webToken = token;
    printLog("FirebaseMessaging token: ${Constant.webToken}");
  }

/* ======================= Web Device Token End ============ */
/* Navigation  */

  /* 1= pushReplacement.
2 = push,
3 = pushAndRemoveUntil */

  static void navigatePage(
    BuildContext context,
    Widget routePage,
    isPushReplacement,
  ) {
    if (isPushReplacement == "1") {
      Navigator.of(context).pushReplacement(
        PageRouteBuilder(
          pageBuilder: (BuildContext context, Animation<double> animation,
              Animation<double> secondaryAnimation) {
            return routePage;
          },
          transitionDuration: const Duration(milliseconds: 200),
          transitionsBuilder: (BuildContext context,
              Animation<double> animation,
              Animation<double> secondaryAnimation,
              Widget child) {
            return Align(
              child: FadeTransition(
                opacity: animation,
                child: child,
              ),
            );
          },
        ),
      );
    } else if (isPushReplacement == "2") {
      Navigator.of(context).push(
        PageRouteBuilder(
          pageBuilder: (context, animation, secondaryAnimation) {
            return routePage;
          },
          transitionDuration: const Duration(milliseconds: 200),
          transitionsBuilder: (BuildContext context,
              Animation<double> animation,
              Animation<double> secondaryAnimation,
              Widget child) {
            return Align(
              child: FadeTransition(
                opacity: animation,
                child: child,
              ),
            );
          },
        ),
      );
    } else {
      WidgetsBinding.instance.addPostFrameCallback((_) {
        Navigator.of(context).pushAndRemoveUntil(
          PageRouteBuilder(
            pageBuilder: (context, animation, secondaryAnimation) {
              return routePage;
            },
            transitionDuration: const Duration(milliseconds: 200),
            transitionsBuilder: (BuildContext context,
                Animation<double> animation,
                Animation<double> secondaryAnimation,
                Widget child) {
              return Align(
                child: FadeTransition(
                  opacity: animation,
                  child: child,
                ),
              );
            },
          ),
          (route) => false,
        );
      });
    }
  }
}

/* ================ Download =================== */

Future<void> encryptFile(List<dynamic> args) async {
  File inFile = args[0] as File;
  File outFile = args[0] as File;
  String generateKey = args[1] as String;
  final sendPort = args[2] as SendPort;
  final rootToken = args[3] as RootIsolateToken;
  BackgroundIsolateBinaryMessenger.ensureInitialized(rootToken);

  bool outFileExists = await outFile.exists();

  if (!outFileExists) {
    await outFile.create();
  }

  final videoFileContents = inFile.readAsStringSync(encoding: latin1);

  final key = excrypt.Key.fromUtf8(generateKey);
  final iv = excrypt.IV.fromLength(16);

  final encrypter =
      excrypt.Encrypter(excrypt.AES(key, mode: excrypt.AESMode.ecb));

  final encrypted = encrypter.encrypt(videoFileContents, iv: iv);
  await outFile.writeAsBytes(encrypted.bytes);
  sendPort.send(outFile);
}

Future<dynamic> decryptFile(List<dynamic> args) async {
  File inFile = args[0] as File;
  String generateKey = args[1] as String;
  var generateIVKey = args[2];

  printLog("decryptUsingFFMPEG generateKey =====> $generateKey");
  printLog("decryptUsingFFMPEG generateIVKey ===> $generateIVKey");
  // await deleteCacheDir();

  // Create a temporary decrypted file
  final tempDir = await getTemporaryDirectory();
  File decryptedFile = File('${tempDir.path}/${path.basename(inFile.path)}');
  printLog('decryptUsingFFMPEG inFile ==========> $inFile');
  printLog('decryptUsingFFMPEG decryptedFile ===> $decryptedFile');

  final Completer<File?> completer = Completer<File?>();
  try {
    // Check if the encrypted file exists
    bool isInFileExists = await inFile.exists();
    if (!isInFileExists) {
      printLog("decryptUsingFFMPEG Encrypted file does not exist.");
      completer.complete(null);
      return completer.future;
    }

    /* DURATION FETCHING */
    // Get the duration of the input file
    // String durationCommand = '-i ${inFile.path} -hide_banner';
    // final durationSession = await FFmpegKit.execute(durationCommand);
    // final durationLog = await durationSession.getOutput();

    // Check if the log output is not null and has the expected format
    // double totalDuration = 0;
    // if (durationLog != null) {
    //   // Extract duration from the log output
    //   final durationMatch =
    //       RegExp(r'Duration:\s+(\d{2}):(\d{2}):(\d{2})\.(\d{2})')
    //           .firstMatch(durationLog);

    //   // Calculate total duration in seconds
    //   if (durationMatch != null) {
    //     final hours = int.parse(durationMatch.group(1)!);
    //     final minutes = int.parse(durationMatch.group(2)!);
    //     final seconds = double.parse(durationMatch.group(3)!);

    //     totalDuration = hours * 3600 + minutes * 60 + seconds;

    //     printLog(
    //         'decryptUsingFFMPEG Decryption totalDuration ====> $totalDuration'); // Duration in seconds
    //   } else {
    //     printLog('Could not find duration in log output');
    //   }
    // } else {
    //   printLog('No output from duration command');
    // }
    /* DURATION FETCHING */

    // // FFmpeg command for decryption
    // String command =
    //     '-decryption_key $generateKey -i ${inFile.path} -c:v copy -c:a copy ${decryptedFile.path}';

    // await FFmpegKit.executeAsync(
    //   command,
    //   (session) async {
    //     final returnCode = await session.getReturnCode();
    //     printLog('decryptUsingFFMPEG returnCode : $returnCode');
    //     if (ReturnCode.isSuccess(returnCode)) {
    //       // SUCCESS
    //       printLog(
    //           'decryptUsingFFMPEG Decryption successful decryptedFile : $decryptedFile');
    //       completer.complete(decryptedFile);
    //       playerProvider.setDecryptProgress(1.0);
    //     } else {
    //       // ERROR
    //       printLog('decryptUsingFFMPEG Decryption failed!!!');
    //       completer.complete(null);
    //       playerProvider.setDecryptProgress(0.0);
    //     }
    //   },
    //   (log) {
    //     printLog('decryptUsingFFMPEG getMessage : ${log.getMessage()}');
    //   },
    //   (progress) async {
    //     if (totalDuration > 0) {
    //       // Update the progress provider here
    //       printLog(
    //           'decryptUsingFFMPEG Decryption progressTime =====> ${progress.getTime()}');
    //       printLog(
    //           'decryptUsingFFMPEG Decryption totalDuration ====> $totalDuration');
    //       // Assuming progress.getTime() returns milliseconds
    //       final progressTimeInSeconds = (progress.getTime() / 1000.0)
    //           .roundToDouble(); // Convert to seconds
    //       printLog(
    //           'decryptUsingFFMPEG Decryption progressTimeInSeconds ====> $progressTimeInSeconds');

    //       double percentage = progressTimeInSeconds / totalDuration;
    //       playerProvider
    //           .setDecryptProgress(percentage.clamp(0.0, 1.0)); // Clamp to 0-1
    //     }
    //   },
    // );
    printLog('decryptUsingFFMPEG decryptedFile ===> $decryptedFile');
  } catch (e) {
    printLog('decryptUsingFFMPEG Error during decryption: $e');
    completer.complete(null);
    // playerProvider.setDecryptProgress(0.0);
  }
  return completer.future;
}

/* ================ Download =================== */
