import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:google_fonts/google_fonts.dart';

/* Main Color */
const colorPrimary = Color(0xff3787FF);
const colorPrimaryDark = Color(0xff004AAB);
const colorAccent = Color(0xffFF9801);

const appBgColor = Color(0xFFFFFFFF);
const textFiledColor = Color(0xFFE8F1FF);
const webTextFiled = Color(0xFFD0D5DD);
const liveTextColor = Color(0xFFECF3FE);

const white = Color(0xffffffff);
const bottomBarIcon = Color(0xff9DB2CE);

const black = Color(0xFF000000);
const lightblack = Color(0xff3D3D3D);
const red = Color(0xffFF0000);
const green = Color(0xff6ACA2F);
const gray = Color(0xff888888);
const comman = Color(0xff0F2E56);
const transparent = Colors.transparent;

/* ============================= Light Theme =============================== */

final ThemeData lightTheme = ThemeData(
  brightness: Brightness.light,
  /* Main Color Start */
  primaryColor: colorPrimary,
  secondaryHeaderColor: textFiledColor,
  hintColor: colorAccent,
  scaffoldBackgroundColor: appBgColor,
  dialogTheme: DialogThemeData(backgroundColor: white),
  /* Main Color End */
  /* Text Color Start */
  colorScheme: const ColorScheme.light(
    surface: black,
    primary: white,
    onPrimary: white,
    secondary: white,
    onSecondary: white,
  ),
  textTheme: TextTheme(bodyMedium: GoogleFonts.lato(color: white)),
  bottomNavigationBarTheme: BottomNavigationBarThemeData(
      backgroundColor: white,
      selectedIconTheme: IconThemeData(color: colorPrimary),
      unselectedIconTheme: IconThemeData(color: gray),
      selectedItemColor: colorPrimary,
      unselectedItemColor: gray),
  /* Text Color End */
  appBarTheme: AppBarTheme(
      backgroundColor: appBgColor,
      surfaceTintColor: transparent,
      systemOverlayStyle: SystemUiOverlayStyle(
          statusBarColor: white,
          statusBarBrightness: Brightness.light,
          statusBarIconBrightness: Brightness.dark)),
  cardColor: white,
);

/* ============================= Dark Theme =============================== */

final ThemeData darkTheme = ThemeData(
  brightness: Brightness.dark,
  /* Main Color Start */
  primaryColor: colorPrimary,
   dialogTheme: DialogThemeData(backgroundColor: black),
  hintColor: colorAccent,
  secondaryHeaderColor: gray.withValues(alpha: 0.20),
  scaffoldBackgroundColor: black,
  /* Main Color End */
  /* Text Color Start */
  bottomNavigationBarTheme: BottomNavigationBarThemeData(
      backgroundColor: black,
      selectedIconTheme: IconThemeData(color: colorPrimary),
      unselectedIconTheme: IconThemeData(color: gray),
      selectedItemColor: colorPrimary,
      unselectedItemColor: gray),
  colorScheme: const ColorScheme.dark(
    surface: white,
    primary: white,
    onPrimary: white,
    secondary: white,
    onSecondary: white,
  ),
  textTheme: TextTheme(bodyMedium: GoogleFonts.lato(color: black)),
  /* Text Color End */
  appBarTheme: const AppBarTheme(
    backgroundColor: black,
    systemOverlayStyle: SystemUiOverlayStyle(
        statusBarColor: black,
        statusBarBrightness: Brightness.dark,
        statusBarIconBrightness: Brightness.light),
  ),
  cardColor: black,
);
