import 'dart:io';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/subscriptionprovider.dart';
import 'package:prakah/subscription/allpayment.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';
import '../model/packagemodel.dart';

class Subscription extends StatefulWidget {
  const Subscription({super.key});

  @override
  State<Subscription> createState() => _SubscriptionState();
}

class _SubscriptionState extends State<Subscription> {
  SubscriptionProvider subscriptionProvider = SubscriptionProvider();
  SharedPre sharedPre = SharedPre();
  final ScrollController _scrollController = ScrollController();
  String? userName, userEmail, userMobileNo;

  @override
  void initState() {
    super.initState();
    subscriptionProvider =
        Provider.of<SubscriptionProvider>(context, listen: false);
    _scrollController.addListener(_scrollListener);
    _fetchData(0);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (subscriptionProvider.currentPage ?? 0) <
            (subscriptionProvider.totalPage ?? 0)) {
      subscriptionProvider.setLoadMore(true);
      _fetchData(subscriptionProvider.currentPage ?? 0);
    }
  }

  Future<void> _fetchData(int? nextPage) async {
    await subscriptionProvider.getPackage((nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    subscriptionProvider.clearPackageList();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: Utils.myAppBarWithBack(
          editType: "1",
          context: context,
          appBarTitle: "subsciption",
          multilanguage: true),
      body: Container(
        height: MediaQuery.of(context).size.height * 0.90,
        decoration: BoxDecoration(
            color: white,
            borderRadius: const BorderRadius.only(
                topLeft: Radius.circular(20.0),
                topRight: Radius.circular(20.0))),
        padding: const EdgeInsets.fromLTRB(20, 20, 20, 20),
        child: SingleChildScrollView(
          controller: _scrollController,
          scrollDirection: Axis.vertical,
          physics: const BouncingScrollPhysics(),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              buildTitle(),
              const SizedBox(height: 20),
              buildPackage(),
            ],
          ),
        ),
      ),
    );
  }

/* Mobile UI Layout For Package Open */

  Widget buildTitle() {
    return Column(
      mainAxisAlignment: MainAxisAlignment.start,
      crossAxisAlignment: CrossAxisAlignment.center,
      children: [
        MyImage(
          width: 50,
          height: 50,
          imagePath: "ic_premium.png",
          color: Theme.of(context).colorScheme.surface,
        ),
        const SizedBox(height: 20),
        MyText(
          color: colorPrimary,
          text: "unlockeverything",
          maxline: 1,
          fontwaight: FontWeight.w600,
          fontsizeNormal: Dimens.textlargeBig,
          overflow: TextOverflow.ellipsis,
          textalign: TextAlign.center,
          fontstyle: FontStyle.normal,
          multilanguage: true,
        ),
        const SizedBox(height: 10),
        MyText(
          color: gray,
          text: "unlockeverythingdisc",
          maxline: 2,
          fontwaight: FontWeight.w500,
          fontsizeNormal: Dimens.textMedium,
          overflow: TextOverflow.ellipsis,
          textalign: TextAlign.center,
          fontstyle: FontStyle.normal,
          multilanguage: true,
        ),
      ],
    );
  }

  Widget buildShimmer() {
    return ResponsiveGridList(
      minItemWidth: 160,
      minItemsPerRow: 1,
      maxItemsPerRow: 1,
      listViewBuilderOptions: ListViewBuilderOptions(
        shrinkWrap: true,
        physics: const NeverScrollableScrollPhysics(),
      ),
      children: List.generate(
        5,
        (index) {
          return Container(
            padding: const EdgeInsets.fromLTRB(20, 20, 20, 20),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(15),
              border: Border.all(
                width: 1.5,
                color: gray.withValues(alpha: 0.20),
              ),
            ),
            child: const Column(
              mainAxisAlignment: MainAxisAlignment.center,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    CustomWidget.roundrectborder(
                      height: 8,
                      width: 100,
                    ),
                    CustomWidget.roundrectborder(
                      height: 8,
                      width: 50,
                    ),
                  ],
                ),
                SizedBox(height: 10),
                CustomWidget.roundrectborder(
                  height: 8,
                ),
                SizedBox(height: 15),
                CustomWidget.circleborder(
                  height: 40,
                  width: 100,
                ),
              ],
            ),
          );
        },
      ),
    );
  }

  Widget buildPackage() {
    return Consumer<SubscriptionProvider>(
        builder: (context, subscriptionprovider, child) {
      if (subscriptionprovider.loading && !subscriptionprovider.loadmore) {
        return buildShimmer();
      } else {
        if (subscriptionprovider.packageModel.status == 200 &&
            subscriptionprovider.packageList != null) {
          if ((subscriptionprovider.packageList?.length ?? 0) > 0) {
            return Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                buildPackageListMobile(),
                if (subscriptionprovider.loadmore)
                  Container(
                    height: 50,
                    margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                    child: Utils.pageLoader(),
                  )
                else
                  const SizedBox.shrink(),
              ],
            );
          } else {
            return const NoData();
          }
        } else {
          return const NoData();
        }
      }
    });
  }

  Widget buildPackageListMobile() {
    return ResponsiveGridList(
      minItemWidth: 160,
      minItemsPerRow: 1,
      maxItemsPerRow: 1,
      listViewBuilderOptions: ListViewBuilderOptions(
        shrinkWrap: true,
        physics: const NeverScrollableScrollPhysics(),
      ),
      children: List.generate(
        subscriptionProvider.packageList?.length ?? 0,
        (index) {
          return InkWell(
            onTap: () {
              _checkAndPay(subscriptionProvider.packageList ?? [], index);
            },
            child: Container(
              padding: const EdgeInsets.fromLTRB(20, 20, 20, 20),
              margin:
                  (kIsWeb) ? const EdgeInsets.fromLTRB(20, 0, 20, 20) : null,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(15),
                border: Border.all(
                  width: 1.5,
                  color: gray.withValues(alpha: 0.20),
                ),
              ),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      MyText(
                        color: Theme.of(context).colorScheme.surface,
                        text: subscriptionProvider
                                .packageModel.result?[index].name
                                .toString()
                                .toUpperCase() ??
                            "",
                        maxline: 1,
                        fontwaight: FontWeight.w700,
                        fontsizeNormal: Dimens.textTitle,
                        fontsizeWeb: Dimens.textBig,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal,
                        multilanguage: false,
                      ),
                      MyText(
                        color: green,
                        text:
                            "${Constant.currencyCode} ${subscriptionProvider.packageList?[index].price.toString() ?? ""}",
                        maxline: 1,
                        fontwaight: FontWeight.w700,
                        fontsizeNormal: Dimens.textBig,
                        fontsizeWeb: Dimens.textBig,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal,
                        multilanguage: false,
                      ),
                    ],
                  ),
                  const SizedBox(height: 10),
                  MyText(
                    color: gray,
                    text:
                        "Ads Free Content for ${subscriptionProvider.packageList?[index].durationDays.toString() ?? ""} ${subscriptionProvider.packageList?[index].maxCoursesAllowed.toString() ?? ""}",
                    maxline: 1,
                    fontwaight: FontWeight.w400,
                    fontsizeNormal: Dimens.textSmall,
                    fontsizeWeb: Dimens.textMedium,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.center,
                    fontstyle: FontStyle.normal,
                    multilanguage: false,
                  ),
                  const SizedBox(height: 15),
                  InkWell(
                    onTap: () {
                      Navigator.pop(context);
                      _checkAndPay(
                          subscriptionProvider.packageList ?? [], index);
                    },
                    child: Container(
                      width: 100,
                      height: 40,
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(50),
                        color:
                            (subscriptionProvider.packageList?[index].isBuy ==
                                    1)
                                ? colorAccent
                                : colorPrimary,
                      ),
                      child: MyText(
                        color:
                            (subscriptionProvider.packageList?[index].isBuy ==
                                    1)
                                ? black
                                : white,
                        text: (subscriptionProvider.packageList?[index].isBuy ==
                                1)
                            ? "active"
                            : "subscribe",
                        maxline: 1,
                        fontwaight:
                            (subscriptionProvider.packageList?[index].isBuy ==
                                    1)
                                ? FontWeight.w600
                                : FontWeight.w500,
                        fontsizeNormal: Dimens.textSmall,
                        fontsizeWeb: Dimens.textTitle,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal,
                        multilanguage: true,
                      ),
                    ),
                  ),
                ],
              ),
            ),
          );
        },
      ),
    );
  }

/* Check And Pay */

  Future<void> _checkAndPay(List<Result>? packageList, int index) async {
    if (Utils.checkLoginUser(context)) {
      await Navigator.push(
        context,
        MaterialPageRoute(
          builder: (context) {
            return AllPayment(
              payType: 'Package',
              contentType: "1",
              itemId: packageList?[index].id.toString() ?? '',
              price: packageList?[index].price.toString() ?? '',
              itemTitle: packageList?[index].name.toString() ?? '',
              productPackage: (!kIsWeb)
                  ? (Platform.isIOS
                      ? (packageList?[index].iosProductPackage.toString() ?? '')
                      : (packageList?[index].androidProductPackage.toString() ??
                          ''))
                  : '',
            );
          },
        ),
      );
    }
  }
}
