import 'dart:async';
import 'dart:convert';
import 'dart:io';
import 'package:prakah/pages/bottombar.dart';
import 'package:prakah/pages/meeting.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/provider/meetingprovider.dart';
import 'package:prakah/provider/profileprovider.dart';
import 'package:prakah/provider/subscriptionprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webhome.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:flutter_paypal_payment/flutter_paypal_payment.dart';
import 'package:flutter_stripe/flutter_stripe.dart' as stripe;
import 'package:flutterwave_standard_smart/flutterwave.dart';
import 'package:http/http.dart' as http;
import 'package:google_fonts/google_fonts.dart';
import 'package:progress_dialog_null_safe/progress_dialog_null_safe.dart';
import 'package:in_app_purchase/in_app_purchase.dart';
import 'package:in_app_purchase_android/in_app_purchase_android.dart';
import 'package:in_app_purchase_storekit/in_app_purchase_storekit.dart';
import 'package:in_app_purchase_storekit/store_kit_wrappers.dart';
import 'package:provider/provider.dart';
// import 'package:razorpay_web/razorpay_web.dart';
import 'package:uuid/uuid.dart';

final bool _kAutoConsume = Platform.isIOS || true;

class AllPayment extends StatefulWidget {
  final String? payType,
      contentType,
      itemId,
      price,
      itemTitle,
      productPackage,
      cartType,
      promoCodeId,
      discountPrice,
      fileName,
      mediaType;
  final String? mettingId,
      mettingScheduleId,
      date,
      chapterId,
      totalPrice,
      details,
      attachment;
  final Uint8List? imageFileA;

  final int? rentSectionIndex, rentVideoIndex;
  const AllPayment({
    super.key,
    this.imageFileA,
    this.fileName,
    this.mediaType,
    this.mettingId,
    this.mettingScheduleId,
    this.date,
    this.chapterId,
    this.totalPrice,
    this.details,
    this.attachment,
    this.cartType,
    this.promoCodeId,
    this.discountPrice,
    this.payType,
    this.contentType,
    this.itemId,
    this.price,
    this.itemTitle,
    this.productPackage,
    this.rentVideoIndex,
    this.rentSectionIndex,
  });

  @override
  State<AllPayment> createState() => AllPaymentState();
}

class AllPaymentState extends State<AllPayment> {
  final couponController = TextEditingController();
  late ProgressDialog prDialog;
  late SubscriptionProvider subscriptionProvider;
  SharedPre sharedPref = SharedPre();
  String? userId, userName, userEmail, userMobileNo, paymentId;
  String? strCouponCode = "";
  bool isPaymentDone = false;

  /* InApp Purchase */
  final InAppPurchase _inAppPurchase = InAppPurchase.instance;
  late StreamSubscription<List<PurchaseDetails>> _subscription;
  late List<String> _kProductIds;
  final List<PurchaseDetails> _purchases = <PurchaseDetails>[];

  /* Paytm */
  String paytmResult = "";

  /* Flutterwave */
  String selectedCurrency = "";
  bool isTestMode = true;

  /* Stripe */
  Map<String, dynamic>? paymentIntent;

  /* PayU */
  // late PayUCheckoutProFlutter _payUCheckoutPro;

  @override
  void initState() {
    super.initState();
    subscriptionProvider =
        Provider.of<SubscriptionProvider>(context, listen: false);
    prDialog = ProgressDialog(context);
    _getData();
    if (!kIsWeb) {
      /* PayU */
      // _payUCheckoutPro = PayUCheckoutProFlutter(this);

      /* InApp Purchase */
      _kProductIds = <String>[widget.productPackage ?? ""];
      prDialog = ProgressDialog(context);
      _getData();
      final Stream<List<PurchaseDetails>> purchaseUpdated =
          _inAppPurchase.purchaseStream;
      _subscription =
          purchaseUpdated.listen((List<PurchaseDetails> purchaseDetailsList) {
        _listenToPurchaseUpdated(purchaseDetailsList);
      }, onDone: () {
        _subscription.cancel();
      }, onError: (Object error) {
        // handle error here.
        printLog("onError ============> ${error.toString()}");
      });
      initStoreInfo();
    }
    _getUserData();
  }

  Future<void> _getData() async {
    await subscriptionProvider.getPaymentOption();
    subscriptionProvider.setFinalAmount(widget.price ?? "");

    /* PaymentID */
    paymentId = Utils.generateRandomOrderID();
    printLog('paymentId =====================> $paymentId');
  }

  Future<void> _getUserData() async {
    final profileProvider =
        Provider.of<ProfileProvider>(context, listen: false);
    await profileProvider.getprofile(context);
    if (profileProvider.profileModel.status == 200) {
      userName = profileProvider.profileModel.result?[0].fullName ?? "";
      userEmail = profileProvider.profileModel.result?[0].email ?? "";
      userMobileNo = profileProvider.profileModel.result?[0].mobileNumber ?? "";
    }
  }

  @override
  void dispose() {
    subscriptionProvider.clearAllPaymentProvider();
    if (!kIsWeb) {
      if (Platform.isIOS) {
        final InAppPurchaseStoreKitPlatformAddition iosPlatformAddition =
            _inAppPurchase
                .getPlatformAddition<InAppPurchaseStoreKitPlatformAddition>();
        iosPlatformAddition.setDelegate(null);
      }
      _subscription.cancel();
    }

    super.dispose();
  }

/* Buy Course api */
  Future buyCourse() async {
    final gen = Provider.of<GeneralProvider>(context, listen: false);

    subscriptionProvider.setPaymentLoading(true);

    await subscriptionProvider.buyCourseApi(
        widget.cartType ?? "",
        subscriptionProvider.finalAmount,
        widget.discountPrice,
        widget.promoCodeId,
        0,
        paymentId ?? "");

    if (subscriptionProvider.successModel.status == 200) {
      isPaymentDone = true;
      subscriptionProvider.setPaymentLoading(false);

      if (!mounted) return;

      Utils.showSnackbar(context, "success",
          subscriptionProvider.successModel.message ?? "", false);
      Future.microtask(() {
        if (kIsWeb) {
          if (!mounted) return;

          Utils.navigatePage(context, const WebHome(), '');

          gen.setHomeTab("1");
        } else {
          if (!mounted) return;

          Utils.navigatePage(context, const Bottombar(), '');
        }
      });
    } else {
      isPaymentDone = false;
      subscriptionProvider.setPaymentLoading(false);
      if (!mounted) return;
      Utils.showSnackbar(context, "fail",
          subscriptionProvider.successModel.message ?? "", false);
    }
  }

  /*  Book a Session Data  api */
  Future<void> bookSession() async {
    subscriptionProvider.setPaymentLoading(true);
    try {
      await subscriptionProvider.getBookSeesion(
          widget.mettingId ?? "",
          widget.mettingScheduleId,
          widget.date,
          widget.chapterId,
          subscriptionProvider.finalAmount,
          widget.details,
          (kIsWeb) ? widget.imageFileA : widget.attachment,
          paymentId ?? "",
          widget.promoCodeId,
          widget.fileName,
          widget.mediaType);

      if (subscriptionProvider.successModel.status == 200) {
        isPaymentDone = true;
        subscriptionProvider.setPaymentLoading(false);
        if (!mounted) return;

        Utils.showSnackbar(context, "success",
            subscriptionProvider.successModel.message ?? "", false);
        /* Payment Success show Dialog */
        if (kIsWeb) {
          Navigator.of(context).pop({"isType": "1"});
        } else {
          await confirmDialog();
        }
      } else {
        isPaymentDone = false;
        if (!mounted) return;
        subscriptionProvider.setPaymentLoading(false);

        Utils.showSnackbar(context, "fail",
            subscriptionProvider.successModel.message ?? "", false);
      }
    } catch (e) {
      isPaymentDone = false;
      subscriptionProvider.setPaymentLoading(false);
      printLog(e.toString());
      if (!mounted) return;

      Utils.showSnackbar(context, "fail",
          subscriptionProvider.successModel.message ?? "", false);
    }
  }

/* Confirm Dialog */
  Future<void> confirmDialog() async {
    return showDialog(
      context: context,
      builder: (context) {
        return AlertDialog(
          backgroundColor: white,
          title: Padding(
            padding: const EdgeInsets.all(20),
            child: MyImage(
              width: 184,
              height: 140,
              imagePath: 'confirm_dialog.png',
              fit: BoxFit.fill,
            ),
          ),
          content: SizedBox(
            height: 100,
            width: 160,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                MyText(
                  text: 'congratulations',
                  multilanguage: true,
                  maxline: 1,
                  overflow: TextOverflow.ellipsis,
                  fontsizeNormal: Dimens.textTitle,
                  color: colorPrimaryDark,
                  fontwaight: FontWeight.w500,
                ),
                MyText(
                  text: 'con_dialog',
                  multilanguage: true,
                  maxline: 3,
                  textalign: TextAlign.center,
                  overflow: TextOverflow.ellipsis,
                  fontsizeNormal: Dimens.textSmall,
                  color: gray,
                  fontwaight: FontWeight.w500,
                ),
              ],
            ),
          ),
          actions: [
            _btnWidget(
                borderColor: transparent,
                color: colorPrimaryDark,
                textColor: white,
                title: "view_appoinment",
                onTap: () {
                  final meetingProvider =
                      Provider.of<MeetingProvider>(context, listen: false);

                  if (Navigator.canPop(context)) {
                    Navigator.of(context).pop();
                  }

                  Navigator.of(context).pushAndRemoveUntil(
                    PageRouteBuilder(
                      pageBuilder: (context, animation, secondaryAnimation) =>
                          Meeting(selectedTab: "2"),
                      transitionsBuilder:
                          (context, animation, secondaryAnimation, child) {
                        const begin = Offset(1.0, 0.0);
                        const end = Offset.zero;
                        const curve = Curves.ease;

                        var tween = Tween(begin: begin, end: end)
                            .chain(CurveTween(curve: curve));

                        return SlideTransition(
                          position: animation.drive(tween),
                          child: child,
                        );
                      },
                    ),
                    (route) => route.isFirst,
                  );

                  /* API Call */
                  meetingProvider.clearProvider();
                  meetingProvider.setTab("2");
                  meetingProvider.getMeetingStatus();
                  meetingProvider.getUseMeeting(meetingProvider.myTab, 0);
                }),
            SizedBox(height: 20),
            _btnWidget(
                borderColor: transparent,
                color: colorPrimary.withValues(alpha: 0.4),
                textColor: colorPrimaryDark,
                title: "cancel",
                onTap: () {
                  final meetingProvider =
                      Provider.of<MeetingProvider>(context, listen: false);

                  Navigator.of(context).pushAndRemoveUntil(
                    PageRouteBuilder(
                      pageBuilder: (context, animation, secondaryAnimation) =>
                          Meeting(
                        selectedTab: "1",
                      ),
                      transitionsBuilder:
                          (context, animation, secondaryAnimation, child) {
                        const begin = Offset(1.0, 0.0);
                        const end = Offset.zero;
                        const curve = Curves.ease;

                        var tween = Tween(begin: begin, end: end)
                            .chain(CurveTween(curve: curve));

                        return SlideTransition(
                          position: animation.drive(tween),
                          child: child,
                        );
                      },
                    ),
                    (route) => route.isFirst,
                  );

                  /* API Call */
                  meetingProvider.clearProvider();

                  meetingProvider.setTab("1");
                  meetingProvider.getCourseName();
                  meetingProvider.getMeeting("0", 0);
                }),
          ],
        );
      },
    );
  }

  Widget _btnWidget({String? title, textColor, color, borderColor, onTap}) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: onTap,
      child: Container(
        padding: EdgeInsets.fromLTRB(24, 16, 24, 16),
        alignment: Alignment.center,
        width: MediaQuery.sizeOf(context).width,
        decoration: BoxDecoration(
            border: Border.all(
                width: 1, color: borderColor, style: BorderStyle.solid),
            color: color,
            borderRadius: BorderRadius.circular(26)),
        child: MyText(
          text: title ?? "",
          multilanguage: true,
          color: textColor,
          fontsizeNormal: Dimens.textMedium,
          fontsizeWeb: Dimens.textMedium,
          fontwaight: FontWeight.w600,
        ),
      ),
    );
  }

/* END */
  /* Package Transection API */
  Future addPackageTransaction() async {
    subscriptionProvider.setPaymentLoading(true);

    await subscriptionProvider.addPackageTransaction(
      widget.contentType ?? "",
      widget.itemId ?? "",
      subscriptionProvider.finalAmount ?? "",
      paymentId ?? "",
    );

    if (subscriptionProvider.successModel.status == 200) {
      isPaymentDone = true;
      subscriptionProvider.setPaymentLoading(false);
      if (!mounted) return;

      Utils.showSnackbar(context, "success",
          subscriptionProvider.successModel.message ?? "", false);
      if (kIsWeb) {
        Utils.navigatePage(context, const WebHome(), '');
      } else {
        Utils.navigatePage(context, const Bottombar(), '');
      }
    } else {
      isPaymentDone = false;
      subscriptionProvider.setPaymentLoading(false);
      if (!mounted) return;
      Utils.showSnackbar(context, "fail",
          subscriptionProvider.successModel.message ?? "", false);
    }
  }

  Future<void> openPayment({required String pgName}) async {
    printLog("finalAmount =============> ${subscriptionProvider.finalAmount}");
    if (subscriptionProvider.finalAmount != "0") {
      if (pgName == "paypal") {
        if (Constant.isDemoMode == "1") {
          if (widget.payType == "cart") {
            buyCourse();
          } else if (widget.payType == "book_session") {
            bookSession();
          } else if (widget.payType == "Package") {
            addPackageTransaction();
          } else {
            printLog("No API");
          }
        } else {
          _paypalInit();
        }
      } else if (pgName == "inapp") {
        if (Constant.isDemoMode == "1") {
          if (widget.payType == "cart") {
            buyCourse();
          } else if (widget.payType == "book_session") {
            bookSession();
          } else if (widget.payType == "Package") {
            addPackageTransaction();
          } else {
            printLog("No API");
          }
        } else {
          _initInAppPurchase();
        }
      } else if (pgName == "razorpay") {
        if (Constant.isDemoMode == "1") {
          if (widget.payType == "cart") {
            buyCourse();
          } else if (widget.payType == "book_session") {
            bookSession();
          } else if (widget.payType == "Package") {
            addPackageTransaction();
          } else {
            printLog("No API");
          }
        } else {
          _initializeRazorpay();
        }
      } else if (pgName == "flutterwave") {
        if (Constant.isDemoMode == "1") {
          if (widget.payType == "cart") {
            buyCourse();
          } else if (widget.payType == "book_session") {
            bookSession();
          } else if (widget.payType == "Package") {
            addPackageTransaction();
          } else {
            printLog("No API");
          }
        } else {
          _flutterwaveInit();
        }
      } else if (pgName == "payumoney") {
        if (Constant.isDemoMode == "1") {
          if (widget.payType == "cart") {
            buyCourse();
          } else if (widget.payType == "book_session") {
            bookSession();
          } else if (widget.payType == "Package") {
            addPackageTransaction();
          } else {
            printLog("No API");
          }
        } else {}
      } else if (pgName == "stripe") {
        if (Constant.isDemoMode == "1") {
          if (widget.payType == "cart") {
            buyCourse();
          } else if (widget.payType == "book_session") {
            bookSession();
          } else if (widget.payType == "Package") {
            addPackageTransaction();
          } else {
            printLog("No API");
          }
        } else {
          _stripeInit();
        }
      } else if (pgName == "cash") {
        if (!mounted) return;
        Utils.showSnackbar(context, "success", "cash_payment_msg", true);
      }
    } else {
      if (widget.payType == "cart") {
        buyCourse();
      } else if (widget.payType == "book_session") {
        bookSession();
      } else if (widget.payType == "Package") {
        addPackageTransaction();
      } else {
        printLog("No API");
      }
    }
  }

/* Confirm Button */

  Widget _buildButton() {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      highlightColor: transparent,
      onTap: () {
        if (subscriptionProvider.setIndex == null ||
            subscriptionProvider.setIndex == 0) {
          Utils.showSnackbar(
              context, "fail", "Please selecte the Payment Option", false);
        } else {
          subscriptionProvider
              .setCurrentPayment(subscriptionProvider.pageName ?? "");
          openPayment(pgName: subscriptionProvider.pageName ?? "");
        }
      },
      child: AnimatedContainer(
        padding: EdgeInsets.fromLTRB(40, 10, 40, 10),
        width: subscriptionProvider.payLoading
            ? 100
            : kIsWeb
                ? MediaQuery.sizeOf(context).width * 0.3
                : MediaQuery.sizeOf(context).width * 0.5,
        alignment: Alignment.center,
        duration: Duration(milliseconds: 200),
        decoration: BoxDecoration(
          color: colorPrimaryDark,
          borderRadius: BorderRadius.circular(10),
        ),
        child: subscriptionProvider.payLoading
            ? SizedBox(
                height: 25,
                child: CircularProgressIndicator(
                  color: white,
                ),
              )
            : MyText(
                text: "confirm",
                fontsizeNormal: Dimens.textBig,
                color: white,
                fontwaight: FontWeight.w600,
                multilanguage: true,
              ),
      ),
    );
  }

  bool checkKeysAndContinue({
    required String isLive,
    required bool isBothKeyReq,
    required String key1,
    required String key2,
  }) {
    if (isBothKeyReq) {
      if (key1 == "" || key2 == "") {
        Utils.showSnackbar(context, "", "payment_not_processed", true);
        return false;
      }
    } else {
      if (key1 == "") {
        Utils.showSnackbar(context, "", "payment_not_processed", true);
        return false;
      }
    }
    return true;
  }

  @override
  Widget build(BuildContext context) {
    return PopScope(
      onPopInvokedWithResult: (didPop, result) => onBackPressed,
      child: Consumer<SubscriptionProvider>(
          builder: (context, subscriptionprovider, child) {
        return _buildPage();
      }),
    );
  }

  Widget _buildPage() {
    return Scaffold(
      // backgroundColor: white,
      appBar: kIsWeb
          ? Utils.webMainAppbar()
          : Utils.myAppBarWithBack(
              editType: "1",
              context: context,
              appBarTitle: "payment_methods",
              multilanguage: true),
      body: kIsWeb
          ? Utils.hoverItemWithPage(
              myWidget: SafeArea(
                child: SingleChildScrollView(
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      Utils.buildWebDetailsAppBar(
                          context: context, title: "payment_methods"),
                      SizedBox(height: 30),
                      _buildWebPayments(),
                      _buildButton(),
                      SizedBox(height: 30),
                    ],
                  ),
                ),
              ),
            )
          : SafeArea(
              child: Center(
                child: _buildMobilePage(),
              ),
            ),
    );
  }

  Widget _buildMobilePage() {
    return Container(
      width:
          ((kIsWeb || Constant.isTV) && MediaQuery.of(context).size.width > 720)
              ? MediaQuery.of(context).size.width * 0.5
              : MediaQuery.of(context).size.width,
      margin: (kIsWeb || Constant.isTV)
          ? const EdgeInsets.fromLTRB(50, 0, 50, 50)
          : const EdgeInsets.all(0),
      alignment: Alignment.center,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          /*  Total Amount */
          Container(
            margin: const EdgeInsets.all(15.0),
            child: Card(
              semanticContainer: true,
              clipBehavior: Clip.antiAliasWithSaveLayer,
              elevation: 5,
              color: gray,
              shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.circular(5),
              ),
              child: Container(
                width: MediaQuery.of(context).size.width,
                constraints: const BoxConstraints(minHeight: 50),
                alignment: Alignment.centerLeft,
                child: Column(
                  children: [
                    Container(
                      width: MediaQuery.of(context).size.width,
                      constraints: const BoxConstraints(minHeight: 50),
                      decoration: Utils.setBackground(colorPrimary, 0),
                      padding: const EdgeInsets.fromLTRB(15, 0, 15, 0),
                      alignment: Alignment.centerLeft,
                      child: Consumer<SubscriptionProvider>(
                        builder: (context, subscriptionProvider, child) {
                          return RichText(
                            textAlign: TextAlign.start,
                            text: TextSpan(
                              text: "Amount : ",
                              style: GoogleFonts.montserrat(
                                textStyle: TextStyle(
                                  color: white,
                                  fontSize: Dimens.textTitle,
                                  fontWeight: FontWeight.w600,
                                  fontStyle: FontStyle.normal,
                                  letterSpacing: 0.5,
                                ),
                              ),
                              children: <TextSpan>[
                                TextSpan(
                                  text:
                                      "${Constant.currencyCode}${subscriptionProvider.finalAmount ?? ""}",
                                  style: GoogleFonts.montserrat(
                                    textStyle: TextStyle(
                                      color: white,
                                      fontSize: Dimens.textlargeBig,
                                      fontWeight: FontWeight.w700,
                                      fontStyle: FontStyle.normal,
                                      letterSpacing: 0.2,
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          );
                        },
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ),

          /* PGs */
          Expanded(
            child: SingleChildScrollView(
              scrollDirection: Axis.vertical,
              physics: const BouncingScrollPhysics(),
              child: subscriptionProvider.loading
                  ? Container(
                      height: 230,
                      padding: const EdgeInsets.all(20),
                      child: Utils.pageLoader(),
                    )
                  : subscriptionProvider.paymentOptionModel.status == 200
                      ? subscriptionProvider.paymentOptionModel.result != null
                          ? _buildPaymentPage()
                          : const NoData()
                      : const NoData(),
            ),
          ),
        ],
      ),
    );
  }

  Widget _buildPaymentPage() {
    return Container(
      padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          MyText(
            color: Theme.of(context).colorScheme.surface,
            text: "payment_methods",
            fontsizeNormal: Dimens.textTitle,
            maxline: 1,
            multilanguage: true,
            overflow: TextOverflow.ellipsis,
            fontwaight: FontWeight.w600,
            textalign: TextAlign.center,
            fontstyle: FontStyle.normal,
          ),
          const SizedBox(height: 5),
          MyText(
            color: Theme.of(context).colorScheme.surface,
            text: "choose_a_payment_methods_to_pay",
            multilanguage: true,
            fontsizeNormal: Dimens.textMedium,
            maxline: 2,
            overflow: TextOverflow.ellipsis,
            fontwaight: FontWeight.w500,
            textalign: TextAlign.center,
            fontstyle: FontStyle.normal,
          ),
          const SizedBox(height: 15),
          MyText(
            color: Theme.of(context).colorScheme.surface,
            text: "pay_with",
            multilanguage: true,
            fontsizeNormal: Dimens.textTitle,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            fontwaight: FontWeight.w700,
            textalign: TextAlign.center,
            fontstyle: FontStyle.normal,
          ),
          const SizedBox(height: 20),

          /* /* Payments */ */
          (!kIsWeb)
              ? (/* Platform.isIOS ? buildIOSPG() : */ _buildAndroidPG())
              : const SizedBox.shrink(),
          const SizedBox(height: 20),
          _buildButton(),
        ],
      ),
    );
  }

  Widget buildIOSPG() {
    /* In-App purchase */
    return _buildIOSPGButton("In-App Purchase", 35, 110, onClick: () async {
      subscriptionProvider.setCurrentPayment("inapp");
      _initInAppPurchase();
    });
  }

  Widget _buildIOSPGButton(String pgName, double imgHeight, double imgWidth,
      {required Function() onClick}) {
    return Container(
      margin: const EdgeInsets.only(bottom: 5),
      child: Card(
        semanticContainer: true,
        clipBehavior: Clip.antiAliasWithSaveLayer,
        elevation: 5,
        color: gray,
        shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.circular(8),
        ),
        child: InkWell(
          borderRadius: BorderRadius.circular(8),
          onTap: onClick,
          child: Container(
            constraints: const BoxConstraints(minHeight: 85),
            padding: const EdgeInsets.all(20),
            child: Row(
              mainAxisSize: MainAxisSize.max,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: <Widget>[
                Expanded(
                  child: MyText(
                    color: white,
                    text: pgName,
                    multilanguage: false,
                    fontsizeNormal: Dimens.textSmall,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.start,
                    fontstyle: FontStyle.normal,
                  ),
                ),
                const SizedBox(width: 20),
                Icon(
                  Icons.arrow_forward_ios_outlined,
                  size: 22,
                  color: white,
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }

  Widget _buildAndroidPG() {
    return Column(
      children: [
        /* In-App purchase */
        subscriptionProvider.paymentOptionModel.result?.inapppurchage != null
            ? subscriptionProvider
                        .paymentOptionModel.result?.inapppurchage?.visibility ==
                    "1"
                ? _buildPGButton("pg_inapp.png", "InApp Purchase", 35, 110, 1,
                    onClick: () {
                    subscriptionProvider.setPaymentOpen(
                        value: 1, valueName: "inapp");
                  })
                : const SizedBox.shrink()
            : const SizedBox.shrink(),

        /* Paypal */
        subscriptionProvider.paymentOptionModel.result?.paypal != null
            ? subscriptionProvider
                        .paymentOptionModel.result?.paypal?.visibility ==
                    "1"
                ? _buildPGButton("pg_paypal.png", "Paypal", 35, 130, 2,
                    onClick: () {
                    subscriptionProvider.setPaymentOpen(
                        value: 2, valueName: "paypal");
                  })
                : const SizedBox.shrink()
            : const SizedBox.shrink(),

        /* Razorpay */
        subscriptionProvider.paymentOptionModel.result?.razorpay != null
            ? subscriptionProvider
                        .paymentOptionModel.result?.razorpay?.visibility ==
                    "1"
                ? _buildPGButton("pg_razorpay.png", "Razorpay", 35, 130, 3,
                    onClick: () {
                    subscriptionProvider.setPaymentOpen(
                        value: 3, valueName: "razorpay");
                  })
                : const SizedBox.shrink()
            : const SizedBox.shrink(),

        /* Paytm */
        subscriptionProvider.paymentOptionModel.result?.paytm != null
            ? subscriptionProvider
                        .paymentOptionModel.result?.paytm?.visibility ==
                    "1"
                ? _buildPGButton("pg_paytm.png", "Paytm", 30, 90, 4,
                    onClick: () {
                    subscriptionProvider.setPaymentOpen(
                        value: 4, valueName: "paytm");
                  })
                : const SizedBox.shrink()
            : const SizedBox.shrink(),

        /* Flutterwave */
        subscriptionProvider.paymentOptionModel.result?.flutterwave != null
            ? subscriptionProvider
                        .paymentOptionModel.result?.flutterwave?.visibility ==
                    "1"
                ? _buildPGButton(
                    "pg_flutterwave.png", "Flutterwave", 35, 130, 5,
                    onClick: () {
                    subscriptionProvider.setPaymentOpen(
                        value: 5, valueName: "flutterwave");
                  })
                : const SizedBox.shrink()
            : const SizedBox.shrink(),
        /* Stripe */
        subscriptionProvider.paymentOptionModel.result?.stripe != null
            ? subscriptionProvider
                        .paymentOptionModel.result?.stripe?.visibility ==
                    "1"
                ? _buildPGButton("pg_stripe.png", "Stripe", 35, 130, 6,
                    onClick: () {
                    subscriptionProvider.setPaymentOpen(
                        value: 6, valueName: "stripe");
                  })
                : const SizedBox.shrink()
            : const SizedBox.shrink(),

        /* PayUMoney */
        subscriptionProvider.paymentOptionModel.result?.payumoney != null
            ? subscriptionProvider
                        .paymentOptionModel.result?.payumoney?.visibility ==
                    "1"
                ? _buildPGButton("pg_payumoney.png", "PayU Money", 35, 130, 7,
                    onClick: () {
                    subscriptionProvider.setPaymentOpen(
                        value: 7, valueName: "payumoney");
                  })
                : const SizedBox.shrink()
            : const SizedBox.shrink(),
      ],
    );
  }

  Widget _buildPGButton(String imageName, String pgName, double imgHeight,
      double imgWidth, int count,
      {required Function() onClick}) {
    return Container(
      margin: const EdgeInsets.only(bottom: 5),
      child: Card(
        semanticContainer: true,
        clipBehavior: Clip.antiAliasWithSaveLayer,
        elevation: 0,
        color: colorPrimary.withValues(alpha: 0.15),
        shape: RoundedRectangleBorder(
            borderRadius: BorderRadius.circular(8),
            side: subscriptionProvider.setIndex == count
                ? BorderSide(
                    width: 1, color: colorPrimaryDark, style: BorderStyle.solid)
                : BorderSide.none),
        child: InkWell(
          borderRadius: BorderRadius.circular(8),
          onTap: onClick,
          child: Container(
            constraints: const BoxConstraints(minHeight: 85),
            padding: const EdgeInsets.all(12),
            child: Row(
              mainAxisSize: MainAxisSize.max,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: <Widget>[
                MyImage(
                  imagePath: imageName,
                  fit: BoxFit.contain,
                  height: imgHeight,
                  width: imgWidth,
                ),
                const SizedBox(width: 15),
                Expanded(
                  child: MyText(
                    color: black,
                    text: pgName,
                    multilanguage: false,
                    fontsizeNormal: Dimens.textMedium,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.end,
                    fontstyle: FontStyle.normal,
                  ),
                ),
                const SizedBox(width: 15),
                Icon(
                  Icons.arrow_forward_ios_outlined,
                  size: 22,
                  color: black,
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }

  Widget _buildWebPayments() {
    return Consumer<SubscriptionProvider>(
        builder: (context, subscriptionProvider, child) {
      return Container(
        padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
        width: MediaQuery.of(context).size.width,
        decoration: const BoxDecoration(),
        alignment: Alignment.center,
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            MyText(
              color: Theme.of(context).colorScheme.surface,
              text: "payment_methods",
              maxline: 1,
              fontsizeNormal: Dimens.textExtralargeBig,
              fontsizeWeb: Dimens.textExtralargeBig,
              multilanguage: true,
              overflow: TextOverflow.ellipsis,
              fontwaight: FontWeight.w700,
              textalign: TextAlign.center,
              fontstyle: FontStyle.normal,
            ),
            const SizedBox(height: 15),
            MyText(
              color: Theme.of(context).colorScheme.surface,
              text: "choose_a_payment_methods_to_pay",
              multilanguage: true,
              fontsizeNormal: Dimens.textTitle,
              fontsizeWeb: Dimens.textTitle,
              maxline: 2,
              overflow: TextOverflow.ellipsis,
              fontwaight: FontWeight.w500,
              textalign: TextAlign.center,
              fontstyle: FontStyle.normal,
            ),
            const SizedBox(height: 50),
            /* Price */

            Row(
              mainAxisAlignment: MainAxisAlignment.center,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                MyText(
                  color: Theme.of(context).colorScheme.surface,
                  text: "total",
                  multilanguage: true,
                  fontsizeNormal: Dimens.textTitle,
                  fontsizeWeb: Dimens.textTitle,
                  maxline: 1,
                  overflow: TextOverflow.ellipsis,
                  fontwaight: FontWeight.w600,
                  textalign: TextAlign.center,
                  fontstyle: FontStyle.normal,
                ),
                const SizedBox(width: 20),
                MyText(
                  color: Theme.of(context).colorScheme.surface,
                  text:
                      "${Constant.currencyCode} ${subscriptionProvider.finalAmount ?? ""}",
                  multilanguage: false,
                  fontsizeNormal: Dimens.textExtralargeBig,
                  fontsizeWeb: Dimens.textExtralargeBig,
                  maxline: 1,
                  overflow: TextOverflow.ellipsis,
                  fontwaight: FontWeight.w700,
                  textalign: TextAlign.center,
                  fontstyle: FontStyle.normal,
                ),
              ],
            ),
            const SizedBox(height: 50),
            /* Razorpay */
            InkWell(
              onTap: () {
                subscriptionProvider.setPaymentOpen(
                    value: 1, valueName: "razorpay");
              },
              child: Container(
                width: MediaQuery.of(context).size.width * 0.50,
                padding: const EdgeInsets.fromLTRB(15, 15, 15, 15),
                decoration: BoxDecoration(
                  color: colorPrimary.withValues(alpha: 0.15),
                  border: Border.all(
                      width: 1,
                      color: colorPrimaryDark,
                      style: subscriptionProvider.setIndex == 1
                          ? BorderStyle.solid
                          : BorderStyle.none),
                  borderRadius: BorderRadius.circular(15),
                ),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    MyImage(
                      width: 100,
                      height: 50,
                      imagePath: "pg_razorpay.png",
                      fit: BoxFit.contain,
                    ),
                    const SizedBox(width: 15),
                    Flexible(
                      fit: FlexFit.loose,
                      child: MyText(
                        color: Theme.of(context).colorScheme.surface,
                        text: "continuewithrazorpay",
                        multilanguage: true,
                        fontsizeNormal: Dimens.textTitle,
                        fontsizeWeb: Dimens.textTitle,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontwaight: FontWeight.w600,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal,
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ],
        ),
      );
    });
  }

  /* ********* InApp purchase START ********* */
  Future<void> initStoreInfo() async {
    final bool isAvailable = await _inAppPurchase.isAvailable();
    if (!isAvailable) {
      setState(() {});
      return;
    }

    if (Platform.isIOS) {
      final InAppPurchaseStoreKitPlatformAddition iosPlatformAddition =
          _inAppPurchase
              .getPlatformAddition<InAppPurchaseStoreKitPlatformAddition>();
      await iosPlatformAddition.setDelegate(ExamplePaymentQueueDelegate());
    }

    final ProductDetailsResponse productDetailResponse =
        await _inAppPurchase.queryProductDetails(_kProductIds.toSet());
    if (productDetailResponse.error != null) {
      setState(() {});
      return;
    }

    if (productDetailResponse.productDetails.isEmpty) {
      setState(() {});
      return;
    }
    setState(() {});
  }

  Future<void> _initInAppPurchase() async {
    printLog(
        "_initInAppPurchase _kProductIds ============> ${_kProductIds[0].toString()}");
    final ProductDetailsResponse response =
        await InAppPurchase.instance.queryProductDetails(_kProductIds.toSet());
    if (response.notFoundIDs.isNotEmpty) {
      Utils().showToast("Please check SKU");
      return;
    }
    printLog("productID ============> ${response.productDetails[0].id}");
    late PurchaseParam purchaseParam;
    if (Platform.isAndroid) {
      purchaseParam =
          GooglePlayPurchaseParam(productDetails: response.productDetails[0]);
    } else {
      purchaseParam = PurchaseParam(productDetails: response.productDetails[0]);
    }
    _inAppPurchase.buyNonConsumable(purchaseParam: purchaseParam);
  }

  Future<void> _listenToPurchaseUpdated(
      List<PurchaseDetails> purchaseDetailsList) async {
    for (final PurchaseDetails purchaseDetails in purchaseDetailsList) {
      if (purchaseDetails.status == PurchaseStatus.pending) {
        showPendingUI();
      } else {
        if (purchaseDetails.status == PurchaseStatus.error) {
          printLog(
              "purchaseDetails ============> ${purchaseDetails.error.toString()}");
          handleError(purchaseDetails.error!);
        } else if (purchaseDetails.status == PurchaseStatus.purchased ||
            purchaseDetails.status == PurchaseStatus.restored) {
          printLog("===> status ${purchaseDetails.status}");
          final bool valid = await _verifyPurchase(purchaseDetails);
          if (valid) {
            deliverProduct(purchaseDetails);
          } else {
            _handleInvalidPurchase(purchaseDetails);
            return;
          }
        }
        if (Platform.isAndroid) {
          if (!_kAutoConsume && purchaseDetails.productID == _kProductIds[0]) {
            final InAppPurchaseAndroidPlatformAddition androidAddition =
                _inAppPurchase.getPlatformAddition<
                    InAppPurchaseAndroidPlatformAddition>();
            await androidAddition.consumePurchase(purchaseDetails);
          }
        }
        if (purchaseDetails.pendingCompletePurchase) {
          printLog(
              "===> pendingCompletePurchase ${purchaseDetails.pendingCompletePurchase}");
          await _inAppPurchase.completePurchase(purchaseDetails);
        }
      }
    }
  }

  Future<void> deliverProduct(PurchaseDetails purchaseDetails) async {
    printLog("===> productID ${purchaseDetails.productID}");
    if (purchaseDetails.productID == _kProductIds[0]) {
      if (widget.payType == "cart") {
        buyCourse();
      } else if (widget.payType == "book_session") {
        bookSession();
      } else if (widget.payType == "Package") {
        addPackageTransaction();
      } else {
        printLog("No API");
      }
      if (mounted) {
        setState(() {});
      }
    } else {
      printLog("===> consumables else $purchaseDetails");
      if (mounted) {
        setState(() {
          _purchases.add(purchaseDetails);
        });
      }
    }
  }

  void showPendingUI() {
    setState(() {});
  }

  void handleError(IAPError error) {
    setState(() {});
  }

  Future<bool> _verifyPurchase(PurchaseDetails purchaseDetails) {
    return Future<bool>.value(true);
  }

  void _handleInvalidPurchase(PurchaseDetails purchaseDetails) {
    printLog("invalid Purchase ===> $purchaseDetails");
  }
  /* ********* InApp purchase END ********* */

  /* ********* Razorpay START ********* */
  void _initializeRazorpay() {
    // if (subscriptionProvider.paymentOptionModel.result?.razorpay != null) {
    //   /* Check Keys */
    //   bool isContinue = checkKeysAndContinue(
    //     isBothKeyReq: false,
    //     isLive:
    //         (subscriptionProvider.paymentOptionModel.result?.razorpay?.isLive ??
    //             ""),
    //     key1: (subscriptionProvider.paymentOptionModel.result?.razorpay?.key1 ??
    //         ""),
    //     key2: "",
    //   );
    //   if (!isContinue) return;
    //   /* Check Keys */

    //   Razorpay razorpay = Razorpay();
    //   var options = {
    //     'key': subscriptionProvider.paymentOptionModel.result?.razorpay?.key1 ??
    //         "",
    //     'currency': Constant.currency,
    //     'amount': (double.parse(subscriptionProvider.finalAmount ?? "") * 100),
    //     'name': "Test",
    //     'description': "Test",
    //     'retry': {'enabled': true, 'max_count': 1},
    //     'send_sms_hash': true,
    //     'prefill': {'contact': userMobileNo, 'email': userEmail},
    //     'external': {
    //       'wallets': ['paytm']
    //     }
    //   };
    //   razorpay.on(Razorpay.EVENT_PAYMENT_ERROR, handlePaymentErrorResponse);
    //   razorpay.on(Razorpay.EVENT_PAYMENT_SUCCESS, handlePaymentSuccessResponse);
    //   razorpay.on(Razorpay.EVENT_EXTERNAL_WALLET, handleExternalWalletSelected);

    //   try {
    //     razorpay.open(options);
    //   } catch (e) {
    //     debugPrint('Razorpay Error :=========> $e');
    //   }
    // } else {
    //   Utils.showSnackbar(context, "info", "payment_not_processed", true);
    // }
  }

  // void handlePaymentErrorResponse(PaymentFailureResponse response) async {
  //   /*
  //   * PaymentFailureResponse contains three values:
  //   * 1. Error Code
  //   * 2. Error Description
  //   * 3. Metadata
  //   * */
  //   Utils.showSnackbar(context, "fail", "payment_fail", true);
  //   await subscriptionProvider.setCurrentPayment("");
  // }

  // void handlePaymentSuccessResponse(PaymentSuccessResponse response) {
  //   /*
  //   * Payment Success Response contains three values:
  //   * 1. Order ID
  //   * 2. Payment ID
  //   * 3. Signature
  //   * */
  //   // paymentId = response.paymentId;
  //   debugPrint("paymentId ========> $paymentId");
  //   if (widget.payType == "cart") {
  //     buyCourse();
  //   } else if (widget.payType == "book_session") {
  //     bookSession();
  //   } else if (widget.payType == "Package") {
  //     addPackageTransaction();
  //   } else {
  //     addContentTransaction(
  //       widget.contentType ?? "",
  //       widget.itemId,
  //       widget.itemTitle,
  //       subscriptionProvider.finalAmount,
  //       paymentId,
  //     );
  //   }
  // }

  // void handleExternalWalletSelected(ExternalWalletResponse response) {
  //   debugPrint("============ External Wallet Selected ============");
  // }

  /* ********* Razorpay END ********* */

  /* ********* Paypal START ********* */
  Future<void> _paypalInit() async {
    if (subscriptionProvider.paymentOptionModel.result?.paypal != null) {
      /* Check Keys */
      bool isContinue = checkKeysAndContinue(
        isLive:
            (subscriptionProvider.paymentOptionModel.result?.paypal?.isLive ??
                ""),
        isBothKeyReq: true,
        key1: (subscriptionProvider.paymentOptionModel.result?.paypal?.key1 ??
            ""),
        key2: (subscriptionProvider.paymentOptionModel.result?.paypal?.key2 ??
            ""),
      );
      if (!isContinue) return;
      /* Check Keys */

      Navigator.of(context).push(
        MaterialPageRoute(
          builder: (BuildContext context) => PaypalCheckoutView(
              sandboxMode: (subscriptionProvider
                              .paymentOptionModel.result?.paypal?.isLive ??
                          "") ==
                      "1"
                  ? false
                  : true,
              clientId: subscriptionProvider
                      .paymentOptionModel.result?.paypal?.key1 ??
                  "",
              secretKey: subscriptionProvider
                      .paymentOptionModel.result?.paypal?.key2 ??
                  "",
              transactions: [
                {
                  "amount": {
                    "total": '${subscriptionProvider.finalAmount}',
                    "currency": Constant.currency,
                    "details": {
                      "subtotal": '${subscriptionProvider.finalAmount}',
                      "shipping": '0',
                      "shipping_discount": 0
                    }
                  },
                  "description": "Order ",
                  "item_list": {
                    "items": [
                      {
                        "name": "Service Booking",
                        "quantity": 1,
                        "price": '${subscriptionProvider.finalAmount}',
                        "currency": Constant.currency
                      }
                    ],
                  }
                }
              ],
              note: "Contact us for any questions on your order.",
              onSuccess: (params) async {
                printLog("onSuccess: ${params["paymentId"]}");
                if (widget.payType == "cart") {
                  buyCourse();
                } else if (widget.payType == "book_session") {
                  bookSession();
                } else if (widget.payType == "Package") {
                  addPackageTransaction();
                } else {
                  printLog("No API");
                }
              },
              onError: (params) {
                printLog("onError: ${params["message"]}");
                Utils.showSnackbar(
                    context, "fail", params["message"].toString(), false);
              },
              onCancel: (params) {
                printLog('cancelled: $params');
                Utils.showSnackbar(context, "fail", params.toString(), false);
              }),
        ),
      );
    } else {
      Utils.showSnackbar(context, "", "payment_not_processed", true);
    }
  } /* ********* Paypal END ********* */

  /* ********* Stripe START ********* */
  Future createCustomer() async {
    try {
      var body = {
        "email": userEmail,
        "name": userName,
        "phone": userMobileNo,
      };

      //final response  = await http.post(Uri.parse("https://api.stripe.com/v1/customers"),
      final response = await http.post(
        Uri.parse("https://api.stripe.com/v1/customers"),
        headers: {
          "Content-Type": "application/x-www-form-urlencoded",
          "Authorization":
              "Bearer ${subscriptionProvider.paymentOptionModel.result?.stripe?.key2}",
        },
        body: body,
      );
      printLog('createCustomer jsonDecode :=> ${jsonDecode(response.body)}');
      return jsonDecode(response.body);
    } catch (err) {
      printLog('createCustomer Error :=> ${err.toString()}');
      return null;
    }
  }

  Future<void> _stripeInit() async {
    if (subscriptionProvider.paymentOptionModel.result?.stripe != null) {
      /* Check Keys */
      bool isContinue = checkKeysAndContinue(
        isLive:
            (subscriptionProvider.paymentOptionModel.result?.stripe?.isLive ??
                ""),
        isBothKeyReq: true,
        key1: (subscriptionProvider.paymentOptionModel.result?.stripe?.key1 ??
            ""),
        key2: (subscriptionProvider.paymentOptionModel.result?.stripe?.key2 ??
            ""),
      );
      if (!isContinue) return;
      /* Check Keys */

      stripe.Stripe.publishableKey =
          subscriptionProvider.paymentOptionModel.result?.stripe?.key1 ?? "";

      if (kIsWeb) {
        /* ******* INITIALIZE VALUES ******* */
        Constant.publishableKey =
            (subscriptionProvider.paymentOptionModel.result?.stripe?.key1 ??
                "");
        Constant.secretKey =
            (subscriptionProvider.paymentOptionModel.result?.stripe?.key2 ??
                "");
        // Constant.packagePriceId = subscriptionProvider.productPackage ?? "";
        Constant.successURL = '${Constant.webDomainURL}#/success';
        Constant.cancelURL = '${Constant.webDomainURL}#/cancel';
        printLog("publishableKey ==> ${Constant.publishableKey}");
        printLog("secretKey =======> ${Constant.secretKey}");
        printLog("packagePriceId ==> ${Constant.packagePriceId}");
        printLog("successURL ======> ${Constant.successURL}");
        printLog("cancelURL =======> ${Constant.cancelURL}");
        /* ******* INITIALIZE VALUES ******* */

        // redirectToCheckout(context);
      } else {
        try {
          final customerData = await createCustomer();
          printLog("customerData =====> $customerData");

          //STEP 1: Create Payment Intent
          paymentIntent = await createPaymentIntent(
              subscriptionProvider.finalAmount ?? "", Constant.currency);

          //STEP 2: Initialize Payment Sheet
          if (!mounted) return;
          await stripe.Stripe.instance
              .initPaymentSheet(
                  paymentSheetParameters: stripe.SetupPaymentSheetParameters(
                billingDetailsCollectionConfiguration:
                    const stripe.BillingDetailsCollectionConfiguration(
                  attachDefaultsToPaymentMethod: true,
                  address: stripe.AddressCollectionMode.automatic,
                  name: stripe.CollectionMode.always,
                  email: stripe.CollectionMode.always,
                  phone: stripe.CollectionMode.always,
                ),
                paymentIntentClientSecret: paymentIntent?['client_secret'],
                style: ThemeMode.light,
                merchantDisplayName: Locales.string(context, "appname"),
                customerId: customerData['id'],
                billingDetails: stripe.BillingDetails(
                  email: userEmail,
                  phone: userMobileNo,
                  name: userName,
                ),
              ))
              .then((value) {});

          //STEP 3: Display Payment sheet
          displayPaymentSheet();
        } catch (err) {
          printLog("_stripeInit Error =====> ${err.toString()}");
        }
      }
    } else {
      Utils.showSnackbar(context, "", "payment_not_processed", true);
    }
  }

  dynamic createPaymentIntent(String amount, String currency) async {
    try {
      //Request body
      Map<String, dynamic> body = {
        'amount': calculateAmount(amount),
        'currency': currency,
        'description': "Service Data",
      };

      //Make post request to Stripe
      var response = await http.post(
        Uri.parse('https://api.stripe.com/v1/payment_intents'),
        headers: {
          'Authorization':
              'Bearer ${subscriptionProvider.paymentOptionModel.result?.stripe?.key2 ?? ""}',
          'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: body,
      );
      return json.decode(response.body);
    } catch (err) {
      throw Exception(err.toString());
    }
  }

  dynamic calculateAmount(String amount) {
    final calculatedAmout = (int.parse(amount)) * 100;
    return calculatedAmout.toString();
  }

  Future<void> displayPaymentSheet() async {
    try {
      await stripe.Stripe.instance.presentPaymentSheet().then((value) {
        if (!mounted) return;
        Utils.showSnackbar(context, "success", "payment_success", true);
        if (widget.payType == "cart") {
          buyCourse();
        } else if (widget.payType == "book_session") {
          bookSession();
        } else if (widget.payType == "Package") {
          addPackageTransaction();
        } else {
          printLog("No API");
        }
        paymentIntent = null;
      }).onError((error, stackTrace) {
        throw Exception(error);
      });
    } on stripe.StripeException catch (e) {
      printLog('Error is:---> $e');
      if (!mounted) return;
      Utils.showSnackbar(context, "fail", "payment_fail", true);
    } catch (e) {
      printLog('$e');
    }
  }

  /* ********* Stripe END ********* */

  /* ********* Flutterwave START ********* */
  Future<void> _flutterwaveInit() async {
/* Check Keys */
    bool isContinue = checkKeysAndContinue(
      isLive:
          subscriptionProvider.paymentOptionModel.result?.flutterwave?.isLive ??
              "",
      isBothKeyReq: false,
      key1: subscriptionProvider.paymentOptionModel.result?.flutterwave?.key1 ??
          "",
      key2: "",
    );
    if (!isContinue) return;
/* Check Keys */

    final Customer customer = Customer(
        email: userEmail ?? "",
        name: userName ?? "",
        phoneNumber: userMobileNo ?? '');

    final Flutterwave flutterwave = Flutterwave(
      context: context,
      publicKey:
          subscriptionProvider.paymentOptionModel.result?.flutterwave?.key1 ??
              "",
      currency: Constant.currency,
      redirectUrl: 'https://www.divinetechs.com',
      txRef: const Uuid().v1(),
      amount: subscriptionProvider.finalAmount.toString().trim(),
      customer: customer,
      paymentOptions: "card, payattitude, barter, bank transfer, ussd",
      customization: Customization(title: widget.itemTitle),
      isTestMode:
          subscriptionProvider.paymentOptionModel.result?.flutterwave?.isLive !=
              "1",
    );
    ChargeResponse? response = await flutterwave.charge();
    printLog("Flutterwave response =====> ${response.toJson()}");
    if ((response.status == "success" ||
            response.status == "successful" ||
            (response.status ?? "").contains("success")) &&
        response.success == true) {
      paymentId = response.transactionId.toString();
      printLog("paymentId ========> $paymentId");
      if (!mounted) return;
      Utils.showSnackbar(context, "success", "payment_success", true);

      if (widget.payType == "cart") {
        buyCourse();
      } else if (widget.payType == "book_session") {
        bookSession();
      } else if (widget.payType == "Package") {
        addPackageTransaction();
      } else {
        printLog("No API");
      }
    } else if (response.status == "cancel" && response.status == "cancelled") {
      if (!mounted) return;
      Utils.showSnackbar(context, "info", "payment_cancel", true);
    } else {
      if (!mounted) return;
      Utils.showSnackbar(context, "fail", "payment_fail", true);
    }
  }

/* ********* Flutterwave END ********* */

  Future<bool> onBackPressed() async {
    if (!mounted) return Future.value(false);
    Navigator.pop(context, isPaymentDone);
    return Future.value(isPaymentDone == true ? true : false);
  }
}

class ExamplePaymentQueueDelegate implements SKPaymentQueueDelegateWrapper {
  @override
  bool shouldContinueTransaction(
      SKPaymentTransactionWrapper transaction, SKStorefrontWrapper storefront) {
    return true;
  }

  @override
  bool shouldShowPriceConsent() {
    return false;
  }
}
