import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/coursedetailsprovider.dart';
import 'package:prakah/provider/quizeprovider.dart';
import 'package:prakah/quize/leaderboard.dart';
import 'package:prakah/utils/utils.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:auto_size_text/auto_size_text.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:provider/provider.dart';

class Quize extends StatefulWidget {
  final int? courseId, chapterId;

  const Quize({
    super.key,
    required this.courseId,
    required this.chapterId,
  });

  @override
  State<Quize> createState() => _QuizeState();
}

class _QuizeState extends State<Quize> {
  SharedPre sharePref = SharedPre();
  late QuizeProvider quizeProvider;
  late CourseDetailsProvider courseDetailsProvider;
  final PageController _pageController = PageController(initialPage: 0);
  int pageIndex = 0;

  @override
  void initState() {
    quizeProvider = Provider.of<QuizeProvider>(context, listen: false);
    courseDetailsProvider =
        Provider.of<CourseDetailsProvider>(context, listen: false);
    super.initState();
    getQuestionList();
  }

  Future<void> getQuestionList() async {
    await quizeProvider.getQuestionByChapter(
        widget.courseId.toString(), widget.chapterId);
  }

  Future<void> getDetailPage() async {
    await courseDetailsProvider.getCourseDetails(widget.courseId);
  }

  @override
  void dispose() {
    getDetailPage();
    quizeProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      // backgroundColor: white,
      appBar: kIsWeb
          ? Utils.webMainAppbar()
          : PreferredSize(
              preferredSize: const Size.fromHeight(60.0),
              child: AppBar(
                elevation: 0,
                centerTitle: false,
                // backgroundColor: white,
                title: MyText(
                  multilanguage: true,
                  text: "quizelession",
                  fontsizeWeb: Dimens.textMedium,
                  fontsizeNormal: Dimens.textMedium,
                  fontwaight: FontWeight.w500,
                  color: Theme.of(context).colorScheme.surface,
                ),
                leading: InkWell(
                  onTap: () {
                    Navigator.of(context).pop(false);
                  },
                  child: Icon(
                    Icons.arrow_back_ios_new_outlined,
                    size: 20,
                    color: black,
                  ),
                ),
              ),
            ),
      body: Consumer<QuizeProvider>(builder: (context, quizeprovider, child) {
        if (quizeProvider.loading) {
          return Utils.pageLoader();
        } else {
          if (quizeprovider.getQuestionByChapterModel.status == 200 &&
              quizeprovider.getQuestionByChapterModel.result != null) {
            if ((quizeprovider.getQuestionByChapterModel.result?.length ?? 0) >
                0) {
              return questionAndOption();
            } else {
              return const NoData();
            }
          } else {
            return const NoData();
          }
        }
      }),
      bottomNavigationBar: Container(
        alignment: Alignment.center,
        height: 100,
        child: nextPage(),
      ),
    );
  }

  Widget questionAndOption() {
    return Align(
      alignment: Alignment.center,
      child: SizedBox(
        width: kIsWeb ? 500 : null,
        child: PageView.builder(
            controller: _pageController,
            itemCount:
                quizeProvider.getQuestionByChapterModel.result?.length ?? 0,
            physics: const NeverScrollableScrollPhysics(),
            onPageChanged: (int page) {},
            scrollDirection: Axis.horizontal,
            allowImplicitScrolling: true,
            itemBuilder: (context, index) {
              return Container(
                width: MediaQuery.of(context).size.width,
                padding: const EdgeInsets.all(20),
                margin: const EdgeInsets.all(20),
                decoration: BoxDecoration(
                  color: gray.withValues(alpha: 0.15),
                  borderRadius: BorderRadius.circular(15),
                ),
                child: SingleChildScrollView(
                  scrollDirection: Axis.vertical,
                  physics: const AlwaysScrollableScrollPhysics(),
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      MyText(
                        multilanguage: false,
                        fontstyle: FontStyle.normal,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        text:
                            "${index + 1} of ${quizeProvider.getQuestionByChapterModel.result?.length ?? 0} Questions",
                        color: Theme.of(context).colorScheme.surface,
                        fontwaight: FontWeight.w400,
                        fontsizeNormal: Dimens.textSmall,
                        fontsizeWeb: Dimens.textSmall,
                      ),
                      const SizedBox(height: 8),
                      AutoSizeText(
                        "Q ${index + 1}. ${quizeProvider.getQuestionByChapterModel.result?[index].question.toString() ?? ""}?",
                        style: GoogleFonts.inter(
                            fontSize: Dimens.textTitle,
                            color: Theme.of(context).colorScheme.surface,
                            fontWeight: FontWeight.w700),
                        minFontSize: Dimens.textSmall,
                        textAlign: TextAlign.left,
                        // maxLines: 10,
                        // overflow: TextOverflow.ellipsis,
                      ),
                      quizeProvider.getQuestionByChapterModel.result?[index]
                                  .note ==
                              ""
                          ? const SizedBox.shrink()
                          : Padding(
                              padding: const EdgeInsets.fromLTRB(0, 10, 0, 10),
                              child: AutoSizeText(
                                "Note: ${quizeProvider.getQuestionByChapterModel.result?[index].note.toString() ?? ""}?",
                                style: GoogleFonts.inter(
                                    fontSize: Dimens.textSmall,
                                    color: red,
                                    fontWeight: FontWeight.w500),
                                minFontSize: Dimens.textSmall,
                                textAlign: TextAlign.left,
                                // maxLines: 10,
                                // overflow: TextOverflow.ellipsis,
                              ),
                            ),
                      const SizedBox(height: 30),
                      /* Option A */
                      InkWell(
                        focusColor: transparent,
                        splashColor: transparent,
                        highlightColor: transparent,
                        hoverColor: transparent,
                        onTap: () async {
                          if (quizeProvider.isSelectAns == false) {
                            quizeProvider.checkAnswer(
                              type: "1",
                              option: quizeProvider.getQuestionByChapterModel
                                      .result?[index].optionA
                                      .toString() ??
                                  "",
                              rightAns: quizeProvider.getQuestionByChapterModel
                                      .result?[index].answer
                                      .toString() ??
                                  "",
                              isSelect: true,
                            );
                          }
                        },
                        child: Container(
                          padding: const EdgeInsets.fromLTRB(10, 22, 10, 22),
                          margin: const EdgeInsets.fromLTRB(0, 0, 0, 20),
                          decoration: BoxDecoration(
                            color: (quizeProvider.optionType == "1" &&
                                    quizeProvider.isSelectAns == true)
                                ? quizeProvider.rightAnswer == true
                                    ? green
                                    : red
                                : Theme.of(context).cardColor,
                            borderRadius: BorderRadius.circular(5),
                          ),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Expanded(
                                child: AutoSizeText(
                                  quizeProvider.getQuestionByChapterModel
                                          .result?[index].optionA
                                          .toString() ??
                                      "",
                                  style: GoogleFonts.inter(
                                      fontSize: Dimens.textDesc,
                                      color: (quizeProvider.optionType == "1" &&
                                              quizeProvider.isSelectAns == true)
                                          ? white
                                          : Theme.of(context)
                                              .colorScheme
                                              .surface,
                                      fontWeight: FontWeight.w400),
                                  minFontSize: Dimens.textSmall,
                                  textAlign: TextAlign.left,
                                  // maxLines: 5,
                                  // overflow: TextOverflow.ellipsis,
                                ),
                              ),
                              (quizeProvider.optionType == "1" &&
                                      quizeProvider.isSelectAns == true)
                                  ? quizeProvider.rightAnswer == true
                                      ? const Icon(Icons.check,
                                          size: 22, color: white)
                                      : const Icon(Icons.close,
                                          size: 22, color: white)
                                  : const SizedBox.shrink(),
                            ],
                          ),
                        ),
                      ),

                      /* Option B */
                      InkWell(
                        focusColor: transparent,
                        splashColor: transparent,
                        highlightColor: transparent,
                        hoverColor: transparent,
                        onTap: () async {
                          if (quizeProvider.isSelectAns == false) {
                            quizeProvider.checkAnswer(
                              type: "2",
                              option: quizeProvider.getQuestionByChapterModel
                                      .result?[index].optionB
                                      .toString() ??
                                  "",
                              rightAns: quizeProvider.getQuestionByChapterModel
                                      .result?[index].answer
                                      .toString() ??
                                  "",
                              isSelect: true,
                            );
                          }
                        },
                        child: Container(
                          padding: const EdgeInsets.fromLTRB(10, 22, 10, 22),
                          margin: const EdgeInsets.fromLTRB(0, 0, 0, 20),
                          decoration: BoxDecoration(
                            color: (quizeProvider.optionType == "2" &&
                                    quizeProvider.isSelectAns == true)
                                ? quizeProvider.rightAnswer == true
                                    ? green
                                    : red
                                : Theme.of(context).cardColor,
                            borderRadius: BorderRadius.circular(5),
                          ),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Expanded(
                                child: AutoSizeText(
                                  quizeProvider.getQuestionByChapterModel
                                          .result?[index].optionB
                                          .toString() ??
                                      "",
                                  style: GoogleFonts.inter(
                                      fontSize: Dimens.textDesc,
                                      color: (quizeProvider.optionType == "2" &&
                                              quizeProvider.isSelectAns == true)
                                          ? white
                                          : Theme.of(context)
                                              .colorScheme
                                              .surface,
                                      fontWeight: FontWeight.w400),
                                  minFontSize: Dimens.textSmall,
                                  textAlign: TextAlign.left,
                                  // maxLines: 5,
                                  // overflow: TextOverflow.ellipsis,
                                ),
                              ),
                              (quizeProvider.optionType == "2" &&
                                      quizeProvider.isSelectAns == true)
                                  ? quizeProvider.rightAnswer == true
                                      ? const Icon(Icons.check,
                                          size: 22, color: white)
                                      : const Icon(Icons.close,
                                          size: 22, color: white)
                                  : const SizedBox.shrink(),
                            ],
                          ),
                        ),
                      ),

                      /* Option C */
                      InkWell(
                        focusColor: transparent,
                        splashColor: transparent,
                        highlightColor: transparent,
                        hoverColor: transparent,
                        onTap: () async {
                          if (quizeProvider.isSelectAns == false) {
                            quizeProvider.checkAnswer(
                              type: "3",
                              option: quizeProvider.getQuestionByChapterModel
                                      .result?[index].optionC
                                      .toString() ??
                                  "",
                              rightAns: quizeProvider.getQuestionByChapterModel
                                      .result?[index].answer
                                      .toString() ??
                                  "",
                              isSelect: true,
                            );
                          }
                        },
                        child: Container(
                          padding: const EdgeInsets.fromLTRB(10, 22, 10, 22),
                          margin: const EdgeInsets.fromLTRB(0, 0, 0, 20),
                          decoration: BoxDecoration(
                            color: (quizeProvider.optionType == "3" &&
                                    quizeProvider.isSelectAns == true)
                                ? quizeProvider.rightAnswer == true
                                    ? green
                                    : red
                                : Theme.of(context).cardColor,
                            borderRadius: BorderRadius.circular(5),
                          ),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Expanded(
                                child: AutoSizeText(
                                  quizeProvider.getQuestionByChapterModel
                                          .result?[index].optionC
                                          .toString() ??
                                      "",
                                  style: GoogleFonts.inter(
                                      fontSize: Dimens.textDesc,
                                      color: (quizeProvider.optionType == "3" &&
                                              quizeProvider.isSelectAns == true)
                                          ? white
                                          : Theme.of(context)
                                              .colorScheme
                                              .surface,
                                      fontWeight: FontWeight.w400),
                                  minFontSize: Dimens.textSmall,
                                  textAlign: TextAlign.left,
                                  // maxLines: 1,
                                  // overflow: TextOverflow.ellipsis,
                                ),
                              ),
                              (quizeProvider.optionType == "3" &&
                                      quizeProvider.isSelectAns == true)
                                  ? quizeProvider.rightAnswer == true
                                      ? const Icon(Icons.check,
                                          size: 22, color: white)
                                      : const Icon(Icons.close,
                                          size: 22, color: white)
                                  : const SizedBox.shrink(),
                            ],
                          ),
                        ),
                      ),

                      /* Option D */
                      InkWell(
                        focusColor: transparent,
                        splashColor: transparent,
                        highlightColor: transparent,
                        hoverColor: transparent,
                        onTap: () async {
                          if (quizeProvider.isSelectAns == false) {
                            quizeProvider.checkAnswer(
                              type: "4",
                              option: quizeProvider.getQuestionByChapterModel
                                      .result?[index].optionD
                                      .toString() ??
                                  "",
                              rightAns: quizeProvider.getQuestionByChapterModel
                                      .result?[index].answer
                                      .toString() ??
                                  "",
                              isSelect: true,
                            );
                          }
                        },
                        child: Container(
                          padding: const EdgeInsets.fromLTRB(10, 22, 10, 22),
                          margin: const EdgeInsets.fromLTRB(0, 0, 0, 20),
                          decoration: BoxDecoration(
                            color: (quizeProvider.optionType == "4" &&
                                    quizeProvider.isSelectAns == true)
                                ? quizeProvider.rightAnswer == true
                                    ? green
                                    : red
                                : Theme.of(context).cardColor,
                            borderRadius: BorderRadius.circular(5),
                          ),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Expanded(
                                child: AutoSizeText(
                                  quizeProvider.getQuestionByChapterModel
                                          .result?[index].optionD
                                          .toString() ??
                                      "",
                                  style: GoogleFonts.inter(
                                      fontSize: Dimens.textDesc,
                                      color: (quizeProvider.optionType == "4" &&
                                              quizeProvider.isSelectAns == true)
                                          ? white
                                          : Theme.of(context)
                                              .colorScheme
                                              .surface,
                                      fontWeight: FontWeight.w400),
                                  minFontSize: Dimens.textSmall,
                                  textAlign: TextAlign.left,
                                  // maxLines: 1,
                                  // overflow: TextOverflow.ellipsis,
                                ),
                              ),
                              (quizeProvider.optionType == "4" &&
                                      quizeProvider.isSelectAns == true)
                                  ? quizeProvider.rightAnswer == true
                                      ? const Icon(Icons.check,
                                          size: 22, color: white)
                                      : const Icon(Icons.close,
                                          size: 22, color: white)
                                  : const SizedBox.shrink(),
                            ],
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
              );
            }),
      ),
    );
  }

  Widget nextPage() {
    return Container(
      width: kIsWeb ? MediaQuery.of(context).size.width : null,
      padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
      color: gray.withValues(alpha: 0.15),
      alignment: Alignment.center,
      child: InkWell(
        onTap: () async {
          if (quizeProvider.isSelectAns == true) {
            /* Pass This Atteded Question Count */
            quizeProvider.totalAttendedQuestion();
          }
          if (quizeProvider.pageIndex !=
              (quizeProvider.getQuestionByChapterModel.result?.length ?? 0) -
                  1) {
            quizeProvider.clearOnlySelectedAnswer();

            quizeProvider.setCurrentBanner(((quizeProvider.pageIndex) + 1));
            /* Attended  Question */

            _pageController.nextPage(
              duration: const Duration(milliseconds: 800),
              curve: Curves.linear,
            );
          } else {
            /* Open Scoore Page */
            await quizeProvider.getSavePraticeQuestionReport(
              courseId: widget.courseId.toString(),
              chapterId: widget.chapterId.toString(),
              totalQuestion:
                  (quizeProvider.getQuestionByChapterModel.result?.length ?? 0)
                      .toString(),
              questionsAttended: quizeProvider.attendedQuestion.toString(),
              correctAnswers: quizeProvider.rightAnsCount,
            );

            if (quizeProvider.saveQuestionReportModel.status == 200) {
              try {
                if (!mounted) return;
                Navigator.of(context).pushReplacement(
                  PageRouteBuilder(
                    transitionDuration: const Duration(milliseconds: 200),
                    pageBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation) {
                      return LeaderBoard(
                        courseId: widget.courseId,
                        chapterId: widget.chapterId,
                        percentage: quizeProvider.saveQuestionReportModel
                                .result?[0].percentage ??
                            0,
                      );
                    },
                    transitionsBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation,
                        Widget child) {
                      return Align(
                        child: FadeTransition(
                          opacity: animation,
                          child: child,
                        ),
                      );
                    },
                  ),
                );
              } catch (e) {
                printLog("catch");
                printLog(e.toString());
              }
            } else {
              if (!mounted) return;
              Utils().hideProgress(context);
              Utils.showSnackbar(context, "fail",
                  quizeProvider.saveQuestionReportModel.message ?? "", false);
            }
          }
        },
        child: Container(
          height: 50,
          width: kIsWeb && MediaQuery.of(context).size.width > 800
              ? 500
              : MediaQuery.of(context).size.width,
          alignment: Alignment.center,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(50),
            color: colorPrimary,
          ),
          child: MyText(
            multilanguage: true,
            text: (quizeProvider.pageIndex !=
                    (quizeProvider.getQuestionByChapterModel.result?.length ??
                            0) -
                        1)
                ? "next"
                : "gotoleaderboard",
            color: white,
            fontwaight: FontWeight.w700,
            fontsizeNormal: Dimens.textTitle,
            fontsizeWeb: Dimens.textTitle,
          ),
        ),
      ),
    );
  }
}
