import 'package:prakah/model/successModel.dart';
import 'package:prakah/model/commanmodel.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';
import 'package:prakah/utils/utils.dart';

class WishlistProvider extends ChangeNotifier {
  /* Wishlist Fields */
  CommanModel wishlistmodel = CommanModel();
  List<Result>? wishList = [];
  bool loading = false, loadMore = false;
  int? totalRows, totalPage, currentPage;
  bool? isMorePage;

  int position = 0;
  bool deleteWishlistloading = false;
  SuccessModel successModel = SuccessModel();

  /* Select Layout */
  String layoutType = Constant.courseType;

  Future<void> getWishList(String type, pageno) async {
    loading = true;
    wishlistmodel = await ApiService().wishlist(type, pageno);
    if (wishlistmodel.status == 200) {
      setPaginationData(wishlistmodel.totalRows, wishlistmodel.totalPage,
          wishlistmodel.currentPage, wishlistmodel.morePage);
      if (wishlistmodel.result != null &&
          (wishlistmodel.result?.length ?? 0) > 0) {
        printLog("wishlist length :==> ${(wishlistmodel.result?.length ?? 0)}");
        printLog('Now on page ==========> $currentPage');
        if (wishlistmodel.result != null &&
            (wishlistmodel.result?.length ?? 0) > 0) {
          printLog(
              "wishlist length :==> ${(wishlistmodel.result?.length ?? 0)}");
          for (var i = 0; i < (wishlistmodel.result?.length ?? 0); i++) {
            wishList?.add(wishlistmodel.result?[i] ?? Result());
          }
          final Map<int, Result> postMap = {};
          wishList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          wishList = postMap.values.toList();
          printLog("wishlist length :==> ${(wishList?.length ?? 0)}");
          setLoadMore(false);
        }
      }
    }
    loading = false;
    notifyListeners();
  }

  void setPaginationData(
      int? totalRows, int? totalPage, int? currentPage, bool? morePage) {
    this.currentPage = currentPage;
    this.totalRows = totalRows;
    this.totalPage = totalPage;
    isMorePage = morePage;
    notifyListeners();
  }

  void setLoadMore(bool loadMore) {
    this.loadMore = loadMore;
    notifyListeners();
  }

/* Add Remove Wishlist Api */

  Future<void> addremoveWatchLater(String type, index, contentId) async {
    position = index;
    removeWishList(true);
    successModel = await ApiService().addRemoveWishlist(type, contentId);
    removeWishList(false);
    wishList?.removeAt(index);
  }

  void removeWishList(bool isSending) {
    deleteWishlistloading = isSending;
    notifyListeners();
  }

/* Chnage Tab */
  Future<void> selectLayout(String type) async {
    layoutType = type;
    notifyListeners();
  }

  Future<void> getAddToCart(int index, contentId) async {
    if ((wishList?[0].isCart ?? 0) == 0) {
      wishList?[0].isCart = 1;
    } else {
      wishList?[0].isCart = 0;
    }
    notifyListeners();
    successModel = await ApiService().addToCartCourse(contentId);
  }

  Future<void> getRemoveCart(String contentId) async {
    notifyListeners();
    successModel = await ApiService().removeToCartCourse(contentId);
  }

  void clearWishList() {
    wishlistmodel = CommanModel();
    wishList?.clear();
    wishList = [];
    loading = false;
    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
  }

/* Clear Provider */

  void clearProvider() {
    /* Wishlist Fields */
    wishlistmodel = CommanModel();
    wishList = [];
    loading = false;
    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
    /* Select Layout */
    layoutType = Constant.courseType;
    position = 0;
    deleteWishlistloading = false;
    successModel = SuccessModel();
  }
}
