import 'package:prakah/model/classhistorydetailsmodel.dart';
import 'package:prakah/model/viewseriesmodel.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class ViewSeriesProvider extends ChangeNotifier {
  ViewSeriesModel viewSeriesModel = ViewSeriesModel();

  ClassHistoryDetailsModel classHistoryDetailsModel =
      ClassHistoryDetailsModel();

  bool loading = false;

  void setLoadin(bool isLoding) {
    loading = isLoding;
    notifyListeners();
  }

  Future<void> getEbooks(String liveClassId) async {
    loading = true;
    viewSeriesModel = await ApiService().viewSeriesResponse(liveClassId);
    loading = false;
    notifyListeners();
  }

  Future<void> getHistroyDetails(String attendingLiveclassId) async {
    loading = true;
    classHistoryDetailsModel =
        await ApiService().classHistoryDetailsResponse(attendingLiveclassId);
    loading = false;
    notifyListeners();
  }

  void clearProvider() {
    viewSeriesModel = ViewSeriesModel();
    classHistoryDetailsModel = ClassHistoryDetailsModel();
    loading = false;
  }
}
