import 'package:prakah/model/viewsessionmodel.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class ViewDetailsProvider extends ChangeNotifier {
  ViewSessionModel viewSessionModel = ViewSessionModel();
  bool viewSessionLoading = false;
  Future<void> getViewSession(String appointmentId) async {
    viewSessionLoading = true;
    viewSessionModel = await ApiService().viewSessionData(appointmentId);
    viewSessionLoading = false;
    notifyListeners();
  }

  void clearProvider() {
    viewSessionModel = ViewSessionModel();
    viewSessionLoading = false;
  }
}
