import 'package:prakah/model/successModel.dart';
import 'package:prakah/model/commanmodel.dart';
import 'package:prakah/model/commanmodel.dart' as courselist;
import 'package:prakah/model/tutorprofilemodel.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:prakah/utils/utils.dart';
import 'package:flutter/material.dart';

class TutorProfileProvider extends ChangeNotifier {
  /* Tutor Profile */
  Tutorprofilemodel tutorprofilemodel = Tutorprofilemodel();
  bool loading = false;
  SuccessModel successModel = SuccessModel();
  /* Tutor Course List */
  CommanModel courselistbytutoridModel = CommanModel();
  List<courselist.Result>? courseList = [];
  bool loadMore = false, tutorContentLoading = false;
  int? totalRows, totalPage, currentPage;
  bool? isMorePage;

  /* Select Layout */
  String layoutType = Constant.blogType;

/* Tutor Profile */

  void setLoading(bool isLoading) {
    loading = isLoading;
    tutorContentLoading = isLoading;
    notifyListeners();
  }

  Future<void> getTutorprofile(String tutorId) async {
    loading = true;
    tutorprofilemodel = await ApiService().tutorprofile(tutorId);
    loading = false;
    notifyListeners();
  }

  Future<void> getContentByTutor(String type, tutorId, pageNo) async {
    tutorContentLoading = true;
    courselistbytutoridModel =
        await ApiService().getContentByTutor(type, tutorId, pageNo);
    if (courselistbytutoridModel.status == 200) {
      setPaginationData(
          courselistbytutoridModel.totalRows,
          courselistbytutoridModel.totalPage,
          courselistbytutoridModel.currentPage,
          courselistbytutoridModel.morePage);
      if (courselistbytutoridModel.result != null &&
          (courselistbytutoridModel.result?.length ?? 0) > 0) {
        printLog(
            "courseList length :==> ${(courselistbytutoridModel.result?.length ?? 0)}");
        printLog('Now on page ==========> $currentPage');
        if (courselistbytutoridModel.result != null &&
            (courselistbytutoridModel.result?.length ?? 0) > 0) {
          printLog(
              "courseList length :==> ${(courselistbytutoridModel.result?.length ?? 0)}");
          for (var i = 0;
              i < (courselistbytutoridModel.result?.length ?? 0);
              i++) {
            courseList?.add(
                courselistbytutoridModel.result?[i] ?? courselist.Result());
          }
          final Map<int, courselist.Result> postMap = {};
          courseList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          courseList = postMap.values.toList();
          printLog("courseList length :==> ${(courseList?.length ?? 0)}");
          setLoadMore(false);
        }
      }
    }
    tutorContentLoading = false;
    notifyListeners();
  }

  void setPaginationData(
      int? totalRows, int? totalPage, int? currentPage, bool? morePage) {
    this.currentPage = currentPage;
    this.totalRows = totalRows;
    this.totalPage = totalPage;
    isMorePage = morePage;
    notifyListeners();
  }

  void setLoadMore(bool loadMore) {
    this.loadMore = loadMore;
    notifyListeners();
  }

  Future<void> selectLayout(String type) async {
    layoutType = type;
    notifyListeners();
  }

  /* Product Like Dislike */
  Future<void> addRemoveWishlist(int index, type, contentId) async {
    if ((courseList?[index].isWishlist ?? 0) == 0) {
      courseList?[index].isWishlist = 1;
    } else {
      courseList?[index].isWishlist = 0;
    }
    notifyListeners();
    addremoveWishList(type, contentId);
  }

  Future<void> addremoveWishList(String type, contentId) async {
    successModel = await ApiService().addRemoveWishlist(type, contentId);
  }

  void clearContent() {
    courselistbytutoridModel = CommanModel();
    tutorContentLoading = false;
    courseList = [];
    courseList?.clear();
    tutorContentLoading = false;
    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
  }

  /* Clear Provider */

  void clearProvider() {
    /* Tutor Profile */
    tutorprofilemodel = Tutorprofilemodel();
    loading = false;
    tutorContentLoading = false;
    /* Tutor Course List */
    courselistbytutoridModel = CommanModel();
    courseList = [];
    courseList?.clear();
    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
    layoutType = Constant.blogType;
    successModel = SuccessModel();
  }
}
