import 'package:prakah/model/transcationlistmodel.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class TransactionListProvider extends ChangeNotifier {
  TransactionListModel transactionListModel = TransactionListModel();
  List<Result>? histroyList = [];
  bool loading = false;
  bool loadMore = false;

  String? selectType = "1";

  void setType(String type) {
    selectType = type;
    notifyListeners();
  }

  void setLoading(bool isLoading) {
    loading = isLoading;
    notifyListeners();
  }

  void setLoadMore(bool loadMore) {
    this.loadMore = loadMore;
    notifyListeners();
  }

  /*  Pagination start */
  int? totalRows, totalPage, currentPage;
  bool? isMorePage;
  void setPagination(
      int? totalRows, int? totalPage, int? currentPage, bool? morePage) {
    this.currentPage = currentPage;
    this.totalRows = totalRows;
    this.totalPage = totalPage;
    isMorePage = morePage;
    notifyListeners();
  }
  /*  Pagination end */

/*  homedata api start  */

  Future<void> getSectionList(String type, pageNo) async {
    loading = true;
    transactionListModel =
        await ApiService().transcationListReponse(type, pageNo);
    if (transactionListModel.status == 200) {
      setPagination(
          transactionListModel.totalRows,
          transactionListModel.totalPage,
          transactionListModel.currentPage,
          transactionListModel.morePage);
      if (transactionListModel.result != null &&
          (transactionListModel.result?.length ?? 0) > 0) {
        if (transactionListModel.result != null &&
            (transactionListModel.result?.length ?? 0) > 0) {
          for (var i = 0; i < (transactionListModel.result?.length ?? 0); i++) {
            histroyList?.add(transactionListModel.result?[i] ?? Result());
          }
          final Map<int, Result> postMap = {};
          histroyList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          histroyList = postMap.values.toList();
          setLoadMore(false);
        }
      }
    }
    loading = false;
    notifyListeners();
  }

  void clearContent() {
    transactionListModel = TransactionListModel();
    histroyList = [];
    histroyList?.clear();
    loading = false;

    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
  }

  void clearProvider() {
    transactionListModel = TransactionListModel();
    histroyList = [];
    histroyList?.clear();
    loading = false;

    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
    selectType = "1";
  }
}
