import 'package:prakah/utils/constant.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

class ThemeProvider with ChangeNotifier {
  bool get isDarkMode => Constant.isDark;

  ThemeMode get themeMode => Constant.isDark ? ThemeMode.dark : ThemeMode.light;

  void changeTheme(bool isOn) {
    Constant.isDark = isOn;
    notifyListeners();
  }

/* This is Code only Web */
  bool _isDarkMode = false;

  bool get isDarkMode1 => _isDarkMode;

  ThemeProvider() {
    _loadTheme(); // ✅ Correctly load the theme when provider initializes
  }

  void toggleTheme() {
    _isDarkMode = !_isDarkMode;
    _saveTheme();
    notifyListeners();
  }

  Future<void> _loadTheme() async {
    final prefs = await SharedPreferences.getInstance();
    _isDarkMode = prefs.getBool('isDarkMode') ?? false; // ✅ Fix applied here
    notifyListeners();
  }

  Future<void> _saveTheme() async {
    final prefs = await SharedPreferences.getInstance();
    await prefs.setBool('isDarkMode', _isDarkMode);
  }
}
