import 'package:prakah/model/successModel.dart';
import 'package:prakah/model/packagemodel.dart' as package;
import 'package:prakah/model/packagemodel.dart';
import 'package:prakah/model/paymentoptionmodel.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';
import 'package:prakah/utils/utils.dart';

class SubscriptionProvider extends ChangeNotifier {
  /* Package Paginattion */
  PackageModel packageModel = PackageModel();
  List<package.Result>? packageList = [];
  int? totalRows, totalPage, currentPage;
  bool? isMorePage;
  bool loading = false, loadmore = false;

/* Payment Option */
  PaymentOptionModel paymentOptionModel = PaymentOptionModel();
  bool payLoading = false;
  String? currentPayment = "", finalAmount = "";

/* Add Transection */
  SuccessModel successModel = SuccessModel();

/* Get Package */
  Future<void> getPackage(int pageNo) async {
    loading = true;
    packageModel = await ApiService().package(pageNo);
    if (packageModel.status == 200) {
      setPaginationData(packageModel.totalRows, packageModel.totalPage,
          packageModel.currentPage, packageModel.morePage);
      if (packageModel.result != null &&
          (packageModel.result?.length ?? 0) > 0) {
        printLog(
            "PackageModel length :==> ${(packageModel.result?.length ?? 0)}");
        if (packageModel.result != null &&
            (packageModel.result?.length ?? 0) > 0) {
          printLog(
              "PackageModel length :==> ${(packageModel.result?.length ?? 0)}");
          for (var i = 0; i < (packageModel.result?.length ?? 0); i++) {
            packageList?.add(packageModel.result?[i] ?? package.Result());
          }
          final Map<int, package.Result> postMap = {};
          packageList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          packageList = postMap.values.toList();
          printLog("PackageList length :==> ${(packageList?.length ?? 0)}");
          setLoadMore(false);
        }
      }
    }
    loading = false;
    notifyListeners();
  }

  void setPaginationData(
      int? totalRows, int? totalPage, int? currentPage, bool? isMorePage) {
    this.currentPage = currentPage;
    this.totalRows = totalRows;
    this.totalPage = totalPage;
    isMorePage = isMorePage;
    notifyListeners();
  }

  void setLoadMore(bool loadmore) {
    this.loadmore = loadmore;
    notifyListeners();
  }

/* Get Payment Options */
  Future<void> getPaymentOption() async {
    loading = true;
    paymentOptionModel = await ApiService().paymentOption();
    loading = false;
    notifyListeners();
  }

  void setFinalAmount(String? amount) {
    finalAmount = amount;
    printLog("setFinalAmount finalAmount :==> $finalAmount");
    notifyListeners();
  }

  void setCurrentPayment(String? payment) {
    currentPayment = payment;
    notifyListeners();
  }

  int? setIndex = 0;
  String? pageName = "";

  void setPaymentOpen({int? value, valueName}) {
    setIndex = value;
    pageName = valueName;
    notifyListeners();
  }

/* add Transection  */
  Future<void> addPackageTransaction(
      String type, contentId, price, transectionId) async {
    setPaymentLoading(true);
    successModel = await ApiService()
        .addPackageTransaction(type, contentId, price, transectionId);
    setPaymentLoading(false);
  }

/* Book seesion Api  */
  Future<void> getBookSeesion(
    String mettingId,
    mettingScheduleId,
    date,
    chapterId,
    totalPrice,
    details,
    attachment,
    transactionId,
    promoCodeId,
    fileName,
    mediaType,
  ) async {
    setPaymentLoading(true);
    successModel = await ApiService().bookSessionResponse(
      mettingId,
      mettingScheduleId,
      date,
      chapterId,
      totalPrice,
      details,
      attachment,
      transactionId,
      promoCodeId,
      fileName,
      mediaType,
    );
    setPaymentLoading(false);
  }

/* Buy Course api */
  Future<void> buyCourseApi(String type, totalPrice, discountPrice, promoCodeId,
      courseId, transactionId) async {
    setPaymentLoading(true);
    successModel = await ApiService().buyCourseResponse(
        type, totalPrice, discountPrice, promoCodeId, courseId, transactionId);
    setPaymentLoading(false);
  }

  void setPaymentLoading(bool isLoding) {
    payLoading = isLoding;
    notifyListeners();
  }

  void clearPackageList() {
    packageModel = PackageModel();
    packageList = [];
    packageList?.clear();
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
    loading = false;
    loadmore = false;
  }

/* Clear Provider */
  void clearAllPaymentProvider() {
    paymentOptionModel = PaymentOptionModel();
    payLoading = false;
    currentPayment = "";
    finalAmount = "";
    setIndex = 0;
    pageName = "";
  }
}
