import 'package:flutter/material.dart';
import 'package:prakah/utils/utils.dart';

class ShowDownloadProvider extends ChangeNotifier {
  int dProgress = 0;
  int? seasonClickIndex;
  int? itemId;
  bool loading = false;

  void setDownloadProgress(int progress, int itemId) {
    this.itemId = itemId;
    loading = (progress != -1);
    dProgress = progress;
    notifyListeners();
    printLog('setDownloadProgress dProgress ==============> $dProgress');
  }

  void setLoading(bool isLoading) {
    loading = isLoading;
    notifyListeners();
  }

  void setSelectedSeason(int index) {
    seasonClickIndex = index;
    notifyListeners();
  }

  void setCurrentDownload(int? itemId) {
    this.itemId = itemId;
    notifyListeners();
  }

  void notifyProvider() {
    notifyListeners();
  }

  void clearProvider() {
    printLog("<================ clearProvider ================>");
    dProgress = 0;
    seasonClickIndex = 0;
    itemId = null;
    loading = false;
  }
}
