import 'package:prakah/model/successModel.dart';
import 'package:prakah/model/commanmodel.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class SearchProvider extends ChangeNotifier {
  CommanModel searchModel = CommanModel();
  SuccessModel successModel = SuccessModel();
  bool loading = false;
  List<Result>? searchList = [];
  bool loadMore = false;
  int? totalRows, totalPage, currentPage;
  bool? isMorePage;
  /* Select Layout */
  String layoutType = Constant.courseType;
  int position = 0;

  Future<void> getSearch(String name, type, pageNo) async {
    loading = true;
    searchModel = await ApiService().search(name, type, pageNo);
    if (searchModel.status == 200) {
      setPaginationData(searchModel.totalRows, searchModel.totalPage,
          searchModel.currentPage, searchModel.morePage);
      if (searchModel.result != null && (searchModel.result?.length ?? 0) > 0) {
        if (searchModel.result != null &&
            (searchModel.result?.length ?? 0) > 0) {
          for (var i = 0; i < (searchModel.result?.length ?? 0); i++) {
            searchList?.add(searchModel.result?[i] ?? Result());
          }
          final Map<int, Result> postMap = {};
          searchList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          searchList = postMap.values.toList();
          setLoadMore(false);
        }
      }
    }
    loading = false;
    notifyListeners();
  }

  void setPaginationData(
      int? totalRows, int? totalPage, int? currentPage, bool? morePage) {
    this.currentPage = currentPage;
    this.totalRows = totalRows;
    this.totalPage = totalPage;
    isMorePage = morePage;
    notifyListeners();
  }

  void setLoadMore(bool loadMore) {
    this.loadMore = loadMore;
    notifyListeners();
  }

  /* Product Like Dislike */
  void addRemoveWishlist(int index, type, contentId) {
    if ((searchList?[index].isWishlist ?? 0) == 0) {
      searchList?[index].isWishlist = 1;
    } else {
      searchList?[index].isWishlist = 0;
    }
    notifyListeners();
    addremoveWishList(type, contentId);
  }

  Future<void> addremoveWishList(String type, contentId) async {
    successModel = await ApiService().addRemoveWishlist(type, contentId);
  }

/* Chnage Tab */
  void selectLayout(String type) {
    layoutType = type;
    notifyListeners();
  }

  String? isSearch = "0";

  void setSearch(String value) {
    isSearch = value;

    notifyListeners();
  }

  void clearWishList() {
    searchModel = CommanModel();
    loading = false;
    successModel = SuccessModel();
    searchList?.clear();
    searchList = [];
    loading = false;
    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
  }

/* Clear Provider */

  void clearProvider() {
    /* Wishlist Fields */
    searchModel = CommanModel();
    successModel = SuccessModel();
    loading = false;
    searchList = [];
    loading = false;
    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage = false;
    isSearch = "0";

    /* Select Layout */
    layoutType = Constant.courseType;
    position = 0;
  }
}
