import 'dart:io';
import 'dart:typed_data';
import 'package:prakah/model/applycouponmodel.dart';
import 'package:prakah/model/coursenamemodel.dart';
import 'package:prakah/model/meetingdetailsmodel.dart';
import 'package:prakah/model/mycoursemodel.dart';
import 'package:prakah/model/packagemodel.dart' as package;
import 'package:prakah/model/successModel.dart';
import 'package:prakah/model/pagemodel.dart';
import 'package:prakah/model/selectedtimeslotemodel.dart';
import 'package:prakah/model/profilemodel.dart';
import 'package:prakah/model/sociallinkmodel.dart';
import 'package:prakah/model/transcationlistmodel.dart' as transaction;
import 'package:prakah/model/viewsessionmodel.dart';
import 'package:prakah/model/mycoursemodel.dart' as mycourse;
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:prakah/utils/utils.dart';
import 'package:file_picker/file_picker.dart';
import 'package:flutter/material.dart';

class ProfileProvider extends ChangeNotifier {
  PageModel getpagemodel = PageModel();
  ProfileModel profileModel = ProfileModel();
  SuccessModel successModel = SuccessModel();
  SocialLinkModel socialLinkModel = SocialLinkModel();
  ViewSessionModel viewSessionModel = ViewSessionModel();
  MyCourseModel myCourseModel = MyCourseModel();
  List<mycourse.Result>? mycourseList = [];
  bool viewSessionLoading = false;
  ApplyCouponModel applyCouponModel = ApplyCouponModel();

  bool removeLoading = false;
  bool loading = false,
      forgotpasswordLoading = false,
      pageLoding = false,
      linkLoding = false;
  SharedPre sharePref = SharedPre();
  // bool updateprofileLoading = false;

  /* Selected Image */
  File? imageFile;
  bool imageSelected = false;

  /* Toggle Button */
  bool isNotification = false;
  bool isDarkMode = false;
  String toggleTypeNotification = "";
  String toggleTypeDarkMode = "";

  /* Update Pyament Info */
  bool loadingUpdate = false;

  void setDataLoading(bool isLoading) {
    loading = isLoading;
    notifyListeners();
  }

/* Add Wallet Api */

  bool walletLoading = false;

  Future<void> getAddWallet(String amount, transactionId) async {
    setWallet(true);
    successModel = await ApiService().addWalletMoney(amount, transactionId);

    setWallet(false);
  }

  void setWallet(bool isLoading) {
    walletLoading = isLoading;
    notifyListeners();
  }

  /* END */

  Future<void> getMyCourse(int pageno) async {
    loading = true;
    myCourseModel = await ApiService().mycourse(pageno);
    if (myCourseModel.status == 200) {
      setPagination(myCourseModel.totalRows, myCourseModel.totalPage,
          myCourseModel.currentPage, myCourseModel.morePage);
      if (myCourseModel.result != null &&
          (myCourseModel.result?.length ?? 0) > 0) {
        printLog("MyCourse length :==> ${(myCourseModel.result?.length ?? 0)}");
        printLog('Now on page ==========> $currentPage');
        if (myCourseModel.result != null &&
            (myCourseModel.result?.length ?? 0) > 0) {
          printLog(
              "MyCourse length :==> ${(myCourseModel.result?.length ?? 0)}");
          for (var i = 0; i < (myCourseModel.result?.length ?? 0); i++) {
            mycourseList?.add(myCourseModel.result?[i] ?? mycourse.Result());
          }
          final Map<int, mycourse.Result> postMap = {};
          mycourseList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          mycourseList = postMap.values.toList();
          printLog("MyCourseList length :==> ${(mycourseList?.length ?? 0)}");
          setLoadMore(false);
        }
      }
    }
    loading = false;
    notifyListeners();
  }

  Future<void> getprofile(BuildContext context) async {
    loading = true;
    profileModel = await ApiService().profile();
    if (profileModel.status == 200 && profileModel.result != null) {
      if ((profileModel.result?.length ?? 0) > 0) {
        Utils.updatePremium(profileModel.result?[0].isBuy.toString() ?? "0");
        if (context.mounted) {
          Utils.loadAds(context);
        }
      }
    }
    loading = false;
    notifyListeners();
  }

  void providerNotifi() {
    notifyListeners();
  }

  Future<void> getViewSession(String appointmentId) async {
    viewSessionLoading = true;
    viewSessionModel = await ApiService().viewSessionData(appointmentId);
    viewSessionLoading = false;
    notifyListeners();
  }

  Future<void> getUpdateProfile(
      String userName,
      fullname,
      mobilenumber,
      email,
      countryCode,
      countryName,
      image,
      fileName,
      mediaType,
      deviceType,
      deviceToken) async {
    setUpdateLoading(true);
    profileModel = await ApiService().updateprofile(
        userName,
        fullname,
        mobilenumber,
        email,
        countryCode,
        countryName,
        image,
        fileName,
        mediaType,
        deviceType,
        deviceToken);
    setUpdateLoading(false);
  }

  // setLoading(bool isLoading) {
  //   updateprofileLoading = isLoading;
  //   notifyListeners();
  // }

  Future<void> getPages() async {
    pageLoding = true;
    getpagemodel = await ApiService().getpage();
    pageLoding = false;
    notifyListeners();
  }

  Future<void> getSocialLink() async {
    linkLoding = true;
    socialLinkModel = await ApiService().getSocialLink();
    linkLoding = false;
    notifyListeners();
  }

  void selectImage(dynamic img, isSelec) {
    imageFile = img;
    imageSelected = isSelec;
    notifyListeners();
  }

  void setUpdateLoading(bool isLoading) {
    loadingUpdate = isLoading;
    notifyListeners();
  }

  /* Web tab Click data */

  /* Meeting tab name show */
  String isAppoinment = "0", isAppoinmentName = "";

  void setAppoinment({
    String? index,
    name,
    ids,
  }) {
    isAppoinment = index ?? "";
    isAppoinmentName = name ?? "";
    meetingId = ids;

    notifyListeners();
  }

/* appoinment confirem show  */
  String isConfAppoinment = "0", isConfAppoinmentName = "";
  void setConfAppoinment({String? index, name, ids}) {
    isConfAppoinment = index ?? "";
    isConfAppoinmentName = name ?? "";

    notifyListeners();
  }

  String? webSelect = "1", webSelectTabName = "my_profile";

  void setWebSelect(String index, name) {
    webSelect = index;
    webSelectTabName = name;
    notifyListeners();
  }

/* Web Image Picked Code Started */
  Uint8List? imageBytes; // Stores image bytes for display
  String? fileName;

  String? mediaType;

  Future<void> pickImageWEB() async {
    final result = await FilePicker.platform.pickFiles(
      type: FileType.image,
      allowMultiple: false,
      withData: true, // Important to get bytes on web
    );

    if (result != null && result.files.single.bytes != null) {
      imageBytes = result.files.single.bytes;
      fileName = result.files.single.name;
      String extension = result.files.first.extension ?? 'jpeg';
      mediaType = 'image/$extension';

      notifyListeners();
    }
  }

/* Web Subscription and transaction list api call and pagenation */
  transaction.TransactionListModel transactionListModel =
      transaction.TransactionListModel();
  package.PackageModel packageModel = package.PackageModel();
  List<package.Result>? packageList = [];
  List<transaction.Result>? histroyList = [];
  bool contentLoading = false;
  bool loadMore = false;

  String? selectType = "1";

  void setType(String type) {
    selectType = type;
    notifyListeners();
  }

  void setLoadMore(bool loadMore) {
    this.loadMore = loadMore;
    notifyListeners();
  }

  /*  Pagination start */
  int? totalRows, totalPage, currentPage;
  bool? isMorePage;
  void setPagination(
      int? totalRows, int? totalPage, int? currentPage, bool? morePage) {
    this.currentPage = currentPage;
    this.totalRows = totalRows;
    this.totalPage = totalPage;
    isMorePage = morePage;
    notifyListeners();
  }
  /*  Pagination end */

/* Get Package */
  Future<void> getPackage(int pageNo) async {
    contentLoading = true;
    packageModel = await ApiService().package(pageNo);
    if (packageModel.status == 200) {
      setPagination(packageModel.totalRows, packageModel.totalPage,
          packageModel.currentPage, packageModel.morePage);
      if (packageModel.result != null &&
          (packageModel.result?.length ?? 0) > 0) {
        printLog(
            "PackageModel length :==> ${(packageModel.result?.length ?? 0)}");
        if (packageModel.result != null &&
            (packageModel.result?.length ?? 0) > 0) {
          printLog(
              "PackageModel length :==> ${(packageModel.result?.length ?? 0)}");
          for (var i = 0; i < (packageModel.result?.length ?? 0); i++) {
            packageList?.add(packageModel.result?[i] ?? package.Result());
          }
          final Map<int, package.Result> postMap = {};
          packageList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          packageList = postMap.values.toList();
          printLog("PackageList length :==> ${(packageList?.length ?? 0)}");
          setLoadMore(false);
        }
      }
    }
    contentLoading = false;
    notifyListeners();
  }

/*  Transcation api start  */

  Future<void> getSectionList(String type, pageNo) async {
    contentLoading = true;
    transactionListModel =
        await ApiService().transcationListReponse(type, pageNo);
    if (transactionListModel.status == 200) {
      setPagination(
          transactionListModel.totalRows,
          transactionListModel.totalPage,
          transactionListModel.currentPage,
          transactionListModel.morePage);
      if (transactionListModel.result != null &&
          (transactionListModel.result?.length ?? 0) > 0) {
        if (transactionListModel.result != null &&
            (transactionListModel.result?.length ?? 0) > 0) {
          for (var i = 0; i < (transactionListModel.result?.length ?? 0); i++) {
            histroyList
                ?.add(transactionListModel.result?[i] ?? transaction.Result());
          }
          final Map<int, transaction.Result> postMap = {};
          histroyList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          histroyList = postMap.values.toList();
          setLoadMore(false);
        }
      }
    }
    contentLoading = false;
    notifyListeners();
  }

/* Appoinment Data started */
  SelectedTimeSloteModel selectedTimeSloteModel = SelectedTimeSloteModel();

  DateTime selectedValue = DateTime.now();
  void setLoding(bool isLoading) {
    courseNameLoading = isLoading;
    loading = isLoading;
    notifyListeners();
  }

  void setDate(DateTime date) {
    selectedValue = date;
    notifyListeners();
  }

  CourseNameModel courseNameModel = CourseNameModel();
  bool courseNameLoading = false, timeSlotLoading = false;
  String? courseId;
  String? meetingId;

  String? weekDayName = "Monday";

  void setWeekDay(String name) {
    weekDayName = name;

    printLog("My Week day name $weekDayName");
    notifyListeners();
  }

/* End */

  Future<void> getCourseName() async {
    courseNameLoading = true;
    courseNameModel = await ApiService().courseNameResponse();
    courseNameLoading = false;
    notifyListeners();
  }

  Future<void> getTimeSlot(String meetinId, weekDay) async {
    timeSlotLoading = true;
    selectedTimeSloteModel =
        await ApiService().timeSlotSelectResponse(meetinId, weekDay);
    if ((selectedTimeSloteModel.result ?? []).isNotEmpty) {
      setMeetingId(
          id: selectedTimeSloteModel
                  .result?[0].timeSlotes?[0].timeSchedul?[0].id
                  .toString() ??
              "",
          start: selectedTimeSloteModel
                  .result?[0].timeSlotes?[0].timeSchedul?[0].startTime
                  .toString() ??
              "",
          end: selectedTimeSloteModel
                  .result?[0].timeSlotes?[0].timeSchedul?[0].endTime
                  .toString() ??
              "");
    }

    timeSlotLoading = false;
    notifyListeners();
  }

  String? chapterId;
  void setCourseId(String ids) {
    chapterId = ids;
    notifyListeners();
  }

/* Time Slot id get */

  String? meetingScheduledId;
  String? meetingScheduledStartTime;
  String? meetingScheduledEndTime;

  void setMeetingId({String? id, start, end}) {
    meetingScheduledId = id ?? "";
    meetingScheduledStartTime = start;
    meetingScheduledEndTime = end;
    printLog(
        "My Selected Starte and END TIme $meetingScheduledStartTime - $meetingScheduledEndTime");
    notifyListeners();
  }

  void clearTimeSlotContent() {
    selectedTimeSloteModel = SelectedTimeSloteModel();
    meetingScheduledId = "";
    loading = false;
  }
/* Appointment Data END */

/* Meeting details api */
  MeetingDetailsModel meetingDetailsModel = MeetingDetailsModel();

  bool detailsLoading = false;

  Future<void> getMeetingDetails(String meetingId) async {
    detailsLoading = true;
    meetingDetailsModel = await ApiService().meetingDetailsResponse(meetingId);
    detailsLoading = false;
    notifyListeners();
  }

/* END */
  String? priceMeeting,
      discountPrice,
      promocodeName = "",
      promocodeId,
      totalPrice;
  void setPrice({String? value, disPri, proId, proName, totPrice}) {
    priceMeeting = value ?? "";
    discountPrice = disPri;
    promocodeId = proId;
    promocodeName = proName;
    totalPrice = totPrice;
    notifyListeners();
  }

  Future<void> getRemoveCoupone(String totalPrice) async {
    setRemoveLoading(true);
    applyCouponModel = await ApiService().removeCouponResponse(totalPrice);
    setRemoveLoading(false);
  }

  void setRemoveLoading(bool isLoading) {
    removeLoading = isLoading;
    notifyListeners();
  }

  void providerNoti() {
    notifyListeners();
  }

/* user meeting details show code */
  String? isShowDetails = "0";

  void setDetails(String value) {
    isShowDetails = value;
    notifyListeners();
  }

  void clearSession() {
    viewSessionModel = ViewSessionModel();
    viewSessionLoading = false;
  }

  void clearContent() {
    transactionListModel = transaction.TransactionListModel();
    histroyList = [];
    histroyList?.clear();
    contentLoading = false;

    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
  }

  void clearPackageList() {
    packageModel = package.PackageModel();
    packageList = [];
    packageList?.clear();
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
    loading = false;
    loadMore = false;
  }

  void clearWebContent() {
    profileModel = ProfileModel();
    viewSessionModel = ViewSessionModel();
    viewSessionLoading = false;
    loading = false; /* Update Pyament Info */

    imageBytes = null; // Stores image bytes for display
    fileName = "";
    mediaType;
    imageSelected = false;
    transactionListModel = transaction.TransactionListModel();
    histroyList = [];
    histroyList?.clear();
    applyCouponModel = ApplyCouponModel();

    removeLoading = false;
    contentLoading = false;
    packageModel = package.PackageModel();
    packageList = [];
    packageList?.clear();
    isAppoinment = "0";
    isAppoinmentName = "";
    isConfAppoinment = "0";
    isConfAppoinmentName = "";
    discountPrice = "";
    promocodeName = "";
    promocodeId = "";
    isShowDetails = "0";
    priceMeeting = "";
    loadMore = false;
    totalRows;
    walletLoading = false;
    totalPage;
    currentPage;
    isMorePage;
    /* appointment */
    selectedValue = DateTime.now();
    courseNameModel = CourseNameModel();
    courseNameLoading = false;
    selectedTimeSloteModel = SelectedTimeSloteModel();
    myCourseModel = MyCourseModel();
    mycourseList = [];
    mycourseList?.clear();
    loading = false;
    chapterId = "";
    courseId = "";
    meetingId = "";
    meetingScheduledId = "";
    fileName = "";
    totalPrice = "";

    meetingScheduledStartTime = "";
    meetingScheduledEndTime = "";
    weekDayName = "Monday";
    selectedValue = DateTime.now();
  }

  void clearWeb() {
    myCourseModel = MyCourseModel();
    mycourseList = [];
    mycourseList?.clear();
    profileModel = ProfileModel();

    viewSessionModel = ViewSessionModel();
    applyCouponModel = ApplyCouponModel();

    removeLoading = false;
    viewSessionLoading = false;
    webSelect = "1";
    webSelectTabName = "";
    imageBytes = null; // Stores image bytes for display
    fileName = "";
    mediaType;
    imageSelected = false;
    transactionListModel = transaction.TransactionListModel();
    histroyList = [];
    histroyList?.clear();
    contentLoading = false;
    packageModel = package.PackageModel();
    packageList = [];
    packageList?.clear();
    walletLoading = false;
    isShowDetails = "0";
    isAppoinment = "0";
    isAppoinmentName = "";
    isConfAppoinment = "0";

    isConfAppoinmentName = "";
    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;

    /* appointment */
    selectedValue = DateTime.now();
    courseNameModel = CourseNameModel();
    courseNameLoading = false;
    selectedTimeSloteModel = SelectedTimeSloteModel();
    loading = false;
    courseId = "";
    chapterId = "";
    priceMeeting = "";
    totalPrice = "";
    meetingId = "";
    meetingScheduledId = "";
    fileName = "";

    meetingScheduledStartTime = "";
    meetingScheduledEndTime = "";
    weekDayName = "Monday";
    selectedValue = DateTime.now();
  }

  void clearProvider() {
    profileModel = ProfileModel();
    successModel = SuccessModel();
    loading = false;

    sharePref = SharedPre();
    // updateprofileLoading = false;
    forgotpasswordLoading = false;
    walletLoading = false;
    /* Selected Image */
    imageFile;
    /* Toggle Button */
    isNotification = false;
    isDarkMode = false;
    toggleTypeNotification = "";
    toggleTypeDarkMode = "";
    /* Update Pyament Info */
    loadingUpdate = false;
    webSelect = "1";
    imageBytes = null; // Stores image bytes for display
    fileName = "";
    mediaType;
    imageSelected = false;
  }
}
