import 'package:prakah/model/profilemodel.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class ProfileEditProvider extends ChangeNotifier {
  ProfileModel profileModel = ProfileModel();

  bool loading = false;
  /* Update Pyament Info */
  bool loadingUpdate = false;

  Future<void> getprofile() async {
    loading = true;
    profileModel = await ApiService().profile();

    loading = false;
    notifyListeners();
  }

  Future<void> getUpdateProfile(
      String userName,
      fullname,
      mobilenumber,
      email,
      countryCode,
      countryName,
      image,
      fileName,
      mediaType,
      deviceType,
      deviceToken) async {
    setUpdateLoading(true);
    profileModel = await ApiService().updateprofile(
        userName,
        fullname,
        mobilenumber,
        email,
        countryCode,
        countryName,
        image,
        fileName,
        mediaType,
        deviceType,
        deviceToken);
    setUpdateLoading(false);
  }

  void setUpdateLoading(bool isLoading) {
    loadingUpdate = isLoading;
    notifyListeners();
  }

  void providerNotified() {
    notifyListeners();
  }
}
