import 'package:prakah/model/successModel.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class PlayerProvider extends ChangeNotifier {
  SuccessModel successModel = SuccessModel();
  SuccessModel successVideoReadModel = SuccessModel();
  bool loading = false;

  Future<void> addVideoView(dynamic type, contentId, videoId) async {
    loading = true;
    successModel = await ApiService().addContentView(type, contentId, videoId);
    loading = false;
    notifyListeners();
  }

  Future<void> addVideoRead(
    dynamic courseId,
    chapterId,
    videoId,
    stopTime,
  ) async {
    loading = true;
    successVideoReadModel = await ApiService().addVideoRead(
      courseId,
      chapterId,
      videoId,
      stopTime,
    );
    loading = false;
    notifyListeners();
  }
}
