import 'package:prakah/model/profilemodel.dart';
import 'package:prakah/model/successModel.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class MyWalletProvider extends ChangeNotifier {
  ProfileModel profileModel = ProfileModel();
  SuccessModel successModel = SuccessModel();
  bool loading = false;

  Future<void> getprofile() async {
    loading = true;
    profileModel = await ApiService().profile();

    loading = false;
    notifyListeners();
  }

  /* Add Wallet Api */

  bool walletLoading = false;

  Future<void> getAddWallet(String amount, transactionId) async {
    setWallet(true);
    successModel = await ApiService().addWalletMoney(amount, transactionId);

    setWallet(false);
  }

  void setWallet(bool isLoading) {
    walletLoading = isLoading;
    notifyListeners();
  }

  void clearProvider() {
    profileModel = ProfileModel();
    successModel = SuccessModel();
    loading = false;
    walletLoading = false;
  }
}
