import 'package:prakah/model/coursenamemodel.dart';
import 'package:prakah/model/meetinglistmodel.dart' as meeting;
import 'package:prakah/model/meetingstatusmodel.dart';
import 'package:prakah/model/selectedtimeslotemodel.dart';
import 'package:prakah/model/successModel.dart';
import 'package:prakah/model/usermeetingmodel.dart' as usermeeting;
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class MeetingProvider extends ChangeNotifier {
  MeetingStatusModel meetingStatusModel = MeetingStatusModel();
  meeting.MeetingListModel meetingListModel = meeting.MeetingListModel();
  usermeeting.UserMeetingModel userMeetingModel =
      usermeeting.UserMeetingModel();
  CourseNameModel courseNameModel = CourseNameModel();
  bool courseNameLoading = false;
  SuccessModel successModel = SuccessModel();

  bool statusLoading = false, loading = false;
  String? selectedIndex = "1";
  List<meeting.Result>? meetingList = [];
  List<usermeeting.Result>? userMeetingList = [];

  /* Post Pagination */
  bool loadMore = false;
  int? totalRows, totalPage, currentPage;
  bool? isMorePage;

  void setLoading(bool isLoading) {
    loading = isLoading;
    courseNameLoading = isLoading;
    notifyListeners();
  }

  Future<void> getMeetingStatus() async {
    statusLoading = true;
    meetingStatusModel = await ApiService().meetingStatusResponse();
    statusLoading = false;
    notifyListeners();
  }

  Future<void> getCourseName() async {
    courseNameLoading = true;
    courseNameModel = await ApiService().courseNameResponse();
    courseNameLoading = false;
    notifyListeners();
  }

  String? courseId = "0";

  void setCourseId(String ids) {
    courseId = ids;
    notifyListeners();
  }

  Future<void> getMeeting(String courseId, pageNo) async {
    loading = true;

    meetingListModel = await ApiService().meetingListResponse(courseId, pageNo);
    if (meetingListModel.status == 200) {
      setPagination(meetingListModel.totalRows, meetingListModel.totalPage,
          meetingListModel.currentPage, meetingListModel.morePage);
      if (meetingListModel.result != null &&
          (meetingListModel.result?.length ?? 0) > 0) {
        for (var i = 0; i < (meetingListModel.result?.length ?? 0); i++) {
          meetingList?.add(meetingListModel.result?[i] ?? meeting.Result());
        }
        final Map<int, meeting.Result> postMap = {};
        meetingList?.forEach((item) {
          postMap[item.id ?? 0] = item;
        });
        meetingList = postMap.values.toList();
        setLoadMore(false);
      }
    }
    loading = false;
    notifyListeners();
  }

/* User Meeting Code */
  Future<void> getUseMeeting(String status, pageNo) async {
    loading = true;
    userMeetingModel = await ApiService().userMeetingResponse(status, pageNo);
    if (userMeetingModel.status == 200) {
      setPagination(userMeetingModel.totalRows, userMeetingModel.totalPage,
          userMeetingModel.currentPage, userMeetingModel.morePage);
      if (userMeetingModel.result != null &&
          (userMeetingModel.result?.length ?? 0) > 0) {
        for (var i = 0; i < (userMeetingModel.result?.length ?? 0); i++) {
          userMeetingList
              ?.add(userMeetingModel.result?[i] ?? usermeeting.Result());
        }
        final Map<int, usermeeting.Result> postMap = {};
        userMeetingList?.forEach((item) {
          postMap[item.id ?? 0] = item;
        });
        userMeetingList = postMap.values.toList();
        setLoadMore(false);
      }
    }
    loading = false;
    notifyListeners();
  }

  void setLoadMore(bool loadMore) {
    this.loadMore = loadMore;
    notifyListeners();
  }

  void setPagination(
      int? totalRows, int? totalPage, int? currentPage, bool? morePage) {
    this.currentPage = currentPage;
    this.totalRows = totalRows;
    this.totalPage = totalPage;
    isMorePage = morePage;
    notifyListeners();
  }

/* Cancel Appointment Api Started */
  bool cancelAppointmentLoading = false;
  Future<void> getCancelAppointment(String appointmentId) async {
    setCancel(true);
    successModel = await ApiService().cancelAppointment(appointmentId);
    setCancel(false);
    notifyListeners();
  }

  void setCancel(bool isLoading) {
    cancelAppointmentLoading = isLoading;
    notifyListeners();
  }

/* Reschedules Api statrted */
  bool reschedulesAppointmentLoading = false;
  Future<void> getReschedulesAppointment(
      String appointmentId, mettingScheduleId, date) async {
    setReschedules(true);
    successModel = await ApiService()
        .reschedulesAppointment(appointmentId, mettingScheduleId, date);
    setReschedules(false);
    notifyListeners();
  }

  void setReschedules(bool isLoading) {
    reschedulesAppointmentLoading = isLoading;
    notifyListeners();
  }

  void setTab(String index) {
    selectedIndex = index;
    notifyListeners();
  }

/* my meeting Tab */
  String myTab = "1";

  void setMyTab(String index) {
    myTab = index;
    notifyListeners();
  }

/* Date and Time */
  SelectedTimeSloteModel selectedTimeSloteModel = SelectedTimeSloteModel();
  bool timeSelectLoading = false;

  DateTime selectedValue = DateTime.now();
  void setDate(DateTime date) {
    selectedValue = date;
    notifyListeners();
  }

  String? weekDayName = "Monday";

  void setWeekDay(String name) {
    weekDayName = name;

    printLog("My Week day name $weekDayName");
    notifyListeners();
  }

  Future<void> getTimeSlotSelect(String meetinId, weekDay) async {
    timeSelectLoading = true;
    selectedTimeSloteModel =
        await ApiService().timeSlotSelectResponse(meetinId, weekDay);
    if ((selectedTimeSloteModel.result ?? []).isNotEmpty) {
      setMeetingId(
          id: selectedTimeSloteModel
                  .result?[0].timeSlotes?[0].timeSchedul?[0].id
                  .toString() ??
              "",
          start: selectedTimeSloteModel
                  .result?[0].timeSlotes?[0].timeSchedul?[0].startTime
                  .toString() ??
              "",
          end: selectedTimeSloteModel
                  .result?[0].timeSlotes?[0].timeSchedul?[0].endTime
                  .toString() ??
              "");
    }

    timeSelectLoading = false;
    notifyListeners();
  }

  String? meetingScheduledId;
  String? meetingScheduledStartTime;
  String? meetingScheduledEndTime;

  void setMeetingId({String? id, start, end}) {
    meetingScheduledId = id;
    meetingScheduledStartTime = start;
    meetingScheduledEndTime = end;
    printLog(
        "My Selected Starte and END TIme $meetingScheduledStartTime - $meetingScheduledEndTime");
    notifyListeners();
  }

  void clearTimeSolt() {
    selectedTimeSloteModel = SelectedTimeSloteModel();
    meetingScheduledId = "";
    loading = false;
  }

  void clearMeetingData() {
    meetingListModel = meeting.MeetingListModel();

    loading = false;
    meetingList = [];
    meetingList?.clear();
    /* Pagination */
    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
  }

  void clearUserMeetingContent() {
    userMeetingModel = usermeeting.UserMeetingModel();
    selectedTimeSloteModel = SelectedTimeSloteModel();
    timeSelectLoading = false;

    meetingScheduledId = "";
    meetingScheduledStartTime = "";
    meetingScheduledEndTime = "";
    weekDayName = "";
    loading = false;
    userMeetingList?.clear();
    userMeetingList = [];
    /* Pagination */
    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
  }

  void clearContent() {
    myTab = "1";
    meetingStatusModel = MeetingStatusModel();
    meetingListModel = meeting.MeetingListModel();
    userMeetingModel = usermeeting.UserMeetingModel();
    courseNameModel = CourseNameModel();
    selectedTimeSloteModel = SelectedTimeSloteModel();
    timeSelectLoading = false;

    meetingScheduledId = "";
    meetingScheduledStartTime = "";
    meetingScheduledEndTime = "";
    weekDayName = "";
    courseNameLoading = false;
    courseId = "0";
    loading = false;
    statusLoading = false;
    meetingList = [];
    meetingList?.clear();
    userMeetingList?.clear();
    userMeetingList = [];
    /* Pagination */
    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
  }

  void clearProvider() {
    selectedIndex = "1";
    myTab = "1";
    cancelAppointmentLoading = false;
    reschedulesAppointmentLoading = false;
    successModel = SuccessModel();
    meetingStatusModel = MeetingStatusModel();
    meetingListModel = meeting.MeetingListModel();
    userMeetingModel = usermeeting.UserMeetingModel();
    loading = false;
    statusLoading = false;
    meetingList = [];
    meetingList?.clear();
    userMeetingList?.clear();
    userMeetingList = [];
    courseNameModel = CourseNameModel();
    courseNameLoading = false;
    courseId = "0";
    /* Pagination */
    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
    selectedTimeSloteModel = SelectedTimeSloteModel();
    timeSelectLoading = false;
    meetingScheduledId = "";
    meetingScheduledStartTime = "";
    meetingScheduledEndTime = "";
    weekDayName = "";
  }
}
