import 'package:prakah/model/applycouponmodel.dart';
import 'package:prakah/model/meetingdetailsmodel.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class MeetingDetailsProvider extends ChangeNotifier {
  MeetingDetailsModel meetingDetailsModel = MeetingDetailsModel();
  ApplyCouponModel applyCouponModel = ApplyCouponModel();

  bool loading = false;
  bool removeLoading = false;

  Future<void> getMeetingDetails(String meetingId) async {
    loading = true;
    meetingDetailsModel = await ApiService().meetingDetailsResponse(meetingId);
    loading = false;
    notifyListeners();
  }

  Future<void> getRemoveCoupone(String totalPrice) async {
    setRemoveLoading(true);
    applyCouponModel = await ApiService().removeCouponResponse(totalPrice);
    setRemoveLoading(false);
  }

  void setRemoveLoading(bool isLoading) {
    removeLoading = isLoading;
    notifyListeners();
  }

  void providerNoti() {
    notifyListeners();
  }

  void clearProvider() {
    meetingDetailsModel = MeetingDetailsModel();
    applyCouponModel = ApplyCouponModel();
    loading = false;
    removeLoading = false;
  }
}
