import 'package:prakah/model/classhistorymodel.dart' as histroy;
import 'package:prakah/model/coursenamemodel.dart';
import 'package:prakah/model/liveclasssectionmodel.dart' as liveclass;
import 'package:prakah/model/searchliveclassmodel.dart' as search;
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class LiveClassProvider extends ChangeNotifier {
  liveclass.LiveClassSectionModel liveClassSectionModel =
      liveclass.LiveClassSectionModel();

  histroy.ClassHistoryModel classHistoryModel = histroy.ClassHistoryModel();

  search.SearchLiveClassModel searchLiveClassModel =
      search.SearchLiveClassModel();

/* Course name api and funcation */
  CourseNameModel courseNameModel = CourseNameModel();
  bool courseNameLoading = false;
  String? courseId;

  Future<void> getCourseName() async {
    courseNameLoading = true;
    courseNameModel = await ApiService().courseNameResponse();
    courseNameLoading = false;
    notifyListeners();
  }

  void setCourseId(String ids) {
    courseId = ids;
    notifyListeners();
  }

/* classes time */

  String? classTimeStatus;

  void setStatus(String value) {
    classTimeStatus = value;
    notifyListeners();
  }

/* Course name end */
  bool loading = false, loadmore = false;
  List<liveclass.Result>? livesectionList = [];
  int? sectiontotalRows, sectiontotalPage, sectioncurrentPage;
  bool? sectionisMorePage;

  void setLoding(bool loadmore) {
    loading = loadmore;
    histroyLoding = loadmore;
    notifyListeners();
  }

  Future<void> getSeactionList(int pageNo) async {
    loading = true;
    liveClassSectionModel = await ApiService().liveClassSectionResponse(pageNo);
    if (liveClassSectionModel.status == 200) {
      setSectionPaginationData(
          liveClassSectionModel.totalRows,
          liveClassSectionModel.totalPage,
          liveClassSectionModel.currentPage,
          liveClassSectionModel.morePage);
      if (liveClassSectionModel.result != null &&
          (liveClassSectionModel.result?.length ?? 0) > 0) {
        printLog(
            "followingModel length :==> ${(liveClassSectionModel.result?.length ?? 0)}");
        printLog('Now on page ==========> $sectioncurrentPage');
        if (liveClassSectionModel.result != null &&
            (liveClassSectionModel.result?.length ?? 0) > 0) {
          printLog(
              "followingModel length :==> ${(liveClassSectionModel.result?.length ?? 0)}");
          for (var i = 0;
              i < (liveClassSectionModel.result?.length ?? 0);
              i++) {
            livesectionList
                ?.add(liveClassSectionModel.result?[i] ?? liveclass.Result());
          }
          final Map<int, liveclass.Result> postMap = {};
          livesectionList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          livesectionList = postMap.values.toList();
          printLog(
              "followFollowingList length :==> ${(livesectionList?.length ?? 0)}");
          setLoadMore(false);
        }
      }
    }
    loading = false;
    notifyListeners();
  }

  void setSectionPaginationData(int? sectiontotalRows, int? sectiontotalPage,
      int? sectioncurrentPage, bool? sectionisMorePage) {
    this.sectioncurrentPage = sectioncurrentPage;
    this.sectiontotalRows = sectiontotalRows;
    this.sectiontotalPage = sectiontotalPage;
    sectionisMorePage = sectionisMorePage;
    notifyListeners();
  }

  void setLoadMore(bool loadmore) {
    this.loadmore = loadmore;
    notifyListeners();
  }

/* Histroy API Call */

  bool histroyLoding = false;
  bool histroyLoadmore = false;

  List<histroy.Result>? histroyList = [];
  int? histroytotalRows, histroytotalPage, histroycurrentPage;
  bool? histroyisMorePage;

  Future<void> getHistroyList(int pageNo) async {
    histroyLoding = true;
    classHistoryModel = await ApiService().classHistoryResponse(pageNo);
    if (classHistoryModel.status == 200) {
      setSectionPaginationData(
          classHistoryModel.totalRows,
          classHistoryModel.totalPage,
          classHistoryModel.currentPage,
          classHistoryModel.morePage);
      if (classHistoryModel.result != null &&
          (classHistoryModel.result?.length ?? 0) > 0) {
        if (classHistoryModel.result != null &&
            (classHistoryModel.result?.length ?? 0) > 0) {
          for (var i = 0; i < (classHistoryModel.result?.length ?? 0); i++) {
            histroyList?.add(classHistoryModel.result?[i] ?? histroy.Result());
          }
          final Map<int, histroy.Result> postMap = {};
          histroyList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          histroyList = postMap.values.toList();
          setHistroyLoadMore(false);
        }
      }
    }
    histroyLoding = false;
    notifyListeners();
  }

  void setHistroyPaginationData(int? sectiontotalRows, int? sectiontotalPage,
      int? sectioncurrentPage, bool? sectionisMorePage) {
    histroycurrentPage = sectioncurrentPage;
    histroytotalRows = sectiontotalRows;
    histroytotalPage = sectiontotalPage;
    histroyisMorePage = sectionisMorePage;
    notifyListeners();
  }

  void setHistroyLoadMore(bool loadmore) {
    histroyLoadmore = loadmore;
    notifyListeners();
  }

/* search API Call */

  bool searchLoding = false;
  bool searchLoadmore = false;

  List<search.Result>? searchList = [];
  int? searchtotalRows, searchtotalPage, searchcurrentPage;
  bool? searchisMorePage;

  Future<void> getSearchList(
      dynamic formDate, toDate, isFree, courseId, classStatus, pageNo) async {
    searchLoding = true;
    searchLiveClassModel = await ApiService().searchLiveClassResponse(
        formDate, toDate, isFree, courseId, classStatus, pageNo);
    if (searchLiveClassModel.status == 200) {
      setSearchPaginationData(
          searchLiveClassModel.totalRows,
          searchLiveClassModel.totalPage,
          searchLiveClassModel.currentPage,
          searchLiveClassModel.morePage);
      if (searchLiveClassModel.result != null &&
          (searchLiveClassModel.result?.length ?? 0) > 0) {
        if (searchLiveClassModel.result != null &&
            (searchLiveClassModel.result?.length ?? 0) > 0) {
          for (var i = 0; i < (searchLiveClassModel.result?.length ?? 0); i++) {
            searchList?.add(searchLiveClassModel.result?[i] ?? search.Result());
          }
          final Map<int, search.Result> postMap = {};
          searchList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          searchList = postMap.values.toList();
          setSearchLoadMore(false);
        }
      }
    }
    searchLoding = false;
    notifyListeners();
  }

  void setSearchPaginationData(int? sectiontotalRows, int? sectiontotalPage,
      int? sectioncurrentPage, bool? sectionisMorePage) {
    searchcurrentPage = sectioncurrentPage;
    searchtotalRows = sectiontotalRows;
    searchtotalPage = sectiontotalPage;
    searchisMorePage = sectionisMorePage;
    notifyListeners();
  }

  void setSearchLoadMore(bool loadmore) {
    searchLoadmore = loadmore;
    notifyListeners();
  }

/* Date Picked */
  DateTime startDate = DateTime.now();
  void setDateValue(DateTime value) {
    startDate = value;
    notifyListeners();
  }

  String? isFree = "0";

  void setPlan(String value) {
    isFree = value;
    notifyListeners();
  }

/* Reset the filter data */
  void resetFilters() {
    courseId = "";
    startDate = DateTime.now();
    isFree = "0";
    classTimeStatus = "";
    notifyListeners();
  }

/* Search Data show */

  String? isSearch = "0";

  void setSearch(String value) {
    isSearch = value;
    notifyListeners();
  }

  /* Web Search Data Started */
  String? isFilter;

  void setFilter(String value) {
    isFilter = value;
    notifyListeners();
  }

  void clearProvider() {
    isFilter = "";

    loading = false;
    loadmore = false;
    liveClassSectionModel = liveclass.LiveClassSectionModel();
    livesectionList = [];
    livesectionList?.clear();
    sectiontotalRows;
    sectiontotalPage;
    sectioncurrentPage;
    sectionisMorePage;
    classHistoryModel = histroy.ClassHistoryModel();
    /* History */
    histroyLoding = false;
    histroyLoadmore = false;
    histroyList = [];
    histroyList?.clear();
    histroytotalRows;
    histroytotalPage;
    histroycurrentPage;
    histroyisMorePage;
    /* Search */
    searchLiveClassModel = search.SearchLiveClassModel();
    searchLoding = false;
    searchLoadmore = false;

    searchList = [];
    searchList?.clear();
    searchtotalRows;
    searchtotalPage;
    searchcurrentPage;
    searchisMorePage;
    startDate = DateTime.now();
    isFree = "0";
    courseId = "";
    courseNameModel = CourseNameModel();
    courseNameLoading = false;
    classTimeStatus = "";
    isSearch = "0";
  }
}
