import 'package:prakah/model/commanmodel.dart' as search;
import 'package:prakah/model/sectionlistmodel.dart' as section;
import 'package:prakah/model/sectionlistmodel.dart';
import 'package:prakah/model/successModel.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class HomeProvider extends ChangeNotifier {
  /* New Field */
  bool loading = false, loadmore = false;
  SectionListModel sectionListModel = SectionListModel();
  List<section.Result>? sectionList = [];
  int? sectiontotalRows, sectiontotalPage, sectioncurrentPage;
  bool? sectionisMorePage;
  int pageIndex = 0;

  void setInde(int index) {
    pageIndex = index;
    notifyListeners();
  }

  /* PageView Arrow */
  int? cBannerIndex = 0;

  /* New Api */

  Future<void> getSeactionList(int pageNo) async {
    loading = true;
    sectionListModel = await ApiService().sectionList(pageNo);
    if (sectionListModel.status == 200) {
      setSectionPaginationData(
          sectionListModel.totalRows,
          sectionListModel.totalPage,
          sectionListModel.currentPage,
          sectionListModel.morePage);
      if (sectionListModel.result != null &&
          (sectionListModel.result?.length ?? 0) > 0) {
        if (sectionListModel.result != null &&
            (sectionListModel.result?.length ?? 0) > 0) {
          for (var i = 0; i < (sectionListModel.result?.length ?? 0); i++) {
            sectionList?.add(sectionListModel.result?[i] ?? section.Result());
          }
          final Map<int, section.Result> postMap = {};
          sectionList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          sectionList = postMap.values.toList();

          setLoadMore(false);
        }
      }
    }
    loading = false;
    notifyListeners();
  }

  void setSectionPaginationData(int? sectiontotalRows, int? sectiontotalPage,
      int? sectioncurrentPage, bool? sectionisMorePage) {
    this.sectioncurrentPage = sectioncurrentPage;
    this.sectiontotalRows = sectiontotalRows;
    this.sectiontotalPage = sectiontotalPage;
    sectionisMorePage = sectionisMorePage;
    notifyListeners();
  }

  void setLoadMore(bool loadmore) {
    this.loadmore = loadmore;
    notifyListeners();
  }

/* Search Data Started */
  search.CommanModel searchModel = search.CommanModel();
  SuccessModel successModel = SuccessModel();
  List<search.Result>? searchList = [];
  bool searchLoadMore = false;
  int? totalRows, totalPage, currentPage;
  bool? isMorePage;

  String? isSearch = "0";

  void setSearch(String value) {
    isSearch = value;
    Constant.isSearch = value;
    notifyListeners();
  }

  /* Select Layout */
  String layoutType = Constant.courseType;
  int position = 0;

  Future<void> getSearch(String name, type, pageNo) async {
    loading = true;
    searchModel = await ApiService().search(name, type, pageNo);
    if (searchModel.status == 200) {
      setPaginationData(searchModel.totalRows, searchModel.totalPage,
          searchModel.currentPage, searchModel.morePage);
      if (searchModel.result != null && (searchModel.result?.length ?? 0) > 0) {
        if (searchModel.result != null &&
            (searchModel.result?.length ?? 0) > 0) {
          for (var i = 0; i < (searchModel.result?.length ?? 0); i++) {
            searchList?.add(searchModel.result?[i] ?? search.Result());
          }
          final Map<int, search.Result> postMap = {};
          searchList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          searchList = postMap.values.toList();
          setSearchLoadMore(false);
        }
      }
    }
    loading = false;
    notifyListeners();
  }

  /* Product Like Dislike */
  void addRemoveWishlist(int index, type, contentId) {
    if ((searchList?[index].isWishlist ?? 0) == 0) {
      searchList?[index].isWishlist = 1;
    } else {
      searchList?[index].isWishlist = 0;
    }
    notifyListeners();
    addremoveWishList(type, contentId);
  }

  Future<void> addremoveWishList(String type, contentId) async {
    successModel = await ApiService().addRemoveWishlist(type, contentId);
  }

/* Chnage Tab */
  Future<void> selectLayout(String type) async {
    layoutType = type;
    notifyListeners();
  }

  void setPaginationData(
      int? totalRows, int? totalPage, int? currentPage, bool? morePage) {
    this.currentPage = currentPage;
    this.totalRows = totalRows;
    this.totalPage = totalPage;
    isMorePage = morePage;
    notifyListeners();
  }

  void setSearchLoadMore(bool searchLoadMore) {
    this.searchLoadMore = searchLoadMore;
    notifyListeners();
  }

  void clearWishList() {
    searchModel = search.CommanModel();
    successModel = SuccessModel();
    loading = false;
    searchList?.clear();
    searchList = [];
    loading = false;
    searchLoadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
  }

/* Search Data END */
  void clearProvider() {
    loading = false;
    loadmore = false;
    isSearch = "0";
    sectionListModel = SectionListModel();
    sectionList = [];
    sectionList?.clear();
    sectiontotalRows;
    sectiontotalPage;
    sectioncurrentPage;
    sectionisMorePage = false;
    pageIndex = 0; /* Wishlist Fields */
    searchModel = search.CommanModel();
    successModel = SuccessModel();
    loading = false;
    searchList = [];
    loading = false;
    searchLoadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage = false;
    /* Select Layout */
    layoutType = Constant.courseType;
    position = 0;
  }

  void setCurrentBanner(int position) {
    cBannerIndex = position;
    notifyListeners();
  }
}
