import 'package:prakah/model/categorymodel.dart';
import 'package:prakah/model/successModel.dart';
import 'package:prakah/model/pagemodel.dart';
import 'package:prakah/pages/login.dart';
import 'package:flutter/foundation.dart';
import 'package:prakah/model/generalsettingmodel.dart';
import 'package:prakah/model/introscreenmodel.dart';
import 'package:prakah/model/usermodel.dart';
import 'package:prakah/model/profilemodel.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class GeneralProvider extends ChangeNotifier {
  /* App Field */
  SharedPre sharedPre = SharedPre();
  GeneralSettingModel generalSettingModel = GeneralSettingModel();
  IntroScreenModel introScreenModel = IntroScreenModel();
  UserModel loginmodel = UserModel();
  ProfileModel profileModel = ProfileModel();
  PageModel getPageModel = PageModel();
  SuccessModel successModel = SuccessModel();
  CategoryModel categoryModel = CategoryModel();
  bool isCheck = false;

  void setCheck(bool index) {
    isCheck = index;
    notifyListeners();
  }

  Future<void> getCategory(int pageNo) async {
    loading = true;
    categoryModel = await ApiService().category(pageNo);

    loading = false;
    notifyListeners();
  }

  Future<void> getForgetPassword(String email) async {
    loading = true;
    successModel = await ApiService().forgotPasswordResponse(email);

    loading = false;
    notifyListeners();
  }

/* Pages API */
  Future<void> getPages() async {
    loading = true;
    getPageModel = await ApiService().getpage();
    loading = false;
    notifyListeners();
  }

  /* Loading */
  bool loading = false;
  bool isProgressLoading = false;
  /* Other Field */
  int pageindex = 1;

  /* Web Fields */
  bool isNotification = false;
  bool isSearch = false;
  bool isProfile = false;

/* Bottom bar on Tap code */
  int index = 0;
  void setIndex(int val) {
    index = val;
    notifyListeners();
  }

  void onItemTapped(BuildContext context, int value) async {
    if (value == 2 && Constant.userID == null) {
      final result = await Navigator.of(context).push(
        PageRouteBuilder(
          pageBuilder: (context, animation, secondaryAnimation) =>
              const Login(),
          transitionsBuilder: (context, animation, secondaryAnimation, child) {
            const begin = Offset(1.0, 0.0);
            const end = Offset.zero;
            const curve = Curves.ease;
            final tween =
                Tween(begin: begin, end: end).chain(CurveTween(curve: curve));
            return SlideTransition(
                position: animation.drive(tween), child: child);
          },
        ),
      );

      // After login, show Home
      if (result == true) {
        setIndex(0);
      }
    } else {
      setIndex(value);
    }
    notifyListeners();
  }
/* ================================= Api Start ======================================= */

  Future<void> getGeneralsetting(BuildContext context) async {
    loading = true;
    generalSettingModel = await ApiService().genaralSetting();
    if (generalSettingModel.status == 200) {
      if (generalSettingModel.result != null) {
        for (var i = 0; i < (generalSettingModel.result?.length ?? 0); i++) {
          await sharedPre.save(
            generalSettingModel.result?[i].key.toString() ?? "",
            generalSettingModel.result?[i].value.toString() ?? "",
          );
        }
        if (!kIsWeb) {
          await getIntroPages();
        }
        Utils.getCurrencySymbol();
        Constant.userID = await sharedPre.read('userid');
        Constant.userImage = await sharedPre.read('userimage');
        Constant.isBuy = await sharedPre.read('userIsBuy');
        Constant.appDescription = await sharedPre.read("app_description") ?? "";
        printLog("My App Des ${Constant.appDescription}");
        /* Get Ads Init */
        if (context.mounted && !kIsWeb) {
          AdHelper.getAds(context);
          // Utils.initializeOneSignal();
        }
      }
    }
    loading = false;
    notifyListeners();
  }

  Future<void> getIntroPages() async {
    introScreenModel = await ApiService().getOnboardingScreen();
  }

  Future<void> login(
      String type, email, password, deviceType, deviceToken) async {
    setLoading(true);
    loginmodel = await ApiService()
        .login(type, email, password, deviceType, deviceToken);
    setLoading(false);
  }

  Future<void> getSocialLogin(
      String type, email, deviceType, deviceToken) async {
    setLoading(true);
    loginmodel =
        await ApiService().socilaLogin(type, email, deviceType, deviceToken);
    setLoading(false);
  }

  Future<void> getOtpLogin(String type, countryCode, number, countryName,
      deviceType, deviceToken) async {
    setLoading(true);
    loginmodel = await ApiService().otpLogin(
        type, countryCode, number, countryName, deviceType, deviceToken);
    setLoading(false);
  }

  Future<void> getRegister(String fullname, email, number, password,
      countryCode, countryName, deviceType, deviceToken) async {
    loading = true;
    loginmodel = await ApiService().register(fullname, email, number, password,
        countryCode, countryName, deviceType, deviceToken);
    loading = false;
    notifyListeners();
  }

  /* Become tutor api  */

  Future<void> getBecomeTutor(String fullName, email, password, mobileNumber,
      countryCode, countryName, designation) async {
    loading = true;
    successModel = await ApiService().becomeTutor(fullName, email, password,
        mobileNumber, countryCode, countryName, designation);
    loading = false;
    notifyListeners();
  }

/* ================================= Api End ======================================= */

/* ================================= Mobile Methods Start ======================================= */

  void pagechange(int index) {
    pageindex = index;
    notifyListeners();
  }

  void setLoading(bool loading) {
    isProgressLoading = loading;
    notifyListeners();
  }

  /* ================================= Mobile Methods Start ======================================= */

  /* ================================= Web Methods Start ======================================= */

  String? isTab = "1";

  void setHomeTab(String? value) {
    isTab = value;
    notifyListeners();
  }

  void getNotificationSectionShowHide(bool notification) {
    isNotification = notification;
    notifyListeners();
  }

  void getOpenSearchSection(bool search) {
    isSearch = search;
    notifyListeners();
  }

  void getOpenProfileSection(bool profile) {
    isProfile = profile;
    notifyListeners();
  }

  void clearProvider() {
    isCheck = false;
    introScreenModel = IntroScreenModel();
    loading = false;
    index = 0;
    isTab = "1";
  }

  /* ================================= Web APi & Methods End ======================================= */
}
