import 'package:prakah/webservice/apiservice.dart';
import 'package:prakah/model/successModel.dart';
import 'package:flutter/material.dart';

class FeedbackProvider extends ChangeNotifier {
  SuccessModel successModel = SuccessModel();
  bool isReview = false;
  double? rating = 0.0;

  Future<void> getRescheduled(String type, contentId, comment, rating) async {
    setRescheduled(true);
    successModel =
        await ApiService().addContentReview(type, contentId, comment, rating);
    setRescheduled(false);
  }

  void setRescheduled(bool isLoding) {
    isReview = isLoding;
    notifyListeners();
  }

  void setRating(dynamic value) {
    rating = value;
    notifyListeners();
  }

  void clearProvider() {
    successModel = SuccessModel();
    isReview = false;
    rating = 0.0;
  }
}
